/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.formplugin.revision;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmbs.common.enums.ContractStatusEnum;

public class ContractRevisionListPlugin
extends AbstractListPlugin {
    public void beforeShowBill(BeforeShowBillFormEvent e) {
        e.getParameter().setCustomParam("contractId", (Object)this.getPageCache().get("contractId"));
        e.getParameter().setCustomParam("paydirection", (Object)this.getPageCache().get("paydirection"));
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List filterList = e.getQFilters();
        Object contractId = this.getView().getFormShowParameter().getCustomParam("contractId");
        Object payDirection = this.getView().getFormShowParameter().getCustomParam("paydirection");
        this.getPageCache().put("contractId", contractId.toString());
        this.getPageCache().put("paydirection", payDirection.toString());
        filterList.add(new QFilter("contract", "=", contractId));
        e.setOrderBy("versionnumber desc");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        ListSelectedRowCollection selectedRows = ((ListView)this.getView()).getSelectedRows().getBillListSelectedRowCollection();
        if (selectedRows.size() > 1 && !StringUtils.equals((CharSequence)"modify", (CharSequence)operateKey)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"ContractRevisionListPlugin_2", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (StringUtils.equals((CharSequence)"unaudit", (CharSequence)operateKey)) {
            DynamicObject contract = BusinessDataServiceHelper.loadSingle((Object)selectedRows.get(0).getPrimaryKeyValue(), (String)"pmct_contractrevision").getDynamicObject("contract");
            contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_contracttpl");
            DynamicObject contStatus = contract.getDynamicObject("contractstatus");
            List statusNums = Stream.of(ContractStatusEnum.CLOSED.getValue()).collect(Collectors.toList());
            if (statusNums.contains(contStatus.getString("number"))) {
                String tip = String.format(ResManager.loadKDString((String)"\u5408\u540c\u72b6\u6001\u4e3a%s\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002", (String)"ContractRevisionListPlugin_3", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), contStatus.getString("name"));
                this.getView().showTipNotification(tip);
                args.setCancel(true);
            }
        }
    }
}

