/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.formplugin.revision;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.pmgt.pmbs.business.helper.ContractCollectItemHelper;
import kd.pmgt.pmbs.business.helper.ContractPayItemHelper;
import kd.pmgt.pmbs.common.enums.CompletionStatusEnum;
import kd.pmgt.pmbs.common.enums.NodeSettingSourceEnum;
import kd.pmgt.pmbs.common.enums.PayPlanSourceEnum;
import kd.pmgt.pmbs.common.enums.TaskCompleteStateEnum;
import kd.pmgt.pmbs.common.utils.DetailBillUtils;
import kd.pmgt.pmbs.common.utils.NumberHelper;
import kd.pmgt.pmct.business.helper.ContractEditHelper;
import kd.pmgt.pmct.business.service.ProjectBudgetItemService;

public class InContractRevisionBillEditPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public static final String CALCULATE_RATIO = "calculateratio";
    public static final String CALCULATE_AMOUNT = "calculateamount";
    public static final String DELETEPAYPLAN = "deletecollect";
    public static final String VIEWCOMPARE = "viewcompare";
    public static final String PARAMETER_SOURCE_ID = "sourceid";
    public static final String PARAMETER_CONTRACT_ID = "contractid";
    public static final String PARAMETER_CHANGE_TYPE = "changetype";
    public static final String PARAMETER_FORMID = "formId";
    public static final String PARAMETER_CUSTOM_ENTRY_DATA = "entrydata";
    private static final String CTRL_NEWCHANPLAN = "newchanplan";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = args.getOperateKey()) {
            case "newchanplan": {
                DynamicObjectCollection entries = this.getModel().getEntryEntity("incomeplanentry");
                int rowIndex = entries.size() - 1;
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"ctrlstrategy"});
                break;
            }
            case "submit": 
            case "unsubmit": 
            case "unaudit": {
                ContractCollectItemHelper.setBillNameInContractCollectEntry((IDataModel)this.getModel());
            }
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        DynamicObjectCollection payPlanEntrys = this.getModel().getEntryEntity("incomeplanentry");
        Map completeMap = ContractPayItemHelper.getSrcObjCompleteMap((DynamicObject[])((DynamicObject[])payPlanEntrys.toArray((Object[])new DynamicObject[payPlanEntrys.size()])));
        Map mapData = (Map)completeMap.get(NodeSettingSourceEnum.PMBS_TASK.getValue());
        for (DynamicObject payPlanEntry : payPlanEntrys) {
            DynamicObject nodeSetting = payPlanEntry.getDynamicObject("nodesetting");
            if (null == nodeSetting || !QueryServiceHelper.exists((String)NodeSettingSourceEnum.PMBS_TASK.getValue(), (Object)nodeSetting.getPkValue())) continue;
            nodeSetting = BusinessDataServiceHelper.loadSingle((Object)nodeSetting.getPkValue(), (String)NodeSettingSourceEnum.PMBS_TASK.getValue());
            payPlanEntry.set("taskcompletestate", mapData.get(nodeSetting.getLong("id")));
            Long incomeItemId = payPlanEntry.getLong("conplanitemid");
            if (0L == incomeItemId || QueryServiceHelper.exists((String)"pmbs_contractcollectitem", (Object)incomeItemId)) continue;
            payPlanEntry.set("conplanitemid", null);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "calculateratio": {
                this.doCalculateRatio();
                break;
            }
            case "calculateamount": {
                this.doCalculateAmount();
                break;
            }
            case "viewcompare": {
                this.viewCompare();
                break;
            }
            case "deletecollect": {
                this.checkDeletePayPlan(args);
                break;
            }
            case "submit": {
                ContractEditHelper.setCheckParameter((BeforeDoOperationEventArgs)args, (String)"pmct_incontractrevision", (String)"changeincomeplan");
                break;
            }
            case "newchanplan": {
                DynamicObject contract = (DynamicObject)this.getModel().getValue("contract");
                if (contract != null) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5408\u540c\u3002", (String)"InContractRevisionBillEditPlugin_5", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        Object oldValue = changeData.getOldValue();
        int rowIndex = changeData.getRowIndex();
        if (StringUtils.equals((CharSequence)name, (CharSequence)"incomepercent")) {
            BigDecimal latestAmountOfTax = (BigDecimal)this.getModel().getValue("latestamountoftax");
            BigDecimal payAmountOfTax = ((BigDecimal)newValue).divide(BigDecimal.valueOf(100L)).multiply(latestAmountOfTax);
            this.getModel().beginInit();
            this.getModel().setValue("incomeamountoftax", (Object)payAmountOfTax, rowIndex);
            this.getModel().endInit();
            this.getView().updateView("incomeamountoftax", rowIndex);
        } else if (StringUtils.equals((CharSequence)name, (CharSequence)"incomeamountoftax")) {
            BigDecimal latestAmountOfTax = (BigDecimal)this.getModel().getValue("latestamountoftax");
            this.getModel().beginInit();
            BigDecimal payPercent = BigDecimal.ZERO;
            if (latestAmountOfTax.compareTo(BigDecimal.ZERO) != 0) {
                payPercent = ((BigDecimal)newValue).divide(latestAmountOfTax, 10, 4).multiply(BigDecimal.valueOf(100L));
            }
            this.getModel().setValue("incomepercent", (Object)payPercent, rowIndex);
            this.getModel().endInit();
            this.getView().updateView("incomepercent", rowIndex);
        } else if (StringUtils.equals((CharSequence)name, (CharSequence)"listingbudgetitem")) {
            this.listingBudgetItemChanged((DynamicObject)oldValue, (DynamicObject)newValue, rowIndex);
        } else if (StringUtils.equals((CharSequence)name, (CharSequence)"parentlisting")) {
            this.parentListingChanged((DynamicObject)newValue, rowIndex);
        } else if (StringUtils.equals((CharSequence)name, (CharSequence)"superlistingid")) {
            this.superListingIdChanged(newValue, rowIndex);
        } else if (StringUtils.equals((CharSequence)name, (CharSequence)"nodesetting")) {
            this.nodeSettingChange(rowIndex, newValue, oldValue);
        } else if (StringUtils.equals((CharSequence)name, (CharSequence)"ctrlstrategy")) {
            this.ctrlStrategyChange(rowIndex, newValue, oldValue);
        }
    }

    protected void nodeSettingChange(int rowIndex, Object newValue, Object oldValue) {
        if (newValue == oldValue) {
            return;
        }
        DynamicObject rowEntry = this.getModel().getEntryRowEntity("incomeplanentry", rowIndex);
        Long sourceId = rowEntry.getLong("conplanitemid");
        DynamicObject incomeItem = sourceId == 0L ? null : BusinessDataServiceHelper.loadSingle((Object)sourceId, (String)"pmbs_contractcollectitem");
        String incomeItemName = null == incomeItem ? null : incomeItem.getString("name");
        Long incomeItemNodeId = null;
        if (null != incomeItem && null != incomeItem.getDynamicObject("nodesetting")) {
            incomeItemNodeId = incomeItem.getDynamicObject("nodesetting").getLong("id");
        }
        if (sourceId != 0L && null == this.getPageCache().get("rowIndex") && null != oldValue && null != incomeItemNodeId && ((DynamicObject)oldValue).getLong("id") == incomeItemNodeId.longValue()) {
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u6761\u76ee\u540d\u79f0\uff1a%s\u7684\u6536\u6b3e\u8282\u70b9\u8bbe\u7f6e\u5df2\u4fee\u6539\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"InContractRevisionBillEditPlugin_1", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), incomeItemName), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("nodesetting", (IFormPlugin)this));
            String nodeSettingOldId = oldValue != null ? ((DynamicObject)oldValue).getString("id") : null;
            this.getPageCache().put("oldValue", nodeSettingOldId);
            this.getPageCache().put("rowIndex", String.valueOf(rowIndex));
        } else {
            this.getPageCache().remove("oldValue");
            this.getPageCache().remove("rowIndex");
        }
        if (newValue == null) {
            this.getModel().setValue("ctrlstrategy", null, rowIndex);
            this.getModel().setValue("taskcompletestate", null, rowIndex);
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"ctrlstrategy"});
            return;
        }
        this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"ctrlstrategy"});
        DynamicObject nodeSetting = (DynamicObject)newValue;
        if (null == nodeSetting.getDynamicObjectType().getProperty("completionstatus") && QueryServiceHelper.exists((String)NodeSettingSourceEnum.PMBS_TASK.getValue(), (Object)nodeSetting.getPkValue())) {
            nodeSetting = BusinessDataServiceHelper.loadSingle((Object)nodeSetting.getPkValue(), (String)NodeSettingSourceEnum.PMBS_TASK.getValue());
        }
        String completionStatus = nodeSetting.getString("completionstatus");
        String status = CompletionStatusEnum.OVERDUECOMPLETE.getValue().equals(completionStatus) || CompletionStatusEnum.ONTIMECOMPLETE.getValue().equals(completionStatus) ? TaskCompleteStateEnum.COMPLETE.getValue() : TaskCompleteStateEnum.INCOMPLETE.getValue();
        this.getModel().setValue("taskcompletestate", (Object)status, rowIndex);
    }

    private void ctrlStrategyChange(int rowIndex, Object newValue, Object oldValue) {
        String incomeItemStrategy;
        if (newValue == oldValue) {
            return;
        }
        DynamicObject rowEntry = this.getModel().getEntryRowEntity("incomeplanentry", rowIndex);
        Long sourceId = rowEntry.getLong("conplanitemid");
        DynamicObject incomeItem = sourceId == 0L ? null : BusinessDataServiceHelper.loadSingle((Object)sourceId, (String)"pmbs_contractcollectitem");
        String incomeItemName = null == incomeItem ? null : incomeItem.getString("name");
        String string = incomeItemStrategy = null == incomeItem ? null : incomeItem.getString("ctrlstrategy");
        if (sourceId != 0L && null == this.getPageCache().get("rowIndex") && null != oldValue && incomeItemStrategy != null && incomeItemStrategy.equals(oldValue.toString())) {
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u6761\u76ee\u540d\u79f0\uff1a%s\u7684\u63a7\u5236\u7b56\u7565\u5df2\u4fee\u6539\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"InContractRevisionBillEditPlugin_2", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), incomeItemName), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("ctrlstrategy", (IFormPlugin)this));
            String ctrlStrategyOldValue = oldValue.toString();
            this.getPageCache().put("oldValue", ctrlStrategyOldValue);
            this.getPageCache().put("rowIndex", String.valueOf(rowIndex));
        } else {
            this.getPageCache().remove("oldValue");
            this.getPageCache().remove("rowIndex");
        }
        if (newValue == null) {
            this.getModel().setValue("taskcompletestate", null, rowIndex);
        }
    }

    protected void doCalculateRatio() {
        BigDecimal latestAmountOfTax;
        DynamicObjectCollection changeIncomePlanEntry = this.getModel().getEntryEntity("incomeplanentry");
        if (!changeIncomePlanEntry.isEmpty() && (latestAmountOfTax = (BigDecimal)this.getModel().getValue("latestamountoftax")).compareTo(BigDecimal.ZERO) != 0) {
            for (DynamicObject changeIncomePlanEntryObj : changeIncomePlanEntry) {
                BigDecimal incomeOfTaxAmount = changeIncomePlanEntryObj.getBigDecimal("incomeamountoftax");
                BigDecimal ratio = incomeOfTaxAmount.divide(latestAmountOfTax, 10, 4).multiply(BigDecimal.valueOf(100L));
                changeIncomePlanEntryObj.set("incomepercent", (Object)ratio);
                int index = changeIncomePlanEntry.indexOf((Object)changeIncomePlanEntryObj);
                this.getView().updateView("incomepercent", index);
            }
        }
    }

    protected void doCalculateAmount() {
        DynamicObjectCollection changeIncomePlanEntry = this.getModel().getEntryEntity("incomeplanentry");
        if (!changeIncomePlanEntry.isEmpty()) {
            BigDecimal latestAmountOfTax = (BigDecimal)this.getModel().getValue("latestamountoftax");
            for (DynamicObject changeIncomePlanEntryObj : changeIncomePlanEntry) {
                BigDecimal incomePercent = changeIncomePlanEntryObj.getBigDecimal("incomepercent");
                BigDecimal incomeOfTaxAmount = latestAmountOfTax.multiply(incomePercent.divide(BigDecimal.valueOf(100L)));
                changeIncomePlanEntryObj.set("incomeamountoftax", (Object)incomeOfTaxAmount);
                int index = changeIncomePlanEntry.indexOf((Object)changeIncomePlanEntryObj);
                this.getView().updateView("incomeamountoftax", index);
            }
        }
    }

    private void viewCompare() {
        if (this.getModel().getValue("contract") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5408\u540c\u3002", (String)"InContractRevisionBillEditPlugin_5", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put(PARAMETER_SOURCE_ID, this.getModel().getDataEntity().getPkValue());
        param.put(PARAMETER_CONTRACT_ID, ((DynamicObject)this.getModel().getValue("contract")).getPkValue());
        param.put(PARAMETER_CHANGE_TYPE, PayPlanSourceEnum.MODIFY.getValue());
        param.put(PARAMETER_FORMID, "pmct_incontractrevision");
        DynamicObjectType dt = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_incontractrevision")).getDynamicObjectCollection("incomeplanentry").getDynamicObjectType();
        DynamicObjectCollection changeIncomePlanEntry = this.getModel().getEntryEntity("incomeplanentry");
        param.put(PARAMETER_CUSTOM_ENTRY_DATA, DynamicObjectSerializeUtil.serialize((Object[])changeIncomePlanEntry.toArray(), (DynamicObjectType)dt));
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId("pmct_incomeplanchange");
        showParameter.setCustomParams(param);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void checkDeletePayPlan(BeforeDoOperationEventArgs args) {
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("incomeplanentry");
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("incomeplanentry", entryCurrentRowIndex);
        String conPlanItemId = entryRowEntity.getString("conplanitemid");
        if (StringUtils.isNotBlank((CharSequence)conPlanItemId)) {
            DynamicObject conPlanItemIdObj = BusinessDataServiceHelper.loadSingle((Object)conPlanItemId, (String)"pmbs_contractcollectitem");
            BigDecimal collectedComAmt = conPlanItemIdObj.getBigDecimal("collectedcomamt");
            if (collectedComAmt.compareTo(BigDecimal.ZERO) > 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6536\u6b3e\u8ba1\u5212\u5df2\u53d1\u751f\u6536\u6b3e\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"InContractRevisionBillEditPlugin_0", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            String payItemName = conPlanItemIdObj.getString("name");
            Map targetBillIds = BFTrackerServiceHelper.findTargetBills((String)"pmbs_contractcolitembook", (Long[])new Long[]{conPlanItemIdObj.getLong("id")});
            if (!targetBillIds.isEmpty()) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5df2\u88ab\u5f15\u7528\u6216\u4e0b\u63a8\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"InContractRevisionBillEditPlugin_6", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]), payItemName));
                args.setCancel(true);
                return;
            }
            BigDecimal appliedComAmt = conPlanItemIdObj.getBigDecimal("appliedcomamt");
            if (!NumberHelper.isNullZero((BigDecimal)appliedComAmt)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6536\u6b3e\u8ba1\u5212\u5df2\u53d1\u751f\u8bf7\u6b3e\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"InContractRevisionBillEditPlugin_4", (String)"pmgt-pmct-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    @Deprecated
    protected void updateBudgetViewByProject() {
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit budgetItem = (BasedataEdit)this.getView().getControl("budgetitem");
        budgetItem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit listingBudgetItem = (BasedataEdit)this.getView().getControl("listingbudgetitem");
        listingBudgetItem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit nodeSettingEdit = (BasedataEdit)this.getControl("nodesetting");
        nodeSettingEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        nodeSettingEdit.addBeforeF7ViewDetailListener(evt -> {
            DynamicObject nodeSetting;
            evt.setCancel(true);
            Object pkId = evt.getPkId();
            if (null != pkId && QueryServiceHelper.exists((String)NodeSettingSourceEnum.PMBS_TASK.getValue(), (Object)pkId) && !(nodeSetting = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)NodeSettingSourceEnum.PMBS_TASK.getValue())).getBoolean("islatest")) {
                DynamicObject sourceTask = nodeSetting.getDynamicObject("sourcetask");
                nodeSetting = BusinessDataServiceHelper.loadSingle((String)NodeSettingSourceEnum.PMBS_TASK.getValue(), (String)String.join((CharSequence)",", new CharSequence[0]), (QFilter[])new QFilter[]{new QFilter("sourcetask", "=", sourceTask.getPkValue()), new QFilter("islatest", "=", (Object)true)});
                pkId = nodeSetting.getPkValue();
            }
            this.getView().showForm((FormShowParameter)DetailBillUtils.viewDetail((String)"pmpt_reporttaskview", (String)"id", (Object)pkId));
        });
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        String name;
        switch (name = arg0.getProperty().getName()) {
            case "budgetitem": 
            case "listingbudgetitem": {
                this.beforeBudgetItemF7Select(arg0);
                break;
            }
            case "nodesetting": {
                ListShowParameter param = (ListShowParameter)arg0.getFormShowParameter();
                this.beforeSelectNodeSetting(param);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String callBackId = evt.getCallBackId();
        int result = evt.getResult().getValue();
        switch (callBackId) {
            case "nodesetting": {
                if (result != MessageBoxResult.Cancel.getValue()) break;
                Long oldValue = null != this.getPageCache().get("oldValue") ? Long.valueOf(Long.parseLong(this.getPageCache().get("oldValue"))) : null;
                int rowIndex = Integer.parseInt(this.getPageCache().get("rowIndex"));
                this.getModel().setValue("nodesetting", (Object)oldValue, rowIndex);
                break;
            }
            case "ctrlstrategy": {
                if (result != MessageBoxResult.Cancel.getValue()) break;
                String oldValue = this.getPageCache().get("oldValue");
                int rowIndex = Integer.parseInt(this.getPageCache().get("rowIndex"));
                this.getModel().setValue("ctrlstrategy", (Object)oldValue, rowIndex);
            }
        }
    }

    protected void beforeSelectNodeSetting(ListShowParameter param) {
        DynamicObject project = this.getModel().getDataEntity().getDynamicObject("project");
        param.setFormId("bos_listf7");
        QFilter qFilter = new QFilter("project", "=", null != project ? project.getPkValue() : null);
        param.getListFilterParameter().getQFilters().add(qFilter);
        QFilter txTypeFilter = new QFilter("number", "=", (Object)"003");
        DynamicObject txType = BusinessDataServiceHelper.loadSingle((String)"pmpt_transactiontype", (String)"id", (QFilter[])new QFilter[]{txTypeFilter});
        qFilter = new QFilter(String.join((CharSequence)".", "transactiontype", "fbasedataid_id"), "in", txType.getPkValue());
        param.getListFilterParameter().getQFilters().add(qFilter);
        qFilter = new QFilter("islatest", "=", (Object)true);
        param.getListFilterParameter().getQFilters().add(qFilter);
    }

    protected void beforeBudgetItemF7Select(BeforeF7SelectEvent arg) {
        DynamicObject contract = (DynamicObject)this.getModel().getValue("contract");
        QFilter idFilter = new ProjectBudgetItemService().getBudgetItemFilter(contract);
        if (idFilter == null) {
            return;
        }
        ListShowParameter parameter = (ListShowParameter)arg.getFormShowParameter();
        parameter.getListFilterParameter().getQFilters().add(idFilter);
    }

    protected void listingBudgetItemChanged(DynamicObject oldValue, DynamicObject newValue, int rowIndex) {
        if (StringUtils.equals((CharSequence)"3", (CharSequence)((String)this.getModel().getValue("subchangetype", rowIndex))) && oldValue != null && newValue != null) {
            long parentId = (Long)this.getModel().getValue("newlistingid", rowIndex);
            int rowCount = this.getModel().getEntryRowCount("entryentity");
            for (int i = 0; i < rowCount; ++i) {
                long superId = (Long)this.getModel().getValue("superlistingid", i);
                DynamicObject budget = (DynamicObject)this.getModel().getValue("listingbudgetitem", i);
                if (parentId != superId || budget == null || !budget.getPkValue().equals(oldValue.getPkValue())) continue;
                this.getModel().setValue("listingbudgetitem", newValue.getPkValue(), i);
            }
        }
    }

    protected void parentListingChanged(DynamicObject newValue, int rowIndex) {
        DynamicObject budgetItem;
        if (newValue != null && (budgetItem = newValue.getDynamicObject("listingbudgetitem")) != null) {
            this.getModel().setValue("listingbudgetitem", budgetItem.getPkValue(), rowIndex);
        }
    }

    protected void superListingIdChanged(Object newValue, int rowIndex) {
        if (newValue != null && (Long)newValue != 0L) {
            int rowCount = this.getModel().getEntryRowCount("entryentity");
            for (int i = 0; i < rowCount; ++i) {
                if (!StringUtils.equals((CharSequence)"3", (CharSequence)((String)this.getModel().getValue("subchangetype", i))) || ((Long)newValue).longValue() != ((Long)this.getModel().getValue("newlistingid", i)).longValue()) continue;
                DynamicObject budget = (DynamicObject)this.getModel().getValue("listingbudgetitem", i);
                if (budget == null) break;
                this.getModel().setValue("listingbudgetitem", budget.getPkValue(), rowIndex);
                break;
            }
        }
    }
}

