/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.report.form;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.FileNameUtils;
import kd.pmgt.pmbs.business.helper.ContractCollectItemHelper;
import kd.pmgt.pmbs.business.helper.ContractPayItemHelper;
import kd.pmgt.pmbs.business.helper.project.ProjectPermFilterHelper;
import kd.pmgt.pmbs.business.helper.project.ProjectTeamPermissionHelper;
import kd.pmgt.pmbs.common.enums.CtrlStrategyEnum;
import kd.pmgt.pmbs.common.enums.NodeSettingSourceEnum;
import kd.pmgt.pmbs.common.enums.PayDirectionEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.utils.DetailBillUtils;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.RegionUtil;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.jetbrains.annotations.NotNull;

public class InContractReportFormPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener,
RowClickEventListener {
    private static final Log logger = LogFactory.getLog(InContractReportFormPlugin.class);
    private String[] incomePlanTitle = new String[]{ResManager.loadKDString((String)"\u5408\u540c\u7f16\u53f7", (String)"InContractReportFormPlugin_2", (String)"pmgt-pmct-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5408\u540c\u540d\u79f0", (String)"InContractReportFormPlugin_3", (String)"pmgt-pmct-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6536\u6b3e\u7c7b\u578b", (String)"InContractReportFormPlugin_4", (String)"pmgt-pmct-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6536\u6b3e\u9891\u6b21", (String)"InContractReportFormPlugin_5", (String)"pmgt-pmct-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6536\u6b3e\u65b9\u5f0f", (String)"InContractReportFormPlugin_6", (String)"pmgt-pmct-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6536\u6b3e\u6bd4\u4f8b\uff08%\uff09", (String)"InContractReportFormPlugin_7", (String)"pmgt-pmct-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u542b\u7a0e\u91d1\u989d", (String)"InContractReportFormPlugin_8", (String)"pmgt-pmct-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8ba1\u5212\u6536\u6b3e\u65e5\u671f", (String)"InContractReportFormPlugin_9", (String)"pmgt-pmct-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6536\u6b3e\u8282\u70b9\u8bbe\u7f6e", (String)"InContractReportFormPlugin_10", (String)"pmgt-pmct-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u63a7\u5236\u7b56\u7565", (String)"InContractReportFormPlugin_11", (String)"pmgt-pmct-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4efb\u52a1\u5b8c\u6210\u72b6\u6001", (String)"InContractReportFormPlugin_12", (String)"pmgt-pmct-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6761\u76ee\u540d\u79f0", (String)"InContractReportFormPlugin_13", (String)"pmgt-pmct-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5df2\u8bf7\u6b3e\u91d1\u989d", (String)"InContractReportFormPlugin_14", (String)"pmgt-pmct-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5df2\u8bf7\u6b3e\u91d1\u989d\uff08\u542b\u5728\u9014\uff09", (String)"InContractReportFormPlugin_15", (String)"pmgt-pmct-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u53ef\u8bf7\u6b3e\u91d1\u989d", (String)"InContractReportFormPlugin_16", (String)"pmgt-pmct-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5df2\u6536\u6b3e\u91d1\u989d", (String)"InContractReportFormPlugin_17", (String)"pmgt-pmct-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5df2\u6536\u6b3e\u91d1\u989d(\u542b\u5728\u9014)", (String)"InContractReportFormPlugin_18", (String)"pmgt-pmct-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u672a\u6536\u6b3e\u91d1\u989d", (String)"InContractReportFormPlugin_19", (String)"pmgt-pmct-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8bf4\u660e", (String)"InContractReportFormPlugin_20", (String)"pmgt-pmct-report", (Object[])new Object[0])};

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        super.processRowData(gridPK, rowData, queryParam);
        for (DynamicObject dyn : rowData) {
            BigDecimal totalRevisionOfTaxAmount = dyn.getBigDecimal("totalrevisionoftaxamount");
            BigDecimal totalClaimOfTaxAmount = dyn.getBigDecimal("totalclaimoftaxamount");
            BigDecimal totalAddTaxAmount = dyn.getBigDecimal("totaladditionoftaxamt");
            dyn.set("allchangeamount", (Object)totalRevisionOfTaxAmount.add(totalClaimOfTaxAmount).add(totalAddTaxAmount));
            BigDecimal totalOfTaxAmount = dyn.getBigDecimal("totaloftaxamount");
            BigDecimal totalSettleOfTaxAmount = dyn.getBigDecimal("totalsettleoftaxamount");
            dyn.set("totalunsettleamount", (Object)totalOfTaxAmount.subtract(totalSettleOfTaxAmount));
            BigDecimal totalRealOfTaxAmount = dyn.getBigDecimal("totalrealoftaxamount");
            dyn.set("totalunrealoftaxamount", (Object)totalSettleOfTaxAmount.subtract(totalRealOfTaxAmount));
            BigDecimal totalInvoiceOftaxAmount = dyn.getBigDecimal("totalinvoiceoftaxamount");
            dyn.set("uninvoiceamt", (Object)totalSettleOfTaxAmount.subtract(totalInvoiceOftaxAmount));
            dyn.set("sumuninvoiceamt", (Object)totalOfTaxAmount.subtract(totalInvoiceOftaxAmount));
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportList list = (ReportList)this.getControl("reportlistap");
        list.addHyperClickListener((HyperLinkClickListener)this);
        list.addRowClickListener((RowClickEventListener)this);
        EntryGrid entryentity = (EntryGrid)this.getControl("entryentity");
        entryentity.addHyperClickListener((HyperLinkClickListener)this);
        BasedataEdit nodeSetting = (BasedataEdit)this.getControl("nodesetting");
        nodeSetting.addBeforeF7ViewDetailListener(beforeF7ViewDetailEvent -> {
            beforeF7ViewDetailEvent.setCancel(true);
            int rowKey = beforeF7ViewDetailEvent.getRowKey();
            DynamicObject collectItemEntryRow = this.getModel().getEntryRowEntity("collectitementry", rowKey);
            String nodeSettingSource = collectItemEntryRow.getString("nodesettingsource");
            if (NodeSettingSourceEnum.PMBS_TASK.getValue().equals(nodeSettingSource)) {
                DynamicObject task = BusinessDataServiceHelper.loadSingle((String)NodeSettingSourceEnum.PMBS_TASK.getValue(), (String)"islatest,sourcetask", (QFilter[])new QFilter[]{new QFilter("id", "in", beforeF7ViewDetailEvent.getPkId())});
                if ((task = ContractCollectItemHelper.getLatestTask((DynamicObject)task)) != null) {
                    this.getView().showForm((FormShowParameter)DetailBillUtils.viewDetail((String)"pmpt_reporttaskview", (Object)task.getPkValue()));
                }
            } else if ("pmbs_wbs".equals(nodeSettingSource)) {
                this.getView().showForm((FormShowParameter)DetailBillUtils.viewDetail((String)"pmbs_wbs", (Object)beforeF7ViewDetailEvent.getPkId()));
            } else {
                this.getView().showForm((FormShowParameter)DetailBillUtils.viewDetail((String)"pmbs_workexecution", (Object)beforeF7ViewDetailEvent.getPkId()));
            }
        });
    }

    public void entryRowClick(RowClickEvent evt) {
        int clickRowIndex = evt.getRow();
        if (clickRowIndex < 0) {
            this.getModel().deleteEntryData("entryentity");
            this.getModel().deleteEntryData("collectitementry");
            return;
        }
        this.getModel().deleteEntryData("entryentity");
        this.getModel().deleteEntryData("collectitementry");
        ReportList list = (ReportList)this.getControl("reportlistap");
        DynamicObject contract = (DynamicObject)list.getReportModel().getValue(clickRowIndex, "contract");
        this.loadContractEntry(contract);
        this.loadCollectItemEntry(contract);
    }

    private void loadCollectItemEntry(DynamicObject contract) {
        QFilter contractFilter = new QFilter("contract", "=", contract.getPkValue());
        QFilter statusFilter = new QFilter("status", "=", (Object)StatusEnum.CHECKED.getValue());
        DynamicObject[] collectItems = BusinessDataServiceHelper.load((String)"pmbs_contractcollectitem", (String)"currency,collecttype,collectfeq,collectway,collectpercent,collectamount,plancollecttime,collectedamt,collectedcomamt,uncollectedamt,sourcebilltype,remarks,nodesetting,nodesettingsource,taskcompletestatus,name,appliedamt,appliedcomamt,appliableamt", (QFilter[])new QFilter[]{contractFilter, statusFilter});
        DynamicObjectCollection collectItemEntryEntity = this.getModel().getEntryEntity("collectitementry");
        DynamicObjectType collectItemEntryDT = collectItemEntryEntity.getDynamicObjectType();
        Map srcObjCompleteMap = ContractCollectItemHelper.getSrcObjCompleteMap((DynamicObject[])collectItems);
        for (DynamicObject collectItem : collectItems) {
            DynamicObject collectItemEntry = new DynamicObject(collectItemEntryDT);
            collectItemEntry.set("collectitem", (Object)collectItem);
            collectItemEntry.set("itemcurrency", (Object)collectItem.getDynamicObject("currency"));
            collectItemEntry.set("collecttype", (Object)collectItem.getString("collecttype"));
            collectItemEntry.set("collectfeq", (Object)collectItem.getString("collectfeq"));
            collectItemEntry.set("collectpercent", (Object)collectItem.getString("collectpercent"));
            collectItemEntry.set("collectamount", collectItem.get("collectamount"));
            DynamicObject nodeSetting = collectItem.getDynamicObject("nodesetting");
            collectItemEntry.set("nodesetting", (Object)nodeSetting);
            String nodeSettingSource = collectItem.getString("nodesettingsource");
            collectItemEntry.set("nodesettingsource", (Object)nodeSettingSource);
            if (nodeSetting != null) {
                Map nodeObjCompMap = (Map)srcObjCompleteMap.get(nodeSettingSource);
                collectItemEntry.set("taskcompletestatus", nodeObjCompMap != null ? nodeObjCompMap.get(nodeSetting.getPkValue()) : "");
            }
            collectItemEntry.set("appliedamt", collectItem.get("appliedamt"));
            collectItemEntry.set("appliedcomamt", collectItem.get("appliedcomamt"));
            collectItemEntry.set("appliableamt", collectItem.get("appliableamt"));
            collectItemEntry.set("collectedamt", collectItem.get("collectedamt"));
            collectItemEntry.set("collectedcomamt", collectItem.get("collectedcomamt"));
            collectItemEntry.set("uncollectedamt", collectItem.get("uncollectedamt"));
            collectItemEntry.set("sourcebilltype", collectItem.get("sourcebilltype"));
            collectItemEntryEntity.add((Object)collectItemEntry);
        }
        this.getModel().updateEntryCache(collectItemEntryEntity);
        this.getView().updateView("collectitementry");
    }

    private void loadContractEntry(DynamicObject contract) {
        QFilter filter = new QFilter("contract", "=", contract.getPkValue());
        if (null != contract.getDynamicObject("contract")) {
            filter.or(new QFilter("id", "=", contract.getDynamicObject("contract").getPkValue()));
        }
        String selector = Stream.of("project", "billstatus", "createorg", "currency", "contracttype", "originaloftaxamount", "totaloftaxamount", "totalsettleoftaxamount", "totalapplyoftaxamount", "totalrealoftaxamount", "totalinvoiceoftaxamount", "totalclaimoftaxamount", "totalrevisionoftaxamount", "totaladditionoftaxamt", "paydirection").collect(Collectors.joining(","));
        DynamicObject[] contracts = BusinessDataServiceHelper.load((String)"pmct_contractf7", (String)selector, (QFilter[])new QFilter[]{filter});
        DynamicObjectCollection outContractCol = this.getModel().getEntryEntity("entryentity");
        DynamicObjectType outContEntryDT = outContractCol.getDynamicObjectType();
        for (DynamicObject cont : contracts) {
            DynamicObject outContEntry = new DynamicObject(outContEntryDT);
            outContEntry.set("refpaydirection", (Object)(PayDirectionEnum.IN.getValue().equals(cont.getString("paydirection")) ? ResManager.loadKDString((String)"\u6536\u5165\u5408\u540c", (String)"InContractReportFormPlugin_0", (String)"pmgt-pmct-report", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u652f\u51fa\u5408\u540c", (String)"InContractReportFormPlugin_1", (String)"pmgt-pmct-report", (Object[])new Object[0])));
            outContEntry.set("refcontract", (Object)cont);
            BigDecimal totalAmt = cont.getBigDecimal("totaloftaxamount");
            BigDecimal totalClaimAmt = cont.getBigDecimal("totalclaimoftaxamount");
            BigDecimal totalRevisionAmt = cont.getBigDecimal("totalrevisionoftaxamount");
            BigDecimal totalAddAmt = cont.getBigDecimal("totaladditionoftaxamt");
            BigDecimal totalSettleAmt = cont.getBigDecimal("totalsettleoftaxamount");
            BigDecimal totalRealAmt = cont.getBigDecimal("totalrealoftaxamount");
            BigDecimal totalInvoiceAmt = cont.getBigDecimal("totalinvoiceoftaxamount");
            outContEntry.set("refcurrency", (Object)cont.getDynamicObject("currency"));
            outContEntry.set("refproject", (Object)cont.getDynamicObject("project"));
            outContEntry.set("ref_originaloftaxamount", cont.get("originaloftaxamount"));
            outContEntry.set("ref_changeamount", (Object)totalClaimAmt.add(totalRevisionAmt).add(totalAddAmt));
            outContEntry.set("ref_totaloftaxamount", (Object)totalAmt);
            outContEntry.set("reftotalsettleoftaxamount", (Object)totalSettleAmt);
            outContEntry.set("ref_totalunsettleamount", (Object)totalAmt.subtract(totalSettleAmt));
            outContEntry.set("ref_totalapplyoftaxamount", (Object)cont.getBigDecimal("totalapplyoftaxamount"));
            outContEntry.set("ref_totalrealoftaxamount", (Object)totalRealAmt);
            outContEntry.set("reftotalunrealoftaxamount", (Object)totalSettleAmt.subtract(totalRealAmt));
            outContEntry.set("ref_totalinvoiceoftaxamt", (Object)totalInvoiceAmt);
            outContEntry.set("ref_uninvoiceamt", (Object)totalSettleAmt.subtract(totalInvoiceAmt));
            outContractCol.add((Object)outContEntry);
        }
        this.getModel().updateEntryCache(outContractCol);
        this.getView().updateView("entryentity");
    }

    public void hyperLinkClick(HyperLinkClickEvent paramHyperLinkClickEvent) {
        String fieldName = paramHyperLinkClickEvent.getFieldName();
        int rowIndex = paramHyperLinkClickEvent.getRowIndex();
        ReportList list = (ReportList)this.getControl("reportlistap");
        if (fieldName.equals("contract")) {
            long projectId;
            Map permMap;
            DynamicObject contract = (DynamicObject)list.getReportModel().getValue(rowIndex, fieldName);
            DynamicObject project = contract.getDynamicObject("project");
            boolean teamPermSysParam = ProjectPermFilterHelper.getTeamPermSysParam();
            if (project != null && teamPermSysParam && (permMap = ProjectTeamPermissionHelper.judgeIsHasProOpPerm((Long)(projectId = Long.parseLong(project.getPkValue().toString())), (String)"pmct_incontractrpt", (String)"reportquery", (Long)RequestContext.get().getCurrUserId())).containsKey("noHasPerm")) {
                this.getView().showTipNotification((String)permMap.get("noHasPerm"));
                return;
            }
            long id = contract.getLong("id");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("formId", "pmct_incontract");
            map.put("pkId", String.valueOf(id));
            FormShowParameter parameter = FormShowParameter.createFormShowParameter(map);
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm(parameter);
        } else if (fieldName.equals("refcontract")) {
            DynamicObject contract = (DynamicObject)this.getModel().getValue(fieldName, rowIndex);
            Long id = contract.getLong("id");
            HashMap<String, String> map = new HashMap<String, String>(16);
            map.put("formId", ResManager.loadKDString((String)"\u6536\u5165\u5408\u540c", (String)"InContractReportFormPlugin_0", (String)"pmgt-pmct-report", (Object[])new Object[0]).equals(this.getModel().getValue("refpaydirection")) ? "pmct_incontract" : "pmct_outcontract");
            map.put("pkId", id.toString());
            FormShowParameter parameter = FormShowParameter.createFormShowParameter(map);
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(parameter);
        } else if (fieldName.equals("project") || fieldName.equals("refproject")) {
            Map permMap;
            DynamicObject project = null;
            project = StringUtils.equals((CharSequence)"project", (CharSequence)fieldName) ? (DynamicObject)list.getReportModel().getValue(rowIndex, fieldName) : (DynamicObject)this.getModel().getValue(fieldName, rowIndex);
            if (project == null) {
                return;
            }
            Long projectId = project.getLong("id");
            boolean teamPermSysParam = ProjectPermFilterHelper.getTeamPermSysParam();
            if (teamPermSysParam && (permMap = ProjectTeamPermissionHelper.judgeIsHasProOpPerm((Long)projectId, (String)"pmct_incontractrpt", (String)"reportquery", (Long)RequestContext.get().getCurrUserId())).containsKey("noHasPerm")) {
                this.getView().showTipNotification((String)permMap.get("noHasPerm"));
                return;
            }
            DynamicObject proApproval = QueryServiceHelper.queryOne((String)"pmas_pro_approval", (String)"id,pro", (QFilter[])new QFilter[]{new QFilter("pro", "=", (Object)projectId)});
            if (proApproval != null) {
                HashMap<String, Object> map = new HashMap<String, Object>(2);
                HashMap<String, String> custormMap = new HashMap<String, String>(1);
                custormMap.put("proAppId", proApproval.getString("id"));
                map.put("formId", "pmba_projectkanban");
                map.put("customParams", custormMap);
                FormShowParameter parameter = FormShowParameter.createFormShowParameter(map);
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm(parameter);
            } else {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("formId", "bd_project");
                map.put("pkId", projectId.toString());
                FormShowParameter parameter = FormShowParameter.createFormShowParameter(map);
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                parameter.setStatus(OperationStatus.VIEW);
                this.getView().showForm(parameter);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String key = operate.getOperateKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"refresh")) {
            this.getModel().deleteEntryData("entryentity");
            this.getModel().deleteEntryData("collectitementry");
        } else if (StringUtils.equals((CharSequence)key, (CharSequence)"exportdata")) {
            this.exportExcel();
        }
    }

    private void exportExcel() {
        XSSFWorkbook xssfWorkbook = new XSSFWorkbook();
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        int rowCount = reportList.getReportModel().getRowCount();
        if (rowCount > 0) {
            XSSFSheet contractReportSheet = xssfWorkbook.createSheet(ResManager.loadKDString((String)"\u6536\u5165\u5408\u540c\u4e00\u89c8\u8868", (String)"InContractReportFormPlugin_21", (String)"pmgt-pmct-report", (Object[])new Object[0]));
            XSSFSheet collectPlanSheet = xssfWorkbook.createSheet(ResManager.loadKDString((String)"\u6536\u6b3e\u6761\u76ee", (String)"InContractReportFormPlugin_22", (String)"pmgt-pmct-report", (Object[])new Object[0]));
            XSSFSheet refContSheet = xssfWorkbook.createSheet(ResManager.loadKDString((String)"\u5173\u8054\u5408\u540c", (String)"InContractReportFormPlugin_23", (String)"pmgt-pmct-report", (Object[])new Object[0]));
            XSSFFont font = xssfWorkbook.createFont();
            font.setFontHeightInPoints((short)16);
            font.setBold(Boolean.TRUE.booleanValue());
            XSSFCellStyle parentStyle = xssfWorkbook.createCellStyle();
            parentStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            parentStyle.setAlignment(HorizontalAlignment.CENTER);
            parentStyle.setFont((Font)font);
            String[] contReportNumbers = this.initContractReportSheet(reportList, contractReportSheet, parentStyle);
            EntryGrid collectItemEntry = (EntryGrid)this.getControl("collectitementry");
            String[] collectPlanNumbers = this.initCollectPlanSheet(collectPlanSheet, parentStyle, collectItemEntry);
            EntryGrid contractEntry = (EntryGrid)this.getControl("entryentity");
            String[] refContNumbers = this.initRelationContractSheet(refContSheet, parentStyle, contractEntry);
            List columns = reportList.getColumns();
            int reportStartRow = 2;
            int refContStartRow = 2;
            int collectPlanStartRow = 2;
            for (int i = 1; i <= rowCount; ++i) {
                DynamicObject rowData = reportList.getReportModel().getRowData(i);
                this.writeContractReportData(columns, contReportNumbers, contractReportSheet, reportStartRow, rowData);
                ++reportStartRow;
                DynamicObject contract = rowData.getDynamicObject("contract");
                refContStartRow = this.setRelationContractData(refContSheet, refContNumbers, refContStartRow, contract);
                collectPlanStartRow = this.setCollectPlanData(collectPlanSheet, collectPlanNumbers, collectPlanStartRow, contract);
            }
            this.downloadFile(xssfWorkbook);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e\u53ef\u4ee5\u5bfc\u51fa\u3002", (String)"InContractReportFormPlugin_51", (String)"pmgt-pmct-report", (Object[])new Object[0]));
        }
    }

    private void downloadFile(XSSFWorkbook xssfWorkbook) {
        Date date = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String fileName = String.format(ResManager.loadKDString((String)"\u6536\u5165\u5408\u540c\u4e00\u89c8\u8868-%s.xlsx", (String)"InContractReportFormPlugin_25", (String)"pmgt-pmct-report", (Object[])new Object[0]), dateFormat.format(date));
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            xssfWorkbook.write((OutputStream)outputStream);
        }
        catch (IOException e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5199\u5165\u6570\u636e\u5f02\u5e38", (String)"InContractReportFormPlugin_26", (String)"pmgt-pmct-report", (Object[])new Object[0]));
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        FileService service = FileServiceFactory.getAttachmentFileService();
        RequestContext ctx = RequestContext.getOrCreate();
        String filePath = FileNameUtils.getExportFileName((String)ctx.getTenantId(), (String)ctx.getAccountId(), (String)"pmct", (String)("pmct_incontractrpt_" + UUID.randomUUID().toString()), (String)fileName);
        FileItem fileItem = new FileItem(fileName, filePath, (InputStream)inputStream);
        String url = service.upload(fileItem);
        String fullUrl = UrlService.getAttachmentFullUrl((String)url);
        this.getView().download(fullUrl);
        try {
            outputStream.close();
        }
        catch (IOException e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8f93\u51fa\u6d41\u5173\u95ed\u5f02\u5e38", (String)"InContractReportFormPlugin_27", (String)"pmgt-pmct-report", (Object[])new Object[0]));
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6570\u636e\u5bfc\u51fa\u6210\u529f\u3002", (String)"InContractReportFormPlugin_52", (String)"pmgt-pmct-report", (Object[])new Object[0]));
    }

    private String[] initContractReportSheet(ReportList reportList, XSSFSheet contractReportSheet, XSSFCellStyle parentStyle) {
        List<String> excludeColumnList = Arrays.asList("currency", "totalreceiptamount", "totalpaymentamount", "totalrevisionoftaxamount", "totalclaimoftaxamount", "totaladditionoftaxamt");
        List columns = reportList.getColumns();
        Iterator iterator = columns.iterator();
        while (iterator.hasNext()) {
            ReportColumn field = (ReportColumn)iterator.next();
            String fieldKey = field.getFieldKey();
            if (!excludeColumnList.contains(fieldKey)) continue;
            iterator.remove();
        }
        int size = columns.size();
        String[] title = new String[size];
        String[] numbers = new String[size];
        int index = 0;
        for (AbstractReportColumn column : columns) {
            title[index] = column.getCaption().getLocaleValue();
            numbers[index] = ((ReportColumn)column).getFieldKey();
            ++index;
        }
        XSSFRow row = contractReportSheet.createRow(0);
        CellRangeAddress callRangeAddress = new CellRangeAddress(0, 0, 0, size - 1);
        XSSFCell inCell = row.createCell(0);
        inCell.setCellStyle((CellStyle)parentStyle);
        inCell.setCellValue(ResManager.loadKDString((String)"\u6536\u5165\u5408\u540c\u4e00\u89c8\u8868", (String)"InContractReportFormPlugin_21", (String)"pmgt-pmct-report", (Object[])new Object[0]));
        InContractReportFormPlugin.setMergedRegion(callRangeAddress, contractReportSheet);
        row.setHeightInPoints(35.0f);
        XSSFRow headRow = contractReportSheet.createRow(1);
        headRow.setHeightInPoints(15.0f);
        for (int i = 0; i < size; ++i) {
            XSSFCell cell = headRow.createCell(i);
            cell.setCellValue(title[i]);
            contractReportSheet.setColumnWidth(i, 5320);
        }
        return numbers;
    }

    private int setCollectPlanData(XSSFSheet collectPlanSheet, String[] collectPlanNumbers, int collectPlanStartRow, DynamicObject contract) {
        QFilter statusFilter = new QFilter("status", "=", (Object)StatusEnum.CHECKED.getValue());
        QFilter contractFilter = new QFilter("contract.id", "=", contract.getPkValue());
        String selector = Stream.of("collecttype", "collectfeq", "collectway", "collectpercent", "collectamount", "plancollecttime", "collectedamt", "sourcebilltype", "remarks", "contract", "currency", "collectedcomamt", "uncollectedamt", "nodesetting", "nodesettingsource", "taskcompletestatus", "name", "ctrlstrategy", "appliedamt", "appliedcomamt", "appliableamt").collect(Collectors.joining(","));
        DynamicObject[] collectPlans = BusinessDataServiceHelper.load((String)"pmbs_contractcollectitem", (String)selector, (QFilter[])new QFilter[]{contractFilter, statusFilter});
        if (collectPlans != null && collectPlans.length > 0) {
            for (DynamicObject collectPlan : collectPlans) {
                this.writeCollectPlanData(collectPlanNumbers, collectPlanSheet, collectPlanStartRow, collectPlan);
                ++collectPlanStartRow;
            }
        }
        return collectPlanStartRow;
    }

    public int setRelationContractData(XSSFSheet refContSheet, String[] contractNumbers, int refContStartRow, DynamicObject contract) {
        String selector;
        DynamicObject[] contracts;
        QFilter filter = new QFilter("contract", "=", contract.getPkValue());
        if (null != contract.getDynamicObject("contract")) {
            filter.or(new QFilter("id", "=", contract.getDynamicObject("contract").getPkValue()));
        }
        if ((contracts = BusinessDataServiceHelper.load((String)"pmct_contractf7", (String)(selector = Stream.of("project", "billstatus", "createorg", "currency", "contracttype", "originaloftaxamount", "totaloftaxamount", "totalsettleoftaxamount", "totalapplyoftaxamount", "totalrealoftaxamount", "totalinvoiceoftaxamount", "totalclaimoftaxamount", "totalrevisionoftaxamount", "paydirection", "totaladditionoftaxamt", "org", "contractstatus", "billno", "billname").collect(Collectors.joining(","))), (QFilter[])new QFilter[]{filter})) != null && contracts.length > 0) {
            for (DynamicObject relationContract : contracts) {
                this.writeRefContractData(contractNumbers, refContSheet, refContStartRow, relationContract, contract);
                ++refContStartRow;
            }
        }
        return refContStartRow;
    }

    @NotNull
    public String[] initCollectPlanSheet(XSSFSheet collectPlanSheet, XSSFCellStyle parentStyle, EntryGrid collectItemEntry) {
        List collectItems = collectItemEntry.getItems();
        List<String> excludeColumnList = Arrays.asList("collectitem", "itemcurrency", "nodesettingsource", "sourcebilltype");
        Iterator iterator = collectItems.iterator();
        while (iterator.hasNext()) {
            Control field = (Control)iterator.next();
            String fieldKey = field.getKey();
            if (!excludeColumnList.contains(fieldKey)) continue;
            iterator.remove();
        }
        int collectPlanSize = collectItems.size() + 2;
        XSSFRow collectPlanRow = collectPlanSheet.createRow(0);
        XSSFCell collectPlanCell1 = collectPlanRow.createCell(0);
        XSSFCell collectPlanCell2 = collectPlanRow.createCell(2);
        collectPlanCell1.setCellStyle((CellStyle)parentStyle);
        collectPlanCell1.setCellValue(ResManager.loadKDString((String)"\u6536\u5165\u5408\u540c", (String)"InContractReportFormPlugin_0", (String)"pmgt-pmct-report", (Object[])new Object[0]));
        collectPlanCell2.setCellStyle((CellStyle)parentStyle);
        collectPlanCell2.setCellValue(ResManager.loadKDString((String)"\u6536\u6b3e\u6761\u76ee", (String)"InContractReportFormPlugin_22", (String)"pmgt-pmct-report", (Object[])new Object[0]));
        CellRangeAddress payPlanFirstCallRangeAddress = new CellRangeAddress(0, 0, 0, 1);
        InContractReportFormPlugin.setMergedRegion(payPlanFirstCallRangeAddress, collectPlanSheet);
        CellRangeAddress payPlanSecondCallRangeAddress = new CellRangeAddress(0, 0, 2, collectPlanSize - 1);
        InContractReportFormPlugin.setMergedRegion(payPlanSecondCallRangeAddress, collectPlanSheet);
        collectPlanRow.setHeightInPoints(35.0f);
        XSSFRow collectPlanHeadRow = collectPlanSheet.createRow(1);
        collectPlanHeadRow.setHeightInPoints(15.0f);
        String[] collectPlanNumbers = new String[collectPlanSize];
        collectPlanNumbers[0] = "billno";
        collectPlanNumbers[1] = "billname";
        int index = 2;
        for (Control item : collectItems) {
            FieldEdit column = (FieldEdit)item;
            collectPlanNumbers[index] = column.getKey();
            ++index;
        }
        for (int i = 0; i < collectPlanSize; ++i) {
            XSSFCell collectPlanCell = collectPlanHeadRow.createCell(i);
            collectPlanCell.setCellValue(this.incomePlanTitle[i]);
            collectPlanSheet.setColumnWidth(i, 5320);
        }
        return collectPlanNumbers;
    }

    @NotNull
    public String[] initRelationContractSheet(XSSFSheet contractSheet, XSSFCellStyle parentStyle, EntryGrid contractEntry) {
        List contractItems = contractEntry.getItems();
        contractItems.remove(0);
        int contractSize = contractItems.size() + 2;
        XSSFRow contractRow = contractSheet.createRow(0);
        XSSFCell cell1 = contractRow.createCell(0);
        XSSFCell cell2 = contractRow.createCell(2);
        cell1.setCellStyle((CellStyle)parentStyle);
        cell1.setCellValue(ResManager.loadKDString((String)"\u6536\u5165\u5408\u540c", (String)"InContractReportFormPlugin_0", (String)"pmgt-pmct-report", (Object[])new Object[0]));
        cell2.setCellStyle((CellStyle)parentStyle);
        cell2.setCellValue(ResManager.loadKDString((String)"\u5173\u8054\u5408\u540c", (String)"InContractReportFormPlugin_23", (String)"pmgt-pmct-report", (Object[])new Object[0]));
        CellRangeAddress firstCallRangeAddress = new CellRangeAddress(0, 0, 0, 1);
        InContractReportFormPlugin.setMergedRegion(firstCallRangeAddress, contractSheet);
        CellRangeAddress secondCallRangeAddress = new CellRangeAddress(0, 0, 2, contractSize - 1);
        InContractReportFormPlugin.setMergedRegion(secondCallRangeAddress, contractSheet);
        contractRow.setHeightInPoints(35.0f);
        XSSFRow contractHeadRow = contractSheet.createRow(1);
        contractHeadRow.setHeightInPoints(15.0f);
        String[] contractTitle = new String[contractSize];
        String[] contractNumbers = new String[contractSize];
        contractTitle[0] = ResManager.loadKDString((String)"\u5408\u540c\u7f16\u53f7", (String)"InContractReportFormPlugin_2", (String)"pmgt-pmct-report", (Object[])new Object[0]);
        contractTitle[1] = ResManager.loadKDString((String)"\u5408\u540c\u540d\u79f0", (String)"InContractReportFormPlugin_3", (String)"pmgt-pmct-report", (Object[])new Object[0]);
        contractTitle[2] = ResManager.loadKDString((String)"\u5173\u8054\u5408\u540c\u6536\u652f\u6027\u8d28", (String)"InContractReportFormPlugin_29", (String)"pmgt-pmct-report", (Object[])new Object[0]);
        contractTitle[3] = ResManager.loadKDString((String)"\u5173\u8054\u5408\u540c\u7f16\u7801", (String)"InContractReportFormPlugin_30", (String)"pmgt-pmct-report", (Object[])new Object[0]);
        contractTitle[4] = ResManager.loadKDString((String)"\u5173\u8054\u5408\u540c\u540d\u79f0", (String)"InContractReportFormPlugin_31", (String)"pmgt-pmct-report", (Object[])new Object[0]);
        contractTitle[5] = ResManager.loadKDString((String)"\u4e1a\u52a1\u7ec4\u7ec7", (String)"InContractReportFormPlugin_32", (String)"pmgt-pmct-report", (Object[])new Object[0]);
        contractTitle[6] = ResManager.loadKDString((String)"\u9879\u76ee", (String)"InContractReportFormPlugin_33", (String)"pmgt-pmct-report", (Object[])new Object[0]);
        contractTitle[7] = ResManager.loadKDString((String)"\u5408\u540c\u72b6\u6001", (String)"InContractReportFormPlugin_34", (String)"pmgt-pmct-report", (Object[])new Object[0]);
        contractTitle[8] = ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001", (String)"InContractReportFormPlugin_35", (String)"pmgt-pmct-report", (Object[])new Object[0]);
        contractTitle[9] = ResManager.loadKDString((String)"\u521b\u5efa\u90e8\u95e8", (String)"InContractReportFormPlugin_50", (String)"pmgt-pmct-report", (Object[])new Object[0]);
        contractTitle[10] = ResManager.loadKDString((String)"\u5408\u540c\u7c7b\u578b", (String)"InContractReportFormPlugin_36", (String)"pmgt-pmct-report", (Object[])new Object[0]);
        contractTitle[11] = ResManager.loadKDString((String)"\u5408\u540c\u521d\u59cb\u91d1\u989d\u2460", (String)"InContractReportFormPlugin_37", (String)"pmgt-pmct-report", (Object[])new Object[0]);
        contractTitle[12] = ResManager.loadKDString((String)"\u7d2f\u8ba1\u53d8\u52a8\u91d1\u989d\u2461", (String)"InContractReportFormPlugin_38", (String)"pmgt-pmct-report", (Object[])new Object[0]);
        contractTitle[13] = ResManager.loadKDString((String)"\u5408\u540c\u603b\u91d1\u989d\u2462", (String)"InContractReportFormPlugin_39", (String)"pmgt-pmct-report", (Object[])new Object[0]);
        contractTitle[14] = ResManager.loadKDString((String)"\u7d2f\u8ba1\u7ed3\u7b97\u91d1\u989d\u2463", (String)"InContractReportFormPlugin_40", (String)"pmgt-pmct-report", (Object[])new Object[0]);
        contractTitle[15] = ResManager.loadKDString((String)"\u5408\u540c\u5269\u4f59\u91d1\u989d\u2462-\u2463", (String)"InContractReportFormPlugin_41", (String)"pmgt-pmct-report", (Object[])new Object[0]);
        contractTitle[16] = ResManager.loadKDString((String)"\u7d2f\u8ba1\u4ed8\u6b3e\u7533\u8bf7\u91d1\u989d\u2465", (String)"InContractReportFormPlugin_42", (String)"pmgt-pmct-report", (Object[])new Object[0]);
        contractTitle[17] = ResManager.loadKDString((String)"\u7d2f\u8ba1\u5b9e\u4ed8\u91d1\u989d\u2466", (String)"InContractReportFormPlugin_43", (String)"pmgt-pmct-report", (Object[])new Object[0]);
        contractTitle[18] = ResManager.loadKDString((String)"\u7d2f\u8ba1\u5e94\u4ed8\u91d1\u989d\u2463-\u2466", (String)"InContractReportFormPlugin_44", (String)"pmgt-pmct-report", (Object[])new Object[0]);
        contractTitle[19] = ResManager.loadKDString((String)"\u7d2f\u8ba1\u6536\u7968\u91d1\u989d\u2468", (String)"InContractReportFormPlugin_45", (String)"pmgt-pmct-report", (Object[])new Object[0]);
        contractTitle[20] = ResManager.loadKDString((String)"\u5269\u4f59\u672a\u6536\u7968\u91d1\u989d\u2469", (String)"InContractReportFormPlugin_46", (String)"pmgt-pmct-report", (Object[])new Object[0]);
        contractNumbers[0] = "billno";
        contractNumbers[1] = "billname";
        contractNumbers[2] = "refpaydirection";
        contractNumbers[3] = "refcontract";
        contractNumbers[4] = "refcontractname";
        contractNumbers[5] = "refcontractorg";
        contractNumbers[6] = "refproject";
        contractNumbers[7] = "refrelatecontstatus";
        contractNumbers[8] = "refbillstatus";
        contractNumbers[9] = "refcreateorg";
        contractNumbers[10] = "refconttype";
        contractNumbers[11] = "ref_originaloftaxamount";
        contractNumbers[12] = "ref_changeamount";
        contractNumbers[13] = "ref_totaloftaxamount";
        contractNumbers[14] = "reftotalsettleoftaxamount";
        contractNumbers[15] = "ref_totalunsettleamount";
        contractNumbers[16] = "ref_totalapplyoftaxamount";
        contractNumbers[17] = "ref_totalrealoftaxamount";
        contractNumbers[18] = "reftotalunrealoftaxamount";
        contractNumbers[19] = "ref_totalinvoiceoftaxamt";
        contractNumbers[20] = "ref_uninvoiceamt";
        for (int i = 0; i < contractSize; ++i) {
            XSSFCell contractCell = contractHeadRow.createCell(i);
            contractCell.setCellValue(contractTitle[i]);
            contractSheet.setColumnWidth(i, 5320);
        }
        return contractNumbers;
    }

    public static void setMergedRegion(CellRangeAddress cellAddresses, XSSFSheet sheet) {
        sheet.addMergedRegion(cellAddresses);
        RegionUtil.setBorderTop((BorderStyle)BorderStyle.MEDIUM, (CellRangeAddress)cellAddresses, (Sheet)sheet);
        RegionUtil.setBorderBottom((BorderStyle)BorderStyle.MEDIUM, (CellRangeAddress)cellAddresses, (Sheet)sheet);
        RegionUtil.setBorderLeft((BorderStyle)BorderStyle.MEDIUM, (CellRangeAddress)cellAddresses, (Sheet)sheet);
        RegionUtil.setBorderRight((BorderStyle)BorderStyle.MEDIUM, (CellRangeAddress)cellAddresses, (Sheet)sheet);
    }

    private void writeContractReportData(List<AbstractReportColumn> columns, String[] numbers, XSSFSheet sheet, int startRow, DynamicObject data) {
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"pmct_incontractrpt");
        XSSFRow curRow = sheet.createRow(startRow);
        for (int i = 0; i < columns.size(); ++i) {
            String cellValue;
            XSSFCell dataCell = curRow.createCell(i);
            Object value = null;
            value = "contract".equals(numbers[i]) ? data.getDynamicObject("contract").get("billno") : ("project".equals(numbers[i]) && data.getDynamicObject("project") != null ? data.getDynamicObject("contract").get("project.name") : ("contractname".equals(numbers[i]) ? data.getDynamicObject("contract").get("billname") : ("contractorg".equals(numbers[i]) ? data.getDynamicObject("contract").get("org.name") : ("contractstatus".equals(numbers[i]) ? data.getDynamicObject("contract").get("contractstatus.name") : ("billstatus".equals(numbers[i]) ? (data.getDynamicObject("contract").get("billstatus").equals("A") ? ResManager.loadKDString((String)"\u6682\u5b58", (String)"InContractReportFormPlugin_47", (String)"pmgt-pmct-report", (Object[])new Object[0]) : (data.getDynamicObject("contract").get("billstatus").equals("B") ? ResManager.loadKDString((String)"\u5df2\u63d0\u4ea4", (String)"InContractReportFormPlugin_48", (String)"pmgt-pmct-report", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5df2\u5ba1\u6838", (String)"InContractReportFormPlugin_49", (String)"pmgt-pmct-report", (Object[])new Object[0]))) : ("conttype".equals(numbers[i]) ? data.getDynamicObject("contract").get("contracttype.name") : ("createorg".equals(numbers[i]) ? data.getDynamicObject("contract").get("createorg.name") : data.get(numbers[i]))))))));
            IDataEntityProperty property = dt.findProperty(numbers[i]);
            DynamicObject currency = data.getDynamicObject("currency");
            String currencySign = currency.getString("sign");
            int amtprecision = currency.getInt("amtprecision");
            if (property instanceof ComboProp) {
                ComboProp comboProp = (ComboProp)property;
                cellValue = comboProp.getItemByName(value.toString());
            } else if (value instanceof BigDecimal) {
                cellValue = ((BigDecimal)value).setScale(amtprecision, RoundingMode.HALF_UP).toPlainString();
                if ("0E-10".equals(cellValue)) {
                    cellValue = BigDecimal.ZERO.setScale(amtprecision).toString();
                }
                cellValue = currencySign + cellValue;
            } else {
                cellValue = value != null ? value.toString() : null;
            }
            dataCell.setCellValue(cellValue);
        }
    }

    private void writeCollectPlanData(String[] numbers, XSSFSheet sheet, int startRow, DynamicObject data) {
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"pmct_incontractrpt");
        XSSFRow curRow = sheet.createRow(startRow);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        for (int i = 0; i < numbers.length; ++i) {
            String cellValue;
            CtrlStrategyEnum ctrlStrategyEnum;
            String nodeSettingSource;
            Map srcObjCompleteMap;
            Map nodeObjCompMap;
            DynamicObject nodeSetting;
            XSSFCell dataCell = curRow.createCell(i);
            Object value = "billno".equals(numbers[i]) ? data.getDynamicObject("contract").get("billno") : ("billname".equals(numbers[i]) ? data.getDynamicObject("contract").getString("billname") : ("collectway".equals(numbers[i]) && data.getDynamicObject("collectway") != null ? data.getDynamicObject("collectway").getLocaleString("name") : ("plancollecttime".equals(numbers[i]) && data.getDate("plancollecttime") != null ? df.format(data.getDate("plancollecttime")) : ("nodesetting".equals(numbers[i]) ? this.getNodeSettingName(data) : ("taskcompletestatus".equals(numbers[i]) ? ((nodeSetting = data.getDynamicObject("nodesetting")) != null ? ((nodeObjCompMap = (Map)(srcObjCompleteMap = ContractPayItemHelper.getSrcObjCompleteMap((DynamicObject[])new DynamicObject[]{data})).get(nodeSettingSource = data.getString("nodesettingsource"))) != null ? nodeObjCompMap.get(nodeSetting.getPkValue()) : "") : "") : ("itemname".equals(numbers[i]) ? data.getLocaleString("name") : ("ctrlstrategy".equals(numbers[i]) ? ((ctrlStrategyEnum = CtrlStrategyEnum.getEnumByValue((String)data.getString("ctrlstrategy"))) != null ? ctrlStrategyEnum.getName() : "") : ("collectpercent".equals(numbers[i]) ? data.getBigDecimal(numbers[i]).setScale(4, RoundingMode.HALF_UP) : data.get(numbers[i])))))))));
            IDataEntityProperty property = dt.findProperty(numbers[i]);
            DynamicObject currency = data.getDynamicObject("currency");
            String currencySign = currency.getString("sign");
            int amtprecision = currency.getInt("amtprecision");
            if (property instanceof ComboProp) {
                ComboProp comboProp = (ComboProp)property;
                cellValue = value != null ? comboProp.getItemByName(value.toString()) : "";
            } else if (property instanceof AmountProp) {
                if (value != null) {
                    cellValue = ((BigDecimal)value).setScale(amtprecision, RoundingMode.HALF_UP).toPlainString();
                    if ("0E-10".equals(cellValue)) {
                        cellValue = BigDecimal.ZERO.setScale(amtprecision).toString();
                    }
                    cellValue = currencySign + cellValue;
                } else {
                    cellValue = BigDecimal.ZERO.setScale(amtprecision).toString();
                }
            } else {
                cellValue = value != null ? value.toString() : null;
            }
            dataCell.setCellValue(cellValue);
        }
    }

    private ILocaleString getNodeSettingName(DynamicObject data) {
        DynamicObject nodesetting = data.getDynamicObject("nodesetting");
        if (nodesetting == null) {
            return null;
        }
        String name = nodesetting.getDynamicObjectType().getName();
        if (StringUtils.equals((CharSequence)name, (CharSequence)NodeSettingSourceEnum.PMBS_TASK.getValue())) {
            return nodesetting.getLocaleString("name");
        }
        if (StringUtils.equals((CharSequence)name, (CharSequence)"pmbs_wbs")) {
            return nodesetting.getLocaleString("name");
        }
        return nodesetting.getLocaleString("workitem");
    }

    private void writeRefContractData(String[] numbers, XSSFSheet sheet, int startRow, DynamicObject data, DynamicObject contractData) {
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"pmct_incontractrpt");
        XSSFRow curRow = sheet.createRow(startRow);
        BigDecimal totalAmt = data.getBigDecimal("totaloftaxamount");
        BigDecimal totalClaimAmt = data.getBigDecimal("totalclaimoftaxamount");
        BigDecimal totalAdditionOfTaxAmt = data.getBigDecimal("totaladditionoftaxamt");
        BigDecimal totalRevisionAmt = data.getBigDecimal("totalrevisionoftaxamount");
        BigDecimal totalSettleAmt = data.getBigDecimal("totalsettleoftaxamount");
        BigDecimal totalRealAmt = data.getBigDecimal("totalrealoftaxamount");
        BigDecimal totalInvoiceAmt = data.getBigDecimal("totalinvoiceoftaxamount");
        for (int i = 0; i < numbers.length; ++i) {
            XSSFCell dataCell = curRow.createCell(i);
            Object value = null;
            if ("billno".equals(numbers[i])) {
                value = contractData.get("billno");
            } else if ("billname".equals(numbers[i])) {
                value = contractData.get("billname");
            } else if ("refcontract".equals(numbers[i])) {
                value = data.get("billno");
            } else if ("refcontractname".equals(numbers[i])) {
                value = data.get("billname");
            } else if ("refpaydirection".equals(numbers[i]) && !data.getString("paydirection").isEmpty()) {
                value = data.getString("paydirection").equals("out") ? PayDirectionEnum.OUT.getName() : PayDirectionEnum.IN.getName();
            } else if ("refcontractorg".equals(numbers[i])) {
                value = data.getDynamicObject("org").get("name");
            } else if ("refcreateorg".equals(numbers[i])) {
                value = data.getDynamicObject("createorg").get("name");
            } else if ("refproject".equals(numbers[i]) && data.getDynamicObject("project") != null) {
                value = data.getDynamicObject("project").get("name");
            } else if ("refrelatecontstatus".equals(numbers[i])) {
                value = data.getDynamicObject("contractstatus").get("name");
            } else if ("refbillstatus".equals(numbers[i])) {
                value = "A".equals(data.get("billstatus")) ? StatusEnum.TEMPSAVE.getName() : ("B".equals(data.get("billstatus")) ? StatusEnum.UNCHECKED.getName() : StatusEnum.CHECKED.getName());
            } else if ("refconttype".equals(numbers[i]) && data.getDynamicObject("contracttype") != null) {
                value = data.getDynamicObject("contracttype").get("name");
            } else if ("ref_originaloftaxamount".equals(numbers[i])) {
                value = data.get("originaloftaxamount");
            } else if ("ref_changeamount".equals(numbers[i])) {
                value = totalClaimAmt.add(totalRevisionAmt).add(totalAdditionOfTaxAmt);
            } else if ("ref_totaloftaxamount".equals(numbers[i])) {
                value = totalAmt;
            } else if ("reftotalsettleoftaxamount".equals(numbers[i])) {
                value = totalSettleAmt;
            } else if ("ref_totalunsettleamount".equals(numbers[i])) {
                value = totalAmt.subtract(totalSettleAmt);
            } else if ("ref_totalapplyoftaxamount".equals(numbers[i])) {
                value = data.get("totalapplyoftaxamount");
            } else if ("ref_totalrealoftaxamount".equals(numbers[i])) {
                value = totalRealAmt;
            } else if ("reftotalunrealoftaxamount".equals(numbers[i])) {
                value = totalSettleAmt.subtract(totalRealAmt);
            } else if ("ref_totalinvoiceoftaxamt".equals(numbers[i])) {
                value = totalInvoiceAmt;
            } else if ("ref_uninvoiceamt".equals(numbers[i])) {
                value = totalSettleAmt.subtract(totalInvoiceAmt);
            }
            String cellValue = null;
            IDataEntityProperty property = dt.findProperty(numbers[i]);
            DynamicObject currency = data.getDynamicObject("currency");
            String currencySign = currency.getString("sign");
            int amtprecision = currency.getInt("amtprecision");
            if (property instanceof ComboProp) {
                ComboProp comboProp = (ComboProp)property;
                if (value != null) {
                    cellValue = comboProp.getItemByName(value.toString());
                }
            } else if (value instanceof BigDecimal) {
                cellValue = ((BigDecimal)value).setScale(amtprecision, RoundingMode.HALF_UP).toPlainString();
                if ("0E-10".equals(cellValue)) {
                    cellValue = BigDecimal.ZERO.setScale(amtprecision).toString();
                }
                cellValue = currencySign + cellValue;
            } else {
                cellValue = value != null ? value.toString() : null;
            }
            dataCell.setCellValue(cellValue);
        }
    }
}

