/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.common.model;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRFormula;
import kd.bos.entity.formula.CalcExprParser;
import kd.bos.entity.formula.ExpressionParameter;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.validate.BillStatus;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.operation.Operation;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmbs.common.enums.BudgetSourceTypeEnum;
import kd.pmgt.pmbs.common.enums.EnableEnum;
import kd.pmgt.pmbs.common.enums.budgetreg.BillFieldTypeEnum;
import kd.pmgt.pmbs.common.enums.budgetreg.IdentifyValueEnum;
import kd.pmgt.pmct.common.model.BudgetRegModel;
import kd.pmgt.pmct.common.model.BudgetRegValue;
import kd.pmgt.pmct.common.model.CommonBudgetUpdateParam;
import org.apache.commons.collections4.CollectionUtils;

public class BudgetUpdateParam
extends CommonBudgetUpdateParam {
    private static final Log logger = LogFactory.getLog(BudgetUpdateParam.class);
    public DynamicObject bill;
    public List<BudgetRegValue> budgetRegValues;
    private List<BudgetRegModel> budgetRegModels;
    public DynamicObject[] bgControlBizRegArray;
    public DynamicObject regBillInfo;

    public BudgetUpdateParam(DynamicObject regBillInfo, DynamicObject[] bgControlBizRegArray, DynamicObject bill, Operation operation) {
        this.regBillInfo = regBillInfo;
        this.bgControlBizRegArray = bgControlBizRegArray;
        this.bill = bill;
        if (operation != null) {
            this.op = operation;
            this.operation = operation.getKey();
        }
    }

    private List<BudgetRegModel> getBudgetRegModels() {
        if (CollectionUtils.isEmpty(this.budgetRegModels)) {
            this.budgetRegModels = new ArrayList<BudgetRegModel>(16);
            for (DynamicObject item : this.bgControlBizRegArray) {
                BudgetRegModel budgetRegModel = new BudgetRegModel();
                BillFieldTypeEnum fieldType = BillFieldTypeEnum.getEnumByNumber((String)item.getString("type"));
                budgetRegModel.setFieldType(fieldType);
                String identify = item.getString("identify");
                budgetRegModel.setIdentify(identify);
                if (IdentifyValueEnum.SOURCEBILLFIELD.getValue().equals(identify)) {
                    String fieldKey = item.getString("number");
                    budgetRegModel.setFieldRegKey(fieldKey);
                } else if (IdentifyValueEnum.FORMULA.getValue().equals(identify)) {
                    String formula = item.getString("fieldformula");
                    budgetRegModel.setFormula(formula);
                }
                String value = item.getString("defaultvalue");
                if (StringUtils.isNotEmpty((CharSequence)value)) {
                    CRFormula formula = (CRFormula)SerializationUtils.fromJsonString((String)value, CRFormula.class);
                    budgetRegModel.setDefaultValue(formula.getExpression());
                }
                this.setFieldRegValue(budgetRegModel);
                this.budgetRegModels.add(budgetRegModel);
            }
        }
        return this.budgetRegModels;
    }

    protected String getBizRegKey(BillFieldTypeEnum fieldType) {
        String bizFieldRegKey = null;
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)this.bill.getDynamicObjectType().getName());
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        if (BillFieldTypeEnum.BILL_NAME.equals((Object)fieldType)) {
            for (IDataEntityProperty item : properties) {
                DynamicProperty property = (DynamicProperty)item;
                if (!Arrays.asList("billname", "name").contains(property.getName())) continue;
                bizFieldRegKey = property.getName();
                break;
            }
        } else if (BillFieldTypeEnum.BILL_NO.equals((Object)fieldType)) {
            for (IDataEntityProperty item : properties) {
                DynamicProperty property = (DynamicProperty)item;
                if (!Arrays.asList("billno", "number").contains(property.getName())) continue;
                bizFieldRegKey = property.getName();
                break;
            }
        }
        if (BillFieldTypeEnum.BILL_NAME.equals((Object)fieldType) && bizFieldRegKey == null) {
            bizFieldRegKey = this.getBizRegKey(BillFieldTypeEnum.BILL_NO);
        }
        return bizFieldRegKey;
    }

    public List<BudgetRegValue> getBudgetRegValues() {
        block28: {
            BudgetRegValue budgetRegValue;
            int i;
            Object budget;
            if (!CollectionUtils.isEmpty(this.budgetRegValues)) break block28;
            List<BudgetRegModel> budgetRegModels = this.getBudgetRegModels();
            List<Object> projectValueList = new ArrayList();
            int projectValueSize = 0;
            List<Object> budgetValueList = new ArrayList();
            int budgetValueSize = 0;
            List<Object> periodValueList = new ArrayList();
            int periodValueSize = 0;
            List<Object> currencyValueList = new ArrayList();
            int currencyValueSize = 0;
            List<Object> amountValueList = new ArrayList();
            int amountValueSize = 0;
            List<Object> budgetTypeValueList = new ArrayList();
            int budgetTypeValueSize = 0;
            for (BudgetRegModel model : budgetRegModels) {
                String fieldType = model.getFieldType().getNumber();
                if (fieldType.equalsIgnoreCase(BillFieldTypeEnum.PROJECT.getNumber())) {
                    projectValueList = model.getFieldValue();
                    if (projectValueList == null || projectValueList.size() == 0) {
                        projectValueList = new ArrayList();
                        projectValueList.add(model.getDefaultValue());
                    }
                    projectValueSize = projectValueList.size();
                }
                if (fieldType.equalsIgnoreCase(BillFieldTypeEnum.BUDGET.getNumber())) {
                    budgetValueList = model.getFieldValue();
                    if (budgetValueList == null || budgetValueList.size() == 0) {
                        budgetValueList = new ArrayList();
                        budget = model.getDefaultValue();
                        QFilter filter = budget instanceof String ? new QFilter("budgetitem", "=", (Object)Long.parseLong(budget.toString())) : new QFilter("budgetitem", "=", budget);
                        DynamicObject projectBudget = BusinessDataServiceHelper.loadSingle((String)"pmas_projectbudget", (String)"", (QFilter[])new QFilter[]{filter});
                        if (projectBudget != null) {
                            budgetValueList.add(projectBudget);
                        }
                    }
                    budgetValueSize = budgetValueList.size();
                }
                if (fieldType.equalsIgnoreCase(BillFieldTypeEnum.PERIOD.getNumber())) {
                    periodValueList = model.getFieldValue();
                    if (periodValueList == null || periodValueList.size() == 0) {
                        periodValueList = new ArrayList();
                        periodValueList.add(model.getDefaultValue());
                    }
                    periodValueSize = periodValueList.size();
                }
                if (fieldType.equalsIgnoreCase(BillFieldTypeEnum.CURRENCY.getNumber())) {
                    currencyValueList = model.getFieldValue();
                    if (currencyValueList == null || currencyValueList.size() == 0) {
                        currencyValueList = new ArrayList();
                        currencyValueList.add(model.getDefaultValue());
                    }
                    currencyValueSize = currencyValueList.size();
                }
                if (fieldType.equalsIgnoreCase(BillFieldTypeEnum.AMOUNT.getNumber())) {
                    amountValueList = model.getFieldValue();
                    if (amountValueList == null || amountValueList.size() == 0) {
                        amountValueList = new ArrayList();
                        amountValueList.add(model.getDefaultValue());
                    }
                    amountValueSize = amountValueList.size();
                }
                if (!fieldType.equalsIgnoreCase(BillFieldTypeEnum.BUDGETTYPE.getNumber())) continue;
                budgetTypeValueList = model.getFieldValue();
                if (budgetTypeValueList == null || budgetTypeValueList.size() == 0) {
                    budgetTypeValueList = new ArrayList();
                    budgetTypeValueList.add(model.getDefaultValue());
                }
                budgetTypeValueSize = budgetTypeValueList.size();
            }
            this.budgetRegValues = new ArrayList<BudgetRegValue>();
            if (projectValueSize >= budgetValueSize) {
                for (i = 0; i < projectValueSize; ++i) {
                    DynamicObject projectBudget;
                    budgetRegValue = new BudgetRegValue();
                    DynamicObject project = (DynamicObject)projectValueList.get(i);
                    budgetRegValue.setProjectValue(project);
                    if (budgetValueSize == 0) {
                        budgetRegValue.setBudgetValue(null);
                    } else if (budgetValueSize == 1) {
                        budget = (DynamicObject)budgetValueList.get(0);
                        projectBudget = this.getBudgetValue(budget, project);
                        budgetRegValue.setBudgetValue(projectBudget);
                    } else {
                        budget = (DynamicObject)budgetValueList.get(i);
                        projectBudget = this.getBudgetValue(budget, project);
                        budgetRegValue.setBudgetValue(projectBudget);
                    }
                    this.budgetRegValues.add(budgetRegValue);
                }
            } else {
                for (i = 0; i < budgetValueSize; ++i) {
                    budgetRegValue = new BudgetRegValue();
                    budgetRegValue.setProjectValue((DynamicObject)projectValueList.get(0));
                    budgetRegValue.setBudgetValue((DynamicObject)budgetValueList.get(i));
                    this.budgetRegValues.add(budgetRegValue);
                }
            }
            for (i = 0; i < this.budgetRegValues.size(); ++i) {
                if (periodValueSize != 0) {
                    Date bizDate;
                    Object period = periodValueSize == 1 ? periodValueList.get(0) : periodValueList.get(i);
                    if (period instanceof DynamicObject) {
                        period = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)period).getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)((DynamicObject)period).getDataEntityType().getName()));
                        bizDate = ((DynamicObject)period).getDate("begindate");
                    } else {
                        bizDate = (Date)period;
                    }
                    this.budgetRegValues.get(i).setBizDateValue(bizDate);
                }
                Object currencyObj = currencyValueSize == 1 ? currencyValueList.get(0) : currencyValueList.get(i);
                DynamicObject currency = currencyObj instanceof DynamicObject ? (DynamicObject)currencyObj : BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(currencyObj.toString()), (String)"bd_currency");
                this.budgetRegValues.get(i).setCurrencyValue(currency);
                if (amountValueSize == 1) {
                    this.budgetRegValues.get(i).setAmountValue(new BigDecimal(amountValueList.get(0).toString()));
                } else {
                    this.budgetRegValues.get(i).setAmountValue(new BigDecimal(amountValueList.get(i).toString()));
                }
                if (budgetTypeValueSize == 1) {
                    this.budgetRegValues.get(i).setBudgetTypeValue(BudgetSourceTypeEnum.getEnumByValue((Object)budgetTypeValueList.get(0)));
                    continue;
                }
                this.budgetRegValues.get(i).setBudgetTypeValue(BudgetSourceTypeEnum.getEnumByValue((Object)budgetTypeValueList.get(i)));
            }
        }
        return this.budgetRegValues;
    }

    protected DynamicObject getBudgetValue(Object dimMember, DynamicObject project) {
        DynamicObject projectBudget = null;
        DynamicObject dimMem = null;
        if (dimMember instanceof DynamicObject) {
            dimMem = (DynamicObject)dimMember;
            Long dimMemId = (Long)dimMem.getPkValue();
            for (DynamicObject bgControlBizReg : this.bgControlBizRegArray) {
                if (!StringUtils.equals((CharSequence)bgControlBizReg.getString("type"), (CharSequence)BillFieldTypeEnum.BUDGET.getNumber())) continue;
                DynamicObject budgetMapping = bgControlBizReg.getDynamicObject("budgetmapping");
                if (budgetMapping == null) break;
                QFilter filter = new QFilter("id", "=", budgetMapping.getPkValue()).and("enable", "=", (Object)EnableEnum.ENABLE.getValue());
                budgetMapping = BusinessDataServiceHelper.loadSingle((String)"pmbs_budgetmapping", (QFilter[])new QFilter[]{filter});
                if (budgetMapping == null) break;
                for (DynamicObject budgetMappingEntry : budgetMapping.getDynamicObjectCollection("budgetmappingentry")) {
                    Long settingDimMemId = (Long)budgetMappingEntry.getDynamicObject("mappingvalue").getPkValue();
                    if (!dimMemId.equals(settingDimMemId)) continue;
                    DynamicObject stdBudget = budgetMappingEntry.getDynamicObject("budgetitem");
                    filter = new QFilter("project", "=", project.getPkValue()).and("budgetitem", "=", stdBudget.getPkValue());
                    projectBudget = BusinessDataServiceHelper.loadSingle((String)"pmas_projectbudget", (QFilter[])new QFilter[]{filter});
                    if (projectBudget == null) continue;
                    return projectBudget;
                }
                filter = new QFilter("project", "=", project.getPkValue()).and("billstatus", "=", (Object)BillStatus.C.name());
                DynamicObject projectBudgetMapping = BusinessDataServiceHelper.loadSingle((String)"pmco_probudgetmapping", (QFilter[])new QFilter[]{filter});
                if (projectBudgetMapping == null) break;
                for (DynamicObject projectBudgetMappingEntry : projectBudgetMapping.getDynamicObjectCollection("entryentity")) {
                    long projectSettingDimMemId = Long.parseLong(projectBudgetMappingEntry.getDynamicObject("mappingvalue").getPkValue().toString());
                    if (!dimMemId.equals(projectSettingDimMemId)) continue;
                    projectBudget = projectBudgetMappingEntry.getDynamicObject("probudget");
                    return projectBudget;
                }
            }
            logger.info("\u4e1a\u52a1\u5355\u636e\u7ef4\u5ea6\u6210\u5458\u3010{}\u3011\u5bf9\u5e94\u7684\u9879\u76ee\u9884\u7b97\u9879\u4e3a\u3010{}\u3011", new Object[]{dimMem.getDataEntityType().getName(), dimMem.getString("id"), dimMem.getString("name")});
        }
        return dimMem;
    }

    public CommonBudgetUpdateParam getCommonBudgetUpdateParam() {
        this.billNo = this.bill.getString(BillFieldTypeEnum.BILL_NO.getNumber());
        String billName = this.getBizRegKey(BillFieldTypeEnum.BILL_NAME);
        if (StringUtils.isNotEmpty((CharSequence)billName)) {
            this.billName = this.bill.getString(billName);
        }
        this.creator = this.bill.getDynamicObject(BillFieldTypeEnum.CREATOR.getNumber());
        this.createTime = this.bill.getDate(BillFieldTypeEnum.CREATE_TIME.getNumber());
        this.auditor = this.bill.getDynamicObject(BillFieldTypeEnum.AUDITOR.getNumber());
        this.auditTime = this.bill.getDate(BillFieldTypeEnum.AUDIT_TIME.getNumber());
        this.billId = (Long)this.bill.getPkValue();
        this.entityNumber = this.bill.getDynamicObjectType().getName();
        return this;
    }

    private void setFieldRegValue(BudgetRegModel budgetRegModel) {
        ArrayList<Object> fieldRegValue = new ArrayList<Object>();
        String identify = budgetRegModel.getIdentify();
        if (IdentifyValueEnum.SOURCEBILLFIELD.getValue().equals(identify)) {
            String fieldRegKey = budgetRegModel.getFieldRegKey();
            this.getCollectionValue(fieldRegKey, fieldRegValue, this.bill);
            budgetRegModel.setFieldRegValue(fieldRegValue);
        } else if (IdentifyValueEnum.FORMULA.getValue().equals(identify)) {
            ArrayList<Object> values;
            String formulaJson = budgetRegModel.getFormula();
            CRFormula formula = (CRFormula)SerializationUtils.fromJsonString((String)formulaJson, CRFormula.class);
            String[] variables = CalcExprParser.getExprVariables((String)formula.getExpression());
            String entityId = this.bill.getDataEntityType().getName();
            boolean includeEntryField = false;
            boolean includeSubEntryField = false;
            IDataEntityType entryFather = null;
            IDataEntityType subEntryFather = null;
            for (String var : variables) {
                IDataEntityProperty property;
                IDataEntityType father;
                if (var.contains(".")) {
                    var = var.substring(0, var.indexOf("."));
                }
                if ((father = (property = EntityMetadataCache.getDataEntityType((String)entityId).findProperty(var)).getParent()).getName().equalsIgnoreCase(entityId)) continue;
                IDataEntityType grandpa = father.getParent();
                if (grandpa.getName().equalsIgnoreCase(entityId)) {
                    includeEntryField = true;
                    entryFather = father;
                    continue;
                }
                IDataEntityType grandpaFather = grandpa.getParent();
                if (!grandpaFather.getName().equalsIgnoreCase(entityId)) continue;
                includeSubEntryField = true;
                subEntryFather = father;
            }
            if (includeSubEntryField && subEntryFather != null) {
                String subEntryEntityId = subEntryFather.getName();
                String entryEntityId = subEntryFather.getParent().getName();
                DynamicObjectCollection rows = this.bill.getDynamicObjectCollection(entryEntityId);
                RowDataModel rowDataModel = new RowDataModel(subEntryEntityId, (MainEntityType)this.bill.getDataEntityType());
                values = new ArrayList<Object>();
                for (DynamicObject row : rows) {
                    DynamicObjectCollection subEntryData = row.getDynamicObjectCollection(subEntryEntityId);
                    int index = 0;
                    for (DynamicObject subEntry : subEntryData) {
                        ExpressionParameter rowParameter = new ExpressionParameter(formula.getExpression(), rowDataModel);
                        rowParameter.setActiveRow((Object)subEntry);
                        rowParameter.setRowIndex(index++);
                        values.add(new BigDecimal(CalcExprParser.getExpressionValue((ExpressionParameter)rowParameter).toString()));
                    }
                }
                budgetRegModel.setFieldRegValue(values);
            } else if (includeEntryField && entryFather != null) {
                String entryEntityId = entryFather.getName();
                DynamicObjectCollection rows = this.bill.getDynamicObjectCollection(entryEntityId);
                RowDataModel rowDataModel = new RowDataModel(rows.getDynamicObjectType().getName(), (MainEntityType)this.bill.getDataEntityType());
                int index = 0;
                values = new ArrayList();
                for (DynamicObject row : rows) {
                    ExpressionParameter rowParameter = new ExpressionParameter(formula.getExpression(), rowDataModel);
                    rowParameter.setActiveRow((Object)row);
                    rowParameter.setRowIndex(index++);
                    values.add(new BigDecimal(CalcExprParser.getExpressionValue((ExpressionParameter)rowParameter).toString()));
                }
                budgetRegModel.setFieldRegValue(values);
            } else {
                RowDataModel dataModel = new RowDataModel(this.bill.getDynamicObjectType().getName(), (MainEntityType)this.bill.getDataEntityType());
                ExpressionParameter parameter = new ExpressionParameter(formula.getExpression(), dataModel);
                parameter.setActiveRow((Object)this.bill);
                Object v = CalcExprParser.getExpressionValue((ExpressionParameter)parameter);
                ArrayList<Object> values2 = new ArrayList<Object>();
                values2.add(new BigDecimal(v.toString()));
                budgetRegModel.setFieldRegValue(values2);
            }
        } else if (IdentifyValueEnum.CONSTANT.getValue().equals(identify)) {
            ArrayList<Object> values = new ArrayList<Object>();
            Object value = budgetRegModel.getDefaultValue();
            if (BillFieldTypeEnum.BUDGETTYPE.getNumber().equals(budgetRegModel.getFieldType().getNumber())) {
                values.add(value);
                budgetRegModel.setFieldValue(values);
            }
            if (BillFieldTypeEnum.BUDGET.getNumber().equals(budgetRegModel.getFieldType().getNumber())) {
                DynamicObject budget = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(value.toString()), (String)"pmas_projectbudget");
                values.add(budget);
                budgetRegModel.setFieldValue(values);
            }
            if (BillFieldTypeEnum.PERIOD.getNumber().equals(budgetRegModel.getFieldType().getNumber())) {
                DynamicObject period = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(value.toString()), (String)"bd_period");
                values.add(period);
                budgetRegModel.setFieldValue(values);
            }
            if (BillFieldTypeEnum.AMOUNT.getNumber().equals(budgetRegModel.getFieldType().getNumber())) {
                values.add(value);
                budgetRegModel.setFieldValue(values);
            }
        }
    }

    private void getCollectionValue(String fieldKey, List<Object> result, DynamicObject data) {
        String[] splits = fieldKey.split("\\.");
        if (splits.length == 1) {
            if (StringUtils.isNotEmpty((CharSequence)splits[0])) {
                result.add(data.get(splits[0]));
            }
            return;
        }
        if (splits.length == 2) {
            DynamicObjectCollection entries = data.getDynamicObjectCollection(splits[0]);
            for (DynamicObject entry : entries) {
                result.add(entry.get(splits[1]));
            }
            return;
        }
        if (splits.length == 3) {
            DynamicObjectCollection entries = data.getDynamicObjectCollection(splits[0]);
            for (DynamicObject entry : entries) {
                DynamicObjectCollection subEntries = entry.getDynamicObjectCollection(splits[1]);
                for (DynamicObject subEntry : subEntries) {
                    result.add(subEntry.get(splits[2]));
                }
            }
        }
    }
}

