/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.common.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.List;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.utils.poi.POIHelper;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.DVConstraint;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFDataValidation;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Name;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.usermodel.XSSFDataValidation;

public class ContractListingPOIHelper {
    private static final Log LOG = LogFactory.getLog(ContractListingPOIHelper.class);

    public static String exportExcel(String fileName, String sheetName, JSONArray header, JSONArray data) {
        int i;
        int taxrateIndex;
        int amountIndex;
        int measureunitIndex;
        int materialIndex;
        int listnumber;
        List columnKeyList = POIHelper.getColumnKeys((JSONArray)header);
        if (columnKeyList.isEmpty()) {
            return null;
        }
        List columnNameList = POIHelper.getColumnNames((JSONArray)header);
        if (columnNameList.isEmpty()) {
            return null;
        }
        List mustFillColumn = POIHelper.getMustFillColumn((JSONArray)header);
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet(sheetName);
        HSSFRow columnKeyHashRow = sheet.createRow(0);
        columnKeyHashRow.setHeight((short)0);
        Cell columnKeyHashCell = columnKeyHashRow.createCell(0);
        HSSFCellStyle columnKeyHashCellCss = wb.createCellStyle();
        HSSFDataFormat columnKeyHashCellFormat = wb.createDataFormat();
        columnKeyHashCellCss.setDataFormat(columnKeyHashCellFormat.getFormat("@"));
        columnKeyHashCell.setCellStyle((CellStyle)columnKeyHashCellCss);
        columnKeyHashCell.setCellValue((double)columnKeyList.toString().hashCode());
        HSSFRow columnKeyRow = sheet.createRow(1);
        columnKeyRow.setHeight((short)0);
        HSSFRow nameRow = sheet.createRow(2);
        int sysnumIndex = columnKeyList.indexOf("sysnumber");
        if (sysnumIndex >= 0) {
            sheet.addValidationData((DataValidation)ContractListingPOIHelper.setTip("sysnumber", 3, 3, sysnumIndex, sysnumIndex, ResManager.loadKDString((String)"\u8bbe\u7f6e\u7cfb\u7edf\u7f16\u7801\uff0c\u8bf7\u4f7f\u7528\u201c.\u201d\u4f5c\u4e3a\u4e0a\u4e0b\u7ea7\u5206\u9694\u7b26\u3002\u3002", (String)"ContractListingPOIHelper_10", (String)"pmgt-pmct-common", (Object[])new Object[0])));
        }
        if ((listnumber = columnKeyList.indexOf("listnumber")) >= 0) {
            sheet.addValidationData((DataValidation)ContractListingPOIHelper.setTip("listnumber", 3, 3, listnumber, listnumber, ResManager.loadKDString((String)"\u6587\u672c\u683c\u5f0f", (String)"ContractListingPOIHelper_1", (String)"pmgt-pmct-common", (Object[])new Object[0])));
        }
        if ((materialIndex = columnKeyList.indexOf("material")) >= 0) {
            sheet.addValidationData((DataValidation)ContractListingPOIHelper.setTip("material", 3, 3, materialIndex, materialIndex, ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\u7684\u7269\u6599\u7f16\u7801", (String)"ContractListingPOIHelper_2", (String)"pmgt-pmct-common", (Object[])new Object[0])));
        }
        if ((measureunitIndex = columnKeyList.indexOf("measureunit")) >= 0) {
            sheet.addValidationData((DataValidation)ContractListingPOIHelper.setTip("measureunit", 3, 3, measureunitIndex, measureunitIndex, ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\u7684\u8ba1\u91cf\u5355\u4f4d\u540d\u79f0", (String)"ContractListingPOIHelper_3", (String)"pmgt-pmct-common", (Object[])new Object[0])));
        }
        if ((amountIndex = columnKeyList.indexOf("amount")) != -1) {
            sheet.addValidationData((DataValidation)ContractListingPOIHelper.setTip("amount", 3, 3, amountIndex, amountIndex, ResManager.loadKDString((String)"\u5bfc\u5165\u7cfb\u7edf\u65f6\uff0c\u53ef\u81ea\u52a8\u6839\u636e[\u91d1\u989d=\u5355\u4ef7*\u6570\u91cf]\u516c\u5f0f\u8ba1\u7b97", (String)"ContractListingPOIHelper_4", (String)"pmgt-pmct-common", (Object[])new Object[0])));
        }
        if ((taxrateIndex = columnKeyList.indexOf("rate")) != -1) {
            QFilter taxrateFiler = new QFilter("status", "=", (Object)StatusEnum.CHECKED.getValue());
            DynamicObject[] taxrateCol = BusinessDataServiceHelper.load((String)"bd_taxrate", (String)"number,name,taxrate", (QFilter[])new QFilter[]{taxrateFiler});
            int len = taxrateCol.length;
            String[] dataList = new String[len];
            for (i = 0; i < len; ++i) {
                BigDecimal taxrate = taxrateCol[i].getBigDecimal("taxrate");
                dataList[i] = String.valueOf(taxrate);
            }
            ContractListingPOIHelper.setDropDownAndHidden((Workbook)wb, sheetName, 3, 200, taxrateIndex, taxrateIndex, dataList);
        }
        HSSFCellStyle titleCellStyle = wb.createCellStyle();
        titleCellStyle.setAlignment(HorizontalAlignment.CENTER);
        titleCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        titleCellStyle.setBorderTop(BorderStyle.THIN);
        titleCellStyle.setBorderLeft(BorderStyle.THIN);
        titleCellStyle.setBorderRight(BorderStyle.THIN);
        titleCellStyle.setBorderBottom(BorderStyle.THIN);
        titleCellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        titleCellStyle.setFillForegroundColor(IndexedColors.PALE_BLUE.getIndex());
        Cell columnKeyCell = null;
        Cell nameCell = null;
        for (int i2 = 0; i2 < columnNameList.size(); ++i2) {
            try {
                sheet.setColumnWidth(i2, ((String)columnNameList.get(i2)).getBytes("UTF-8").length * 2 * 256);
            }
            catch (UnsupportedEncodingException e) {
                LOG.error((Throwable)e);
            }
            columnKeyCell = columnKeyRow.createCell(i2);
            columnKeyCell.setCellValue((String)columnKeyList.get(i2));
            if (!("qty".equals(columnKeyList.get(i2)) || "price".equals(columnKeyList.get(i2)) || "taxrate".equals(columnKeyList.get(i2)) || "amount".equals(columnKeyList.get(i2)))) {
                HSSFCellStyle css = wb.createCellStyle();
                HSSFDataFormat format = wb.createDataFormat();
                css.setDataFormat(format.getFormat("@"));
                sheet.setDefaultColumnStyle(i2, (CellStyle)css);
            }
            columnKeyCell.setCellStyle((CellStyle)titleCellStyle);
            nameCell = nameRow.createCell(i2);
            if (mustFillColumn.contains(columnKeyList.get(i2))) {
                HSSFCellStyle mustFillColumnStyle = wb.createCellStyle();
                mustFillColumnStyle.setAlignment(HorizontalAlignment.CENTER);
                mustFillColumnStyle.setVerticalAlignment(VerticalAlignment.CENTER);
                mustFillColumnStyle.setBorderTop(BorderStyle.THIN);
                mustFillColumnStyle.setBorderLeft(BorderStyle.THIN);
                mustFillColumnStyle.setBorderRight(BorderStyle.THIN);
                mustFillColumnStyle.setBorderBottom(BorderStyle.THIN);
                mustFillColumnStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                mustFillColumnStyle.setFillForegroundColor(IndexedColors.PALE_BLUE.getIndex());
                HSSFFont mheadFont = wb.createFont();
                mheadFont.setColor(IndexedColors.RED.getIndex());
                mustFillColumnStyle.setFont((Font)mheadFont);
                nameCell.setCellValue((String)columnNameList.get(i2) + "*");
                nameCell.setCellStyle((CellStyle)mustFillColumnStyle);
                continue;
            }
            nameCell.setCellValue((String)columnNameList.get(i2));
            nameCell.setCellStyle((CellStyle)titleCellStyle);
        }
        HSSFCellStyle cellStyle = wb.createCellStyle();
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        cellStyle.setBorderBottom(BorderStyle.THIN);
        if (data != null && !data.isEmpty()) {
            for (i = 0; i < data.size(); ++i) {
                JSONObject jsonObject = data.getJSONObject(i);
                nameRow = sheet.createRow(i + 3);
                for (int j = 0; j < columnKeyList.size(); ++j) {
                    nameCell = nameRow.createCell(j);
                    nameCell.setCellValue(jsonObject.get(columnKeyList.get(j)) == null ? null : jsonObject.getString((String)columnKeyList.get(j)));
                    nameCell.setCellStyle((CellStyle)cellStyle);
                }
            }
        }
        fileName = StringUtils.isBlank((CharSequence)fileName) ? System.currentTimeMillis() + ".xls" : fileName + ".xls";
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            wb.write((OutputStream)os);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        byte[] content = os.toByteArray();
        ByteArrayInputStream in = new ByteArrayInputStream(content);
        String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, (InputStream)in, 5000);
        try {
            wb.close();
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        return url;
    }

    public static JSONArray inputExcel(String url, String coulmnHashCode) {
        JSONArray jsonArray = new JSONArray();
        if (StringUtils.isNotBlank((CharSequence)url)) {
            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            InputStream in = cache.getInputStream(url);
            try {
                POIFSFileSystem fs = new POIFSFileSystem(in);
                HSSFWorkbook wb = new HSSFWorkbook(fs);
                HSSFSheet sheet = wb.getSheetAt(0);
                int rowNum = sheet.getLastRowNum();
                HSSFRow columnKeyRow = sheet.getRow(1);
                HSSFRow headerRow = sheet.getRow(2);
                HSSFRow columnKeyHashRow = sheet.getRow(0);
                if (columnKeyHashRow == null || columnKeyHashRow.getCell(0) == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6a21\u677f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4f7f\u7528\u5bfc\u51fa\u7684\u6a21\u677f\u3002", (String)"ContractListingPOIHelper_12", (String)"pmgt-pmct-common", (Object[])new Object[0]));
                }
                columnKeyHashRow.getCell(0).setCellType(CellType.STRING);
                String columnKeyHashCellValue = columnKeyHashRow.getCell(0).getStringCellValue();
                if (!StringUtils.equals((CharSequence)columnKeyHashCellValue, (CharSequence)coulmnHashCode)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6a21\u677f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4f7f\u7528\u5bfc\u51fa\u7684\u6a21\u677f\u3002", (String)"ContractListingPOIHelper_12", (String)"pmgt-pmct-common", (Object[])new Object[0]));
                }
                int columnNum = columnKeyRow.getLastCellNum();
                for (int j = 3; j <= rowNum; ++j) {
                    JSONArray jsonRow = new JSONArray();
                    for (int i = 0; i < columnNum; ++i) {
                        HSSFRow irow = sheet.getRow(j);
                        JSONObject jsonObject = new JSONObject();
                        columnKeyRow.getCell(i).setCellType(CellType.STRING);
                        headerRow.getCell(i).setCellType(CellType.STRING);
                        jsonObject.put("columnKey", (Object)columnKeyRow.getCell(i).getStringCellValue());
                        jsonObject.put("columnName", (Object)headerRow.getCell(i).getStringCellValue());
                        String value = "";
                        if (irow.getCell(i) != null) {
                            irow.getCell(i).setCellType(CellType.STRING);
                            value = irow.getCell(i).getStringCellValue();
                        }
                        jsonObject.put("cellValue", (Object)value);
                        jsonRow.add((Object)jsonObject);
                    }
                    jsonArray.add((Object)jsonRow);
                }
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        return jsonArray;
    }

    public static HSSFDataValidation setTip(String key, int firstRow, int lastRow, int firstCol, int lastCol, String tip) {
        CellRangeAddressList addressList = new CellRangeAddressList(firstRow, lastRow, firstCol, lastCol);
        DVConstraint dvConstraint = null;
        dvConstraint = DVConstraint.createCustomFormulaConstraint((String)"BB1");
        HSSFDataValidation dataValidation = new HSSFDataValidation(addressList, (DataValidationConstraint)dvConstraint);
        dataValidation.createErrorBox(ResManager.loadKDString((String)"\u9519\u8bef\u63d0\u793a", (String)"ContractListingPOIHelper_6", (String)"pmgt-pmct-common", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8f93\u5165\u7684\u683c\u5f0f\u4e0d\u7b26\u5408\u89c4\u8303\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"ContractListingPOIHelper_11", (String)"pmgt-pmct-common", (Object[])new Object[0]));
        dataValidation.setSuppressDropDownArrow(false);
        if (tip != null) {
            dataValidation.createPromptBox(ResManager.loadKDString((String)"\u8f93\u5165\u63d0\u793a", (String)"ContractListingPOIHelper_8", (String)"pmgt-pmct-common", (Object[])new Object[0]), tip);
        }
        dataValidation.setShowPromptBox(true);
        return dataValidation;
    }

    public static Workbook setDropDownAndHidden(Workbook workbook, String sheetName, int firstRow, int lastRow, int firstCol, int lastCol, String[] formulaString) {
        Sheet sheet = workbook.getSheet(sheetName);
        Sheet hideSheet = workbook.createSheet("hiddenSheet");
        for (int i = 0; i < formulaString.length; ++i) {
            hideSheet.createRow(i).createCell(0).setCellValue(formulaString[i]);
        }
        Name category1Name = workbook.createName();
        category1Name.setNameName("rate");
        category1Name.setRefersToFormula("hiddenSheet!$A$1:$A$" + formulaString.length);
        DataValidationHelper helper = sheet.getDataValidationHelper();
        DataValidationConstraint constraint = helper.createFormulaListConstraint("rate");
        CellRangeAddressList addressList = new CellRangeAddressList(firstRow, lastRow, firstCol, lastCol);
        DataValidation dataValidation = helper.createValidation(constraint, addressList);
        if (dataValidation instanceof XSSFDataValidation) {
            dataValidation.setSuppressDropDownArrow(true);
            dataValidation.setShowErrorBox(true);
        } else {
            dataValidation.setSuppressDropDownArrow(false);
        }
        sheet.addValidationData(dataValidation);
        workbook.setSheetHidden(1, true);
        return workbook;
    }
}

