/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.common.utils;

import com.alibaba.fastjson.JSONObject;
import java.text.SimpleDateFormat;
import java.util.Date;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.pmgt.pmct.common.utils.AES128;
import kd.pmgt.pmct.common.utils.HttpClientUtils;
import org.apache.commons.codec.digest.DigestUtils;

public class InvoiceUtils {
    private static Log log = LogFactory.getLog(InvoiceUtils.class);

    public static String getToken(String appId, String appSecret, String invoiceUrl) {
        long timestamp = System.currentTimeMillis();
        String tokenUrl = invoiceUrl + "/base/oauth/token";
        String sign = DigestUtils.md5Hex((String)(appId + appSecret + timestamp));
        JSONObject object = new JSONObject();
        object.put("client_id", (Object)appId);
        object.put("sign", (Object)sign);
        object.put("timestamp", (Object)timestamp);
        String response = HttpClientUtils.HttpPostWithJson(tokenUrl, object.toJSONString());
        return response;
    }

    public static String queryInvoiceInfo(String accessToken, String encryptKey, Date beginDate, Date endDate, String invoiceType, String invoiceUrl, String pageSize) {
        String interfaceUrl = invoiceUrl + "/m6/bill/invoice/query?access_token=" + accessToken;
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("startTime", (Object)format.format(beginDate));
        jsonObject.put("endTime", (Object)format.format(endDate));
        jsonObject.put("pageNo", (Object)"");
        jsonObject.put("pageSize", (Object)pageSize);
        if (!StringUtils.isEmpty((CharSequence)invoiceType)) {
            jsonObject.put("invoiceTypes", (Object)invoiceType);
        }
        String encryptStr = "";
        try {
            encryptStr = AES128.encrypt(jsonObject.toJSONString(), encryptKey);
        }
        catch (Exception e) {
            log.info("info", (Object)e);
        }
        String response = "";
        try {
            response = HttpClientUtils.HttpPostWithJson(interfaceUrl, encryptStr);
        }
        catch (Exception e) {
            log.info("info", (Object)e);
        }
        return response;
    }

    public static String queryOutInvoiceInfo(String accessToken, String encryptKey, Date beginDate, Date endDate, String invoiceType, String taxNo, String invoiceUrl) {
        String interfaceUrl = invoiceUrl + "/m7/bill/invoice/items/query?access_token=" + accessToken;
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("startTime", (Object)format.format(beginDate));
        jsonObject.put("endTime", (Object)format.format(endDate));
        jsonObject.put("pageNo", (Object)"1");
        jsonObject.put("pageSize", (Object)"500");
        jsonObject.put("taxNo", (Object)taxNo);
        if (!StringUtils.isEmpty((CharSequence)invoiceType)) {
            jsonObject.put("invoiceType", (Object)invoiceType);
        }
        String encryptStr = "";
        try {
            encryptStr = AES128.encrypt(jsonObject.toJSONString(), encryptKey);
        }
        catch (Exception e) {
            log.error("AESExceptionInfo\uff1a{}", (Object)e.getMessage());
        }
        String response = "";
        try {
            response = HttpClientUtils.HttpPostWithJson(interfaceUrl, encryptStr);
            log.info("response\uff1a{}", (Object)response);
        }
        catch (Exception e) {
            log.error("PostExceptionInfo\uff1a{}", (Object)e.getMessage());
        }
        return response;
    }
}

