/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.common.utils;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.FieldEdit;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmct.common.utils.ListingColumnKeyMappingHelper;

public class ListingColumnShowHelper {
    public static void setContractListingColumnVisible(IFormView view, String entryKey, String listingModelId) {
        ListingColumnShowHelper.setVisible(view, entryKey, listingModelId);
    }

    public static void setSettleListingColumnVisible(IFormView view, String entryKey, String listingModelId) {
        ListingColumnShowHelper.setVisible(view, entryKey, listingModelId);
    }

    public static void setVisible(IFormView view, String entryKey, String listingModelId) {
        ListingColumnShowHelper.setVisible(view, entryKey, listingModelId, -1);
    }

    public static void setVisible(IFormView view, String entryKey, String listingModelId, int type) {
        ListingColumnShowHelper.setVisible(view, entryKey, listingModelId, type, false);
    }

    public static void setVisible(IFormView view, String entryKey, String listingModelId, int type, boolean isInPayDirection) {
        if (listingModelId == null || "".equals(listingModelId.trim())) {
            return;
        }
        List<DynamicObject> entryConfigs = ListingColumnShowHelper.getListingModelConfigs(listingModelId);
        EntryGrid grid = (EntryGrid)view.getControl(entryKey);
        if (type == -1) {
            type = ListingColumnShowHelper.getFormType(view);
        }
        if (type != 1 && type != 4 && type != 5) {
            if (listingModelId == null || "".equals(listingModelId.trim())) {
                view.setVisible(Boolean.TRUE, new String[]{ListingColumnKeyMappingHelper.getColumnKey("directfee", type)});
                view.setVisible(Boolean.TRUE, new String[]{ListingColumnKeyMappingHelper.getColumnKey("manfee", type)});
                view.setVisible(Boolean.TRUE, new String[]{ListingColumnKeyMappingHelper.getColumnKey("equfee", type)});
                view.setVisible(Boolean.TRUE, new String[]{ListingColumnKeyMappingHelper.getColumnKey("manequfee", type)});
                view.setVisible(Boolean.TRUE, new String[]{ListingColumnKeyMappingHelper.getColumnKey("tmpfee", type)});
                return;
            }
            view.setVisible(Boolean.FALSE, new String[]{ListingColumnKeyMappingHelper.getColumnKey("directfee", type)});
            view.setVisible(Boolean.FALSE, new String[]{ListingColumnKeyMappingHelper.getColumnKey("manfee", type)});
            view.setVisible(Boolean.FALSE, new String[]{ListingColumnKeyMappingHelper.getColumnKey("equfee", type)});
            view.setVisible(Boolean.FALSE, new String[]{ListingColumnKeyMappingHelper.getColumnKey("manequfee", type)});
            view.setVisible(Boolean.FALSE, new String[]{ListingColumnKeyMappingHelper.getColumnKey("tmpfee", type)});
        }
        boolean showNumber = false;
        boolean showMaterial = false;
        boolean showResource = false;
        for (DynamicObject obj : entryConfigs) {
            String fieldNumber = obj.getString("propnum");
            String fieldKey = ListingColumnKeyMappingHelper.getColumnKey(fieldNumber, type);
            if (fieldKey == null) continue;
            boolean isShowed = obj.getBoolean("isshowed");
            if (isShowed) {
                switch (fieldNumber) {
                    case "listnumber": {
                        showNumber = true;
                        showMaterial = false;
                        showResource = false;
                        break;
                    }
                    case "materiel": {
                        showNumber = false;
                        showMaterial = true;
                        showResource = false;
                        break;
                    }
                    case "resourceitem": {
                        showNumber = false;
                        showMaterial = false;
                        showResource = true;
                        break;
                    }
                    case "contlistnumber": 
                    case "contlistname": {
                        if (!isInPayDirection) break;
                        isShowed = false;
                        break;
                    }
                }
            }
            view.setVisible(Boolean.valueOf(isShowed), new String[]{fieldKey});
            if ("materiel".equals(fieldNumber)) {
                view.setVisible(Boolean.valueOf(isShowed), new String[]{ListingColumnKeyMappingHelper.getColumnKey("materialmodel", type)});
            } else if ("resourceitem".equals(fieldNumber)) {
                view.setVisible(Boolean.valueOf(isShowed), new String[]{ListingColumnKeyMappingHelper.getColumnKey("resourcemodel", type)});
            }
            String fieldName = obj.getString("fieldname");
            grid.setColumnProperty(fieldKey, "header", (Object)new LocaleString(fieldName));
        }
        if (type == 0) {
            ListingColumnShowHelper.setContractFieldMustInput(view, showNumber, showMaterial, showResource);
        } else if (type == 2) {
            ListingColumnShowHelper.setFieldMustInput(view, showNumber, showMaterial, showResource);
        }
    }

    private static int getFormType(IFormView view) {
        switch (view.getFormShowParameter().getFormId()) {
            case "ec_in_contract": 
            case "ec_out_contract": {
                return 0;
            }
            case "ec_in_contract_settle": 
            case "ec_out_contract_settle": {
                return 1;
            }
            case "ec_inrevision": 
            case "ec_outrevision": {
                return 2;
            }
            case "ec_treelistinglist": {
                return 3;
            }
        }
        return -1;
    }

    private static void setFieldMustInput(IFormView view, boolean showNumber, boolean showMaterial, boolean showResource) {
        if (showNumber) {
            ((FieldEdit)view.getControl(ListingColumnKeyMappingHelper.getColumnKey("listnumber", 2))).setMustInput(true);
            ((FieldEdit)view.getControl(ListingColumnKeyMappingHelper.getColumnKey("listname", 2))).setMustInput(true);
            ((FieldEdit)view.getControl(ListingColumnKeyMappingHelper.getColumnKey("materiel", 2))).setMustInput(false);
            ((FieldEdit)view.getControl(ListingColumnKeyMappingHelper.getColumnKey("resourceitem", 2))).setMustInput(false);
            ((FieldEdit)view.getControl("measureunit")).setMustInput(false);
            ((FieldEdit)view.getControl("qty")).setMustInput(false);
            ((FieldEdit)view.getControl("price")).setMustInput(false);
            ((FieldEdit)view.getControl("amount")).setMustInput(false);
        } else if (showMaterial) {
            ((FieldEdit)view.getControl(ListingColumnKeyMappingHelper.getColumnKey("listnumber", 2))).setMustInput(false);
            ((FieldEdit)view.getControl(ListingColumnKeyMappingHelper.getColumnKey("listname", 2))).setMustInput(false);
            ((FieldEdit)view.getControl(ListingColumnKeyMappingHelper.getColumnKey("materiel", 2))).setMustInput(true);
            ((FieldEdit)view.getControl(ListingColumnKeyMappingHelper.getColumnKey("resourceitem", 2))).setMustInput(false);
            ((FieldEdit)view.getControl("measureunit")).setMustInput(true);
            ((FieldEdit)view.getControl("qty")).setMustInput(true);
            ((FieldEdit)view.getControl("price")).setMustInput(true);
            ((FieldEdit)view.getControl("amount")).setMustInput(true);
        } else if (showResource) {
            ((FieldEdit)view.getControl(ListingColumnKeyMappingHelper.getColumnKey("listnumber", 2))).setMustInput(false);
            ((FieldEdit)view.getControl(ListingColumnKeyMappingHelper.getColumnKey("listname", 2))).setMustInput(false);
            ((FieldEdit)view.getControl(ListingColumnKeyMappingHelper.getColumnKey("materiel", 2))).setMustInput(false);
            ((FieldEdit)view.getControl(ListingColumnKeyMappingHelper.getColumnKey("resourceitem", 2))).setMustInput(true);
            ((FieldEdit)view.getControl("measureunit")).setMustInput(true);
            ((FieldEdit)view.getControl("qty")).setMustInput(true);
            ((FieldEdit)view.getControl("price")).setMustInput(true);
            ((FieldEdit)view.getControl("amount")).setMustInput(true);
        }
    }

    private static void setContractFieldMustInput(IFormView view, boolean showNumber, boolean showMaterial, boolean showResource) {
        if (showNumber) {
            ((FieldEdit)view.getControl(ListingColumnKeyMappingHelper.getColumnKey("listnumber", 0))).setMustInput(true);
            ((FieldEdit)view.getControl(ListingColumnKeyMappingHelper.getColumnKey("listname", 0))).setMustInput(true);
            ((FieldEdit)view.getControl(ListingColumnKeyMappingHelper.getColumnKey("materiel", 0))).setMustInput(false);
            ((FieldEdit)view.getControl(ListingColumnKeyMappingHelper.getColumnKey("resourceitem", 0))).setMustInput(false);
            ((FieldEdit)view.getControl("treemeasureunit")).setMustInput(false);
            ((FieldEdit)view.getControl("treeqty")).setMustInput(false);
            ((FieldEdit)view.getControl("treeprice")).setMustInput(false);
            ((FieldEdit)view.getControl("treeamount")).setMustInput(false);
        } else if (showMaterial) {
            ((FieldEdit)view.getControl(ListingColumnKeyMappingHelper.getColumnKey("listnumber", 0))).setMustInput(false);
            ((FieldEdit)view.getControl(ListingColumnKeyMappingHelper.getColumnKey("listname", 0))).setMustInput(false);
            ((FieldEdit)view.getControl(ListingColumnKeyMappingHelper.getColumnKey("materiel", 0))).setMustInput(true);
            ((FieldEdit)view.getControl(ListingColumnKeyMappingHelper.getColumnKey("resourceitem", 0))).setMustInput(false);
            ((FieldEdit)view.getControl("treemeasureunit")).setMustInput(true);
            ((FieldEdit)view.getControl("treeqty")).setMustInput(true);
            ((FieldEdit)view.getControl("treeprice")).setMustInput(true);
            ((FieldEdit)view.getControl("treeamount")).setMustInput(true);
        } else if (showResource) {
            ((FieldEdit)view.getControl(ListingColumnKeyMappingHelper.getColumnKey("listnumber", 0))).setMustInput(false);
            ((FieldEdit)view.getControl(ListingColumnKeyMappingHelper.getColumnKey("listname", 0))).setMustInput(false);
            ((FieldEdit)view.getControl(ListingColumnKeyMappingHelper.getColumnKey("resourceitem", 0))).setMustInput(true);
            ((FieldEdit)view.getControl(ListingColumnKeyMappingHelper.getColumnKey("materiel", 0))).setMustInput(false);
            ((FieldEdit)view.getControl("treemeasureunit")).setMustInput(true);
            ((FieldEdit)view.getControl("treeqty")).setMustInput(true);
            ((FieldEdit)view.getControl("treeprice")).setMustInput(true);
            ((FieldEdit)view.getControl("treeamount")).setMustInput(true);
        }
    }

    private static List<DynamicObject> getListingModelConfigs(String listingModelId) {
        DynamicObject model = BusinessDataServiceHelper.loadSingle((Object)listingModelId, (String)"ec_listingmodel");
        DynamicObjectCollection entryConfigs = model.getDynamicObjectCollection("entryentity");
        return entryConfigs;
    }
}

