/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.common.utils;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.utils.MetadataUtil;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;

public class RichEditorUtils {
    private static final String FIELDSELECTOR = "span[class$=-fieldclass]";
    private static final String ENTRYSELECTOR = "table[class$=-entryclass]";
    private static final String LISTSELECTOR = "table[class$=-listingclass]";
    private static final String PRIVATEINFOSELECTOR = "span[class$=-privateinfoclass]";

    public static Element createTd(Document document) {
        Element td = document.createElement("td");
        td.attr("width", "120");
        td.attr("valign", "top");
        td.attr("style", "word-break: break-all;text-align:center");
        return td;
    }

    public static String initpBlock(DynamicObject object) {
        String pString = "<p>{<span class=\"" + object.getString("billtypename") + "-" + object.getString("fieldname") + "-fieldclass\" style=\"line-height: 25px;font-size: 12px;font-weight: normal;\">" + object.getString("name") + "</span>}</p>";
        return pString;
    }

    public static String initPrivateInfoBlock(DynamicObject fieldConfig) {
        String pString = "<p>{<span class=\"" + fieldConfig.getString("billtypename") + "-" + fieldConfig.getString("fieldname") + "-privateinfoclass\" style=\"line-height: 25px;font-size: 12px;font-weight: normal;\">" + fieldConfig.getString("name") + "</span>}</p>";
        return pString;
    }

    public static String initListingControl(List<String> aimStringList) {
        Document document = new Document("");
        List<Map<String, String>> listDisplayNameMapList = RichEditorUtils.getListPropDisplayNameMapList("ec_listing", aimStringList);
        Element tabElement = document.createElement("table");
        tabElement.addClass("ec_listing-class");
        Element tbody = document.createElement("tbody");
        Element trElement = document.createElement("tr");
        trElement.addClass("firstRow");
        Element trElement1 = document.createElement("tr");
        for (int i = 0; i < listDisplayNameMapList.size(); ++i) {
            Element td = RichEditorUtils.createTd(document);
            td.text(listDisplayNameMapList.get(i).get("propDisplayName"));
            trElement.appendChild((Node)td);
            Element td1 = RichEditorUtils.createTd(document);
            String spanString = "{<span class=\"" + listDisplayNameMapList.get(i).get("propname") + "\" style=\"line-height: 25px;font-size: 12px;font-weight: normal;\">" + listDisplayNameMapList.get(i).get("propDisplayName") + "</span>}";
            td1.html(spanString);
            trElement1.appendChild((Node)td1);
        }
        tbody.appendChild((Node)trElement);
        tbody.appendChild((Node)trElement1);
        tabElement.appendChild((Node)tbody);
        return tabElement.toString();
    }

    public static List<String> getFieldListByListModel(Object listModelId) {
        ArrayList<String> fieldList = new ArrayList<String>();
        DynamicObject listingmodel = BusinessDataServiceHelper.loadSingle((Object)listModelId, (String)"pmct_listingmodel");
        DynamicObjectCollection entryCol = listingmodel.getDynamicObjectCollection("entryentity");
        for (int i = 0; i < entryCol.size(); ++i) {
            DynamicObject entry = (DynamicObject)entryCol.get(i);
            boolean isShowed = entry.getBoolean("isshowed");
            if (!isShowed) continue;
            String fieldKey = RichEditorUtils.getAimString(entry.getString("propnum"));
            fieldList.add(fieldKey);
        }
        return fieldList;
    }

    public static String initListingControlByListModel(DynamicObject listModel) {
        Document document = new Document("");
        Element tabElement = document.createElement("table");
        tabElement.addClass(listModel.getString("id") + "-listingclass");
        Element tbody = document.createElement("tbody");
        Element trElement = document.createElement("tr");
        trElement.addClass("firstRow");
        Element trElement1 = document.createElement("tr");
        tbody.appendChild((Node)trElement);
        tbody.appendChild((Node)trElement1);
        tabElement.appendChild((Node)tbody);
        return tabElement.toString();
    }

    private static String getAimString(String string) {
        String fieldKey;
        switch (fieldKey = string) {
            case "listnumber": {
                fieldKey = "number";
                break;
            }
            case "listname": {
                fieldKey = "name";
                break;
            }
            case "contlistnumber": {
                fieldKey = "contlistnumber-number";
                break;
            }
            case "contlistname": {
                fieldKey = "contlistnumber-name";
                break;
            }
            case "materiel": {
                fieldKey = "material-number";
                break;
            }
            case "materielname": {
                fieldKey = "material-name";
                break;
            }
            case "rate": {
                fieldKey = "taxrate";
                break;
            }
            case "sublistmodelid": {
                fieldKey = "listingmodel";
                break;
            }
        }
        return fieldKey;
    }

    public static List<Map<String, String>> getListPropDisplayNameMapList(String billFormId, List<String> aimStringList) {
        ArrayList<Map<String, String>> listPropMapList = new ArrayList<Map<String, String>>();
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)billFormId);
        for (int i = 0; i < aimStringList.size(); ++i) {
            Map<String, String> map1;
            DynamicProperty entryProperty = dt.getProperty(aimStringList.get(i));
            if (entryProperty != null) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("propname", entryProperty.getName());
                LocaleString xLocaleString = entryProperty.getDisplayName();
                if (xLocaleString == null) continue;
                map.put("propDisplayName", "" + xLocaleString);
                listPropMapList.add(map);
                continue;
            }
            if (StringUtils.equals((CharSequence)"resourceitem", (CharSequence)aimStringList.get(i))) {
                map1 = RichEditorUtils.initMap("resourceitem-number", ResManager.loadKDString((String)"\u8d44\u6e90\u7f16\u7801", (String)"RichEditorUtils_0", (String)"pmgt-pmct-common", (Object[])new Object[0]));
                listPropMapList.add(map1);
                continue;
            }
            if (StringUtils.equals((CharSequence)"resname", (CharSequence)aimStringList.get(i))) {
                map1 = RichEditorUtils.initMap("resourceitem-name", ResManager.loadKDString((String)"\u8d44\u6e90\u540d\u79f0", (String)"RichEditorUtils_1", (String)"pmgt-pmct-common", (Object[])new Object[0]));
                listPropMapList.add(map1);
                continue;
            }
            if (StringUtils.equals((CharSequence)"boqnumber", (CharSequence)aimStringList.get(i))) {
                map1 = RichEditorUtils.initMap("boqnumber-number", ResManager.loadKDString((String)"\u5de5\u7a0b\u91cf\u6e05\u5355\u7f16\u7801", (String)"RichEditorUtils_2", (String)"pmgt-pmct-common", (Object[])new Object[0]));
                listPropMapList.add(map1);
                continue;
            }
            if (StringUtils.equals((CharSequence)"boqname", (CharSequence)aimStringList.get(i))) {
                map1 = RichEditorUtils.initMap("boqnumber-name", ResManager.loadKDString((String)"\u5de5\u7a0b\u91cf\u6e05\u5355\u540d\u79f0", (String)"RichEditorUtils_3", (String)"pmgt-pmct-common", (Object[])new Object[0]));
                listPropMapList.add(map1);
                continue;
            }
            if (StringUtils.equals((CharSequence)"contlistnumber", (CharSequence)aimStringList.get(i))) {
                map1 = RichEditorUtils.initMap("contlistnumber-number", ResManager.loadKDString((String)"\u6536\u5165\u5408\u540c\u6e05\u5355\u7f16\u7801", (String)"RichEditorUtils_4", (String)"pmgt-pmct-common", (Object[])new Object[0]));
                listPropMapList.add(map1);
                continue;
            }
            if (StringUtils.equals((CharSequence)"contlistname", (CharSequence)aimStringList.get(i))) {
                map1 = RichEditorUtils.initMap("contlistnumber-name", ResManager.loadKDString((String)"\u6536\u5165\u5408\u540c\u6e05\u5355\u540d\u79f0", (String)"RichEditorUtils_5", (String)"pmgt-pmct-common", (Object[])new Object[0]));
                listPropMapList.add(map1);
                continue;
            }
            if (StringUtils.equals((CharSequence)"materielnumber", (CharSequence)aimStringList.get(i))) {
                map1 = RichEditorUtils.initMap("materielnumber-number", ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801", (String)"RichEditorUtils_6", (String)"pmgt-pmct-common", (Object[])new Object[0]));
                listPropMapList.add(map1);
                continue;
            }
            if (!StringUtils.equals((CharSequence)"materielname", (CharSequence)aimStringList.get(i))) continue;
            map1 = RichEditorUtils.initMap("materielnumber-name", ResManager.loadKDString((String)"\u7269\u6599\u540d\u79f0", (String)"RichEditorUtils_7", (String)"pmgt-pmct-common", (Object[])new Object[0]));
            listPropMapList.add(map1);
        }
        return listPropMapList;
    }

    private static Map<String, String> initMap(String propName, String propDisPlayName) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("propname", propName);
        map.put("propDisplayName", propDisPlayName);
        return map;
    }

    public static String initTableControl(DynamicObject object) {
        Document document = new Document("");
        List<Map<String, String>> entryPropDisplayNameMapList = RichEditorUtils.getEntryPropDisplayNameMapList(object.getString("billtypename"), object.getString("fieldname"));
        Element tabElement = document.createElement("table");
        tabElement.addClass(object.getString("billtypename") + "-" + object.getString("fieldname") + "-entryclass");
        Element tbody = document.createElement("tbody");
        Element trElement = document.createElement("tr");
        trElement.addClass("firstRow");
        Element trElement1 = document.createElement("tr");
        for (int i = 0; i < entryPropDisplayNameMapList.size(); ++i) {
            Element td = RichEditorUtils.createTd(document);
            td.text(entryPropDisplayNameMapList.get(i).get("propDisplayName"));
            trElement.appendChild((Node)td);
            Element td1 = RichEditorUtils.createTd(document);
            String spanString = "{<span class=\"" + entryPropDisplayNameMapList.get(i).get("propname") + "\" style=\"line-height: 25px;font-size: 12px;font-weight: normal;\">" + entryPropDisplayNameMapList.get(i).get("propDisplayName") + "</span>}";
            td1.html(spanString);
            trElement1.appendChild((Node)td1);
        }
        tbody.appendChild((Node)trElement);
        tbody.appendChild((Node)trElement1);
        tabElement.appendChild((Node)tbody);
        return tabElement.toString();
    }

    public static String initListingTableControl(DynamicObject listModel, String billFormId, String entryId, String subEntryId) {
        Document document = new Document("");
        List<Map<String, String>> entryPropDisplayNameMapList = RichEditorUtils.getListEntryPropMapList(billFormId, entryId, subEntryId);
        Element tabElement = document.createElement("table");
        tabElement.addClass(billFormId + "-" + entryId + "-" + subEntryId + "-" + listModel.getString("id") + "-listingclass");
        Element tbody = document.createElement("tbody");
        Element trElement = document.createElement("tr");
        trElement.addClass("firstRow");
        Element trElement1 = document.createElement("tr");
        for (int i = 0; i < entryPropDisplayNameMapList.size(); ++i) {
            if ("enable".equals(entryPropDisplayNameMapList.get(i).get("propname"))) continue;
            Element td = RichEditorUtils.createTd(document);
            td.text(entryPropDisplayNameMapList.get(i).get("propDisplayName"));
            trElement.appendChild((Node)td);
            Element td1 = RichEditorUtils.createTd(document);
            String fieldKey = RichEditorUtils.getAimString(entryPropDisplayNameMapList.get(i).get("propname"));
            String spanString = "{<span class=\"" + fieldKey + "\" style=\"line-height: 25px;font-size: 12px;font-weight: normal;\">" + entryPropDisplayNameMapList.get(i).get("propDisplayName") + "</span>}";
            td1.html(spanString);
            trElement1.appendChild((Node)td1);
        }
        tbody.appendChild((Node)trElement);
        tbody.appendChild((Node)trElement1);
        tabElement.appendChild((Node)tbody);
        return tabElement.toString();
    }

    public static List<String> getEntryPropList(String billFormId, String entryId) {
        ArrayList<String> entryPropList = new ArrayList<String>();
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)billFormId);
        EntryProp xEntryProp = (EntryProp)dt.getProperty(entryId);
        DataEntityPropertyCollection entryPropertys = xEntryProp.getDynamicCollectionItemPropertyType().getProperties();
        for (int j = 0; j < entryPropertys.size(); ++j) {
            LocaleString xLocaleString;
            DynamicProperty entryProperty = (DynamicProperty)entryPropertys.get(j);
            if ("id".equals(entryProperty.getName()) || "entityid".equals(entryProperty.getName()) || "seq".equals(entryProperty.getName()) || (xLocaleString = entryProperty.getDisplayName()) == null) continue;
            entryPropList.add(entryProperty.getName());
        }
        return entryPropList;
    }

    public static List<String> getSubEntryPropList(String billFormId, String entryId, String subEntryId) {
        ArrayList<String> subEntryPropList = new ArrayList<String>();
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)billFormId);
        EntryProp xEntryProp = (EntryProp)dt.getProperty(entryId);
        DataEntityPropertyCollection entryPropertys = xEntryProp.getDynamicCollectionItemPropertyType().getProperties();
        SubEntryProp entryProperty = (SubEntryProp)entryPropertys.get((Object)subEntryId);
        DataEntityPropertyCollection subEntryPropertys = entryProperty.getDynamicCollectionItemPropertyType().getProperties();
        for (int j = 0; j < subEntryPropertys.size(); ++j) {
            String fieldKey;
            LocaleString xLocaleString;
            DynamicProperty subEntryProperty = (DynamicProperty)subEntryPropertys.get(j);
            if ("id".equals(subEntryProperty.getName()) || "entityid".equals(subEntryProperty.getName()) || "seq".equals(subEntryProperty.getName()) || "enable".equals(subEntryProperty.getName()) || (xLocaleString = subEntryProperty.getDisplayName()) == null) continue;
            if ("material".equals(subEntryProperty.getName())) {
                fieldKey = RichEditorUtils.getAimString(subEntryProperty.getName());
                subEntryPropList.add(fieldKey);
                subEntryPropList.add("materialname");
                subEntryPropList.add("materialmodel");
                continue;
            }
            fieldKey = RichEditorUtils.getAimString(subEntryProperty.getName());
            subEntryPropList.add(fieldKey);
        }
        return subEntryPropList;
    }

    public static DynamicObjectCollection getList(String billId, String billTypeId, String entryTypeId) {
        DynamicObject xDynamicObject = BusinessDataServiceHelper.loadSingle((Object)billId, (String)billTypeId);
        DynamicObjectCollection xCollection = xDynamicObject.getDynamicObjectCollection(entryTypeId);
        return xCollection;
    }

    public static List<String> getEntryPropDisplayNameList(String billFormId, String entryId) {
        ArrayList<String> entryPropDisplayNameList = new ArrayList<String>();
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)billFormId);
        EntryProp xEntryProp = (EntryProp)dt.getProperty(entryId);
        DataEntityPropertyCollection entryPropertys = xEntryProp.getDynamicCollectionItemPropertyType().getProperties();
        for (int j = 0; j < entryPropertys.size(); ++j) {
            DynamicProperty entryProperty = (DynamicProperty)entryPropertys.get(j);
            if ("id".equals(entryProperty.getName()) || "entityid".equals(entryProperty.getName()) || "seq".equals(entryProperty.getName())) continue;
            entryPropDisplayNameList.add(entryProperty.getDisplayName().getLocaleValue());
        }
        return entryPropDisplayNameList;
    }

    public static List<Map<String, String>> getEntryPropDisplayNameMapList(String billFormId, String entryId) {
        ArrayList<Map<String, String>> entryPropDisplayNameMapList = new ArrayList<Map<String, String>>();
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)billFormId);
        EntryProp xEntryProp = (EntryProp)dt.getProperty(entryId);
        DataEntityPropertyCollection entryPropertys = xEntryProp.getDynamicCollectionItemPropertyType().getProperties();
        for (int j = 0; j < entryPropertys.size(); ++j) {
            DynamicProperty entryProperty = (DynamicProperty)entryPropertys.get(j);
            if ("id".equals(entryProperty.getName()) || "entityid".equals(entryProperty.getName()) || "seq".equals(entryProperty.getName())) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("propname", entryProperty.getName());
            LocaleString xLocaleString = entryProperty.getDisplayName();
            if (xLocaleString == null) continue;
            map.put("propDisplayName", "" + xLocaleString);
            entryPropDisplayNameMapList.add(map);
        }
        return entryPropDisplayNameMapList;
    }

    public static List<Map<String, String>> getListEntryPropMapList(String billFormId, String entryId, String subEntryId) {
        ArrayList<Map<String, String>> entryPropDisplayNameMapList = new ArrayList<Map<String, String>>();
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)billFormId);
        EntryProp xEntryProp = (EntryProp)dt.getProperty(entryId);
        DataEntityPropertyCollection entryPropertys = xEntryProp.getDynamicCollectionItemPropertyType().getProperties();
        SubEntryProp entryProperty = (SubEntryProp)entryPropertys.get((Object)subEntryId);
        DataEntityPropertyCollection subEntryPropertys = entryProperty.getDynamicCollectionItemPropertyType().getProperties();
        List aps = MetadataUtil.getFormMetadata((String)billFormId);
        MetadataUtil.getSortProperties((List)subEntryPropertys, (List)aps);
        for (int j = 0; j < subEntryPropertys.size(); ++j) {
            LocaleString xLocaleString;
            DynamicProperty subEntryProperty = (DynamicProperty)subEntryPropertys.get(j);
            if ("id".equals(subEntryProperty.getName()) || "entityid".equals(subEntryProperty.getName()) || "seq".equals(subEntryProperty.getName()) || "longnumber".equals(subEntryProperty.getName()) || "listparentid".equals(subEntryProperty.getName()) || (xLocaleString = subEntryProperty.getDisplayName()) == null) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            if ("material".equals(subEntryProperty.getName())) {
                HashMap<String, String> materialMap = new HashMap<String, String>();
                materialMap.put("propname", subEntryProperty.getName());
                materialMap.put("propDisplayName", "" + xLocaleString);
                entryPropDisplayNameMapList.add(materialMap);
                materialMap = new HashMap();
                LocaleString nameLocalStr = new LocaleString(ResManager.loadKDString((String)"\u7269\u6599.\u540d\u79f0", (String)"RichEditorUtils_10", (String)"pmgt-pmct-common", (Object[])new Object[0]));
                materialMap.put("propname", "materialname");
                materialMap.put("propDisplayName", "" + nameLocalStr);
                entryPropDisplayNameMapList.add(materialMap);
                materialMap = new HashMap();
                LocaleString modelLocalStr = new LocaleString(ResManager.loadKDString((String)"\u7269\u6599.\u89c4\u683c\u578b\u53f7", (String)"RichEditorUtils_11", (String)"pmgt-pmct-common", (Object[])new Object[0]));
                materialMap.put("propname", "materialmodel");
                materialMap.put("propDisplayName", "" + modelLocalStr);
                entryPropDisplayNameMapList.add(materialMap);
                continue;
            }
            map.put("propname", subEntryProperty.getName());
            map.put("propDisplayName", "" + xLocaleString);
            entryPropDisplayNameMapList.add(map);
        }
        return entryPropDisplayNameMapList;
    }

    public static String wirteFieldData(Document document, String billId, String billTypeName) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)billId, (String)billTypeName);
        Map<String, Map<String, String>> enumMap = RichEditorUtils.getEnumMapByBillTypeName(billTypeName);
        Elements xElements = document.select(FIELDSELECTOR);
        for (Element element : xElements) {
            String fString = "";
            String className = element.className();
            String[] resultArr = className.split("-");
            Object object = dynamicObject.get(resultArr[1]);
            if (object == null) {
                fString = "";
            } else if (resultArr.length == 4 && StringUtils.equals((CharSequence)resultArr[2], (CharSequence)"enum")) {
                fString = enumMap.get(resultArr[1]).get(dynamicObject.getString(resultArr[1]));
            } else if (object instanceof DynamicObject) {
                fString = StringUtils.equals((CharSequence)"project", (CharSequence)resultArr[1]) ? (StringUtils.equals((CharSequence)"bd_project", (CharSequence)resultArr[2]) ? dynamicObject.getString(resultArr[1] + ".name") : dynamicObject.getString(resultArr[1] + ".projectname")) : dynamicObject.getString(resultArr[1] + ".name");
            } else if (object instanceof BigDecimal) {
                DecimalFormat df1 = new DecimalFormat("###,###.##");
                fString = df1.format(dynamicObject.getBigDecimal(resultArr[1]));
            } else if (object instanceof Timestamp) {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
                if (dynamicObject.getDate(resultArr[1]) != null) {
                    Date date = dynamicObject.getDate(resultArr[1]);
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(date);
                    int hour = calendar.get(10);
                    int minute = calendar.get(12);
                    int second = calendar.get(13);
                    if (hour == 0 && minute == 0 && second == 0) {
                        SimpleDateFormat format1 = new SimpleDateFormat("yyyy-MM-dd");
                        fString = format1.format(dynamicObject.getDate(resultArr[1]));
                    } else {
                        fString = format.format(dynamicObject.getDate(resultArr[1]));
                    }
                }
            } else {
                fString = dynamicObject.getString(resultArr[1]);
            }
            String spanString = element.toString();
            String parenttextString = element.parent().html();
            String pattern = "(?:>)(.*?)(?:<)";
            String xString = spanString.replaceFirst(pattern, ">" + fString + "<");
            String parentString = parenttextString.replaceFirst("\\{(.*?)\\}", xString);
            element.parent().empty().html(parentString);
        }
        String xString = document.body().toString().substring(8, document.body().toString().length() - 7);
        return xString;
    }

    public static String wirtePrivateInfoData(Document document, String billId, String billTypeName) {
        Map<String, Map<String, String>> map = RichEditorUtils.getPrivateInfoEnumMap();
        HashMap<String, Object> privateInfoMap = new HashMap<String, Object>();
        Elements xElements = document.select(PRIVATEINFOSELECTOR);
        for (Element element : xElements) {
            String className = element.className();
            String[] resultArr = className.split("-");
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)billId, (String)billTypeName);
            DynamicObjectCollection privateInfoCol = dynamicObject.getDynamicObjectCollection("specentry");
            for (DynamicObject privateInfo : privateInfoCol) {
                privateInfoMap.put(privateInfo.getString("propname"), privateInfo.get("value"));
            }
            String spanString = element.toString();
            String parenttextString = element.parent().html();
            String fString = "";
            if (resultArr.length == 4) {
                if (StringUtils.equals((CharSequence)resultArr[2], (CharSequence)"enum")) {
                    fString = map.get(resultArr[1]).get(privateInfoMap.get(resultArr[1]));
                } else {
                    DynamicObject dynamicObject2 = BusinessDataServiceHelper.loadSingle((String)resultArr[2], (String)"name", (QFilter[])new QFilter[]{new QFilter("number", "=", privateInfoMap.get(resultArr[1]))});
                    if (dynamicObject2 != null) {
                        fString = dynamicObject2.getString("name");
                    }
                }
            } else {
                fString = (String)privateInfoMap.get(resultArr[1]);
            }
            String pattern = "(?:>)(.*?)(?:<)";
            String xString = spanString.replaceFirst(pattern, ">" + fString + "<");
            String parentString = parenttextString.replaceFirst("\\{(.*?)\\}", xString);
            element.parent().empty().html(parentString);
        }
        String xString = document.body().toString().substring(8, document.body().toString().length() - 7);
        return xString;
    }

    public static String wirteTableData(Document document, String billId, String billTypeName) {
        Elements xElement = document.select(ENTRYSELECTOR);
        for (Element element : xElement) {
            String className = element.className();
            String[] resultArr = className.split("-");
            DynamicObjectCollection list = null;
            Map<String, Map<String, String>> map = RichEditorUtils.getEnumMapByEntry(billTypeName, resultArr[1]);
            list = RichEditorUtils.getList(billId, resultArr[0], resultArr[1]);
            String thHtml = element.child(0).child(0).html();
            String trHtml = element.child(0).child(1).html();
            element.child(0).remove();
            element.append(thHtml);
            element.child(0).append(trHtml);
            element.child(0).child(0).addClass("firstRow");
            element.child(0).child(1).attr("Style", "display:none");
            List<String> pList = RichEditorUtils.getEntryPropList(resultArr[0], resultArr[1]);
            for (int i = 1; i < list.size() + 1; ++i) {
                element.child(0).append(trHtml);
                DynamicObject dObject = (DynamicObject)list.get(i - 1);
                for (int j = 0; j < pList.size(); ++j) {
                    String field = pList.get(j);
                    if (element.child(0).child(i + 1).select("." + field).size() == 0) continue;
                    Element tempElement = ((Element)element.child(0).child(i + 1).select("." + field).get(0)).parent();
                    ((Element)element.child(0).child(i + 1).select("." + field).get(0)).remove();
                    Object object = dObject.get(field);
                    if (object == null) {
                        tempElement.text("");
                        continue;
                    }
                    if (object instanceof DynamicObject) {
                        tempElement.text(dObject.getString(field + ".name"));
                        continue;
                    }
                    if (object instanceof BigDecimal) {
                        DecimalFormat df1 = new DecimalFormat("###,###.##");
                        tempElement.text(df1.format(dObject.getBigDecimal(field)));
                        continue;
                    }
                    if (object instanceof Timestamp) {
                        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                        tempElement.text(format.format(dObject.getDate(field)));
                        continue;
                    }
                    if (object instanceof Boolean) {
                        Boolean boolean1 = (Boolean)object;
                        if (boolean1.booleanValue()) {
                            tempElement.text(ResManager.loadKDString((String)"\u662f", (String)"RichEditorUtils_8", (String)"pmgt-pmct-common", (Object[])new Object[0]));
                            continue;
                        }
                        tempElement.text(ResManager.loadKDString((String)"\u5426", (String)"RichEditorUtils_9", (String)"pmgt-pmct-common", (Object[])new Object[0]));
                        continue;
                    }
                    Map<String, String> detailMap = map.get(field);
                    if (detailMap != null) {
                        String value = detailMap.get(dObject.getString(field));
                        if (StringUtils.isBlank((CharSequence)value)) {
                            tempElement.text(dObject.getString(field));
                            continue;
                        }
                        tempElement.text(value);
                        continue;
                    }
                    tempElement.text(dObject.getString(field));
                }
            }
        }
        String xString = document.body().toString().substring(8, document.body().toString().length() - 7);
        return xString;
    }

    public static String newWirteListTableData(Document document, String billId) {
        HashMap map = new HashMap();
        Elements xElement = document.select(LISTSELECTOR);
        for (Element element : xElement) {
            String className = element.className();
            String[] resultArr = className.split("-");
            if (resultArr.length <= 1) continue;
            String listModelId = resultArr[0];
            List<String> aimStringList = RichEditorUtils.getFieldListByListModel(listModelId);
            QFilter listModelFilter = new QFilter("listingmodel", "=", (Object)listModelId);
            QFilter contractIdFilter = new QFilter("contractid", "=", (Object)billId);
            String selectString = "number,status,name,creator,modifier,enable,createtime,material.name,material.number,boqnumber.number,boqnumber.name,contlistnumber.number,contlistnumber.namemodifytime,masterid,paydirection,resourceitem.number,resourceitem.name,measureunit,currency,qty,taxprice,taxrate,amount,price,tax,oftax,directfee,manfee,equfee,manequfee,tmpfee,desc,group.name,listingmodel,contract,entryid,no,lstsettleqty,lstsettleoftaxamount,changeqty,chgeffectqty,chgoftaxamount,totalqty,curtaxprice,lstoftaxamount,avgtaxprice,ischanged,isaddnew";
            DynamicObject[] listArr = BusinessDataServiceHelper.load((String)"pmct_contractlist", (String)selectString, (QFilter[])new QFilter[]{contractIdFilter, listModelFilter}, (String)"listparentid");
            String thHtml = element.child(0).child(0).html();
            String trHtml = element.child(0).child(1).html();
            element.child(0).remove();
            element.append(thHtml);
            element.child(0).append(trHtml);
            element.child(0).child(0).addClass("firstRow");
            element.child(0).child(1).attr("Style", "display:none");
            for (int i = 1; i < listArr.length + 1; ++i) {
                element.child(0).append(trHtml);
                DynamicObject dObject = listArr[i - 1];
                for (int j = 0; j < aimStringList.size(); ++j) {
                    Elements elements = element.child(0).child(i + 1).select("." + aimStringList.get(j));
                    if (elements.size() == 0) continue;
                    Element tempElement = ((Element)elements.get(0)).parent();
                    ((Element)element.child(0).child(i + 1).select("." + aimStringList.get(j)).get(0)).remove();
                    if (aimStringList.get(j).contains("-")) {
                        String newString = aimStringList.get(j).replaceAll("-", ".");
                        if (dObject.getString(newString) != null) {
                            tempElement.text(map.get(dObject.getString(newString)) == null ? dObject.getString(newString) : (String)map.get(dObject.getString(newString)));
                            continue;
                        }
                        tempElement.text("");
                        continue;
                    }
                    Object object = dObject.get(aimStringList.get(j));
                    if (object == null) {
                        tempElement.text("");
                        continue;
                    }
                    if (object instanceof DynamicObject) {
                        tempElement.text(map.get(dObject.getString(aimStringList.get(j) + ".name")) == null ? dObject.getString(aimStringList.get(j) + ".name") : (String)map.get(dObject.getString(aimStringList.get(j) + ".name")));
                        continue;
                    }
                    if (object instanceof BigDecimal) {
                        DecimalFormat df1 = new DecimalFormat("###,###.##");
                        tempElement.text(df1.format(dObject.getBigDecimal(aimStringList.get(j))));
                        continue;
                    }
                    tempElement.text(map.get(dObject.getString(aimStringList.get(j))) == null ? dObject.getString(aimStringList.get(j)) : (String)map.get(dObject.getString(aimStringList.get(j))));
                }
            }
        }
        String xString = document.body().toString().substring(8, document.body().toString().length() - 7);
        return xString;
    }

    public static String wirteListTableData(Document document, String billId) {
        Elements xElement = document.select(LISTSELECTOR);
        for (Element element : xElement) {
            String className = element.className();
            String[] resultArr = className.split("-");
            if (resultArr.length <= 1) continue;
            String listModelId = resultArr[3];
            QFilter listingModelFilter = new QFilter("listingmodel", "=", (Object)listModelId);
            QFilter contractIdFilter = new QFilter("contractid", "=", (Object)billId);
            String selectString = "sysnumber, number, name, material, level, parent, sequence, measureunit, qty, taxprice, taxrate, rateobj, amount, price, tax, oftax, desc, lstsettleqty, lstsettleoftaxamount, changeqty, chgeffectqty, chgoftaxamount, totalqty, curtaxprice, lstoftaxamount, avgtaxprice, ischanged, isaddnew,fullname, isleaf, status, currency, listingmodel, contractid, paydirection,listingbudgetitem,contlistnumber";
            DynamicObject[] lists = BusinessDataServiceHelper.load((String)"pmct_contractlist", (String)selectString, (QFilter[])new QFilter[]{contractIdFilter, listingModelFilter}, (String)"listingmodel");
            String thHtml = element.child(0).child(0).html();
            String trHtml = element.child(0).child(1).html();
            element.child(0).remove();
            element.append(thHtml);
            element.child(0).append(trHtml);
            element.child(0).child(0).addClass("firstRow");
            element.child(0).child(1).attr("Style", "display:none");
            List<String> pList = RichEditorUtils.getSubEntryPropList(resultArr[0], resultArr[1], resultArr[2]);
            for (int i = 1; i < lists.length + 1; ++i) {
                element.child(0).append(trHtml);
                DynamicObject dObject = lists[i - 1];
                for (int j = 0; j < pList.size(); ++j) {
                    Object object;
                    String field = pList.get(j);
                    if (element.child(0).child(i + 1).select("." + field).size() == 0) continue;
                    Element tempElement = ((Element)element.child(0).child(i + 1).select("." + field).get(0)).parent();
                    ((Element)element.child(0).child(i + 1).select("." + field).get(0)).remove();
                    if (field.contains("-")) {
                        if (dObject.getString(field = field.replaceAll("-", ".")) != null) {
                            tempElement.text(dObject.getString(field));
                        } else {
                            tempElement.text("");
                        }
                    }
                    if ((object = "materialname".equals(field) ? dObject.get("material.name") : ("materialmodel".equals(field) ? dObject.get("material.modelnum") : dObject.get(field))) == null) {
                        tempElement.text("");
                        continue;
                    }
                    if (object instanceof DynamicObject) {
                        if ("material".equals(field)) {
                            tempElement.text(dObject.getString(field + ".number"));
                            continue;
                        }
                        tempElement.text(dObject.getString(field + ".name"));
                        continue;
                    }
                    if (object instanceof BigDecimal) {
                        DecimalFormat df1 = new DecimalFormat("###,###.##");
                        tempElement.text(df1.format(dObject.getBigDecimal(field)));
                        continue;
                    }
                    if (object instanceof Timestamp) {
                        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                        tempElement.text(format.format(dObject.getDate(field)));
                        continue;
                    }
                    if (object instanceof Boolean) {
                        Boolean boolean1 = (Boolean)object;
                        if (boolean1.booleanValue()) {
                            tempElement.text(ResManager.loadKDString((String)"\u662f", (String)"RichEditorUtils_8", (String)"pmgt-pmct-common", (Object[])new Object[0]));
                            continue;
                        }
                        tempElement.text(ResManager.loadKDString((String)"\u5426", (String)"RichEditorUtils_9", (String)"pmgt-pmct-common", (Object[])new Object[0]));
                        continue;
                    }
                    if ("materialname".equals(field)) {
                        tempElement.text(dObject.getString("material.name"));
                        continue;
                    }
                    if ("materialmodel".equals(field)) {
                        tempElement.text(dObject.getString("material.modelnum"));
                        continue;
                    }
                    if ("status".equals(field)) {
                        tempElement.text(StatusEnum.getEnumByValue((Object)dObject.getString(field)).getName());
                        continue;
                    }
                    if (dObject.getString(field) == null) continue;
                    tempElement.text(dObject.getString(field));
                }
            }
        }
        String xString = document.body().toString().substring(8, document.body().toString().length() - 7);
        return xString;
    }

    private static Map<String, Map<String, String>> getEnumMapByEntry(String billName, String entryName) {
        HashMap<String, Map<String, String>> enumMap = new HashMap<String, Map<String, String>>();
        MainEntityType billType = EntityMetadataCache.getDataEntityType((String)billName);
        EntryProp entryProp = (EntryProp)billType.getProperty(entryName);
        DataEntityPropertyCollection entryPropCol = entryProp.getDynamicCollectionItemPropertyType().getProperties();
        for (IDataEntityProperty iDataEntityProperty : entryPropCol) {
            if (!(iDataEntityProperty instanceof ComboProp)) continue;
            ComboProp comboProp = (ComboProp)iDataEntityProperty;
            List valueMapItemList = comboProp.getComboItems();
            HashMap<String, String> enumDetailMap = new HashMap<String, String>(16);
            for (ValueMapItem item : valueMapItemList) {
                enumDetailMap.put(item.getValue(), item.getName() + "");
            }
            enumMap.put(iDataEntityProperty.getName(), enumDetailMap);
        }
        return enumMap;
    }

    private static Map<String, Map<String, String>> getEnumMapByBillTypeName(String billTypeName) {
        HashMap<String, Map<String, String>> enumMap = new HashMap<String, Map<String, String>>();
        MainEntityType billType = EntityMetadataCache.getDataEntityType((String)billTypeName);
        DataEntityPropertyCollection propertyCollection = billType.getProperties();
        for (IDataEntityProperty iDataEntityProperty : propertyCollection) {
            if (iDataEntityProperty instanceof ComboProp) {
                ComboProp comboProp = (ComboProp)iDataEntityProperty;
                HashMap<String, String> enumDetailMap = new HashMap<String, String>(16);
                List enumList = comboProp.getComboItems();
                for (ValueMapItem enumObj : enumList) {
                    enumDetailMap.put(enumObj.getValue(), enumObj.getName() + "");
                }
                enumMap.put(comboProp.getName(), enumDetailMap);
                continue;
            }
            if (!(iDataEntityProperty instanceof EntryProp)) continue;
            EntryProp entryProp = (EntryProp)iDataEntityProperty;
            DataEntityPropertyCollection entryPropCollection = entryProp.getDynamicCollectionItemPropertyType().getProperties();
            for (IDataEntityProperty entryDetailProp : entryPropCollection) {
                if (!(entryDetailProp instanceof ComboProp)) continue;
                ComboProp comboProp = (ComboProp)entryDetailProp;
                HashMap<String, String> enumDetailMap = new HashMap<String, String>(16);
                List enumList = comboProp.getComboItems();
                for (ValueMapItem enumObj : enumList) {
                    enumDetailMap.put(enumObj.getValue(), enumObj.getName() + "");
                }
                enumMap.put(comboProp.getName(), enumDetailMap);
            }
        }
        return enumMap;
    }

    private static Map<String, Map<String, String>> getPrivateInfoEnumMap() {
        HashMap<String, Map<String, String>> enumMap = new HashMap<String, Map<String, String>>();
        MainEntityType specType = EntityMetadataCache.getDataEntityType((String)"ec_specpanel");
        DataEntityPropertyCollection propCol = specType.getProperties();
        for (IDataEntityProperty iDataEntityProperty : propCol) {
            if (!(iDataEntityProperty instanceof ComboProp)) continue;
            ComboProp comboProp = (ComboProp)iDataEntityProperty;
            HashMap<String, String> enumDetailMap = new HashMap<String, String>(16);
            List enumList = comboProp.getComboItems();
            for (ValueMapItem enumObj : enumList) {
                enumDetailMap.put(enumObj.getValue(), enumObj.getName() + "");
            }
            enumMap.put(comboProp.getName(), enumDetailMap);
        }
        return enumMap;
    }
}

