/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.business.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.common.enums.pmct.ChangeTypeEnum;
import kd.pmgt.pmbs.common.utils.NumberHelper;
import kd.pmgt.pmbs.common.utils.TypeUtils;

public class ContractListHelper {
    public static void upadteListingByChangeType(DynamicObject listingEntryObj, DynamicObject inventory, DynamicObject listing, String changeType, String formId) {
        ArrayList<DynamicObject> contractListingList = new ArrayList<DynamicObject>(10);
        String currentChangeType = null;
        BigDecimal thisAfterOFTaxAmount = BigDecimal.ZERO;
        BigDecimal currentNums = BigDecimal.ZERO;
        BigDecimal currentPrice = BigDecimal.ZERO;
        BigDecimal affectedNums = BigDecimal.ZERO;
        BigDecimal taxrate = BigDecimal.ZERO;
        BigDecimal curChangedTaxAmount = BigDecimal.ZERO;
        BigDecimal curChangedAmount = BigDecimal.ZERO;
        if ("pmct_outclaimbill".equals(formId) || "pmct_inclaimbill".equals(formId)) {
            currentChangeType = listingEntryObj.getString("subclaimtype");
            currentNums = listingEntryObj.getBigDecimal("qty");
            thisAfterOFTaxAmount = listingEntryObj.getBigDecimal("thisafteroftaxamount");
            currentPrice = listingEntryObj.getBigDecimal("oftaxprice");
            affectedNums = listingEntryObj.getBigDecimal("beaffectedcount");
            taxrate = listingEntryObj.getBigDecimal("subtaxrate");
            curChangedTaxAmount = thisAfterOFTaxAmount;
        } else if ("pmct_outcontractrevision".equals(formId) || "pmct_incontractrevision".equals(formId)) {
            currentChangeType = listingEntryObj.getString("subchangetype");
            currentNums = listingEntryObj.getBigDecimal("qty");
            thisAfterOFTaxAmount = listingEntryObj.getBigDecimal("hsbgje");
            currentPrice = listingEntryObj.getBigDecimal("hanshuidanj");
            affectedNums = listingEntryObj.getBigDecimal("shouyingxsl");
            taxrate = listingEntryObj.getBigDecimal("taxrate1");
            curChangedTaxAmount = thisAfterOFTaxAmount;
        } else if ("pmct_outaddagreement".equals(formId) || "pmct_inaddagreement".equals(formId)) {
            currentChangeType = listingEntryObj.getString("subaddtype");
            currentNums = listingEntryObj.getBigDecimal("qty");
            thisAfterOFTaxAmount = listingEntryObj.getBigDecimal("changeamountoftax");
            currentPrice = listingEntryObj.getBigDecimal("priceoftax");
            affectedNums = listingEntryObj.getBigDecimal("affectedqty");
            taxrate = listingEntryObj.getBigDecimal("subtaxrate");
            curChangedTaxAmount = thisAfterOFTaxAmount;
        }
        if (StringUtils.equals((CharSequence)currentChangeType, (CharSequence)ChangeTypeEnum.NUMBERCHANGE.getValue())) {
            listing.set("ischanged", (Object)Boolean.TRUE);
            listing.set("enable", (Object)1);
            double changeqty = TypeUtils.StringToDouble((Object)listingEntryObj.getBigDecimal("qty"));
            listing.set("changeqty", (Object)(changeqty -= TypeUtils.StringToDouble((Object)listing.getBigDecimal("qty"))));
            BigDecimal changedTaxAmount = (BigDecimal)listing.get("chgoftaxamount");
            listing.set("chgoftaxamount", (Object)changedTaxAmount.subtract(thisAfterOFTaxAmount));
            BigDecimal newTotalChangedTaxAmount = listing.getBigDecimal("lstoftaxamount");
            BigDecimal totalChangedTaxAmount = newTotalChangedTaxAmount.subtract(thisAfterOFTaxAmount);
            listing.set("lstoftaxamount", (Object)totalChangedTaxAmount);
            curChangedAmount = NumberHelper.divide((Object)thisAfterOFTaxAmount, (Object)BigDecimal.ONE.add(taxrate.divide(new BigDecimal("100"))), (int)10, (RoundingMode)RoundingMode.HALF_UP);
            BigDecimal newTotalChangedAmount = listing.getBigDecimal("latestamount");
            listing.set("latestamount", (Object)newTotalChangedAmount.subtract(curChangedAmount));
            listing.set("totalqty", (Object)currentNums);
            listing.set("avgtaxprice", (Object)totalChangedTaxAmount.divide(currentNums, 10, RoundingMode.HALF_UP));
            listing.set("desc", inventory.get("remark"));
            listing.set("amount", (Object)listingEntryObj.getBigDecimal("amount"));
            listing.set("oftax", (Object)listingEntryObj.getBigDecimal("oftax"));
        } else if (StringUtils.equals((CharSequence)currentChangeType, (CharSequence)ChangeTypeEnum.PRICECHANGE.getValue())) {
            listing.set("ischanged", (Object)Boolean.TRUE);
            listing.set("enable", (Object)1);
            BigDecimal lastChangedEffectQty = listing.getBigDecimal("chgeffectqty");
            listing.set("chgeffectqty", (Object)lastChangedEffectQty.subtract(affectedNums));
            listing.set("curtaxprice", (Object)currentPrice);
            listing.set("latestprice", (Object)listingEntryObj.getBigDecimal("price"));
            BigDecimal changedTaxAmount = (BigDecimal)listing.get("chgoftaxamount");
            listing.set("chgoftaxamount", (Object)changedTaxAmount.subtract(thisAfterOFTaxAmount));
            BigDecimal newTotalChangedTaxAmount = listing.getBigDecimal("lstoftaxamount");
            BigDecimal totalChangedTaxAmount = newTotalChangedTaxAmount.subtract(thisAfterOFTaxAmount);
            listing.set("lstoftaxamount", (Object)totalChangedTaxAmount);
            curChangedAmount = NumberHelper.divide((Object)thisAfterOFTaxAmount, (Object)BigDecimal.ONE.add(taxrate.divide(new BigDecimal("100"))), (int)10, (RoundingMode)RoundingMode.HALF_UP);
            BigDecimal newTotalChangedAmount = listing.getBigDecimal("latestamount");
            listing.set("latestamount", (Object)newTotalChangedAmount.subtract(curChangedAmount));
            BigDecimal totalQty = listing.getBigDecimal("totalqty");
            listing.set("avgtaxprice", (Object)totalChangedTaxAmount.divide(totalQty, 10, RoundingMode.HALF_UP));
            listing.set("desc", inventory.get("remark"));
            listing.set("amount", (Object)listingEntryObj.getBigDecimal("amount"));
            listing.set("oftax", (Object)listingEntryObj.getBigDecimal("oftax"));
        } else if (StringUtils.equals((CharSequence)currentChangeType, (CharSequence)ChangeTypeEnum.DETAILLISTING.getValue()) || StringUtils.equals((CharSequence)currentChangeType, (CharSequence)ChangeTypeEnum.NOTDETAILLISTING.getValue())) {
            listing.set("isaddnew", (Object)Boolean.TRUE);
            listing.set("ischanged", (Object)Boolean.FALSE);
        } else if (StringUtils.equals((CharSequence)currentChangeType, (CharSequence)ChangeTypeEnum.TAXRATECHGANGE.getValue())) {
            listing.set("ischanged", (Object)Boolean.TRUE);
            listing.set("enable", (Object)1);
            BigDecimal lastChangedEffectQty = listing.getBigDecimal("chgeffectqty");
            listing.set("chgeffectqty", (Object)lastChangedEffectQty.subtract(affectedNums));
            listing.set("curtaxprice", (Object)currentPrice);
            listing.set("latestprice", (Object)listingEntryObj.getBigDecimal("price"));
            BigDecimal changedTaxAmount = (BigDecimal)listing.get("chgoftaxamount");
            listing.set("chgoftaxamount", (Object)changedTaxAmount.subtract(thisAfterOFTaxAmount));
            BigDecimal newTotalChangedTaxAmount = listing.getBigDecimal("lstoftaxamount");
            BigDecimal totalChangedTaxAmount = newTotalChangedTaxAmount.subtract(thisAfterOFTaxAmount);
            listing.set("lstoftaxamount", (Object)totalChangedTaxAmount);
            listing.set("latestamount", (Object)listingEntryObj.getBigDecimal("amount"));
            BigDecimal totalQty = listing.getBigDecimal("totalqty");
            if (totalQty.compareTo(BigDecimal.ZERO) != 0) {
                listing.set("avgtaxprice", (Object)totalChangedTaxAmount.divide(totalQty, 10, RoundingMode.HALF_UP));
            }
            listing.set("desc", inventory.get("remark"));
            listing.set("amount", (Object)listingEntryObj.getBigDecimal("amount"));
            listing.set("oftax", (Object)listingEntryObj.getBigDecimal("oftax"));
            listing.set("rateobj", listingEntryObj.get("rateobj"));
            listing.set("taxrate", (Object)listingEntryObj.getBigDecimal("taxrate1"));
            curChangedAmount = BigDecimal.ZERO;
        }
        contractListingList.add(listing);
        DynamicObject parentListing = listing.getDynamicObject("parent");
        if (parentListing != null) {
            ContractListHelper.updateContractParentDataOnUnAudit(contractListingList, parentListing, curChangedTaxAmount, curChangedAmount, Boolean.TRUE);
        }
        SaveServiceHelper.update((DynamicObject[])contractListingList.toArray(new DynamicObject[0]));
    }

    public static void updateLastContractListing(DynamicObject bill, DynamicObject contract, DynamicObject[] claims, DynamicObject[] contractRevisions, DynamicObject[] contAddAgreements) {
        Object inventoryEntry;
        String currentFormId = bill.getDynamicObjectType().getName();
        Date auditDate = bill.getDate("auditdate");
        ArrayList<Long> newContractListingId = new ArrayList<Long>(16);
        DynamicObjectCollection cardModelEntry = new DynamicObjectCollection();
        if ("pmct_outaddagreement".equals(currentFormId) || "pmct_inaddagreement".equals(currentFormId)) {
            cardModelEntry = bill.getDynamicObjectCollection("cardentry");
        } else if ("pmct_outcontractrevision".equals(currentFormId) || "pmct_incontractrevision".equals(currentFormId)) {
            cardModelEntry = bill.getDynamicObjectCollection("kapianentry");
        } else if ("pmct_outclaimbill".equals(currentFormId) || "pmct_inclaimbill".equals(currentFormId)) {
            cardModelEntry = bill.getDynamicObjectCollection("kapianentry");
        }
        ArrayList<DynamicObject> listingEntryList = new ArrayList<DynamicObject>(16);
        if (cardModelEntry.size() > 0) {
            for (DynamicObject cardModel : cardModelEntry) {
                DynamicObjectCollection listingEntryCol = cardModel.getDynamicObjectCollection("entryentity");
                if (listingEntryCol.size() <= 0) continue;
                for (DynamicObject listingEntryRow : listingEntryCol) {
                    if (listingEntryRow == null) continue;
                    listingEntryList.add(listingEntryRow);
                }
            }
        } else {
            return;
        }
        if (listingEntryList.size() == 0) {
            return;
        }
        HashMap<Object, Date> claimMap = new HashMap<Object, Date>();
        HashMap<Object, DynamicObject> claimInventoryMap = new HashMap<Object, DynamicObject>();
        if (claims.length > 0) {
            Object[] ids = Arrays.stream(claims).map(DataEntityBase::getPkValue).toArray();
            for (DynamicObject claim : claims = BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_claimbilltpl"))) {
                DynamicObjectCollection claimCardEntry = claim.getDynamicObjectCollection("kapianentry");
                if (claimCardEntry == null || claimCardEntry.size() <= 0) continue;
                for (DynamicObject claimCard : claimCardEntry) {
                    DynamicObjectCollection inventoryEntry2 = claimCard.getDynamicObjectCollection("entryentity");
                    if (inventoryEntry2 == null || inventoryEntry2.size() <= 0) continue;
                    Iterator iterator = inventoryEntry2.iterator();
                    while (iterator.hasNext()) {
                        DynamicObject inventory = (DynamicObject)iterator.next();
                        if (inventory.getDynamicObject("listid") != null) {
                            claimInventoryMap.put(inventory.getDynamicObject("listid").getPkValue(), inventory);
                            claimMap.put(inventory.getDynamicObject("listid").getPkValue(), claim.getDate("auditdate"));
                            continue;
                        }
                        claimInventoryMap.put(inventory.getLong("newlistingid"), inventory);
                        claimMap.put(inventory.getLong("newlistingid"), claim.getDate("auditdate"));
                    }
                }
            }
        }
        HashMap<Object, Date> contractRevisionMap = new HashMap<Object, Date>();
        HashMap<Object, DynamicObject> contractRevisionInventoryMap = new HashMap<Object, DynamicObject>();
        if (contractRevisions.length > 0) {
            Object[] ids = Arrays.stream(contractRevisions).map(DataEntityBase::getPkValue).toArray();
            for (DynamicObject contractRevision : contractRevisions = BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_revisiontpl"))) {
                DynamicObjectCollection contractRevisionCardEntry = contractRevision.getDynamicObjectCollection("kapianentry");
                if (contractRevisionCardEntry == null || contractRevisionCardEntry.size() <= 0) continue;
                for (DynamicObject contractRevisionCard : contractRevisionCardEntry) {
                    inventoryEntry = contractRevisionCard.getDynamicObjectCollection("entryentity");
                    if (inventoryEntry == null || inventoryEntry.size() <= 0) continue;
                    Iterator iterator = inventoryEntry.iterator();
                    while (iterator.hasNext()) {
                        DynamicObject inventory = (DynamicObject)iterator.next();
                        if (inventory.getDynamicObject("listid") != null) {
                            contractRevisionInventoryMap.put(inventory.getDynamicObject("listid").getPkValue(), inventory);
                            contractRevisionMap.put(inventory.getDynamicObject("listid").getPkValue(), contractRevision.getDate("auditdate"));
                            continue;
                        }
                        contractRevisionInventoryMap.put(inventory.getLong("newlistingid"), inventory);
                        contractRevisionMap.put(inventory.getLong("newlistingid"), contractRevision.getDate("auditdate"));
                    }
                }
            }
        }
        HashMap<Object, Date> contAddAgreementMap = new HashMap<Object, Date>();
        HashMap<Object, DynamicObject> contAddAgreementInventoryMap = new HashMap<Object, DynamicObject>();
        if (contAddAgreements.length > 0) {
            Object[] ids = Arrays.stream(contAddAgreements).map(DataEntityBase::getPkValue).toArray();
            for (DynamicObject contAddAgreement : contAddAgreements = BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_addagreementtpl"))) {
                DynamicObjectCollection contAddAgreementCardEntry = contAddAgreement.getDynamicObjectCollection("cardentry");
                if (contAddAgreementCardEntry == null || contAddAgreementCardEntry.size() <= 0) continue;
                inventoryEntry = contAddAgreementCardEntry.iterator();
                while (inventoryEntry.hasNext()) {
                    DynamicObject contAddAgreementCard = (DynamicObject)inventoryEntry.next();
                    DynamicObjectCollection inventoryEntry3 = contAddAgreementCard.getDynamicObjectCollection("entryentity");
                    if (inventoryEntry3 == null || inventoryEntry3.size() <= 0) continue;
                    for (DynamicObject inventory : inventoryEntry3) {
                        if (inventory.getDynamicObject("listid") != null) {
                            contAddAgreementInventoryMap.put(inventory.getDynamicObject("listid").getPkValue(), inventory);
                            contAddAgreementMap.put(inventory.getDynamicObject("listid").getPkValue(), contAddAgreement.getDate("auditdate"));
                            continue;
                        }
                        contAddAgreementInventoryMap.put(inventory.getLong("newlistingid"), inventory);
                        contAddAgreementMap.put(inventory.getLong("newlistingid"), contAddAgreement.getDate("auditdate"));
                    }
                }
            }
        }
        HashMap<Object, DynamicObject> contractMap = new HashMap<Object, DynamicObject>(16);
        DynamicObjectCollection contractListModelEntry = contract.getDynamicObjectCollection("listmodelentry");
        if (contractListModelEntry.size() > 0) {
            for (DynamicObject contractListModel : contractListModelEntry) {
                DynamicObjectCollection cardEntry = contractListModel.getDynamicObjectCollection("sublistentry");
                if (cardEntry == null || cardEntry.size() <= 0) continue;
                for (DynamicObject card : cardEntry) {
                    contractMap.put(card.getPkValue(), card);
                }
            }
        }
        for (DynamicObject listingEntryObj : listingEntryList) {
            String changeType;
            Long newListingId = listingEntryObj.getLong("newlistingid");
            if (newListingId != 0L) {
                ArrayList<DynamicObject> contractListingList = new ArrayList<DynamicObject>(10);
                newContractListingId.add(newListingId);
                DynamicObject newListing = BusinessDataServiceHelper.loadSingle((Object)newListingId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_contractlist"));
                DynamicObject parentListing = newListing.getDynamicObject("parent");
                if (newListing.getBoolean("isleaf") && parentListing != null) {
                    BigDecimal curChangedTaxAmount = newListing.getBigDecimal("lstoftaxamount");
                    BigDecimal curChangedAmount = newListing.getBigDecimal("latestamount");
                    ContractListHelper.updateContractParentDataOnUnAudit(contractListingList, parentListing, curChangedTaxAmount, curChangedAmount, Boolean.TRUE);
                }
                if (contractListingList.size() <= 0) continue;
                SaveServiceHelper.save((DynamicObject[])contractListingList.toArray(new DynamicObject[0]));
                continue;
            }
            DynamicObject contractListing = listingEntryObj.getDynamicObject("listid");
            if (contractListing == null) continue;
            Object listingId = contractListing.getPkValue();
            Date claimAuditDate = auditDate;
            Date contractRevisionAuditDate = auditDate;
            Date contAddAgreementAuditDate = auditDate;
            boolean cardFlag = true;
            if (claimInventoryMap.size() > 0 && claimInventoryMap.get(contractListing.getPkValue()) != null) {
                cardFlag = false;
                claimAuditDate = (Date)claimMap.get(contractListing.getPkValue());
            }
            if (contractRevisionInventoryMap.size() > 0 && contractRevisionInventoryMap.get(contractListing.getPkValue()) != null) {
                cardFlag = false;
                contractRevisionAuditDate = (Date)contractRevisionMap.get(contractListing.getPkValue());
            }
            if (contAddAgreementInventoryMap.size() > 0 && contAddAgreementInventoryMap.get(contractListing.getPkValue()) != null) {
                cardFlag = false;
                contAddAgreementAuditDate = (Date)contAddAgreementMap.get(contractListing.getPkValue());
            }
            if (cardFlag) {
                if (("pmct_outcontractrevision".equals(currentFormId) || "pmct_incontractrevision".equals(currentFormId)) && StringUtils.equals((CharSequence)listingEntryObj.getString("subchangetype"), (CharSequence)ChangeTypeEnum.TAXRATECHGANGE.getValue())) {
                    ContractListHelper.updateContractListingByTaxRateChange(contractMap, listingEntryObj);
                    continue;
                }
                ContractListHelper.updateContractListing(contractMap, listingId);
                continue;
            }
            DynamicObject listing = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(listingId.toString()), (String)"pmct_contractlist");
            if (claimAuditDate.compareTo(auditDate) < 0 && contractRevisionAuditDate.compareTo(auditDate) < 0 && contAddAgreementAuditDate.compareTo(auditDate) < 0 && claimAuditDate.compareTo(contractRevisionAuditDate) > 0 && claimAuditDate.compareTo(contAddAgreementAuditDate) > 0 || claimAuditDate.compareTo(auditDate) < 0 && contractRevisionAuditDate.compareTo(auditDate) < 0 && contAddAgreementAuditDate.compareTo(auditDate) == 0 && claimAuditDate.compareTo(contractRevisionAuditDate) > 0 || claimAuditDate.compareTo(auditDate) < 0 && contAddAgreementAuditDate.compareTo(auditDate) < 0 && contractRevisionAuditDate.compareTo(auditDate) == 0 && claimAuditDate.compareTo(contAddAgreementAuditDate) > 0 || claimAuditDate.compareTo(auditDate) < 0 && contAddAgreementAuditDate.compareTo(auditDate) == 0 && contractRevisionAuditDate.compareTo(auditDate) == 0) {
                DynamicObject claimInventory = (DynamicObject)claimInventoryMap.get(listingId);
                changeType = claimInventory.getString("subclaimtype");
                ContractListHelper.upadteListingByChangeType(listingEntryObj, claimInventory, listing, changeType, currentFormId);
                continue;
            }
            if (contractRevisionAuditDate.compareTo(auditDate) < 0 && contAddAgreementAuditDate.compareTo(auditDate) < 0 && contractRevisionAuditDate.compareTo(contAddAgreementAuditDate) > 0 || contractRevisionAuditDate.compareTo(auditDate) < 0 && contAddAgreementAuditDate.compareTo(auditDate) == 0) {
                DynamicObject contractRevisionInventory = (DynamicObject)contractRevisionInventoryMap.get(listingId);
                changeType = contractRevisionInventory.getString("subchangetype");
                ContractListHelper.upadteListingByChangeType(listingEntryObj, contractRevisionInventory, listing, changeType, currentFormId);
                continue;
            }
            if (contAddAgreementAuditDate.compareTo(auditDate) >= 0) continue;
            DynamicObject outContAddAgreementInventory = (DynamicObject)contAddAgreementInventoryMap.get(listingId);
            changeType = outContAddAgreementInventory.getString("subaddtype");
            ContractListHelper.upadteListingByChangeType(listingEntryObj, outContAddAgreementInventory, listing, changeType, currentFormId);
        }
        if (newContractListingId.size() > 0) {
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"pmct_contractlist"), (Object[])newContractListingId.toArray());
        }
    }

    public static void updateContractListingByTaxRateChange(Map<Object, DynamicObject> contractMap, DynamicObject listingEntryObj) {
        DynamicObject contractListing = listingEntryObj.getDynamicObject("listid");
        Object listingId = contractListing.getPkValue();
        ArrayList<DynamicObject> contractListingList = new ArrayList<DynamicObject>(10);
        contractListing = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(listingId.toString()), (String)"pmct_contractlist");
        DynamicObject parentListing = contractListing.getDynamicObject("parent");
        if (parentListing != null) {
            BigDecimal curChangedTaxAmount = contractListing.getBigDecimal("lstoftaxamount").subtract(contractListing.getBigDecimal("oftax"));
            BigDecimal curChangedAmount = BigDecimal.ZERO;
            parentListing = BusinessDataServiceHelper.loadSingle((Object)parentListing.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_contractlist"));
            BigDecimal ofTax = parentListing.getBigDecimal("oftax");
            BigDecimal changedTaxAmount = parentListing.getBigDecimal("lstoftaxamount");
            if (changedTaxAmount.subtract(ofTax).compareTo(curChangedTaxAmount) == 0) {
                ContractListHelper.updateContractParentDataOnUnAudit(contractListingList, parentListing, curChangedTaxAmount, curChangedAmount, Boolean.FALSE);
            } else {
                ContractListHelper.updateContractParentDataOnUnAudit(contractListingList, parentListing, curChangedTaxAmount, curChangedAmount, Boolean.TRUE);
            }
        }
        DynamicObject contractCard = contractMap.get(listingId);
        contractListing.set("amount", (Object)listingEntryObj.getBigDecimal("amount"));
        contractListing.set("totalqty", (Object)listingEntryObj.getBigDecimal("qty"));
        contractListing.set("tax", (Object)listingEntryObj.getBigDecimal("tax"));
        contractListing.set("oftax", (Object)listingEntryObj.getBigDecimal("oftax"));
        contractListing.set("desc", contractCard.get("desc"));
        contractListing.set("rateobj", listingEntryObj.get("rateobj"));
        contractListing.set("taxrate", listingEntryObj.get("taxrate1"));
        contractListing.set("changeqty", (Object)0);
        contractListing.set("chgeffectqty", (Object)0);
        contractListing.set("chgoftaxamount", (Object)0);
        contractListing.set("price", (Object)listingEntryObj.getBigDecimal("price"));
        contractListing.set("curtaxprice", (Object)listingEntryObj.getBigDecimal("hanshuidanj"));
        contractListing.set("lstoftaxamount", (Object)listingEntryObj.getBigDecimal("oftax"));
        contractListing.set("latestamount", (Object)listingEntryObj.getBigDecimal("amount"));
        contractListing.set("avgtaxprice", (Object)listingEntryObj.getBigDecimal("hanshuidanj"));
        contractListing.set("ischanged", (Object)Boolean.FALSE);
        contractListingList.add(contractListing);
        SaveServiceHelper.save((DynamicObject[])contractListingList.toArray(new DynamicObject[0]));
    }

    private static void updateParentData(List<DynamicObject> contractListingList, DynamicObject parentListing, BigDecimal changeOfTaxAmount, BigDecimal lstOfTaxAmount, BigDecimal latestAmount) {
        parentListing = BusinessDataServiceHelper.loadSingle((Object)parentListing.getPkValue(), (String)"pmct_contractlist");
        parentListing.set("chgoftaxamount", (Object)parentListing.getBigDecimal("chgoftaxamount").subtract(changeOfTaxAmount));
        parentListing.set("lstoftaxamount", (Object)parentListing.getBigDecimal("lstoftaxamount").subtract(lstOfTaxAmount));
        parentListing.set("latestamount", (Object)parentListing.getBigDecimal("latestamount").subtract(latestAmount));
        parentListing.set("ischanged", (Object)parentListing.getBoolean("ischanged"));
        contractListingList.add(parentListing);
        parentListing = parentListing.getDynamicObject("parent");
        if (parentListing != null) {
            ContractListHelper.updateParentData(contractListingList, parentListing, changeOfTaxAmount, lstOfTaxAmount, latestAmount);
        }
    }

    public static void updateContractListing(Map<Object, DynamicObject> contractMap, Object listingId) {
        ArrayList<DynamicObject> contractListingList = new ArrayList<DynamicObject>(10);
        DynamicObject contractListing = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(listingId.toString()), (String)"pmct_contractlist");
        DynamicObject parentListing = contractListing.getDynamicObject("parent");
        if (parentListing != null) {
            BigDecimal curChangedTaxAmount = contractListing.getBigDecimal("lstoftaxamount").subtract(contractListing.getBigDecimal("oftax"));
            BigDecimal curChangedAmount = contractListing.getBigDecimal("latestamount").subtract(contractListing.getBigDecimal("amount"));
            parentListing = BusinessDataServiceHelper.loadSingle((Object)parentListing.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_contractlist"));
            BigDecimal ofTax = parentListing.getBigDecimal("oftax");
            BigDecimal changedTaxAmount = parentListing.getBigDecimal("lstoftaxamount");
            if (changedTaxAmount.subtract(ofTax).compareTo(curChangedTaxAmount) == 0) {
                ContractListHelper.updateContractParentDataOnUnAudit(contractListingList, parentListing, curChangedTaxAmount, curChangedAmount, Boolean.FALSE);
            } else {
                ContractListHelper.updateContractParentDataOnUnAudit(contractListingList, parentListing, curChangedTaxAmount, curChangedAmount, Boolean.TRUE);
            }
        }
        DynamicObject contractCard = contractMap.get(listingId);
        contractListing.set("amount", (Object)contractCard.getBigDecimal("amount"));
        contractListing.set("totalqty", (Object)contractCard.getBigDecimal("qty"));
        contractListing.set("tax", (Object)contractCard.getBigDecimal("tax"));
        contractListing.set("oftax", (Object)contractCard.getBigDecimal("oftax"));
        contractListing.set("desc", contractCard.get("desc"));
        contractListing.set("changeqty", (Object)0);
        contractListing.set("chgeffectqty", (Object)0);
        contractListing.set("chgoftaxamount", (Object)0);
        contractListing.set("price", (Object)contractCard.getBigDecimal("price"));
        contractListing.set("curtaxprice", (Object)contractCard.getBigDecimal("taxprice"));
        contractListing.set("lstoftaxamount", (Object)contractCard.getBigDecimal("oftax"));
        contractListing.set("latestamount", (Object)contractCard.getBigDecimal("amount"));
        contractListing.set("avgtaxprice", (Object)contractCard.getBigDecimal("taxprice"));
        contractListing.set("ischanged", (Object)Boolean.FALSE);
        contractListingList.add(contractListing);
        SaveServiceHelper.save((DynamicObject[])contractListingList.toArray(new DynamicObject[0]));
    }

    public static void updateContractParentListingData(DynamicObject contractListing, List<DynamicObject> contractListingList, DynamicObject parentListing) {
        parentListing = BusinessDataServiceHelper.loadSingle((Object)parentListing.getPkValue(), (String)"pmct_contractlist");
        parentListing.set("chgoftaxamount", (Object)contractListing.getBigDecimal("chgoftaxamount"));
        parentListing.set("lstoftaxamount", (Object)contractListing.getBigDecimal("lstoftaxamount"));
        parentListing.set("latestamount", (Object)contractListing.getBigDecimal("latestamount"));
        parentListing.set("ischanged", (Object)contractListing.getBoolean("ischanged"));
        contractListingList.add(parentListing);
        parentListing = parentListing.getDynamicObject("parent");
        if (parentListing != null) {
            ContractListHelper.updateContractParentListingData(contractListing, contractListingList, parentListing);
        }
    }

    public static void updateContractParentDataOnAudit(List<DynamicObject> listUpdateList, DynamicObject parentListing, BigDecimal curChangedTaxAmount, BigDecimal curChangedAmount) {
        boolean exitFlag = false;
        int index = 0;
        if (listUpdateList.size() > 0) {
            for (int i = 0; i < listUpdateList.size(); ++i) {
                DynamicObject listing = listUpdateList.get(i);
                if (!listing.getPkValue().equals(parentListing.getPkValue())) continue;
                parentListing = listing;
                exitFlag = true;
                index = i;
                break;
            }
        }
        if (!exitFlag) {
            parentListing = BusinessDataServiceHelper.loadSingle((Object)parentListing.getPkValue(), (String)"pmct_contractlist");
        } else {
            listUpdateList.remove(index);
        }
        parentListing.set("chgoftaxamount", (Object)parentListing.getBigDecimal("chgoftaxamount").add(curChangedTaxAmount));
        parentListing.set("lstoftaxamount", (Object)parentListing.getBigDecimal("lstoftaxamount").add(curChangedTaxAmount));
        parentListing.set("latestamount", (Object)parentListing.getBigDecimal("latestamount").add(curChangedAmount));
        parentListing.set("ischanged", (Object)Boolean.TRUE);
        listUpdateList.add(parentListing);
        parentListing = parentListing.getDynamicObject("parent");
        if (parentListing != null) {
            ContractListHelper.updateContractParentDataOnAudit(listUpdateList, parentListing, curChangedTaxAmount, curChangedAmount);
        }
    }

    public static void updateContractParentDataOnUnAudit(List<DynamicObject> listUpdateList, DynamicObject parentListing, BigDecimal curChangedTaxAmount, BigDecimal curChangedAmount, Boolean isChanged) {
        boolean exitFlag = false;
        int index = 0;
        if (listUpdateList.size() > 0) {
            for (int i = 0; i < listUpdateList.size(); ++i) {
                DynamicObject listing = listUpdateList.get(i);
                if (!listing.getPkValue().equals(parentListing.getPkValue())) continue;
                parentListing = listing;
                exitFlag = true;
                index = i;
                break;
            }
        }
        if (!exitFlag) {
            parentListing = BusinessDataServiceHelper.loadSingle((Object)parentListing.getPkValue(), (String)"pmct_contractlist");
        } else {
            listUpdateList.remove(index);
        }
        parentListing.set("chgoftaxamount", (Object)parentListing.getBigDecimal("chgoftaxamount").subtract(curChangedTaxAmount));
        parentListing.set("lstoftaxamount", (Object)parentListing.getBigDecimal("lstoftaxamount").subtract(curChangedTaxAmount));
        parentListing.set("latestamount", (Object)parentListing.getBigDecimal("latestamount").subtract(curChangedAmount));
        parentListing.set("ischanged", (Object)isChanged);
        listUpdateList.add(parentListing);
        parentListing = parentListing.getDynamicObject("parent");
        if (parentListing != null) {
            ContractListHelper.updateContractParentDataOnUnAudit(listUpdateList, parentListing, curChangedTaxAmount, curChangedAmount, isChanged);
        }
    }

    public static String genSysNumberRule(DynamicObject[] listings, List<String> excludeSysNum) {
        String sysNum = "";
        if (listings.length <= 0) {
            int num = 1;
            sysNum = "001";
            while (excludeSysNum.contains(sysNum)) {
                sysNum = String.format("%03d", ++num);
            }
        } else {
            int num;
            for (DynamicObject listing : listings) {
                String curSysNum = listing.getString("sysnumber");
                if (StringUtils.isEmpty((CharSequence)curSysNum) || curSysNum.contains(".") || !ContractListHelper.isDigitStr(curSysNum)) continue;
                if (StringUtils.isEmpty((CharSequence)sysNum)) {
                    sysNum = curSysNum;
                    continue;
                }
                if (sysNum.compareTo(curSysNum) >= 0) continue;
                sysNum = curSysNum;
            }
            if (StringUtils.isEmpty((CharSequence)sysNum)) {
                sysNum = "001";
                num = 1;
            } else {
                num = Integer.parseInt(sysNum);
                sysNum = String.format("%03d", ++num);
            }
            while (excludeSysNum.contains(sysNum)) {
                sysNum = String.format("%03d", ++num);
            }
        }
        return sysNum;
    }

    public static boolean isDigitStr(String curSysNum) {
        boolean isDigitStr = true;
        for (int i = 0; i < curSysNum.length(); ++i) {
            char c = curSysNum.charAt(i);
            if (c >= '0' && c <= '9') continue;
            isDigitStr = false;
            break;
        }
        return isDigitStr;
    }
}

