/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.business.helper;

import java.math.BigDecimal;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmbs.common.enums.PayDirectionEnum;
import kd.pmgt.pmbs.common.utils.NumberHelper;
import kd.pmgt.pmbs.common.utils.SystemParamHelper;
import kd.pmgt.pmct.business.model.ContractValidateResult;

public class ContractRelationBillValidateHelper {
    @Deprecated
    public static ContractValidateResult chargeByPlanNeedPlanEntry(DynamicObjectCollection contractPlanEntries, String payDirection) {
        Object appParameter = Optional.ofNullable(SystemParamHelper.getAppParameter((String)"chargebyplan", (String)"pmct")).orElse("false");
        boolean chargeByPlan = Boolean.parseBoolean(appParameter.toString());
        String msg = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6536\u6b3e\u8ba1\u5212\u3002", (String)"ContractRelationBillValidateHelper_0", (String)"pmgt-pmct-business", (Object[])new Object[0]);
        if (StringUtils.equals((CharSequence)PayDirectionEnum.OUT.getValue(), (CharSequence)payDirection)) {
            msg = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u4ed8\u6b3e\u8ba1\u5212\u3002", (String)"ContractRelationBillValidateHelper_1", (String)"pmgt-pmct-business", (Object[])new Object[0]);
        }
        if (chargeByPlan && contractPlanEntries.isEmpty()) {
            return new ContractValidateResult(true, msg);
        }
        return new ContractValidateResult(false, "");
    }

    @Deprecated
    public static ContractValidateResult chargeByPlanNeedPlanEntry(DynamicObject bill, String entryFormId, String payDirection) {
        DynamicObjectCollection contractPlanEntries = bill.getDynamicObjectCollection(entryFormId);
        DynamicObject contract = BusinessDataServiceHelper.loadSingle((Object)bill.getDynamicObject("contract").getPkValue(), (String)"pmct_contracttpl");
        DynamicObject contractType = contract.getDynamicObject("contracttype");
        boolean chargeByPlan = (contractType = BusinessDataServiceHelper.loadSingle((Object)contractType.getPkValue(), (String)"pmct_conttype")).getBoolean("enable") && contractType.getBoolean("chargebyplan");
        String msg = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6536\u6b3e\u8ba1\u5212\u3002", (String)"ContractRelationBillValidateHelper_0", (String)"pmgt-pmct-business", (Object[])new Object[0]);
        if (StringUtils.equals((CharSequence)PayDirectionEnum.OUT.getValue(), (CharSequence)payDirection)) {
            msg = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u4ed8\u6b3e\u8ba1\u5212\u3002", (String)"ContractRelationBillValidateHelper_1", (String)"pmgt-pmct-business", (Object[])new Object[0]);
        }
        if (chargeByPlan && contractPlanEntries.isEmpty()) {
            return new ContractValidateResult(true, msg);
        }
        return new ContractValidateResult(false, "");
    }

    public static ContractValidateResult checkOriginalOfTaxAmount(BigDecimal latestAmountOfTax, DynamicObjectCollection contractPlanEntries, String payDirection) {
        String msg = StringUtils.equals((CharSequence)PayDirectionEnum.OUT.getValue(), (CharSequence)payDirection) ? ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\uff0c\u4ed8\u6b3e\u8ba1\u5212\u542b\u7a0e\u91d1\u989d\u5408\u8ba1\u4e0d\u7b49\u4e8e\u542b\u7a0e\u5408\u540c\u603b\u91d1\u989d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ContractRelationBillValidateHelper_2", (String)"pmgt-pmct-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\uff0c\u6536\u6b3e\u8ba1\u5212\u542b\u7a0e\u91d1\u989d\u5408\u8ba1\u4e0d\u7b49\u4e8e\u542b\u7a0e\u5408\u540c\u603b\u91d1\u989d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ContractRelationBillValidateHelper_3", (String)"pmgt-pmct-business", (Object[])new Object[0]);
        String amountIdentification = StringUtils.equals((CharSequence)PayDirectionEnum.OUT.getValue(), (CharSequence)payDirection) ? "payamountoftax" : "incomeamountoftax";
        BigDecimal totalAmount = contractPlanEntries.stream().map(entry -> entry.getBigDecimal(amountIdentification)).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (!contractPlanEntries.isEmpty() && totalAmount.compareTo(latestAmountOfTax) != 0) {
            return new ContractValidateResult(true, msg);
        }
        return new ContractValidateResult(false, "");
    }

    public static ContractValidateResult checkOriginalOfTaxAmount(DynamicObject currency, BigDecimal latestAmountOfTax, DynamicObjectCollection contractPlanEntries, String payDirection) {
        String msg = StringUtils.equals((CharSequence)PayDirectionEnum.OUT.getValue(), (CharSequence)payDirection) ? ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\uff0c\u4ed8\u6b3e\u8ba1\u5212\u542b\u7a0e\u91d1\u989d\u5408\u8ba1\u4e0d\u7b49\u4e8e\u542b\u7a0e\u5408\u540c\u603b\u91d1\u989d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ContractRelationBillValidateHelper_2", (String)"pmgt-pmct-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25\uff0c\u6536\u6b3e\u8ba1\u5212\u542b\u7a0e\u91d1\u989d\u5408\u8ba1\u4e0d\u7b49\u4e8e\u542b\u7a0e\u5408\u540c\u603b\u91d1\u989d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ContractRelationBillValidateHelper_3", (String)"pmgt-pmct-business", (Object[])new Object[0]);
        String amountIdentification = StringUtils.equals((CharSequence)PayDirectionEnum.OUT.getValue(), (CharSequence)payDirection) ? "payamountoftax" : "incomeamountoftax";
        int amtprecision = currency != null ? currency.getInt("amtprecision") : 10;
        BigDecimal totalAmount = contractPlanEntries.stream().map(entry -> entry.getBigDecimal(amountIdentification).setScale(amtprecision, 4)).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (!contractPlanEntries.isEmpty() && totalAmount.compareTo(latestAmountOfTax) != 0) {
            return new ContractValidateResult(true, msg);
        }
        return new ContractValidateResult(false, "");
    }

    public static ContractValidateResult checkPayAmount(DynamicObjectCollection contractPayPlanEntries) {
        StringBuilder errMsg = new StringBuilder();
        for (int i = 0; i < contractPayPlanEntries.size(); ++i) {
            BigDecimal appliedComAmt;
            DynamicObject changePayPlanEntryObj = (DynamicObject)contractPayPlanEntries.get(i);
            BigDecimal payOfTaxAmount = changePayPlanEntryObj.getBigDecimal("payamountoftax");
            String conPayItemId = changePayPlanEntryObj.getString("conplanitemid");
            if (!StringUtils.isNotBlank((CharSequence)conPayItemId)) continue;
            DynamicObject conPayItemObj = BusinessDataServiceHelper.loadSingle((Object)conPayItemId, (String)"pmbs_contractpayitem");
            BigDecimal reimbursedComAmt = conPayItemObj.getBigDecimal("reimbursedcomamt");
            BigDecimal paidComAmt = conPayItemObj.getBigDecimal("paidcomamt");
            if (paidComAmt.compareTo(reimbursedComAmt) > 0) {
                if (payOfTaxAmount.compareTo(paidComAmt) < 0) {
                    if (StringUtils.isNotBlank((CharSequence)errMsg.toString())) {
                        errMsg.append('\n');
                    }
                    errMsg.append(String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u8ba1\u5212\u7b2c%s\u9879\uff0c\u542b\u7a0e\u91d1\u989d\u5c0f\u4e8e\u8be5\u9879\u5df2\u4ed8\u6b3e\u91d1\u989d\uff08\u542b\u5728\u9014\uff09\u3002", (String)"ContractRelationBillValidateHelper_11", (String)"pmgt-pmct-business", (Object[])new Object[0]), i + 1));
                }
            } else if (payOfTaxAmount.compareTo(reimbursedComAmt) < 0) {
                if (StringUtils.isNotBlank((CharSequence)errMsg.toString())) {
                    errMsg.append('\n');
                }
                errMsg.append(String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u8ba1\u5212\u7b2c%s\u9879\uff0c\u542b\u7a0e\u91d1\u989d\u5c0f\u4e8e\u8be5\u9879\u5df2\u62a5\u9500\u91d1\u989d\uff08\u542b\u5728\u9014\uff09\u3002", (String)"ContractRelationBillValidateHelper_12", (String)"pmgt-pmct-business", (Object[])new Object[0]), i + 1));
            }
            if (NumberHelper.compareValue((Object)payOfTaxAmount, (Object)(appliedComAmt = conPayItemObj.getBigDecimal("appliedcomamt"))) >= 0) continue;
            if (StringUtils.isNotBlank((CharSequence)errMsg.toString())) {
                errMsg.append('\n');
            }
            errMsg.append(String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u8ba1\u5212\u7b2c%s\u9879\uff0c\u542b\u7a0e\u91d1\u989d\u5c0f\u4e8e\u8be5\u9879\u5df2\u7533\u8bf7\u91d1\u989d\uff08\u542b\u5728\u9014\uff09\u3002", (String)"ContractRelationBillValidateHelper_13", (String)"pmgt-pmct-business", (Object[])new Object[0]), i + 1));
        }
        if (StringUtils.isNotBlank((CharSequence)errMsg.toString())) {
            return new ContractValidateResult(true, errMsg.toString());
        }
        return new ContractValidateResult(false, "");
    }

    public static ContractValidateResult checkCollectAmount(DynamicObjectCollection contractPlanEntries) {
        StringBuilder errMsg = new StringBuilder();
        for (int i = 0; i < contractPlanEntries.size(); ++i) {
            BigDecimal appliedComAmt;
            DynamicObject changeIncomePlanEntryObj = (DynamicObject)contractPlanEntries.get(i);
            BigDecimal incomeOfTaxAmount = changeIncomePlanEntryObj.getBigDecimal("incomeamountoftax");
            String conCollectItemId = changeIncomePlanEntryObj.getString("conplanitemid");
            if (!StringUtils.isNotBlank((CharSequence)conCollectItemId)) continue;
            DynamicObject conCollectItemObj = BusinessDataServiceHelper.loadSingle((Object)conCollectItemId, (String)"pmbs_contractcollectitem");
            BigDecimal collectedComAmt = conCollectItemObj.getBigDecimal("collectedcomamt");
            if (incomeOfTaxAmount.compareTo(collectedComAmt) < 0) {
                errMsg.append('\n');
                errMsg.append(String.format(ResManager.loadKDString((String)"\u6536\u6b3e\u8ba1\u5212\u7b2c%s\u9879\uff0c\u542b\u7a0e\u91d1\u989d\u5c0f\u4e8e\u8be5\u9879\u5df2\u6536\u6b3e\u91d1\u989d\uff08\u542b\u5728\u9014\uff09,\u4e0d\u80fd\u63d0\u4ea4\uff0c\u8bf7\u4fee\u6539\u6570\u636e\u540e\u91cd\u65b0\u63d0\u4ea4\u3002", (String)"ContractRelationBillValidateHelper_6", (String)"pmgt-pmct-business", (Object[])new Object[0]), i + 1));
            }
            if (NumberHelper.compareValue((Object)incomeOfTaxAmount, (Object)(appliedComAmt = conCollectItemObj.getBigDecimal("appliedcomamt"))) >= 0) continue;
            errMsg.append('\n');
            errMsg.append(String.format(ResManager.loadKDString((String)"\u6536\u6b3e\u8ba1\u5212\u7b2c%s\u9879\uff0c\u542b\u7a0e\u91d1\u989d\u5c0f\u4e8e\u8be5\u9879\u5df2\u8bf7\u6b3e\u91d1\u989d\uff08\u542b\u5728\u9014\uff09\u3002", (String)"ContractRelationBillValidateHelper_14", (String)"pmgt-pmct-business", (Object[])new Object[0]), i + 1));
        }
        if (StringUtils.isNotBlank((CharSequence)errMsg.toString())) {
            return new ContractValidateResult(true, errMsg.toString());
        }
        return new ContractValidateResult(false, "");
    }
}

