/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.business.helper;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmbs.common.enums.ContractPayItemSourceEnum;
import kd.pmgt.pmbs.common.enums.DefaultEnum;
import kd.pmgt.pmbs.common.enums.PayPlanSourceEnum;

public class FundPlanChangeHelper {
    private static final Log logger = LogFactory.getLog(FundPlanChangeHelper.class);
    private static final int BUILDTYPE_UPDATE = 1;
    private static final int BUILDTYPE_NEW = 2;
    private static final int BUILDTYPE_DELETE = 3;
    private String srcFormId;

    public DynamicObject buildFundPlanChangeEntry(Object sourcePk, Object contractPk, String changeType, DynamicObject[] customEntries, String srcFormId, boolean needBillHead) {
        this.srcFormId = srcFormId;
        DynamicObject fundPlanChangeObj = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_fundplanchange"));
        DynamicObjectCollection changeEntries = fundPlanChangeObj.getDynamicObjectCollection("changeentity");
        if (needBillHead) {
            this.buildEntryHead(sourcePk, changeType, fundPlanChangeObj);
        }
        QFilter sourceBillIdFilter = new QFilter("sourcebillid", "=", sourcePk);
        QFilter typeFilter = new QFilter("payplansource", "=", (Object)changeType);
        DynamicObject[] fundPlanChangeBills = BusinessDataServiceHelper.load((String)"pmct_fundplanchange", (String)"id", (QFilter[])new QFilter[]{sourceBillIdFilter, typeFilter});
        if (fundPlanChangeBills.length == 0) {
            QFilter contractFilter = new QFilter("contract", "=", contractPk);
            QFilter sourceFilter = new QFilter("source", "=", (Object)ContractPayItemSourceEnum.PAYPLAN.getValue());
            QFilter autoGeneFilter = new QFilter("autogenerated", "=", (Object)DefaultEnum.NO.getValue());
            DynamicObject[] contractPayItems = BusinessDataServiceHelper.load((String)"pmbs_contractpayitem", (String)"id", (QFilter[])new QFilter[]{contractFilter, sourceFilter, autoGeneFilter});
            contractPayItems = Arrays.stream(contractPayItems).map(item -> BusinessDataServiceHelper.loadSingle((Object)item.getPkValue(), (String)"pmbs_contractpayitem")).collect(Collectors.toList()).toArray(new DynamicObject[0]);
            this.fillFundPlanChangeEntry(customEntries, changeEntries, contractPayItems);
        } else {
            fundPlanChangeObj = BusinessDataServiceHelper.loadSingle((Object)fundPlanChangeBills[0].getPkValue(), (String)"pmct_fundplanchange");
        }
        DynamicObject contract = BusinessDataServiceHelper.loadSingle((Object)contractPk, (String)"pmct_contracttpl");
        fundPlanChangeObj.set("currency", contract.get("currency"));
        return fundPlanChangeObj;
    }

    private void buildEntryHead(Object sourceId, String changeType, DynamicObject fundPlanChangeObj) {
        DynamicObject sourceBill = StringUtils.equals((CharSequence)PayPlanSourceEnum.REVISE.getValue(), (CharSequence)changeType) ? BusinessDataServiceHelper.loadSingle((Object)sourceId, (String)"pmct_contractrevision") : (StringUtils.equals((CharSequence)PayPlanSourceEnum.MODIFY.getValue(), (CharSequence)changeType) ? BusinessDataServiceHelper.loadSingle((Object)sourceId, (String)"pmct_revisiontpl") : (StringUtils.equals((CharSequence)PayPlanSourceEnum.CLAIM.getValue(), (CharSequence)changeType) ? BusinessDataServiceHelper.loadSingle((Object)sourceId, (String)"pmct_outclaimbill") : BusinessDataServiceHelper.loadSingle((Object)sourceId, (String)"pmct_addagreementtpl")));
        Object contractPk = sourceBill.getDynamicObject("contract").getPkValue();
        DynamicObject contract = BusinessDataServiceHelper.loadSingle((Object)contractPk, (String)"pmct_contracttpl");
        fundPlanChangeObj.set("currency", contract.get("currency"));
        fundPlanChangeObj.set("payplansource", (Object)changeType);
    }

    protected void fillFundPlanChangeEntry(DynamicObject[] customEntries, DynamicObjectCollection changeEntries, DynamicObject[] contractPayItems) {
        long contractPayItemPk;
        long pk;
        int n;
        DynamicObject customEntry = null;
        DynamicObject contractPayItem = null;
        boolean contains = false;
        String conPayItemId = "";
        switch (this.srcFormId) {
            case "pmct_contractrevision": {
                conPayItemId = "conpayitemid";
                break;
            }
            case "pmct_outcontractrevision": {
                conPayItemId = "conplanitemid";
                break;
            }
            case "pmct_outaddagreement": {
                conPayItemId = "conplanitemid";
                break;
            }
            case "pmct_outclaimbill": {
                conPayItemId = "conplanitemid";
                break;
            }
        }
        DynamicObject[] dynamicObjectArray = contractPayItems;
        int n2 = dynamicObjectArray.length;
        for (n = 0; n < n2; ++n) {
            DynamicObject item;
            contractPayItem = item = dynamicObjectArray[n];
            for (DynamicObject entry : customEntries) {
                pk = entry.getLong(conPayItemId);
                contractPayItemPk = Long.parseLong(String.valueOf(item.getPkValue()));
                if (contractPayItemPk == pk) {
                    customEntry = entry;
                    contains = true;
                    this.buildItem(changeEntries, customEntry, contractPayItem, 1);
                    break;
                }
                customEntry = null;
                contains = false;
            }
            if (contains) continue;
            this.buildItem(changeEntries, customEntry, contractPayItem, 3);
        }
        dynamicObjectArray = customEntries;
        n2 = dynamicObjectArray.length;
        for (n = 0; n < n2; ++n) {
            DynamicObject entry;
            customEntry = entry = dynamicObjectArray[n];
            for (DynamicObject item : contractPayItems) {
                pk = entry.getLong(conPayItemId);
                contractPayItemPk = Long.parseLong(String.valueOf(item.getPkValue()));
                if (contractPayItemPk == pk) {
                    contains = true;
                    break;
                }
                contractPayItem = null;
                contains = false;
            }
            if (contains) continue;
            this.buildItem(changeEntries, customEntry, contractPayItem, 2);
        }
    }

    private void buildItem(DynamicObjectCollection changeEntries, DynamicObject customEntry, DynamicObject contractPayItem, Integer buildType) {
        DynamicObject changeEntry = changeEntries.addNew();
        changeEntry.set("id", (Object)DB.genLongId((String)"t_pmct_fundplanchange"));
        if (contractPayItem != null) {
            changeEntry.set("supplier", contractPayItem.get("supplier"));
            changeEntry.set("oldpaytype", contractPayItem.get("paytype"));
            changeEntry.set("oldpayfeq", contractPayItem.get("payfeq"));
            changeEntry.set("oldpayway", contractPayItem.get("payway"));
            changeEntry.set("oldpaypercent", contractPayItem.get("paypercent"));
            changeEntry.set("oldpayamount", contractPayItem.get("payamount"));
            changeEntry.set("oldplanpaytime", contractPayItem.get("planpaytime"));
            changeEntry.set("oldpayplanid", contractPayItem.get("payplanentryid"));
            Object nodeSetting = contractPayItem.get("nodesetting");
            changeEntry.set("oldnodesetting", nodeSetting);
            changeEntry.set("oldctrlstrategy", contractPayItem.get("ctrlstrategy"));
            if (nodeSetting != null) {
                changeEntry.set("oldnodesettingsource", contractPayItem.get("nodesettingsource"));
            }
        }
        if (customEntry != null) {
            switch (this.srcFormId) {
                case "pmct_contractrevision": {
                    changeEntry.set("supplier", customEntry.get("supplier"));
                    changeEntry.set("newpaytype", customEntry.get("paytype"));
                    changeEntry.set("newpayfeq", customEntry.get("paymethod"));
                    changeEntry.set("newpayway", customEntry.get("payway"));
                    changeEntry.set("newpaypercent", customEntry.get("paypercent"));
                    changeEntry.set("newpayamount", customEntry.get("payamount"));
                    changeEntry.set("newplanpaytime", customEntry.get("planpaytime"));
                    changeEntry.set("newpayplanid", customEntry.getPkValue());
                    changeEntry.set("seq", customEntry.get("seq"));
                    Object nodeSetting = customEntry.get("nodesetting");
                    changeEntry.set("newnodesetting", nodeSetting);
                    changeEntry.set("newctrlstrategy", customEntry.get("ctrlstrategy"));
                    if (nodeSetting == null) break;
                    changeEntry.set("newnodesettingsource", customEntry.get("nodesettingsource"));
                    break;
                }
                case "pmct_outcontractrevision": {
                    changeEntry.set("supplier", customEntry.get("supplier"));
                    changeEntry.set("newpaytype", customEntry.get("paytype"));
                    changeEntry.set("newpayfeq", customEntry.get("payfeq"));
                    changeEntry.set("newpayway", customEntry.get("payway"));
                    changeEntry.set("newpaypercent", customEntry.get("paypercent"));
                    changeEntry.set("newpayamount", customEntry.get("payamountoftax"));
                    changeEntry.set("newplanpaytime", customEntry.get("planpaytime"));
                    changeEntry.set("newpayplanid", customEntry.getPkValue());
                    changeEntry.set("seq", customEntry.get("seq"));
                    Object nodeSetting = customEntry.get("nodesetting");
                    changeEntry.set("newnodesetting", nodeSetting);
                    changeEntry.set("newctrlstrategy", customEntry.get("ctrlstrategy"));
                    if (nodeSetting == null) break;
                    changeEntry.set("newnodesettingsource", customEntry.get("nodesettingsource"));
                    break;
                }
                case "pmct_outaddagreement": {
                    changeEntry.set("supplier", customEntry.get("supplier"));
                    changeEntry.set("newpaytype", customEntry.get("paytype"));
                    changeEntry.set("newpayfeq", customEntry.get("payfeq"));
                    changeEntry.set("newpayway", customEntry.get("payway"));
                    changeEntry.set("newpaypercent", customEntry.get("paypercent"));
                    changeEntry.set("newpayamount", customEntry.get("payamountoftax"));
                    changeEntry.set("newplanpaytime", customEntry.get("planpaytime"));
                    changeEntry.set("newpayplanid", customEntry.getPkValue());
                    changeEntry.set("seq", customEntry.get("seq"));
                    Object nodeSetting = customEntry.get("nodesetting");
                    changeEntry.set("newnodesetting", nodeSetting);
                    changeEntry.set("newctrlstrategy", customEntry.get("ctrlstrategy"));
                    if (nodeSetting == null) break;
                    changeEntry.set("newnodesettingsource", customEntry.get("nodesettingsource"));
                    break;
                }
                case "pmct_outclaimbill": {
                    changeEntry.set("supplier", customEntry.get("supplier"));
                    changeEntry.set("newpaytype", customEntry.get("paytype"));
                    changeEntry.set("newpayfeq", customEntry.get("payfeq"));
                    changeEntry.set("newpayway", customEntry.get("payway"));
                    changeEntry.set("newpaypercent", customEntry.get("paypercent"));
                    changeEntry.set("newpayamount", customEntry.get("payamountoftax"));
                    changeEntry.set("newplanpaytime", customEntry.get("planpaytime"));
                    changeEntry.set("newpayplanid", customEntry.getPkValue());
                    changeEntry.set("seq", customEntry.get("seq"));
                    Object nodeSetting = customEntry.get("nodesetting");
                    changeEntry.set("newnodesetting", nodeSetting);
                    changeEntry.set("newctrlstrategy", customEntry.get("ctrlstrategy"));
                    if (nodeSetting == null) break;
                    changeEntry.set("newnodesettingsource", customEntry.get("nodesettingsource"));
                    break;
                }
            }
        }
        if (contractPayItem != null && customEntry != null && buildType == 1) {
            BigDecimal reimbursedComAmt = (BigDecimal)contractPayItem.get("reimbursedcomamt");
            BigDecimal paidComAmt = (BigDecimal)contractPayItem.get("paidcomamt");
            BigDecimal payAmountOfTax = BigDecimal.ZERO;
            switch (this.srcFormId) {
                case "pmct_contractrevision": {
                    payAmountOfTax = (BigDecimal)customEntry.get("payamount");
                    changeEntry.set("reimbursableamt", (Object)payAmountOfTax.subtract(reimbursedComAmt));
                    changeEntry.set("unpaidamt", (Object)payAmountOfTax.subtract(paidComAmt));
                    break;
                }
                case "pmct_outcontractrevision": {
                    payAmountOfTax = (BigDecimal)customEntry.get("payamountoftax");
                    changeEntry.set("reimbursableamt", (Object)payAmountOfTax.subtract(reimbursedComAmt));
                    changeEntry.set("unpaidamt", (Object)payAmountOfTax.subtract(paidComAmt));
                    break;
                }
                case "pmct_outaddagreement": {
                    payAmountOfTax = (BigDecimal)customEntry.get("payamountoftax");
                    changeEntry.set("reimbursableamt", (Object)payAmountOfTax.subtract(reimbursedComAmt));
                    changeEntry.set("unpaidamt", (Object)payAmountOfTax.subtract(paidComAmt));
                    break;
                }
                case "pmct_outclaimbill": {
                    payAmountOfTax = (BigDecimal)customEntry.get("payamountoftax");
                    changeEntry.set("reimbursableamt", (Object)payAmountOfTax.subtract(reimbursedComAmt));
                    changeEntry.set("unpaidamt", (Object)payAmountOfTax.subtract(paidComAmt));
                }
            }
            changeEntry.set("reimbursedamt", contractPayItem.get("reimbursedamt"));
            changeEntry.set("reimbursedcomamt", (Object)reimbursedComAmt);
            changeEntry.set("paidamt", contractPayItem.get("paidamt"));
            changeEntry.set("paidcomamt", (Object)paidComAmt);
            changeEntry.set("appliedamt", contractPayItem.get("appliedamt"));
            changeEntry.set("appliedcomamt", contractPayItem.get("appliedcomamt"));
            changeEntry.set("appliableamt", contractPayItem.get("appliableamt"));
        } else if (buildType == 2) {
            Object newPayAmountOfTax = changeEntry.get("newpayamount");
            changeEntry.set("reimbursableamt", newPayAmountOfTax);
            changeEntry.set("unpaidamt", newPayAmountOfTax);
            changeEntry.set("appliableamt", newPayAmountOfTax);
        } else if (buildType == 3) {
            changeEntry.set("reimbursableamt", (Object)0);
            changeEntry.set("unpaidamt", (Object)0);
            changeEntry.set("appliableamt", (Object)0);
        }
        BigDecimal newPayAmount = Optional.ofNullable(changeEntry.getBigDecimal("newpayamount")).orElse(BigDecimal.ZERO);
        BigDecimal oldPayAmount = Optional.ofNullable(changeEntry.getBigDecimal("oldpayamount")).orElse(BigDecimal.ZERO);
        changeEntry.set("changepayamount", (Object)newPayAmount.subtract(oldPayAmount));
    }
}

