/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.business.helper;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.path.DecodeFileFactory;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.session.SessionDAO;
import kd.bos.session.SessionDAOFactory;
import kd.bos.url.UrlService;
import kd.pmgt.pmbs.business.helper.ContractHelper;
import kd.pmgt.pmbs.common.enums.InvoiceSellerParamEnum;
import kd.pmgt.pmbs.common.enums.InvoiceSourceEnum;
import kd.pmgt.pmbs.common.enums.InvoiceStatusEnum;
import kd.pmgt.pmbs.common.enums.OperationEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;
import kd.pmgt.pmbs.common.utils.TextHelper;

public class InvoiceHelper {
    private static final Log log = LogFactory.getLog(InvoiceHelper.class);

    public static void deleteInvoice(DynamicObject invoice, String curBillId) {
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put("billId", curBillId);
        map.put("entityId", "pmct_paymentapply");
        JSONObject result = (JSONObject)DispatchServiceHelper.invokeBizService((String)"imc", (String)"rim", (String)"FpzsService", (String)"delete", (Object[])new Object[]{map});
        if (!"0000".equals(result.getString("errcode"))) {
            log.error(String.format("---\u5220\u9664\u53d1\u7968\u4e91\u53d1\u7968\u4e1a\u52a1\u5355\u636e\u4fe1\u606f\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", result.getString("description")));
        }
        HashSet<Long> deleteInvoice = new HashSet<Long>();
        String invoiceSourceId = invoice.getString("invoicesourceid");
        boolean isQuote = QueryServiceHelper.exists((String)"pmct_paymentapply", (Object)invoiceSourceId);
        if (!isQuote) {
            isQuote = QueryServiceHelper.exists((String)"pmct_applymentpay", (Object)invoiceSourceId);
        }
        if (!isQuote) {
            isQuote = QueryServiceHelper.exists((String)"pmct_outcontract", (Object)invoiceSourceId);
        }
        if (invoiceSourceId.equals(curBillId)) {
            DynamicObject quoteBill = InvoiceHelper.verifyQuote(invoice, curBillId);
            if (quoteBill == null) {
                isQuote = false;
            } else {
                String errorTip = String.format(ResManager.loadKDString((String)"\u5df2\u5728\u4e1a\u52a1\u5355\u636e\u4ed8\u6b3e\u7533\u8bf7\u5355\u7f16\u7801\u4e3a\uff1a%1$s\u4e2d\u8ba4\u9886\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u53d1\u7968\u3002", (String)"InvoiceHelper_14", (String)"pmgt-pmct-business", (Object[])new Object[0]), quoteBill.getString("billno"));
                throw new KDBizException(errorTip);
            }
        }
        if (!isQuote) {
            DynamicObject contract = invoice.getDynamicObject("contract");
            if (contract != null) {
                invoice.set("invoicestatus", (Object)InvoiceStatusEnum.CANCEL_2.getValue());
                ContractHelper.updateContractInvoiceAmount((DynamicObject)contract, (DynamicObject)invoice, (String)OperationEnum.UNAUDIT.getValue());
            }
            deleteInvoice.add(Long.parseLong(invoice.getPkValue().toString()));
        }
        if (deleteInvoice.size() > 0) {
            DeleteServiceHelper.delete((String)"pmct_ininvoice", (QFilter[])new QFilter[]{new QFilter("id", "in", deleteInvoice)});
            ArrayList<String> invoiceList = new ArrayList<String>(16);
            invoiceList.add(invoice.getString("serialno"));
            result = (JSONObject)DispatchServiceHelper.invokeBizService((String)"imc", (String)"rim", (String)"FpzsService", (String)"deleteInvoice", (Object[])new Object[]{invoiceList});
            if (!"0000".equals(result.getString("errcode"))) {
                log.error(String.format("---\u5220\u9664\u53d1\u7968\u4e91\u53d1\u7968\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", result.getString("description")));
            }
        }
    }

    public static DynamicObject verifyQuote(DynamicObject invoice, String curBillId) {
        DynamicObject[] applyInvoices;
        DynamicObject quoteBill = null;
        for (DynamicObject applyInvoice : applyInvoices = BusinessDataServiceHelper.load((String)"pmct_applyinvoice", (String)"invoice,entryid", (QFilter[])new QFilter[0])) {
            if (applyInvoice.getDynamicObject("invoice") == null || !invoice.getPkValue().toString().equals(applyInvoice.getDynamicObject("invoice").getString("id"))) continue;
            QFilter filter = new QFilter("entryentity.id", "=", (Object)applyInvoice.getLong("entryid"));
            filter.and(new QFilter("id", "!=", (Object)Long.parseLong(curBillId)));
            DynamicObject bill = BusinessDataServiceHelper.loadSingle((String)"pmct_paymentapply", (String)"billno", (QFilter[])new QFilter[]{filter});
            if (bill == null) continue;
            quoteBill = bill;
            break;
        }
        if (quoteBill == null) {
            QFilter filter = new QFilter("invoiceentry.invoice", "=", (Object)Long.parseLong(invoice.getPkValue().toString()));
            filter.and(new QFilter("id", "!=", (Object)Long.parseLong(curBillId)));
            DynamicObject bill = BusinessDataServiceHelper.loadSingle((String)"pmct_applymentpay", (String)"billno", (QFilter[])new QFilter[]{filter});
            if (bill != null) {
                quoteBill = bill;
            }
        }
        return quoteBill;
    }

    public static boolean checkIsQuote(DynamicObject invoice, String curBillId) {
        DynamicObject[] applyInvoices;
        boolean isQuote = false;
        for (DynamicObject applyInvoice : applyInvoices = BusinessDataServiceHelper.load((String)"pmct_applyinvoice", (String)"invoice,entryid", (QFilter[])new QFilter[0])) {
            if (applyInvoice.getDynamicObject("invoice") == null || !invoice.getPkValue().toString().equals(applyInvoice.getDynamicObject("invoice").getString("id"))) continue;
            QFilter filter = new QFilter("entryentity.id", "=", (Object)applyInvoice.getLong("entryid"));
            filter.and(new QFilter("id", "!=", (Object)Long.parseLong(curBillId)));
            DynamicObject[] bills = BusinessDataServiceHelper.load((String)"pmct_paymentapply", (String)"id", (QFilter[])new QFilter[]{filter});
            boolean bl = isQuote = bills != null && bills.length > 0;
            if (isQuote) break;
        }
        if (!isQuote) {
            QFilter filter = new QFilter("invoiceentry.invoice", "=", (Object)Long.parseLong(invoice.getPkValue().toString()));
            filter.and(new QFilter("id", "!=", (Object)Long.parseLong(curBillId)));
            DynamicObject[] bills = BusinessDataServiceHelper.load((String)"pmct_applymentpay", (String)"id", (QFilter[])new QFilter[]{filter});
            isQuote = bills != null && bills.length > 0;
        }
        return isQuote;
    }

    public static boolean checkIsQuoteByCheckApplyPay(DynamicObject invoice, String curBillId) {
        DynamicObject[] applyInvoices;
        boolean isQuote = false;
        for (DynamicObject applyInvoice : applyInvoices = BusinessDataServiceHelper.load((String)"pmct_applyinvoice", (String)"invoice,entryid", (QFilter[])new QFilter[0])) {
            if (applyInvoice.getDynamicObject("invoice") == null || !invoice.getPkValue().toString().equals(applyInvoice.getDynamicObject("invoice").getString("id"))) continue;
            QFilter filter = new QFilter("entryentity.id", "=", (Object)applyInvoice.getLong("entryid"));
            filter.and(new QFilter("id", "!=", (Object)Long.parseLong(curBillId)));
            filter.and(new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue()));
            DynamicObject[] bills = BusinessDataServiceHelper.load((String)"pmct_paymentapply", (String)"id", (QFilter[])new QFilter[]{filter});
            boolean bl = isQuote = bills != null && bills.length > 0;
            if (isQuote) break;
        }
        if (!isQuote) {
            QFilter filter = new QFilter("invoiceentry.invoice", "=", (Object)Long.parseLong(invoice.getPkValue().toString()));
            filter.and(new QFilter("id", "!=", (Object)Long.parseLong(curBillId)));
            filter.and(new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue()));
            DynamicObject[] bills = BusinessDataServiceHelper.load((String)"pmct_applymentpay", (String)"id", (QFilter[])new QFilter[]{filter});
            isQuote = bills != null && bills.length > 0;
        }
        return isQuote;
    }

    private static OperateOption create(OperateOption option, boolean isHasRight) {
        if (isHasRight) {
            option.setVariableValue("ishasright", Boolean.TRUE.toString());
        }
        return option;
    }

    public static boolean verifyClaim(ListSelectedRowCollection selCols, IFormView view) {
        ArrayList<Integer> rowIndexList = new ArrayList<Integer>();
        for (ListSelectedRow selRow : selCols) {
            Object invPk = selRow.getPrimaryKeyValue();
            DynamicObject inv = BusinessDataServiceHelper.loadSingle((Object)invPk, (String)"pmct_ininvoice", (String)"name,number,isclaimed");
            boolean isClaimed = inv.getBoolean("isclaimed");
            if (!isClaimed) continue;
            rowIndexList.add(selRow.getRowKey());
        }
        Collections.sort(rowIndexList);
        if (rowIndexList.size() > 0) {
            StringBuffer rowIndexs = new StringBuffer();
            for (int i = 0; i < rowIndexList.size(); ++i) {
                rowIndexs.append((Integer)rowIndexList.get(i) + 1);
                if (i == rowIndexList.size() - 1) continue;
                rowIndexs.append("\u3001");
            }
            view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u53d1\u7968\u5df2\u8ba4\u9886\uff0c\u65e0\u6cd5\u518d\u6b21\u8ba4\u9886\u3002", (String)"InvoiceHelper_13", (String)"pmgt-pmct-business", (Object[])new Object[0]), rowIndexs));
            return false;
        }
        return true;
    }

    public static DynamicObject verifyUnClaim(DynamicObject listing) {
        DynamicObject[] col1;
        DynamicObject quoteBill = null;
        DynamicObject inv = BusinessDataServiceHelper.loadSingle((Object)listing.getPkValue(), (String)"pmct_ininvoice", (String)"billno,name,number,isclaimed");
        for (DynamicObject dobj : col1 = BusinessDataServiceHelper.load((String)"pmct_applyinvoice", (String)"invoice,entryid", (QFilter[])new QFilter[0])) {
            DynamicObject bill;
            if (dobj.getDynamicObject("invoice") == null || !inv.getPkValue().toString().equals(dobj.getDynamicObject("invoice").getString("id")) || (bill = BusinessDataServiceHelper.loadSingle((String)"pmct_paymentapply", (String)"billno,entryentity.id", (QFilter[])new QFilter[]{new QFilter("entryentity.id", "=", (Object)dobj.getLong("entryid"))})) == null) continue;
            quoteBill = bill;
            break;
        }
        return quoteBill;
    }

    public static boolean verifyOrg(DynamicObject[] dynamicObjects, HashSet<Long> objects, IFormView view) {
        int length = dynamicObjects.length;
        for (int i = 0; i < length; ++i) {
            DynamicObject org = dynamicObjects[i].getDynamicObject("org");
            Object pkValue = org.getPkValue();
            objects.add(Long.valueOf(pkValue.toString()));
        }
        if (objects.size() != 1) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u53d1\u7968\u4e0d\u5c5e\u4e8e\u540c\u4e00\u7ec4\u7ec7\uff0c\u4e0d\u80fd\u6279\u91cf\u8ba4\u9886\u3002", (String)"InvoiceHelper_8", (String)"pmgt-pmct-business", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public static boolean verifyProjectOnly(DynamicObject[] outInvoices) {
        if (outInvoices != null && outInvoices.length > 1) {
            HashSet<Long> projectIds = new HashSet<Long>();
            for (DynamicObject outInvoice : outInvoices) {
                DynamicObject project = outInvoice.getDynamicObject("project");
                if (project == null) {
                    return false;
                }
                projectIds.add(project.getLong("id"));
            }
            return projectIds.size() == 1;
        }
        return false;
    }

    public static void processInvoice(JSONObject object, Long org, IFormView view) {
        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> insertList = new ArrayList<DynamicObject>();
        JSONArray invoiceArray = object.getJSONArray("data");
        if (invoiceArray != null && invoiceArray.size() > 0) {
            for (int index = 0; index < invoiceArray.size(); ++index) {
                QFilter saleFilter;
                DynamicObject saler;
                QFilter buyerFilter;
                DynamicObject buyer;
                long currOrg;
                long currUserId;
                List userDepartment;
                DynamicObject dynamicObject;
                JSONObject invoice = invoiceArray.getJSONObject(index);
                String invoiceCode = invoice.getString("invoiceCode");
                String invoiceNo = invoice.getString("invoiceNo");
                QFilter invoiceFilter = new QFilter("invoiceno", "=", (Object)invoiceNo);
                if (!StringUtils.isEmpty((CharSequence)invoiceCode)) {
                    invoiceFilter.and("invoicecode", "=", (Object)invoiceCode);
                }
                if ((dynamicObject = BusinessDataServiceHelper.loadSingle((String)"pmct_ininvoice", (String)"invoicestatus", (QFilter[])new QFilter[]{invoiceFilter})) != null) {
                    dynamicObject.set("invoicestatus", (Object)invoice.getString("invoiceStatus"));
                    updateList.add(dynamicObject);
                    continue;
                }
                dynamicObject = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_ininvoice"));
                QFilter qFilter = new QFilter("number", "=", (Object)invoice.getString("invoiceType"));
                DynamicObject invoiceType = BusinessDataServiceHelper.loadSingle((String)"bd_invoicetype", (String)"id", (QFilter[])new QFilter[]{qFilter});
                if (invoiceType != null) {
                    dynamicObject.set("invoicetypeid", (Object)invoiceType);
                }
                dynamicObject.set("org", (Object)org);
                Map mapOrg = OrgUnitServiceHelper.getCompanyByOrg((Long)org, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
                if (mapOrg != null && !mapOrg.isEmpty() && mapOrg.get("id") != null) {
                    dynamicObject.set("accountorg", mapOrg.get("id"));
                }
                if ((userDepartment = UserServiceHelper.getUserDepartment((long)(currUserId = RequestContext.get().getCurrUserId()), (boolean)false)).contains(currOrg = RequestContext.get().getOrgId())) {
                    dynamicObject.set("createorg", (Object)currOrg);
                } else {
                    long userMainOrgId = UserServiceHelper.getUserMainOrgId((long)currUserId);
                    dynamicObject.set("createorg", (Object)userMainOrgId);
                }
                boolean exist = CodeRuleServiceHelper.isExist((String)"pmct_ininvoice", (DynamicObject)dynamicObject, (String)String.valueOf(RequestContext.get().getOrgId()));
                if (exist) {
                    CodeRuleServiceHelper.getCodeRule((String)"pmct_ininvoice", (DynamicObject)dynamicObject, (String)String.valueOf(RequestContext.get().getOrgId()));
                } else {
                    dynamicObject.set("billno", (Object)invoice.getString("serialNo"));
                }
                dynamicObject.set("source", (Object)InvoiceSourceEnum.SOURCE_01.getValue());
                dynamicObject.set("invoicecode", (Object)invoice.getString("invoiceCode"));
                dynamicObject.set("invoiceno", (Object)invoice.getString("invoiceNo"));
                dynamicObject.set("invoicedate", (Object)invoice.getDate("invoiceDate"));
                dynamicObject.set("invoicestatus", (Object)invoice.getString("invoiceStatus"));
                dynamicObject.set("totalamount", (Object)invoice.getBigDecimal("invoiceAmount"));
                dynamicObject.set("totaltax", (Object)invoice.getBigDecimal("totalTaxAmount"));
                dynamicObject.set("totaloftaxamount", (Object)invoice.getBigDecimal("totalAmount"));
                String buyerName = invoice.getString("buyerName");
                if (buyerName != null && !buyerName.isEmpty() && (buyer = BusinessDataServiceHelper.loadSingle((String)"bos_org", (String)"name", (QFilter[])new QFilter[]{buyerFilter = new QFilter("name", "=", (Object)buyerName)})) != null) {
                    dynamicObject.set("buyer", (Object)buyer);
                }
                dynamicObject.set("buyertaxno", (Object)invoice.getString("buyerTaxNo"));
                String buyerBankAccount = invoice.getString("buyerAccount");
                if (buyerBankAccount != null) {
                    dynamicObject.set("buyerbank", (Object)TextHelper.getBankName((String)buyerBankAccount));
                    dynamicObject.set("buyeraccount", (Object)TextHelper.getBankNum((String)buyerBankAccount));
                }
                String buyerAddressPhone = invoice.getString("buyerAddressPhone");
                dynamicObject.set("buyeraddress", (Object)TextHelper.getAddress((String)buyerAddressPhone));
                dynamicObject.set("buyerphone", (Object)TextHelper.getPhoneNum((String)buyerAddressPhone));
                String saleName = invoice.getString("salerName");
                if (saleName != null && !saleName.isEmpty() && (saler = BusinessDataServiceHelper.loadSingle((String)"bd_bizpartner", (String)"name", (QFilter[])new QFilter[]{saleFilter = new QFilter("name", "=", (Object)saleName)})) != null) {
                    dynamicObject.set("seller", (Object)saler);
                }
                String salerBankAccount = invoice.getString("salerAccount");
                dynamicObject.set("sellerbank", (Object)TextHelper.getBankName((String)salerBankAccount));
                dynamicObject.set("selleraccount", (Object)TextHelper.getBankNum((String)salerBankAccount));
                String salerAddressPhone = invoice.getString("salerAddressPhone");
                dynamicObject.set("selleraddress", (Object)TextHelper.getAddress((String)salerAddressPhone));
                dynamicObject.set("sellerphone", (Object)TextHelper.getPhoneNum((String)salerAddressPhone));
                dynamicObject.set("billstatus", (Object)"C");
                dynamicObject.set("createtime", (Object)new Date());
                DynamicObjectCollection entryentitys = dynamicObject.getDynamicObjectCollection("entryentity");
                DynamicObjectCollection collection = new DynamicObjectCollection(entryentitys.getDynamicObjectType(), (Object)dynamicObject);
                JSONArray items = invoice.getJSONArray("items");
                if (items != null && items.size() > 0) {
                    for (int i = 0; i < items.size(); ++i) {
                        QFilter unitFilter;
                        DynamicObject unit;
                        JSONObject item = items.getJSONObject(i);
                        DynamicObject entry = new DynamicObject(entryentitys.getDynamicObjectType());
                        entry.set("name", (Object)item.getString("goodsName"));
                        entry.set("model", (Object)item.getString("specModel"));
                        String unitName = item.getString("unit");
                        if (unitName != null && !unitName.isEmpty() && (unit = BusinessDataServiceHelper.loadSingle((String)"bd_measureunits", (String)"name", (QFilter[])new QFilter[]{unitFilter = new QFilter("name", "=", (Object)unitName)})) != null) {
                            entry.set("unit", (Object)unit);
                        }
                        entry.set("qty", (Object)item.getBigDecimal("num"));
                        BigDecimal price = item.getBigDecimal("unitPrice");
                        entry.set("price", (Object)price);
                        BigDecimal amount = item.getBigDecimal("detailAmount");
                        entry.set("amount", (Object)amount);
                        BigDecimal tax = item.getBigDecimal("taxRate");
                        if (tax != null) {
                            QFilter taxFilter = new QFilter("taxrate", "=", (Object)tax.multiply(new BigDecimal("100")));
                            DynamicObject[] taxRate = BusinessDataServiceHelper.load((String)"bd_taxrate", (String)"name", (QFilter[])new QFilter[]{taxFilter});
                            if (taxRate != null && taxRate.length == 1) {
                                entry.set("taxrate", (Object)taxRate);
                            }
                            entry.set("taxvalue", (Object)tax.multiply(new BigDecimal("100")));
                            if (price != null) {
                                entry.set("oftaxprice", (Object)price.multiply(new BigDecimal("1").add(tax)));
                            }
                        }
                        BigDecimal taxAmount = item.getBigDecimal("taxAmount");
                        entry.set("tax", (Object)taxAmount);
                        if (amount != null && taxAmount != null) {
                            entry.set("oftaxamount", (Object)amount.add(taxAmount));
                        }
                        collection.add((Object)entry);
                    }
                }
                dynamicObject.set("entryentity", (Object)collection);
                insertList.add(dynamicObject);
            }
        }
        SaveServiceHelper.save((DynamicObject[])updateList.toArray(new DynamicObject[updateList.size()]));
        SaveServiceHelper.save((DynamicObject[])insertList.toArray(new DynamicObject[insertList.size()]));
        view.showTipNotification(String.format(ResManager.loadKDString((String)"\u4e0b\u8f7d%1$s\u6761\u6570\u636e\uff0c\u66f4\u65b0%2$s\u6761\u6570\u636e\u3002", (String)"InvoiceHelper_3", (String)"pmgt-pmct-business", (Object[])new Object[0]), insertList.size(), updateList.size()));
    }

    public static String checkConSupplier(List<Long> supplierIds, DynamicObject org) {
        QFilter qFilter;
        DynamicObject[] suppliers;
        String errorTip = null;
        HashSet noTexNoSupplier = new HashSet(16);
        if (!supplierIds.isEmpty() && (suppliers = BusinessDataServiceHelper.load((String)"bd_supplier", (String)"name,tx_register_no", (QFilter[])new QFilter[]{qFilter = new QFilter("id", "in", (Object)supplierIds.toArray())})).length > 0) {
            Arrays.stream(suppliers).forEach(supplier -> {
                if (StringUtils.isBlank((CharSequence)supplier.getString("tx_register_no"))) {
                    noTexNoSupplier.add(supplier.getString("name"));
                }
            });
        }
        String invoiceSellerParam = ContractHelper.getInvoiceSellerParam();
        if (!noTexNoSupplier.isEmpty() && (InvoiceSellerParamEnum.STRICTCTRL.getValue().equals(invoiceSellerParam) || InvoiceSellerParamEnum.REMINDCTRL.getValue().equals(invoiceSellerParam))) {
            String noTexNoSupplierStr = ((Object)noTexNoSupplier).toString().replace("[", " ").replace("]", " ");
            errorTip = String.format(ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u7ec7\u4e3a\u201c%1$s\u201d\uff0c\u540d\u79f0\u4e3a\uff1a\u201c%2$s\u201d\u7684\u4f9b\u5e94\u5546\u7684\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u4e3a\u7a7a\uff0c\u8bf7\u5148\u5728\u4e3b\u6570\u636e-\u4f9b\u5e94\u5546\u4e2d\u7ef4\u62a4\u5bf9\u5e94\u4f9b\u5e94\u5546\u7684\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u3002", (String)"InvoiceHelper_7", (String)"pmgt-pmct-business", (Object[])new Object[0]), org.getString("name"), noTexNoSupplierStr);
        }
        return errorTip;
    }

    public static String checkInvoiceSeller(Long supplierId, Set<Long> invoiceIds) {
        StringBuilder errorTip = new StringBuilder();
        if (!invoiceIds.isEmpty()) {
            QFilter qFilter = new QFilter("id", "in", (Object)invoiceIds.toArray());
            DynamicObject[] inInvoices = BusinessDataServiceHelper.load((String)"pmct_ininvoice", (String)String.join((CharSequence)",", "invoiceno", "invoicecode", "seller"), (QFilter[])new QFilter[]{qFilter});
            if (inInvoices.length > 0) {
                DynamicObject supplier = BusinessDataServiceHelper.loadSingle((Object)supplierId, (String)"bd_supplier");
                DynamicObject bizPartner = supplier.getDynamicObject("bizpartner");
                if (bizPartner == null) {
                    return errorTip.toString();
                }
                long bizPartnerId = Long.parseLong(bizPartner.getPkValue().toString());
                for (DynamicObject invoice : inInvoices) {
                    String invoiceNo = invoice.getString("invoiceno");
                    String invoiceCode = invoice.getString("invoicecode");
                    DynamicObject seller = invoice.getDynamicObject("seller");
                    if (seller == null) {
                        if (!errorTip.toString().isEmpty()) {
                            errorTip.append("\r\n");
                        }
                        errorTip.append(String.format(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u548c\u53d1\u7968\uff08\u53d1\u7968\u53f7\u7801\u4e3a%1$s\uff09\u9500\u552e\u65b9\u5173\u8054\u7684\u4f9b\u5e94\u5546\u4e0d\u4e00\u81f4\u3002", (String)"InvoiceHelper_11", (String)"pmgt-pmct-business", (Object[])new Object[0]), invoiceNo));
                        if (StringUtils.isEmpty((CharSequence)invoiceCode)) continue;
                        errorTip.append(String.format(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u548c\u53d1\u7968\uff08\u53d1\u7968\u4ee3\u7801\u4e3a%1$s,\u53d1\u7968\u53f7\u7801\u4e3a%2$s\uff09\u9500\u552e\u65b9\u5173\u8054\u7684\u4f9b\u5e94\u5546\u4e0d\u4e00\u81f4\u3002", (String)"InvoiceHelper_9", (String)"pmgt-pmct-business", (Object[])new Object[0]), invoiceCode, invoiceNo));
                        continue;
                    }
                    DynamicObject[] invoiceSuppliers = ContractHelper.getSuppliers((Object)seller.getPkValue());
                    if (invoiceSuppliers.length == 0) {
                        if (!errorTip.toString().isEmpty()) {
                            errorTip.append("\r\n");
                        }
                        errorTip.append(String.format(ResManager.loadKDString((String)"\u53d1\u7968\uff08\u53d1\u7968\u53f7\u7801\u4e3a%1$s\uff09\u7684\u9500\u552e\u65b9[%2$s]\u6ca1\u6709\u5173\u8054\u4f9b\u5e94\u5546\uff0c\u8bf7\u5148\u7ef4\u62a4\u4f9b\u5e94\u5546\u4fe1\u606f\u3002", (String)"InvoiceHelper_12", (String)"pmgt-pmct-business", (Object[])new Object[0]), invoiceNo, seller.getString("name")));
                        if (StringUtils.isEmpty((CharSequence)invoiceCode)) continue;
                        errorTip.append(String.format(ResManager.loadKDString((String)"\u53d1\u7968\uff08\u53d1\u7968\u4ee3\u7801\u4e3a%1$s,\u53d1\u7968\u53f7\u7801\u4e3a%2$s\uff09\u7684\u9500\u552e\u65b9[%3$s]\u6ca1\u6709\u5173\u8054\u4f9b\u5e94\u5546\uff0c\u8bf7\u5148\u7ef4\u62a4\u4f9b\u5e94\u5546\u4fe1\u606f\u3002", (String)"InvoiceHelper_10", (String)"pmgt-pmct-business", (Object[])new Object[0]), invoiceCode, invoiceNo, seller.getString("name")));
                        continue;
                    }
                    long sellerId = Long.parseLong(seller.getPkValue().toString());
                    if (bizPartnerId == sellerId) continue;
                    if (!errorTip.toString().isEmpty()) {
                        errorTip.append("\r\n");
                    }
                    errorTip.append(String.format(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u548c\u53d1\u7968\uff08\u53d1\u7968\u4ee3\u7801\u4e3a%1$s,\u53d1\u7968\u53f7\u7801\u4e3a%2$s\uff09\u9500\u552e\u65b9\u5173\u8054\u7684\u4f9b\u5e94\u5546\u4e0d\u4e00\u81f4\u3002", (String)"InvoiceHelper_9", (String)"pmgt-pmct-business", (Object[])new Object[0]), invoiceCode, invoiceNo));
                }
            }
        }
        return errorTip.toString();
    }

    public static String checkInvoiceSeller(Long supplierId, DynamicObjectCollection invoices, Long orgId) {
        StringBuilder errorTip = new StringBuilder();
        String supplierName = null;
        String supplierTaxNo = null;
        QFilter qFilter = new QFilter("id", "=", (Object)supplierId);
        DynamicObject[] suppliers = BusinessDataServiceHelper.load((String)"bd_supplier", (String)"name,tx_register_no", (QFilter[])new QFilter[]{qFilter});
        if (suppliers.length > 0) {
            DynamicObject supplier = suppliers[0];
            supplierName = supplier.getString("name");
            supplierTaxNo = supplier.getString("tx_register_no");
        }
        if (!invoices.isEmpty()) {
            Set invoiceIds = invoices.stream().map(invoice -> Long.parseLong(invoice.getDynamicObject("invoice").getPkValue().toString())).collect(Collectors.toSet());
            qFilter = new QFilter("id", "in", (Object)invoiceIds.toArray());
            DynamicObject[] inInvoices = BusinessDataServiceHelper.load((String)"pmct_ininvoice", (String)String.join((CharSequence)",", "invoiceno", "invoicecode", "seller"), (QFilter[])new QFilter[]{qFilter});
            if (inInvoices.length > 0) {
                for (DynamicObject invoice2 : inInvoices) {
                    String invoiceNo = invoice2.getString("invoiceno");
                    String invoiceCode = invoice2.getString("invoicecode");
                    DynamicObject seller = invoice2.getDynamicObject("seller");
                    if (seller == null) {
                        if (!errorTip.toString().isEmpty()) {
                            errorTip.append("\r\n");
                        }
                        errorTip.append(String.format(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u548c\u53d1\u7968\uff08\u53d1\u7968\u4ee3\u7801\u4e3a%1$s,\u53d1\u7968\u53f7\u7801\u4e3a%2$s\uff09\u9500\u552e\u65b9\u7684\u540d\u79f0\u6216\u7eb3\u7a0e\u8bc6\u522b\u53f7\u4e0d\u4e00\u81f4\u3002", (String)"InvoiceHelper_5", (String)"pmgt-pmct-business", (Object[])new Object[0]), invoiceCode, invoiceNo));
                        continue;
                    }
                    DynamicObject[] invoiceSuppliers = ContractHelper.getSuppliers((Object)seller.getPkValue(), (Long)orgId);
                    if (invoiceSuppliers.length > 0) {
                        DynamicObject supplier = invoiceSuppliers[0];
                        String name = supplier.getString("name");
                        String tx_register_no = supplier.getString("tx_register_no");
                        if (StringUtils.equals((CharSequence)supplierName, (CharSequence)name) && StringUtils.equals((CharSequence)supplierTaxNo, (CharSequence)tx_register_no)) continue;
                        if (!errorTip.toString().isEmpty()) {
                            errorTip.append("\r\n");
                        }
                        errorTip.append(String.format(ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u548c\u53d1\u7968\uff08\u53d1\u7968\u4ee3\u7801\u4e3a%1$s,\u53d1\u7968\u53f7\u7801\u4e3a%2$s\uff09\u9500\u552e\u65b9\u7684\u540d\u79f0\u6216\u7eb3\u7a0e\u8bc6\u522b\u53f7\u4e0d\u4e00\u81f4\u3002", (String)"InvoiceHelper_5", (String)"pmgt-pmct-business", (Object[])new Object[0]), invoiceCode, invoiceNo));
                        continue;
                    }
                    if (!errorTip.toString().isEmpty()) {
                        errorTip.append("\r\n");
                    }
                    errorTip.append(String.format(ResManager.loadKDString((String)"\u540d\u79f0\u4e3a[%1$s]\u7684\u5546\u52a1\u4f19\u4f34\u4e0d\u5b58\u5728\u521b\u5efa\u7ec4\u7ec7\u4e3a\u5f53\u524d\u5355\u636e\u7ec4\u7ec7\u7684\u4f9b\u5e94\u5546\uff0c\u8bf7\u5728\u4e3b\u6570\u636e-\u5546\u52a1\u4f19\u4f34\u4e2d\u7ef4\u62a4\u76f8\u5173\u4fe1\u606f\u3002", (String)"InvoiceHelper_6", (String)"pmgt-pmct-business", (Object[])new Object[0]), seller.getString("name")));
                }
            }
        }
        return errorTip.toString();
    }

    public static String getDownloadUrl(String path) {
        if (StringUtils.isNotBlank((CharSequence)path)) {
            if (path.startsWith("http")) {
                return InvoiceHelper.getCsPath(path);
            }
            String afterDecodePath = DecodeFileFactory.getDecodeService().getDecodeFilePath(path);
            if (afterDecodePath.startsWith("http")) {
                return InvoiceHelper.getCsPath(afterDecodePath);
            }
            String previewUrl = UrlService.getAttachmentFullUrl((String)afterDecodePath);
            return InvoiceHelper.getCsPath(previewUrl);
        }
        return path;
    }

    public static String getCsPath(String path) {
        if (StringUtils.isNotBlank((CharSequence)path) && !path.contains("kd_cs_ticket")) {
            String csTicketSuffix = InvoiceHelper.getCsTicketSuffix();
            path = path.contains("?") ? path + "&" + csTicketSuffix : path + "?" + csTicketSuffix;
            return path;
        }
        return path;
    }

    public static String getCsTicketSuffix() {
        return "kd_cs_ticket=" + InvoiceHelper.getCsrfToken(RequestContext.get().getGlobalSessionId());
    }

    public static String getCsrfToken(String sessionId) {
        SessionDAO sessionDAO;
        Map sessionInfo;
        String tkey = "kdCsrfToken";
        String returnValue = "";
        if (StringUtils.isNotBlank((CharSequence)sessionId) && (sessionInfo = (sessionDAO = SessionDAOFactory.getSessionDAO((String)sessionId)).getAttributesAsMap(new String[]{tkey})) != null && sessionInfo.size() > 0) {
            returnValue = (String)sessionInfo.get(tkey);
        }
        return returnValue;
    }
}

