/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.business.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.pmgt.pmbs.business.helper.ContractCollectItemHelper;
import kd.pmgt.pmbs.business.helper.ContractPayItemHelper;
import kd.pmgt.pmbs.common.enums.PayDirectionEnum;
import kd.pmgt.pmct.business.helper.ContractListHelper;

public class UnAuditHelper {
    public static void updateLastVersionData(DynamicObject bill, DynamicObjectCollection currentPlanEntry) {
        String contAddAgreementName;
        String revisionName;
        String claimName;
        String currentFormId = bill.getDynamicObjectType().getName();
        DynamicObject contract = bill.getDynamicObject("contract");
        contract = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(contract.getPkValue().toString()), (String)"pmct_contracttpl");
        String payDirection = contract.getString("paydirection");
        if (PayDirectionEnum.IN.getValue().equals(payDirection)) {
            claimName = "pmct_inclaimbill";
            revisionName = "pmct_incontractrevision";
            contAddAgreementName = "pmct_inaddagreement";
        } else {
            claimName = "pmct_outclaimbill";
            revisionName = "pmct_outcontractrevision";
            contAddAgreementName = "pmct_outaddagreement";
        }
        Date auditDate = bill.getDate("auditdate");
        QFilter isNeedSettleFilter = new QFilter("isneedsettle", "=", (Object)Boolean.TRUE);
        QFilter contractFilter = new QFilter("contract", "=", (Object)Long.parseLong(contract.getPkValue().toString()));
        QFilter billStatusFilter = new QFilter("billstatus", "=", (Object)"C");
        QFilter auditDateFilter = new QFilter("auditdate", "<", (Object)auditDate);
        QFilter versionFilter = new QFilter("versionnumber", ">", (Object)1.0);
        DynamicObject[] contractRevisions = BusinessDataServiceHelper.load((String)"pmct_contractrevision", (String)"auditdate", (QFilter[])new QFilter[]{contractFilter, billStatusFilter, auditDateFilter, versionFilter}, (String)"auditdate desc");
        DynamicObject[] contractChanges = BusinessDataServiceHelper.load((String)revisionName, (String)String.join((CharSequence)",", "auditdate", "kapianentry"), (QFilter[])new QFilter[]{contractFilter, billStatusFilter, auditDateFilter}, (String)"auditdate desc");
        DynamicObject[] claims = BusinessDataServiceHelper.load((String)claimName, (String)String.join((CharSequence)",", "auditdate", "kapianentry"), (QFilter[])new QFilter[]{isNeedSettleFilter, contractFilter, billStatusFilter, auditDateFilter}, (String)"auditdate desc");
        DynamicObject[] contAddAgreements = BusinessDataServiceHelper.load((String)contAddAgreementName, (String)String.join((CharSequence)",", "auditdate", "cardentry"), (QFilter[])new QFilter[]{contractFilter, billStatusFilter, auditDateFilter}, (String)"auditdate desc");
        if (PayDirectionEnum.IN.getValue().equals(payDirection)) {
            ContractCollectItemHelper.updateLastIncomePlan((DynamicObject)bill, (DynamicObjectCollection)currentPlanEntry, (DynamicObject[])claims, (DynamicObject[])contractRevisions, (DynamicObject[])contractChanges, (DynamicObject[])contAddAgreements);
            DynamicObject IncomePlanChange = BusinessDataServiceHelper.loadSingle((String)"pmct_incomeplanchange", (String)"id", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", (Object)Long.parseLong(bill.getPkValue().toString()))});
            if (IncomePlanChange != null) {
                DeleteServiceHelper.delete((String)"pmct_incomeplanchange", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(IncomePlanChange.getPkValue().toString()))});
            }
        } else {
            ContractPayItemHelper.updateLastPayPaln((DynamicObject)bill, (DynamicObjectCollection)currentPlanEntry, (DynamicObject[])claims, (DynamicObject[])contractRevisions, (DynamicObject[])contractChanges, (DynamicObject[])contAddAgreements);
            DynamicObject fundPlanChange = BusinessDataServiceHelper.loadSingle((String)"pmct_fundplanchange", (String)"id", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", (Object)Long.parseLong(bill.getPkValue().toString()))});
            if (fundPlanChange != null) {
                DeleteServiceHelper.delete((String)"pmct_fundplanchange", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(fundPlanChange.getPkValue().toString()))});
            }
        }
        if (!"pmct_contractrevision".equals(currentFormId)) {
            ContractListHelper.updateLastContractListing(bill, contract, claims, contractChanges, contAddAgreements);
            UnAuditHelper.updateContractData(currentFormId, bill, contract);
        }
    }

    public static void updateContractData(String currentFormId, DynamicObject bill, DynamicObject contract) {
        contract = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(contract.getPkValue().toString()), (String)"pmct_contracttpl");
        switch (currentFormId) {
            case "pmct_outclaimbill": 
            case "pmct_inclaimbill": {
                BigDecimal totalClaimAmount = contract.getBigDecimal("totalclaimamount");
                BigDecimal totalClaimOfTaxAmount = contract.getBigDecimal("totalclaimoftaxamount");
                BigDecimal claimAmount = bill.getBigDecimal("claimamount");
                BigDecimal claimOfTaxAmount = bill.getBigDecimal("claimoftaxamount");
                BigDecimal primaryOFTaxAmount = bill.getBigDecimal("primaryoftaxamount");
                BigDecimal primaryAmount = bill.getBigDecimal("primaryamount");
                contract.set("totalclaimamount", (Object)totalClaimAmount.subtract(claimAmount));
                contract.set("totalclaimoftaxamount", (Object)totalClaimOfTaxAmount.subtract(claimOfTaxAmount));
                contract.set("totalamount", (Object)primaryAmount);
                contract.set("totaloftaxamount", (Object)primaryOFTaxAmount);
                boolean isMultiRate = bill.getBoolean("ismultirate");
                if (isMultiRate) {
                    BigDecimal srcTaxAmount = bill.getBigDecimal("primarytaxamount");
                    BigDecimal srcAmount = bill.getBigDecimal("primaryamount");
                    if (srcAmount.compareTo(BigDecimal.ZERO) != 0) {
                        contract.set("lstavgtaxrate", (Object)srcTaxAmount.multiply(new BigDecimal("100")).divide(srcAmount, 2, RoundingMode.HALF_UP));
                    }
                }
                SaveServiceHelper.update((DynamicObject)contract);
                break;
            }
            case "pmct_outcontractrevision": 
            case "pmct_incontractrevision": {
                BigDecimal totalRevisionAmount = contract.getBigDecimal("totalrevisionamount");
                BigDecimal totalRevisionOfTaxAmount = contract.getBigDecimal("totalrevisionoftaxamount");
                BigDecimal totalAmount = contract.getBigDecimal("totalamount");
                BigDecimal totalOfTaxAmount = contract.getBigDecimal("totaloftaxamount");
                BigDecimal revisionAmount = bill.getBigDecimal("revisionamount");
                BigDecimal revisionOfTaxAmount = bill.getBigDecimal("revisionoftaxamount");
                contract.set("totalrevisionamount", (Object)totalRevisionAmount.subtract(revisionAmount));
                contract.set("totalrevisionoftaxamount", (Object)totalRevisionOfTaxAmount.subtract(revisionOfTaxAmount));
                contract.set("totalamount", (Object)totalAmount.subtract(revisionAmount));
                contract.set("totaloftaxamount", (Object)totalOfTaxAmount.subtract(revisionOfTaxAmount));
                boolean taxRateChange = bill.getBoolean("taxratechange");
                if (taxRateChange) {
                    contract.set("lsttaxrate", bill.get("taxrate"));
                    contract.set("lstavgtaxrate", (Object)bill.getBigDecimal("avgtaxrate"));
                } else {
                    boolean isMultiRate = bill.getBoolean("ismultirate");
                    if (isMultiRate) {
                        BigDecimal srcTaxAmount = bill.getBigDecimal("srctaxamount");
                        BigDecimal srcAmount = bill.getBigDecimal("srcamount");
                        if (srcAmount.compareTo(BigDecimal.ZERO) != 0) {
                            contract.set("lstavgtaxrate", (Object)srcTaxAmount.multiply(new BigDecimal("100")).divide(srcAmount, 2, RoundingMode.HALF_UP));
                        }
                    }
                }
                SaveServiceHelper.update((DynamicObject)contract);
                break;
            }
            case "pmct_outaddagreement": 
            case "pmct_inaddagreement": {
                BigDecimal totalAdditionAmount = contract.getBigDecimal("totaladditionamount");
                BigDecimal totalAdditionOfTaxAmount = contract.getBigDecimal("totaladditionoftaxamt");
                BigDecimal totalAmount = contract.getBigDecimal("totalamount");
                BigDecimal totalOfTaxAmount = contract.getBigDecimal("totaloftaxamount");
                BigDecimal additionAmount = bill.getBigDecimal("addamount");
                BigDecimal additionAmountOfTax = bill.getBigDecimal("addamountoftax");
                contract.set("totaladditionamount", (Object)totalAdditionAmount.subtract(additionAmount));
                contract.set("totaladditionoftaxamt", (Object)totalAdditionOfTaxAmount.subtract(additionAmountOfTax));
                contract.set("totalamount", (Object)totalAmount.subtract(additionAmount));
                contract.set("totaloftaxamount", (Object)totalOfTaxAmount.subtract(additionAmountOfTax));
                boolean isMultiRate = bill.getBoolean("ismultirate");
                if (isMultiRate) {
                    BigDecimal srcTaxAmount = bill.getBigDecimal("srctaxamount");
                    BigDecimal srcAmount = bill.getBigDecimal("srcamount");
                    if (srcAmount.compareTo(BigDecimal.ZERO) != 0) {
                        contract.set("lstavgtaxrate", (Object)srcTaxAmount.multiply(new BigDecimal("100")).divide(srcAmount, 2, RoundingMode.HALF_UP));
                    }
                }
                SaveServiceHelper.update((DynamicObject)contract);
                break;
            }
        }
    }

    public static void deleteClaimAutogeneratedItem(DynamicObject bill) {
        DynamicObject contract = bill.getDynamicObject("contract");
        contract = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(contract.getPkValue().toString()), (String)"pmct_contracttpl");
        String payDirection = contract.getString("paydirection");
        String billFromId = bill.getDataEntityType().getName();
        if (PayDirectionEnum.IN.getValue().equals(payDirection)) {
            QFilter billIdFilter = new QFilter("sourcebill", "=", bill.getPkValue());
            DeleteServiceHelper.delete((String)"pmbs_contractcollectitem", (QFilter[])new QFilter[]{billIdFilter});
        } else {
            QFilter billIdFilter = new QFilter("payplanentryid", "=", bill.getPkValue());
            DeleteServiceHelper.delete((String)"pmbs_contractpayitem", (QFilter[])new QFilter[]{billIdFilter});
        }
    }
}

