/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.business.manage;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmbs.business.helper.ContractPayItemHelper;
import kd.pmgt.pmbs.common.enums.NodeSettingSourceEnum;

public class FundPlanPayItemService {
    public void loadIncomeItemEntry(DynamicObject contract, DynamicObjectCollection incomeItemEntryEntity) {
        incomeItemEntryEntity.clear();
        QFilter contractFilter = new QFilter("contract", "=", contract.getPkValue());
        DynamicObject[] incomeItems = BusinessDataServiceHelper.load((String)"pmbs_contractcollectitem", (String)"masterid, status, billno, enable, customer, collecttype, collectfeq, collectway, collectpercent, currency, collectamount, plancollecttime, remarks, collectedamt, collectedcomamt, uncollectedamt, contract, sourcebilltype, autogenerated, creator, createtime, modifier, modifytime, sourcebill, paydirection,nodesettingsource,nodesetting,ctrlstrategy,appliedamt,appliedcomamt,appliableamt", (QFilter[])new QFilter[]{contractFilter});
        Map incomeItemsCompleteStateMap = ContractPayItemHelper.getSrcObjCompleteMap((DynamicObject[])incomeItems);
        Map completeStateMap = (Map)incomeItemsCompleteStateMap.get(NodeSettingSourceEnum.PMBS_TASK.getValue());
        DynamicObjectType incomeItemEntryDT = incomeItemEntryEntity.getDynamicObjectType();
        for (DynamicObject incomeItem : incomeItems) {
            DynamicObject incomeItemEntry = new DynamicObject(incomeItemEntryDT);
            incomeItemEntry.set("incomeitem", (Object)incomeItem);
            incomeItemEntry.set("in_appliedamt", (Object)incomeItem.getBigDecimal("appliedamt"));
            incomeItemEntry.set("in_appliedcomamt", (Object)incomeItem.getBigDecimal("appliedcomamt"));
            incomeItemEntry.set("in_appliableamt", (Object)incomeItem.getBigDecimal("appliableamt"));
            if (null != completeStateMap && null != incomeItem.get("nodesetting")) {
                Object taskId = incomeItem.getDynamicObject("nodesetting").getPkValue();
                incomeItemEntry.set("in_taskcompletestatus", completeStateMap.get(taskId));
            }
            incomeItemEntry.set("incometype", (Object)incomeItem.getString("collecttype"));
            incomeItemEntry.set("incomeitemcurrency", (Object)incomeItem.getDynamicObject("currency"));
            incomeItemEntry.set("incomefeq", (Object)incomeItem.getString("collectfeq"));
            incomeItemEntry.set("incomeway", incomeItem.get("collectway"));
            incomeItemEntry.set("incomepercent", incomeItem.get("collectpercent"));
            incomeItemEntry.set("incomeamountoftax", incomeItem.get("collectamount"));
            incomeItemEntry.set("planincometime", incomeItem.get("plancollecttime"));
            incomeItemEntry.set("collectedamt", incomeItem.get("collectedamt"));
            incomeItemEntry.set("collectedcomamt", incomeItem.get("collectedcomamt"));
            incomeItemEntry.set("uncollectedamt", incomeItem.get("uncollectedamt"));
            incomeItemEntry.set("incomesource", incomeItem.get("sourcebill"));
            incomeItemEntry.set("incomeremarks", incomeItem.get("remarks"));
            incomeItemEntryEntity.add((Object)incomeItemEntry);
        }
    }

    public void loadPayItemEntry(DynamicObject contract, DynamicObjectCollection payItemEntryEntity) {
        payItemEntryEntity.clear();
        QFilter contractFilter = new QFilter("contract", "=", contract.getPkValue());
        DynamicObject[] payItems = BusinessDataServiceHelper.load((String)"pmbs_contractpayitem", (String)"paytype,payfeq,payway,paypercent,payamount,planpaytime,remarks,reimbursedamt,paidamt,currency,reimbursedcomamt,reimbursableamt,paidcomamt,unpaidamt,source,remarks,nodesettingsource,nodesetting,ctrlstrategy,appliedamt,appliedcomamt,appliableamt", (QFilter[])new QFilter[]{contractFilter});
        Map payItemsCompleteStateMap = ContractPayItemHelper.getSrcObjCompleteMap((DynamicObject[])payItems);
        Map completeStateMap = (Map)payItemsCompleteStateMap.get(NodeSettingSourceEnum.PMBS_TASK.getValue());
        DynamicObjectType payItemEntryDT = payItemEntryEntity.getDynamicObjectType();
        for (DynamicObject payItem : payItems) {
            DynamicObject payItemEntry = new DynamicObject(payItemEntryDT);
            payItemEntry.set("payitem", (Object)payItem);
            payItemEntry.set("out_appliedamt", (Object)payItem.getBigDecimal("appliedamt"));
            payItemEntry.set("out_appliedcomamt", (Object)payItem.getBigDecimal("appliedcomamt"));
            payItemEntry.set("out_appliableamt", (Object)payItem.getBigDecimal("appliableamt"));
            if (null != completeStateMap && null != payItem.get("nodesetting")) {
                Object taskId = payItem.getDynamicObject("nodesetting").getPkValue();
                payItemEntry.set("out_taskcompletestatus", completeStateMap.get(taskId));
            }
            payItemEntry.set("paytype", (Object)payItem.getString("paytype"));
            payItemEntry.set("itemcurrency", (Object)payItem.getDynamicObject("currency"));
            payItemEntry.set("payfeq", (Object)payItem.getString("payfeq"));
            payItemEntry.set("payway", payItem.get("payway"));
            payItemEntry.set("paypercent", payItem.get("paypercent"));
            payItemEntry.set("payamountoftax", payItem.get("payamount"));
            payItemEntry.set("planpaytime", payItem.get("planpaytime"));
            payItemEntry.set("reimbursedamt", payItem.get("reimbursedamt"));
            payItemEntry.set("reimbursedcomamt", payItem.get("reimbursedcomamt"));
            payItemEntry.set("reimbursableamt", payItem.get("reimbursableamt"));
            payItemEntry.set("paidamt", payItem.get("paidamt"));
            payItemEntry.set("paidcomamt", payItem.get("paidcomamt"));
            payItemEntry.set("unpaidamt", payItem.get("unpaidamt"));
            payItemEntry.set("source", payItem.get("source"));
            payItemEntry.set("remarks", payItem.get("remarks"));
            payItemEntryEntity.add((Object)payItemEntry);
        }
    }
}

