/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.business.manage;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.field.ComboItem;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.pmgt.pmbs.business.helper.ContractPayItemHelper;
import kd.pmgt.pmbs.common.enums.NodeSettingSourceEnum;
import kd.pmgt.pmbs.common.enums.PayDirectionEnum;
import kd.pmgt.pmct.business.manage.AbstractFundPlanningService;
import kd.pmgt.pmct.business.manage.ContractSelectSupport;
import kd.pmgt.pmct.business.manage.FundPlanPayItemService;
import kd.pmgt.pmct.business.manage.IContractFundPlanningService;
import kd.pmgt.pmct.common.enums.FundPlanningStatisticsEnum;
import kd.pmgt.pmct.common.utils.AmountCurrencyUtils;

public class InContractFundPlanningService
extends AbstractFundPlanningService
implements IContractFundPlanningService {
    private static final Log logger = LogFactory.getLog(InContractFundPlanningService.class);
    private ContractSelectSupport contractSelectSupport = new ContractSelectSupport();
    private FundPlanPayItemService fundPlanPayItemService = new FundPlanPayItemService();

    @Override
    public List<ComboItem> initStaticDimensions() {
        List<FundPlanningStatisticsEnum> dimensionEnums = Arrays.asList(FundPlanningStatisticsEnum.PARTA, FundPlanningStatisticsEnum.ORG, FundPlanningStatisticsEnum.PROJECT, FundPlanningStatisticsEnum.CONTRACTTYPE);
        return dimensionEnums.stream().map(dimensionEnum -> new ComboItem(new LocaleString(dimensionEnum.getName()), dimensionEnum.getValue())).collect(Collectors.toList());
    }

    @Override
    public void loadPayItemEntry(IFormView formView, int clickRowIndex) {
        IDataModel dataModel = formView.getModel();
        DynamicObjectCollection inContractPlans = dataModel.getDataEntity(true).getDynamicObjectCollection("incontractplanentity");
        DynamicObject clickContract = (DynamicObject)inContractPlans.get(clickRowIndex);
        Object contractPk = clickContract.getDynamicObject("incontract").getPkValue();
        QFilter contractFilter = new QFilter("contract", "=", contractPk);
        DynamicObject[] incomeItems = BusinessDataServiceHelper.load((String)"pmbs_contractcollectitem", (String)"masterid, status, billno, enable, customer, collecttype, collectfeq, collectway, collectpercent, currency, collectamount, plancollecttime, remarks, collectedamt, collectedcomamt, uncollectedamt, contract, sourcebilltype, autogenerated, creator, createtime, modifier, modifytime, sourcebill, paydirection,nodesettingsource,nodesetting,ctrlstrategy,appliedamt,appliedcomamt,appliableamt", (QFilter[])new QFilter[]{contractFilter});
        DynamicObjectCollection incomeItemEntryEntity = clickContract.getDynamicObjectCollection("subincomeitementity");
        DynamicObjectType incomeItemEntryDT = incomeItemEntryEntity.getDynamicObjectType();
        Map incomeItemsCompleteStateMap = ContractPayItemHelper.getSrcObjCompleteMap((DynamicObject[])incomeItems);
        Map completeStateMap = (Map)incomeItemsCompleteStateMap.get(NodeSettingSourceEnum.PMBS_TASK.getValue());
        for (DynamicObject incomeItem : incomeItems) {
            DynamicObject incomeItemEntry = new DynamicObject(incomeItemEntryDT);
            incomeItemEntry.set("incomeitem", (Object)incomeItem);
            incomeItemEntry.set("in_appliedamt", (Object)incomeItem.getBigDecimal("appliedamt"));
            incomeItemEntry.set("in_appliedcomamt", (Object)incomeItem.getBigDecimal("appliedcomamt"));
            incomeItemEntry.set("in_appliableamt", (Object)incomeItem.getBigDecimal("appliableamt"));
            if (null != completeStateMap && null != incomeItem.get("nodesetting")) {
                Object taskId = incomeItem.getDynamicObject("nodesetting").getPkValue();
                incomeItemEntry.set("in_taskcompletestatus", completeStateMap.get(taskId));
            }
            incomeItemEntry.set("inconplanentry", contractPk);
            incomeItemEntry.set("incometype", (Object)incomeItem.getString("collecttype"));
            incomeItemEntry.set("incomeitemcurrency", (Object)incomeItem.getDynamicObject("currency"));
            incomeItemEntry.set("incomefeq", (Object)incomeItem.getString("collectfeq"));
            incomeItemEntry.set("incomeway", incomeItem.get("collectway"));
            incomeItemEntry.set("incomepercent", incomeItem.get("collectpercent"));
            incomeItemEntry.set("incomeamountoftax", incomeItem.get("collectamount"));
            incomeItemEntry.set("planincometime", incomeItem.get("plancollecttime"));
            incomeItemEntry.set("collectedamt", incomeItem.get("collectedamt"));
            incomeItemEntry.set("collectedcomamt", incomeItem.get("collectedcomamt"));
            incomeItemEntry.set("uncollectedamt", incomeItem.get("uncollectedamt"));
            incomeItemEntry.set("incomesource", incomeItem.get("sourcebill"));
            incomeItemEntry.set("incomeremarks", incomeItem.get("remarks"));
            incomeItemEntryEntity.add((Object)incomeItemEntry);
        }
        dataModel.updateEntryCache(incomeItemEntryEntity);
        formView.updateView("subincomeitementity");
    }

    @Override
    public List<ItemValue> getChartData(IDataModel dataModel, String entryProp) {
        String dimension = this.getDimension(dataModel);
        List<Object> itemValues = new ArrayList<ItemValue>();
        String targetPlanAmtStd = "inperiodplanamtstd";
        DynamicObjectCollection contracts = dataModel.getEntryEntity("incontractplanentity");
        if (contracts.isEmpty()) {
            itemValues.add(new ItemValue("", (Number)0));
            return itemValues;
        }
        Map<Long, List<DynamicObject>> chartDataMap = contracts.stream().collect(Collectors.groupingBy(contract -> Long.parseLong(contract.getDynamicObject(entryProp).getPkValue().toString())));
        itemValues = chartDataMap.values().stream().map(dynamicObjects -> {
            String itemName = ((DynamicObject)dynamicObjects.get(0)).getDynamicObject(entryProp).getString(this.getDimensionNameFormId(dimension));
            BigDecimal totalPeriodAmt = dynamicObjects.stream().map(it -> it.getBigDecimal(targetPlanAmtStd)).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            return new ItemValue(itemName, (Number)totalPeriodAmt);
        }).sorted(Comparator.comparing(o -> (BigDecimal)o.getValue())).collect(Collectors.toList());
        Collections.reverse(itemValues);
        return itemValues;
    }

    @Override
    public String dimension2EntryProp(IDataModel dataModel) {
        String entryProp = null;
        String dimension = this.getDimension(dataModel);
        DynamicObjectCollection contractEntity = dataModel.getEntryEntity("incontractplanentity");
        FundPlanningStatisticsEnum statisticsEnum = FundPlanningStatisticsEnum.getEnumByValue((String)dimension);
        switch (statisticsEnum) {
            case PARTA: {
                entryProp = "parta";
                break;
            }
            case ORG: {
                entryProp = "inorg";
                break;
            }
            case PROJECT: {
                boolean noProject = contractEntity.stream().map(it -> it.getDynamicObject("inproject")).anyMatch(Objects::isNull);
                if (noProject) break;
                entryProp = "inproject";
                break;
            }
            case CONTRACTTYPE: {
                entryProp = "incontracttype";
                break;
            }
        }
        return entryProp;
    }

    private String getDimension(IDataModel dataModel) {
        Object dimension = dataModel.getValue("dimension");
        if (dimension == null) {
            dataModel.setValue("dimension", (Object)FundPlanningStatisticsEnum.PARTA.getValue());
        }
        return dataModel.getValue("dimension").toString();
    }

    @Override
    public ListShowParameter showContractListView(IFormView formView, IDataModel dataModel, CloseCallBack closeCallBack) {
        QFilter contractFilter;
        Set<Long> excludeContractPks = this.getSelectedContractPks(dataModel);
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"pmct_incontractf7", (boolean)true);
        listShowParameter.setCloseCallBack(closeCallBack);
        QFilter excludePkFilter = new QFilter("id", "not in", excludeContractPks);
        String appId = BizAppServiceHelp.getAppIdByAppNumber((String)dataModel.getDataEntityType().getAppId());
        long userId = Long.parseLong(RequestContext.get().getUserId());
        HasPermOrgResult hasPermOrgs = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appId, (String)"pmct_monthlyfundplan", (String)"47150e89000000ac");
        if (hasPermOrgs.hasAllOrgPerm() && CollectionUtils.isEmpty((Collection)hasPermOrgs.getHasPermOrgs())) {
            contractFilter = this.contractSelectSupport.getContractFilterForAllOrgPerm(formView.getEntityId(), PayDirectionEnum.IN);
        } else {
            List orgPks = hasPermOrgs.getHasPermOrgs();
            logger.info("userId:{}, InContractFundPlanningService#hasPermPrgList:{}", (Object)userId, (Object)orgPks);
            contractFilter = this.contractSelectSupport.getContractFilter(formView.getEntityId(), "inselectcontract", PayDirectionEnum.IN, orgPks, (DynamicObject)dataModel.getValue("project"));
        }
        contractFilter.and(excludePkFilter);
        logger.info("userId:{}, InContractFundPlanningService#showContractListView contractFilter:{}", (Object)userId, (Object)contractFilter);
        listShowParameter.getListFilterParameter().getQFilters().add(contractFilter);
        return listShowParameter;
    }

    @Override
    public Set<Long> getSelectedContractPks(IDataModel dataModel) {
        return dataModel.getEntryEntity("incontractplanentity").stream().map(entry -> entry.getDynamicObject("incontract")).map(DataEntityBase::getPkValue).map(pk -> Long.parseLong(pk.toString())).collect(Collectors.toSet());
    }

    @Override
    public String getReturnData(IDataModel dataModel) {
        DynamicObjectType dt = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_monthlyfundplan")).getDynamicObjectCollection("incontractplanentity").getDynamicObjectType();
        DynamicObjectCollection entryContract = dataModel.getEntryEntity("incontractplanentity");
        return DynamicObjectSerializeUtil.serialize((Object[])entryContract.toArray(), (DynamicObjectType)dt);
    }

    public void fillEntryByContract(DynamicObject currentEntry, DynamicObject contractEntry) {
        this.fillCurrentEntry(currentEntry, contractEntry);
    }

    public void fillContractF7Data2Entry(DynamicObject currentEntry, DynamicObject contract) {
        currentEntry.set("incontract", (Object)contract);
        currentEntry.set("incurrency", contract.get("currency"));
        BigDecimal exchangeRate = contract.getBigDecimal("exchangerate");
        if (exchangeRate.compareTo(BigDecimal.ZERO) == 0) {
            exchangeRate = BigDecimal.ONE;
        }
        currentEntry.set("inexchangerate", (Object)exchangeRate);
        currentEntry.set("inoriginaloftaxamt", contract.get("originaloftaxamount"));
        currentEntry.set("intotalsettleoftaxamt", contract.get("totalsettleoftaxamount"));
        currentEntry.set("intotalinvoiceoftaxamt", contract.get("totalinvoiceoftaxamount"));
        currentEntry.set("intotalrealoftaxamt", contract.get("totalrealoftaxamount"));
        currentEntry.set("ininvoicednonpay", (Object)contract.getBigDecimal("totalinvoiceoftaxamount").subtract(contract.getBigDecimal("totalrealoftaxamount")));
        currentEntry.set("insettlednonpay", (Object)contract.getBigDecimal("totalsettleoftaxamount").subtract(contract.getBigDecimal("totalrealoftaxamount")));
        currentEntry.set("incontractbillno", contract.get("billno"));
        if (StringUtils.equals((CharSequence)contract.getString("paydirection"), (CharSequence)PayDirectionEnum.OUT.getValue())) {
            currentEntry.set("parta", contract.get("partb"));
        } else {
            currentEntry.set("parta", contract.get("parta"));
        }
        currentEntry.set("incontractstatus", contract.get("contractstatus"));
        currentEntry.set("incontracttype", contract.get("contracttype"));
        currentEntry.set("inproject", contract.get("project"));
        currentEntry.set("inorg", contract.get("org"));
        currentEntry.set("incontractdescription", contract.get("description"));
    }

    public void fillEntryByContract(DynamicObjectCollection entries, int currentIndex, DynamicObject contract) {
        DynamicObject currentEntry = (DynamicObject)entries.get(currentIndex);
        this.fillCurrentEntry(currentEntry, contract);
    }

    private void fillCurrentEntry(DynamicObject currentEntry, DynamicObject contractEntry) {
        currentEntry.set("incontract", (Object)contractEntry);
        currentEntry.set("incurrency", contractEntry.get("incurrency"));
        BigDecimal exchangeRate = contractEntry.getBigDecimal("inexchangerate");
        if (exchangeRate.compareTo(BigDecimal.ZERO) == 0) {
            exchangeRate = BigDecimal.ONE;
        }
        currentEntry.set("inexchangerate", (Object)exchangeRate);
        currentEntry.set("inoriginaloftaxamt", contractEntry.get("inoriginaloftaxamt"));
        currentEntry.set("intotalsettleoftaxamt", contractEntry.get("intotalsettleoftaxamt"));
        currentEntry.set("intotalinvoiceoftaxamt", contractEntry.get("intotalinvoiceoftaxamt"));
        currentEntry.set("intotalrealoftaxamt", contractEntry.get("intotalrealoftaxamt"));
        currentEntry.set("ininvoicednonpay", contractEntry.get("ininvoicednonpay"));
        currentEntry.set("insettlednonpay", contractEntry.get("insettlednonpay"));
        currentEntry.set("inperiodplanamt", contractEntry.get("inperiodplanamt"));
        currentEntry.set("inperiodplanamtstd", contractEntry.get("inperiodplanamtstd"));
        currentEntry.set("incontractbillno", contractEntry.get("incontractbillno"));
        currentEntry.set("parta", contractEntry.get("parta"));
        currentEntry.set("incontractstatus", contractEntry.get("incontractstatus"));
        currentEntry.set("incontracttype", contractEntry.get("incontracttype"));
        currentEntry.set("inproject", contractEntry.get("inproject"));
        currentEntry.set("inorg", contractEntry.get("inorg"));
        currentEntry.set("incontractdescription", contractEntry.get("incontractdescription"));
    }

    private String switchPlanningType(String planningType) {
        switch (planningType) {
            case "invoice": {
                planningType = "ininvoicednonpay";
                break;
            }
            case "settle": {
                planningType = "insettlednonpay";
                break;
            }
        }
        return planningType;
    }

    @Override
    public void doFundPlanning(BigDecimal distributedAmt, int[] selectRows, IDataModel dataModel) {
        String planningType = this.switchPlanningType(dataModel.getValue("radiogroupfield").toString());
        for (int selectRow : selectRows) {
            BigDecimal periodPlanAmtStd;
            BigDecimal periodPlanEntryAmt;
            DynamicObjectCollection incomeItemEntities;
            DynamicObject inContractPlanEntities = dataModel.getEntryRowEntity("incontractplanentity", selectRow);
            BigDecimal needPlanAmt = this.getNeedPlanAmt(planningType, inContractPlanEntities, incomeItemEntities = dataModel.getEntryEntity("subincomeitementity"));
            BigDecimal restAmt = distributedAmt.subtract(needPlanAmt);
            if (restAmt.compareTo(BigDecimal.ZERO) >= 0) {
                periodPlanEntryAmt = needPlanAmt;
                periodPlanAmtStd = AmountCurrencyUtils.amount2StdAmount((BigDecimal)periodPlanEntryAmt, (BigDecimal)inContractPlanEntities.getBigDecimal("inexchangerate"), (DynamicObject)((DynamicObject)dataModel.getValue("stdcurrency")));
                inContractPlanEntities.set("inperiodplanamt", (Object)periodPlanEntryAmt);
                inContractPlanEntities.set("inperiodplanamtstd", (Object)periodPlanAmtStd);
                distributedAmt = restAmt;
                continue;
            }
            periodPlanEntryAmt = distributedAmt;
            periodPlanAmtStd = AmountCurrencyUtils.amount2StdAmount((BigDecimal)periodPlanEntryAmt, (BigDecimal)inContractPlanEntities.getBigDecimal("inexchangerate"), (DynamicObject)((DynamicObject)dataModel.getValue("incurrency")));
            inContractPlanEntities.set("inperiodplanamt", (Object)periodPlanEntryAmt);
            inContractPlanEntities.set("inperiodplanamtstd", (Object)periodPlanAmtStd);
            distributedAmt = BigDecimal.ZERO;
        }
    }

    private BigDecimal getNeedPlanAmt(String planningType, DynamicObject rowEntity, DynamicObjectCollection incomeItemEntities) {
        BigDecimal needPlanAmt = BigDecimal.ZERO;
        switch (planningType) {
            case "ininvoicednonpay": 
            case "insettlednonpay": {
                needPlanAmt = rowEntity.getBigDecimal(planningType);
                break;
            }
            case "incomeitem": {
                DynamicObject outContract = rowEntity.getDynamicObject("incontract");
                this.fundPlanPayItemService.loadIncomeItemEntry(outContract, incomeItemEntities);
                needPlanAmt = incomeItemEntities.stream().filter(payItem -> {
                    Date planPayTime = payItem.getDate("planincometime");
                    SimpleDateFormat yearAndMonthFormat = new SimpleDateFormat("yyyy-MM");
                    return planPayTime == null || yearAndMonthFormat.format(planPayTime).compareTo(yearAndMonthFormat.format(new Date())) <= 0;
                }).map(payItem -> payItem.getBigDecimal("uncollectedamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                break;
            }
        }
        return needPlanAmt;
    }

    @Override
    public BigDecimal calculatePeriodPlanAmt(IDataModel dataModel) {
        return dataModel.getEntryEntity("incontractplanentity").stream().map(it -> it.getBigDecimal("inperiodplanamtstd")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
    }

    @Override
    public BigDecimal calculateNonContractPeriodPlanAmt(IDataModel dataModel) {
        return dataModel.getEntryEntity("innoncontractplanentity").stream().map(it -> it.getBigDecimal("noninperiodplanamtstd")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
    }
}

