/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.business.manage;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.pmgt.pmbs.common.enums.PayDirectionEnum;

public class InFundPlanningService {
    public void fillEntryByContract(DynamicObject currentEntry, DynamicObject contractEntry) {
        this.fillCurrentEntry(currentEntry, contractEntry);
    }

    public void fillContractF7Data2Entry(DynamicObject currentEntry, DynamicObject contract) {
        currentEntry.set("incontract", (Object)contract);
        currentEntry.set("incurrency", contract.get("currency"));
        BigDecimal exchangeRate = contract.getBigDecimal("exchangerate");
        if (exchangeRate.compareTo(BigDecimal.ZERO) == 0) {
            exchangeRate = BigDecimal.ONE;
        }
        currentEntry.set("inexchangerate", (Object)exchangeRate);
        currentEntry.set("inoriginaloftaxamt", contract.get("originaloftaxamount"));
        currentEntry.set("intotalsettleoftaxamt", contract.get("totalsettleoftaxamount"));
        currentEntry.set("intotalinvoiceoftaxamt", contract.get("totalinvoiceoftaxamount"));
        currentEntry.set("intotalrealoftaxamt", contract.get("totalrealoftaxamount"));
        currentEntry.set("ininvoicednonpay", (Object)contract.getBigDecimal("totalinvoiceoftaxamount").subtract(contract.getBigDecimal("totalrealoftaxamount")));
        currentEntry.set("insettlednonpay", (Object)contract.getBigDecimal("totalsettleoftaxamount").subtract(contract.getBigDecimal("totalrealoftaxamount")));
        currentEntry.set("incontractbillno", contract.get("billno"));
        if (StringUtils.equals((CharSequence)contract.getString("paydirection"), (CharSequence)PayDirectionEnum.OUT.getValue())) {
            currentEntry.set("parta", contract.get("partb"));
        } else {
            currentEntry.set("parta", contract.get("parta"));
        }
        currentEntry.set("incontractstatus", contract.get("contractstatus"));
        currentEntry.set("incontracttype", contract.get("contracttype"));
        currentEntry.set("inproject", contract.get("project"));
        currentEntry.set("inorg", contract.get("org"));
        currentEntry.set("incontractdescription", contract.get("description"));
    }

    public void fillEntryByContract(DynamicObjectCollection entries, int currentIndex, DynamicObject contract) {
        DynamicObject currentEntry = (DynamicObject)entries.get(currentIndex);
        this.fillCurrentEntry(currentEntry, contract);
    }

    private void fillCurrentEntry(DynamicObject currentEntry, DynamicObject contractEntry) {
        currentEntry.set("incontract", (Object)contractEntry);
        currentEntry.set("incurrency", contractEntry.get("incurrency"));
        BigDecimal exchangeRate = contractEntry.getBigDecimal("inexchangerate");
        if (exchangeRate.compareTo(BigDecimal.ZERO) == 0) {
            exchangeRate = BigDecimal.ONE;
        }
        currentEntry.set("inexchangerate", (Object)exchangeRate);
        currentEntry.set("inoriginaloftaxamt", contractEntry.get("inoriginaloftaxamt"));
        currentEntry.set("intotalsettleoftaxamt", contractEntry.get("intotalsettleoftaxamt"));
        currentEntry.set("intotalinvoiceoftaxamt", contractEntry.get("intotalinvoiceoftaxamt"));
        currentEntry.set("intotalrealoftaxamt", contractEntry.get("intotalrealoftaxamt"));
        currentEntry.set("ininvoicednonpay", contractEntry.get("ininvoicednonpay"));
        currentEntry.set("insettlednonpay", contractEntry.get("insettlednonpay"));
        currentEntry.set("inperiodplanamt", contractEntry.get("inperiodplanamt"));
        currentEntry.set("inperiodplanamtstd", contractEntry.get("inperiodplanamtstd"));
        currentEntry.set("incontractbillno", contractEntry.get("incontractbillno"));
        currentEntry.set("parta", contractEntry.get("parta"));
        currentEntry.set("incontractstatus", contractEntry.get("incontractstatus"));
        currentEntry.set("incontracttype", contractEntry.get("incontracttype"));
        currentEntry.set("inproject", contractEntry.get("inproject"));
        currentEntry.set("inorg", contractEntry.get("inorg"));
        currentEntry.set("incontractdescription", contractEntry.get("incontractdescription"));
    }
}

