/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.business.manage;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmbs.common.enums.PayDirectionEnum;
import kd.pmgt.pmbs.common.enums.StatusEnum;

public class MonthlyFundPlanEditService {
    private static final Log logger = LogFactory.getLog(MonthlyFundPlanEditService.class);

    public DynamicObject getPeriodFundPlanAmount(DynamicObject period, DynamicObject contract, DynamicObject org, DynamicObject project) {
        QFilter statusFilter;
        QFilter contractFilter;
        String periodFundPlanAmtFormId;
        String contractFormId;
        String projectFormId;
        String entityFormId;
        String payDirection = contract.getString("paydirection");
        String billFormId = "pmct_monthlyfundplan";
        String periodFormId = "period";
        if (StringUtils.equals((CharSequence)payDirection, (CharSequence)PayDirectionEnum.IN.getValue())) {
            entityFormId = "incontractplanentity";
            projectFormId = "inproject";
            contractFormId = "incontract";
            periodFundPlanAmtFormId = "inperiodplanamt";
        } else {
            entityFormId = "outcontractplanentity";
            projectFormId = "outproject";
            contractFormId = "outcontract";
            periodFundPlanAmtFormId = "outperiodplanamt";
        }
        QFilter filter = new QFilter(periodFormId, "=", period.getPkValue());
        boolean multiPartSettlement = contract.getBoolean("multipartsettlement");
        String multiPayType = contract.getString("multipaytype");
        if (multiPartSettlement && StringUtils.equals((CharSequence)multiPayType, (CharSequence)"separatepay")) {
            contractFilter = new QFilter(String.join((CharSequence)".", entityFormId, contractFormId), "=", contract.getPkValue());
            statusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
            filter.and(contractFilter).and(statusFilter);
        } else {
            contractFilter = new QFilter(String.join((CharSequence)".", entityFormId, contractFormId), "=", contract.getPkValue());
            statusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
            QFilter orgFilter = new QFilter("org", "=", org.getPkValue());
            filter.and(contractFilter).and(statusFilter).and(orgFilter);
            if (project != null) {
                filter.and(new QFilter(String.join((CharSequence)".", entityFormId, projectFormId), "=", project.getPkValue()));
            }
        }
        logger.info("MonthlyFundPlanEditService#getPeriodFundPlanAmount filter:{}", (Object)filter);
        String selectProperties = String.join((CharSequence)",", String.join((CharSequence)".", entityFormId, periodFundPlanAmtFormId), String.join((CharSequence)".", entityFormId, contractFormId));
        DynamicObject[] fundPlans = BusinessDataServiceHelper.load((String)billFormId, (String)selectProperties, (QFilter[])new QFilter[]{filter}, (String)"auditdate desc");
        if (fundPlans.length > 0) {
            return fundPlans[0];
        }
        return null;
    }

    public DynamicObject[] getSameOrgAndPeriodBill(DynamicObject org, DynamicObject period) {
        QFilter filter = new QFilter("period", "=", period.getPkValue());
        QFilter orgFilter = new QFilter("org", "=", org.getPkValue());
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)StatusEnum.CHECKED.getValue());
        filter.and(orgFilter).and(statusFilter);
        logger.info("MonthlyFundPlanEditService#getSameOrgAndPeriodBill filter:{}", (Object)filter);
        return BusinessDataServiceHelper.load((String)"pmct_monthlyfundplan", (String)"id", (QFilter[])new QFilter[]{filter});
    }
}

