/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.business.manage;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.IFormView;
import kd.bos.form.control.AbstractGrid;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.pmgt.pmbs.common.enums.pmct.ContractMultiTypeEnum;
import kd.pmgt.pmct.business.manage.IContractFillBackService;
import kd.pmgt.pmct.business.manage.MultiSettleAmtService;
import kd.pmgt.pmct.common.utils.AmountCurrencyUtils;

public class OutContractFillBackService
implements IContractFillBackService {
    @Override
    public DynamicObjectCollection fillBillEntryByContractF7(IFormView view, IDataModel dataModel, ListSelectedRowCollection selectedRows) {
        int i;
        DynamicObjectCollection outContractPlanEntries = dataModel.getEntryEntity("outcontractplanentity");
        for (i = 0; i < selectedRows.size(); ++i) {
            ListSelectedRow selectedRow = selectedRows.get(i);
            DynamicObject entry = outContractPlanEntries.addNew();
            DynamicObject contract = BusinessDataServiceHelper.loadSingle((Object)selectedRow.getPrimaryKeyValue(), (String)"pmct_outcontract");
            this.fillCurrentEntry(dataModel, contract, entry);
        }
        for (i = 0; i < outContractPlanEntries.size(); ++i) {
            DynamicObject contract = ((DynamicObject)outContractPlanEntries.get(i)).getDynamicObject("outcontract");
            contract = BusinessDataServiceHelper.loadSingle((Object)contract.getPkValue(), (String)"pmct_outcontract");
            boolean multiPartSettlement = contract.getBoolean("multipartsettlement");
            String multiPayType = contract.getString("multipaytype");
            if (!multiPartSettlement || !StringUtils.equals((CharSequence)multiPayType, (CharSequence)ContractMultiTypeEnum.SEPARATEPAY.getValue())) continue;
            AbstractGrid grid = (AbstractGrid)view.getControl("outcontractplanentity");
            this.setCellColor(grid, "outoriginaloftaxamt", i);
            this.setCellColor(grid, "outtotalinvoiceoftaxamt", i);
            this.setCellColor(grid, "outinvoicednonpay", i);
        }
        return outContractPlanEntries;
    }

    @Override
    public DynamicObjectCollection fillFundPlanData2BillEntry(IFormView view, IDataModel dataModel, String returnData) {
        DynamicObjectCollection outContractPlanEntries = dataModel.getEntryEntity("outcontractplanentity");
        outContractPlanEntries.clear();
        DynamicObjectType dt = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_monthlyfundplan")).getDynamicObjectCollection("outcontractplanentity").getDynamicObjectType();
        Object[] customObjectEntries = DynamicObjectSerializeUtil.deserialize((String)returnData, (DynamicObjectType)dt);
        List contracts = Arrays.stream(customObjectEntries).map(item -> (DynamicObject)item).collect(Collectors.toList());
        for (int i = 0; i < contracts.size(); ++i) {
            DynamicObject contract = (DynamicObject)contracts.get(i);
            DynamicObject entry = outContractPlanEntries.addNew();
            this.doFillFundPlanData2BillEntry(view, i, entry, contract);
        }
        return outContractPlanEntries;
    }

    @Override
    public DynamicObjectCollection fillImportData2BillEntry(IFormView view, IDataModel dataModel, String returnData) {
        DynamicObject period = (DynamicObject)dataModel.getValue("period");
        DynamicObjectCollection contractPlanEntries = dataModel.getEntryEntity("outcontractplanentity");
        contractPlanEntries.clear();
        DynamicObjectType dt = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_monthlyfundplan")).getDynamicObjectCollection("outcontractplanentity").getDynamicObjectType();
        Object[] customObjectEntries = DynamicObjectSerializeUtil.deserialize((String)returnData, (DynamicObjectType)dt);
        List importEntities = Arrays.stream(customObjectEntries).map(item -> (DynamicObject)item).collect(Collectors.toList());
        for (int i = 0; i < importEntities.size(); ++i) {
            DynamicObject importData = (DynamicObject)importEntities.get(i);
            DynamicObject entry = contractPlanEntries.addNew();
            DynamicObject contract = BusinessDataServiceHelper.loadSingle((Object)importData.getDynamicObject("outcontract").getPkValue(), (String)"pmct_outcontract");
            this.fillCurrentEntry(dataModel, contract, entry);
            if (period == null) continue;
            entry.set("outperiodplanamt", (Object)importData.getBigDecimal("outperiodplanamt"));
            BigDecimal inPeriodPlanAmtStd = AmountCurrencyUtils.amount2StdAmount((BigDecimal)entry.getBigDecimal("outperiodplanamt"), (BigDecimal)entry.getBigDecimal("outexchangerate"), (DynamicObject)((DynamicObject)dataModel.getValue("currency")));
            entry.set("outperiodplanamtstd", (Object)inPeriodPlanAmtStd);
            entry.set("outcontractdescription", (Object)importData.getString("outcontractdescription"));
        }
        return contractPlanEntries;
    }

    private void doFillFundPlanData2BillEntry(IFormView view, int rowIndex, DynamicObject currentEntry, DynamicObject fundPlanContract) {
        currentEntry.set("outcontract", fundPlanContract.get("outcontract"));
        currentEntry.set("outcurrency", fundPlanContract.get("outcurrency"));
        currentEntry.set("outexchangerate", (Object)fundPlanContract.getBigDecimal("outexchangerate"));
        currentEntry.set("outoriginaloftaxamt", fundPlanContract.get("outoriginaloftaxamt"));
        currentEntry.set("outtotalsettleoftaxamt", fundPlanContract.get("outtotalsettleoftaxamt"));
        currentEntry.set("outtotalinvoiceoftaxamt", fundPlanContract.get("outtotalinvoiceoftaxamt"));
        currentEntry.set("outtotalrealoftaxamt", fundPlanContract.get("outtotalrealoftaxamt"));
        currentEntry.set("outinvoicednonpay", fundPlanContract.get("outinvoicednonpay"));
        currentEntry.set("outsettlednonpay", fundPlanContract.get("outsettlednonpay"));
        currentEntry.set("outperiodplanamt", fundPlanContract.get("outperiodplanamt"));
        currentEntry.set("outperiodplanamtstd", fundPlanContract.get("outperiodplanamtstd"));
        currentEntry.set("outcontractbillno", fundPlanContract.get("outcontractbillno"));
        currentEntry.set("partb", fundPlanContract.get("partb"));
        currentEntry.set("outcontractstatus", fundPlanContract.get("outcontractstatus"));
        currentEntry.set("outcontracttype", fundPlanContract.get("outcontracttype"));
        currentEntry.set("outproject", fundPlanContract.get("outproject"));
        currentEntry.set("outorg", fundPlanContract.get("outorg"));
        currentEntry.set("outcontractdescription", fundPlanContract.get("outcontractdescription"));
        DynamicObject contract = BusinessDataServiceHelper.loadSingle((Object)fundPlanContract.getDynamicObject("outcontract").getPkValue(), (String)"pmct_outcontract");
        boolean multiPartSettlement = contract.getBoolean("multipartsettlement");
        String multiPayType = contract.getString("multipaytype");
        if (multiPartSettlement && StringUtils.equals((CharSequence)multiPayType, (CharSequence)ContractMultiTypeEnum.SEPARATEPAY.getValue())) {
            AbstractGrid grid = (AbstractGrid)view.getControl("outcontractplanentity");
            this.setCellColor(grid, "outoriginaloftaxamt", rowIndex);
            this.setCellColor(grid, "outtotalinvoiceoftaxamt", rowIndex);
            this.setCellColor(grid, "outinvoicednonpay", rowIndex);
        }
    }

    private void fillCurrentEntry(IDataModel dataModel, DynamicObject contract, DynamicObject currentEntry) {
        BigDecimal totalPaymentOfTaxAmount;
        BigDecimal totalSettleOfTaxAmount;
        DynamicObject project = (DynamicObject)dataModel.getValue("project");
        DynamicObject org = (DynamicObject)dataModel.getValue("org");
        currentEntry.set("outcontract", (Object)contract);
        currentEntry.set("outcurrency", contract.get("currency"));
        BigDecimal exchangeRate = contract.getBigDecimal("exchangerate");
        if (exchangeRate.compareTo(BigDecimal.ZERO) == 0) {
            exchangeRate = BigDecimal.ONE;
        }
        currentEntry.set("outexchangerate", (Object)exchangeRate);
        currentEntry.set("outoriginaloftaxamt", contract.get("totaloftaxamount"));
        boolean multiPartSettlement = contract.getBoolean("multipartsettlement");
        String multiPayType = contract.getString("multipaytype");
        if (multiPartSettlement && StringUtils.equals((CharSequence)multiPayType, (CharSequence)ContractMultiTypeEnum.SEPARATEPAY.getValue())) {
            MultiSettleAmtService multiSettleAmtService = new MultiSettleAmtService();
            totalSettleOfTaxAmount = multiSettleAmtService.getMultiTotalSettleOfTaxAmt(org, project, contract);
            totalPaymentOfTaxAmount = multiSettleAmtService.getMultiTotalPayOfTaxAmt(org, project, contract);
        } else {
            totalSettleOfTaxAmount = contract.getBigDecimal("totalsettleoftaxamount");
            totalPaymentOfTaxAmount = contract.getBigDecimal("totalrealoftaxamount");
        }
        currentEntry.set("outtotalsettleoftaxamt", (Object)totalSettleOfTaxAmount);
        currentEntry.set("outtotalrealoftaxamt", (Object)totalPaymentOfTaxAmount);
        currentEntry.set("outtotalinvoiceoftaxamt", (Object)contract.getBigDecimal("totalinvoiceoftaxamount"));
        currentEntry.set("outinvoicednonpay", (Object)contract.getBigDecimal("totalinvoiceoftaxamount").subtract(totalPaymentOfTaxAmount));
        currentEntry.set("outsettlednonpay", (Object)totalSettleOfTaxAmount.subtract(totalPaymentOfTaxAmount));
        currentEntry.set("outcontractbillno", contract.get("billno"));
        currentEntry.set("partb", contract.get("partb"));
        currentEntry.set("outcontractstatus", contract.get("contractstatus"));
        currentEntry.set("outcontracttype", contract.get("contracttype"));
        currentEntry.set("outproject", contract.get("project"));
        currentEntry.set("outorg", contract.get("org"));
        currentEntry.set("outcontractdescription", contract.get("description"));
    }

    @Override
    public void updateView(IFormView formView) {
        formView.updateView("outcontractplanentity");
    }
}

