/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.business.manage;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.pmgt.pmbs.common.utils.CurrencyHelper;
import kd.pmgt.pmct.business.manage.INonContractFundPlanningService;
import kd.pmgt.pmct.common.utils.AmountCurrencyUtils;

public class OutNonContractFundPlanningService
implements INonContractFundPlanningService {
    @Override
    public BigDecimal calculateNonPeriodPlanAmtStd(IDataModel dataModel) {
        int curIndex = dataModel.getEntryCurrentRowIndex("outnoncontractplanentity");
        DynamicObject rowEntity = dataModel.getEntryRowEntity("outnoncontractplanentity", curIndex);
        DynamicObject currency = rowEntity.getDynamicObject("outnoncurrency");
        DynamicObject stdCurrency = (DynamicObject)dataModel.getValue("currency");
        DynamicObject exRateTable = rowEntity.getDynamicObject("nonoutexratetable");
        Date exchangeDate = (Date)rowEntity.get("nonoutexchangedate");
        BigDecimal exchangeRate = CurrencyHelper.getExChangeRate((Long)currency.getLong("id"), (Long)stdCurrency.getLong("id"), (Long)exRateTable.getLong("id"), (Date)exchangeDate);
        return AmountCurrencyUtils.amount2StdAmount((BigDecimal)((BigDecimal)dataModel.getValue("nonoutperiodplanamt")), (BigDecimal)exchangeRate, (DynamicObject)stdCurrency);
    }

    @Override
    public void setDefaultExchangeFields(IDataModel dataModel) {
        int currentRowIndex = dataModel.getEntryCurrentRowIndex("outnoncontractplanentity");
        DynamicObject org = (DynamicObject)dataModel.getValue("org");
        DynamicObject currency = CurrencyHelper.getCurrency((Long)((Long)org.getPkValue()));
        DynamicObject exRateTable = CurrencyHelper.getExRateTable((Long)((Long)org.getPkValue()));
        dataModel.setValue("outnoncurrency", (Object)currency, currentRowIndex);
        dataModel.setValue("nonoutexratetable", exRateTable.getPkValue(), currentRowIndex);
        dataModel.setValue("nonoutexchangedate", (Object)new Date(), currentRowIndex);
    }

    @Override
    public DynamicObjectCollection setImportData(IDataModel dataModel, String returnData) {
        DynamicObjectCollection contractPlanEntries = dataModel.getEntryEntity("outnoncontractplanentity");
        contractPlanEntries.clear();
        DynamicObjectType dt = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmct_monthlyfundplan")).getDynamicObjectCollection("outnoncontractplanentity").getDynamicObjectType();
        Object[] customObjectEntries = DynamicObjectSerializeUtil.deserialize((String)returnData, (DynamicObjectType)dt);
        List<DynamicObject> importEntities = Arrays.stream(customObjectEntries).map(item -> (DynamicObject)item).collect(Collectors.toList());
        importEntities.forEach(importData -> {
            DynamicObject entry = contractPlanEntries.addNew();
            entry.set("nonoutcomeitem", (Object)importData.getString("nonoutcomeitem"));
            DynamicObject currency = importData.getDynamicObject("outnoncurrency");
            entry.set("outnoncurrency", (Object)currency);
            DynamicObject exRateTable = importData.getDynamicObject("nonoutexratetable");
            entry.set("nonoutexratetable", (Object)exRateTable);
            Date exchangeDate = importData.getDate("nonoutexchangedate");
            entry.set("nonoutexchangedate", (Object)exchangeDate);
            entry.set("nonoutperiodplanamt", (Object)importData.getBigDecimal("nonoutperiodplanamt"));
            entry.set("nonoutcompanyname", (Object)importData.getString("nonoutcompanyname"));
            DynamicObject stdCurrency = (DynamicObject)dataModel.getValue("currency");
            BigDecimal exchangeRate = CurrencyHelper.getExChangeRate((Long)currency.getLong("id"), (Long)stdCurrency.getLong("id"), (Long)exRateTable.getLong("id"), (Date)exchangeDate);
            BigDecimal inPeriodPlanAmtStd = AmountCurrencyUtils.amount2StdAmount((BigDecimal)entry.getBigDecimal("nonoutperiodplanamt"), (BigDecimal)exchangeRate, (DynamicObject)stdCurrency);
            entry.set("nonoutperiodplanamtstd", (Object)inPeriodPlanAmtStd);
            entry.set("nonoutdescription", (Object)importData.getString("nonoutdescription"));
        });
        return contractPlanEntries;
    }
}

