/*
 * Decompiled with CFR 0.152.
 */
package kd.pmgt.pmct.business.service;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.pmgt.pmbs.common.enums.BudgetSourceTypeEnum;
import kd.pmgt.pmbs.common.enums.PayDirectionEnum;

public class ProjectBudgetItemService {
    public QFilter getBudgetItemFilter(DynamicObject contract) {
        if (contract != null && contract.getDynamicObject("project") != null) {
            Object projectPk = contract.getDynamicObject("project").getPkValue();
            QFilter filter = new QFilter("project", "=", projectPk);
            filter.and(new QFilter("sourcetype", "=", (Object)StringUtils.upperCase((String)contract.getString("paydirection"))));
            DynamicObject[] budgetItems = BusinessDataServiceHelper.load((String)"pmas_projectbudget", (String)String.join((CharSequence)",", "parent", "sourcetype"), (QFilter[])new QFilter[]{filter});
            List ids = Arrays.stream(budgetItems).filter(budgetItem -> {
                QFilter parentFilter = new QFilter("parent", "=", (Object)budgetItem.getLong("id"));
                DynamicObject[] children = BusinessDataServiceHelper.load((String)"pmas_projectbudget", (String)"", (QFilter[])new QFilter[]{parentFilter});
                return children == null || children.length == 0;
            }).map(DataEntityBase::getPkValue).collect(Collectors.toList());
            return new QFilter("id", "in", ids);
        }
        return null;
    }

    public QFilter getBudgetItemFilterByProject(DynamicObject project, String payDirection) {
        if (project != null) {
            Object projectPk = project.getPkValue();
            QFilter filter = new QFilter("project", "=", projectPk);
            if (StringUtils.equals((CharSequence)PayDirectionEnum.IN.getValue(), (CharSequence)payDirection)) {
                filter.and(new QFilter("sourcetype", "=", (Object)BudgetSourceTypeEnum.IN.getValue()));
            } else {
                filter.and(new QFilter("sourcetype", "!=", (Object)BudgetSourceTypeEnum.IN.getValue()));
            }
            DynamicObject[] budgetItems = BusinessDataServiceHelper.load((String)"pmas_projectbudget", (String)"parent", (QFilter[])new QFilter[]{filter});
            List ids = Arrays.stream(budgetItems).filter(budgetItem -> {
                QFilter parentFilter = new QFilter("parent", "=", (Object)budgetItem.getLong("id"));
                DynamicObject[] children = BusinessDataServiceHelper.load((String)"pmas_projectbudget", (String)"", (QFilter[])new QFilter[]{parentFilter});
                return children == null || children.length == 0;
            }).map(DataEntityBase::getPkValue).collect(Collectors.toList());
            return new QFilter("id", "in", ids);
        }
        return null;
    }
}

