/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.adm.common;

import java.net.URLEncoder;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.IAppCache;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.IFormView;
import kd.bos.form.control.Html;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.adm.common.sdk.ISrmRegisterSendMessageServiceImpl;
import kd.scm.common.util.AESUtil;
import kd.scm.common.util.CommonUtil;
import kd.sdk.scm.srm.extpoint.ISrmRegisterSendMessageService;

public class AdmCommonUtils {
    private static Log log = LogFactory.getLog(AdmCommonUtils.class);
    private static int verfyCodeExpireTime = 300;

    public static String getAdmFirstPage(Map<String, Object> enableData) {
        Object id = enableData.get("id");
        Object numbers = enableData.get("number");
        Object names = enableData.get("name");
        Object enterprise = enableData.get("enterprise");
        try {
            String encryptnumbers = AESUtil.encryptToStringNew((String)numbers.toString());
            numbers = URLEncoder.encode(URLEncoder.encode(encryptnumbers, "UTF-8"), "UTF-8");
            String encrypnames = AESUtil.encryptToStringNew((String)names.toString());
            names = URLEncoder.encode(URLEncoder.encode(encrypnames, "UTF-8"), "UTF-8");
            String encrypenterprise = AESUtil.encryptToStringNew((String)enterprise.toString());
            enterprise = URLEncoder.encode(URLEncoder.encode(encrypenterprise, "UTF-8"), "UTF-8");
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return CommonUtil.getDomainUrlWidthouSlash() + "/index.html";
        }
        return CommonUtil.getDomainUrlWidthouSlash() + "/index.html?formId=adm_admittance&id=" + id + "&number=" + numbers + "&name=" + names + "&enterprise=" + enterprise;
    }

    public static void addOnProgressListener(AbstractFormPlugin dataModelPlugin, String progress, String getmsg, String htmlap) {
        ((ProgressBar)dataModelPlugin.getControl(progress)).addProgressListener(progressEvent -> {
            ProgressBar progressBar = (ProgressBar)dataModelPlugin.getControl(progress);
            progressBar.stop();
            dataModelPlugin.getView().setVisible(Boolean.TRUE, new String[]{getmsg});
            dataModelPlugin.getView().setVisible(Boolean.FALSE, new String[]{htmlap});
            dataModelPlugin.getView().updateView();
        });
    }

    public static boolean getMsg(AbstractFormPlugin dataModelPlugin, IAppCache verifyCodeExpire, BeforeClickEvent evt, String fun) {
        return true;
    }

    public static Map<String, Object> getMsgValid(String account, IAppCache verifyCodeExpire) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(8);
        resultMap.put("success", true);
        StringBuilder msg = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)account)) {
            if (account.contains("+86")) {
                account = account.substring(3, 14);
            }
            if (StringUtils.isEmail((String)account) || StringUtils.isPhoneNumberValid((String)account) || account.contains("-")) {
                if (verifyCodeExpire == null) {
                    msg.append(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u9a8c\u8bc1\u7801\u4ecd\u6709\u6548\uff0c\u65e0\u9700\u518d\u6b21\u83b7\u53d6\u3002", (String)"AdmCommonUtils_4", (String)"scm-adm-common", (Object[])new Object[0]), (String)"AdmCommonUtils_4", (String)"scm-adm-common", (Object[])new Object[0]));
                    resultMap.put("success", false);
                    resultMap.put("msg", msg);
                }
            } else {
                msg.append(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u624b\u673a\u53f7/\u90ae\u7bb1\u8f93\u5165\u9519\u8bef\u3002", (String)"AdmCommonUtils_5", (String)"scm-adm-common", (Object[])new Object[0]), (String)"AdmCommonUtils_5", (String)"scm-adm-common", (Object[])new Object[0]));
                resultMap.put("success", false);
                resultMap.put("msg", msg);
            }
        } else {
            msg.append(ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u624b\u673a\u53f7/\u90ae\u7bb1\u3002", (String)"AdmCommonUtils_6", (String)"scm-adm-common", (Object[])new Object[0]), (String)"AdmCommonUtils_6", (String)"scm-adm-common", (Object[])new Object[0]));
            resultMap.put("success", false);
            resultMap.put("msg", msg);
        }
        return resultMap;
    }

    public static void getMsg(AbstractFormPlugin dataModelPlugin, IAppCache verifyCodeExpire, String fun) {
        String randomStr = AdmCommonUtils.createRandNum();
        IFormView view = dataModelPlugin.getView();
        view.getPageCache().put("randomStr", randomStr);
        String account = String.valueOf(dataModelPlugin.getView().getModel().getValue("number"));
        ISrmRegisterSendMessageServiceImpl defPlugin = new ISrmRegisterSendMessageServiceImpl();
        PluginProxy pluginProxy = PluginProxy.create((Object)defPlugin, ISrmRegisterSendMessageService.class, (String)"SCM_SRM_REGISTER1SENDMESSAGE_EXT", null);
        pluginProxy.callReplaceIfPresent(p -> {
            p.sendMessage(verifyCodeExpire, account, randomStr, fun);
            return null;
        });
        view.getPageCache().put("randomStr", randomStr + account);
        view.setVisible(Boolean.FALSE, new String[]{"getmsg"});
        view.setVisible(Boolean.TRUE, new String[]{"htmlap"});
        Html html = (Html)view.getControl("htmlap");
        html.setConent(AdmCommonUtils.getHtmlStr());
        ProgressBar progress = (ProgressBar)view.getControl("progressbarap");
        progress.start();
    }

    private static String createRandNum() {
        SecureRandom random = new SecureRandom();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i <= 5; ++i) {
            String s = random.nextInt(10) + "";
            sb.append(s);
        }
        return sb.toString();
    }

    private static boolean verifyCodeExpire(String account, String code, IAppCache verifyCodeExpire) {
        String verifyCode = (String)verifyCodeExpire.get(account, String.class);
        if (verifyCode != null) {
            return false;
        }
        verifyCodeExpire.put(account, (Object)code, 60);
        return true;
    }

    public static String validateVerycode(String randomStr, String validate) {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)validate)) {
            if (StringUtils.isEmpty((CharSequence)randomStr)) {
                sb.append(ResManager.loadKDString((String)"\u9a8c\u8bc1\u7801\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6\u3002\n", (String)"AdmCommonUtils_11", (String)"scm-adm-common", (Object[])new Object[0]));
                return sb.toString();
            }
            if (!StringUtils.equals((CharSequence)randomStr, (CharSequence)validate)) {
                sb.append(ResManager.loadKDString((String)"\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002\n", (String)"AdmCommonUtils_12", (String)"scm-adm-common", (Object[])new Object[0]));
            }
        } else {
            sb.append(ResManager.loadKDString((String)"\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u586b\u5199\u3002\n", (String)"AdmCommonUtils_13", (String)"scm-adm-common", (Object[])new Object[0]));
        }
        return sb.toString();
    }

    private static String getHtmlStr() {
        StringBuilder content = new StringBuilder();
        content.append("<html><style>.cell{font-family:'Microsoft YaHei';");
        content.append("width:7em;height:1em;font-size:1em;overflow:hidden;position:relative;line-height:1em;top:28%;left:5%;margin:0;opacity:0;animation:go 60s;transform-origin:left bottom;}");
        content.append(".num{display:inline;position:absolute;margin-top:-1px;margin-left:2px;width:1.8em;color:#333;line-height:1em;text-align:center;text-shadow:0px 0px 0px rgba(255,255,255,.3);animation:run 60s steps(60);}");
        content.append("@keyframes run{0%{top:0;}100%{top:-60em;}}");
        content.append("@keyframes go{0%{opacity:1;}99.84%{opacity:1;transform:rotate(0deg)scale(1);}100%{opacity:0;transform:rotate(0deg)scale(.01);}}.main{display:inline-block;width:90px;height:28px;border:1px solid#BBB;background-color:#DDD;}");
        content.append(".content{margin-left:3px;margin-right:2px}</style><body><div class='main'><div class='cell'><span class='content'>");
        content.append(AdmCommonUtils.getMsg());
        content.append("</span><div class='num'>(59) (58) (57) (56) (55) (54) (53) (52) (51) (50) (49) (48) (47) (46) (45) (44) (43) (42) (41) (40) (39) (38) (37) (36) (35) (34) (33) (32) (31) (30) (29) (28) (27) (26) (25) (24) (23) (22) (21) (20)");
        content.append("(19) (18) (17) (16) (15) (14) (13) (12) (11) (10) (9) (8) (7) (6) (5) (4) (3) (2) (1) (0)</div></div></div></body></html>");
        return content.toString();
    }

    private static String getMsg() {
        return ResManager.loadKDString((String)"\u91cd\u65b0\u83b7\u53d6", (String)"AdmForgetPwdPlugin_9", (String)"scm-adm-formplugin", (Object[])new Object[0]);
    }

    public static void updateEnterpriseNames(DynamicObject[] dataEntities) {
        HashMap supplierMap = new HashMap(20);
        for (DynamicObject obj : dataEntities) {
            HashMap<String, String> modifyMap = new HashMap<String, String>(10);
            modifyMap.put("name", obj.getString("name"));
            modifyMap.put("code", obj.getString("societycreditcode"));
            modifyMap.put("linkman", obj.getString("linkman"));
            modifyMap.put("phone", obj.getString("phone"));
            supplierMap.put(obj.getString("id"), modifyMap);
        }
        if (!supplierMap.isEmpty()) {
            DynamicObject[] supplierUsers;
            String selects = "id,enterprise,creditno,name,number,supplierregid";
            for (DynamicObject supplierUser : supplierUsers = BusinessDataServiceHelper.load((String)"srm_user", (String)selects, (QFilter[])new QFilter[]{new QFilter("supplierregid", "in", supplierMap.keySet())})) {
                for (Map.Entry entry : supplierMap.entrySet()) {
                    if (!((String)entry.getKey()).equals(supplierUser.getString("supplierregid"))) continue;
                    supplierUser.set("enterprise", ((Map)entry.getValue()).get("name"));
                    supplierUser.set("creditno", ((Map)entry.getValue()).get("code"));
                    supplierUser.set("name", ((Map)entry.getValue()).get("linkman"));
                    supplierUser.set("number", ((Map)entry.getValue()).get("phone"));
                }
            }
            OperateOption option = OperateOption.create();
            option.setVariableValue("isStrict", String.valueOf(false));
            SaveServiceHelper.update((DynamicObject[])supplierUsers, (OperateOption)option);
        }
    }
}

