/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.adm.formplugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.exception.ORMDesignException;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.pluginnew.GridCardPlugin;
import kd.scm.common.ORMUtil;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.OpenFormUtil;
import kd.scm.common.util.SrmUserUtil;

public class AdmCardOpinionPlugin
extends GridCardPlugin
implements HyperLinkClickListener {
    private Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"labelap"});
        BillList billList = (BillList)this.getView().getControl("billlistap");
        billList.addHyperClickListener((HyperLinkClickListener)this);
    }

    protected void refreshCard(Map<String, String> allConfigMap) {
        super.refreshCard(allConfigMap);
        try {
            String number = this.getView().getParentView().getModel().getDataEntity().getString("number");
            if (StringUtils.isEmpty((CharSequence)number)) {
                this.showNullData();
            }
            long id = 0L;
            Map availableSrmRegSupplierData = SrmUserUtil.getAvailableSrmRegSupplierData((String)number);
            if (!availableSrmRegSupplierData.isEmpty()) {
                Long enterprise = (Long)availableSrmRegSupplierData.get("enterprise");
                QFilter qFilter = new QFilter("srctype", "!=", (Object)"srm_categorychg").and(new QFilter("srctype", "!=", (Object)"srm_supquit"));
                if (enterprise != null) {
                    id = enterprise;
                    qFilter.and(new QFilter("supplier", "=", (Object)id));
                }
                this.getPageCache().put("qFilter", qFilter.toSerializedString());
                BillList billList = (BillList)this.getControl("billlistap");
                billList.getDataPermQFilters().add(qFilter);
                billList.refresh();
            } else {
                this.showNullData();
            }
        }
        catch (ORMDesignException e) {
            this.showNullData();
            this.log.error(e.getMessage());
        }
    }

    private void showNullData() {
        QFilter qFilter = new QFilter("supplier", "=", null);
        this.getPageCache().put("qFilter", qFilter.toSerializedString());
        BillList billList = (BillList)this.getControl("billlistap");
        billList.getDataPermQFilters().add(qFilter);
        billList.refresh();
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "labelap": {
                this.openDealPage();
            }
        }
    }

    protected void openDealPage() {
        if (null != this.getPageCache().get("qFilter")) {
            QFilter qFilter = QFilter.fromSerializedString((String)this.getPageCache().get("qFilter"));
            OpenFormUtil.openListPage((IFormView)this.getView(), (String)"adm_examopinion", (ShowType)ShowType.NewWindow, null, (QFilter)qFilter, null);
        } else {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5f53\u524d\u9875\u9762\u6682\u4e0d\u652f\u6301\u6dfb\u52a0\u8be5\u5361\u7247\u529f\u80fd\u3002", (String)"AdmCardOpinionPlugin_0", (String)"scm-adm-formplugin", (Object[])new Object[0]));
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent heperLinkEvent) {
        BillList grid = (BillList)heperLinkEvent.getSource();
        Object rowPkId = grid.getFocusRowPkId();
        this.showBillForm(rowPkId, "adm_examopinion");
    }

    public void showBillForm(Object val, String entityKey) {
        if (val == null || entityKey == null || entityKey.isEmpty()) {
            return;
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("entryid", val);
        DynamicObject dynaObject = ORMUtil.queryOneByPro((String)entityKey, (String)"srctype,srcbillid", param);
        if (dynaObject != null) {
            this.getView().showForm((FormShowParameter)BillFormUtil.assembleShowBillFormParam((String)dynaObject.getString("srctype"), (ShowType)ShowType.NewWindow, (OperationStatus)OperationStatus.VIEW, (long)Long.parseLong(dynaObject.getString("srcbillid")), new HashMap(), null));
        }
    }
}

