/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.adm.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.util.PhoneValidator;
import kd.bos.portal.util.LoginMCServiceUtil;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.url.UrlService;
import kd.scm.adm.common.AdmCommonUtils;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.OpenFormUtil;

public class AdmLoginPlugin
extends AbstractFormPlugin {
    private Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    protected IAppCache verifyCodeExpire = AppCache.get((String)"loginVerifyCodeExpire");
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("SCM_ADM_LOGIN_DATA");

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"htmlap"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"progressbarap"});
        this.setLogo();
    }

    private void setLogo() {
        try {
            String value = LoginMCServiceUtil.getMcData((String)"_tenant_login_config_values_");
            if (StringUtils.isNotEmpty((CharSequence)value)) {
                HashMap resultMap = (HashMap)SerializationUtils.fromJsonString((String)value, HashMap.class);
                if (resultMap == null) {
                    return;
                }
                FileService imageFileService = FileServiceFactory.getImageFileService();
                String realPath = imageFileService.getRealPath((String)resultMap.get("lefttoplogoimg"));
                if (StringUtils.isNotBlank((CharSequence)realPath)) {
                    realPath = UrlService.getImageFullUrl((String)String.valueOf(realPath));
                    Image imageap = (Image)this.getControl("imageap");
                    if (imageap != null) {
                        imageap.setUrl(realPath);
                    }
                }
            }
        }
        catch (Exception e) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8c03\u7528\u79df\u6237\u7ba1\u7406\u4e2d\u5fc3\u5931\u8d25\uff0c\u65e0\u6709\u6548\u6570\u636e\u3002", (String)"AdmLoginPlugin_16", (String)"scm-adm-formplugin", (Object[])new Object[0]));
            this.log.error("\u8c03\u7528\u79df\u6237\u7ba1\u7406\u4e2d\u5fc3\u5931\u8d25\uff0c\u65e0\u6709\u6548\u6570\u636e" + e.getMessage());
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button getMsg = (Button)this.getView().getControl("getmsg");
        getMsg.addClickListener((ClickListener)this);
        AdmCommonUtils.addOnProgressListener((AbstractFormPlugin)this, (String)"progressbarap", (String)"getmsg", (String)"htmlap");
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)"getmsg", (CharSequence)source.getKey()) && this.validateInfo(false)) {
            String verifycodeaccept = this.getView().getPageCache().get("verifycodeaccept");
            String number = this.getModel().getValue("number").toString();
            if (StringUtils.isBlank((CharSequence)verifycodeaccept)) {
                if (this.isRegisterPhoneBusy(number)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u9891\u7e41\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"AdmLoginPlugin_17", (String)"scm-adm-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                String selectBaseDataFieldsForm = "adm_getverifycodeimg";
                OpenFormUtil.openDynamicPage((IFormView)this.getView(), (String)selectBaseDataFieldsForm, (ShowType)ShowType.Modal, null, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "verifycode"));
            } else {
                Map resultMap = AdmCommonUtils.getMsgValid((String)number, (IAppCache)this.verifyCodeExpire);
                if (((Boolean)resultMap.get("success")).booleanValue()) {
                    String selectBaseDataFieldsForm = "adm_getverifycodeimg";
                    OpenFormUtil.openDynamicPage((IFormView)this.getView(), (String)selectBaseDataFieldsForm, (ShowType)ShowType.Modal, null, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "verifycode"));
                } else {
                    this.getView().showMessage(resultMap.get("msg").toString());
                    evt.setCancel(true);
                    return;
                }
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if ("verifycode".equals(closedCallBackEvent.getActionId())) {
            String number = this.getModel().getValue("number").toString();
            String tenantId = RequestContext.get().getTenantId();
            String key = tenantId + number;
            String value = (String)cache.get(key);
            if (StringUtils.isNotBlank((CharSequence)value)) {
                int time = Integer.parseInt(value);
                if (++time > 6) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u9891\u7e41\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"AdmLoginPlugin_17", (String)"scm-adm-formplugin", (Object[])new Object[0]));
                } else {
                    cache.put(key, (Object)("" + time), 180);
                    Object returnData = closedCallBackEvent.getReturnData();
                    if (Objects.nonNull(returnData)) {
                        AdmCommonUtils.getMsg((AbstractFormPlugin)this, (IAppCache)this.verifyCodeExpire, (String)ResManager.loadKDString((String)"\u767b\u5f55", (String)"AdmLoginPlugin_18", (String)"scm-adm-formplugin", (Object[])new Object[0]));
                    }
                }
            }
        }
    }

    private boolean isRegisterPhoneBusy(String phone) {
        String tenantId = RequestContext.get().getTenantId();
        String key = tenantId + phone;
        String value = (String)cache.get(key);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            int time = Integer.parseInt(value);
            if (++time > 6) {
                return true;
            }
            cache.put(key, (Object)("" + time), 180);
        } else {
            cache.put(key, (Object)"1", 180);
        }
        return false;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        switch (operateKey = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "login": {
                this.validateInfo(true);
                break;
            }
        }
    }

    private void solPhoneValid() {
        String number = this.getModel().getValue("number").toString();
        if (StringUtils.isNotBlank((CharSequence)number)) {
            String[] split;
            int i;
            int charnum = 0;
            for (i = 0; i < number.length(); ++i) {
                if (number.charAt(i) != '-') continue;
                ++charnum;
            }
            if (charnum != 0 && (split = number.split("-", 2))[0].equals("86")) {
                number = number.substring(3);
                --charnum;
            }
            for (i = 0; i < charnum - 1; ++i) {
                int index = number.indexOf(45);
                number = number.substring(0, index) + number.substring(index + 1);
            }
            this.getModel().setValue("number", (Object)number);
            this.getView().updateView("number");
        }
    }

    private Map<String, Object> isPhone() {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String number = this.getModel().getValue("number").toString();
        resultMap.put("succed", Boolean.TRUE);
        try {
            PhoneValidator phoneValidator = new PhoneValidator(number, true);
            phoneValidator.check();
        }
        catch (KDBizException e) {
            resultMap.put("succed", Boolean.FALSE);
            resultMap.put("message", ResManager.loadKDString((String)"\u201c\u8d26\u53f7\u201d\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"AdmLoginPlugin_19", (String)"scm-adm-formplugin", (Object[])new Object[0]));
            this.log.error("\u201c\u8d26\u53f7\u201d\u683c\u5f0f\u4e0d\u6b63\u786e\uff1a" + e.getMessage());
        }
        return resultMap;
    }

    private boolean validateInfo(boolean isValidateCode) {
        String info;
        String number;
        IDataModel model = this.getModel();
        String validate = model.getValue("validate").toString();
        Object numberobj = this.getModel().getValue("number");
        if (numberobj != null) {
            this.getModel().setValue("number", (Object)numberobj.toString().replace(" ", ""));
        }
        if (!(StringUtils.isBlank((CharSequence)(number = this.getModel().getValue("number").toString())) || StringUtils.isEmail((String)number) || StringUtils.isPhoneNumberValid((String)number))) {
            this.solPhoneValid();
        }
        boolean isSucced = true;
        if (StringUtils.isNotBlank((CharSequence)number)) {
            if (number.contains("+86")) {
                number = number.substring(3, 14);
            }
            if (StringUtils.isEmail((String)number)) {
                isSucced = true;
            } else if (StringUtils.isPhoneNumberValid((String)number)) {
                isSucced = true;
            } else {
                this.solPhoneValid();
                if (((Boolean)this.isPhone().get("succed")).booleanValue()) {
                    isSucced = true;
                } else {
                    this.getView().showMessage(this.isPhone().get("message").toString());
                    isSucced = false;
                }
            }
        }
        if (number == null || number.trim().equals("")) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AdmLoginPlugin_12", (String)"scm-adm-formplugin", (Object[])new Object[0]));
            isSucced = false;
        }
        if (isValidateCode && StringUtils.isNotBlank((CharSequence)(info = AdmCommonUtils.validateVerycode((String)((String)this.verifyCodeExpire.get(number, String.class)), (String)validate)))) {
            isSucced = false;
            this.getView().showMessage(info);
        }
        if (isSucced) {
            ArrayList availableSecUser = new ArrayList(1);
            QFilter qFilter = new QFilter("phone", "=", (Object)number).or("email", "=", (Object)number).and(new QFilter("enable", "=", (Object)"1"));
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)"bos_user", (String)"id", (QFilter[])new QFilter[]{qFilter}, (String)"id", (int)1);){
                dataSet.forEach(row -> availableSecUser.add(row.getLong("id")));
            }
            if (!availableSecUser.isEmpty()) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u6b64\u8d26\u53f7\u5df2\u5ba1\u6279\u901a\u8fc7\uff0c\u8bf7\u70b9\u51fb\u201c\u767b\u5f55\u201d\u6309\u94ae\u8fdb\u5165\u7cfb\u7edf\u3002", (String)"AdmLoginPlugin_13", (String)"scm-adm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK, new ConfirmCallBackListener("jumpToLogin"));
                if (!isValidateCode) {
                    return false;
                }
            } else {
                HashMap enableData = new HashMap();
                HashMap disableData = new HashMap();
                try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)"srm_user", (String)"id,number,name,enterprise,status,enable", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number)}, (String)"id");){
                    dataSet.forEach(row -> {
                        if (row.getBoolean("enable").booleanValue()) {
                            enableData.put("id", row.getLong("id"));
                            enableData.put("name", row.getString("name"));
                            enableData.put("number", row.getString("number"));
                            enableData.put("enterprise", row.get("enterprise"));
                            enableData.put("status", row.getString("status"));
                        } else {
                            disableData.put(row.getLong("id"), row.getLong("id"));
                        }
                    });
                }
                if (disableData.isEmpty() && enableData.isEmpty()) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u83b7\u53d6\u9a8c\u8bc1\u7801\u5931\u8d25\uff0c\u5f53\u524d\u7528\u6237\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\u3002", (String)"AdmLoginPlugin_5", (String)"scm-adm-formplugin", (Object[])new Object[0]));
                    isSucced = false;
                } else if (!enableData.isEmpty() && !BillStatusEnum.AUDIT.getVal().equals(enableData.get("status"))) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u8fd8\u672a\u7ecf\u8fc7\u91c7\u8d2d\u65b9\u5ba1\u6838\uff0c\u6682\u65f6\u4e0d\u80fd\u767b\u5f55\u3002", (String)"AdmLoginPlugin_6", (String)"scm-adm-formplugin", (Object[])new Object[0]));
                    isSucced = false;
                } else if (enableData.isEmpty() && !disableData.isEmpty()) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u5df2\u7ecf\u88ab\u7981\u7528\uff0c\u4e0d\u80fd\u518d\u767b\u5f55\u3002", (String)"AdmLoginPlugin_7", (String)"scm-adm-formplugin", (Object[])new Object[0]));
                    isSucced = false;
                } else if (!enableData.isEmpty() && BillStatusEnum.AUDIT.getVal().equals(enableData.get("status"))) {
                    ArrayList supplierReg = new ArrayList(1);
                    try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)"adm_supplierreg", (String)"id", (QFilter[])new QFilter[]{new QFilter("phone", "=", (Object)number).and(new QFilter("enable", "=", (Object)"1"))}, (String)"id");){
                        dataSet.forEach(row -> supplierReg.add(row.getLong("id")));
                    }
                    if (supplierReg.isEmpty()) {
                        this.getView().showMessage(ResManager.loadResFormat((String)"\u6ca1\u6709\u627e\u5230\u8d26\u53f7\u4e3a%1\u6240\u5bf9\u5e94\u7684\u4f01\u4e1a\u6ce8\u518c\u8d44\u6599\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AdmLoginPlugin_15", (String)"scm-adm-formplugin", (Object[])new Object[]{number}));
                        isSucced = false;
                    } else if (isValidateCode) {
                        DynamicObjectCollection query = QueryServiceHelper.query((String)"adm_registerstatus", (String)"id", (QFilter[])new QFilter[]{new QFilter("phone", "=", (Object)number)});
                        if (!query.isEmpty()) {
                            long id = ((DynamicObject)query.get(0)).getLong("id");
                            BaseShowParameter bsp = new BaseShowParameter();
                            bsp.setFormId("adm_registerstatus");
                            bsp.setPkId((Object)id);
                            bsp.setBillStatus(BillOperationStatus.EDIT);
                            bsp.getOpenStyle().setShowType(ShowType.NewBrowserPage);
                            this.getView().showForm((FormShowParameter)bsp);
                        }
                        this.getView().close();
                    }
                }
            }
        }
        if (!isSucced) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u767b\u5f55\u4fe1\u606f\u4e0d\u6b63\u786e\uff0c\u8bf7\u67e5\u8be2\u8be6\u60c5\u3002", (String)"AdmLoginPlugin_10", (String)"scm-adm-formplugin", (Object[])new Object[0]));
        }
        return isSucced;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if ("jumpToLogin".equals(messageBoxClosedEvent.getCallBackId())) {
            String url = CommonUtil.getDomainUrlWidthouSlash() + "/login.html";
            this.getView().openUrl(url);
            this.getView().close();
        }
    }
}

