/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.adm.formplugin;

import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.i18n.api.model.TelephoneVerifyResult;
import kd.bos.i18n.mservice.I18nServiceHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.util.LoginMCServiceUtil;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.url.UrlService;
import kd.scm.adm.common.AdmCommonUtils;
import kd.scm.adm.service.opp.AdmRegistUserSubmitService;
import kd.scm.adm.service.valid.AdmRegistValid;
import kd.scm.common.cloudkingdee.CloudDataUtils;
import kd.scm.common.cloudkingdee.CompanyInfo;
import kd.scm.common.skyeye.QiChaChaApiUtil;
import kd.scm.common.skyeye.config.QiChaChaConfig;
import kd.scm.common.skyeye.config.SkyEyeConfig;
import kd.scm.common.util.OpenFormUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.common.util.SupplierLifeCycleManagerUtil;

public class AdmRegisterPlugin
extends AbstractFormPlugin {
    protected IAppCache verifyCodeExpire = AppCache.get((String)"verifyCodeExpire");
    private static Log log = LogFactory.getLog((String)"AdmRegisterPlugin");
    public static final String JUMP_SIGN = "sign";
    public AdmRegistValid admRegistValid = new AdmRegistValid();
    public AdmRegistUserSubmitService admRegistUserSubmitService = new AdmRegistUserSubmitService();
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("SCM_ADM_LOGIN_DATA");

    public void initialize() {
        Map customParams = this.getView().getFormShowParameter().getShowParameter().getCustomParams();
        if (customParams.containsKey(JUMP_SIGN)) {
            OpenFormUtil.openDynamicPage((IFormView)this.getView(), (String)"adm_register", (ShowType)ShowType.InCurrentForm, null, null);
        } else {
            super.initialize();
            AdmCommonUtils.addOnProgressListener((AbstractFormPlugin)this, (String)"progressbarap", (String)"getmsg", (String)"htmlap");
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setStatusVisible(true);
        Map customParams = this.getView().getFormShowParameter().getShowParameter().getCustomParams();
        Object agree = customParams.get("agree");
        if (Objects.nonNull(agree) && "true".equals(agree.toString())) {
            this.getView().getModel().setValue("isagreed", agree);
            this.getView().setEnable(Boolean.FALSE, new String[]{"isagreed"});
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setLogo();
    }

    private void setLogo() {
        try {
            String value = LoginMCServiceUtil.getMcData((String)"_tenant_login_config_values_");
            if (StringUtils.isNotEmpty((CharSequence)value)) {
                HashMap resultMap = (HashMap)SerializationUtils.fromJsonString((String)value, HashMap.class);
                if (resultMap == null) {
                    return;
                }
                FileService imageFileService = FileServiceFactory.getImageFileService();
                String realPath = imageFileService.getRealPath((String)resultMap.get("lefttoplogoimg"));
                if (StringUtils.isNotBlank((CharSequence)realPath)) {
                    realPath = UrlService.getImageFullUrl((String)String.valueOf(realPath));
                    Image imageap = (Image)this.getControl("imageap");
                    if (imageap != null) {
                        imageap.setUrl(realPath);
                    }
                }
            }
        }
        catch (Exception e) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8c03\u7528\u79df\u6237\u7ba1\u7406\u4e2d\u5fc3\u5931\u8d25\uff0c\u65e0\u6709\u6548\u6570\u636e\u3002", (String)"AdmRegisterPlugin_31", (String)"scm-adm-formplugin", (Object[])new Object[0]));
            log.error("\u8c03\u7528\u79df\u6237\u7ba1\u7406\u4e2d\u5fc3\u5931\u8d25\uff0c\u65e0\u6709\u6548\u6570\u636e" + e.getMessage());
        }
    }

    private void setStatusVisible(boolean isInit) {
        if (isInit) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"namefail"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"namesuccess"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"nofail"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"nosuccess"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"htmlap"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"progressbarap"});
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"agreement"});
        Button getMsg = (Button)this.getView().getControl("getmsg");
        getMsg.addClickListener((ClickListener)this);
        AdmCommonUtils.addOnProgressListener((AbstractFormPlugin)this, (String)"progressbarap", (String)"getmsg", (String)"htmlap");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void propertyChanged(PropertyChangedArgs e) {
        DynamicObject qiChaChaDyo;
        super.propertyChanged(e);
        String fieldKey = e.getProperty().getName();
        ChangeData[] changedData = e.getChangeSet();
        if (StringUtils.equals((CharSequence)"enterprise", (CharSequence)fieldKey)) {
            DynamicObject obj = QueryServiceHelper.queryOne((String)"srm_declarationref", (String)"cfmstatus", (QFilter[])new QFilter[]{new QFilter("isdisplay", "=", (Object)"1")});
            String cfmstatus = "";
            if (Objects.nonNull(obj)) {
                cfmstatus = obj.getString("cfmstatus");
            }
            LocaleDynamicObjectCollection newLocalDyo = (LocaleDynamicObjectCollection)changedData[0].getNewValue();
            LocaleDynamicObjectCollection oldLocalDyo = (LocaleDynamicObjectCollection)changedData[0].getOldValue();
            String newValue = newLocalDyo.size() > 0 ? ((DynamicObject)newLocalDyo.get(0)).getString("enterprise") : "";
            String oldValue = oldLocalDyo.size() > 0 ? ((DynamicObject)oldLocalDyo.get(0)).getString("enterprise") : "";
            String creditNo = (String)this.getModel().getValue("creditno");
            if (StringUtils.isBlank((CharSequence)newValue) && StringUtils.isNotBlank((CharSequence)creditNo)) {
                this.getModel().setValue("creditno", null);
                this.getView().setVisible(Boolean.FALSE, new String[]{"namefail"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"nofail"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"namesuccess"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"nosuccess"});
                return;
            }
            if (StringUtils.equals((CharSequence)newValue, (CharSequence)oldValue)) {
                return;
            }
            if (!"B".equals(cfmstatus)) return;
            String creditno = this.getCreditno(newValue);
            if (creditno != null) {
                this.getModel().setValue("creditno", (Object)creditno);
            }
            if (!StringUtils.isNotBlank((CharSequence)creditNo)) return;
            DynamicObject skyEyeDyo = SkyEyeConfig.getSkyEyeConfig();
            if (null != skyEyeDyo) {
                if (QiChaChaApiUtil.verifySupplier((String)newValue, (String)creditNo)) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"namefail"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"nofail"});
                    this.getView().setVisible(Boolean.TRUE, new String[]{"namesuccess"});
                    this.getView().setVisible(Boolean.TRUE, new String[]{"nosuccess"});
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"namesuccess"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"nosuccess"});
                    this.getView().setVisible(Boolean.TRUE, new String[]{"namefail"});
                    this.getView().setVisible(Boolean.TRUE, new String[]{"nofail"});
                }
            }
        }
        if (!StringUtils.equals((CharSequence)"creditno", (CharSequence)fieldKey)) return;
        String newValue = StringUtils.isNotBlank((Object)changedData[0].getNewValue()) ? String.valueOf(changedData[0].getNewValue()) : "";
        String oldValue = StringUtils.isNotBlank((Object)changedData[0].getOldValue()) ? String.valueOf(changedData[0].getOldValue()) : "";
        String companyName = this.getModel().getValue("enterprise").toString();
        if (StringUtils.isBlank((CharSequence)newValue) && StringUtils.isNotBlank((CharSequence)companyName)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"namesuccess"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"nosuccess"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"namefail"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"nofail"});
            return;
        }
        if (StringUtils.equals((CharSequence)newValue, (CharSequence)oldValue)) {
            return;
        }
        if (!StringUtils.isNotBlank((CharSequence)companyName) || null == (qiChaChaDyo = QiChaChaConfig.getQiChaChaConfig())) return;
        if (QiChaChaApiUtil.verifySupplier((String)companyName, (String)newValue)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"namefail"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"nofail"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"namesuccess"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"nosuccess"});
            return;
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"namesuccess"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"nosuccess"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"namefail"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"nofail"});
        }
    }

    private String getCreditno(String companyName) {
        String creditno = null;
        CompanyInfo companyInfo = CloudDataUtils.getCompanyInfo((String)companyName);
        if (companyInfo != null) {
            creditno = companyInfo.getSocialCreditCode();
        }
        return creditno;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control source = (Control)evt.getSource();
        if (!StringUtils.equals((CharSequence)"getmsg", (CharSequence)source.getKey())) return;
        StringBuilder sb = new StringBuilder();
        boolean isSucced = this.validateInfo(sb, false);
        if (!isSucced) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6ce8\u518c\u8d44\u6599\u4e0d\u7b26\u5408\u8981\u6c42\uff0c\u8bf7\u67e5\u770b\u8be6\u60c5\uff1a", (String)"AdmRegisterPlugin_22", (String)"scm-adm-formplugin", (Object[])new Object[0]), sb.toString(), MessageTypes.Permission);
            return;
        }
        String number = this.getModel().getValue("number").toString();
        if (this.isRegisterPhoneBusy(number)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u9891\u7e41\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"AdmRegisterPlugin_32", (String)"scm-adm-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        String resMsg = "";
        Map<String, Object> resMap = null;
        if (!(StringUtils.isEmail((String)number) || StringUtils.isPhoneNumberValid((String)number) || ((Boolean)(resMap = this.isPhone()).get("succed")).booleanValue())) {
            resMsg = resMap.get("message").toString();
            this.getView().showTipNotification(resMsg);
            return;
        }
        Map resultMap = AdmCommonUtils.getMsgValid((String)number, (IAppCache)this.verifyCodeExpire);
        if (((Boolean)resultMap.get("success")).booleanValue()) {
            String selectBaseDataFieldsForm = "adm_getverifycodeimg";
            OpenFormUtil.openDynamicPage((IFormView)this.getView(), (String)selectBaseDataFieldsForm, (ShowType)ShowType.Modal, null, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "verifycode"));
            return;
        }
        this.getView().showMessage(resultMap.get("msg").toString());
        evt.setCancel(true);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if ("verifycode".equals(closedCallBackEvent.getActionId())) {
            String number = this.getModel().getValue("number").toString();
            String tenantId = RequestContext.get().getTenantId();
            String key = tenantId + number;
            String value = (String)cache.get(key);
            if (StringUtils.isNotBlank((CharSequence)value)) {
                int time = Integer.parseInt(value);
                if (++time > 6) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u9891\u7e41\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"AdmRegisterPlugin_32", (String)"scm-adm-formplugin", (Object[])new Object[0]));
                } else {
                    cache.put(key, (Object)("" + time), 180);
                    Object returnData = closedCallBackEvent.getReturnData();
                    if (Objects.nonNull(returnData)) {
                        AdmCommonUtils.getMsg((AbstractFormPlugin)this, (IAppCache)this.verifyCodeExpire, (String)ResManager.loadKDString((String)"\u6ce8\u518c", (String)"AdmRegisterPlugin_33", (String)"scm-adm-formplugin", (Object[])new Object[0]));
                    }
                }
            }
        }
    }

    private boolean isRegisterPhoneBusy(String phone) {
        String tenantId = RequestContext.get().getTenantId();
        String key = tenantId + phone;
        String value = (String)cache.get(key);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            int time = Integer.parseInt(value);
            if (++time > 6) {
                return true;
            }
            cache.put(key, (Object)("" + time), 180);
        } else {
            cache.put(key, (Object)"1", 180);
        }
        return false;
    }

    private void delSpace() {
        Object numberobj;
        Object nameobj;
        Object creditnoobj;
        Object enterpriseobj = this.getModel().getValue("enterprise");
        if (enterpriseobj != null && StringUtils.isNotBlank((CharSequence)enterpriseobj.toString())) {
            this.getModel().setValue("enterprise", (Object)enterpriseobj.toString().replace(" ", ""));
        }
        if ((creditnoobj = this.getModel().getValue("creditno")) != null && StringUtils.isNotBlank((CharSequence)creditnoobj.toString())) {
            this.getModel().setValue("creditno", (Object)creditnoobj.toString().replace(" ", ""));
        }
        if ((nameobj = this.getModel().getValue("name")) != null && StringUtils.isNotBlank((CharSequence)nameobj.toString())) {
            this.getModel().setValue("name", (Object)nameobj.toString().replace(" ", ""));
        }
        if ((numberobj = this.getModel().getValue("number")) != null && StringUtils.isNotBlank((CharSequence)numberobj.toString())) {
            this.getModel().setValue("number", (Object)numberobj.toString().replace(" ", ""));
        }
        this.getView().updateView();
    }

    private void solPhoneValid() {
        String number = this.getModel().getValue("number").toString();
        if (StringUtils.isNotBlank((CharSequence)number)) {
            String[] split;
            int i;
            int charnum = 0;
            for (i = 0; i < number.length(); ++i) {
                if (number.charAt(i) != '-') continue;
                ++charnum;
            }
            if (charnum != 0 && (split = number.split("-", 2))[0].equals("86")) {
                number = number.substring(3);
                --charnum;
            }
            for (i = 0; i < charnum - 1; ++i) {
                int index = number.indexOf(45);
                number = number.substring(0, index) + number.substring(index + 1);
            }
            this.getModel().setValue("number", (Object)number);
            this.getView().updateView("number");
        }
    }

    private Map<String, Object> isPhone() {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String number = this.getModel().getValue("number").toString();
        resultMap.put("succed", Boolean.TRUE);
        try {
            number = this.getFullPhoneFormat(number);
            List<String> phoneList = Collections.singletonList(number);
            this.validatePhone(phoneList);
        }
        catch (KDBizException e) {
            resultMap.put("succed", Boolean.FALSE);
            resultMap.put("message", e.getMessage());
        }
        return resultMap;
    }

    private String getFullPhoneFormat(String phone) {
        if (!phone.startsWith("+")) {
            phone = phone.contains("-") ? "+" + phone : "+86-" + phone;
        }
        return phone;
    }

    private void validatePhone(List<String> phoneList) {
        List resultList = I18nServiceHelper.batchVerifyTelephoneNumber(phoneList);
        StringBuilder msg = new StringBuilder();
        for (TelephoneVerifyResult item : resultList) {
            Map result;
            String message;
            if (!item.isParseSuccess()) {
                throw new KDBizException(item.getParseErrorMsg());
            }
            if (item.isVerifySuccess() || !StringUtils.isNotBlank((CharSequence)(message = CollectionUtils.isEmpty((Map)(result = item.getVerifyResult())) ? "" : (String)result.get("message")))) continue;
            msg.append(ResManager.loadResFormat((String)ResManager.loadResFormat((String)"\u8d26\u53f7\uff1a%1", (String)"AdmRegisterPlugin_29", (String)"scm-adm-formplugin", (Object[])new Object[]{message}), (String)"AdmRegisterPlugin_29", (String)"scm-adm-formplugin", (Object[])new Object[0]));
            throw new KDBizException(msg.toString());
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        switch (operateKey = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "submit": {
                String name = this.getModel().getValue("name").toString();
                if (StringUtils.equals((CharSequence)"administrator", (CharSequence)name)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u6ce8\u518c\u7528\u6237\u540d\u4e3a\u201cadministrator\u201d\u7684\u7528\u6237\u3002", (String)"AdmRegisterPlugin_34", (String)"scm-adm-formplugin", (Object[])new Object[0]));
                    return;
                }
                StringBuilder sb = new StringBuilder();
                boolean isSucced = this.validateInfo(sb, true);
                if (!isSucced) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u6ce8\u518c\u8d44\u6599\u4e0d\u7b26\u5408\u8981\u6c42\uff0c\u8bf7\u67e5\u770b\u8be6\u60c5\uff1a", (String)"AdmRegisterPlugin_22", (String)"scm-adm-formplugin", (Object[])new Object[0]), sb.toString(), MessageTypes.Permission);
                    return;
                }
                String enterprise = this.getModel().getValue("enterprise").toString();
                String creditno = this.getModel().getValue("creditno").toString();
                String realcreditno = this.getCreditno(enterprise);
                DynamicObject obj = QueryServiceHelper.queryOne((String)"srm_declarationref", (String)"cfmstatus", (QFilter[])new QFilter[]{new QFilter("isdisplay", "=", (Object)"1")});
                String cfmstatus = "";
                if (Objects.nonNull(obj)) {
                    cfmstatus = obj.getString("cfmstatus");
                }
                if ("B".equals(cfmstatus) && StringUtils.isNotBlank((CharSequence)realcreditno) && !creditno.equals(realcreditno)) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u60a8\u8f93\u5165\u7684\u4f01\u4e1a\u540d\u79f0\u548c\u4fe1\u7528\u4ee3\u7801\u4fe1\u606f\u4e0d\u5339\u914d\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u63d0\u4ea4\u6ce8\u518c\u8d44\u6599\u7ed9\u91c7\u8d2d\u65b9\u5ba1\u6838\uff1f", (String)"AdmRegisterPlugin_35", (String)"scm-adm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("submitCallBackId"));
                    break;
                }
                this.submitAndLogin();
                break;
            }
        }
    }

    private boolean validateInfo(StringBuilder sb, boolean codeValidate) {
        IDataModel model = this.getModel();
        this.delSpace();
        String enterprise = model.getValue("enterprise").toString();
        String creditno = model.getValue("creditno").toString();
        String name = model.getValue("name").toString();
        String number = null;
        if (!model.getValue("number").toString().trim().isEmpty() && (number = model.getValue("number").toString()).contains("+86") && number.length() > 14) {
            number = number.substring(3, 14);
        }
        if (!(StringUtils.isBlank(number) || StringUtils.isEmail((String)number) || StringUtils.isPhoneNumberValid((String)number))) {
            this.solPhoneValid();
        }
        boolean isagreed = (Boolean)model.getValue("isagreed");
        boolean isSucced = true;
        if (name == null || name.trim().equals("")) {
            sb.append(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6b63\u786e\u7684\u59d3\u540d\u3002", (String)"AdmRegisterPlugin_12", (String)"scm-adm-formplugin", (Object[])new Object[0]));
            sb.append("\n");
            isSucced = false;
        }
        boolean supplierlifecycle = SupplierLifeCycleManagerUtil.isEnableSupplierLifeCycleManager();
        boolean hasUncompletedSrmAptitudeBill = SupplierLifeCycleManagerUtil.hasUncompletedSrmAptitudeBill((String)enterprise, (String)creditno);
        log.info("\u4f9b\u5e94\u5546\u95e8\u6237\u6ce8\u518c\u53c2\u6570@supplierlifecycle\uff1a" + supplierlifecycle + "@hasUncompletedSrmAptitudeBill" + hasUncompletedSrmAptitudeBill);
        boolean validEnterprise = true;
        boolean validCreditno = true;
        boolean validAccount = true;
        boolean validSkyeye = true;
        boolean isBlackEnterpirse = false;
        boolean isBlackCreditno = false;
        if (StringUtils.isNotBlank((CharSequence)enterprise) && SrmCommonUtil.isBlackEnterpirse((long)0L, null, (String)enterprise)) {
            isBlackEnterpirse = true;
        }
        if (StringUtils.isNotBlank((CharSequence)creditno) && SrmCommonUtil.isBlackEnterpirse((long)0L, (String)creditno, null)) {
            isBlackCreditno = true;
        }
        if (isBlackEnterpirse && isBlackCreditno) {
            isSucced = false;
            sb.append(ResManager.loadResFormat((String)"\u4f01\u4e1a\u540d\u79f0(%1)\u3001\u4fe1\u7528\u4ee3\u7801(%2) \u72b6\u6001\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u91c7\u8d2d\u65b9\u3002", (String)"AdmRegisterPlugin_13", (String)"scm-adm-formplugin", (Object[])new Object[]{enterprise, creditno}));
        } else if (isBlackEnterpirse) {
            isSucced = false;
            sb.append(ResManager.loadResFormat((String)"\u4f01\u4e1a\u540d\u79f0(%1) \u72b6\u6001\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u91c7\u8d2d\u65b9\u3002", (String)"AdmRegisterPlugin_4", (String)"scm-adm-formplugin", (Object[])new Object[]{enterprise}));
        } else if (isBlackCreditno) {
            isSucced = false;
            sb.append(ResManager.loadResFormat((String)"\u4fe1\u7528\u4ee3\u7801(%1) \u72b6\u6001\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u91c7\u8d2d\u65b9\u3002", (String)"AdmRegisterPlugin_8", (String)"scm-adm-formplugin", (Object[])new Object[]{creditno}));
        } else if (supplierlifecycle && !hasUncompletedSrmAptitudeBill) {
            validEnterprise = this.admRegistValid.validEnterprise(enterprise, creditno, sb, number, Boolean.valueOf(isSucced));
            validCreditno = this.admRegistValid.validCreditno(enterprise, creditno, sb, Boolean.valueOf(isSucced));
        } else {
            validEnterprise = this.admRegistValid.validEnterprise(enterprise, sb, number, Boolean.valueOf(isSucced));
            validCreditno = this.admRegistValid.validCreditno(creditno, sb, Boolean.valueOf(isSucced));
        }
        validAccount = this.admRegistValid.validNumber(number, sb, Boolean.valueOf(isSucced));
        validSkyeye = this.admRegistValid.validSkyEye(enterprise, creditno, sb, Boolean.valueOf(isSucced));
        if (!(validEnterprise && validCreditno && validAccount && validSkyeye)) {
            return false;
        }
        if (codeValidate && Objects.nonNull(number)) {
            String validate = this.getModel().getValue("validate").toString();
            String info = AdmCommonUtils.validateVerycode((String)((String)this.verifyCodeExpire.get(number, String.class)), (String)validate);
            if (StringUtils.isNotBlank((CharSequence)info)) {
                isSucced = false;
                sb.append(info);
            }
            if (!isagreed) {
                sb.append(ResManager.loadKDString((String)"\u5df2\u9605\u8bfb\u5e76\u540c\u610f\u534f\u8bae\u5fc5\u987b\u52fe\u9009\u3002\n", (String)"AdmRegisterPlugin_36", (String)"scm-adm-formplugin", (Object[])new Object[0]));
                isSucced = false;
            }
        }
        return isSucced;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("submitCallBackId".equals(callBackId) && messageBoxClosedEvent.getResult().compareTo((Enum)MessageBoxResult.Yes) == 0) {
            this.submitAndLogin();
        }
        if ("confirm".equals(callBackId)) {
            this.getView().close();
        }
    }

    private void submitAndLogin() {
        Object number = this.getModel().getValue("number");
        Map<String, Object> resultMap = this.submit();
        if (((Boolean)resultMap.get("succed")).booleanValue()) {
            DynamicObjectCollection query = QueryServiceHelper.query((String)"adm_supplierreg", (String)"id", (QFilter[])new QFilter[]{new QFilter("phone", "=", number)});
            if (!query.isEmpty()) {
                long id = ((DynamicObject)query.get(0)).getLong("id");
                BaseShowParameter bsp = new BaseShowParameter();
                bsp.setFormId("adm_supplierreg");
                bsp.setPkId((Object)id);
                bsp.setBillStatus(BillOperationStatus.EDIT);
                bsp.getOpenStyle().setShowType(ShowType.NewBrowserPage);
                this.getView().showForm((FormShowParameter)bsp);
            }
            this.getView().close();
            return;
        }
        this.getView().showMessage(ResManager.loadKDString((String)"\u6ce8\u518c\u8d44\u6599\u63d0\u4ea4\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u8be6\u60c5\uff1a", (String)"AdmRegisterPlugin_25", (String)"scm-adm-formplugin", (Object[])new Object[0]), resultMap.get("message").toString(), MessageTypes.Default);
    }

    private Map<String, Object> submit() {
        IDataModel model = this.getModel();
        String enterprise = model.getValue("enterprise").toString();
        String creditno = model.getValue("creditno").toString();
        String name = model.getValue("name").toString();
        String number = model.getValue("number").toString();
        HashMap<String, String> param = new HashMap<String, String>(4);
        param.put("number", number);
        param.put("enterprise", enterprise);
        param.put("creditno", creditno);
        param.put("name", name);
        Map resultMap = this.admRegistUserSubmitService.submit(param);
        return resultMap;
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "agreement": {
                QFilter qFilter = new QFilter("biztype", "=", (Object)"2");
                qFilter.and(new QFilter("status", "=", (Object)"1"));
                qFilter.and(new QFilter("billstatus", "=", (Object)"C"));
                DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"srm_srmhelp", (String)"id,necessaryreg", (QFilter[])new QFilter[]{qFilter});
                if (!CollectionUtils.isEmpty((Collection)dynamicObjects)) {
                    StringBuilder noticeIds = new StringBuilder(32);
                    for (DynamicObject dynamicObject : dynamicObjects) {
                        noticeIds.append(dynamicObject.get("id").toString()).append(",");
                    }
                    if (noticeIds.length() <= 0) break;
                    HashMap<String, StringBuilder> paramMap = new HashMap<String, StringBuilder>(2);
                    paramMap.put("noticeId", noticeIds);
                    OpenFormUtil.openBillPage((IFormView)this.getView(), (String)"srm_srmreg_query", null, (BillOperationStatus)BillOperationStatus.VIEW, (ShowType)ShowType.NewWindow, paramMap, null);
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ce8\u518c\u534f\u8bae\u672a\u53d1\u5e03\uff0c\u8bf7\u4e0e\u91c7\u8d2d\u65b9\u8054\u7cfb\u3002", (String)"AdmRegisterPlugin_26", (String)"scm-adm-formplugin", (Object[])new Object[0]));
            }
        }
    }
}

