/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.adm.formplugin.edit;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.adm.service.guest.GuestBaseDataUtil;

public class AdmGuestBaseDataHelper {
    private static final String KEY_ENTRYENTITY = "entryentity";
    private static final String SEARCHTEXT = "searchtext";
    private static final String SEARCHFIELDS = "searchfields";

    public void setEntryData(List<String> fieldKeyList, IFormView view, IDataModel model, int startIndex, int pageRows) {
        FormShowParameter parameter = view.getFormShowParameter();
        GuestBaseDataUtil.Result result = this.getGuestBaseDataResult(view, model, parameter, startIndex, pageRows);
        if (result == null) {
            return;
        }
        if (!result.getSuccess().booleanValue()) {
            String message = result.getMessage();
            if (Objects.nonNull(message)) {
                view.showMessage(message);
                return;
            }
            return;
        }
        DynamicObjectCollection dynamicObjectCollection = result.getDatas();
        if (dynamicObjectCollection == null) {
            return;
        }
        this.bindEntryDataEntities(fieldKeyList, view, model, dynamicObjectCollection, startIndex, pageRows, result.getRowcount());
    }

    public GuestBaseDataUtil.Result getGuestBaseDataResult(IFormView view, IDataModel model, FormShowParameter parameter, int startIndex, int pageRows) {
        Object guestbasedataid = parameter.getCustomParam("guestbasedataid");
        Object bill = parameter.getCustomParam("bill");
        if (Objects.isNull(bill) || Objects.isNull(guestbasedataid)) {
            return null;
        }
        if (view != null) {
            String searchtext = view.getPageCache().get(SEARCHTEXT);
            String searchfieldsStr = view.getPageCache().get(SEARCHFIELDS);
            if (StringUtils.isNotBlank((CharSequence)searchtext) && StringUtils.isNotBlank((CharSequence)searchfieldsStr)) {
                List<Map<String, Object>> searchfields = this.deSerializeSearchFields(searchfieldsStr);
                parameter.getCustomParams().put(SEARCHTEXT, searchtext);
                parameter.getCustomParams().put(SEARCHFIELDS, searchfields);
            } else {
                parameter.getCustomParams().put(SEARCHTEXT, null);
            }
        }
        Map customParams = parameter.getCustomParams();
        customParams.put("startrowindex", startIndex);
        customParams.put("pagerows", pageRows);
        return GuestBaseDataUtil.query((String)bill.toString(), (String)guestbasedataid.toString(), (Map)customParams);
    }

    private DynamicObject bindEntryDataEntities(List<String> fieldKeyList, IFormView view, IDataModel model, DynamicObjectCollection dynamicObjectCollection, int startIndex, int pageRows, int rowcount) {
        EntityType entityType = (EntityType)model.getDataEntityType().getAllEntities().get(KEY_ENTRYENTITY);
        int index = 0;
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObjectCollection entryEntities = dataEntity.getDynamicObjectCollection(KEY_ENTRYENTITY);
        HashMap<String, DynamicObject> baseDataBindMap = new HashMap<String, DynamicObject>(32);
        entryEntities.clear();
        for (DynamicObject dyo : dynamicObjectCollection) {
            DynamicObject rowObj = entryEntities.addNew();
            rowObj.set("seq", (Object)index);
            for (String fieldKey : fieldKeyList) {
                if (entityType.getProperty(fieldKey) instanceof BasedataProp) {
                    DynamicObject dynamicObject;
                    String id = dyo.getString(fieldKey.split("_", 2)[1]);
                    if (!StringUtils.isNotBlank((CharSequence)id)) continue;
                    if (baseDataBindMap.get(id) == null) {
                        dynamicObject = this.getDynamicObject(entityType, fieldKey);
                        DynamicObject query = this.queryDynamicObject(((BasedataProp)entityType.getProperty(fieldKey)).getBaseEntityId(), id);
                        if (query != null) {
                            dynamicObject.set("name", (Object)query.getString("name"));
                            dynamicObject.set("id", (Object)query.getString("id"));
                        }
                        baseDataBindMap.put(id, dynamicObject);
                    } else {
                        dynamicObject = (DynamicObject)baseDataBindMap.get(id);
                    }
                    rowObj.set(fieldKey, (Object)dynamicObject);
                    continue;
                }
                rowObj.set(fieldKey, (Object)dyo.getString(fieldKey.split("_", 2)[1]));
            }
            ++index;
        }
        dataEntity.getDataEntityState().setEntryRowCount(KEY_ENTRYENTITY, rowcount);
        dataEntity.getDataEntityState().setEntryStartRowIndex(KEY_ENTRYENTITY, startIndex);
        dataEntity.getDataEntityState().setEntryPageSize(KEY_ENTRYENTITY, pageRows);
        return dataEntity;
    }

    private DynamicObject getDynamicObject(EntityType entityType, String fieldKey) {
        return ORM.create().newDynamicObject(((BasedataProp)entityType.getProperty(fieldKey)).getBaseEntityId());
    }

    private DynamicObject queryDynamicObject(String billno, String id) {
        return QueryServiceHelper.queryOne((String)billno, (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(id))});
    }

    private List<Map<String, Object>> deSerializeSearchFields(String fieldsStr) {
        if (StringUtils.isBlank((CharSequence)fieldsStr)) {
            return null;
        }
        return (List)SerializationUtils.fromJsonString((String)fieldsStr, ArrayList.class);
    }
}

