/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.adm.formplugin.edit;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.scm.common.enums.ConfirmStatusEnum;
import kd.scm.common.enums.SrmScoreStatusEnum;
import kd.scm.common.plugin.AbstractAdmBillPlugIn;
import kd.scm.common.util.OpenFormUtil;
import kd.scm.common.util.SrmCommonUtil;

public class AdmScorerptEdit
extends AbstractAdmBillPlugIn {
    private static final String INDEXCLASSENTRY = "indexclassentry";
    private static final String INDEXTYPEENTRY = "indextypeentry";
    private static final String INDEX_INDEXTYPE = "index.indextype";
    private static final String INDEX_INDEXCLASS = "index.indexclass";
    private static final String IDX_INDEXTYPE = "idxtype_detail";
    private static final String INDEXCLASS_SUMSCORE = "indexclass_sumscore";
    private static final String INDEXTYPE_SUMSCORE = "indextype_sumscore";

    public void afterLoadData(EventObject e) {
        this.bulidIndexClassEntry("indexclass_detail", "indexclass_finalscore");
        this.bulidIndexTypeEntry();
        this.sortIndexClassEntry();
    }

    private void sortIndexClassEntry() {
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getDataEntity(true).getDynamicObjectCollection(INDEXCLASSENTRY);
        dynamicObjectCollection.sort((x, y) -> x.getString("idxtype_detail.number").compareTo(y.getString("idxtype_detail.number")));
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        SrmCommonUtil.setScoreRptTabStatus((IFormView)this.getView(), (IDataModel)this.getModel());
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((AbstractOperate)args.getSource()).getOperateKey();
        if (operateKey.equals("myconfirm")) {
            long billId = (Long)this.getModel().getDataEntity().getPkValue();
            if (billId == 0L) {
                args.setCancel(true);
                return;
            }
            String bizStatus = this.getModel().getDataEntity().getString("bizstatus");
            String cfmStatus = this.getModel().getDataEntity().getString("cfmstatus");
            if (!bizStatus.equals(SrmScoreStatusEnum.TRIALED.getValue()) || !cfmStatus.equals(ConfirmStatusEnum.UNCONFIRM.getVal())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709 \u521d\u5ba1\u901a\u8fc7 \u4e14 \u672a\u53cd\u9988 \u7684\u8bc4\u4f30\u62a5\u544a\u624d\u80fd\u8fdb\u884c\u53cd\u9988\u3002", (String)"AdmScorerptEdit_0", (String)"scm-adm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("myconfirm".equals(operateKey) && Objects.nonNull(operationResult) && operationResult.isSuccess()) {
            long billId = (Long)this.getModel().getDataEntity().getPkValue();
            MutexHelper.require((String)"adm_score", (Object)billId, (String)"myconfirm", (boolean)true, (StringBuilder)new StringBuilder(16));
            OpenFormUtil.openBillPage((IFormView)this.getView(), (String)"adm_scorecfm", (Object)billId, (BillOperationStatus)BillOperationStatus.EDIT, (ShowType)ShowType.Modal, null, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "callbackid"));
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getActionId().equals("callbackid")) {
            this.getView().invokeOperation("refresh");
            SrmCommonUtil.setScoreRptTabStatus((IFormView)this.getView(), (IDataModel)this.getModel());
            long billId = (Long)this.getModel().getDataEntity().getPkValue();
            MutexHelper.release((String)"adm_score", (String)"myconfirm", (String)String.valueOf(billId));
        }
    }

    private void bulidIndexClassEntry(String detailId, String finalscoreId) {
        DynamicObjectCollection indexCollection = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        DynamicObjectCollection indexClassCollection = this.getModel().getDataEntity(true).getDynamicObjectCollection(INDEXCLASSENTRY);
        Map<DynamicObject, List<DynamicObject>> groupByIndexClass = indexCollection.stream().collect(Collectors.groupingBy(x -> x.getDynamicObject(INDEX_INDEXCLASS)));
        if (Objects.isNull(groupByIndexClass)) {
            return;
        }
        Set<DynamicObject> classDy = groupByIndexClass.keySet();
        Set clssIds = classDy.stream().map(x -> x.getPkValue()).collect(Collectors.toSet());
        DynamicObjectCollection classDb = QueryServiceHelper.query((String)"srm_indexclass", (String)"id,lowestscore", (QFilter[])new QFilter[]{new QFilter("id", "in", clssIds)});
        if (CollectionUtils.isEmpty((Collection)classDb)) {
            return;
        }
        Set<Map.Entry<DynamicObject, List<DynamicObject>>> entries = groupByIndexClass.entrySet();
        for (Map.Entry<DynamicObject, List<DynamicObject>> entry : entries) {
            DynamicObject dynamicObject = indexClassCollection.addNew();
            DynamicObject classDyKey = entry.getKey();
            dynamicObject.set(detailId, (Object)classDyKey);
            List<DynamicObject> entryentityValue = entry.getValue();
            BigDecimal sunValue = new BigDecimal(0);
            BigDecimal finalValue = new BigDecimal(0);
            Boolean isclassTypeVeto = false;
            for (DynamicObject value : entryentityValue) {
                BigDecimal finaScore = value.getBigDecimal("finalscore");
                String veto = value.getString("veto");
                sunValue = sunValue.add(finaScore);
                if (!"2".equals(veto)) continue;
                isclassTypeVeto = true;
            }
            Boolean isLowestscore = false;
            for (DynamicObject classDbType : classDb) {
                String lowestscore;
                if (!classDyKey.getPkValue().equals(classDbType.get("id")) || StringUtils.isEmpty((String)(lowestscore = classDbType.getString("lowestscore"))) || !"2".equals(lowestscore)) continue;
                isLowestscore = true;
            }
            finalValue = isclassTypeVeto != false ? new BigDecimal(0) : (sunValue.compareTo(new BigDecimal(0)) < 0 && isLowestscore != false ? new BigDecimal(0) : sunValue);
            dynamicObject.set(finalscoreId, (Object)sunValue);
            dynamicObject.set(INDEXCLASS_SUMSCORE, (Object)finalValue);
            dynamicObject.set(IDX_INDEXTYPE, (Object)entryentityValue.get(0).getDynamicObject(INDEX_INDEXTYPE));
        }
    }

    private void bulidIndexTypeEntry() {
        DynamicObjectCollection indexCollection = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        DynamicObjectCollection indexTypeCollection = this.getModel().getDataEntity(true).getDynamicObjectCollection(INDEXTYPEENTRY);
        DynamicObjectCollection indexClassCollection = this.getModel().getDataEntity(true).getDynamicObjectCollection(INDEXCLASSENTRY);
        Map<DynamicObject, List<DynamicObject>> indexClolleGroupByIndexType = indexCollection.stream().collect(Collectors.groupingBy(x -> x.getDynamicObject(INDEX_INDEXTYPE)));
        if (Objects.isNull(indexClolleGroupByIndexType)) {
            return;
        }
        Set<DynamicObject> classDy = indexClolleGroupByIndexType.keySet();
        Set clssIds = classDy.stream().map(x -> x.getPkValue()).collect(Collectors.toSet());
        DynamicObjectCollection classDb = QueryServiceHelper.query((String)"srm_indexclass", (String)"id,lowestscore", (QFilter[])new QFilter[]{new QFilter("id", "in", clssIds)});
        if (CollectionUtils.isEmpty((Collection)classDb)) {
            return;
        }
        Map<Object, List<DynamicObject>> classTypeMap = classDb.stream().collect(Collectors.groupingBy(x -> x.get("id")));
        if (CollectionUtils.isEmpty((Collection)indexClassCollection) || CollectionUtils.isEmpty(classTypeMap)) {
            return;
        }
        Map<DynamicObject, List<DynamicObject>> indexClassMapType = indexClassCollection.stream().collect(Collectors.groupingBy(x -> x.getDynamicObject(IDX_INDEXTYPE)));
        Set<Map.Entry<DynamicObject, List<DynamicObject>>> entries = indexClassMapType.entrySet();
        List vetos = indexCollection.stream().filter(x -> "4".equals(x.getString("veto"))).collect(Collectors.toList());
        Boolean isVeto = false;
        if (!CollectionUtils.isEmpty(vetos)) {
            isVeto = true;
        }
        for (Map.Entry<DynamicObject, List<DynamicObject>> entry : entries) {
            String lowestscore;
            DynamicObject dynamicObject = indexTypeCollection.addNew();
            DynamicObject indexType = entry.getKey();
            List<DynamicObject> indexClassList = entry.getValue();
            BigDecimal sunValue = new BigDecimal(0);
            BigDecimal sunClassValue = new BigDecimal(0);
            BigDecimal finalValue = new BigDecimal(0);
            Boolean isclassTypeVeto = false;
            Boolean isLowestscore = false;
            List<DynamicObject> indexCollectionsGroup = indexClolleGroupByIndexType.get(indexType);
            for (DynamicObject index : indexCollectionsGroup) {
                String veto = index.getString("veto");
                if (!"1".equals(veto)) continue;
                isclassTypeVeto = true;
            }
            for (DynamicObject indexClass : indexClassList) {
                sunValue = sunValue.add(indexClass.getBigDecimal("indexclass_finalscore"));
                sunClassValue = sunClassValue.add(indexClass.getBigDecimal(INDEXCLASS_SUMSCORE));
            }
            List<DynamicObject> classType = classTypeMap.get(indexType.getPkValue());
            if (!CollectionUtils.isEmpty(classType) && !StringUtils.isEmpty((String)(lowestscore = classType.get(0).getString("lowestscore"))) && "2".equals(lowestscore)) {
                isLowestscore = true;
            }
            finalValue = isclassTypeVeto != false || isVeto != false ? new BigDecimal(0) : (sunClassValue.compareTo(new BigDecimal(0)) < 0 && isLowestscore != false ? new BigDecimal(0) : sunClassValue);
            dynamicObject.set("indextype_finalscore", (Object)sunValue);
            dynamicObject.set("indextype_detail", (Object)indexType);
            dynamicObject.set(INDEXTYPE_SUMSCORE, (Object)finalValue);
        }
    }
}

