/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.adm.formplugin.edit;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.ORM;

public class AdmSelectBaseDataFieldsPlugin
extends AbstractFormPlugin {
    private static final String SELECT_FIELD = "selects";
    private static final String BT_OK = "btnok";
    private static final String BASEDATA_KEY = "basedatakey";
    private static final String BASEDATA_NAME = "basedataname";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button bt = (Button)this.getControl(BT_OK);
        bt.addClickListener((ClickListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        ComboEdit comboEdit = (ComboEdit)this.getControl(SELECT_FIELD);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object sourcebasedatakey = customParams.get("sourcebasedatano");
        Object basedatakey = customParams.get("guestbasedatano");
        Object selects = customParams.get(SELECT_FIELD);
        this.getModel().setValue(BASEDATA_KEY, basedatakey);
        if (Objects.isNull(sourcebasedatakey)) {
            return;
        }
        ArrayList<ComboItem> data = new ArrayList<ComboItem>();
        String sourcebasedatakeystr = sourcebasedatakey.toString();
        if (StringUtils.isBlank((CharSequence)sourcebasedatakeystr)) {
            return;
        }
        if (!Objects.isNull(selects)) {
            this.getModel().setValue(SELECT_FIELD, (Object)selects.toString());
        }
        DynamicObject baseEntity = ORM.create().newDynamicObject(sourcebasedatakeystr);
        this.getModel().setValue(BASEDATA_NAME, (Object)baseEntity.getDynamicObjectType().getDisplayName());
        DataEntityPropertyCollection baseDataProperties = baseEntity.getDynamicObjectType().getProperties();
        for (IDataEntityProperty baseDataProperty : baseDataProperties) {
            if (this.isBaseDataIdProperty(baseDataProperty.getName()) || "id".equals(baseDataProperty.getName())) continue;
            data.add(new ComboItem(new LocaleString(baseDataProperty.getName()), baseDataProperty.getName()));
        }
        comboEdit.setComboItems(data);
    }

    private boolean isBaseDataIdProperty(String propertyName) {
        int lastIndex;
        String propertyNameSuffix;
        return propertyName.length() > 3 && (propertyNameSuffix = propertyName.substring((lastIndex = propertyName.length()) - 3, lastIndex)).equals("_id");
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control bt = (Control)evt.getSource();
        String key = bt.getKey();
        if (key.equals(BT_OK)) {
            Object selectsobj = this.getModel().getValue(SELECT_FIELD);
            if (!Objects.isNull(selectsobj)) {
                String selects = selectsobj.toString();
                if (StringUtils.isNotBlank((CharSequence)selects) && selects.charAt(0) == ',') {
                    selects = selects.substring(1);
                }
                if (StringUtils.isNotBlank((CharSequence)selects) && selects.charAt(selects.length() - 1) == ',') {
                    selects = selects.substring(0, selects.length() - 1);
                }
                this.getView().returnDataToParent((Object)selects);
                this.getView().close();
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u5b57\u6bb5\u3002", (String)"AdmSelectBaseDataFieldsPlugin_1", (String)"scm-adm-formplugin", (Object[])new Object[0]));
            }
        }
    }
}

