/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.adm.formplugin.edit;

import java.net.URLDecoder;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleDynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Image;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.util.LoginMCServiceUtil;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.url.UrlService;
import kd.scm.adm.common.BusinessRulesServiceUtils;
import kd.scm.adm.formplugin.edit.AdmGuestOpenBaseDataSuperPlugin;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.enums.SrmSupplierStatusEnum;
import kd.scm.common.util.AESUtil;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.common.util.SrmCommonValidator;

public class AdmSupplierRegEdit
extends AdmGuestOpenBaseDataSuperPlugin {
    private static Log log = LogFactory.getLog(AdmSupplierRegEdit.class);

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key = evt.getItemKey();
        if (StringUtils.isEmpty((CharSequence)key)) {
            return;
        }
        switch (key) {
            case "bar_save": 
            case "bar_submit": {
                this.ifDelete();
            }
        }
    }

    @Override
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    private void setFormData() {
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String operateKey;
        super.beforeDoOperation(e);
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        DynamicObject dynamicObject = model.getDataEntity();
        switch (operateKey = ((AbstractOperate)e.getSource()).getOperateKey()) {
            case "withdraw": {
                DynamicObject queryData = QueryServiceHelper.queryOne((String)"srm_supplierreg", (String)"auditstatus, status", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)dynamicObject.getLong("id"))});
                if (queryData == null || SrmSupplierStatusEnum.SUBMIT.getValue().equals(queryData.getString("auditstatus"))) break;
                e.setCancel(true);
                view.showErrorNotification(ResManager.loadKDString((String)"\u5ba1\u6279\u72b6\u6001\u4e3a\u63d0\u4ea4\u5ba1\u6279\u624d\u80fd\u64a4\u56de\u3002", (String)"AdmSupplierRegEdit_2", (String)"scm-adm-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        DynamicObject dynamicObject = model.getDataEntity();
        Long id = dynamicObject.getLong("id");
        switch (operateKey) {
            case "submit": {
                this.resetStatus();
                OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
                if (!operationResult.isSuccess()) break;
                this.openRegisterStatusForm();
                break;
            }
            case "withdraw": {
                if (!afterDoOperationEventArgs.getOperationResult().isSuccess()) break;
                boolean inProcess = WorkflowServiceHelper.inProcess((String)id.toString());
                if (inProcess) {
                    try {
                        DynamicObject srm_supplier = BusinessDataServiceHelper.loadSingle((Object)id, (String)"srm_supplierreg");
                        WorkflowServiceHelper.withdraw((DynamicObject)srm_supplier);
                    }
                    catch (Exception e) {
                        view.showErrorNotification(ResManager.loadKDString((String)"\u91c7\u8d2d\u65b9\u5df2\u6709\u5ba1\u6279\u8bb0\u5f55\uff0c\u65e0\u6cd5\u64a4\u56de\u3002", (String)"AdmSupplierRegEdit_1", (String)"scm-adm-formplugin", (Object[])new Object[0]));
                        log.error("\u91c7\u8d2d\u65b9\u5df2\u6709\u5ba1\u6279\u8bb0\u5f55\uff0c\u65e0\u6cd5\u64a4\u56de\u3002" + e.getMessage());
                        return;
                    }
                }
                model.setDataChanged(false);
                model.setValue("auditstatus", (Object)SrmSupplierStatusEnum.INITIAL);
                model.setValue("status", (Object)"A");
                DynamicObject obj = model.getDataEntity();
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
                this.resetStatus();
                view.showSuccessNotification(ResManager.loadKDString((String)"\u64a4\u56de\u6210\u529f", (String)"AdmSupplierRegEdit_3", (String)"scm-adm-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    private void openRegisterStatusForm() {
        Object registerstatusform = this.getView().getFormShowParameter().getCustomParams().get("registerstatusform");
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        Map resultMap = SrmCommonValidator.supRegValidator((ExtendedDataEntity)new ExtendedDataEntity(dataEntity, 0, 0));
        Map aptitudeResultMap = SrmCommonValidator.aptitudeMustInputValidate((ExtendedDataEntity)new ExtendedDataEntity(dataEntity, 0, 0));
        if (registerstatusform == null && ((Boolean)resultMap.get("succed")).booleanValue() && ((Boolean)aptitudeResultMap.get("succed")).booleanValue()) {
            long id = Long.parseLong(this.getModel().getDataEntity().getPkValue().toString());
            BaseShowParameter bsp = new BaseShowParameter();
            bsp.setFormId("adm_registerstatus");
            bsp.setPkId((Object)id);
            bsp.setBillStatus(BillOperationStatus.EDIT);
            bsp.getOpenStyle().setShowType(ShowType.NewBrowserPage);
            this.getView().showForm((FormShowParameter)bsp);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("confirmActionId".equals(callBackId) && messageBoxClosedEvent.getResult().compareTo((Enum)MessageBoxResult.Yes) == 0) {
            this.getView().showForm(BillFormUtil.assembleShowDynamicFormParam((String)"srm_portal", null, null, (ShowType)ShowType.Modal));
        } else if (callBackId.equals("mailValidityConfirm") || callBackId.equals("idNullConfirm")) {
            this.getView().close();
        }
    }

    public void afterCreateNewData(EventObject e) {
    }

    public String decrypt(String value) {
        String decryptValue = null;
        try {
            decryptValue = AESUtil.decryptToStringNew((String)value);
        }
        catch (Exception e1) {
            log.error("decrypt value is fail value :" + value + " next to decode" + e1.getMessage());
            try {
                String decode = URLDecoder.decode(value, "UTF-8");
                decryptValue = AESUtil.decryptToStringNew((String)decode);
            }
            catch (Exception e2) {
                log.error("decode value is fail value :" + value + e2.getMessage());
            }
        }
        return decryptValue;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.resetStatus();
        this.ifDelete();
        this.setLogo();
    }

    private void setLogo() {
        try {
            String value = LoginMCServiceUtil.getMcData((String)"_tenant_login_config_values_");
            if (StringUtils.isNotEmpty((CharSequence)value)) {
                HashMap resultMap = (HashMap)SerializationUtils.fromJsonString((String)value, HashMap.class);
                if (resultMap == null) {
                    return;
                }
                FileService imageFileService = FileServiceFactory.getImageFileService();
                String realPath = imageFileService.getRealPath((String)resultMap.get("lefttoplogoimg"));
                if (StringUtils.isNotBlank((CharSequence)realPath)) {
                    realPath = UrlService.getImageFullUrl((String)String.valueOf(realPath));
                    Image imageap = (Image)this.getControl("imageap");
                    if (imageap != null) {
                        imageap.setUrl(realPath);
                    }
                }
            }
        }
        catch (Exception e) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8c03\u7528\u79df\u6237\u7ba1\u7406\u4e2d\u5fc3\u5931\u8d25\uff0c\u65e0\u6709\u6548\u6570\u636e\u3002", (String)"AdmSupplierRegEdit_6", (String)"scm-adm-formplugin", (Object[])new Object[0]));
            log.error("\u8c03\u7528\u79df\u6237\u7ba1\u7406\u4e2d\u5fc3\u5931\u8d25\uff0c\u65e0\u6709\u6548\u6570\u636e" + e.getMessage());
        }
    }

    public void ifDelete() {
        String id = this.getModel().getDataEntity().getString("id");
        Object id1 = this.getView().getFormShowParameter().getCustomParams().get("id");
        if (id != null && !id.trim().equals("")) {
            Long pkid = Long.valueOf(id);
            DynamicObject regsupObj = QueryServiceHelper.queryOne((String)"srm_supplierreg", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)pkid)});
            if (regsupObj == null && id1 != null) {
                String s = id1.toString();
                String decryptid = this.decrypt(s);
                if (StringUtils.isNumeric((CharSequence)decryptid)) {
                    pkid = Long.valueOf(decryptid);
                    regsupObj = QueryServiceHelper.queryOne((String)"srm_supplierreg", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)pkid)});
                } else if (StringUtils.isNumeric((CharSequence)s)) {
                    regsupObj = QueryServiceHelper.queryOne((String)"srm_supplierreg", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(s))});
                }
            }
            String billName = this.getModel().getDataEntity().getDynamicObjectType().getName();
            if (regsupObj == null && !"adm_companyinfo_register".equals(billName)) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff0c\u662f\u5426\u91cd\u65b0\u767b\u5f55?", (String)"AdmSupplierRegEdit_0", (String)"scm-adm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("confirmActionId"));
                return;
            }
        }
    }

    public void resetStatus() {
        this.getModel().setDataChanged(false);
        DynamicObject obj = this.getModel().getDataEntity();
        String status = obj.getString("status");
        String bizStatus = obj.getString("auditstatus");
        if (bizStatus == null) {
            return;
        }
        BillFormUtil.activeTab((IFormView)this.getView(), (String)"status_tabap", (String)(bizStatus.toLowerCase() + "tab"));
        boolean visible = status.equalsIgnoreCase(BillStatusEnum.SAVE.getVal());
        this.getView().setVisible(Boolean.valueOf(visible), new String[]{"bar_save"});
        this.getView().setVisible(Boolean.valueOf(visible), new String[]{"bar_submit"});
        this.getView().setVisible(Boolean.valueOf(!visible), new String[]{"bar_unsubmit"});
        this.getView().setEnable(Boolean.valueOf(visible), new String[]{"attachmentpanel1"});
    }

    public void propertyChanged(PropertyChangedArgs arg0) {
        String propertyName;
        super.propertyChanged(arg0);
        switch (propertyName = arg0.getProperty().getName()) {
            case "org": {
                DynamicObject orgObj = (DynamicObject)arg0.getChangeSet()[0].getNewValue();
                if (orgObj == null) {
                    return;
                }
                Object oldOrgValue = arg0.getChangeSet()[0].getOldValue();
                this.input(this.getView(), this.getModel(), propertyName, oldOrgValue);
                this.getModel().setValue("createorg", (Object)orgObj);
                this.getModel().setValue("useorg", (Object)orgObj);
                this.getView().updateView("createorg");
                this.getView().updateView("useorg");
                break;
            }
            case "name": {
                String replaceStr;
                LocaleDynamicObjectCollection localeDyns = (LocaleDynamicObjectCollection)arg0.getChangeSet()[0].getNewValue();
                if (localeDyns.isEmpty()) break;
                String newName = ((DynamicObject)localeDyns.get(0)).getString("name");
                if (!newName.equals(replaceStr = newName.replaceAll("\\s", ""))) {
                    this.setValue(propertyName, replaceStr);
                    break;
                }
                boolean exists = this.isExists(propertyName);
                if (!exists) {
                    Object oldNameValue = arg0.getChangeSet()[0].getOldValue();
                    this.input(this.getView(), this.getModel(), propertyName, oldNameValue);
                }
                this.showRepeatTips(propertyName, exists);
                break;
            }
            case "simplename": {
                String replaceStr;
                String newName;
                LocaleDynamicObjectCollection localeDyns = (LocaleDynamicObjectCollection)arg0.getChangeSet()[0].getNewValue();
                if (localeDyns.isEmpty() || (newName = ((DynamicObject)localeDyns.get(0)).getString("simplename")).equals(replaceStr = newName.replaceAll("\\s", ""))) break;
                this.setValue(propertyName, replaceStr);
                break;
            }
            case "societycreditcode": {
                String newCode = (String)arg0.getChangeSet()[0].getNewValue();
                String replaceStr = newCode.replaceAll("\\s", "");
                if (!newCode.equals(replaceStr)) {
                    this.setValue(propertyName, replaceStr);
                    break;
                }
                boolean exists = this.isExists(propertyName);
                this.showRepeatTips(propertyName, exists);
                break;
            }
        }
    }

    private void setValue(String propertyName, String replaceStr) {
        this.getModel().setValue(propertyName, (Object)replaceStr);
        this.getView().updateView(propertyName);
    }

    private boolean isExists(String propertyName) {
        Object value = this.getModel().getValue(propertyName);
        if (value != null && !StringUtils.isEmpty((CharSequence)value.toString())) {
            Object id = this.getModel().getDataEntity().getPkValue();
            boolean exists = QueryServiceHelper.exists((String)"adm_supplierreg", (QFilter[])new QFilter[]{new QFilter(propertyName, "=", (Object)value.toString()).and("id", "!=", id)});
            return exists;
        }
        return false;
    }

    private void showRepeatTips(String propertyName, Boolean exists) {
        if (exists.booleanValue()) {
            IDataEntityProperty property = (IDataEntityProperty)this.getModel().getDataEntity(true).getDynamicObjectType().getProperties().get((Object)propertyName);
            Object value = this.getModel().getValue(propertyName);
            LocaleString displayName = property.getDisplayName();
            StringBuilder msg = new StringBuilder();
            msg.append(displayName.toString());
            msg.append(value);
            msg.append(ResManager.loadKDString((String)"\u5df2\u6ce8\u518c\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u6ce8\u518c\u3002", (String)"AdmSupplierRegEdit_7", (String)"scm-adm-formplugin", (Object[])new Object[0]));
            this.getView().showTipNotification(msg.toString());
        }
    }

    private void input(IFormView view, IDataModel model, String propertyName, Object oldNameValue) {
        try {
            BusinessRulesServiceUtils.input((IFormView)view, (IDataModel)model, (String)propertyName, (Object)oldNameValue);
        }
        catch (Exception e1) {
            log.error("\u52a0\u8f7d\u4f9b\u5e94\u5546\u6570\u636e\u5f02\u5e38", (Throwable)e1);
            this.getView().showTipNotification(ExceptionUtil.wrapExceptionErrorInfo((Throwable)e1));
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent var1) {
        String key;
        super.beforeF7Select(var1);
        switch (key = var1.getProperty().getName()) {
            case "org": {
                Map resultMap = SrmCommonUtil.getAuditOrgFilter((IDataModel)this.getModel());
                if (((Boolean)resultMap.get("succed")).booleanValue()) {
                    ListShowParameter showParameter = (ListShowParameter)var1.getFormShowParameter();
                    showParameter.getListFilterParameter().setFilter((QFilter)resultMap.get("message"));
                    break;
                }
                this.getView().showTipNotification(resultMap.get("message").toString());
                var1.setCancel(true);
                break;
            }
            case "invoicetypeid": {
                DynamicObjectCollection query = QueryServiceHelper.query((String)"bd_invoicetype", (String)"id,number,name,bd_applicationfield", (QFilter[])new QFilter[]{new QFilter("bd_applicationfield.fbasedataId.number", "=", (Object)"PUR")});
                List ids = query.stream().map(x -> x.getLong("id")).collect(Collectors.toList());
                ListShowParameter showParameter = (ListShowParameter)var1.getFormShowParameter();
                showParameter.getListFilterParameter().setFilter(new QFilter("bd_applicationfield", "in", ids));
                break;
            }
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        FormShowParameter formShowParameter = e.getFormShowParameter();
        if (formShowParameter instanceof BaseShowParameter) {
            Map param;
            Object pkId = formShowParameter.getCustomParams().get("id");
            if (Objects.isNull(pkId)) {
                pkId = ((BaseShowParameter)formShowParameter).getPkId();
            }
            boolean hasId = false;
            if (!Objects.isNull(pkId)) {
                String decryptId = this.decrypt(pkId.toString());
                BaseShowParameter baseShowParameter = (BaseShowParameter)formShowParameter;
                if (StringUtils.isNumeric((CharSequence)decryptId) && (hasId = QueryServiceHelper.exists((String)"adm_supplierreg", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(decryptId))}))) {
                    baseShowParameter.setPkId((Object)decryptId);
                }
                if (!hasId && StringUtils.isNumeric((CharSequence)pkId.toString()) && (hasId = QueryServiceHelper.exists((String)"adm_supplierreg", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(pkId.toString()))}))) {
                    baseShowParameter.setPkId(pkId);
                }
                baseShowParameter.setBillStatus(BillOperationStatus.EDIT);
                if (!hasId) {
                    e.setCancel(true);
                    e.setCancelMessage(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\u3002", (String)"AdmSupplierRegEdit_8", (String)"scm-adm-formplugin", (Object[])new Object[0]));
                }
            }
            if ((param = e.getFormShowParameter().getShowParameter().getCustomParams()).get("mailvalidity") != null && !this.mailValidity(param)) {
                e.setCancel(true);
                e.setCancelMessage(ResManager.loadKDString((String)"\u90ae\u4ef6\u94fe\u63a5\u5df2\u5931\u6548\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u6709\u6700\u65b0\u90ae\u4ef6\uff0c\u6216\u8054\u7cfb\u91c7\u8d2d\u65b9\u8fdb\u884cRFI\u90ae\u4ef6\u91cd\u53d1\u3002", (String)"AdmSupplierRegEdit_9", (String)"scm-adm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private boolean mailValidity(Map<String, Object> param) {
        Object numberParam = param.get("number");
        if (Objects.isNull(numberParam)) {
            return false;
        }
        String number = this.decrypt(numberParam.toString());
        if (Objects.isNull(number)) {
            return false;
        }
        boolean isExist = QueryServiceHelper.exists((String)"srm_issuerfi", (QFilter[])new QFilter[]{new QFilter("email", "=", (Object)number)});
        if (isExist) {
            Object mailvalidity = param.get("mailvalidity");
            if (Objects.nonNull(mailvalidity)) {
                String urlmailvalidity = this.decrypt(mailvalidity.toString());
                if (!TimeServiceHelper.now().before(DateUtil.string2date((String)urlmailvalidity, (String)"yyyy-MM-dd HH:mm:ss"))) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }
}

