/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.adm.formplugin.list;

import java.util.List;
import java.util.Objects;
import kd.bos.bill.BillOperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.enums.SrmExamineConfirmStatusEnum;
import kd.scm.common.plugin.AbstractAdmListPlugin;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.common.util.OpenFormUtil;
import kd.scm.common.util.QueryRecordUtil;
import kd.scm.common.util.SrmCommonUtil;

public class AdmExamineList
extends AbstractAdmListPlugin {
    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List qFilterList = e.getQFilters();
        List supIdList = BizPartnerUtil.getSupplierByUserOfBizPartner();
        qFilterList.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal()).or(new QFilter("billstatus", "=", (Object)BillStatusEnum.CANCELED.getVal())).and(new QFilter("supplier", "in", (Object)supIdList)));
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key = evt.getItemKey();
        if (StringUtils.equals((CharSequence)"tblconfirm", (CharSequence)key)) {
            long billId = SrmCommonUtil.getBillSelectedId((IFormView)this.getView(), (BillList)((BillList)this.getView().getControl("billlistap")));
            if (billId == 0L) {
                evt.setCancel(true);
                return;
            }
            DynamicObject obj = QueryRecordUtil.queryRecordSet((String)"adm_examine", (String)"id", (String)"id", (Object)billId, (String)"confirmstatus", (Object)SrmExamineConfirmStatusEnum.TODO.getVal(), null, null, null, null, null, (String)"queryOne", null);
            if (obj == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5355\u636e\u5df2\u53cd\u9988\uff0c\u4e0d\u80fd\u518d\u6b21\u53cd\u9988\u3002", (String)"AdmExamineList_0", (String)"scm-adm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (Objects.nonNull(operationResult) && operationResult.isSuccess() && "myconfirm".equals(operateKey)) {
            long billId = SrmCommonUtil.getBillSelectedId((IFormView)this.getView(), (BillList)((BillList)this.getView().getControl("billlistap")));
            MutexHelper.require((String)"adm_examine", (Object)billId, (String)"myconfirm", (boolean)true, (StringBuilder)new StringBuilder(16));
            OpenFormUtil.openBillPage((IFormView)this.getView(), (String)"adm_examinecfm", (Object)SrmCommonUtil.getBillSelectedId((IFormView)this.getView(), (BillList)((BillList)this.getView().getControl("billlistap"))), (BillOperationStatus)BillOperationStatus.EDIT, (ShowType)ShowType.Modal, null, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "callbackid"));
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getActionId().equals("callbackid")) {
            long billId = SrmCommonUtil.getBillSelectedId((IFormView)this.getView(), (BillList)((BillList)this.getView().getControl("billlistap")));
            MutexHelper.release((String)"adm_examine", (String)"myconfirm", (String)String.valueOf(billId));
            Object returnData = closedCallBackEvent.getReturnData();
            if (returnData != null) {
                OperateOption option = OperateOption.create();
                OperationServiceHelper.executeOperate((String)"sendmsg", (String)"adm_examine", (Object[])new Object[]{billId}, (OperateOption)option);
            }
            this.getView().invokeOperation("refresh");
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        if ("bd_supplier".equals(args.getRefEntityId())) {
            List supIdList = BizPartnerUtil.getSupplierByUserOfBizPartner();
            args.addCustomQFilter(new QFilter("id", "in", (Object)supIdList));
        }
    }
}

