/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.adm.service.guest;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.adm.service.guest.GuestBaseDataDefaultQueryService;
import kd.scm.adm.service.guest.GuestBaseDataService;

public class GuestBaseDataUtil {
    public static Result query(String bill, String guestbasedataid, Map<String, Object> customParams) {
        Result result = new Result();
        GuestBaseDataUtil.queryBaseDataConfig(bill, guestbasedataid, result);
        if (!result.getSuccess().booleanValue()) {
            return result;
        }
        DynamicObject adm_basedataconfig = result.getData();
        String sourcebasedatano = adm_basedataconfig.getString("entryentity.sourcebasedatano");
        String guestbasedatano = adm_basedataconfig.getString("entryentity.guestbasedatano");
        String selects = adm_basedataconfig.getString("entryentity.selects");
        String customdatasourcePlugnin = adm_basedataconfig.getString("entryentity.customdatasource");
        GuestBaseDataUtil.queryBaseData(sourcebasedatano, guestbasedatano, selects, customdatasourcePlugnin, result, customParams);
        if (!result.getSuccess().booleanValue()) {
            return result;
        }
        return result;
    }

    public static Result queryBaseDataConfig(String bill, String guestbasedataid, Result result) {
        DynamicObject adm_basedataconfig = QueryServiceHelper.queryOne((String)"adm_basedataconfig", (String)"entryentity.guestbasedatano,entryentity.sourcebasedatano,entryentity.selects,entryentity.customdatasource", (QFilter[])new QFilter[]{new QFilter("mainentity.number", "=", (Object)bill).and(new QFilter("billstatus", "=", (Object)"C")).and(new QFilter("entryentity.guestbasedatano", "=", (Object)guestbasedataid).and("entryentity.enable", "=", (Object)"1"))});
        if (Objects.isNull(adm_basedataconfig)) {
            result.setMessage(ResManager.loadKDString((String)"\u533f\u540d\u57fa\u7840\u8d44\u6599\u914d\u7f6e\u4e2d\u672a\u914d\u7f6e\u533f\u540d\u5355\u636e\u3002", (String)"GuestBaseDataUtil_1", (String)"scm-adm-common", (Object[])new Object[0]));
            result.setSuccess(Boolean.FALSE);
            return result;
        }
        String basedataid = adm_basedataconfig.getString("entryentity.sourcebasedatano");
        if (StringUtils.isEmpty((CharSequence)basedataid)) {
            result.setMessage(ResManager.loadResFormat((String)"\u533f\u540d\u57fa\u7840\u8d44\u6599\u914d\u7f6e\u4e2d\u672a\u914d\u7f6e\u201c%1\u201d\u5173\u8054\u57fa\u7840\u8d44\u6599\u3002 ", (String)"GuestBaseDataUtil_2", (String)"scm-adm-common", (Object[])new Object[]{guestbasedataid}));
            result.setSuccess(Boolean.FALSE);
            return result;
        }
        String selects = adm_basedataconfig.getString("entryentity.selects");
        if (StringUtils.isEmpty((CharSequence)selects)) {
            result.setMessage(ResManager.loadResFormat((String)"\u533f\u540d\u57fa\u7840\u8d44\u6599\u914d\u7f6e\u4e2d\u672a\u914d\u7f6e\u201c%1\u201d\u67e5\u8be2\u5b57\u6bb5\u3002", (String)"GuestBaseDataUtil_3", (String)"scm-adm-common", (Object[])new Object[]{guestbasedataid}));
            result.setSuccess(Boolean.FALSE);
            return result;
        }
        result.setSuccess(Boolean.TRUE);
        result.setData(adm_basedataconfig);
        result.setQuerySelects(selects);
        return result;
    }

    public static Result queryBaseData(String basedatabillid, String guestbasedatano, String selects, String className, Result result, Map<String, Object> customParams) {
        result.setSuccess(Boolean.TRUE);
        QFilter qf = GuestBaseDataUtil.getSearchFilter(customParams);
        if (StringUtils.isEmpty((CharSequence)className)) {
            GuestBaseDataDefaultQueryService service = new GuestBaseDataDefaultQueryService();
            DynamicObjectCollection dynamicObjects = service.queryBaseDataSource(basedatabillid, guestbasedatano, selects, customParams, qf);
            result.setDatas(dynamicObjects);
            result.setRowcount(service.queryBaseDataSourceCount(basedatabillid, selects, customParams, qf));
            return result;
        }
        GuestBaseDataService guestServiceClass = GuestBaseDataUtil.getGuestServiceClass(className.trim());
        if (Objects.isNull(guestServiceClass)) {
            result.setMessage(ResManager.loadKDString((String)"\u6839\u636e\u533f\u540d\u57fa\u7840\u8d44\u6599\u914d\u7f6e\u63d2\u4ef6\u672a\u83b7\u53d6\u5230\u5b9e\u73b0\u7c7b\u3002", (String)"GuestBaseDataUtil_5", (String)"scm-adm-common", (Object[])new Object[0]));
            result.setSuccess(Boolean.FALSE);
            return null;
        }
        DynamicObjectCollection dynamicObjects = guestServiceClass.queryBaseDataSource(basedatabillid, guestbasedatano, selects, customParams, qf);
        result.setDatas(dynamicObjects);
        result.setRowcount(guestServiceClass.queryBaseDataSourceCount(basedatabillid, selects, customParams, qf));
        return result;
    }

    public static QFilter getSearchFilter(Map<String, Object> customParams) {
        QFilter qf = null;
        Object searchtext = customParams.get("searchtext");
        List searchFields = (List)customParams.get("searchfields");
        if (StringUtils.isNotBlank((Object)searchtext) && searchFields != null) {
            HashMap filterMap = new HashMap(16);
            for (Map searchField : searchFields) {
                List fieldNames = (List)searchField.get("fieldName");
                List values = (List)searchField.get("value");
                for (String fieldName : fieldNames) {
                    HashSet<String> fieldNameSet = (HashSet<String>)filterMap.get(fieldName);
                    if (fieldNameSet == null) {
                        fieldNameSet = new HashSet<String>(16);
                    }
                    for (String fieldValue : values) {
                        fieldNameSet.add(fieldValue);
                    }
                    filterMap.put(fieldName, fieldNameSet);
                }
            }
            Set entries = filterMap.entrySet();
            for (Map.Entry entry : entries) {
                String key = (String)entry.getKey();
                Set value = (Set)entry.getValue();
                if (qf == null) {
                    qf = GuestBaseDataUtil.getSearchFilter(value, key);
                    continue;
                }
                qf.or(GuestBaseDataUtil.getSearchFilter(value, key));
            }
        }
        return qf;
    }

    private static QFilter getSearchFilter(Set<String> orgFilters, String name) {
        QFilter ofilter = null;
        if (CollectionUtils.isEmpty(orgFilters)) {
            return ofilter;
        }
        for (String filter : orgFilters) {
            if (ofilter == null) {
                ofilter = new QFilter(name, "like", (Object)("%" + filter + "%"));
                continue;
            }
            ofilter.or(new QFilter(name, "like", (Object)("%" + filter + "%")));
        }
        return ofilter;
    }

    public static GuestBaseDataService getGuestServiceClass(String className) {
        GuestBaseDataService guestBaseDataService = null;
        try {
            guestBaseDataService = (GuestBaseDataService)Class.forName(className).newInstance();
        }
        catch (InstantiationException e) {
            BizLog.log((String)("GuestBaseDataUtil getGuestServiceClass  is fail " + e.getMessage()));
        }
        catch (IllegalAccessException e) {
            BizLog.log((String)("GuestBaseDataUtil getGuestServiceClass  is fail " + e.getMessage()));
        }
        catch (ClassNotFoundException e) {
            BizLog.log((String)("GuestBaseDataUtil getGuestServiceClass  is fail " + e.getMessage()));
        }
        return guestBaseDataService;
    }

    public static class Result {
        String message;
        Boolean success;
        DynamicObject data;
        DynamicObjectCollection datas;
        DataSet dataSet;
        String querySelects;
        int rowcount;

        public int getRowcount() {
            return this.rowcount;
        }

        public void setRowcount(int rowcount) {
            this.rowcount = rowcount;
        }

        public String getQuerySelects() {
            return this.querySelects;
        }

        public void setQuerySelects(String querySelects) {
            this.querySelects = querySelects;
        }

        public DataSet getDataSet() {
            return this.dataSet;
        }

        public void setDataSet(DataSet dataSet) {
            this.dataSet = dataSet;
        }

        public DynamicObjectCollection getDatas() {
            return this.datas;
        }

        public void setDatas(DynamicObjectCollection datas) {
            this.datas = datas;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public Boolean getSuccess() {
            return this.success;
        }

        public void setSuccess(Boolean success) {
            this.success = success;
        }

        public DynamicObject getData() {
            return this.data;
        }

        public void setData(DynamicObject data) {
            this.data = data;
        }
    }
}

