/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.business.basedata.serviceImpl;

import java.util.TreeSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.business.basedata.IProficientService;
import kd.scm.bid.business.basedata.serviceImpl.BidServiceImpl;
import org.apache.commons.lang3.StringUtils;

public class ProficientServiceImpl
extends BidServiceImpl
implements IProficientService {
    @Override
    public DynamicObject getProficient(Long proficientId, String selectFields) {
        QFilter qFilter = new QFilter("id", "=", (Object)proficientId);
        DynamicObject proficient = QueryServiceHelper.queryOne((String)"bid_proficient", (String)selectFields, (QFilter[])new QFilter[]{qFilter});
        return proficient;
    }

    @Override
    public boolean checkRefByBill(Long proficientId) {
        String selectFields = "id";
        QFilter qFilter = new QFilter("bidopen_proficient.proficient", "=", (Object)proficientId);
        DynamicObjectCollection bidOpenColl = QueryServiceHelper.query((String)"bid_bidopen", (String)selectFields, (QFilter[])new QFilter[]{qFilter});
        return bidOpenColl != null && bidOpenColl.size() > 0;
    }

    @Override
    public DynamicObjectCollection listProficients(Long[] proficientIds, String selectFields) {
        QFilter qFilter = new QFilter("id", "in", (Object)proficientIds);
        DynamicObjectCollection proficients = QueryServiceHelper.query((String)"bid_proficient", (String)selectFields, (QFilter[])new QFilter[]{qFilter});
        return proficients;
    }

    @Override
    public DynamicObject getProficient_f7(Long proficientId, String selectFields) {
        QFilter qFilter = new QFilter("id", "=", (Object)proficientId);
        DynamicObject proficient = QueryServiceHelper.queryOne((String)"bid_proficient_f7", (String)selectFields, (QFilter[])new QFilter[]{qFilter});
        return proficient;
    }

    @Override
    public DynamicObject getProficientById(Long id) {
        return BusinessDataServiceHelper.loadSingle((Object)id, (DynamicObjectType)this.getMainType());
    }

    @Override
    public DynamicObject insertProjectEntry(DynamicObject bidproject, int size) {
        DynamicObject entry = new DynamicObject((DynamicObjectType)this.getProjectType());
        entry.set("participatetime", (Object)bidproject.getDate("setupdate"));
        DynamicObject org = (DynamicObject)bidproject.get("org");
        String orgName = org.getLocaleString("name").getLocaleValue();
        entry.set("bidunit", (Object)orgName);
        entry.set("seq", (Object)(size + 1));
        String projectName = bidproject.getLocaleString("name").getLocaleValue();
        entry.set("bidproject", (Object)projectName);
        return entry;
    }

    @Override
    public void insertProficientEntryByIds(TreeSet<Object> idSet, DynamicObject bidProject) {
        if (idSet != null && idSet.size() > 0) {
            DynamicObject[] proficientArray = BusinessDataServiceHelper.load((Object[])idSet.toArray(new Object[0]), (DynamicObjectType)this.getMainType());
            String projectName = bidProject.getLocaleString("name").getLocaleValue();
            DynamicObject org = bidProject.getDynamicObject("org");
            String orgName = org.getLocaleString("name").getLocaleValue();
            if (proficientArray != null && proficientArray.length > 0) {
                for (DynamicObject proficient : proficientArray) {
                    DynamicObjectCollection projectEntryCol = proficient.getDynamicObjectCollection("bid_profprojentry");
                    DynamicObject projectEntry = projectEntryCol.addNew();
                    projectEntry.set("participatetime", (Object)bidProject.getDate("setupdate"));
                    projectEntry.set("bidunit", (Object)orgName);
                    projectEntry.set("seq", (Object)(projectEntryCol.size() + 1));
                    projectEntry.set("bidproject", (Object)projectName);
                }
                if (proficientArray != null && proficientArray.length > 0) {
                    SaveServiceHelper.save((DynamicObject[])proficientArray);
                }
            }
        }
    }

    @Override
    public void updateProficientMajorTypeNames(Long majorTypeId) {
        QFilter qFilter = new QFilter("basedata", "=", (Object)majorTypeId);
        DynamicObjectCollection profMajorEntrys = QueryServiceHelper.query((String)"bid_profmajorentry", (String)"id, basedata", (QFilter[])new QFilter[]{qFilter});
        if (profMajorEntrys != null) {
            for (DynamicObject profMajorEntry : profMajorEntrys) {
                Long proficientId = profMajorEntry.getLong("id");
                DynamicObject proficient = BusinessDataServiceHelper.loadSingle((Object)proficientId, (String)"bid_proficient");
                DynamicObjectCollection majorTypeColl = proficient.getDynamicObjectCollection("majortype");
                String majorTypeNames = this.getMajorTypeNames(majorTypeColl);
                proficient.set("majortypenames", (Object)majorTypeNames);
                BusinessDataServiceHelper.save((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bid_proficient"), (Object[])new DynamicObject[]{proficient});
            }
        }
    }

    @Override
    public String getMajorTypeNames(DynamicObjectCollection dynamicObjectColl) {
        StringBuilder sb = new StringBuilder();
        if (dynamicObjectColl != null && dynamicObjectColl.size() > 0) {
            int size = dynamicObjectColl.size();
            char s = ';';
            for (int i = 0; i < size; ++i) {
                DynamicObject dynamicObject = (DynamicObject)((DynamicObject)dynamicObjectColl.get(i)).get("FBasedataId");
                String name = dynamicObject.getString("name");
                sb.append(name);
                if (i == size - 1) continue;
                sb.append(s);
            }
        }
        return sb.toString();
    }

    private EntityType getMainType() {
        return EntityMetadataCache.getDataEntityType((String)"bid_proficient");
    }

    private EntityType getProjectType() {
        MainEntityType type = (MainEntityType)this.getMainType();
        return (EntityType)type.getAllEntities().get("bid_profprojentry");
    }

    @Override
    public void deleteProficientProByField(Long id, DynamicObject project) {
        DynamicObject now = this.getProficientById(id);
        DynamicObjectCollection pros = now.getDynamicObjectCollection("bid_profprojentry");
        DynamicObject toDele = null;
        String projectName = project.getLocaleString("name").getLocaleValue();
        DynamicObject org = project.getDynamicObject("org");
        String orgName = org.getLocaleString("name").getLocaleValue();
        for (DynamicObject pro : pros) {
            String tOrgName = pro.getString("bidunit");
            String tProjectName = pro.getString("bidproject");
            if (projectName == null || !StringUtils.equals((CharSequence)tProjectName, (CharSequence)projectName)) continue;
            if (orgName != null) {
                if (!StringUtils.equals((CharSequence)tOrgName, (CharSequence)orgName)) continue;
                toDele = pro;
                break;
            }
            toDele = pro;
            break;
        }
        if (toDele != null) {
            pros.remove(toDele);
        }
        BusinessDataServiceHelper.save((IDataEntityType)this.getMainType(), (Object[])new Object[]{now});
    }

    @Override
    public void insertProficientProByIds(Long id, DynamicObject project) {
        DynamicObject now = this.getProficientById(id);
        DynamicObjectCollection pros = now.getDynamicObjectCollection("bid_profprojentry");
        if (pros != null) {
            int size = pros.size();
            pros.add((Object)this.insertProjectEntry(project, size));
        } else {
            pros = new DynamicObjectCollection((DynamicObjectType)this.getProjectType(), (Object)now);
            pros.add((Object)this.insertProjectEntry(project, 0));
        }
        BusinessDataServiceHelper.save((IDataEntityType)this.getMainType(), (Object[])new Object[]{now});
    }

    @Override
    public boolean checkUniqueNameAndTelephone(String entity, Long id, String name, String telephone, Long orgId) {
        QFilter qFilter = new QFilter("name", "=", (Object)name);
        qFilter.and(new QFilter("telephone", "=", (Object)telephone));
        qFilter.and(new QFilter("id", "!=", (Object)id));
        qFilter.and(new QFilter("entitytypeid", "=", (Object)entity));
        qFilter.and(new QFilter("org", "=", (Object)orgId));
        DynamicObjectCollection colls = QueryServiceHelper.query((String)entity, (String)"id", (QFilter[])new QFilter[]{qFilter});
        return colls.size() <= 0;
    }
}

