/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.business.basedata.serviceImpl;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.tree.TreeNode;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.business.basedata.ITemplateMangeService;
import kd.scm.bid.common.constant.entity.BidTemplateMangeEntity;
import kd.scm.bid.common.constant.entity.BidTemplateTypeEntity;

public class TemplateMangeServiceImpl
implements ITemplateMangeService {
    @Override
    public List<TreeNode> listNodes(String modelType, int isRoot) {
        String fields = "number,id,name,isleaf,parent,level";
        QFilter isRootFilter = isRoot == 1 ? new QFilter(BidTemplateTypeEntity.PARENT, "=", (Object)0L) : new QFilter(BidTemplateTypeEntity.PARENT, "!=", (Object)0L);
        QFilter modelTypeFilter = !"".equals(modelType) ? new QFilter(BidTemplateTypeEntity.MODELTYPE, "=", (Object)modelType) : null;
        DynamicObjectCollection nodes = QueryServiceHelper.query((String)"bid_templatetype", (String)fields, (QFilter[])new QFilter[]{isRootFilter, modelTypeFilter});
        List<TreeNode> result = this.buildNodes(nodes);
        return result;
    }

    @Override
    public List<TreeNode> listAllNodes() {
        String fields = "number,id,name,isleaf,parent,level";
        DynamicObjectCollection nodes = QueryServiceHelper.query((String)"bid_templatetype", (String)fields, (QFilter[])new QFilter[0]);
        List<TreeNode> result = this.buildNodes(nodes);
        return result;
    }

    @Override
    public void updateDefault(DynamicObject templateManage) {
        DynamicObject[] templates;
        String fields = "modeltype,default";
        Long type = (Long)templateManage.getDynamicObject(BidTemplateMangeEntity.TYPE).getPkValue();
        QFilter type_filter = new QFilter(BidTemplateMangeEntity.TYPE, "=", (Object)type);
        QFilter defalut_filter = new QFilter(BidTemplateMangeEntity.DEFALUT, "=", (Object)"1");
        QFilter org_filter = new QFilter(BidTemplateMangeEntity.ORG, "=", templateManage.getDynamicObject(BidTemplateMangeEntity.ORG).getPkValue());
        for (DynamicObject obj : templates = BusinessDataServiceHelper.load((String)"bid_templatemanage", (String)fields, (QFilter[])new QFilter[]{defalut_filter, type_filter, org_filter})) {
            obj.set(BidTemplateMangeEntity.DEFALUT, (Object)Character.valueOf('0'));
        }
        templateManage.set(BidTemplateMangeEntity.DEFALUT, (Object)Character.valueOf('1'));
        SaveServiceHelper.save((DynamicObject[])templates);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{templateManage});
    }

    private List<TreeNode> buildNodes(DynamicObjectCollection nodes) {
        ArrayList<TreeNode> result = new ArrayList<TreeNode>();
        for (DynamicObject object : nodes) {
            TreeNode node = new TreeNode("", object.getString("id"), object.getString(BidTemplateTypeEntity.NAME));
            node.setParentid(object.getString(BidTemplateTypeEntity.PARENT));
            result.add(node);
        }
        return result;
    }

    @Override
    public List<TreeNode> getTypeByModelType(String modelType) {
        String fields = "number,id,name,isleaf,parent,level";
        QFilter filter = new QFilter(BidTemplateTypeEntity.MODELTYPE, "=", (Object)modelType);
        DynamicObjectCollection nodes = QueryServiceHelper.query((String)"bid_templatetype", (String)fields, (QFilter[])new QFilter[]{filter});
        List<TreeNode> result = this.buildNodes(nodes);
        return result;
    }
}

