/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.business.bidcenter.impl;

import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.bid.business.bidcenter.IBidCenterService;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.enums.BidOpenSelectTypeEnum;
import kd.scm.bid.common.enums.BidOpenTypeEnum;
import kd.scm.bid.common.enums.BidStepEnum;
import kd.scm.bid.common.enums.BillStatusEnum;
import kd.scm.bid.common.enums.RespBusiness;

public class BidCenterServiceImpl
implements IBidCenterService {
    private static String STEP_OPEN_FLAG = "open";
    private static String STEP_ONEV_FLAG = "onev";
    private static String STEP_EVAL_FLAG = "eval";
    public static final String TYPE_COMM_FLAG = "comm";
    public static final String TYPE_TECH_FLAG = "tech";

    @Override
    public QFilter getCenterLookPermissionBidIdFilter(Object userId) {
        QFilter qFilter = new QFilter("user", "=", (Object)Long.parseLong(userId.toString()));
        DynamicObject[] members = BusinessDataServiceHelper.load((String)"bid_memberentity", (String)"entryid,bidproject", (QFilter[])new QFilter[]{qFilter});
        DynamicObject[] leaders = BusinessDataServiceHelper.load((String)"bid_leadermemberentity", (String)"entryid,bidproject", (QFilter[])new QFilter[]{qFilter});
        HashSet<Long> bidProIds = new HashSet<Long>(100);
        for (DynamicObject member : members) {
            bidProIds.add(Long.parseLong(member.getString("bidproject")));
        }
        for (DynamicObject leader : leaders) {
            bidProIds.add(Long.parseLong(leader.getString("bidproject")));
        }
        QFilter idQFilter = new QFilter("id", "in", bidProIds);
        return idQFilter;
    }

    @Override
    public Boolean checkContainStep(Object bidProjectId, BidStepEnum checkStep) {
        String strs = "id,bidproject,supplierinvitation,biddocument,bidpublish,bidopen,bidanswerquestion,bidevaluation,bidbustalk,biddecision,clarificaiton,bidbottommake";
        DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProjectId, (String)"bid_project", (String)strs);
        if (bidProject != null) {
            return bidProject.getBoolean(checkStep.name().toLowerCase());
        }
        return Boolean.FALSE;
    }

    @Override
    public DynamicObject getSingleFormByBidProjectId(String formId, String selectProperties, Object bidProjectId) {
        QFilter bidQFilter = new QFilter("bidproject.id", "=", bidProjectId);
        QFilter cancelQFilter = new QFilter("billstatus", "!=", (Object)BillStatusEnum.INVALIDXX.getVal());
        QFilter[] qFilters = new QFilter[]{bidQFilter, cancelQFilter};
        DynamicObject singleForm = BusinessDataServiceHelper.loadSingle((String)formId, (String)selectProperties, (QFilter[])qFilters);
        return singleForm;
    }

    @Override
    public DynamicObject getSingleFormHisByBidProjectId(String formId, String selectProperties, Object bidProjectId) {
        QFilter bidQFilter = new QFilter("bidproject.id", "=", bidProjectId);
        QFilter cancelQFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.INVALIDXX.getVal());
        QFilter[] qFilters = new QFilter[]{bidQFilter, cancelQFilter};
        DynamicObject[] singleForm = BusinessDataServiceHelper.load((String)formId, (String)selectProperties, (QFilter[])qFilters, (String)"createtime desc");
        return singleForm[0];
    }

    @Override
    public DynamicObject getSingleFormByBidProjectId(String formId, String selectProperties, Object bidProjectId, QFilter qFilter) {
        QFilter bidQFilter = new QFilter("bidproject.id", "=", bidProjectId);
        QFilter[] qFilters = qFilter == null ? new QFilter[]{bidQFilter} : new QFilter[]{bidQFilter, qFilter};
        DynamicObject singleForm = BusinessDataServiceHelper.loadSingle((String)formId, (String)selectProperties, (QFilter[])qFilters);
        return singleForm;
    }

    @Override
    public DynamicObject getSingleFormByBidProjectIdCurrent(String formId, String selectProperties, Object bidProjectId, QFilter qFilter) {
        QFilter bidQFilter = new QFilter("bidproject.id", "=", bidProjectId);
        QFilter[] qFilters = qFilter == null ? new QFilter[]{bidQFilter} : new QFilter[]{bidQFilter, qFilter};
        DynamicObject[] singleFormList = BusinessDataServiceHelper.load((String)formId, (String)selectProperties, (QFilter[])qFilters, (String)"createtime desc");
        if (singleFormList.length > 0) {
            return singleFormList[0];
        }
        return null;
    }

    @Override
    public DynamicObject getSingleFormByBidProjectIdCurrent(String formId, String selectProperties, Object bidProjectId) {
        QFilter bidQFilter = new QFilter("bidproject.id", "=", bidProjectId);
        QFilter cancelQFilter = new QFilter("billstatus", "!=", (Object)BillStatusEnum.INVALIDXX);
        QFilter[] qFilters = new QFilter[]{bidQFilter, cancelQFilter};
        DynamicObject[] singleFormList = BusinessDataServiceHelper.load((String)formId, (String)selectProperties, (QFilter[])qFilters, (String)"createtime desc");
        if (singleFormList.length > 0) {
            return singleFormList[0];
        }
        return null;
    }

    @Override
    public DynamicObject getLastestAnswerQuestionRecobybidprojectid(Object bidProjectId) {
        DynamicObject[] recoArr = this.getAnswerQuestionRecobybidprojectid(bidProjectId);
        if (recoArr != null && recoArr.length > 0) {
            return recoArr[0];
        }
        return null;
    }

    @Override
    public DynamicObject[] getAnswerQuestionRecobybidprojectid(Object bidProjectId) {
        QFilter bidProjectIdFilter = new QFilter("bidproject", "=", bidProjectId);
        String orderBys = "createtime desc";
        DynamicObject[] recoArr = BusinessDataServiceHelper.load((String)FormTypeConstants.getFormConstant((String)"answerquestion_reco", this.getClass()), (String)"id,bidproject.id,answerquestiontime,createtime,billstatus", (QFilter[])new QFilter[]{bidProjectIdFilter}, (String)orderBys);
        return recoArr;
    }

    @Override
    public DynamicObject getLastestBidBustalkRecobybidprojectid(Object bidProjectId) {
        DynamicObject[] recoArr = this.getBidBustalkRecobybidprojectid(bidProjectId);
        if (recoArr != null && recoArr.length > 0) {
            return recoArr[0];
        }
        return null;
    }

    @Override
    public DynamicObject[] getBidBustalkRecobybidprojectid(Object bidProjectId) {
        QFilter bidProjectIdFilter = new QFilter("bidproject", "=", bidProjectId);
        String orderBys = "createtime desc";
        DynamicObject[] recoArr = BusinessDataServiceHelper.load((String)FormTypeConstants.getFormConstant((String)"bustalk", this.getClass()), (String)"id,bidproject.id,createtime,billstatus", (QFilter[])new QFilter[]{bidProjectIdFilter}, (String)orderBys);
        return recoArr;
    }

    @Override
    public DynamicObject getPermissionMember(Object userId, Object bidProjectId, String respbusinessNo) {
        QFilter bidFilter = new QFilter("bidproject", "=", bidProjectId);
        QFilter userFilter = new QFilter("user", "=", (Object)Long.parseLong(userId.toString()));
        QFilter f = new QFilter("respbusiness", "like", (Object)("%" + respbusinessNo + "%")).or(new QFilter("isdirector", "=", (Object)"1"));
        QFilter l = new QFilter("respbusiness", "like", (Object)("%" + respbusinessNo + "%"));
        if (RespBusiness.RespCreateDoc.getVal().equals(respbusinessNo)) {
            f.or(new QFilter("respbusiness", "like", (Object)("%" + RespBusiness.TechnicalDoc.getVal() + "%"))).or(new QFilter("respbusiness", "like", (Object)("%" + RespBusiness.CommercialDoc.getVal() + "%")));
            l.or(new QFilter("respbusiness", "like", (Object)("%" + RespBusiness.TechnicalDoc.getVal() + "%"))).or(new QFilter("respbusiness", "like", (Object)("%" + RespBusiness.CommercialDoc.getVal() + "%")));
        }
        if (RespBusiness.BidOpen.getVal().equals(respbusinessNo)) {
            f.or(new QFilter("respbusiness", "like", (Object)("%" + RespBusiness.TechnicalOpen.getVal() + "%"))).or(new QFilter("respbusiness", "like", (Object)("%" + RespBusiness.BusinessOpen.getVal() + "%")));
            l.or(new QFilter("respbusiness", "like", (Object)("%" + RespBusiness.TechnicalOpen.getVal() + "%"))).or(new QFilter("respbusiness", "like", (Object)("%" + RespBusiness.BusinessOpen.getVal() + "%")));
        }
        if (RespBusiness.BidEvaluation.getVal().equals(respbusinessNo)) {
            f.or(new QFilter("respbusiness", "like", (Object)("%" + RespBusiness.TechnicalEval.getVal() + "%"))).or(new QFilter("respbusiness", "like", (Object)("%" + RespBusiness.BusinessEval.getVal() + "%")));
            l.or(new QFilter("respbusiness", "like", (Object)("%" + RespBusiness.TechnicalEval.getVal() + "%"))).or(new QFilter("respbusiness", "like", (Object)("%" + RespBusiness.BusinessEval.getVal() + "%")));
        }
        bidFilter = bidFilter.and(userFilter).and(f);
        DynamicObject member = BusinessDataServiceHelper.loadSingle((String)"bid_memberentity", (String)"entryid,bidproject,respbusiness,isdirector", (QFilter[])new QFilter[]{bidFilter});
        QFilter leaderQfilter = new QFilter("bidproject", "=", bidProjectId);
        leaderQfilter.and(userFilter).and(l);
        DynamicObject leader = BusinessDataServiceHelper.loadSingle((String)"bid_leadermemberentity", (String)"entryid,bidproject,respbusiness,isdirector", (QFilter[])new QFilter[]{leaderQfilter});
        return member == null ? leader : member;
    }

    @Override
    public Boolean checkCanTechnicalOpen(Object bidProjectId, String bidopentype) {
        if (StringUtils.equals((CharSequence)BidOpenSelectTypeEnum.BUSSINESSTECH.getValue(), (CharSequence)bidopentype)) {
            QFilter bidFilter = new QFilter("bidproject.id", "=", bidProjectId);
            bidFilter.and(new QFilter("billstatus", "!=", (Object)BillStatusEnum.INVALIDXX.getVal()));
            bidFilter = bidFilter.and(new QFilter("opentype", "=", (Object)BidOpenTypeEnum.BUSSINESS.getValue()));
            DynamicObject bidOpenCheck = BusinessDataServiceHelper.loadSingle((String)FormTypeConstants.getFormConstant((String)"bidopen", this.getClass()), (String)"opentype,billstatus,bidproject.id,bidproject.bidopentype", (QFilter[])new QFilter[]{bidFilter});
            if (bidOpenCheck != null && !StringUtils.equals((CharSequence)BillStatusEnum.OPEN.getVal(), (CharSequence)bidOpenCheck.getString("billstatus")) && !StringUtils.equals((CharSequence)BillStatusEnum.INVALID.getVal(), (CharSequence)bidOpenCheck.getString("billstatus"))) {
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean checkCanBusinessOpen(Object bidProjectId, String bidopentype) {
        if (StringUtils.equals((CharSequence)BidOpenSelectTypeEnum.TECHBUSINESS.getValue(), (CharSequence)bidopentype)) {
            QFilter bidFilter = new QFilter("bidproject.id", "=", bidProjectId);
            bidFilter.and(new QFilter("billstatus", "!=", (Object)BillStatusEnum.INVALIDXX.getVal()));
            bidFilter = bidFilter.and(new QFilter("opentype", "=", (Object)BidOpenTypeEnum.TECHNICAL.getValue()));
            DynamicObject bidOpenCheck = BusinessDataServiceHelper.loadSingle((String)FormTypeConstants.getFormConstant((String)"bidopen", this.getClass()), (String)"opentype,billstatus,bidproject.id,bidproject.bidopentype", (QFilter[])new QFilter[]{bidFilter});
            if (bidOpenCheck != null && !StringUtils.equals((CharSequence)BillStatusEnum.OPEN.getVal(), (CharSequence)bidOpenCheck.getString("billstatus")) && !StringUtils.equals((CharSequence)BillStatusEnum.INVALID.getVal(), (CharSequence)bidOpenCheck.getString("billstatus"))) {
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean checkCanTechnicalEval(Object bidProjectId) {
        DynamicObject techEvalData = this.getTechEvalDataByBidId(bidProjectId, null);
        if (techEvalData == null) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean checkCanBusinessEval(Object bidProjectId) {
        DynamicObject commEvalData = this.getCommEvalDataByBidId(bidProjectId, null);
        if (commEvalData == null) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean checkHaveCurrentStepData(Object bidProjectId, String currentStep) {
        return null;
    }

    @Override
    public Boolean checkHaveCurrentStepOpPermission(Object bidProjectId, String currentStep) {
        return null;
    }

    @Override
    public Boolean checkHaveRespbusinessPermission(Object bidProjectId, String respbusinessNo) {
        return null;
    }

    @Override
    public DynamicObject getTechOpenDataByBidId(Object bidProjectId, String selectProperties) {
        return this.getStepTypeDataByBidId(bidProjectId, selectProperties, STEP_OPEN_FLAG, TYPE_TECH_FLAG);
    }

    @Override
    public DynamicObject getCommOpenDataByBidId(Object bidProjectId, String selectProperties) {
        return this.getStepTypeDataByBidId(bidProjectId, selectProperties, STEP_OPEN_FLAG, TYPE_COMM_FLAG);
    }

    @Override
    public DynamicObject getTechEvalDataByBidId(Object bidProjectId, String selectProperties) {
        return this.getStepTypeDataByBidId(bidProjectId, selectProperties, STEP_EVAL_FLAG, TYPE_TECH_FLAG);
    }

    @Override
    public DynamicObject getCommEvalDataByBidId(Object bidProjectId, String selectProperties) {
        return this.getStepTypeDataByBidId(bidProjectId, selectProperties, STEP_EVAL_FLAG, TYPE_COMM_FLAG);
    }

    @Override
    public DynamicObject getTechOnevDataByBidId(Object bidProjectId, String selectProperties) {
        return this.getStepTypeDataByBidId(bidProjectId, selectProperties, STEP_ONEV_FLAG, TYPE_TECH_FLAG);
    }

    @Override
    public DynamicObject getCommOnevDataByBidId(Object bidProjectId, String selectProperties) {
        return this.getStepTypeDataByBidId(bidProjectId, selectProperties, STEP_ONEV_FLAG, TYPE_COMM_FLAG);
    }

    private DynamicObject getStepTypeDataByBidId(Object bidProjectId, String selectProperties, String step, String type) {
        if (StringUtils.isEmpty((CharSequence)selectProperties)) {
            selectProperties = "id,billstatus";
        }
        QFilter bidFilter = new QFilter("bidproject.id", "=", bidProjectId);
        QFilter billStatusFilter = new QFilter("billstatus", "!=", (Object)BillStatusEnum.INVALIDXX.getVal());
        QFilter typeFilter = null;
        String formId = null;
        if (STEP_OPEN_FLAG.equals(step)) {
            formId = "bid_bidopen";
            if (TYPE_COMM_FLAG.equals(type)) {
                typeFilter = new QFilter("opentype", "=", (Object)BidOpenTypeEnum.BUSSINESS.getValue());
            } else if (TYPE_TECH_FLAG.equals(type)) {
                typeFilter = new QFilter("opentype", "=", (Object)BidOpenTypeEnum.TECHNICAL.getValue());
            }
        } else if (STEP_ONEV_FLAG.equals(step)) {
            formId = "bid_onlinebideval";
            if (TYPE_COMM_FLAG.equals(type)) {
                typeFilter = new QFilter("evaltype", "=", (Object)"BUSSINESS");
            } else if (TYPE_TECH_FLAG.equals(type)) {
                typeFilter = new QFilter("evaltype", "=", (Object)"TECHNICAL");
            }
        } else if (STEP_EVAL_FLAG.equals(step)) {
            formId = "bid_bidevaluation";
            if (TYPE_COMM_FLAG.equals(type)) {
                typeFilter = new QFilter("evaltype", "=", (Object)"BUSSINESS");
            } else if (TYPE_TECH_FLAG.equals(type)) {
                typeFilter = new QFilter("evaltype", "=", (Object)"TECHNICAL");
            }
        }
        if (StringUtils.isEmpty((CharSequence)formId)) {
            return null;
        }
        DynamicObject stepTypeData = BusinessDataServiceHelper.loadSingle((String)formId, (String)selectProperties, (QFilter[])new QFilter[]{bidFilter, typeFilter, billStatusFilter});
        return stepTypeData;
    }
}

