/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.business.bill.serviceImpl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.scm.bid.business.basedata.serviceImpl.BidServiceImpl;
import kd.scm.bid.business.bill.IBidBustalkService;
import kd.scm.bid.business.bill.IBidBustalkSupplierFileService;
import kd.scm.bid.business.bill.IBidProjectService;
import kd.scm.bid.business.bill.serviceImpl.BidBustalkSupplierFileServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.BidProjectServiceImpl;
import kd.scm.bid.business.helper.BidFileHelper;
import kd.scm.bid.business.helper.EntityTypeHelper;
import kd.scm.bid.business.util.BidProjectChgCreatorUtils;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.enums.BidStepEnum;
import kd.scm.bid.common.enums.BillStatusEnum;
import kd.scm.bid.common.util.MessageCenterHelper;
import kd.scm.bid.common.util.MessageChannelUtil;

public class BidBustalkServiceImpl
extends BidServiceImpl
implements IBidBustalkService {
    private IBidProjectService bidProjectService = new BidProjectServiceImpl();
    private IBidBustalkSupplierFileService bidBustalkSupplierFileService = new BidBustalkSupplierFileServiceImpl();

    @Override
    public String getFormId() {
        return "bid_bustalk";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void createByLastStep(DynamicObject bidProject, BidStepEnum lastStep) {
        if (null == bidProject || null == bidProject.get("id")) {
            return;
        }
        DynamicObject bProject = this.bidProjectService.getBidProjectAllById((Long)bidProject.get("id"));
        QFilter filters = new QFilter("bidproject.id", "=", bProject.getPkValue());
        DynamicObjectCollection bustalkColl = QueryServiceHelper.query((String)this.getFormId(), (String)"id,createtime,billstatus,bidproject.id", (QFilter[])filters.toArray(), (String)"createtime desc");
        if (bustalkColl != null && bustalkColl.size() != 0) {
            if (!((DynamicObject)bustalkColl.get(0)).getString("billstatus").equals("C")) return;
            this.saveBustalk(bProject, bustalkColl.size());
            return;
        } else {
            this.saveBustalk(bProject, 0);
        }
    }

    private void saveBustalk(DynamicObject bidProject, int judge) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"bid_bustalk");
        DynamicObject bidBustalk = new DynamicObject((DynamicObjectType)mainEntityType);
        bidBustalk.set("bidproject", (Object)bidProject);
        bidBustalk.set("currency", bidProject.get("currency"));
        DynamicObjectCollection sectionCollection = new DynamicObjectCollection();
        EntityType sectionEntityType = (EntityType)mainEntityType.getAllEntities().get("bidsection");
        DynamicObjectCollection bidSectionCollection = bidProject.getDynamicObjectCollection("bidsection");
        for (int i = 0; i < bidSectionCollection.size(); ++i) {
            DynamicObject bidSection = (DynamicObject)bidSectionCollection.get(i);
            DynamicObject section = new DynamicObject((DynamicObjectType)sectionEntityType);
            section.set("seq", (Object)(i + 1));
            section.set("sectionname", bidSection.get("sectionname"));
            sectionCollection.add((Object)section);
        }
        bidBustalk.set("bidsection", (Object)sectionCollection);
        Long queryId = Long.parseLong(bidProject.get("id").toString());
        MainEntityType projectType = EntityMetadataCache.getDataEntityType((String)"bidproject_f7");
        DynamicObject projectF7 = BusinessDataServiceHelper.loadSingle((Object)queryId, (DynamicObjectType)projectType);
        DynamicObject orgnization = projectF7.getDynamicObject("org");
        bidBustalk.set("org", orgnization.getPkValue());
        bidBustalk.set("billstatus", (Object)BillStatusEnum.DISBEGIN.getVal());
        bidBustalk.set("billno", (Object)bidProject.getString("billno"));
        bidBustalk.set("judge_num", (Object)judge);
        if (0 == judge) {
            bidBustalk.set("judge_num_name", (Object)ResManager.loadKDString((String)"\u9996\u6b21\u8c08\u5224", (String)"BidBustalkServiceImpl_0", (String)"scm-bid-business", (Object[])new Object[0]));
        } else {
            bidBustalk.set("judge_num_name", (Object)String.format(ResManager.loadKDString((String)"\u7b2c%s\u8f6e\u8c08\u5224", (String)"BidBustalkServiceImpl_4", (String)"scm-bid-business", (Object[])new Object[0]), String.valueOf(judge + 1)));
        }
        HashMap<String, DynamicObject> creatorMap = BidProjectChgCreatorUtils.getCreator(bidProject);
        DynamicObject creator = creatorMap.get("15");
        bidBustalk.set("creator", (Object)creator);
        bidBustalk.set("createtime", (Object)new Date());
        EntityTypeHelper.setEntityType(bidBustalk, "bid_bustalk", "bidproject");
        BusinessDataServiceHelper.save((IDataEntityType)mainEntityType, (Object[])new DynamicObject[]{bidBustalk});
        ThreadPools.executeOnce((String)"ThreadForTest", () -> {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
    }

    @Override
    public DynamicObject getBustalkById(Long id) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"bid_bustalk");
        return BusinessDataServiceHelper.loadSingle((Object)id, (DynamicObjectType)type);
    }

    @Override
    public DynamicObject getBustalkById(Long id, String selectedFields) {
        QFilter qFilter = new QFilter("id", "=", (Object)id);
        return QueryServiceHelper.queryOne((String)"bid_bustalk", (String)selectedFields, (QFilter[])new QFilter[]{qFilter});
    }

    @Override
    public DynamicObject getAllBustalkById(Long id) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"bid_bustalk");
        return BusinessDataServiceHelper.loadSingle((Object)id, (DynamicObjectType)type);
    }

    @Override
    public void updateFileNumber(Long id, Long sectionId, Long supplierId, String clickFieldName, int size) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"bid_bustalk");
        EntityType entityType = (EntityType)type.getAllEntities().get("supplierentry");
        Long pkId = null;
        DynamicObject mainObject = BusinessDataServiceHelper.loadSingle((Object)id, (DynamicObjectType)type);
        if (mainObject != null) {
            DynamicObjectCollection sectionColl = mainObject.getDynamicObjectCollection("bidsection");
            block0: for (DynamicObject tempSection : sectionColl) {
                Long tempSectionId = tempSection.getLong("id");
                if (tempSectionId.longValue() != sectionId.longValue()) continue;
                DynamicObjectCollection supplierColl = tempSection.getDynamicObjectCollection("supplierentry");
                for (DynamicObject tempSupplier : supplierColl) {
                    Long tempSupplierId = tempSupplier.getLong("supplier.id");
                    if (tempSupplierId.longValue() != supplierId.longValue()) continue;
                    pkId = tempSupplier.getLong("id");
                    continue block0;
                }
            }
        }
        if (pkId != null && pkId != 0L) {
            DynamicObject entry = BusinessDataServiceHelper.loadSingle((Object)pkId, (DynamicObjectType)entityType);
            entry.set(clickFieldName, (Object)size);
            BusinessDataServiceHelper.save((IDataEntityType)entityType, (Object[])new Object[]{entry});
        }
    }

    @Override
    public boolean findBustalkByUnaudit(Long bidprojectId) {
        QFilter qFilter1 = new QFilter("bidproject.id", "=", (Object)bidprojectId);
        QFilter qFilter2 = new QFilter("billstatus", "!=", (Object)"C");
        boolean isExist = QueryServiceHelper.exists((String)"bid_bustalk", (QFilter[])new QFilter[]{qFilter1, qFilter2});
        return isExist;
    }

    @Override
    public boolean findBustalkByUnauditExpFirst(Long bidprojectId) {
        QFilter qFilter1 = new QFilter("bidproject.id", "=", (Object)bidprojectId);
        QFilter qFilter2 = new QFilter("billstatus", "!=", (Object)"C");
        qFilter2.and(new QFilter("billstatus", "!=", (Object)"D"));
        boolean isExist = QueryServiceHelper.exists((String)"bid_bustalk", (QFilter[])new QFilter[]{qFilter1, qFilter2});
        QFilter qFilter4 = new QFilter("billstatus", "=", (Object)"D");
        QFilter qFilter5 = new QFilter("judge_num", "=", (Object)"0");
        boolean isExist2 = QueryServiceHelper.exists((String)"bid_bustalk", (QFilter[])new QFilter[]{qFilter1, qFilter4, qFilter5});
        if (!isExist) {
            return false;
        }
        return isExist2;
    }

    @Override
    public boolean createNextJudge(Long bidprojectId) {
        DynamicObject bustalk = this.findMaxJudgenumBustalk(bidprojectId);
        if (null != bustalk) {
            DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)bidprojectId, (String)"bid_project");
            this.saveBustalk(bidProject, bustalk.getInt("judge_num") + 1);
            return true;
        }
        return false;
    }

    @Override
    public DynamicObject findMaxJudgenumBustalk(Long bidprojectId) {
        QFilter qFilter = new QFilter("bidproject.id", "=", (Object)bidprojectId);
        DynamicObjectCollection bustalks = QueryServiceHelper.query((String)"bid_bustalk", (String)"id,judge_num", (QFilter[])new QFilter[]{qFilter}, (String)"judge_num desc", (int)1);
        if (bustalks.size() > 0) {
            return (DynamicObject)bustalks.get(0);
        }
        return null;
    }

    @Override
    public DynamicObject findPrevJudgenumBustalk(Long bidprojectId, int judgeNum) {
        if (judgeNum == 0) {
            return null;
        }
        QFilter qFilter1 = new QFilter("bidproject.id", "=", (Object)bidprojectId);
        QFilter qFilter2 = new QFilter("judge_num", "=", (Object)(judgeNum - 1));
        DynamicObjectCollection bustalks = QueryServiceHelper.query((String)"bid_bustalk", (String)"id,billstatus", (QFilter[])new QFilter[]{qFilter1, qFilter2}, (String)"judge_num desc", (int)1);
        if (bustalks.size() > 0) {
            Long id = ((DynamicObject)bustalks.get(0)).getLong("id");
            return this.getBustalkById(id);
        }
        return null;
    }

    @Override
    public DynamicObjectCollection findBustalkByBidprojectId(Long bidprojectId) {
        QFilter qFilter = new QFilter("bidproject.id", "=", (Object)bidprojectId);
        DynamicObjectCollection list = QueryServiceHelper.query((String)"bid_bustalk", (String)"id,billstatus,bidproject,is_again_bidding,is_again_ten", (QFilter[])new QFilter[]{qFilter}, (String)"judge_num desc");
        return list;
    }

    @Override
    public DynamicObjectCollection findBustalkByBidprojectId(Long bidprojectId, String orderBys) {
        QFilter qFilter = new QFilter("bidproject.id", "=", (Object)bidprojectId);
        DynamicObjectCollection list = QueryServiceHelper.query((String)"bid_bustalk", (String)"id,billstatus,is_again_bidding,is_again_ten", (QFilter[])new QFilter[]{qFilter}, (String)orderBys);
        return list;
    }

    @Override
    public void updateBustalkComplete(DynamicObjectCollection list, String billstatus, Date date) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"bid_bustalk");
        HashSet<Long> ids = new HashSet<Long>(100);
        for (int i = 0; i < list.size(); ++i) {
            DynamicObject temp = (DynamicObject)list.get(i);
            ids.add(temp.getLong("id"));
        }
        if (ids.size() == 1 && "C".equals(billstatus)) {
            Iterator id = ids.iterator();
            while (id.hasNext()) {
                DynamicObject bustalk = this.getBustalkById(Long.parseLong(id.next().toString()));
                if (null == bustalk.get("auditor")) {
                    billstatus = BillStatusEnum.DISBEGIN.getVal();
                }
                bustalk.set("billstatus", (Object)billstatus);
                BusinessDataServiceHelper.save((IDataEntityType)mainEntityType, (Object[])new DynamicObject[]{bustalk});
            }
        } else {
            Iterator id = ids.iterator();
            while (id.hasNext()) {
                String status = billstatus;
                DynamicObject bustalk = this.getBustalkById(Long.parseLong(id.next().toString()));
                if (null == bustalk.get("auditor") && !"F".equals(billstatus)) {
                    status = BillStatusEnum.DISBEGIN.getVal();
                }
                bustalk.set("billstatus", (Object)status);
                BusinessDataServiceHelper.save((IDataEntityType)mainEntityType, (Object[])new DynamicObject[]{bustalk});
            }
        }
    }

    @Override
    public void copyFileToDecision(String panel, String attachment, Long newSupplierentry, Long supplierentryId, Long supplierId, Long fileId, String appId) {
        Throwable throwable;
        TXHandle h;
        DynamicObject file4Tech = this.bidBustalkSupplierFileService.getOneFileRecordByIds(supplierId, supplierentryId, "techFile", "id,status");
        DynamicObject file4Com = this.bidBustalkSupplierFileService.getOneFileRecordByIds(supplierId, supplierentryId, "comFile", "id,status");
        MainEntityType t = EntityMetadataCache.getDataEntityType((String)(appId + "_decisionentryfile"));
        DynamicObject file = new DynamicObject((DynamicObjectType)t);
        file.set("detailid", (Object)newSupplierentry);
        ORM orm = ORM.create();
        if (null == fileId) {
            fileId = orm.genLongId((IDataEntityType)t);
        }
        file.set("id", (Object)fileId);
        if (file4Tech != null) {
            h = TX.requiresNew();
            throwable = null;
            try {
                try {
                    BidFileHelper.copyFileFromAToB(panel, file4Tech.get("id"), attachment, appId + "_decisionentryfile", fileId, "techfilepanel");
                }
                catch (Throwable ex) {
                    h.markRollback();
                    throw ex;
                }
            }
            catch (Throwable ex) {
                throwable = ex;
                throw ex;
            }
            finally {
                if (h != null) {
                    if (throwable != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable ex) {
                            throwable.addSuppressed(ex);
                        }
                    } else {
                        h.close();
                    }
                }
            }
        }
        if (file4Com != null) {
            h = TX.requiresNew();
            throwable = null;
            try {
                try {
                    BidFileHelper.copyFileFromAToB(panel, file4Com.get("id"), attachment, appId + "_decisionentryfile", fileId, "commfilepanel");
                }
                catch (Throwable ex) {
                    h.markRollback();
                    throw ex;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (h != null) {
                    if (throwable != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        h.close();
                    }
                }
            }
        }
        BusinessDataServiceHelper.save((IDataEntityType)t, (Object[])new DynamicObject[]{file});
    }

    @Override
    public void removeDecisionFile(Object billId, String type, String appId) {
        try (TXHandle h = TX.requiresNew();){
            try {
                BidFileHelper.removeAllFile(appId + "_decisionentryfile", billId, type);
            }
            catch (Throwable ex) {
                h.markRollback();
                throw ex;
            }
        }
        MainEntityType t = EntityMetadataCache.getDataEntityType((String)(appId + "_decisionentryfile"));
        BusinessDataServiceHelper.delete((IDataEntityType)t, (Object[])new Object[]{billId});
    }

    @Override
    public boolean checkBidDocFinished(Long bidProjectId) {
        boolean flag = true;
        DynamicObject pro = BusinessDataServiceHelper.loadSingle((Object)bidProjectId, (String)"bid_project", (String)"id,biddocument");
        boolean isbiddocument = pro.getBoolean("biddocument");
        if (isbiddocument) {
            DynamicObject[] bidDocArr;
            for (DynamicObject bidDoc : bidDocArr = BusinessDataServiceHelper.load((String)"bid_biddocument_edit", (String)"id,billstatus,bidproject", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)bidProjectId)})) {
                if (BillStatusEnum.AUDITED.getVal().equals(bidDoc.getString("billstatus")) || BillStatusEnum.INVALID.getVal().equals(bidDoc.getString("billstatus")) || BillStatusEnum.INVALIDXX.getVal().equals(bidDoc.getString("billstatus"))) continue;
                flag = false;
                break;
            }
        }
        return flag;
    }

    public void sendMessage(DynamicObject bidProjectF7) {
        DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProjectF7.getPkValue(), (String)FormTypeConstants.getFormConstant((String)"project", this.getClass()));
        String appid = bidProject.getString("entitytypeid").split("_")[0];
        DynamicObject bidBustTalk = BusinessDataServiceHelper.loadSingle((String)FormTypeConstants.getFormConstant((String)"bustalk", this.getClass()), (String)"id", (QFilter[])new QFilter[]{new QFilter("bidproject.id", "=", bidProject.getPkValue())});
        if (bidBustTalk != null) {
            String title = String.format(ResManager.loadKDString((String)"\u60a8\u597d\uff0c\u60a8\u6709\u4e00\u6761<%s>\u4e1a\u52a1\u5f85\u529e\u6d88\u606f\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002", (String)"BidBustalkServiceImpl_5", (String)"scm-bid-business", (Object[])new Object[0]), bidProject.getString("name"));
            HashMap<String, Object> msgParam = new HashMap<String, Object>();
            msgParam.put("tplScene", "createbidbust");
            if ("bid".equals(appid)) {
                msgParam.put("formId", "bid_bustalk");
            } else {
                msgParam.put("formId", "rebm_bustalk");
            }
            msgParam.put("appId", appid);
            msgParam.put("id", bidBustTalk.getPkValue());
            msgParam.put("pkId", bidBustTalk.getPkValue());
            msgParam.put("title", null);
            msgParam.put("operation", "save");
            msgParam.put("urlParams", Arrays.asList("formId", "pkId"));
            DynamicObjectCollection memberColl = bidProject.getDynamicObjectCollection("memberentity");
            HashSet<DynamicObject> memberSet = new HashSet<DynamicObject>();
            ArrayList<Long> receiveUserIds = new ArrayList<Long>();
            for (DynamicObject member : memberColl) {
                String[] values;
                if (member.getString("respbusiness") == null || (values = member.getString("respbusiness").split(",")) == null || values.length <= 0) continue;
                for (int m = 0; m < values.length; ++m) {
                    if (!"15".equals(values[m])) continue;
                    memberSet.add(member.getDynamicObject("user"));
                }
            }
            if (!memberSet.isEmpty()) {
                for (DynamicObject set : memberSet) {
                    receiveUserIds.add(set.getLong("id"));
                }
            }
            msgParam.put("msgentity", "bid_bustalk");
            String content = String.format(ResManager.loadKDString((String)"\u60a8\u597d\uff0c\u60a8\u53c2\u4e0e\u7684<%s>\u9879\u76ee\u5df2\u8fdb\u5165\u5546\u52a1\u8c08\u5224\u4e1a\u52a1\u529e\u7406\u73af\u8282\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002", (String)"BidBustalkServiceImpl_7", (String)"scm-bid-business", (Object[])new Object[0]), bidProject.getString("name"));
            msgParam.put("content", null);
            String notifyType = MessageChannelUtil.getNotifyType((String)"createbidbust", (String)"bid_bustalk");
            MessageCenterHelper.sendMessagesToOpetator(msgParam, (boolean)true, receiveUserIds, (String)notifyType);
        }
    }
}

