/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.business.bill.serviceImpl;

import com.google.common.collect.HashBasedTable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.business.basedata.serviceImpl.BidServiceImpl;
import kd.scm.bid.business.bill.IBidEvaluationService;
import kd.scm.bid.business.bill.serviceImpl.OnlineBidEvalServiceImpl;
import kd.scm.bid.business.helper.EntityTypeHelper;
import kd.scm.bid.business.util.BidProjectChgCreatorUtils;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.enums.BidOpenTypeEnum;
import kd.scm.bid.common.enums.BidStepEnum;
import kd.scm.bid.common.enums.BillStatusEnum;
import kd.scm.bid.common.enums.ClarifyStatusEnum;
import kd.scm.bid.common.enums.ScoreMethod;
import kd.scm.bid.common.util.BidDarkUtil;
import kd.scm.bid.common.util.MessageCenterHelper;
import kd.scm.bid.common.util.MessageChannelUtil;
import kd.scm.bid.common.util.OrgUnitHelper;
import kd.scm.bid.common.util.SystemParamHelper;

public class BidEvaluationServiceImpl
extends BidServiceImpl
implements IBidEvaluationService {
    @Override
    public void createByLastStep(DynamicObject bidProject, BidStepEnum lastStep) {
        if (bidProject == null || bidProject.get("id") == null) {
            return;
        }
        Long bidProjectId = bidProject.getLong("id");
        String appId = bidProject.getString("entitytypeid").split("_")[0];
        bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProject.getPkValue(), (String)(appId + "_project"), (String)"id,org,billno,bidopendeadline,biddecisiondate,bidevaluationdate,approachdate,bidpublishdate,answerquestiontime,busbackbidtime,isseparatedoc,bidrollsection,bidrollsection.rollsectionname,bidrollsection.seq,currency,evaluatedecideway,entitytypeid");
        if (BidStepEnum.BidOpen == lastStep || BidStepEnum.BidEvaluation == lastStep) {
            String opentype;
            QFilter qFilter = new QFilter("bidproject.id", "=", (Object)bidProjectId);
            DynamicObjectCollection bidOpenCheckColl = QueryServiceHelper.query((String)"bid_bidopen", (String)"id,billstatus,opentype,auditdate", (QFilter[])new QFilter[]{qFilter}, (String)"auditdate desc");
            DynamicObject bidOpen = null;
            if (bidOpenCheckColl != null) {
                if (bidOpenCheckColl.size() == 1) {
                    bidOpen = "rebm".equals(appId) ? BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)bidOpenCheckColl.get(0)).getLong("id"), (String)"rebm_bidopen") : BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)bidOpenCheckColl.get(0)).getLong("id"), (String)"bid_bidopen");
                } else {
                    DynamicObject curBidOpen = null;
                    for (DynamicObject bidOpenCheck : bidOpenCheckColl) {
                        if (curBidOpen == null) {
                            curBidOpen = bidOpenCheck;
                            continue;
                        }
                        if (bidOpenCheck.getDate("auditdate") != null && curBidOpen.getDate("auditdate") != null && bidOpenCheck.getDate("auditdate").after(curBidOpen.getDate("auditdate"))) {
                            curBidOpen = bidOpenCheck;
                            continue;
                        }
                        if (bidOpenCheck.getDate("auditdate") == null || curBidOpen.getDate("auditdate") != null) continue;
                        curBidOpen = bidOpenCheck;
                    }
                    if (curBidOpen != null) {
                        bidOpen = "rebm".equals(appId) ? BusinessDataServiceHelper.loadSingle((Object)curBidOpen.getLong("id"), (String)"rebm_bidopen") : BusinessDataServiceHelper.loadSingle((Object)curBidOpen.getLong("id"), (String)"bid_bidopen");
                    }
                }
            }
            MainEntityType mainEntityType = null;
            mainEntityType = "rebm".equals(appId) ? EntityMetadataCache.getDataEntityType((String)"rebm_bidevaluation") : EntityMetadataCache.getDataEntityType((String)"bid_bidevaluation");
            DynamicObject bidEvaluation = new DynamicObject((DynamicObjectType)mainEntityType);
            bidEvaluation.set("org", (Object)bidProject.getDynamicObject("org"));
            bidEvaluation.set("currency", bidProject.get("currency"));
            HashMap<String, DynamicObject> creatorMap = BidProjectChgCreatorUtils.getCreator(bidProject);
            DynamicObject creatorTec = creatorMap.get("13");
            DynamicObject creatorCom = creatorMap.get("14");
            DynamicObject creator = creatorMap.get("07");
            bidEvaluation.set("creator", (Object)creator);
            if (bidOpen != null && !kd.bos.orm.util.StringUtils.isEmpty((Object)(opentype = bidOpen.getString("opentype")))) {
                if (opentype.equals("TECHNICAL")) {
                    bidEvaluation.set("creator", (Object)creatorTec);
                } else if (opentype.equals("BUSSINESS")) {
                    bidEvaluation.set("creator", (Object)(creatorCom == null ? creator : creatorCom));
                } else if (opentype.equals("MULTI")) {
                    bidEvaluation.set("creator", (Object)creator);
                }
            }
            if (bidOpen != null && bidOpen.getDynamicObject("bidproject") != null) {
                Object pkValue = bidOpen.getDynamicObject("bidproject").getPkValue();
                bidEvaluation.set("bidproject", (Object)BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"bidproject_f7"));
            }
            if (bidOpen != null) {
                DynamicObject bidevaluation;
                DynamicObject section;
                int i;
                bidEvaluation.set("billno", (Object)bidOpen.getDynamicObject("bidproject").getString("billno"));
                bidEvaluation.set("evaluatedecideway", (Object)bidOpen.getDynamicObject("evaluatedecideway"));
                bidEvaluation.set("evaluatedmethod", bidOpen.get("evaluatedmethod"));
                bidEvaluation.set("techweight", (Object)bidOpen.getBigDecimal("techweight"));
                bidEvaluation.set("commweight", (Object)bidOpen.getBigDecimal("comweight"));
                bidEvaluation.set("billstatus", (Object)BillStatusEnum.DISBEGIN.getVal());
                bidEvaluation.set("scoremethod", (Object)ScoreMethod.AVG_SCORE.getVal());
                bidEvaluation.set("bidprojectname", bidOpen.get("bidprojectname"));
                boolean isOnlineEval = bidOpen.getBoolean("isonlineeval");
                bidEvaluation.set("isonlineeval", (Object)isOnlineEval);
                if (isOnlineEval) {
                    bidEvaluation.set("scoretype", (Object)bidOpen.getString("scoretype"));
                }
                EntityType sectionEntityType = null;
                MainEntityType entryEntityType = null;
                MainEntityType scoreDetailEntityType = null;
                if ("rebm".equals(appId)) {
                    sectionEntityType = (EntityType)mainEntityType.getAllEntities().get("bidsection");
                    entryEntityType = EntityMetadataCache.getDataEntityType((String)"rebm_bidevaluationentry");
                    scoreDetailEntityType = EntityMetadataCache.getDataEntityType((String)"rebm_bidevalscoredetail");
                } else {
                    sectionEntityType = (EntityType)mainEntityType.getAllEntities().get("bidsection");
                    entryEntityType = EntityMetadataCache.getDataEntityType((String)"bid_bidevaluationentry");
                    scoreDetailEntityType = EntityMetadataCache.getDataEntityType((String)"bid_bidevalscoredetail");
                }
                DynamicObjectCollection sectionColl = new DynamicObjectCollection();
                ArrayList<DynamicObject> entryList = new ArrayList<DynamicObject>();
                ArrayList<DynamicObject> scoreDetailList = new ArrayList<DynamicObject>();
                HashBasedTable darkNameTable = HashBasedTable.create();
                if (bidOpen != null) {
                    boolean encEvaluation = BidDarkUtil.isDarkEvaluation((String)appId, (Object)bidOpen.getPkValue(), (String)bidOpen.getString("opentype"));
                    bidEvaluation.set("is_dark", (Object)encEvaluation);
                    if (encEvaluation) {
                        darkNameTable = BidDarkUtil.getEvaluationDark((String)appId, (Object)bidOpen.getPkValue());
                    }
                }
                DynamicObjectCollection bidSectionColl = bidOpen.getDynamicObjectCollection("bidsection");
                DynamicObjectCollection proficientColl = bidOpen.getDynamicObjectCollection("bidopen_proficient");
                for (i = 0; i < bidSectionColl.size(); ++i) {
                    DynamicObject bidSection = (DynamicObject)bidSectionColl.get(i);
                    String sectionName = bidSection.getString("sectionname");
                    section = new DynamicObject((DynamicObjectType)sectionEntityType);
                    section.set("seq", (Object)(i + 1));
                    section.set("sectionname", (Object)sectionName);
                    section.set("opensrcsectionid", bidSection.getPkValue());
                    sectionColl.add((Object)section);
                    DynamicObjectCollection supplierEntryColl = bidSection.getDynamicObjectCollection("supplierentry");
                    for (int j = 0; j < supplierEntryColl.size(); ++j) {
                        DynamicObject supplierEntry = (DynamicObject)supplierEntryColl.get(j);
                        if (supplierEntry.getBoolean("supplier_isinvalid") || !supplierEntry.getBoolean("supplier_istender")) continue;
                        DynamicObject supplier = supplierEntry.getDynamicObject("supplier");
                        DynamicObject entry = new DynamicObject((DynamicObjectType)entryEntityType);
                        entry.set("entryseq", (Object)(j + 1));
                        entry.set("bidevaluation", (Object)bidEvaluation);
                        entry.set("section", (Object)section);
                        entry.set("supplier", (Object)supplier);
                        if (darkNameTable != null) {
                            entry.set("dark_suppliername", darkNameTable.get((Object)sectionName, supplier.getPkValue()));
                        }
                        entry.set("contact", (Object)supplierEntry.getString("suppliercontact"));
                        entry.set("contactphone", (Object)supplierEntry.getString("contactphone"));
                        entry.set("source", (Object)supplierEntry.getLong("id"));
                        entryList.add(entry);
                        for (int k = 0; k < proficientColl.size(); ++k) {
                            DynamicObject proficient = (DynamicObject)proficientColl.get(k);
                            DynamicObject scoreDetail = new DynamicObject((DynamicObjectType)scoreDetailEntityType);
                            scoreDetail.set("entryseq", (Object)(k + 1));
                            scoreDetail.set("bidevaluationentry", (Object)entry);
                            scoreDetail.set("bidevaluation", (Object)bidEvaluation);
                            scoreDetail.set("proficient", (Object)proficient.getDynamicObject("proficient"));
                            scoreDetail.set("supplier", (Object)supplierEntry.getDynamicObject("supplier"));
                            if (darkNameTable != null) {
                                scoreDetail.set("dark_suppliername", darkNameTable.get((Object)sectionName, supplier.getPkValue()));
                            }
                            scoreDetail.set("section", (Object)section);
                            scoreDetail.set("technical", (Object)proficient.getBoolean("proficient_technical"));
                            scoreDetail.set("commercial", (Object)proficient.getBoolean("proficient_commercial"));
                            scoreDetailList.add(scoreDetail);
                        }
                    }
                }
                bidEvaluation.set("bidsection", (Object)sectionColl);
                bidEvaluation.set("evaltype", (Object)bidOpen.getString("opentype"));
                EntityTypeHelper.setEntityType(bidEvaluation, "bid_bidevaluation", "bidproject");
                this.setHistoryData(bidEvaluation, bidOpen);
                this.saveBidEvaluation(bidEvaluation);
                for (i = 0; i < entryList.size(); ++i) {
                    DynamicObject entry = (DynamicObject)entryList.get(i);
                    bidevaluation = (DynamicObject)entry.get("bidevaluation");
                    entry.set("bidevaluation", (Object)bidevaluation);
                    section = (DynamicObject)entry.get("section");
                    entry.set("section", (Object)section);
                }
                this.saveBidEvaluationEntry(entryList);
                for (i = 0; i < scoreDetailList.size(); ++i) {
                    DynamicObject scoreDetail = (DynamicObject)scoreDetailList.get(i);
                    bidevaluation = (DynamicObject)scoreDetail.get("bidevaluation");
                    scoreDetail.set("bidevaluation", (Object)bidevaluation);
                    section = (DynamicObject)scoreDetail.get("section");
                    scoreDetail.set("section", (Object)section);
                    DynamicObject bidevaluationentry = (DynamicObject)scoreDetail.get("bidevaluationentry");
                    scoreDetail.set("bidevaluationentry", (Object)bidevaluationentry);
                }
                this.saveBidEvalScoreDetail(scoreDetailList);
            }
        }
    }

    public void sendMessage(DynamicObject bidProjectF7, String evaltype) {
        DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProjectF7.getPkValue(), (String)FormTypeConstants.getFormConstant((String)"project", this.getClass()));
        String appid = bidProject.getString("entitytypeid").split("_")[0];
        boolean enable = SystemParamHelper.getSystemParameter((String)appid, (Long)OrgUnitHelper.ROOT_ORG_ID, (String)"msg");
        if (!enable) {
            return;
        }
        DynamicObject bidEvaluation = BusinessDataServiceHelper.loadSingle((String)FormTypeConstants.getFormConstant((String)"bidevaluation", this.getClass()), (String)"id", (QFilter[])new QFilter[]{new QFilter("bidproject.id", "=", bidProject.getPkValue()), new QFilter("evaltype", "=", (Object)evaltype), new QFilter("billstatus", "!=", (Object)"XX")});
        if (bidEvaluation != null) {
            HashMap<String, Object> msgParam = new HashMap<String, Object>();
            msgParam.put("id", bidEvaluation.getPkValue());
            msgParam.put("pkId", bidEvaluation.getPkValue());
            msgParam.put("title", null);
            msgParam.put("operation", "save");
            msgParam.put("urlParams", Arrays.asList("formId", "pkId"));
            DynamicObjectCollection memberColl = bidProject.getDynamicObjectCollection("memberentity");
            HashSet<DynamicObject> memberSet = new HashSet<DynamicObject>();
            ArrayList<Long> receiveUserIds = new ArrayList<Long>();
            for (DynamicObject member : memberColl) {
                String[] values;
                if (member.getString("respbusiness") == null || (values = member.getString("respbusiness").split(",")) == null || values.length <= 0) continue;
                for (int m = 0; m < values.length; ++m) {
                    if ("07".equals(values[m])) {
                        memberSet.add(member.getDynamicObject("user"));
                    }
                    if ("13".equals(values[m]) && evaltype.equals("TECHNICAL")) {
                        memberSet.add(member.getDynamicObject("user"));
                    }
                    if (!"14".equals(values[m]) || !evaltype.equals("BUSSINESS")) continue;
                    memberSet.add(member.getDynamicObject("user"));
                }
            }
            if (!memberSet.isEmpty()) {
                for (DynamicObject set : memberSet) {
                    receiveUserIds.add(set.getLong("id"));
                }
            }
            msgParam.put("msgentity", "bid_bidevaluation");
            String notifyTypes = null;
            if (evaltype.equals(BidOpenTypeEnum.BUSSINESS.getValue())) {
                msgParam.put("tplScene", "createbidbueval");
                msgParam.put("appId", appid);
                notifyTypes = MessageChannelUtil.getNotifyType((String)"createbidbueval", (String)"bid_bidevaluation");
            } else if (evaltype.equals(BidOpenTypeEnum.TECHNICAL.getValue())) {
                msgParam.put("tplScene", "createbidteeval");
                msgParam.put("appId", appid);
                notifyTypes = MessageChannelUtil.getNotifyType((String)"createbidteeval", (String)"bid_bidevaluation");
            } else {
                msgParam.put("tplScene", "createbiduneval");
                msgParam.put("appId", appid);
                notifyTypes = MessageChannelUtil.getNotifyType((String)"createbiduneval", (String)"bid_bidevaluation");
            }
            if ("bid".equals(appid)) {
                msgParam.put("formId", "bid_bidevaluation");
            } else {
                msgParam.put("formId", "rebm_bidevaluation");
            }
            msgParam.put("content", null);
            MessageCenterHelper.sendMessagesToOpetator(msgParam, (boolean)true, receiveUserIds, (String)notifyTypes);
        }
    }

    @Override
    public DynamicObject getBidEvaluation(Long bidEvaluationId) {
        DynamicObject bidEvaluation = BusinessDataServiceHelper.loadSingle((Object)bidEvaluationId, (String)"bid_bidevaluation");
        return bidEvaluation;
    }

    @Override
    public DynamicObjectCollection listBidEvaluationEntrys(Long bidEvaluationId, String selectFields) {
        DynamicObject bidEvaluation = QueryServiceHelper.queryOne((String)"bid_bidevaluation", (String)"id,entitytypeid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)bidEvaluationId)});
        String appId = bidEvaluation.getString("entitytypeid").split("_")[0];
        if ("rebm".equals(appId)) {
            QFilter qFilter = new QFilter("bidevaluation", "=", (Object)bidEvaluationId);
            return QueryServiceHelper.query((String)"rebm_bidevaluationentry", (String)selectFields, (QFilter[])new QFilter[]{qFilter});
        }
        QFilter qFilter = new QFilter("bidevaluation", "=", (Object)bidEvaluationId);
        return QueryServiceHelper.query((String)"bid_bidevaluationentry", (String)selectFields, (QFilter[])new QFilter[]{qFilter});
    }

    @Override
    public DynamicObjectCollection listBidEvalEntryBySections(Long sectionId, String selectFields) {
        DynamicObject bidEvaluation = QueryServiceHelper.queryOne((String)"bid_bidevaluation", (String)"id,entitytypeid", (QFilter[])new QFilter[]{new QFilter("bidsection.id", "=", (Object)sectionId)});
        if (bidEvaluation == null) {
            return null;
        }
        Set<Object> outSupplier = this.getOutSupplier(sectionId);
        QFilter supplierQFilter = null;
        if (outSupplier.size() > 0) {
            supplierQFilter = new QFilter("supplier", "not in", outSupplier);
        }
        String appId = bidEvaluation.getString("entitytypeid").split("_")[0];
        String formId = "bid_bidevaluationentry";
        if (kd.bos.orm.util.StringUtils.pathEquals((String)"rebm", (String)appId)) {
            formId = "rebm_bidevaluationentry";
        }
        QFilter qFilter = new QFilter("section", "=", (Object)sectionId);
        if (supplierQFilter != null) {
            return QueryServiceHelper.query((String)formId, (String)selectFields, (QFilter[])new QFilter[]{qFilter, supplierQFilter}, (String)"entryseq");
        }
        return QueryServiceHelper.query((String)formId, (String)selectFields, (QFilter[])new QFilter[]{qFilter}, (String)"entryseq");
    }

    @Override
    public DynamicObjectCollection listBidEvalScoreDetails(Long bidEvaluationId, String selectFields) {
        DynamicObject bidEvaluation = QueryServiceHelper.queryOne((String)"bid_bidevaluation", (String)"id,entitytypeid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)bidEvaluationId)});
        String appId = bidEvaluation.getString("entitytypeid").split("_")[0];
        if ("rebm".equals(appId)) {
            QFilter qFilter = new QFilter("bidevaluation", "=", (Object)bidEvaluationId);
            return QueryServiceHelper.query((String)"rebm_bidevalscoredetail", (String)selectFields, (QFilter[])new QFilter[]{qFilter});
        }
        QFilter qFilter = new QFilter("bidevaluation", "=", (Object)bidEvaluationId);
        return QueryServiceHelper.query((String)"bid_bidevalscoredetail", (String)selectFields, (QFilter[])new QFilter[]{qFilter});
    }

    @Override
    public DynamicObjectCollection listBidEvalScoreDetailBySections(Long sectionId, String selectFields) {
        DynamicObject bidEvaluation = QueryServiceHelper.queryOne((String)"bid_bidevaluation", (String)"id,entitytypeid", (QFilter[])new QFilter[]{new QFilter("bidsection.id", "=", (Object)sectionId)});
        String appId = bidEvaluation.getString("entitytypeid").split("_")[0];
        Set<Object> outSupplier = this.getOutSupplier(sectionId);
        QFilter supplierQFilter = null;
        if (outSupplier.size() > 0) {
            supplierQFilter = new QFilter("supplier", "not in", outSupplier);
        }
        String formId = "bid_bidevalscoredetail";
        QFilter qFilter = new QFilter("section", "=", (Object)sectionId);
        if ("rebm".equals(appId)) {
            formId = "rebm_bidevalscoredetail";
        }
        if (supplierQFilter != null) {
            return QueryServiceHelper.query((String)formId, (String)selectFields, (QFilter[])new QFilter[]{qFilter, supplierQFilter}, (String)"entryseq");
        }
        return QueryServiceHelper.query((String)formId, (String)selectFields, (QFilter[])new QFilter[]{qFilter}, (String)"entryseq");
    }

    public Set<Object> getOutSupplier(Long sectionId) {
        DynamicObject[] bidEvaluations = BusinessDataServiceHelper.load((String)"bid_bidevaluation", (String)"id,entitytypeid,bidsection,bidsection.sectionname,bidsection.opensrcsectionid,bidopenid,evaltype", (QFilter[])new QFilter[]{new QFilter("bidsection.id", "=", (Object)sectionId)});
        HashSet<Object> outSupplierIdSet = new HashSet<Object>();
        String senctionName = "";
        Long bidOpenId = 0L;
        DynamicObject bidEvaluation = bidEvaluations[0];
        DynamicObjectCollection bidsections = bidEvaluation.getDynamicObjectCollection("bidsection");
        bidOpenId = bidEvaluation.getLong("bidopenid");
        for (DynamicObject bidsection : bidsections) {
            if (!StringUtils.equals((CharSequence)sectionId.toString(), (CharSequence)bidsection.getPkValue().toString())) continue;
            senctionName = bidsection.getString("sectionname");
            break;
        }
        String appId = bidEvaluation.getString("entitytypeid").split("_")[0];
        DynamicObject bidOpenDyn = null;
        bidOpenDyn = "rebm".equals(appId) ? BusinessDataServiceHelper.loadSingle((Object)bidOpenId, (String)"rebm_bidopen") : BusinessDataServiceHelper.loadSingle((Object)bidOpenId, (String)"bid_bidopen");
        String evalType = bidEvaluation.getString("evaltype");
        String techEvalResult = ResManager.loadKDString((String)"\u6280\u672f\u6807\u8bc4\u6807\u4e0d\u5408\u683c", (String)"BidEvaluationServiceImpl_50", (String)"scm-bid-business", (Object[])new Object[0]);
        String busEvalResult = ResManager.loadKDString((String)"\u5546\u52a1\u6807\u8bc4\u6807\u4e0d\u5408\u683c", (String)"BidEvaluationServiceImpl_51", (String)"scm-bid-business", (Object[])new Object[0]);
        DynamicObjectCollection bidsection_DOC = bidOpenDyn.getDynamicObjectCollection("bidsection");
        for (DynamicObject bidsection_DO : bidsection_DOC) {
            String bidopSection = bidsection_DO.getString("sectionname");
            if (!StringUtils.equals((CharSequence)bidopSection, (CharSequence)senctionName)) continue;
            DynamicObjectCollection supplierEntry_DOC = bidsection_DO.getDynamicObjectCollection("supplierentry");
            for (DynamicObject supplierEntry_DO : supplierEntry_DOC) {
                boolean openOutFlag;
                boolean evalOutFlag;
                boolean isTender = supplierEntry_DO.getBoolean("supplier_istender");
                boolean openOut = supplierEntry_DO.getBoolean("supplier_isinvalid");
                boolean evalOut = supplierEntry_DO.getBoolean("evalsupplierinvalid");
                String evalResult = supplierEntry_DO.getString("supplier_invalidreason");
                Object supplierId = supplierEntry_DO.getDynamicObject("supplier").getPkValue();
                if ("MULTI".equals(evalType)) {
                    if (!isTender) {
                        outSupplierIdSet.add(supplierId);
                    }
                    if (evalOut || !openOut) continue;
                    outSupplierIdSet.add(supplierId);
                    continue;
                }
                if ("BUSSINESS".equals(evalType)) {
                    if (!isTender) {
                        outSupplierIdSet.add(supplierId);
                        continue;
                    }
                    evalOutFlag = evalOut && openOut && techEvalResult.equals(evalResult);
                    boolean bl = openOutFlag = !evalOut && openOut;
                    if (!evalOutFlag && !openOutFlag) continue;
                    outSupplierIdSet.add(supplierId);
                    continue;
                }
                if (!"TECHNICAL".equals(evalType)) continue;
                if (!isTender) {
                    outSupplierIdSet.add(supplierId);
                    continue;
                }
                evalOutFlag = evalOut && openOut && busEvalResult.equals(evalResult);
                boolean bl = openOutFlag = !evalOut && openOut;
                if (!evalOutFlag && !openOutFlag) continue;
                outSupplierIdSet.add(supplierId);
            }
        }
        return outSupplierIdSet;
    }

    @Override
    public DynamicObject getPriceClarify(Long bidEvaluationId, String selectFields) {
        QFilter qFilter = new QFilter("bidevaluation", "=", (Object)bidEvaluationId);
        DynamicObject priceClarify = QueryServiceHelper.queryOne((String)"bid_priceclarify", (String)selectFields, (QFilter[])new QFilter[]{qFilter});
        return priceClarify;
    }

    @Override
    public void saveSupplierScoreDetail(List<HashMap<String, Object>> scoreDetailDataList, List<HashMap<String, Object>> entryDataList) {
        Long sectionId;
        HashMap<String, Object> dataMap;
        int i;
        ArrayList<DynamicObject> saveScoreDetailDataList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> saveEntryDataList = new ArrayList<DynamicObject>();
        for (i = 0; i < scoreDetailDataList.size(); ++i) {
            dataMap = scoreDetailDataList.get(i);
            sectionId = (Long)dataMap.get("section");
            Long proficientId = (Long)dataMap.get("proficientid");
            Long supplierId = Long.parseLong(dataMap.get("supplierid_").toString());
            Object commercialScore = dataMap.get("commercial_");
            Object technicalScore = dataMap.get("technical_");
            String selectProperties = "id";
            QFilter[] filters = new QFilter[]{new QFilter("proficient", "=", (Object)proficientId), new QFilter("supplier", "=", (Object)supplierId), new QFilter("section", "=", (Object)sectionId)};
            DynamicObject bidEvaluation = QueryServiceHelper.queryOne((String)"bid_bidevaluation", (String)"id,entitytypeid", (QFilter[])new QFilter[]{new QFilter("bidsection.id", "=", (Object)sectionId)});
            String appId = bidEvaluation.getString("entitytypeid").split("_")[0];
            DynamicObject bidEvalScoreDetail = null;
            bidEvalScoreDetail = "rebm".equals(appId) ? QueryServiceHelper.queryOne((String)"rebm_bidevalscoredetail", (String)selectProperties, (QFilter[])filters) : QueryServiceHelper.queryOne((String)"bid_bidevalscoredetail", (String)selectProperties, (QFilter[])filters);
            if (bidEvalScoreDetail == null) continue;
            DynamicObject data = BusinessDataServiceHelper.loadSingle((Object)bidEvalScoreDetail.getLong("id"), (String)"bid_bidevalscoredetail");
            data.set("commercialscore", commercialScore);
            data.set("technicalscore", technicalScore);
            saveScoreDetailDataList.add(data);
        }
        for (i = 0; i < entryDataList.size(); ++i) {
            dataMap = entryDataList.get(i);
            sectionId = (Long)dataMap.get("section");
            Long supplierId = 0L;
            if (dataMap.get("supplierid_") != null) {
                String idStr = dataMap.get("supplierid_").toString();
                supplierId = Long.parseLong(idStr);
            }
            Object score = dataMap.get("commercial_");
            String selectProperties = "id";
            QFilter[] filters = new QFilter[]{new QFilter("supplier", "=", (Object)supplierId), new QFilter("section", "=", (Object)sectionId)};
            DynamicObject bidEvaluation = QueryServiceHelper.queryOne((String)"bid_bidevaluation", (String)"id,entitytypeid", (QFilter[])new QFilter[]{new QFilter("bidsection.id", "=", (Object)sectionId)});
            String appId = bidEvaluation.getString("entitytypeid").split("_")[0];
            Object bidEvalScoreDetail = null;
            DynamicObject bidEvaluationEntry = null;
            bidEvaluationEntry = "rebm".equals(appId) ? QueryServiceHelper.queryOne((String)"rebm_bidevaluationentry", (String)selectProperties, (QFilter[])filters) : QueryServiceHelper.queryOne((String)"bid_bidevaluationentry", (String)selectProperties, (QFilter[])filters);
            if (bidEvaluationEntry == null) continue;
            DynamicObject data = BusinessDataServiceHelper.loadSingle((Object)bidEvaluationEntry.getLong("id"), (String)"bid_bidevaluationentry");
            data.set("score", score);
            saveEntryDataList.add(data);
        }
        if (saveScoreDetailDataList.size() > 0) {
            BusinessDataServiceHelper.save((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bid_bidevalscoredetail"), (Object[])saveScoreDetailDataList.toArray());
        }
        if (saveEntryDataList.size() > 0) {
            BusinessDataServiceHelper.save((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bid_bidevaluationentry"), (Object[])saveEntryDataList.toArray());
        }
    }

    @Override
    public void saveBidEvaluation(DynamicObject bidEvaluation) {
        if (bidEvaluation != null) {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bidEvaluation});
        }
    }

    private void setHistoryData(DynamicObject bidEvaluation, DynamicObject bidOpen) {
        DynamicObject bidproject = bidOpen.getDynamicObject("bidproject");
        Object bidprojectId = bidproject.getPkValue();
        QFilter filter1 = new QFilter("bidproject.id", "=", bidprojectId);
        QFilter filter3 = new QFilter("billstatus", "=", (Object)BillStatusEnum.INVALIDXX.getVal());
        String evaltype = bidEvaluation.getString("evaltype");
        QFilter filter4 = new QFilter("evaltype", "=", (Object)evaltype);
        String evaluationEntryName = null;
        evaluationEntryName = bidproject.getDataEntityType().getName().startsWith("bid") ? "bid_bidevaluation" : "rebm_bidevaluation";
        DynamicObject[] bidevaluationHistoryColl = BusinessDataServiceHelper.load((String)evaluationEntryName, (String)"rounds,createtime", (QFilter[])new QFilter[]{filter1, filter3, filter4}, (String)"createtime desc");
        bidEvaluation.set("supplierinvitationid", bidOpen.get("supplierinvitationid"));
        bidEvaluation.set("bidpublishid", bidOpen.get("bidpublishid"));
        bidEvaluation.set("bidopenid", bidOpen.get("id"));
        String billUtil_44 = String.format(ResManager.loadKDString((String)"\u7b2c%s\u8f6e\u8bc4\u6807", (String)"BidEvaluationServiceImpl_52", (String)"scm-bid-business", (Object[])new Object[0]), BidEvaluationServiceImpl.toChinese(String.valueOf(bidevaluationHistoryColl.length + 1)));
        bidEvaluation.set("listrounds", (Object)billUtil_44);
        if (bidevaluationHistoryColl.length != 0) {
            Object bidEvaluationId = bidevaluationHistoryColl[0].get("id");
            bidEvaluation.set("sourcebillid", bidEvaluationId);
        }
    }

    private static String toChinese(String str) {
        String[] s1 = new String[]{ResManager.loadKDString((String)"\u96f6", (String)"BidEvaluationServiceImpl_0", (String)"scm-bid-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e00", (String)"BidEvaluationServiceImpl_1", (String)"scm-bid-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e8c", (String)"BidEvaluationServiceImpl_2", (String)"scm-bid-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e09", (String)"BidEvaluationServiceImpl_3", (String)"scm-bid-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u56db", (String)"BidEvaluationServiceImpl_4", (String)"scm-bid-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e94", (String)"BidEvaluationServiceImpl_5", (String)"scm-bid-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u516d", (String)"BidEvaluationServiceImpl_6", (String)"scm-bid-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e03", (String)"BidEvaluationServiceImpl_7", (String)"scm-bid-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u516b", (String)"BidEvaluationServiceImpl_8", (String)"scm-bid-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e5d", (String)"BidEvaluationServiceImpl_9", (String)"scm-bid-business", (Object[])new Object[0])};
        String[] s2 = new String[]{ResManager.loadKDString((String)"\u5341", (String)"BidEvaluationServiceImpl_10", (String)"scm-bid-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u767e", (String)"BidEvaluationServiceImpl_11", (String)"scm-bid-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5343", (String)"BidEvaluationServiceImpl_12", (String)"scm-bid-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e07", (String)"BidEvaluationServiceImpl_13", (String)"scm-bid-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5341", (String)"BidEvaluationServiceImpl_10", (String)"scm-bid-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u767e", (String)"BidEvaluationServiceImpl_11", (String)"scm-bid-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5343", (String)"BidEvaluationServiceImpl_12", (String)"scm-bid-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4ebf", (String)"BidEvaluationServiceImpl_14", (String)"scm-bid-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5341", (String)"BidEvaluationServiceImpl_10", (String)"scm-bid-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u767e", (String)"BidEvaluationServiceImpl_11", (String)"scm-bid-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5343", (String)"BidEvaluationServiceImpl_12", (String)"scm-bid-business", (Object[])new Object[0])};
        StringBuilder result = new StringBuilder();
        int n = str.length();
        for (int i = 0; i < n; ++i) {
            int num = str.charAt(i) - 48;
            if (i != n - 1 && num != 0) {
                String temp = s1[num] + s2[n - 2 - i];
                result.append(temp);
                continue;
            }
            result.append(s1[num]);
        }
        return result.toString();
    }

    @Override
    public void saveBidEvaluationEntry(List<DynamicObject> entryList) {
        if (entryList != null && entryList.size() > 0) {
            Object[] entryArr = new DynamicObject[entryList.size()];
            entryList.toArray(entryArr);
            BusinessDataServiceHelper.save((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bid_bidevaluationentry"), (Object[])entryArr);
        }
    }

    @Override
    public void saveBidEvalScoreDetail(List<DynamicObject> scoreDetailList) {
        if (scoreDetailList != null && scoreDetailList.size() > 0) {
            Object[] scoreDetailArr = new DynamicObject[scoreDetailList.size()];
            scoreDetailList.toArray(scoreDetailArr);
            BusinessDataServiceHelper.save((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bid_bidevalscoredetail"), (Object[])scoreDetailArr);
        }
    }

    @Override
    public void deleteBidEvaluationEntry(Long bidevaluationId) {
        QFilter qFilter = new QFilter("bidevaluation", "=", (Object)bidevaluationId);
        Object[] objectArr = BusinessDataServiceHelper.load((String)"bid_bidevaluationentry", (String)"id", (QFilter[])new QFilter[]{qFilter});
        BusinessDataServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bid_bidevaluationentry"), (Object[])objectArr);
    }

    @Override
    public void deleteBidEvalScoreDetail(Long bidevaluationId) {
        QFilter qFilter = new QFilter("bidevaluation", "=", (Object)bidevaluationId);
        Object[] objectArr = BusinessDataServiceHelper.load((String)"bid_bidevalscoredetail", (String)"id", (QFilter[])new QFilter[]{qFilter});
        BusinessDataServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bid_bidevalscoredetail"), (Object[])objectArr);
    }

    @Override
    public Long savePriceClarify(DynamicObject priceClarify) {
        if (priceClarify != null) {
            DynamicObject[] dynamicObjectArr = (DynamicObject[])BusinessDataServiceHelper.save((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bid_priceclarify"), (Object[])new DynamicObject[]{priceClarify});
            return (Long)dynamicObjectArr[0].get("id");
        }
        return null;
    }

    @Override
    public String getFormId() {
        return "bid_bidevaluation";
    }

    @Override
    public DynamicObject getEvaluationByProjectId(Long projectId, String selectedFields) {
        QFilter qFilter = new QFilter("bidproject.id", "=", (Object)projectId);
        return QueryServiceHelper.queryOne((String)"bid_bidevaluation", (String)selectedFields, (QFilter[])new QFilter[]{qFilter});
    }

    @Override
    public boolean checkIsExistUnAuidtedOnlineBidEval(DynamicObject bidProject) {
        if (bidProject == null || bidProject.get("id") == null) {
            return false;
        }
        Object bidProjectPk = bidProject.getPkValue();
        QFilter qFilter1 = new QFilter("bidproject.id", "=", bidProjectPk);
        QFilter qFilter2 = new QFilter("billstatus", "=", (Object)BillStatusEnum.DISBEGIN.getVal());
        qFilter2.or(new QFilter("billstatus", "=", (Object)BillStatusEnum.SAVE.getVal()));
        qFilter2.or(new QFilter("billstatus", "=", (Object)BillStatusEnum.SUBMIT.getVal()));
        qFilter1.and(qFilter2);
        QFilter[] qFilters = new QFilter[]{qFilter1};
        boolean flag = QueryServiceHelper.exists((String)"bid_onlinebideval", (QFilter[])qFilters);
        return flag;
    }

    @Override
    public DynamicObject getDataFromlatestData(Object bidProjectId, Object supplierId, boolean enablemultisection, String sectionName) {
        QFilter[] fs = new QFilter[]{new QFilter("bidProject", "=", bidProjectId).and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDITED.getVal()))};
        DynamicObject evaluation = BusinessDataServiceHelper.loadSingle((String)"bid_bidevaluation", (String)"id", (QFilter[])fs);
        if (evaluation == null) {
            return null;
        }
        QFilter bidProjectFilter = new QFilter("bidproject", "=", bidProjectId);
        QFilter evaluationFilter = new QFilter("bidevaluationid", "=", evaluation.getPkValue());
        DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)bidProjectId, (String)"bid_project");
        String entryEntity = project.getString("entitytypeid");
        QFilter supplierFilter = new QFilter("clarifysupplier", "like", (Object)(supplierId + "%"));
        if (enablemultisection) {
            supplierFilter.and(new QFilter("clarifysupplier", "like", (Object)("%" + sectionName)));
        }
        QFilter billstatusFilter = new QFilter("billstatus", "=", (Object)ClarifyStatusEnum.CLARIFIED.getValue());
        QFilter clarifyTypeFilter = new QFilter("clarifytype", "=", (Object)BidOpenTypeEnum.BUSSINESS.getValue()).or(new QFilter("clarifytype", "=", (Object)BidOpenTypeEnum.MULTI.getValue()));
        QFilter resubmisstendersFilter = new QFilter("resubmisstenders", "=", (Object)Boolean.TRUE);
        String orderBys = "submitdate desc";
        int top = 1;
        String questionclarify = null;
        questionclarify = "bid_project".equals(entryEntity) ? "bid_questionclarify" : "rebm_questionclarify";
        DynamicObject[] latestDatas = BusinessDataServiceHelper.load((String)questionclarify, (String)"id,tenderprice,pricevat,tax,notaxtenderprice,rate,bidsection,bidsection.sectionname,is_again_bidding,submitdate,supplierdetail,supplierdetail.pursupplier,supplierdetail.purentrycontent,supplierdetail.purentryproject,supplierdetail.materialid,supplierdetail.materialdes,supplierdetail.inclutaxprice,supplierdetail.inclutaxamount,supplierdetail.taxrate,supplierdetail.taxamount,supplierdetail.excepttaxamount,supplierdetail.costrate", (QFilter[])new QFilter[]{bidProjectFilter, supplierFilter, clarifyTypeFilter, billstatusFilter, resubmisstendersFilter, evaluationFilter}, (String)orderBys, (int)top);
        if (latestDatas.length > 0) {
            DynamicObject latestData = latestDatas[0];
            return latestData;
        }
        return null;
    }

    @Override
    public DynamicObject getBusinessDataFromLatestData(Object bidProjectId, Object supplierId, boolean enablemultisection, String sectionName) {
        DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)bidProjectId, (String)"bid_project");
        String bidOpenType = project.getString("bidopentype");
        DynamicObject evaluation = null;
        QFilter[] evaluationFilterArray = null;
        if ("UNIONOPEN".equals(bidOpenType)) {
            evaluationFilterArray = new QFilter[]{new QFilter("bidProject", "=", bidProjectId).and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDITED.getVal()))};
            evaluation = BusinessDataServiceHelper.loadSingle((String)"bid_bidevaluation", (String)"id", (QFilter[])evaluationFilterArray);
        } else {
            evaluationFilterArray = new QFilter[]{new QFilter("bidProject", "=", bidProjectId).and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDITED.getVal())).and(new QFilter("evaltype", "=", (Object)BidOpenTypeEnum.BUSSINESS.getValue()))};
            evaluation = BusinessDataServiceHelper.loadSingle((String)"bid_bidevaluation", (String)"id", (QFilter[])evaluationFilterArray);
        }
        if (evaluation == null) {
            return null;
        }
        QFilter bidProjectFilter = new QFilter("bidproject", "=", bidProjectId);
        QFilter evaluationFilter = new QFilter("bidevaluationid", "=", evaluation.getPkValue());
        String entryEntity = project.getString("entitytypeid");
        QFilter supplierFilter = new QFilter("clarifysupplier", "like", (Object)(supplierId + "%"));
        if (enablemultisection) {
            supplierFilter.and(new QFilter("clarifysupplier", "like", (Object)("%" + sectionName)));
        }
        QFilter billstatusFilter = new QFilter("billstatus", "=", (Object)ClarifyStatusEnum.CLARIFIED.getValue());
        QFilter clarifyTypeFilter = new QFilter("clarifytype", "=", (Object)BidOpenTypeEnum.BUSSINESS.getValue()).or(new QFilter("clarifytype", "=", (Object)BidOpenTypeEnum.MULTI.getValue()));
        QFilter resubmisstendersFilter = new QFilter("resubmisstenders", "=", (Object)Boolean.TRUE);
        String orderBys = "submitdate desc";
        int top = 1;
        String questionclarify = null;
        questionclarify = "bid_project".equals(entryEntity) ? "bid_questionclarify" : "rebm_questionclarify";
        DynamicObject[] latestDatas = BusinessDataServiceHelper.load((String)questionclarify, (String)"id,tenderprice,pricevat,tax,notaxtenderprice,rate,bidsection,bidsection.sectionname,is_again_bidding,submitdate,supplierdetail,supplierdetail.pursupplier,supplierdetail.purentrycontent,supplierdetail.purentryproject,supplierdetail.resourceitem,supplierdetail.materialid,supplierdetail.materialdes,supplierdetail.inclutaxprice,supplierdetail.inclutaxamount,supplierdetail.taxrate,supplierdetail.bd_taxrate,supplierdetail.taxamount,supplierdetail.excepttaxamount,supplierdetail.costrate", (QFilter[])new QFilter[]{bidProjectFilter, supplierFilter, clarifyTypeFilter, billstatusFilter, resubmisstendersFilter, evaluationFilter}, (String)orderBys, (int)top);
        if (latestDatas.length > 0) {
            DynamicObject latestData = latestDatas[0];
            return latestData;
        }
        return null;
    }

    @Override
    public Map<String, Object> getOnlineEvalResult(String appId, QFilter[] qFilters) {
        DynamicObject[] onlineEvalArray = BusinessDataServiceHelper.load((String)(appId + "_onlinebideval"), (String)"bidevaluator,bidsectionenroll,bidsectionenroll.sectionname2,bidsectionenroll.opensectionid,supplierentry,supplierentry.supplier,  supplierentry.techevalresult,supplierentry.bsevalresult", (QFilter[])qFilters);
        HashMap<String, Object> evalResultMap = new HashMap<String, Object>();
        HashMap onlineEvalEvaluatorMap = new HashMap();
        TreeSet<String> evaluatorIdSet = new TreeSet<String>();
        for (DynamicObject onlineEval : onlineEvalArray) {
            String evaluatorId = onlineEval.getDynamicObject("bidevaluator").getString("id");
            DynamicObjectCollection bidSectionColl = onlineEval.getDynamicObjectCollection("bidsectionenroll");
            for (DynamicObject bidSection : bidSectionColl) {
                String openSrcSectionId = bidSection.getString("opensectionid");
                DynamicObjectCollection supplierEntryCol = bidSection.getDynamicObjectCollection("supplierentry");
                for (DynamicObject supplierEntry : supplierEntryCol) {
                    List<String> bsResultList;
                    String supplierId = supplierEntry.getDynamicObject("supplier").getString("id");
                    String techEvalResult = supplierEntry.getString("techevalresult");
                    String techProficientIdKey = "proficient_tech_" + openSrcSectionId + "_" + evaluatorId + "_" + supplierId;
                    evalResultMap.put(techProficientIdKey, techEvalResult);
                    String bsEvalResult = supplierEntry.getString("bsevalresult");
                    String bsProficientIdKey = "proficient_bus_" + openSrcSectionId + "_" + evaluatorId + "_" + supplierId;
                    evalResultMap.put(bsProficientIdKey, bsEvalResult);
                    String supplierTechKey = "proficient_tech_" + openSrcSectionId + "_" + supplierId;
                    String supplierBusKey = "proficient_bus_" + openSrcSectionId + "_" + supplierId;
                    if (CollectionUtils.isEmpty(onlineEvalEvaluatorMap) || !onlineEvalEvaluatorMap.containsKey(supplierTechKey)) {
                        ArrayList<String> techResultList = new ArrayList<String>();
                        techResultList.add(supplierEntry.getString("techevalresult"));
                        onlineEvalEvaluatorMap.put(supplierTechKey, techResultList);
                    } else {
                        List techResult = (List)onlineEvalEvaluatorMap.get(supplierTechKey);
                        techResult.add(supplierEntry.getString("techevalresult"));
                        onlineEvalEvaluatorMap.put(supplierTechKey, techResult);
                    }
                    if (CollectionUtils.isEmpty(onlineEvalEvaluatorMap) || !onlineEvalEvaluatorMap.containsKey(supplierBusKey)) {
                        bsResultList = new ArrayList<String>();
                        bsResultList.add(supplierEntry.getString("bsevalresult"));
                        onlineEvalEvaluatorMap.put(supplierBusKey, bsResultList);
                        continue;
                    }
                    bsResultList = (List)onlineEvalEvaluatorMap.get(supplierBusKey);
                    bsResultList.add(supplierEntry.getString("bsevalresult"));
                    onlineEvalEvaluatorMap.put(supplierBusKey, bsResultList);
                }
            }
            evaluatorIdSet.add(evaluatorId);
        }
        if (!CollectionUtils.isEmpty(evaluatorIdSet)) {
            evalResultMap.put("evaluatorIdSet", evaluatorIdSet);
        }
        if (!CollectionUtils.isEmpty(onlineEvalEvaluatorMap)) {
            for (Map.Entry entry : onlineEvalEvaluatorMap.entrySet()) {
                List resultList = (List)entry.getValue();
                String key = (String)entry.getKey();
                if (CollectionUtils.isEmpty((Collection)resultList)) continue;
                if (resultList.contains("0")) {
                    evalResultMap.put(key, "0");
                    continue;
                }
                evalResultMap.put(key, "1");
            }
        }
        return evalResultMap;
    }

    @Override
    public void updateEvalScoreDataByOnlineBidEvel(DynamicObject bidEvaluation) {
        OnlineBidEvalServiceImpl onlineBidEvalService = new OnlineBidEvalServiceImpl();
        DynamicObject bidProject = bidEvaluation.getDynamicObject("bidproject");
        String evalType = bidEvaluation.getString("evaltype");
        DynamicObject[] onlineBidEvalArr = onlineBidEvalService.listOnlineBidEvalByProjectId(bidProject.getLong("id"));
        ArrayList<Long> onlineBidEvalIdList = new ArrayList<Long>();
        for (int j = 0; j < onlineBidEvalArr.length; ++j) {
            DynamicObject onlineBidEval = onlineBidEvalArr[j];
            if (!BillStatusEnum.AUDITED.getVal().equals(onlineBidEval.getString("billstatus"))) continue;
            onlineBidEvalIdList.add(onlineBidEval.getLong("id"));
        }
        if (!onlineBidEvalIdList.isEmpty()) {
            onlineBidEvalService.updateBidEvaluationSupplierScore(bidProject, onlineBidEvalIdList, evalType);
        }
    }
}

