/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.business.bill.serviceImpl;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.id.ID;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.business.basedata.serviceImpl.BidServiceImpl;
import kd.scm.bid.business.bill.IBidPayService;
import kd.scm.bid.common.enums.BidOpenSelectTypeEnum;
import kd.scm.bid.common.enums.BidOpenTypeEnum;
import kd.scm.bid.common.enums.BillStatusEnum;
import kd.scm.bid.common.enums.RespBusiness;

public class BidPayServiceImpl
extends BidServiceImpl
implements IBidPayService {
    @Override
    public String getFormId() {
        return "bid_pay";
    }

    @Override
    public void createPayByBidPublish(DynamicObject bidPublish, boolean isOpen, String appId) {
        DynamicObject bidProject = bidPublish.getDynamicObject("bidproject");
        MainEntityType bidMainType = EntityMetadataCache.getDataEntityType((String)"bid_project");
        DynamicObject bProject = BusinessDataServiceHelper.loadSingle((Object)bidProject.getPkValue(), (DynamicObjectType)bidMainType);
        String respbusiness = this.getBidProjectRespbusiness(bProject);
        RequestContext requestContext = RequestContext.get();
        Long userId = Long.valueOf(requestContext.getUserId());
        ORM orm = ORM.create();
        if (bProject != null) {
            String chargeStage;
            BigDecimal tenderfee = bProject.getBigDecimal("tenderfee");
            if (tenderfee.compareTo(BigDecimal.ZERO) > 0) {
                this.createTenderfee(bidPublish, bProject, tenderfee, userId, orm, respbusiness, isOpen, appId);
            }
            if (StringUtils.equals((CharSequence)"notstage", (CharSequence)(chargeStage = bProject.getString("chargingstage")))) {
                return;
            }
            BigDecimal deposit = bProject.getBigDecimal("deposit");
            boolean isdeposit = bProject.getBoolean("isdeposit");
            boolean isSupplier = bProject.getBoolean("issupplierget");
            if (!isSupplier) {
                Map<String, BigDecimal> secdepositMap = this.getBidProjectSecdeposit(bProject, isdeposit);
                if (isdeposit) {
                    if (secdepositMap.size() > 0) {
                        this.createDeposit(bidPublish, bProject, deposit, userId, orm, respbusiness, isdeposit, secdepositMap, isOpen, appId);
                    }
                } else if (deposit.compareTo(BigDecimal.ZERO) > 0) {
                    this.createDeposit(bidPublish, bProject, deposit, userId, orm, respbusiness, isdeposit, secdepositMap, isOpen, appId);
                }
            } else {
                Map<String, Map<DynamicObject, BigDecimal>> secdeposit = this.getSecdepositBySupplierInvition(bidPublish);
                if (secdeposit == null || secdeposit.size() <= 0) {
                    return;
                }
                this.createDepositBySupplier(bProject, userId, orm, respbusiness, secdeposit, isOpen, appId);
            }
        }
    }

    public Map<String, BigDecimal> getBidProjectSecdeposit(DynamicObject bidProject, boolean isdeposit) {
        HashMap<String, BigDecimal> secdepositMap = new HashMap<String, BigDecimal>();
        if (isdeposit) {
            DynamicObjectCollection bidSection = bidProject.getDynamicObjectCollection("bidsection");
            for (int i = 0; i < bidSection.size(); ++i) {
                DynamicObject section = (DynamicObject)bidSection.get(i);
                BigDecimal secdeposit = section.getBigDecimal("secdeposit");
                if (secdeposit.compareTo(BigDecimal.ZERO) <= 0) continue;
                secdepositMap.put(section.getString("sectionname"), secdeposit);
            }
        }
        return secdepositMap;
    }

    public Map<String, Map<DynamicObject, BigDecimal>> getSecdepositBySupplierInvition(DynamicObject bidPublish) {
        HashMap<String, Map<DynamicObject, BigDecimal>> secdepositMap = new HashMap<String, Map<DynamicObject, BigDecimal>>(16);
        DynamicObject temp = bidPublish;
        DynamicObjectCollection sectionColl = temp.getDynamicObjectCollection("bidsection");
        for (DynamicObject section : sectionColl) {
            String name = section.getString("sectionname");
            DynamicObjectCollection supplierEntry = section.getDynamicObjectCollection("supplierentry");
            Iterator supplierIter = supplierEntry.iterator();
            HashMap<DynamicObject, BigDecimal> supplierAndDe = new HashMap<DynamicObject, BigDecimal>();
            while (supplierIter.hasNext()) {
                DynamicObject row = (DynamicObject)supplierIter.next();
                BigDecimal bigDecimal = row.getBigDecimal("suppliersecdeposit");
                if (bigDecimal == null || bigDecimal.compareTo(BigDecimal.ZERO) <= 0) continue;
                DynamicObject supplier = row.getDynamicObject("supplier");
                supplierAndDe.put(supplier, bigDecimal);
            }
            if (supplierAndDe.size() <= 0) continue;
            secdepositMap.put(name, supplierAndDe);
        }
        return secdepositMap;
    }

    public String getBidProjectRespbusiness(DynamicObject bidProject) {
        String temp = "";
        StringBuilder sb = new StringBuilder();
        if (null != bidProject) {
            DynamicObjectCollection memberEntry = bidProject.getDynamicObjectCollection("memberentity");
            RespBusiness rb = RespBusiness.valueOf((String)"BidPay");
            for (int i = 0; i < memberEntry.size(); ++i) {
                DynamicObject member = (DynamicObject)memberEntry.get(i);
                DynamicObject user = member.getDynamicObject("user");
                String respbusiness = member.getString("respbusiness");
                if (respbusiness.indexOf(rb.getVal()) < 0) continue;
                sb.append(user.getPkValue());
                sb.append(',');
            }
            if (sb.length() > 0) {
                temp = sb.substring(0, sb.length() - 1);
            }
        }
        return temp;
    }

    /*
     * WARNING - void declaration
     */
    public void createTenderfee(DynamicObject bidPublish, DynamicObject bidProject, BigDecimal tenderfee, Long userId, ORM orm, String respbusiness, boolean isOpen, String appId) {
        DynamicObject payList = this.getPayByBidProjectIdAndType(bidProject.getLong("id"), "0");
        if (payList != null) {
            DynamicObjectCollection bidSectionColl = payList.getDynamicObjectCollection("bidsection");
            DynamicObject bidSection = (DynamicObject)bidSectionColl.get(0);
            HashSet<String> supplierIds = new HashSet<String>(100);
            DynamicObjectCollection supplierEntryColl = bidSection.getDynamicObjectCollection("supplierentry");
            int size = supplierEntryColl.size();
            for (int i = 0; i < supplierEntryColl.size(); ++i) {
                DynamicObject supplier = ((DynamicObject)supplierEntryColl.get(i)).getDynamicObject("supplier");
                supplierIds.add(supplier.getPkValue().toString());
            }
            DynamicObjectCollection pubSections = bidPublish.getDynamicObjectCollection("bidsection");
            HashSet<String> pubSupplierIds = new HashSet<String>(100);
            for (int i = 0; i < pubSections.size(); ++i) {
                DynamicObject pubSection = (DynamicObject)pubSections.get(i);
                DynamicObjectCollection dynamicObjectCollection = pubSection.getDynamicObjectCollection("supplierentry");
                for (int j = 0; j < dynamicObjectCollection.size(); ++j) {
                    DynamicObject supplierEntry = (DynamicObject)dynamicObjectCollection.get(j);
                    DynamicObject supplier = supplierEntry.getDynamicObject("supplier");
                    pubSupplierIds.add(supplier.getPkValue().toString());
                }
            }
            HashSet<String> newSupplierIds = new HashSet<String>();
            for (String string : pubSupplierIds) {
                if (supplierIds.contains(string)) continue;
                newSupplierIds.add(string);
            }
            String org = "org";
            for (String string : newSupplierIds) {
                MainEntityType payMainType = EntityMetadataCache.getDataEntityType((String)"bid_pay");
                EntityType paySupplierentryType = (EntityType)payMainType.getAllEntities().get("supplierentry");
                MainEntityType payListMainType = EntityMetadataCache.getDataEntityType((String)"bid_pay_list");
                DynamicObject bidListPay = new DynamicObject((DynamicObjectType)payListMainType);
                bidListPay.set("bidproject", (Object)bidProject);
                bidListPay.set(org, bidProject.get(org));
                bidListPay.set("creator", (Object)userId);
                bidListPay.set("createtime", (Object)new Date());
                bidListPay.set("type", (Object)0);
                bidListPay.set("respbusiness", (Object)respbusiness);
                bidListPay.set("suresum", (Object)tenderfee);
                bidListPay.set("status", (Object)0);
                bidListPay.set("isOpen", (Object)isOpen);
                bidListPay.set("entitytypeid", (Object)(appId + "_pay_list"));
                bidListPay.set("currency", bidProject.get("currency"));
                long id = ID.genLongId();
                DynamicObject paySupplierentry = new DynamicObject((DynamicObjectType)paySupplierentryType);
                paySupplierentry.set("seq", (Object)size++);
                paySupplierentry.set("status", (Object)0);
                paySupplierentry.set("supplier", (Object)string);
                paySupplierentry.set("suresum", (Object)tenderfee);
                paySupplierentry.set("paylistid", (Object)id);
                supplierEntryColl.add((Object)paySupplierentry);
                bidListPay.set("supplier", (Object)string);
                bidListPay.set("id", (Object)id);
                BusinessDataServiceHelper.save((IDataEntityType)payListMainType, (Object[])new DynamicObject[]{bidListPay});
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{payList});
        } else {
            MainEntityType payMainType = EntityMetadataCache.getDataEntityType((String)"bid_pay");
            DynamicObject bidPay = new DynamicObject((DynamicObjectType)payMainType);
            bidPay.set("bidproject", (Object)bidProject);
            bidPay.set("org", bidProject.get("org"));
            bidPay.set("creator", (Object)userId);
            bidPay.set("createtime", (Object)new Date());
            bidPay.set("type", (Object)0);
            bidPay.set("respbusiness", (Object)respbusiness);
            bidPay.set("isOpen", (Object)isOpen);
            bidPay.set("entitytypeid", (Object)(appId + "_pay"));
            bidPay.set("currency", bidProject.get("currency"));
            EntityType paySectionType = (EntityType)payMainType.getAllEntities().get("bidsection");
            EntityType paySupplierentryType = (EntityType)payMainType.getAllEntities().get("supplierentry");
            MainEntityType payListMainType = EntityMetadataCache.getDataEntityType((String)"bid_pay_list");
            DynamicObject bidListPay = new DynamicObject((DynamicObjectType)payListMainType);
            bidListPay.set("bidproject", (Object)bidProject);
            bidListPay.set("org", bidProject.get("org"));
            bidListPay.set("creator", (Object)userId);
            bidListPay.set("createtime", (Object)new Date());
            bidListPay.set("type", (Object)0);
            bidListPay.set("respbusiness", (Object)respbusiness);
            bidListPay.set("suresum", (Object)tenderfee);
            bidListPay.set("status", (Object)0);
            bidListPay.set("isOpen", (Object)isOpen);
            bidListPay.set("entitytypeid", (Object)(appId + "_pay_list"));
            bidListPay.set("currency", bidProject.get("currency"));
            DynamicObjectCollection paySectionCollection = new DynamicObjectCollection();
            DynamicObjectCollection paySupplierentryCollection = new DynamicObjectCollection();
            DynamicObjectCollection bidSections = bidPublish.getDynamicObjectCollection("bidsection");
            HashSet<String> hashSet = new HashSet<String>();
            boolean bl = false;
            for (int i = 0; i < bidSections.size(); ++i) {
                DynamicObject bidSection = (DynamicObject)bidSections.get(i);
                if (i == 0) {
                    DynamicObject paySection = new DynamicObject((DynamicObjectType)paySectionType);
                    paySection.set("seq", (Object)(i + 1));
                    paySection.set("sectionname", bidSection.get("sectionname"));
                    paySectionCollection.add((Object)paySection);
                }
                DynamicObjectCollection supplierentrys = bidSection.getDynamicObjectCollection("supplierentry");
                for (int j = 0; j < supplierentrys.size(); ++j) {
                    void var20_39;
                    DynamicObject supplierentry = (DynamicObject)supplierentrys.get(j);
                    DynamicObject supplier = supplierentry.getDynamicObject("supplier");
                    if (hashSet.contains(supplier.getPkValue().toString())) continue;
                    long id = ID.genLongId();
                    DynamicObject paySupplierentry = new DynamicObject((DynamicObjectType)paySupplierentryType);
                    paySupplierentry.set("seq", (Object)((int)(var20_39 + true)));
                    paySupplierentry.set("status", (Object)0);
                    paySupplierentry.set("supplier", (Object)supplier);
                    paySupplierentry.set("suresum", (Object)tenderfee);
                    paySupplierentry.set("paylistid", (Object)id);
                    paySupplierentryCollection.add((Object)paySupplierentry);
                    bidListPay.set("supplier", (Object)supplier);
                    bidListPay.set("id", (Object)id);
                    BusinessDataServiceHelper.save((IDataEntityType)payListMainType, (Object[])new DynamicObject[]{bidListPay});
                    hashSet.add(supplier.getPkValue().toString());
                    ++var20_39;
                }
            }
            ((DynamicObject)paySectionCollection.get(0)).set("supplierentry", (Object)paySupplierentryCollection);
            bidPay.set("bidsection", (Object)paySectionCollection);
            BusinessDataServiceHelper.save((IDataEntityType)payMainType, (Object[])new DynamicObject[]{bidPay});
        }
    }

    public void createDeposit(DynamicObject bidPublish, DynamicObject bidProject, BigDecimal deposit, Long userId, ORM orm, String respbusiness, boolean isdeposit, Map<String, BigDecimal> secdepositMap, boolean isOpen, String appId) {
        String org = "org";
        DynamicObject payList = this.getPayByBidProjectIdAndType(bidProject.getLong("id"), "1");
        if (payList != null) {
            if (isdeposit) {
                DynamicObjectCollection bidSectionColl = payList.getDynamicObjectCollection("bidsection");
                HashMap sectionColl = new HashMap(16);
                for (int i = 0; i < bidSectionColl.size(); ++i) {
                    DynamicObject bidSection = (DynamicObject)bidSectionColl.get(i);
                    DynamicObjectCollection supplierEntryColl = bidSection.getDynamicObjectCollection("supplierentry");
                    ArrayList<String> supplierIds = new ArrayList<String>(100);
                    for (int j = 0; j < supplierEntryColl.size(); ++j) {
                        DynamicObject supplierEntry = (DynamicObject)supplierEntryColl.get(j);
                        DynamicObject dynamicObject = supplierEntry.getDynamicObject("supplier");
                        supplierIds.add(dynamicObject.getPkValue().toString());
                    }
                    sectionColl.put(bidSection.getString("sectionname"), supplierIds);
                }
                HashMap publishColl = new HashMap(100);
                DynamicObjectCollection bidSections = bidPublish.getDynamicObjectCollection("bidsection");
                for (int i = 0; i < bidSections.size(); ++i) {
                    DynamicObject bidSection = (DynamicObject)bidSections.get(i);
                    DynamicObjectCollection dynamicObjectCollection = bidSection.getDynamicObjectCollection("supplierentry");
                    ArrayList<String> supplierIds = new ArrayList<String>(100);
                    for (int j = 0; j < dynamicObjectCollection.size(); ++j) {
                        DynamicObject supplierEntry = (DynamicObject)dynamicObjectCollection.get(j);
                        DynamicObject supplier = supplierEntry.getDynamicObject("supplier");
                        supplierIds.add(supplier.getPkValue().toString());
                    }
                    publishColl.put(bidSection.getString("sectionname"), supplierIds);
                }
                HashMap needNewColl = new HashMap(100);
                for (Map.Entry entry : sectionColl.entrySet()) {
                    String sectionName = (String)entry.getKey();
                    List list = (List)entry.getValue();
                    List publishSupplierIds = (List)publishColl.get(sectionName);
                    ArrayList supplierIds = new ArrayList(50);
                    for (int i = 0; i < publishSupplierIds.size(); ++i) {
                        if (list.contains(publishSupplierIds.get(i))) continue;
                        supplierIds.add(publishSupplierIds.get(i));
                    }
                    needNewColl.put(sectionName, supplierIds);
                }
                Set newSectionNameSet = needNewColl.keySet();
                HashSet hashSet = new HashSet();
                List suppliers = new ArrayList();
                for (String sectionName : newSectionNameSet) {
                    for (Map.Entry entry : needNewColl.entrySet()) {
                        String key = (String)entry.getKey();
                        if (!sectionName.equals(key)) continue;
                        suppliers = (List)entry.getValue();
                        break;
                    }
                    DynamicObjectCollection payListSectionColl1 = payList.getDynamicObjectCollection("bidsection");
                    for (int i = 0; i < payListSectionColl1.size(); ++i) {
                        DynamicObject payListSection = (DynamicObject)payListSectionColl1.get(i);
                        if (!payListSection.getString("sectionname").equals(sectionName)) continue;
                        for (int j = 0; j < suppliers.size(); ++j) {
                            DynamicObjectCollection supplierEntryColl = payListSection.getDynamicObjectCollection("supplierentry");
                            int size = supplierEntryColl.size();
                            MainEntityType payMainType = EntityMetadataCache.getDataEntityType((String)"bid_pay");
                            EntityType paySupplierentryType = (EntityType)payMainType.getAllEntities().get("supplierentry");
                            MainEntityType payListMainType = EntityMetadataCache.getDataEntityType((String)"bid_pay_list");
                            DynamicObject bidListPay = new DynamicObject((DynamicObjectType)payListMainType);
                            bidListPay.set("bidproject", (Object)bidProject);
                            bidListPay.set(org, bidProject.get(org));
                            bidListPay.set("creator", (Object)userId);
                            bidListPay.set("createtime", (Object)new Date());
                            bidListPay.set("type", (Object)1);
                            bidListPay.set("respbusiness", (Object)respbusiness);
                            bidListPay.set("status", (Object)0);
                            bidListPay.set("isOpen", (Object)isOpen);
                            bidListPay.set("entitytypeid", (Object)(appId + "_pay_list"));
                            bidListPay.set("currency", bidProject.get("currency"));
                            if (isdeposit && !secdepositMap.containsKey(payListSection.getString("sectionname"))) continue;
                            if (isdeposit) {
                                bidListPay.set("sectionname", payListSection.get("sectionname"));
                            }
                            long id = ID.genLongId();
                            DynamicObject paySupplierentry = new DynamicObject((DynamicObjectType)paySupplierentryType);
                            paySupplierentry.set("seq", (Object)size++);
                            paySupplierentry.set("status", (Object)0);
                            paySupplierentry.set("supplier", suppliers.get(j));
                            paySupplierentry.set("paylistid", (Object)id);
                            if (isdeposit) {
                                paySupplierentry.set("suresum", (Object)secdepositMap.get(payListSection.getString("sectionname")));
                                bidListPay.set("suresum", (Object)secdepositMap.get(payListSection.getString("sectionname")));
                            } else {
                                paySupplierentry.set("suresum", (Object)deposit);
                                bidListPay.set("suresum", (Object)deposit);
                            }
                            bidListPay.set("supplier", suppliers.get(j));
                            bidListPay.set("id", (Object)id);
                            if (isdeposit) {
                                BusinessDataServiceHelper.save((IDataEntityType)payListMainType, (Object[])new DynamicObject[]{bidListPay});
                                supplierEntryColl.add((Object)paySupplierentry);
                                continue;
                            }
                            if (hashSet.contains(suppliers.get(j))) continue;
                            BusinessDataServiceHelper.save((IDataEntityType)payListMainType, (Object[])new DynamicObject[]{bidListPay});
                            hashSet.add(suppliers.get(j));
                            supplierEntryColl.add((Object)paySupplierentry);
                        }
                    }
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{payList});
            } else {
                DynamicObjectCollection bidSectionColl = payList.getDynamicObjectCollection("bidsection");
                HashSet<String> bidPaySupplierIdSet = new HashSet<String>(50);
                for (int i = 0; i < bidSectionColl.size(); ++i) {
                    DynamicObject bidSection = (DynamicObject)bidSectionColl.get(i);
                    DynamicObjectCollection supplierEntryColl = bidSection.getDynamicObjectCollection("supplierentry");
                    for (int j = 0; j < supplierEntryColl.size(); ++j) {
                        DynamicObject dynamicObject = (DynamicObject)supplierEntryColl.get(j);
                        DynamicObject supplier = dynamicObject.getDynamicObject("supplier");
                        bidPaySupplierIdSet.add(supplier.getPkValue().toString());
                    }
                }
                HashMap publishSupplierMap = new HashMap(100);
                DynamicObjectCollection bidSections = bidPublish.getDynamicObjectCollection("bidsection");
                for (int i = 0; i < bidSections.size(); ++i) {
                    DynamicObject bidSection = (DynamicObject)bidSections.get(i);
                    DynamicObjectCollection dynamicObjectCollection = bidSection.getDynamicObjectCollection("supplierentry");
                    ArrayList<String> supplierIds = new ArrayList<String>(50);
                    for (int j = 0; j < dynamicObjectCollection.size(); ++j) {
                        DynamicObject supplierEntry = (DynamicObject)dynamicObjectCollection.get(j);
                        DynamicObject supplier = supplierEntry.getDynamicObject("supplier");
                        supplierIds.add(supplier.getPkValue().toString());
                    }
                    publishSupplierMap.put(bidSection.getString("sectionname"), supplierIds);
                }
                HashMap needNewColl = new HashMap(100);
                for (Map.Entry entry : publishSupplierMap.entrySet()) {
                    String sectionName = (String)entry.getKey();
                    List list = (List)entry.getValue();
                    ArrayList supplierIds = new ArrayList(50);
                    for (int i = 0; i < list.size(); ++i) {
                        if (bidPaySupplierIdSet.contains(list.get(i))) continue;
                        supplierIds.add(list.get(i));
                    }
                    needNewColl.put(sectionName, supplierIds);
                }
                Set newSectionNameSet = needNewColl.keySet();
                HashSet<String> hashSet = new HashSet<String>(100);
                for (Map.Entry entry : needNewColl.entrySet()) {
                    String sectionName = (String)entry.getKey();
                    List suppliers = (List)entry.getValue();
                    DynamicObjectCollection payListSectionColl1 = payList.getDynamicObjectCollection("bidsection");
                    if (payListSectionColl1 == null || payListSectionColl1.size() != 1) continue;
                    DynamicObject payListSection = (DynamicObject)payListSectionColl1.get(0);
                    for (int j = 0; j < suppliers.size(); ++j) {
                        String thisSupplierIdStr = (String)suppliers.get(j);
                        DynamicObjectCollection supplierEntryColl = payListSection.getDynamicObjectCollection("supplierentry");
                        int size = supplierEntryColl.size();
                        MainEntityType payMainType = EntityMetadataCache.getDataEntityType((String)"bid_pay");
                        EntityType paySupplierentryType = (EntityType)payMainType.getAllEntities().get("supplierentry");
                        MainEntityType payListMainType = EntityMetadataCache.getDataEntityType((String)"bid_pay_list");
                        DynamicObject bidListPay = new DynamicObject((DynamicObjectType)payListMainType);
                        bidListPay.set("bidproject", (Object)bidProject);
                        bidListPay.set(org, bidProject.get(org));
                        bidListPay.set("creator", (Object)userId);
                        bidListPay.set("createtime", (Object)new Date());
                        bidListPay.set("type", (Object)1);
                        bidListPay.set("respbusiness", (Object)respbusiness);
                        bidListPay.set("status", (Object)0);
                        bidListPay.set("isOpen", (Object)isOpen);
                        bidListPay.set("entitytypeid", (Object)(appId + "_pay_list"));
                        long id = ID.genLongId();
                        bidListPay.set("suresum", (Object)deposit);
                        bidListPay.set("supplier", (Object)thisSupplierIdStr);
                        bidListPay.set("id", (Object)id);
                        bidListPay.set("currency", bidProject.get("currency"));
                        DynamicObject paySupplierentry = new DynamicObject((DynamicObjectType)paySupplierentryType);
                        paySupplierentry.set("seq", (Object)size++);
                        paySupplierentry.set("status", (Object)0);
                        paySupplierentry.set("supplier", (Object)thisSupplierIdStr);
                        paySupplierentry.set("paylistid", (Object)id);
                        paySupplierentry.set("suresum", (Object)deposit);
                        if (!hashSet.add(thisSupplierIdStr)) continue;
                        SaveServiceHelper.save((IDataEntityType)payListMainType, (Object[])new DynamicObject[]{bidListPay});
                        supplierEntryColl.add((Object)paySupplierentry);
                    }
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{payList});
            }
        } else {
            MainEntityType payMainType = EntityMetadataCache.getDataEntityType((String)"bid_pay");
            DynamicObject bidPay = new DynamicObject((DynamicObjectType)payMainType);
            bidPay.set("bidproject", (Object)bidProject);
            bidPay.set(org, bidProject.get(org));
            bidPay.set("creator", (Object)userId);
            bidPay.set("createtime", (Object)new Date());
            bidPay.set("currency", bidProject.get("currency"));
            bidPay.set("type", (Object)1);
            bidPay.set("respbusiness", (Object)respbusiness);
            bidPay.set("isOpen", (Object)isOpen);
            bidPay.set("entitytypeid", (Object)(appId + "_pay"));
            EntityType paySectionType = (EntityType)payMainType.getAllEntities().get("bidsection");
            EntityType paySupplierentryType = (EntityType)payMainType.getAllEntities().get("supplierentry");
            MainEntityType payListMainType = EntityMetadataCache.getDataEntityType((String)"bid_pay_list");
            DynamicObject bidListPay = new DynamicObject((DynamicObjectType)payListMainType);
            bidListPay.set("bidproject", (Object)bidProject);
            bidListPay.set(org, bidProject.get(org));
            bidListPay.set("creator", (Object)userId);
            bidListPay.set("createtime", (Object)new Date());
            bidListPay.set("type", (Object)1);
            bidListPay.set("respbusiness", (Object)respbusiness);
            bidListPay.set("status", (Object)0);
            bidListPay.set("isOpen", (Object)isOpen);
            bidListPay.set("entitytypeid", (Object)(appId + "_pay_list"));
            bidListPay.set("currency", bidProject.get("currency"));
            DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
            DynamicObjectCollection bidSections = bidPublish.getDynamicObjectCollection("bidsection");
            HashSet<String> hashSet = new HashSet<String>();
            for (int i = 0; i < bidSections.size(); ++i) {
                DynamicObject bidSection = (DynamicObject)bidSections.get(i);
                if (isdeposit && !secdepositMap.containsKey(bidSection.getString("sectionname"))) continue;
                if (isdeposit) {
                    bidListPay.set("sectionname", bidSection.get("sectionname"));
                }
                DynamicObjectCollection paySupplierentryCollection = new DynamicObjectCollection();
                DynamicObjectCollection supplierentrys = bidSection.getDynamicObjectCollection("supplierentry");
                int seq = 0;
                for (int j = 0; j < supplierentrys.size(); ++j) {
                    DynamicObject supplierentry = (DynamicObject)supplierentrys.get(j);
                    DynamicObject supplier = supplierentry.getDynamicObject("supplier");
                    long id = ID.genLongId();
                    DynamicObject paySupplierentry = new DynamicObject((DynamicObjectType)paySupplierentryType);
                    paySupplierentry.set("seq", (Object)seq++);
                    paySupplierentry.set("status", (Object)0);
                    paySupplierentry.set("supplier", (Object)supplier);
                    paySupplierentry.set("paylistid", (Object)id);
                    if (isdeposit) {
                        paySupplierentry.set("suresum", (Object)secdepositMap.get(bidSection.getString("sectionname")));
                        bidListPay.set("suresum", (Object)secdepositMap.get(bidSection.getString("sectionname")));
                    } else {
                        paySupplierentry.set("suresum", (Object)deposit);
                        bidListPay.set("suresum", (Object)deposit);
                    }
                    bidListPay.set("supplier", (Object)supplier);
                    bidListPay.set("id", (Object)id);
                    if (isdeposit) {
                        BusinessDataServiceHelper.save((IDataEntityType)payListMainType, (Object[])new DynamicObject[]{bidListPay});
                        paySupplierentryCollection.add((Object)paySupplierentry);
                        continue;
                    }
                    if (hashSet.contains(supplier.getPkValue().toString())) continue;
                    BusinessDataServiceHelper.save((IDataEntityType)payListMainType, (Object[])new DynamicObject[]{bidListPay});
                    hashSet.add(supplier.getPkValue().toString());
                    paySupplierentryCollection.add((Object)paySupplierentry);
                }
                if (isdeposit) {
                    DynamicObject paySection = new DynamicObject((DynamicObjectType)paySectionType);
                    paySection.set("seq", (Object)(i + 1));
                    paySection.set("sectionname", bidSection.get("sectionname"));
                    paySection.set("supplierentry", (Object)paySupplierentryCollection);
                    dynamicObjectCollection.add((Object)paySection);
                    continue;
                }
                if (i == 0) {
                    DynamicObject paySection = new DynamicObject((DynamicObjectType)paySectionType);
                    paySection.set("seq", (Object)(i + 1));
                    paySection.set("sectionname", bidSection.get("sectionname"));
                    paySection.set("supplierentry", (Object)paySupplierentryCollection);
                    dynamicObjectCollection.add((Object)paySection);
                    continue;
                }
                ((DynamicObject)dynamicObjectCollection.get(0)).getDynamicObjectCollection("supplierentry").addAll((Collection)paySupplierentryCollection);
            }
            bidPay.set("bidsection", (Object)dynamicObjectCollection);
            BusinessDataServiceHelper.save((IDataEntityType)payMainType, (Object[])new DynamicObject[]{bidPay});
        }
    }

    /*
     * WARNING - void declaration
     */
    public void createDepositBySupplier(DynamicObject bidProject, Long userId, ORM orm, String respbusiness, Map<String, Map<DynamicObject, BigDecimal>> secdepositMap, boolean isOpen, String appId) {
        DynamicObject payList = this.getPayByBidProjectIdAndType(bidProject.getLong("id"), "1");
        boolean aBoolean = bidProject.getBoolean("enablemultisection");
        if (payList != null) {
            DynamicObjectCollection bidSectionColl = payList.getDynamicObjectCollection("bidsection");
            HashMap sectionColl = new HashMap(16);
            for (int i = 0; i < bidSectionColl.size(); ++i) {
                DynamicObject bidSection = (DynamicObject)bidSectionColl.get(i);
                DynamicObjectCollection dynamicObjectCollection = bidSection.getDynamicObjectCollection("supplierentry");
                HashSet<String> supplierIds = new HashSet<String>(16);
                for (int j = 0; j < dynamicObjectCollection.size(); ++j) {
                    DynamicObject supplierEntry = (DynamicObject)dynamicObjectCollection.get(j);
                    DynamicObject supplier = supplierEntry.getDynamicObject("supplier");
                    supplierIds.add(supplier.getPkValue().toString());
                }
                sectionColl.put(bidSection.getString("sectionname"), supplierIds);
            }
            HashMap<String, Object> newColl = new HashMap<String, Object>(16);
            for (Map.Entry entry : sectionColl.entrySet()) {
                HashMap newRow = new HashMap(16);
                String sectionName = (String)entry.getKey();
                Set oleSupplier = (Set)sectionColl.get(sectionName);
                Map<DynamicObject, BigDecimal> newMap = secdepositMap.get(sectionName);
                for (Map.Entry<DynamicObject, BigDecimal> entry2 : newMap.entrySet()) {
                    String toString = entry2.getKey().getPkValue().toString();
                    if (oleSupplier.contains(toString)) continue;
                    newRow.put(entry2.getKey(), entry2.getValue());
                }
                if (newRow.size() <= 0) continue;
                newColl.put(sectionName, newRow);
            }
            if (newColl.isEmpty()) {
                return;
            }
            Set newSectionNameSet = newColl.keySet();
            HashMap hashMap = new HashMap();
            for (String sectionName : newSectionNameSet) {
                for (Map.Entry entry : newColl.entrySet()) {
                    String key = (String)entry.getKey();
                    if (!sectionName.equals(key)) continue;
                    Map map = (Map)entry.getValue();
                    break;
                }
                DynamicObjectCollection payListSectionColl1 = payList.getDynamicObjectCollection("bidsection");
                for (int i = 0; i < payListSectionColl1.size(); ++i) {
                    void var14_23;
                    DynamicObject payListSection = (DynamicObject)payListSectionColl1.get(i);
                    if (!payListSection.getString("sectionname").equals(sectionName)) continue;
                    for (int j = 0; j < var14_23.size(); ++j) {
                        DynamicObjectCollection supplierEntryColl = payListSection.getDynamicObjectCollection("supplierentry");
                        int size = supplierEntryColl.size();
                        BigDecimal resum = secdepositMap.get(payListSection.getString("sectionname")).get(var14_23.get(j));
                        MainEntityType payMainType = EntityMetadataCache.getDataEntityType((String)"bid_pay");
                        EntityType paySupplierentryType = (EntityType)payMainType.getAllEntities().get("supplierentry");
                        MainEntityType payListMainType = EntityMetadataCache.getDataEntityType((String)"bid_pay_list");
                        DynamicObject bidListPay = new DynamicObject((DynamicObjectType)payListMainType);
                        bidListPay.set("bidproject", (Object)bidProject);
                        bidListPay.set("org", bidProject.get("org"));
                        bidListPay.set("creator", (Object)userId);
                        bidListPay.set("createtime", (Object)new Date());
                        bidListPay.set("type", (Object)1);
                        bidListPay.set("respbusiness", (Object)respbusiness);
                        bidListPay.set("status", (Object)0);
                        bidListPay.set("isOpen", (Object)isOpen);
                        bidListPay.set("entitytypeid", (Object)(appId + "_pay_list"));
                        bidListPay.set("supplier", var14_23.get(j));
                        bidListPay.set("currency", bidProject.get("currency"));
                        if (aBoolean) {
                            bidListPay.set("sectionname", payListSection.get("sectionname"));
                        }
                        long id = ID.genLongId();
                        DynamicObject paySupplierentry = new DynamicObject((DynamicObjectType)paySupplierentryType);
                        paySupplierentry.set("seq", (Object)size++);
                        paySupplierentry.set("status", (Object)0);
                        paySupplierentry.set("supplier", var14_23.get(j));
                        paySupplierentry.set("paylistid", (Object)id);
                        paySupplierentry.set("suresum", (Object)resum);
                        bidListPay.set("suresum", (Object)resum);
                        bidListPay.set("supplier", var14_23.get(j));
                        bidListPay.set("id", (Object)id);
                        bidListPay.set("sectionname", (Object)sectionName);
                        BusinessDataServiceHelper.save((IDataEntityType)payListMainType, (Object[])new DynamicObject[]{bidListPay});
                        supplierEntryColl.add((Object)paySupplierentry);
                    }
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{payList});
            }
        } else {
            MainEntityType payMainType = EntityMetadataCache.getDataEntityType((String)"bid_pay");
            DynamicObject bidPay = new DynamicObject((DynamicObjectType)payMainType);
            bidPay.set("bidproject", (Object)bidProject);
            bidPay.set("org", bidProject.get("org"));
            bidPay.set("creator", (Object)userId);
            bidPay.set("createtime", (Object)new Date());
            bidPay.set("type", (Object)1);
            bidPay.set("respbusiness", (Object)respbusiness);
            bidPay.set("isOpen", (Object)isOpen);
            bidPay.set("entitytypeid", (Object)(appId + "_pay"));
            bidPay.set("currency", bidProject.get("currency"));
            EntityType paySectionType = (EntityType)payMainType.getAllEntities().get("bidsection");
            EntityType paySupplierentryType = (EntityType)payMainType.getAllEntities().get("supplierentry");
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"bid_pay_list");
            DynamicObject bidListPay = new DynamicObject((DynamicObjectType)mainEntityType);
            bidListPay.set("bidproject", (Object)bidProject);
            bidListPay.set("org", bidProject.get("org"));
            bidListPay.set("creator", (Object)userId);
            bidListPay.set("createtime", (Object)new Date());
            bidListPay.set("type", (Object)1);
            bidListPay.set("respbusiness", (Object)respbusiness);
            bidListPay.set("status", (Object)0);
            bidListPay.set("isOpen", (Object)isOpen);
            bidListPay.set("entitytypeid", (Object)(appId + "_pay_list"));
            bidListPay.set("currency", bidProject.get("currency"));
            DynamicObjectCollection paySectionCollection = new DynamicObjectCollection();
            int i = 0;
            for (Map.Entry<String, Map<DynamicObject, BigDecimal>> entry : secdepositMap.entrySet()) {
                int seq = 0;
                DynamicObjectCollection paySupplierentryCollection = new DynamicObjectCollection();
                String name = entry.getKey();
                Map<DynamicObject, BigDecimal> supplierAndDisit = entry.getValue();
                for (Map.Entry<DynamicObject, BigDecimal> supplierAndDisitEntry : supplierAndDisit.entrySet()) {
                    DynamicObject paySupplierentry = new DynamicObject((DynamicObjectType)paySupplierentryType);
                    DynamicObject supplier = supplierAndDisitEntry.getKey();
                    BigDecimal menoy = supplierAndDisitEntry.getValue();
                    long id = ID.genLongId();
                    paySupplierentry.set("seq", (Object)seq++);
                    paySupplierentry.set("status", (Object)0);
                    paySupplierentry.set("supplier", (Object)supplier);
                    paySupplierentry.set("paylistid", (Object)id);
                    paySupplierentry.set("suresum", (Object)menoy);
                    bidListPay.set("suresum", (Object)menoy);
                    bidListPay.set("supplier", (Object)supplier);
                    bidListPay.set("id", (Object)id);
                    if (aBoolean) {
                        bidListPay.set("sectionname", (Object)name);
                    }
                    BusinessDataServiceHelper.save((IDataEntityType)mainEntityType, (Object[])new DynamicObject[]{bidListPay});
                    paySupplierentryCollection.add((Object)paySupplierentry);
                }
                DynamicObject paySection = new DynamicObject((DynamicObjectType)paySectionType);
                paySection.set("seq", (Object)(i + 1));
                paySection.set("sectionname", (Object)name);
                paySection.set("supplierentry", (Object)paySupplierentryCollection);
                paySectionCollection.add((Object)paySection);
            }
            bidPay.set("bidsection", (Object)paySectionCollection);
            BusinessDataServiceHelper.save((IDataEntityType)payMainType, (Object[])new DynamicObject[]{bidPay});
        }
    }

    @Override
    public DynamicObject getPayByBidProjectIdAndType(Long bidProjectId, String type) {
        QFilter qFilter1 = new QFilter("bidproject.id", "=", (Object)bidProjectId);
        QFilter qFilter2 = new QFilter("type", "=", (Object)type);
        QFilter qFilter3 = new QFilter("billno", "is null", (Object)"");
        QFilter qFilter4 = new QFilter("billno", "=", (Object)"");
        QFilter or = qFilter3.or(qFilter4);
        DynamicObject pay = QueryServiceHelper.queryOne((String)"bid_pay", (String)"id,entitytypeid", (QFilter[])new QFilter[]{qFilter1, qFilter2, or});
        if (null != pay) {
            String entryEntity = pay.getString("entitytypeid");
            pay = entryEntity.equals("rebm_pay") ? BusinessDataServiceHelper.loadSingle((Object)pay.get("id"), (String)"rebm_pay") : BusinessDataServiceHelper.loadSingle((Object)pay.get("id"), (String)"bid_pay");
        }
        return pay;
    }

    @Override
    public DynamicObject getPayById(Long id) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"bid_pay");
        return BusinessDataServiceHelper.loadSingle((Object)id, (DynamicObjectType)type);
    }

    @Override
    public DynamicObject getPayListById(Long id) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"bid_pay_list");
        return BusinessDataServiceHelper.loadSingle((Object)id, (DynamicObjectType)type);
    }

    @Override
    public Map<String, String> getPayListStatusByBidProjectId(Long bidProjectId) {
        HashMap<String, String> sMap = new HashMap<String, String>();
        QFilter qFilter1 = new QFilter("bidproject.id", "=", (Object)bidProjectId);
        QFilter qFilter2 = new QFilter("type", "=", (Object)"1");
        DynamicObjectCollection pays = QueryServiceHelper.query((String)"bid_pay_list", (String)"id,entitytypeid", (QFilter[])new QFilter[]{qFilter1, qFilter2});
        if (null != pays && pays.size() > 0) {
            for (DynamicObject pay : pays) {
                String entryEntity = pay.getString("entitytypeid");
                DynamicObject tempPay = null;
                tempPay = entryEntity.equals("bid_pay_list") ? BusinessDataServiceHelper.loadSingle((Object)pay.get("id"), (String)"bid_pay_list") : BusinessDataServiceHelper.loadSingle((Object)pay.get("id"), (String)"rebm_pay_list");
                StringBuilder sb = new StringBuilder();
                sb.append(tempPay.getString("sectionname"));
                char s = '-';
                sb.append(s);
                sb.append(tempPay.getDynamicObject("supplier").getPkValue());
                String status = tempPay.getString("status");
                sMap.put(sb.toString(), status);
            }
        }
        return sMap;
    }

    @Override
    public Map<String, BigDecimal> getPayListRealsumByBidProjectId(Long bidProjectId) {
        HashMap<String, BigDecimal> pMap = new HashMap<String, BigDecimal>();
        QFilter qFilter1 = new QFilter("bidproject.id", "=", (Object)bidProjectId);
        QFilter qFilter2 = new QFilter("type", "=", (Object)"1");
        DynamicObjectCollection pays = QueryServiceHelper.query((String)"bid_pay_list", (String)"id,entitytypeid", (QFilter[])new QFilter[]{qFilter1, qFilter2});
        if (null != pays && pays.size() > 0) {
            for (DynamicObject pay : pays) {
                DynamicObject tempPay = null;
                String entryEntity = pay.getString("entitytypeid");
                tempPay = entryEntity.equals("bid_pay_list") ? BusinessDataServiceHelper.loadSingle((Object)pay.get("id"), (String)"bid_pay_list") : BusinessDataServiceHelper.loadSingle((Object)pay.get("id"), (String)"rebm_pay_list");
                StringBuilder sb = new StringBuilder();
                sb.append(tempPay.getString("sectionname"));
                sb.append('-');
                sb.append(tempPay.getDynamicObject("supplier").getPkValue());
                BigDecimal realsum = tempPay.getBigDecimal("realsum");
                pMap.put(sb.toString(), realsum);
            }
        }
        return pMap;
    }

    @Override
    public void updatePayListStatus(Long id, String status) {
        MainEntityType payListMainType = EntityMetadataCache.getDataEntityType((String)"bid_pay_list");
        DynamicObject paylist = this.getPayListById(id);
        paylist.set("status", (Object)status);
        BusinessDataServiceHelper.save((IDataEntityType)payListMainType, (Object[])new DynamicObject[]{paylist});
        QFilter qFilter = new QFilter("bidsection.supplierentry.paylistid", "=", (Object)id);
        DynamicObject pay = QueryServiceHelper.queryOne((String)"bid_pay", (String)"id", (QFilter[])new QFilter[]{qFilter});
        if (null != pay) {
            MainEntityType payMainType = EntityMetadataCache.getDataEntityType((String)"bid_pay");
            pay = BusinessDataServiceHelper.loadSingle((Object)pay.get("id"), (String)"bid_pay");
            DynamicObjectCollection bidSections = pay.getDynamicObjectCollection("bidsection");
            for (int i = 0; i < bidSections.size(); ++i) {
                DynamicObjectCollection supllierEntrys = ((DynamicObject)bidSections.get(i)).getDynamicObjectCollection("supplierentry");
                for (int j = 0; j < supllierEntrys.size(); ++j) {
                    DynamicObject entry = (DynamicObject)supllierEntrys.get(j);
                    long paylistid = entry.getLong("paylistid");
                    if (paylistid != id) continue;
                    entry.set("status", (Object)status);
                }
            }
            BusinessDataServiceHelper.save((IDataEntityType)payMainType, (Object[])new DynamicObject[]{pay});
        }
        this.setOpenDeposittype(paylist.getDynamicObject("bidproject").getLong("id"));
    }

    @Override
    public void setOpenDeposittype(Long bidProjectId) {
        String billstatus;
        QFilter qFilter;
        QFilter qFilter1 = new QFilter("id", "=", (Object)bidProjectId);
        DynamicObject tempBidProject = QueryServiceHelper.queryOne((String)"bid_project", (String)"id, billstatus, bidopentype, isdeposit,entitytypeid", (QFilter[])new QFilter[]{qFilter1});
        String bidOpenType = tempBidProject.getString("bidopentype");
        String entryEntity = tempBidProject.getString("entitytypeid");
        DynamicObject bidOpen = null;
        if (StringUtils.equals((CharSequence)BidOpenSelectTypeEnum.TECHBUSINESS.getValue(), (CharSequence)bidOpenType)) {
            qFilter = new QFilter("bidproject.id", "=", (Object)bidProjectId);
            qFilter.and(new QFilter("opentype", "=", (Object)BidOpenTypeEnum.TECHNICAL.getValue()));
            qFilter.and(new QFilter("billstatus", "!=", (Object)"XX"));
            bidOpen = "bid_project".equals(entryEntity) ? BusinessDataServiceHelper.loadSingle((String)"bid_bidopen", (String)"id, billstatus", (QFilter[])new QFilter[]{qFilter}) : BusinessDataServiceHelper.loadSingle((String)"rebm_bidopen", (String)"id, billstatus", (QFilter[])new QFilter[]{qFilter});
        } else if (StringUtils.equals((CharSequence)BidOpenSelectTypeEnum.BUSSINESSTECH.getValue(), (CharSequence)bidOpenType)) {
            qFilter = new QFilter("bidproject.id", "=", (Object)bidProjectId);
            qFilter.and(new QFilter("opentype", "=", (Object)BidOpenTypeEnum.BUSSINESS.getValue()));
            qFilter.and(new QFilter("billstatus", "!=", (Object)"XX"));
            bidOpen = "bid_project".equals(entryEntity) ? BusinessDataServiceHelper.loadSingle((String)"bid_bidopen", (String)"id, billstatus", (QFilter[])new QFilter[]{qFilter}) : BusinessDataServiceHelper.loadSingle((String)"rebm_bidopen", (String)"id, billstatus", (QFilter[])new QFilter[]{qFilter});
        } else {
            qFilter = new QFilter("bidproject.id", "=", (Object)bidProjectId);
            qFilter.and(new QFilter("billstatus", "!=", (Object)"XX"));
            bidOpen = "bid_project".equals(entryEntity) ? QueryServiceHelper.queryOne((String)"bid_bidopen", (String)"id, billstatus", (QFilter[])new QFilter[]{qFilter}) : QueryServiceHelper.queryOne((String)"rebm_bidopen", (String)"id, billstatus", (QFilter[])new QFilter[]{qFilter});
        }
        if (null != bidOpen && ((billstatus = (bidOpen = "bid_project".equals(entryEntity) ? BusinessDataServiceHelper.loadSingle((Object)bidOpen.getLong("id"), (String)"bid_bidopen") : BusinessDataServiceHelper.loadSingle((Object)bidOpen.getLong("id"), (String)"rebm_bidopen")).getString("billstatus")).equals(BillStatusEnum.DISBEGIN.getVal()) || billstatus.equals(BillStatusEnum.SAVE.getVal()) || billstatus.equals(BillStatusEnum.AUDITED.getVal()) || billstatus.equals(BillStatusEnum.SUBMIT.getVal()))) {
            boolean isdeposit = tempBidProject.getBoolean("isdeposit");
            Map<String, String> sMap = this.getPayListStatusByBidProjectId(tempBidProject.getLong("id"));
            Map<String, BigDecimal> pMap = this.getPayListRealsumByBidProjectId(tempBidProject.getLong("id"));
            DynamicObjectCollection sections = bidOpen.getDynamicObjectCollection("bidsection");
            for (int i = 0; i < sections.size(); ++i) {
                DynamicObject section = (DynamicObject)sections.get(i);
                DynamicObjectCollection supplierEntry = section.getDynamicObjectCollection("supplierentry");
                for (int j = 0; j < supplierEntry.size(); ++j) {
                    String payStatus;
                    DynamicObject entry = (DynamicObject)supplierEntry.get(j);
                    DynamicObject supplier = entry.getDynamicObject("supplier");
                    StringBuilder sb = new StringBuilder();
                    sb.append('_').append(supplier.getPkValue());
                    String key = sb.toString();
                    if (isdeposit) {
                        StringBuilder sb1 = new StringBuilder();
                        key = sb1.append(section.get("sectionname")).append('_').append(supplier.getPkValue()).toString();
                    }
                    if (StringUtils.isEmpty((CharSequence)(payStatus = sMap.get(key)))) continue;
                    if (payStatus.equals("0") || payStatus.equals("1") || payStatus.equals("4")) {
                        entry.set("supplier_deposittype", (Object)"UNPAY");
                        entry.set("supplier_deposit", null);
                        continue;
                    }
                    if (!payStatus.equals("2")) continue;
                    entry.set("supplier_deposittype", (Object)"PAID");
                    entry.set("supplier_deposit", (Object)pMap.get(key));
                }
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bidOpen});
        }
    }

    @Override
    public void updatePayListReason(List<Long> paylistids, String reason, DynamicObject backuser, Date backDate) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        for (Long id : paylistids) {
            MainEntityType payListMainType = EntityMetadataCache.getDataEntityType((String)"bid_pay_list");
            DynamicObject paylist = this.getPayListById(id);
            paylist.set("reason", (Object)(format.format(backDate) + " " + reason));
            paylist.set("status", (Object)"4");
            DynamicObjectCollection payBackCollection = paylist.getDynamicObjectCollection("payback");
            for (int i = 0; i < payBackCollection.size(); ++i) {
                int seq = ((DynamicObject)payBackCollection.get(i)).getInt("seq");
                ((DynamicObject)payBackCollection.get(i)).set("seq", (Object)(seq + 1));
            }
            EntityType payBackType = (EntityType)payListMainType.getAllEntities().get("payback");
            DynamicObject payBackSection = new DynamicObject((DynamicObjectType)payBackType);
            payBackSection.set("seq", (Object)1);
            payBackSection.set("backuser", (Object)backuser);
            payBackSection.set("backtime", (Object)backDate);
            payBackSection.set("freason", (Object)reason);
            payBackCollection.add((Object)payBackSection);
            BusinessDataServiceHelper.save((IDataEntityType)payListMainType, (Object[])new DynamicObject[]{paylist});
            QFilter qFilter = new QFilter("bidsection.supplierentry.paylistid", "=", (Object)id);
            DynamicObject pay = QueryServiceHelper.queryOne((String)"bid_pay", (String)"id", (QFilter[])new QFilter[]{qFilter});
            if (null == pay) continue;
            MainEntityType payMainType = EntityMetadataCache.getDataEntityType((String)"bid_pay");
            pay = BusinessDataServiceHelper.loadSingle((Object)pay.get("id"), (String)"bid_pay");
            DynamicObjectCollection bidSections = pay.getDynamicObjectCollection("bidsection");
            for (int i = 0; i < bidSections.size(); ++i) {
                DynamicObjectCollection supllierEntrys = ((DynamicObject)bidSections.get(i)).getDynamicObjectCollection("supplierentry");
                for (int j = 0; j < supllierEntrys.size(); ++j) {
                    DynamicObject entry = (DynamicObject)supllierEntrys.get(j);
                    long paylistid = entry.getLong("paylistid");
                    if (paylistid != id) continue;
                    entry.set("reason", (Object)(format.format(backDate) + " " + reason));
                    entry.set("backuser", (Object)backuser);
                    entry.set("backtime", (Object)backDate);
                    entry.set("status", (Object)"4");
                }
            }
            BusinessDataServiceHelper.save((IDataEntityType)payMainType, (Object[])new DynamicObject[]{pay});
            this.setOpenDeposittype(pay.getDynamicObject("bidproject").getLong("id"));
        }
    }

    @Override
    public void updateAllPayRespbusiness(Long bidProjectId, String respbusiness) {
        DynamicObject pay1;
        MainEntityType payListMainType = EntityMetadataCache.getDataEntityType((String)"bid_pay_list");
        MainEntityType payMainType = EntityMetadataCache.getDataEntityType((String)"bid_pay");
        DynamicObject pay0 = this.getPayByBidProjectIdAndType(bidProjectId, "0");
        if (null != pay0) {
            DynamicObjectCollection bidSections = pay0.getDynamicObjectCollection("bidsection");
            for (int i = 0; i < bidSections.size(); ++i) {
                DynamicObjectCollection supllierEntrys = ((DynamicObject)bidSections.get(i)).getDynamicObjectCollection("supplierentry");
                for (int j = 0; j < supllierEntrys.size(); ++j) {
                    DynamicObject entry = (DynamicObject)supllierEntrys.get(j);
                    Long paylistid = entry.getLong("paylistid");
                    DynamicObject paylist = this.getPayListById(paylistid);
                    paylist.set("respbusiness", (Object)respbusiness);
                    BusinessDataServiceHelper.save((IDataEntityType)payListMainType, (Object[])new DynamicObject[]{paylist});
                }
            }
            pay0.set("respbusiness", (Object)respbusiness);
            BusinessDataServiceHelper.save((IDataEntityType)payMainType, (Object[])new DynamicObject[]{pay0});
        }
        if (null != (pay1 = this.getPayByBidProjectIdAndType(bidProjectId, "1"))) {
            DynamicObjectCollection bidSections = pay1.getDynamicObjectCollection("bidsection");
            for (int i = 0; i < bidSections.size(); ++i) {
                DynamicObjectCollection supllierEntrys = ((DynamicObject)bidSections.get(i)).getDynamicObjectCollection("supplierentry");
                for (int j = 0; j < supllierEntrys.size(); ++j) {
                    DynamicObject entry = (DynamicObject)supllierEntrys.get(j);
                    Long paylistid = entry.getLong("paylistid");
                    DynamicObject paylist = this.getPayListById(paylistid);
                    paylist.set("respbusiness", (Object)respbusiness);
                    BusinessDataServiceHelper.save((IDataEntityType)payListMainType, (Object[])new DynamicObject[]{paylist});
                }
            }
            pay1.set("respbusiness", (Object)respbusiness);
            BusinessDataServiceHelper.save((IDataEntityType)payMainType, (Object[])new DynamicObject[]{pay1});
        }
    }
}

