/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.business.bill.serviceImpl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.business.bill.IBidProficientExtractService;
import kd.scm.bid.common.enums.BillStatusEnum;

public class BidProficientExtractServiceImpl
implements IBidProficientExtractService {
    @Override
    public List<QFilter> listQFilterByExtractCondition(DynamicObject extractCondition) {
        String proficientLevel;
        String proficientType;
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        String proficientSource = extractCondition.getString("proficientsource");
        if (proficientSource != null && !proficientSource.equals(" ") && !proficientSource.isEmpty()) {
            QFilter proficientSourceFilter = new QFilter("type", "=", (Object)proficientSource);
            filters.add(proficientSourceFilter);
        }
        if ((proficientType = extractCondition.getString("proficienttype")) != null && !proficientType.equals(" ") && !proficientType.isEmpty()) {
            QFilter proficientTypeFilter = new QFilter("proficienttype", "=", (Object)proficientType);
            filters.add(proficientTypeFilter);
        }
        if (extractCondition.get("majortype") != null) {
            Object majorType = ((DynamicObject)extractCondition.get("majortype")).get("name");
            QFilter majorTypeFilter = new QFilter("majortypenames", "like", (Object)("%" + majorType + "%"));
            filters.add(majorTypeFilter);
        }
        if ((proficientLevel = extractCondition.getString("proficientlevel")) != null && !proficientLevel.equals(" ") && !proficientLevel.isEmpty()) {
            QFilter proficientLevelFilter = new QFilter("proficientlevel", "=", (Object)proficientLevel);
            filters.add(proficientLevelFilter);
        }
        filters.add(new QFilter("status", "=", (Object)BillStatusEnum.AUDITED.getVal()));
        return filters;
    }

    @Override
    public void saveExtractRecord(DynamicObjectCollection extractConditionCol, Map<String, DynamicObject[]> resultMap, Object bidproject) {
        DynamicObject[] resultObjectCol = new DynamicObject[resultMap.size()];
        String extractedPeopleid = RequestContext.get().getUserId();
        Date extractedTime = new Date();
        for (int i = 0; i < resultMap.size(); ++i) {
            MainEntityType extractRecordType = this.createExtractRecordType();
            DynamicObject extractRecord = new DynamicObject((DynamicObjectType)extractRecordType);
            DynamicObject extractCondition = (DynamicObject)extractConditionCol.get(i);
            DynamicObject[] resultCol = resultMap.get(String.format(ResManager.loadKDString((String)"\u6761\u4ef6%s", (String)"BidProficientExtractServiceImpl_0", (String)"scm-bid-business", (Object[])new Object[0]), i + 1));
            ArrayList<String> idList = new ArrayList<String>(20);
            ArrayList<String> nameList = new ArrayList<String>(20);
            for (int j = 0; j < resultCol.length; ++j) {
                idList.add(resultCol[j].getString("id"));
                nameList.add(resultCol[j].getString("name"));
            }
            extractRecord.set("bidproject", bidproject);
            extractRecord.set("proficientsource", extractCondition.get("proficientsource"));
            extractRecord.set("proficienttype", extractCondition.get("proficienttype"));
            extractRecord.set("majortype", extractCondition.get("majortype"));
            extractRecord.set("proficientlevel", extractCondition.get("proficientlevel"));
            extractRecord.set("proficientcount", extractCondition.get("proficientcount"));
            extractRecord.set("extractedresultid", (Object)((Object)idList).toString());
            extractRecord.set("extractedresultname", (Object)((Object)nameList).toString());
            extractRecord.set("extractedpeople", (Object)extractedPeopleid);
            extractRecord.set("extractedtime", (Object)extractedTime);
            resultObjectCol[i] = extractRecord;
        }
        SaveServiceHelper.save((DynamicObject[])resultObjectCol);
    }

    private MainEntityType createExtractRecordType() {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)"bid_pro_extract_record");
        return mainType;
    }

    @Override
    public void saveExtractRecord(DynamicObjectCollection extractConditionCol, Map<String, DynamicObject[]> resultMap, Object bidproject, Boolean orgpriority, DynamicObjectCollection orgCol) {
        ArrayList<String> orgIdList = new ArrayList<String>(20);
        ArrayList<String> orgNameList = new ArrayList<String>(100);
        for (int i = 0; i < orgCol.size(); ++i) {
            orgIdList.add(((DynamicObject)orgCol.get(i)).getString("id"));
            orgNameList.add(((DynamicObject)orgCol.get(i)).getString("name"));
        }
        DynamicObject[] resultObjectCol = new DynamicObject[resultMap.size()];
        String extractedPeopleid = RequestContext.get().getUserId();
        Date extractedTime = new Date();
        for (int i = 0; i < resultMap.size(); ++i) {
            MainEntityType extractRecordType = this.createExtractRecordType();
            DynamicObject extractRecord = new DynamicObject((DynamicObjectType)extractRecordType);
            DynamicObject extractCondition = (DynamicObject)extractConditionCol.get(i);
            DynamicObject[] resultCol = resultMap.get(String.format(ResManager.loadKDString((String)"\u6761\u4ef6%s", (String)"BidProficientExtractServiceImpl_0", (String)"scm-bid-business", (Object[])new Object[0]), i + 1));
            ArrayList<String> idList = new ArrayList<String>(20);
            ArrayList<String> nameList = new ArrayList<String>(100);
            for (int j = 0; j < resultCol.length; ++j) {
                idList.add(resultCol[j].getString("id"));
                nameList.add(resultCol[j].getString("name"));
            }
            extractRecord.set("bidproject", bidproject);
            extractRecord.set("proficientsource", extractCondition.get("proficientsource"));
            extractRecord.set("proficienttype", extractCondition.get("proficienttype"));
            extractRecord.set("majortype", extractCondition.get("majortype"));
            extractRecord.set("proficientlevel", extractCondition.get("proficientlevel"));
            extractRecord.set("proficientcount", extractCondition.get("proficientcount"));
            extractRecord.set("extractedresultid", (Object)((Object)idList).toString());
            extractRecord.set("extractedresultname", (Object)((Object)nameList).toString());
            extractRecord.set("extractedpeople", (Object)extractedPeopleid);
            extractRecord.set("extractedtime", (Object)extractedTime);
            extractRecord.set("orgpriority", (Object)orgpriority);
            extractRecord.set("extractedorgid", (Object)((Object)orgIdList).toString());
            extractRecord.set("extractedorgname", (Object)((Object)orgNameList).toString());
            resultObjectCol[i] = extractRecord;
        }
        SaveServiceHelper.save((DynamicObject[])resultObjectCol);
    }
}

