/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.business.bill.serviceImpl;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.bid.business.basedata.serviceImpl.BidServiceImpl;
import kd.scm.bid.business.bill.IBidProjectProcessService;
import kd.scm.bid.common.enums.BidOpenSelectTypeEnum;
import kd.scm.bid.common.enums.BidOpenTypeEnum;
import kd.scm.bid.common.enums.BillStatusEnum;

public class BidProjectProcessServiceImpl
extends BidServiceImpl
implements IBidProjectProcessService {
    private static final String STATUS = "billStatus";
    private static final String PT = "planTime";
    private static final String RT = "realTime";
    private static final String JD = "jdTime";
    private static final String BZ = "bzTime";
    private static final String SP = "spTime";
    private static final Integer index1 = 1;
    private static final Integer index0 = 0;
    private static final String MT = "modifytime";

    @Override
    public Map<String, Map<String, Object>> getProjectProcessData(String projectId) {
        Map<String, Map<String, Object>> proProcessData = new HashMap<String, Map<String, Object>>();
        if (StringUtils.isEmpty((CharSequence)projectId) || "0".equals(projectId)) {
            return proProcessData;
        }
        String selectProps = "id,createtime,submittime,auditdate,modifytime,billstatus,bidproject,supplierinvitation,biddocument,bidpublish,bidopen,bidevaluation,biddecision,setupdate,supplierinvienddate,technicaldocenddate,commercialdocenddate,bidpublishdate,bidopendeadline,bidanswerquestion,answercomplete,biddecisiondate,approachdate,bidevaluationdate,bidbustalk,bidbustalkdate,bidopentype,clarificaiton,bidbottommake,clarificaitondate,bidbottommakedate,doctype,busopenbidtime,bidopentime,techopenbidtime";
        long projectIdLong = Long.parseLong(projectId);
        DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)projectIdLong, (String)"bid_project", (String)selectProps);
        HashMap<String, Boolean> processStatusMap = new HashMap<String, Boolean>();
        processStatusMap.put("zblx", project.getBoolean("bidproject"));
        processStatusMap.put("gfrw", project.getBoolean("supplierinvitation"));
        processStatusMap.put("bsbz", project.getBoolean("biddocument"));
        processStatusMap.put("fb", project.getBoolean("bidpublish"));
        processStatusMap.put("dy", project.getBoolean("bidanswerquestion"));
        processStatusMap.put("kb", project.getBoolean("bidopen"));
        processStatusMap.put("pb", project.getBoolean("bidevaluation"));
        processStatusMap.put("db", project.getBoolean("biddecision"));
        processStatusMap.put("swtp", project.getBoolean("bidbustalk"));
        processStatusMap.put("bdbz", project.getBoolean("bidbottommake"));
        processStatusMap.put("zbjd", project.getBoolean("clarificaiton"));
        proProcessData = processStatusMap.entrySet().stream().filter(Map.Entry::getValue).collect(Collectors.toMap(Map.Entry::getKey, entry -> this.getProProcessData(projectIdLong, selectProps, project, (Map.Entry<String, Boolean>)entry)));
        return proProcessData;
    }

    private Map<String, Object> getProProcessData(Long projectId, String selectProps, DynamicObject project, Map.Entry<String, Boolean> entry) {
        String key = entry.getKey();
        HashMap<String, Object> sinProMap = new HashMap<String, Object>(100);
        if ("zblx".equals(key)) {
            String billStatus = project.getString("billstatus");
            sinProMap.put(STATUS, billStatus);
            sinProMap.put(PT, project.getDate("setupdate"));
            sinProMap.put(RT, project.getDate("auditdate"));
            sinProMap.put(MT, project.getDate(MT));
            BidProjectProcessServiceImpl.setStepIntervalTime(project, null, sinProMap, key);
            return sinProMap;
        }
        if ("gfrw".equals(key)) {
            String selectInvitationProps = "id,createtime,submittime,auditdate,modifytime,billstatus";
            QFilter projectQFilter = new QFilter("bidproject", "=", (Object)projectId);
            DynamicObject currentSupplierInvitation = BusinessDataServiceHelper.loadSingle((String)"bid_supplierinvitation", (String)selectInvitationProps, (QFilter[])new QFilter[]{projectQFilter, new QFilter("billstatus", "!=", (Object)BillStatusEnum.INVALIDXX.getVal())});
            DynamicObject[] historyCol = BusinessDataServiceHelper.load((String)"bid_supplierinvitation", (String)selectInvitationProps, (QFilter[])new QFilter[]{projectQFilter, new QFilter("billstatus", "=", (Object)BillStatusEnum.INVALIDXX.getVal())});
            BidProjectProcessServiceImpl.setStepIntervalTime(currentSupplierInvitation, historyCol, sinProMap, key);
            sinProMap.put(PT, project.getDate("supplierinvienddate"));
            if (currentSupplierInvitation != null) {
                sinProMap.put(STATUS, currentSupplierInvitation.getString("billstatus"));
                sinProMap.put(RT, currentSupplierInvitation.getDate("auditdate"));
                sinProMap.put(MT, currentSupplierInvitation.getDate(MT));
            }
            return sinProMap;
        }
        if ("bsbz".equals(key)) {
            Date td = project.getDate("technicaldocenddate");
            Date bd = project.getDate("commercialdocenddate");
            Date pt = null;
            pt = td != null && bd != null ? (td.compareTo(bd) >= 0 ? td : bd) : (td != null ? td : bd);
            sinProMap.put(PT, pt);
            String sp = "id,createtime,submittime,auditdate,modifytime,billstatus";
            DynamicObject dObj = BusinessDataServiceHelper.loadSingle((String)"bid_biddocument_edit", (String)sp, (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)projectId).and(new QFilter("billstatus", "not in", Arrays.asList(BillStatusEnum.INVALID.getVal(), BillStatusEnum.INVALIDXX.getVal(), BillStatusEnum.ADJUSTING.getVal())))});
            DynamicObject[] historyCol = BusinessDataServiceHelper.load((String)"bid_biddocument_edit", (String)sp, (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)projectId), new QFilter("billstatus", "=", (Object)BillStatusEnum.INVALIDXX.getVal())});
            if (dObj != null) {
                sinProMap.put(STATUS, dObj.getString("billstatus"));
                if (BillStatusEnum.AUDITED.getVal().equals(dObj.getString("billstatus"))) {
                    sinProMap.put(RT, dObj.getDate("auditdate"));
                }
            } else {
                String orderby;
                QFilter[] filters;
                ORM orm = ORM.create();
                DynamicObjectCollection list = orm.query("bid_biddocument_edit", sp, filters = new QFilter[]{new QFilter("bidproject", "=", (Object)projectId)}, orderby = "createtime desc", 1);
                if (list != null && list.size() > 0) {
                    dObj = (DynamicObject)list.get(0);
                    sinProMap.put(STATUS, dObj.getString("billstatus"));
                    sinProMap.put(RT, dObj.getDate("auditdate"));
                    sinProMap.put(MT, dObj.getDate(MT));
                }
            }
            BidProjectProcessServiceImpl.setStepIntervalTime(dObj, historyCol, sinProMap, key);
            return sinProMap;
        }
        if ("fb".equals(key)) {
            sinProMap.put(PT, project.getDate("bidpublishdate"));
            String fbSelectProperties = "id,createtime,auditdate,submittime,realbidpublishdate,billstatus";
            DynamicObject dObj = BusinessDataServiceHelper.loadSingle((String)"bid_bidpublish", (String)fbSelectProperties, (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)projectId).and(new QFilter("billstatus", "not in", Arrays.asList(BillStatusEnum.INVALID.getVal(), BillStatusEnum.ADJUSTING.getVal())))});
            DynamicObject[] historyCol = BusinessDataServiceHelper.load((String)"bid_bidpublish", (String)fbSelectProperties, (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)projectId), new QFilter("billstatus", "=", (Object)BillStatusEnum.INVALID.getVal())});
            if (dObj != null) {
                sinProMap.put(STATUS, dObj.getString("billstatus"));
                sinProMap.put(RT, dObj.getDate("realbidpublishdate"));
            } else {
                String orderby;
                QFilter[] filters;
                ORM orm = ORM.create();
                DynamicObjectCollection list = orm.query("bid_bidpublish", "id,realbidpublishdate,modifytime,billstatus", filters = new QFilter[]{new QFilter("bidproject", "=", (Object)projectId)}, orderby = "createtime desc", 1);
                if (list != null && list.size() > 0) {
                    dObj = (DynamicObject)list.get(0);
                    sinProMap.put(STATUS, dObj.getString("billstatus"));
                    sinProMap.put(RT, dObj.getDate("realbidpublishdate"));
                    sinProMap.put(MT, dObj.getDate(MT));
                }
            }
            BidProjectProcessServiceImpl.setStepIntervalTime(dObj, historyCol, sinProMap, key);
            return sinProMap;
        }
        if ("dy".equals(key)) {
            sinProMap.put(PT, project.getDate("answercomplete"));
            DynamicObject bidproject = BusinessDataServiceHelper.loadSingle((Object)project.getPkValue(), (String)"bid_project");
            boolean supplierinvitation = bidproject.getBoolean("supplierinvitation");
            boolean biddocument = bidproject.getBoolean("biddocument");
            boolean bidpublish = bidproject.getBoolean("bidpublish");
            QFilter filter = new QFilter("bidproject.id", "=", project.getPkValue());
            QFilter qFilter = new QFilter("billstatus", "=", (Object)"C");
            QFilter qFilter2 = new QFilter("billstatus", "=", (Object)"P");
            DynamicObjectCollection supplierinvitationvcoll = QueryServiceHelper.query((String)"bid_supplierinvitation", (String)"billstatus", (QFilter[])new QFilter[]{qFilter, filter});
            DynamicObjectCollection biddocumentcoll = QueryServiceHelper.query((String)"bid_biddocument_edit", (String)"billstatus", (QFilter[])new QFilter[]{qFilter, filter});
            DynamicObjectCollection bidpubliscoll = QueryServiceHelper.query((String)"bid_bidpublish", (String)"billstatus", (QFilter[])new QFilter[]{qFilter2, filter});
            String status = "F";
            if (supplierinvitation) {
                if (biddocument) {
                    if (bidpublish) {
                        if (bidpubliscoll.size() == 0) {
                            status = null;
                        } else if (biddocumentcoll.size() == 0) {
                            status = null;
                        }
                    } else if (biddocumentcoll.size() == 0) {
                        status = null;
                    }
                } else if (bidpublish) {
                    if (bidpubliscoll.size() == 0) {
                        status = null;
                    }
                } else if (supplierinvitationvcoll.size() == 0) {
                    status = null;
                }
            } else if (biddocument) {
                if (bidpublish) {
                    if (bidpubliscoll.size() == 0) {
                        status = null;
                    } else if (biddocumentcoll.size() == 0) {
                        status = null;
                    }
                } else if (biddocumentcoll.size() == 0) {
                    status = null;
                }
            } else if (bidpublish && bidpubliscoll.size() == 0) {
                status = null;
            }
            DynamicObject dObj = BusinessDataServiceHelper.loadSingle((String)"bid_answerquestion", (String)"id,realanswertime,modifytime,billstatus", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)projectId)});
            if (dObj != null && status != null) {
                sinProMap.put(STATUS, dObj.getString("billstatus"));
                sinProMap.put(RT, dObj.getDate("realanswertime"));
                sinProMap.put(MT, dObj.getDate(MT));
            }
            DynamicObject[] bidAnswerQuestionRecoCol = BusinessDataServiceHelper.load((String)"bid_answerquestion_reco", (String)"id,createtime,auditdate,submittime,realanswertime,modifytime,billstatus", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)projectId)});
            long bzIntervalTime = 0L;
            long spIntervalTime = 0L;
            if (bidAnswerQuestionRecoCol != null && bidAnswerQuestionRecoCol.length > 0) {
                for (DynamicObject bidAnswerQuestionReco : bidAnswerQuestionRecoCol) {
                    Date submitTime = bidAnswerQuestionReco.getDate("submittime");
                    Date createTime = bidAnswerQuestionReco.getDate("createtime");
                    Date auditTime = bidAnswerQuestionReco.getDate("auditdate");
                    if (submitTime != null && createTime != null) {
                        bzIntervalTime += submitTime.getTime() - createTime.getTime();
                    }
                    if (auditTime == null || submitTime == null) continue;
                    spIntervalTime += auditTime.getTime() - submitTime.getTime();
                }
            }
            if (dObj != null) {
                sinProMap.put(BZ, BidProjectProcessServiceImpl.getTimeInterval(bzIntervalTime));
                sinProMap.put(SP, BidProjectProcessServiceImpl.getTimeInterval(spIntervalTime));
                long jdIntervalTime = bzIntervalTime + spIntervalTime;
                sinProMap.put(JD, BidProjectProcessServiceImpl.getTimeInterval(jdIntervalTime));
            } else {
                sinProMap.put(JD, " ");
                sinProMap.put(BZ, " ");
                sinProMap.put(SP, " ");
            }
            return sinProMap;
        }
        QFilter qfilter = new QFilter("billstatus", "!=", (Object)"XX");
        if ("kb".equals(key)) {
            Date date = null;
            if ("BUSSINESS".equals(project.getString("doctype"))) {
                date = project.getDate("busopenbidtime");
            } else if ("MULTI".equals(project.getString("doctype"))) {
                if ("UNIONOPEN".equals(project.getString("bidopentype"))) {
                    date = project.getDate("bidopentime");
                } else if ("TECHBUSINESS".equals(project.getString("bidopentype"))) {
                    date = project.getDate("techopenbidtime");
                }
            }
            sinProMap.put(PT, date);
            DynamicObject dObj = null;
            String kbSelectProperties = "id,createtime,rounds,auditdate,submittime,realbidopendate,modifytime,billstatus,opentype";
            DynamicObject[] historyCol = BusinessDataServiceHelper.load((String)"bid_bidopen", (String)kbSelectProperties, (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)projectId), new QFilter("billstatus", "=", (Object)BillStatusEnum.INVALIDXX.getVal())});
            String bidOpenType = project.getString("bidopentype");
            if (StringUtils.equals((CharSequence)BidOpenSelectTypeEnum.UNIONOPEN.getValue(), (CharSequence)bidOpenType)) {
                dObj = BusinessDataServiceHelper.loadSingle((String)"bid_bidopen", (String)kbSelectProperties, (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)projectId), new QFilter("billstatus", "!=", (Object)BillStatusEnum.INVALIDXX.getVal())});
                if (dObj != null) {
                    sinProMap.put(STATUS, dObj.getString("billstatus"));
                    sinProMap.put(RT, dObj.getDate("realbidopendate"));
                    sinProMap.put(MT, dObj.getDate(MT));
                }
                BidProjectProcessServiceImpl.setStepIntervalTime(dObj, historyCol, sinProMap, key);
            } else if (StringUtils.equals((CharSequence)BidOpenSelectTypeEnum.TECHBUSINESS.getValue(), (CharSequence)bidOpenType)) {
                DynamicObject[] dObjs = BusinessDataServiceHelper.load((String)"bid_bidopen", (String)kbSelectProperties, (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)projectId), qfilter});
                if (dObjs != null && dObjs.length == 2) {
                    if (BillStatusEnum.DISBEGIN.getVal().equals(dObjs[index0].getString("billstatus")) && BillStatusEnum.DISBEGIN.getVal().equals(dObjs[index1].getString("billstatus"))) {
                        sinProMap.put(STATUS, dObjs[0].getString("billstatus"));
                        sinProMap.put(RT, dObjs[0].getDate("realbidopendate"));
                        sinProMap.put(MT, dObjs[0].getDate(MT));
                    } else if (BillStatusEnum.OPEN.getVal().equals(dObjs[index0].getString("billstatus")) && BillStatusEnum.OPEN.getVal().equals(dObjs[index1].getString("billstatus"))) {
                        for (DynamicObject curObj : dObjs) {
                            if (!BidOpenTypeEnum.BUSSINESS.getValue().equals(curObj.getString("opentype"))) continue;
                            sinProMap.put(STATUS, curObj.getString("billstatus"));
                            sinProMap.put(RT, curObj.getDate("realbidopendate"));
                            sinProMap.put(MT, curObj.getDate(MT));
                        }
                    } else if (BillStatusEnum.INVALID.getVal().equals(dObjs[index0].getString("billstatus")) && BillStatusEnum.INVALID.getVal().equals(dObjs[index1].getString("billstatus"))) {
                        for (DynamicObject curObj : dObjs) {
                            if (!BidOpenTypeEnum.BUSSINESS.getValue().equals(curObj.getString("opentype"))) continue;
                            sinProMap.put(STATUS, curObj.getString("billstatus"));
                            sinProMap.put(RT, curObj.getDate("realbidopendate"));
                            sinProMap.put(MT, curObj.getDate(MT));
                        }
                    } else {
                        for (DynamicObject curObj : dObjs) {
                            if (!BidOpenTypeEnum.BUSSINESS.getValue().equals(curObj.getString("opentype"))) continue;
                            sinProMap.put(STATUS, BillStatusEnum.SUBMIT.getVal());
                            sinProMap.put(RT, curObj.getDate("realbidopendate"));
                            sinProMap.put(MT, curObj.getDate(MT));
                        }
                    }
                }
                this.setSeparateOpenIntervalTime(dObjs, historyCol, BidOpenSelectTypeEnum.TECHBUSINESS.getValue(), sinProMap, key);
            } else if (StringUtils.equals((CharSequence)BidOpenSelectTypeEnum.BUSSINESSTECH.getValue(), (CharSequence)bidOpenType)) {
                DynamicObject[] dObjs = BusinessDataServiceHelper.load((String)"bid_bidopen", (String)kbSelectProperties, (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)projectId), qfilter});
                if (dObjs != null && dObjs.length == 2) {
                    if (BillStatusEnum.DISBEGIN.getVal().equals(dObjs[index0].getString("billstatus")) && BillStatusEnum.DISBEGIN.getVal().equals(dObjs[index1].getString("billstatus"))) {
                        sinProMap.put(STATUS, dObjs[0].getString("billstatus"));
                        sinProMap.put(RT, dObjs[0].getDate("realbidopendate"));
                        sinProMap.put(MT, dObjs[0].getDate(MT));
                    } else if (BillStatusEnum.OPEN.getVal().equals(dObjs[index0].getString("billstatus")) && BillStatusEnum.OPEN.getVal().equals(dObjs[index1].getString("billstatus"))) {
                        for (DynamicObject curObj : dObjs) {
                            if (!BidOpenTypeEnum.TECHNICAL.getValue().equals(curObj.getString("opentype"))) continue;
                            sinProMap.put(STATUS, curObj.getString("billstatus"));
                            sinProMap.put(RT, curObj.getDate("realbidopendate"));
                            sinProMap.put(MT, curObj.getDate(MT));
                        }
                    } else if (BillStatusEnum.INVALID.getVal().equals(dObjs[index0].getString("billstatus")) && BillStatusEnum.INVALID.getVal().equals(dObjs[index1].getString("billstatus"))) {
                        for (DynamicObject curObj : dObjs) {
                            if (!BidOpenTypeEnum.TECHNICAL.getValue().equals(curObj.getString("opentype"))) continue;
                            sinProMap.put(STATUS, curObj.getString("billstatus"));
                            sinProMap.put(RT, curObj.getDate("realbidopendate"));
                            sinProMap.put(MT, curObj.getDate(MT));
                        }
                    } else {
                        for (DynamicObject curObj : dObjs) {
                            if (!BidOpenTypeEnum.TECHNICAL.getValue().equals(curObj.getString("opentype"))) continue;
                            sinProMap.put(STATUS, BillStatusEnum.SUBMIT.getVal());
                            sinProMap.put(RT, curObj.getDate("realbidopendate"));
                            sinProMap.put(MT, curObj.getDate(MT));
                        }
                    }
                }
                this.setSeparateOpenIntervalTime(dObjs, historyCol, BidOpenSelectTypeEnum.BUSSINESSTECH.getValue(), sinProMap, key);
            } else if ("".equals(bidOpenType) || bidOpenType == null) {
                dObj = BusinessDataServiceHelper.loadSingle((String)"bid_bidopen", (String)kbSelectProperties, (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)projectId), new QFilter("billstatus", "!=", (Object)BillStatusEnum.INVALIDXX.getVal())});
                if (dObj != null) {
                    sinProMap.put(STATUS, dObj.getString("billstatus"));
                    sinProMap.put(RT, dObj.getDate("realbidopendate"));
                    sinProMap.put(MT, dObj.getDate(MT));
                }
                BidProjectProcessServiceImpl.setStepIntervalTime(dObj, historyCol, sinProMap, key);
            }
            return sinProMap;
        }
        if ("pb".equals(key)) {
            sinProMap.put(PT, project.getDate("bidevaluationdate"));
            DynamicObject dObj = null;
            String selectBpProps = "id,createtime,rounds,auditdate,submittime,modifytime,billstatus,evaltype";
            DynamicObject[] historyCol = BusinessDataServiceHelper.load((String)"bid_bidevaluation", (String)selectBpProps, (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)projectId), new QFilter("billstatus", "=", (Object)"XX")});
            String bidOpenType = project.getString("bidopentype");
            if (StringUtils.isEmpty((CharSequence)bidOpenType) || StringUtils.equals((CharSequence)BidOpenSelectTypeEnum.UNIONOPEN.getValue(), (CharSequence)bidOpenType)) {
                dObj = BusinessDataServiceHelper.loadSingle((String)"bid_bidevaluation", (String)selectBpProps, (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)projectId), new QFilter("billstatus", "!=", (Object)BillStatusEnum.INVALIDXX.getVal())});
                if (dObj != null) {
                    sinProMap.put(STATUS, dObj.getString("billstatus"));
                    sinProMap.put(RT, dObj.getDate("auditdate"));
                    sinProMap.put(MT, dObj.getDate(MT));
                }
                BidProjectProcessServiceImpl.setStepIntervalTime(dObj, historyCol, sinProMap, key);
            } else if (StringUtils.equals((CharSequence)BidOpenSelectTypeEnum.TECHBUSINESS.getValue(), (CharSequence)bidOpenType)) {
                DynamicObject[] dObjs = BusinessDataServiceHelper.load((String)"bid_bidevaluation", (String)selectBpProps, (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)projectId), qfilter});
                if (dObjs != null) {
                    if (dObjs.length == 1) {
                        if (BillStatusEnum.DISBEGIN.getVal().equals(dObjs[0].getString("billstatus"))) {
                            sinProMap.put(STATUS, dObjs[0].getString("billstatus"));
                        } else {
                            sinProMap.put(STATUS, BillStatusEnum.SUBMIT.getVal());
                        }
                        sinProMap.put(RT, null);
                        sinProMap.put(MT, null);
                    } else if (dObjs.length == 2) {
                        for (DynamicObject curObj : dObjs) {
                            if (!BidOpenTypeEnum.BUSSINESS.getValue().equals(curObj.getString("evaltype"))) continue;
                            if (BillStatusEnum.DISBEGIN.getVal().equals(curObj.getString("billstatus"))) {
                                sinProMap.put(STATUS, BillStatusEnum.SUBMIT.getVal());
                            } else {
                                sinProMap.put(STATUS, curObj.getString("billstatus"));
                            }
                            sinProMap.put(RT, curObj.getDate("auditdate"));
                            sinProMap.put(MT, curObj.getDate(MT));
                        }
                    }
                    this.setSeparateOpenIntervalTime(dObjs, historyCol, BidOpenSelectTypeEnum.TECHBUSINESS.getValue(), sinProMap, key);
                } else {
                    sinProMap.put(BZ, " ");
                    sinProMap.put(SP, " ");
                    sinProMap.put(JD, " ");
                }
            } else if (StringUtils.equals((CharSequence)BidOpenSelectTypeEnum.BUSSINESSTECH.getValue(), (CharSequence)bidOpenType)) {
                DynamicObject[] dObjs = BusinessDataServiceHelper.load((String)"bid_bidevaluation", (String)selectBpProps, (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)projectId), qfilter});
                if (dObjs != null) {
                    if (dObjs.length == 1) {
                        if (BillStatusEnum.DISBEGIN.getVal().equals(dObjs[0].getString("billstatus"))) {
                            sinProMap.put(STATUS, dObjs[0].getString("billstatus"));
                        } else {
                            sinProMap.put(STATUS, BillStatusEnum.SUBMIT.getVal());
                        }
                        sinProMap.put(RT, null);
                        sinProMap.put(MT, null);
                    } else if (dObjs.length == 2) {
                        for (DynamicObject curObj : dObjs) {
                            if (!BidOpenTypeEnum.TECHNICAL.getValue().equals(curObj.getString("evaltype"))) continue;
                            if (BillStatusEnum.DISBEGIN.getVal().equals(curObj.getString("billstatus"))) {
                                sinProMap.put(STATUS, BillStatusEnum.SUBMIT.getVal());
                            } else {
                                sinProMap.put(STATUS, curObj.getString("billstatus"));
                            }
                            sinProMap.put(RT, curObj.getDate("auditdate"));
                            sinProMap.put(MT, curObj.getDate(MT));
                        }
                    }
                    this.setSeparateOpenIntervalTime(dObjs, historyCol, BidOpenSelectTypeEnum.BUSSINESSTECH.getValue(), sinProMap, key);
                } else {
                    sinProMap.put(BZ, " ");
                    sinProMap.put(SP, " ");
                    sinProMap.put(JD, " ");
                }
            }
            return sinProMap;
        }
        if ("swtp".equals(key)) {
            sinProMap.put(PT, project.getDate("bidbustalkdate"));
            DynamicObject bidproject = BusinessDataServiceHelper.loadSingle((Object)project.getPkValue(), (String)"bid_project");
            boolean biddocument = bidproject.getBoolean("biddocument");
            boolean bidpublish = bidproject.getBoolean("bidpublish");
            boolean bidevaluation = bidproject.getBoolean("bidevaluation");
            boolean bidopen = bidproject.getBoolean("bidopen");
            QFilter qFilter = new QFilter("billstatus", "=", (Object)"XX");
            QFilter qFilter1 = new QFilter("billstatus", "=", (Object)"X");
            QFilter qFilter2 = new QFilter("bidproject.id", "=", (Object)projectId);
            QFilter qFilter3 = new QFilter("billstatus", "=", (Object)"C");
            DynamicObjectCollection supplierinvitationvcoll = QueryServiceHelper.query((String)"bid_supplierinvitation", (String)"billstatus", (QFilter[])new QFilter[]{qFilter2, qFilter});
            DynamicObjectCollection bidpublishcoll = QueryServiceHelper.query((String)"bid_bidpublish", (String)"billstatus", (QFilter[])new QFilter[]{qFilter2, qFilter1});
            DynamicObjectCollection bidpublishcolls = QueryServiceHelper.query((String)"bid_bidpublish", (String)"billstatus", (QFilter[])new QFilter[]{qFilter2, qFilter3});
            DynamicObjectCollection biddocumenteditcoll = QueryServiceHelper.query((String)"bid_biddocument_edit", (String)"billstatus", (QFilter[])new QFilter[]{qFilter2, qFilter3});
            DynamicObjectCollection bidbidopencoll = QueryServiceHelper.query((String)"bid_bidopen", (String)"billstatus", (QFilter[])new QFilter[]{qFilter2});
            boolean bidopens = true;
            for (DynamicObject bidbidopen : bidbidopencoll) {
                String billstatus = bidbidopen.getString("billstatus");
                if (!"D".equals(billstatus) && !"A".equals(billstatus) && !"B".equals(billstatus) && !"I".equals(billstatus) && !"P".equals(billstatus)) continue;
                bidopens = false;
            }
            DynamicObjectCollection bidpubliscoll = QueryServiceHelper.query((String)"bid_bidevaluation", (String)"billstatus", (QFilter[])new QFilter[]{qFilter2});
            boolean publis = true;
            for (DynamicObject bidpublis : bidpubliscoll) {
                String billstatus = bidpublis.getString("billstatus");
                if (!"D".equals(billstatus) && !"A".equals(billstatus) && !"B".equals(billstatus) && !"I".equals(billstatus)) continue;
                publis = false;
            }
            String ststus = "F";
            if (supplierinvitationvcoll.size() > 0 || bidpublishcoll.size() > 0) {
                if (bidpublish) {
                    if (bidevaluation) {
                        if (!publis) {
                            ststus = null;
                        } else if (!bidopens) {
                            ststus = null;
                        }
                    } else if (!bidopens) {
                        ststus = null;
                    }
                } else if (biddocument) {
                    if (bidevaluation) {
                        if (!publis) {
                            ststus = null;
                        } else if (!bidopens) {
                            ststus = null;
                        } else if (biddocumenteditcoll.size() > 0) {
                            ststus = null;
                        }
                    } else if (bidopen) {
                        if (!bidopens) {
                            ststus = null;
                        } else if (biddocumenteditcoll.size() > 0) {
                            ststus = null;
                        }
                    } else if (biddocumenteditcoll.size() > 0) {
                        ststus = null;
                    }
                } else if (bidevaluation) {
                    if (!publis) {
                        ststus = null;
                    } else if (!bidopens) {
                        ststus = null;
                    }
                } else if (bidopen && !bidopens) {
                    ststus = null;
                }
                String selectPropss = "id,auditdate,modifytime,billstatus";
                DynamicObject dObj = BusinessDataServiceHelper.loadSingle((String)"bid_bustalk", (String)selectPropss, (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)projectId), new QFilter("billstatus", "!=", (Object)BillStatusEnum.INVALIDXX.getVal())});
                if (bidpublishcolls.size() == 0 && dObj != null && ststus != null) {
                    sinProMap.put(STATUS, dObj.getString("billstatus"));
                    sinProMap.put(RT, dObj.getDate("auditdate"));
                    sinProMap.put(MT, dObj.getDate(MT));
                }
            } else {
                this.setProcessAuditDateAndStatus("bid_bustalk", "bidproject", projectId, sinProMap);
            }
            String selectSwtpProps = "id,createtime,submittime,auditdate,modifytime,billstatus";
            DynamicObject[] swtpCol = BusinessDataServiceHelper.load((String)"bid_bustalk", (String)selectSwtpProps, (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)projectId), new QFilter("billstatus", "!=", (Object)BillStatusEnum.INVALIDXX.getVal())});
            if (swtpCol != null && swtpCol.length > 0) {
                long jdIntervalTime = 0L;
                long bzIntervalTime = 0L;
                long spIntervalTime = 0L;
                Date submitTime = null;
                Date auditTime = null;
                Date createTime = null;
                for (DynamicObject swtp : swtpCol) {
                    submitTime = swtp.getDate("submittime");
                    auditTime = swtp.getDate("auditdate");
                    createTime = swtp.getDate("createtime");
                    if (auditTime != null && submitTime != null) {
                        spIntervalTime += auditTime.getTime() - submitTime.getTime();
                    }
                    if (submitTime == null || createTime == null) continue;
                    bzIntervalTime += submitTime.getTime() - createTime.getTime();
                }
                jdIntervalTime = bzIntervalTime + spIntervalTime;
                sinProMap.put(BZ, BidProjectProcessServiceImpl.getTimeInterval(bzIntervalTime));
                sinProMap.put(SP, BidProjectProcessServiceImpl.getTimeInterval(spIntervalTime));
                sinProMap.put(JD, BidProjectProcessServiceImpl.getTimeInterval(jdIntervalTime));
            } else {
                sinProMap.put(BZ, " ");
                sinProMap.put(SP, " ");
                sinProMap.put(JD, " ");
            }
            return sinProMap;
        }
        if ("db".equals(key)) {
            sinProMap.put(PT, project.getDate("biddecisiondate"));
            String selectBottomMakeProps = "id,createtime,submittime,auditdate,modifytime,billstatus";
            DynamicObject dObj = BusinessDataServiceHelper.loadSingle((String)"bid_decision", (String)selectBottomMakeProps, (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)projectId), new QFilter("billstatus", "!=", (Object)BillStatusEnum.INVALIDXX.getVal())});
            if (dObj != null) {
                sinProMap.put(STATUS, dObj.getString("billstatus"));
                sinProMap.put(RT, dObj.getDate("auditdate"));
                sinProMap.put(MT, dObj.getDate(MT));
            }
            BidProjectProcessServiceImpl.setStepIntervalTime(dObj, null, sinProMap, key);
            return sinProMap;
        }
        if ("bdbz".equals(key)) {
            sinProMap.put(PT, project.getDate("bidbottommakedate"));
            String selectBottomMakeProps = "id,createtime,submittime,auditdate,modifytime,billstatus";
            DynamicObject dObj = BusinessDataServiceHelper.loadSingle((String)"bid_bottom_make", (String)selectBottomMakeProps, (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)projectId), new QFilter("billstatus", "!=", (Object)BillStatusEnum.INVALIDXX.getVal())});
            if (dObj != null) {
                sinProMap.put(STATUS, dObj.getString("billstatus"));
                sinProMap.put(RT, dObj.getDate("auditdate"));
                sinProMap.put(MT, dObj.getDate(MT));
            }
            BidProjectProcessServiceImpl.setStepIntervalTime(dObj, null, sinProMap, key);
            return sinProMap;
        }
        if ("zbjd".equals(key)) {
            sinProMap.put(PT, project.getDate("clarificaitondate"));
            DynamicObject dObj = BusinessDataServiceHelper.loadSingle((String)"bid_clarificaiton", (String)"id,createtime,auditdate,submittime,releasetime,modifytime,billstatus", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", (Object)projectId), new QFilter("billstatus", "!=", (Object)BillStatusEnum.INVALIDXX.getVal())});
            if (dObj != null) {
                sinProMap.put(STATUS, dObj.getString("billstatus"));
                sinProMap.put(RT, dObj.getDate("releasetime"));
                sinProMap.put(MT, dObj.getDate(MT));
            }
            BidProjectProcessServiceImpl.setStepIntervalTime(dObj, null, sinProMap, key);
            return sinProMap;
        }
        return sinProMap;
    }

    private void setProcessAuditDateAndStatus(String entityName, String bidProPropName, Long bidProPropValue, Map<String, Object> sinProMap) {
        String selectProps = "id,auditdate,modifytime,billstatus";
        DynamicObject dObj = BusinessDataServiceHelper.loadSingle((String)entityName, (String)selectProps, (QFilter[])new QFilter[]{new QFilter(bidProPropName, "=", (Object)bidProPropValue), new QFilter("billstatus", "!=", (Object)BillStatusEnum.INVALIDXX.getVal())});
        if (dObj != null) {
            sinProMap.put(STATUS, dObj.getString("billstatus"));
            sinProMap.put(RT, dObj.getDate("auditdate"));
            sinProMap.put(MT, dObj.getDate(MT));
        }
    }

    public static String getTimeInterval(long intervalTime) {
        if (intervalTime == 0L) {
            return " ";
        }
        DecimalFormat decimalFormat = new DecimalFormat("00");
        long hours = intervalTime / 3600000L;
        long minutes = (intervalTime - hours * 3600000L) / 60000L;
        long s = intervalTime / 1000L - hours * 60L * 60L - minutes * 60L;
        String countTime = "" + decimalFormat.format(hours) + ":" + decimalFormat.format(minutes) + ":" + decimalFormat.format(s);
        return countTime;
    }

    public static void setStepIntervalTime(DynamicObject current, DynamicObject[] historyCol, Map<String, Object> sinProMap, String key) {
        if (current != null) {
            Date realBidOpenDate;
            Date submitTime = current.getDate("submittime");
            Date auditTime = current.getDate("auditdate");
            Date createTime = current.getDate("createtime");
            long jdIntervalTime = 0L;
            if (key.equals("fb")) {
                Date realBidPublishDate = current.getDate("realbidpublishdate");
                if (realBidPublishDate != null && createTime != null) {
                    jdIntervalTime = realBidPublishDate.getTime() - createTime.getTime();
                }
            } else if (key.equals("kb") && (realBidOpenDate = current.getDate("realbidopendate")) != null && createTime != null) {
                jdIntervalTime = realBidOpenDate.getTime() - createTime.getTime();
            }
            long bzIntervalTime = 0L;
            if (submitTime != null && createTime != null) {
                bzIntervalTime = submitTime.getTime() - createTime.getTime();
            }
            long spIntervalTime = 0L;
            if (auditTime != null && submitTime != null) {
                spIntervalTime = auditTime.getTime() - submitTime.getTime();
            }
            if (historyCol != null && historyCol.length > 0) {
                for (DynamicObject history : historyCol) {
                    Date historyBidOpenDate;
                    Date historySubmitTime = history.getDate("submittime");
                    Date historyCreateTime = history.getDate("createtime");
                    Date historyAuditTime = history.getDate("auditdate");
                    if (historySubmitTime != null && historyCreateTime != null) {
                        bzIntervalTime += historySubmitTime.getTime() - historyCreateTime.getTime();
                    }
                    if (historyAuditTime != null && historySubmitTime != null) {
                        spIntervalTime += historyAuditTime.getTime() - historySubmitTime.getTime();
                    }
                    if (key.equals("fb")) {
                        Date historyBidPublishDate = history.getDate("realbidpublishdate");
                        if (historyBidPublishDate == null || historyCreateTime == null) continue;
                        jdIntervalTime += historyBidPublishDate.getTime() - historyCreateTime.getTime();
                        continue;
                    }
                    if (!key.equals("kb") || (historyBidOpenDate = history.getDate("realbidopendate")) == null || historyCreateTime == null) continue;
                    jdIntervalTime += historyBidOpenDate.getTime() - historyCreateTime.getTime();
                }
            }
            sinProMap.put(SP, BidProjectProcessServiceImpl.getTimeInterval(spIntervalTime));
            sinProMap.put(BZ, BidProjectProcessServiceImpl.getTimeInterval(bzIntervalTime));
            if (!key.equals("fb") && !key.equals("kb")) {
                jdIntervalTime = bzIntervalTime + spIntervalTime;
            }
            sinProMap.put(JD, BidProjectProcessServiceImpl.getTimeInterval(jdIntervalTime));
        } else {
            sinProMap.put(JD, " ");
            sinProMap.put(BZ, " ");
            sinProMap.put(SP, " ");
        }
    }

    public void setSeparateOpenIntervalTime(DynamicObject[] currentObj, DynamicObject[] historyCol, String bidOpenType, Map<String, Object> sinProMap, String key) {
        Map<String, Long> intervalTimeMap = this.dealSeparateOpenIntervalTime(currentObj, bidOpenType, key);
        Long bzIntervalTime = 0L;
        Long spIntervalTime = 0L;
        Long jdIntervalTime = 0L;
        if (!CollectionUtils.isEmpty(intervalTimeMap)) {
            bzIntervalTime = intervalTimeMap.get(BZ);
            spIntervalTime = intervalTimeMap.get(SP);
            jdIntervalTime = intervalTimeMap.get(JD);
        }
        HashMap<Integer, ArrayList<Object>> historyMap = new HashMap<Integer, ArrayList<Object>>(16);
        if (historyCol != null && historyCol.length > 0) {
            for (DynamicObject history : historyCol) {
                int rounds = history.getInt("rounds");
                ArrayList<Object> roundsList = (ArrayList<Object>)historyMap.get(rounds);
                if (CollectionUtils.isEmpty((Collection)roundsList)) {
                    roundsList = new ArrayList<Object>();
                    roundsList.add(history);
                    historyMap.put(rounds, roundsList);
                    continue;
                }
                roundsList.add(history);
                historyMap.put(rounds, roundsList);
            }
        }
        if (!CollectionUtils.isEmpty(historyMap)) {
            for (Map.Entry entry : historyMap.entrySet()) {
                List dealObj = (List)entry.getValue();
                if (CollectionUtils.isEmpty((Collection)dealObj)) continue;
                DynamicObject[] dealArray = new DynamicObject[dealObj.size()];
                dealObj.toArray(dealArray);
                Map<String, Long> historyIntervalTimeMap = this.dealSeparateOpenIntervalTime(dealArray, bidOpenType, key);
                if (CollectionUtils.isEmpty(historyIntervalTimeMap)) continue;
                bzIntervalTime = bzIntervalTime + historyIntervalTimeMap.get(BZ);
                spIntervalTime = spIntervalTime + historyIntervalTimeMap.get(SP);
                jdIntervalTime = jdIntervalTime + historyIntervalTimeMap.get(JD);
            }
        }
        sinProMap.put(BZ, BidProjectProcessServiceImpl.getTimeInterval(bzIntervalTime));
        sinProMap.put(SP, BidProjectProcessServiceImpl.getTimeInterval(spIntervalTime));
        sinProMap.put(JD, BidProjectProcessServiceImpl.getTimeInterval(jdIntervalTime));
    }

    public Map<String, Long> dealSeparateOpenIntervalTime(DynamicObject[] dealObj, String bidOpenType, String key) {
        HashMap<String, Long> result = new HashMap<String, Long>();
        if (dealObj != null && dealObj.length > 0) {
            Date auditTime1;
            Date submitTime;
            Date index1SubmitTime;
            String firstType;
            String lastType;
            boolean dealObjectLengthFLag;
            boolean flag0 = false;
            boolean flag1 = false;
            boolean bl = dealObjectLengthFLag = dealObj.length > 1;
            if (BidOpenSelectTypeEnum.TECHBUSINESS.getValue().equals(bidOpenType)) {
                lastType = BidOpenTypeEnum.BUSSINESS.getValue();
                firstType = BidOpenTypeEnum.TECHNICAL.getValue();
            } else {
                lastType = BidOpenTypeEnum.TECHNICAL.getValue();
                firstType = BidOpenTypeEnum.BUSSINESS.getValue();
            }
            String typeProperties = null;
            if ("kb".equals(key)) {
                typeProperties = "opentype";
            } else if ("pb".equals(key)) {
                typeProperties = "evaltype";
            }
            Date firstCreateTime = null;
            Date firstSubmitTime = null;
            Date firstAuditTime = null;
            for (DynamicObject deal : dealObj) {
                if (!firstType.equals(deal.getString(typeProperties))) continue;
                firstCreateTime = deal.getDate("createtime");
                firstSubmitTime = deal.getDate("submittime");
                firstAuditTime = deal.getDate("auditdate");
            }
            long bzIntervalTime = 0L;
            long spIntervalTime = 0L;
            long jdIntervalTime = 0L;
            Date submitTime0 = dealObj[index0].getDate("submittime");
            if (submitTime0 != null) {
                flag0 = true;
            }
            if (dealObjectLengthFLag && (index1SubmitTime = dealObj[index1].getDate("submittime")) != null) {
                flag1 = true;
            }
            DynamicObject currentObj = null;
            if (flag0 && flag1) {
                currentObj = dealObj[index0];
                if (dealObjectLengthFLag && !lastType.equals(currentObj.getString(typeProperties))) {
                    currentObj = dealObj[index1];
                }
            } else if (flag0) {
                currentObj = dealObj[index0];
            } else if (flag1) {
                currentObj = dealObj[index1];
            }
            if (currentObj != null && (submitTime = currentObj.getDate("submittime")) != null && firstCreateTime != null) {
                bzIntervalTime = submitTime.getTime() - firstCreateTime.getTime();
            }
            currentObj = null;
            flag0 = false;
            flag1 = false;
            Date auditTime0 = dealObj[index0].getDate("auditdate");
            if (auditTime0 != null) {
                flag0 = true;
            }
            if (dealObjectLengthFLag && (auditTime1 = dealObj[index1].getDate("auditdate")) != null) {
                flag1 = true;
            }
            if (flag0 && flag1) {
                currentObj = dealObj[index0];
                if (dealObjectLengthFLag && !lastType.equals(currentObj.getString(typeProperties))) {
                    currentObj = dealObj[index1];
                }
            } else if (flag0) {
                currentObj = dealObj[index0];
            } else if (flag1) {
                currentObj = dealObj[index1];
            }
            if (currentObj != null) {
                Date auditTime = currentObj.getDate("auditdate");
                if (auditTime == null) {
                    auditTime = firstAuditTime;
                }
                if (auditTime != null && firstSubmitTime != null) {
                    spIntervalTime = auditTime.getTime() - firstSubmitTime.getTime();
                }
            }
            currentObj = null;
            flag0 = false;
            flag1 = false;
            if ("kb".equals(key)) {
                Date realBidOpenDate;
                Date openDateTime1;
                Date openDateTime0 = dealObj[index0].getDate("realbidopendate");
                if (openDateTime0 != null) {
                    flag0 = true;
                }
                if (dealObjectLengthFLag && (openDateTime1 = dealObj[index1].getDate("realbidopendate")) != null) {
                    flag1 = true;
                }
                if (flag0 && flag1) {
                    currentObj = dealObj[index0];
                    if (dealObjectLengthFLag && !lastType.equals(currentObj.getString(typeProperties))) {
                        currentObj = dealObj[index1];
                    }
                } else if (flag0) {
                    currentObj = dealObj[index0];
                } else if (flag1) {
                    currentObj = dealObj[index1];
                }
                if (currentObj != null && (realBidOpenDate = currentObj.getDate("realbidopendate")) != null && firstCreateTime != null) {
                    jdIntervalTime = realBidOpenDate.getTime() - firstCreateTime.getTime();
                }
            } else {
                jdIntervalTime = spIntervalTime + bzIntervalTime;
            }
            result.put(SP, spIntervalTime);
            result.put(BZ, bzIntervalTime);
            result.put(JD, jdIntervalTime);
        }
        return result;
    }
}

