/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.business.bill.serviceImpl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.scm.bid.business.basedata.serviceImpl.BidServiceImpl;
import kd.scm.bid.business.bill.IBidProjectService;
import kd.scm.bid.business.helper.BidFileHelper;
import kd.scm.bid.business.helper.BidStepInteractiveHelper;
import kd.scm.bid.common.enums.BidStepEnum;
import kd.scm.bid.common.enums.BillStatusEnum;
import kd.scm.bid.common.enums.RespBusiness;

public class BidProjectServiceImpl
extends BidServiceImpl
implements IBidProjectService {
    @Override
    public DynamicObject getBidProjectById(Long projectId, String selectedfields) {
        QFilter qFilter = new QFilter("id", "=", (Object)projectId);
        return QueryServiceHelper.queryOne((String)"bid_project", (String)selectedfields, (QFilter[])new QFilter[]{qFilter});
    }

    @Override
    public DynamicObjectCollection listBidProjects(String selectedfields) {
        return QueryServiceHelper.query((String)"bid_project", (String)selectedfields, (QFilter[])new QFilter[0]);
    }

    @Override
    public DynamicObjectCollection listBidProjectByIds(Long[] ids, String selectedfields) {
        QFilter qFilter = new QFilter("id", "in", (Object)ids);
        return QueryServiceHelper.query((String)"bid_project", (String)selectedfields, (QFilter[])new QFilter[]{qFilter});
    }

    @Override
    public DynamicObjectCollection listMemberEntryByProjectId(Long projectId) {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)"bid_project");
        DynamicObject[] project = BusinessDataServiceHelper.load((Object[])new Long[]{projectId}, (DynamicObjectType)mainType);
        DynamicObjectCollection memberEntities = project[0].getDynamicObjectCollection("memberentity");
        return memberEntities;
    }

    @Override
    public DynamicObjectCollection listLeaderEntryByProjectId(Long projectId) {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)"bid_project");
        DynamicObject[] project = BusinessDataServiceHelper.load((Object[])new Long[]{projectId}, (DynamicObjectType)mainType);
        DynamicObjectCollection leaderEntities = project[0].getDynamicObjectCollection("memberleaderentity");
        return leaderEntities;
    }

    @Override
    public DynamicObject createSectionObject() {
        return (DynamicObject)this.createSectionType().createInstance();
    }

    @Override
    public DynamicObject createPurDetailObject() {
        return (DynamicObject)this.createPurDetailType().createInstance();
    }

    @Override
    public DynamicObject getPurDetailEntry(Object pk) {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)"bid_project");
        EntityType type = (EntityType)mainType.getAllEntities().get("projectentry");
        return BusinessDataServiceHelper.loadSingle((Object)pk, (DynamicObjectType)type);
    }

    @Override
    public EntityType createSectionType() {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)"bid_project");
        EntityType type = (EntityType)mainType.getAllEntities().get("bidsection");
        return type;
    }

    @Override
    public EntityType createPurDetailType() {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)"bid_project");
        EntityType type = (EntityType)mainType.getAllEntities().get("projectentry");
        return type;
    }

    @Override
    public EntityType createProjectType() {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)"bid_project");
        return mainType;
    }

    @Override
    public void savePurProjectSet(String billId) {
        DynamicObject mainObj = BusinessDataServiceHelper.loadSingle((Object)billId, (String)"bid_project");
        String purProjectSet = mainObj.getDynamicObjectCollection("bidsection").stream().flatMap(section -> section.getDynamicObjectCollection("projectentry").stream()).map(purDetail -> purDetail.getDynamicObject("purentryproject")).filter(purProject -> purProject != null).map(purProject -> purProject.getString("fullname")).distinct().collect(Collectors.joining(","));
        if (purProjectSet != null && purProjectSet.length() > 1999) {
            purProjectSet = purProjectSet.substring(0, 1999);
        }
        mainObj.set("purprojectset", (Object)purProjectSet);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{mainObj});
    }

    @Override
    public void saveProjectInvalidStatus(String billId) {
        Long bidProjectId = Long.parseLong(billId);
        DynamicObject mainObj = BusinessDataServiceHelper.loadSingle((Object)bidProjectId, (String)"bid_project");
        List steps = Arrays.stream(BidStepEnum.values()).filter(step -> {
            if (BidStepEnum.BidProject == step) {
                return false;
            }
            return mainObj.getBoolean(step.name().toLowerCase());
        }).collect(Collectors.toList());
        Map<String, String> mapping = this.getStepMapping();
        for (BidStepEnum bidStep : steps) {
            QFilter qFilter = new QFilter("bidproject", "=", (Object)bidProjectId);
            QFilter statusFilter = new QFilter("billstatus", "!=", (Object)"XX");
            DynamicObject[] entitys = BusinessDataServiceHelper.load((String)mapping.get(bidStep.name()), (String)"id,billstatus", (QFilter[])new QFilter[]{qFilter, statusFilter});
            if (entitys == null || entitys.length <= 0) continue;
            List<DynamicObject> es = Arrays.stream(entitys).map(entity -> {
                entity.set("billstatus", (Object)BillStatusEnum.INVALID.getVal());
                return entity;
            }).collect(Collectors.toList());
            BusinessDataServiceHelper.save((IDataEntityType)((DynamicObject)es.get(0)).getDataEntityType(), (Object[])es.toArray(new DynamicObject[0]));
        }
    }

    @Override
    public List<Boolean> listProcesses(Long projectId) {
        String strs = "bidproject,supplierinvitation,biddocument,bidpublish,bidopen,bidevaluation,biddecision,bidanswerquestion,bidbustalk";
        DynamicObject obj = this.getBidProjectById(projectId, strs);
        String[] strArr = strs.split(",");
        ArrayList<Boolean> list = new ArrayList<Boolean>(20);
        for (String str : strArr) {
            list.add(obj.getBoolean(str));
        }
        return list;
    }

    @Override
    public void generatorNextStepBill(Object billId) {
        DynamicObject mainObj = BusinessDataServiceHelper.loadSingle((Object)billId, (String)"bid_project");
        this.createNextStep(mainObj, BidStepEnum.BidProject);
    }

    @Override
    public boolean checkExistNextStepBill(Object billId) {
        boolean flag = false;
        DynamicObject mainObj = BusinessDataServiceHelper.loadSingle((Object)billId, (String)"bid_project", (String)"id");
        BidStepEnum[] steps = BidStepInteractiveHelper.getNextStep(mainObj, BidStepEnum.BidProject);
        if (steps.length == 0) {
            return flag;
        }
        Map<String, String> mapping = this.getStepMapping();
        for (BidStepEnum bidStep : steps) {
            QFilter qFilter = new QFilter("bidproject", "=", billId);
            DynamicObject entity = BusinessDataServiceHelper.loadSingle((String)mapping.get(bidStep.name()), (String)"id,billstatus,bidproject", (QFilter[])new QFilter[]{qFilter});
            if (entity == null || BillStatusEnum.DISBEGIN.getVal().equals(entity.getString("billstatus"))) continue;
            flag = true;
            break;
        }
        return flag;
    }

    @Override
    public void removeExistDisbeginNextStepBill(Object billId) {
        DynamicObject mainObj = BusinessDataServiceHelper.loadSingle((Object)billId, (String)"bid_project", (String)"id");
        BidStepEnum[] steps = BidStepInteractiveHelper.getNextStep(mainObj, BidStepEnum.BidProject);
        if (steps.length == 0) {
            return;
        }
        Map<String, String> mapping = this.getStepMapping();
        for (BidStepEnum bidStep : steps) {
            QFilter qFilter = new QFilter("bidproject", "=", billId).and(new QFilter("billstatus", "=", (Object)BillStatusEnum.DISBEGIN.getVal()));
            Object[] entitys = BusinessDataServiceHelper.load((String)mapping.get(bidStep.name()), (String)"id,billstatus,bidproject", (QFilter[])new QFilter[]{qFilter});
            if (entitys == null || entitys.length <= 0) continue;
            BusinessDataServiceHelper.delete((IDataEntityType)entitys[0].getDataEntityType(), (Object[])entitys);
        }
        this.saveCurrentBidStep(billId, BidStepEnum.BidProject);
    }

    private Map<String, String> getStepMapping() {
        HashMap<String, String> mapping = new HashMap<String, String>();
        mapping.put(BidStepEnum.SupplierInvitation.name(), "bid_supplierinvitation");
        mapping.put(BidStepEnum.BidDocument.name(), "bid_biddocument_edit");
        mapping.put(BidStepEnum.BidPublish.name(), "bid_bidpublish");
        mapping.put(BidStepEnum.Clarificaiton.name(), "bid_clarificaiton");
        mapping.put(BidStepEnum.BidBottomMake.name(), "bid_bottom_make");
        mapping.put(BidStepEnum.BidOpen.name(), "bid_bidopen");
        mapping.put(BidStepEnum.BidEvaluation.name(), "bid_bidevaluation");
        mapping.put(BidStepEnum.BidDecision.name(), "bid_decision");
        mapping.put(BidStepEnum.BidAnswerQuestion.name(), "bid_answerquestion");
        mapping.put(BidStepEnum.BidBustalk.name(), "bid_bustalk");
        return mapping;
    }

    @Override
    public boolean deleteUnStarted(Object bidProjectPK) {
        this.removeExistDisbeginNextStepBill(bidProjectPK);
        return true;
    }

    @Override
    public Set<String> generatorPermissionFilter(Object userId, String respbusinessNo) {
        Long userIdLong = Long.parseLong(userId.toString());
        QFilter qFilter = new QFilter("user", "=", (Object)userIdLong);
        QFilter qFilterL = new QFilter("user", "=", (Object)userIdLong);
        QFilter f = new QFilter("respbusiness", "like", (Object)("%" + respbusinessNo + "%")).or(new QFilter("isdirector", "=", (Object)"1"));
        QFilter l = new QFilter("respbusiness", "like", (Object)("%" + respbusinessNo + "%"));
        if (RespBusiness.RespCreateDoc.getVal().equals(respbusinessNo)) {
            f.or(new QFilter("respbusiness", "like", (Object)("%" + RespBusiness.TechnicalDoc.getVal() + "%"))).or(new QFilter("respbusiness", "like", (Object)("%" + RespBusiness.CommercialDoc.getVal() + "%")));
            l.or(new QFilter("respbusiness", "like", (Object)("%" + RespBusiness.TechnicalDoc.getVal() + "%"))).or(new QFilter("respbusiness", "like", (Object)("%" + RespBusiness.CommercialDoc.getVal() + "%")));
        }
        if (RespBusiness.BidOpen.getVal().equals(respbusinessNo)) {
            f.or(new QFilter("respbusiness", "like", (Object)("%" + RespBusiness.TechnicalOpen.getVal() + "%"))).or(new QFilter("respbusiness", "like", (Object)("%" + RespBusiness.BusinessOpen.getVal() + "%")));
            l.or(new QFilter("respbusiness", "like", (Object)("%" + RespBusiness.TechnicalOpen.getVal() + "%"))).or(new QFilter("respbusiness", "like", (Object)("%" + RespBusiness.BusinessOpen.getVal() + "%")));
        }
        if (RespBusiness.BidEvaluation.getVal().equals(respbusinessNo)) {
            f.or(new QFilter("respbusiness", "like", (Object)("%" + RespBusiness.TechnicalEval.getVal() + "%"))).or(new QFilter("respbusiness", "like", (Object)("%" + RespBusiness.BusinessEval.getVal() + "%")));
            l.or(new QFilter("respbusiness", "like", (Object)("%" + RespBusiness.TechnicalEval.getVal() + "%"))).or(new QFilter("respbusiness", "like", (Object)("%" + RespBusiness.BusinessEval.getVal() + "%")));
        }
        qFilter.and(f);
        qFilterL.and(l);
        DynamicObject[] members = BusinessDataServiceHelper.load((String)"bid_memberentity", (String)"entryid,bidproject,respbusiness,isdirector", (QFilter[])new QFilter[]{qFilter});
        DynamicObject[] leaders = BusinessDataServiceHelper.load((String)"bid_leadermemberentity", (String)"entryid,bidproject,respbusiness,isdirector", (QFilter[])new QFilter[]{qFilterL});
        Set<String> bidprojectMembers = Arrays.stream(members).map(member -> member.getString("bidproject")).distinct().collect(Collectors.toSet());
        bidprojectMembers.addAll(Arrays.stream(leaders).map(leader -> leader.getString("bidproject")).distinct().collect(Collectors.toSet()));
        return bidprojectMembers;
    }

    @Override
    public DynamicObject getBidProjectAllById(Long id) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"bid_project");
        boolean isExist = QueryServiceHelper.exists((String)"bid_project", (Object)id);
        if (isExist) {
            return BusinessDataServiceHelper.loadSingle((Object)id, (DynamicObjectType)type);
        }
        return null;
    }

    @Override
    public String getFormId() {
        return "bid_project";
    }

    @Override
    public void saveCurrentBidStep(Object bidProId, BidStepEnum ... steps) {
        DynamicObject mainObj = BusinessDataServiceHelper.loadSingle((Object)bidProId, (String)"bid_project", (String)"id,currentstep");
        String curStepNames = Arrays.stream(steps).map(Enum::name).collect(Collectors.joining(",", ",", ","));
        mainObj.set("currentstep", (Object)curStepNames);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{mainObj});
    }

    @Override
    public void copyAttachment(Object sid, Object id) {
        try (TXHandle h = TX.requiresNew();){
            try {
                BidFileHelper.copyFileFromAToB("bid_project", sid, "attachmentpanel", "bid_project", id, "attachmentpanel");
            }
            catch (Throwable ex) {
                h.markRollback();
                throw ex;
            }
        }
    }

    public boolean checkBidProjectAdminPermission() {
        String permissionItemId = "";
        long userId = Long.parseLong(RequestContext.get().getUserId());
        int result = PermissionServiceHelper.checkFunctionPermission((long)userId, (long)RequestContext.get().getOrgId(), (String)"bid_project", (String)permissionItemId);
        return result == 1;
    }

    @Override
    public boolean checkUniqueName(String entityKey, Long id, String name) {
        QFilter qFilter = new QFilter("name", "=", (Object)name);
        qFilter.and(new QFilter("id", "!=", (Object)id));
        qFilter.and(new QFilter("entitytypeid", "=", (Object)entityKey));
        String billstatus = "X";
        DynamicObject[] colls = BusinessDataServiceHelper.load((String)entityKey, (String)"id,billstatus", (QFilter[])new QFilter[]{qFilter});
        if (colls != null && colls.length > 0) {
            for (DynamicObject idRow : colls) {
                if (idRow.getPkValue().toString().equals(id.toString()) || idRow.getString("billstatus").equals(billstatus)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public DynamicObjectCollection getMaDetailCollectionByProjectAndSec(DynamicObject bidproject, String sectionName) {
        DynamicObjectCollection bidSections = bidproject.getDynamicObjectCollection("bidsection");
        for (DynamicObject bidSection : bidSections) {
            if (!StringUtils.equals((CharSequence)sectionName, (CharSequence)bidSection.getString("sectionname"))) continue;
            return bidSection.getDynamicObjectCollection("projectentry");
        }
        return null;
    }
}

