/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.business.bill.serviceImpl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.business.bill.IBidTransferService;

public class BidTransferServiceImpl
implements IBidTransferService {
    private String appid;
    private String bidProjectEntityName;
    private String bidProjectEntityF7Name;

    public BidTransferServiceImpl() {
    }

    public BidTransferServiceImpl(String appid) {
        this.appid = appid;
        this.bidProjectEntityName = appid + '_' + "project";
        this.bidProjectEntityF7Name = "bid".equalsIgnoreCase(appid) ? "bidproject_f7" : "rebm_bidproject_f7";
    }

    @Override
    public DynamicObject[] getBidProjectByIdsAndFields(List<Object> bidProjectIdSet, String selectProperties) {
        return BusinessDataServiceHelper.load((String)this.bidProjectEntityName, (String)selectProperties, (QFilter[])new QFilter[]{new QFilter("id", "in", bidProjectIdSet)});
    }

    @Override
    public DynamicObject[] getBidProjectF7ByIdsAndFields(List<Object> bidProjectIdSet, String selectProperties) {
        return BusinessDataServiceHelper.load((String)this.bidProjectEntityF7Name, (String)selectProperties, (QFilter[])new QFilter[]{new QFilter("id", "in", bidProjectIdSet)});
    }

    @Override
    public DynamicObject getBidProjectByIdAndFields(Object bidProjectId, String selectProperties) {
        return BusinessDataServiceHelper.loadSingle((String)this.bidProjectEntityName, (String)selectProperties, (QFilter[])new QFilter[]{new QFilter("id", "=", bidProjectId)});
    }

    @Override
    public DynamicObject getBidProjectF7ByIdAndFields(Object bidProjectId, String selectProperties) {
        return BusinessDataServiceHelper.loadSingle((String)this.bidProjectEntityF7Name, (String)selectProperties, (QFilter[])new QFilter[]{new QFilter("id", "=", bidProjectId)});
    }

    @Override
    public List<Object> getBidProjectIdByEditFilter(List<QFilter> filterList) {
        DynamicObjectCollection bidProjects = QueryServiceHelper.query((String)this.bidProjectEntityName, (String)"id", (QFilter[])filterList.toArray(new QFilter[0]));
        if (bidProjects == null || bidProjects.size() == 0) {
            return null;
        }
        List<Object> bidProjectIds = bidProjects.stream().map(bidProject -> bidProject.getLong("id")).collect(Collectors.toList());
        DynamicObjectCollection adjustmentrecords = QueryServiceHelper.query((String)(this.appid + "_adjustmentrecord"), (String)"projectid", (QFilter[])new QFilter[]{new QFilter("projectid", "in", bidProjectIds), new QFilter("billstatus", "!=", (Object)"C")});
        List adjustingProjectid = adjustmentrecords.stream().map(record -> record.getLong("projectid")).collect(Collectors.toList());
        bidProjectIds.removeIf(adjustingProjectid::contains);
        return bidProjectIds;
    }

    @Override
    public void updateBidProjectMemberEntityUser(DynamicObject[] bidProjects, Object userId, Object newUserId) {
        Map<String, List<Object>> bidProjectMemberEntryUserMap = this.getBidProjectMemberEntryUserMap(bidProjects);
        List bidProjectIds = Arrays.stream(bidProjects).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        DynamicObject[] payLists = BusinessDataServiceHelper.load((String)(this.appid + "_pay_list"), (String)"respbusiness,bidproject", (QFilter[])new QFilter[]{new QFilter("bidproject", "in", bidProjectIds)});
        HashMap<Object, List> payListMap = new HashMap<Object, List>(16);
        for (DynamicObject payList : payLists) {
            DynamicObject bidProject = payList.getDynamicObject("bidproject");
            if (bidProject == null) continue;
            List list = payListMap.computeIfAbsent(bidProject.getPkValue(), key -> new ArrayList(16));
            list.add(payList);
        }
        ArrayList patListList = new ArrayList(16);
        for (DynamicObject bidProject : bidProjects) {
            Object bidProjectId = bidProject.getPkValue();
            String leaderKey = "leaderUser" + bidProjectId;
            String userKey = "user" + bidProjectId;
            List leaderUserList = bidProjectMemberEntryUserMap.getOrDefault(leaderKey, new ArrayList(16));
            List userList = bidProjectMemberEntryUserMap.getOrDefault(userKey, new ArrayList(16));
            if (leaderUserList.contains(userId)) {
                this.updateMemberLeaderEntry((Long)userId, newUserId, bidProject, leaderUserList);
            } else {
                this.updateMemberEntityEntry((Long)userId, newUserId, bidProject, userList);
            }
            List list = (List)payListMap.get(bidProjectId);
            if (list == null || list.size() <= 0) continue;
            list.forEach(item -> {
                String[] split;
                StringBuilder sb = new StringBuilder();
                String respbusiness = item.getString("respbusiness");
                if (respbusiness == null || respbusiness.isEmpty()) {
                    return;
                }
                for (String s : split = respbusiness.split(",")) {
                    if (s.isEmpty() || StringUtils.equals((CharSequence)s, (CharSequence)String.valueOf(userId))) continue;
                    sb.append(s);
                    sb.append(',');
                }
                sb.append(newUserId);
                sb.append(',');
                item.set("respbusiness", (Object)sb.toString());
                patListList.add(item);
            });
        }
        SaveServiceHelper.save((DynamicObject[])bidProjects);
        SaveServiceHelper.save((DynamicObject[])patListList.toArray(new DynamicObject[0]));
    }

    public void updateMemberEntityEntry(Long userId, Object newUserId, DynamicObject bidProject, List<Object> userList) {
        DynamicObjectCollection memberEntry = bidProject.getDynamicObjectCollection("memberentity");
        HashMap memberEntryMap = new HashMap(16);
        memberEntry.forEach(entry -> {
            DynamicObject user = entry.getDynamicObject("user");
            if (user == null) {
                return;
            }
            memberEntryMap.put(user.getPkValue(), entry);
        });
        DynamicObject entry2 = (DynamicObject)memberEntryMap.get(userId);
        if (entry2 == null) {
            return;
        }
        if (userList.contains(newUserId)) {
            DynamicObject newUserEntry = (DynamicObject)memberEntryMap.get(newUserId);
            String newUserRespBusiness = newUserEntry.getString("respbusiness");
            String oldUserRespBusiness = entry2.getString("respbusiness");
            boolean isDirector = entry2.getBoolean("isdirector");
            if (isDirector) {
                newUserEntry.set("isdirector", (Object)Boolean.TRUE);
            }
            String[] step = oldUserRespBusiness.split(",");
            StringBuilder sb = new StringBuilder();
            sb.append(newUserRespBusiness);
            sb.append(',');
            for (String s : step) {
                if (newUserRespBusiness.contains(s)) continue;
                sb.append(s);
                sb.append(',');
            }
            newUserEntry.set("respbusiness", (Object)sb.toString());
            memberEntry.remove((Object)entry2);
        } else {
            entry2.set("user", newUserId);
        }
    }

    public void updateMemberLeaderEntry(Long userId, Object newUserId, DynamicObject bidProject, List<Object> leaderUserList) {
        DynamicObjectCollection memberLeaderEntry = bidProject.getDynamicObjectCollection("memberleaderentity");
        HashMap leaderEntryMap = new HashMap(16);
        memberLeaderEntry.forEach(entry -> {
            DynamicObject leadeUser = entry.getDynamicObject("userleader");
            if (leadeUser == null) {
                return;
            }
            leaderEntryMap.put(leadeUser.getPkValue(), entry);
        });
        DynamicObject entry2 = (DynamicObject)leaderEntryMap.get(userId);
        if (entry2 == null) {
            return;
        }
        if (leaderUserList.contains(newUserId)) {
            DynamicObject newUserEntry = (DynamicObject)leaderEntryMap.get(newUserId);
            String newUserRespBusiness = newUserEntry.getString("respbusinessleader");
            String oldUserRespBusiness = entry2.getString("respbusinessleader");
            String[] step = oldUserRespBusiness.split(",");
            StringBuilder sb = new StringBuilder();
            sb.append(newUserRespBusiness);
            sb.append(',');
            for (String s : step) {
                if (newUserRespBusiness.contains(s)) continue;
                sb.append(s);
                sb.append(',');
            }
            boolean iswrite = entry2.getBoolean("iswrite");
            if (iswrite) {
                newUserEntry.set("iswrite", (Object)Boolean.TRUE);
            }
            newUserEntry.set("respbusinessleader", (Object)sb.toString());
            memberLeaderEntry.remove((Object)entry2);
        } else {
            entry2.set("userleader", newUserId);
        }
    }

    @Override
    public Map<String, List<Object>> getBidProjectMemberEntryUserMap(DynamicObject[] bidProjects) {
        HashMap<String, List<Object>> memberEntryUserMap = new HashMap<String, List<Object>>(16);
        if (bidProjects == null || bidProjects.length == 0) {
            return memberEntryUserMap;
        }
        for (DynamicObject bidProject : bidProjects) {
            Object bidProjectId = bidProject.getPkValue();
            String leaderKey = "leaderUser" + bidProjectId;
            List leaderUserIds = memberEntryUserMap.computeIfAbsent(leaderKey, k -> new ArrayList(16));
            DynamicObjectCollection memberLeaderEntry = bidProject.getDynamicObjectCollection("memberleaderentity");
            memberLeaderEntry.forEach(entry -> {
                DynamicObject leaderUser = entry.getDynamicObject("userleader");
                if (leaderUser == null) {
                    return;
                }
                leaderUserIds.add(leaderUser.getPkValue());
            });
            String userKey = "user" + bidProjectId;
            List userIds = memberEntryUserMap.computeIfAbsent(userKey, k -> new ArrayList(16));
            DynamicObjectCollection memberEntityEntry = bidProject.getDynamicObjectCollection("memberentity");
            memberEntityEntry.forEach(entry -> {
                DynamicObject user = entry.getDynamicObject("user");
                if (user == null) {
                    return;
                }
                userIds.add(user.getPkValue());
            });
        }
        return memberEntryUserMap;
    }

    @Override
    public List<DynamicObject> getBidProjectSubEntryPurProject(DynamicObject bidProject) {
        ArrayList<DynamicObject> projectList = new ArrayList<DynamicObject>(16);
        DynamicObjectCollection bidSection = bidProject.getDynamicObjectCollection("bidsection");
        bidSection.forEach(section -> {
            DynamicObjectCollection projectEntry = section.getDynamicObjectCollection("projectentry");
            projectEntry.forEach(entry -> {
                DynamicObject purentryProject = entry.getDynamicObject("purentryproject");
                if (purentryProject == null) {
                    return;
                }
                this.addIfAbsent(projectList, purentryProject, (DynamicObject)entry);
            });
        });
        return projectList;
    }

    public void addIfAbsent(List<DynamicObject> projectList, DynamicObject purentryProject, DynamicObject entry) {
        Set purprojectIdsSet = projectList.stream().map(e -> e.getDynamicObject("purentryproject").getPkValue()).collect(Collectors.toSet());
        if (!purprojectIdsSet.contains(purentryProject.getPkValue())) {
            projectList.add(entry);
        }
    }

    @Override
    public String getBidProjectSubEntryPurProjectName(DynamicObject bidProject) {
        List<DynamicObject> projectList = this.getBidProjectSubEntryPurProject(bidProject);
        if (projectList == null || projectList.size() == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        projectList.forEach(item -> {
            String name = item.getDynamicObject("purentryproject").getString("name");
            sb.append(name);
            sb.append(',');
        });
        return sb.toString().isEmpty() ? null : sb.toString().substring(0, sb.toString().lastIndexOf(44));
    }

    @Override
    public Map<Object, DynamicObject> getBidProjectMemberLeaderEntry(DynamicObject bidProject) {
        DynamicObjectCollection memberLeaderEntry = bidProject.getDynamicObjectCollection("memberleaderentity");
        if (memberLeaderEntry == null) {
            return null;
        }
        return memberLeaderEntry.stream().filter(entry -> entry.getDynamicObject("userleader") != null).collect(Collectors.toMap(k -> k.getDynamicObject("userleader").getPkValue(), v -> v, (v1, v2) -> v1));
    }

    @Override
    public Map<Object, DynamicObject> getBidProjectMemberEntityEntry(DynamicObject bidProject) {
        DynamicObjectCollection memberEntityEntry = bidProject.getDynamicObjectCollection("memberentity");
        if (memberEntityEntry == null) {
            return null;
        }
        return memberEntityEntry.stream().filter(entry -> entry.getDynamicObject("user") != null).collect(Collectors.toMap(k -> k.getDynamicObject("user").getPkValue(), v -> v, (v1, v2) -> v1));
    }
}

