/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.business.bill.serviceImpl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.business.bill.IBidSupplierFileService;
import kd.scm.bid.business.bill.IOnlineBidEvalService;
import kd.scm.bid.business.bill.serviceImpl.BidSupplierFileServiceImpl;
import kd.scm.bid.business.helper.BidFileHelper;
import kd.scm.bid.business.helper.EntityTypeHelper;
import kd.scm.bid.business.util.BidProjectChgCreatorUtils;
import kd.scm.bid.business.util.BidUtils;
import kd.scm.bid.common.enums.BidOpenSelectTypeEnum;
import kd.scm.bid.common.enums.BidOpenTypeEnum;
import kd.scm.bid.common.enums.BillStatusEnum;
import kd.scm.bid.common.enums.EvalItemType;

public class OnlineBidEvalServiceImpl
implements IOnlineBidEvalService {
    IBidSupplierFileService supplierFileService = new BidSupplierFileServiceImpl();

    public String[] getS1() {
        return new String[]{ResManager.loadKDString((String)"\u96f6", (String)"OnlineBidEvalServiceImpl_0", (String)"scm-bid-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e00", (String)"OnlineBidEvalServiceImpl_1", (String)"scm-bid-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e8c", (String)"OnlineBidEvalServiceImpl_2", (String)"scm-bid-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e09", (String)"OnlineBidEvalServiceImpl_3", (String)"scm-bid-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u56db", (String)"OnlineBidEvalServiceImpl_4", (String)"scm-bid-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e94", (String)"OnlineBidEvalServiceImpl_5", (String)"scm-bid-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u516d", (String)"OnlineBidEvalServiceImpl_6", (String)"scm-bid-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e03", (String)"OnlineBidEvalServiceImpl_7", (String)"scm-bid-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u516b", (String)"OnlineBidEvalServiceImpl_8", (String)"scm-bid-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e5d", (String)"OnlineBidEvalServiceImpl_9", (String)"scm-bid-business", (Object[])new Object[0])};
    }

    public String[] getS2() {
        return new String[]{ResManager.loadKDString((String)"\u5341", (String)"OnlineBidEvalServiceImpl_10", (String)"scm-bid-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u767e", (String)"OnlineBidEvalServiceImpl_11", (String)"scm-bid-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5343", (String)"OnlineBidEvalServiceImpl_12", (String)"scm-bid-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e07", (String)"OnlineBidEvalServiceImpl_13", (String)"scm-bid-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5341", (String)"OnlineBidEvalServiceImpl_10", (String)"scm-bid-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u767e", (String)"OnlineBidEvalServiceImpl_11", (String)"scm-bid-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5343", (String)"OnlineBidEvalServiceImpl_12", (String)"scm-bid-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4ebf", (String)"OnlineBidEvalServiceImpl_14", (String)"scm-bid-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5341", (String)"OnlineBidEvalServiceImpl_10", (String)"scm-bid-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u767e", (String)"OnlineBidEvalServiceImpl_11", (String)"scm-bid-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5343", (String)"OnlineBidEvalServiceImpl_12", (String)"scm-bid-business", (Object[])new Object[0])};
    }

    @Override
    public void createByLastStep(DynamicObject bidProject) {
        this.createOnlineBidEval(bidProject, 0L, 0L, "init");
    }

    @Override
    public void createByLastStepWhenDelete(DynamicObject bidProject, long proficientCurrentId, long currentOpenId, String timing) {
        this.createOnlineBidEval(bidProject, proficientCurrentId, currentOpenId, timing);
    }

    protected void createOnlineBidEval(DynamicObject bidProject, long proficientCurrentId, long currentOpenId, String timing) {
        if (bidProject == null || bidProject.get("id") == null) {
            return;
        }
        if (currentOpenId == 0L || "delete".equals(timing)) {
            // empty if block
        }
        Long bidProjectId = bidProject.getLong("id");
        DynamicObject project = BusinessDataServiceHelper.loadSingle((Object)bidProjectId, (String)"bid_project");
        String entryEntity = project.getString("entitytypeid");
        QFilter qFilter = new QFilter("bidproject.id", "=", (Object)bidProjectId);
        DynamicObjectCollection bidOpenCheckColl = QueryServiceHelper.query((String)"bid_bidopen", (String)"id,billstatus,opentype,auditdate", (QFilter[])new QFilter[]{qFilter}, (String)"auditdate desc");
        DynamicObject bidOpen = new DynamicObject();
        DynamicObject bid_bidDark = null;
        if (bidOpenCheckColl != null) {
            if (bidOpenCheckColl.size() == 1) {
                if ("bid_project".equals(entryEntity)) {
                    bidOpen = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)bidOpenCheckColl.get(0)).getLong("id"), (String)"bid_bidopen");
                    bid_bidDark = BusinessDataServiceHelper.loadSingle((String)"bid_biddark", (QFilter[])new QFilter[]{new QFilter("bidopen", "=", bidOpen.getPkValue())});
                } else {
                    bidOpen = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)bidOpenCheckColl.get(0)).getLong("id"), (String)"rebm_bidopen");
                    bid_bidDark = BusinessDataServiceHelper.loadSingle((String)"rebm_biddark", (QFilter[])new QFilter[]{new QFilter("bidopen", "=", bidOpen.getPkValue())});
                }
            } else {
                DynamicObject curBidOpen = null;
                for (DynamicObject bidOpenCheck : bidOpenCheckColl) {
                    if (curBidOpen == null) {
                        curBidOpen = bidOpenCheck;
                        continue;
                    }
                    if (bidOpenCheck.getDate("auditdate") != null && curBidOpen.getDate("auditdate") != null && bidOpenCheck.getDate("auditdate").after(curBidOpen.getDate("auditdate"))) {
                        curBidOpen = bidOpenCheck;
                        continue;
                    }
                    if (bidOpenCheck.getDate("auditdate") == null || curBidOpen.getDate("auditdate") != null) continue;
                    curBidOpen = bidOpenCheck;
                }
                if (curBidOpen != null) {
                    if ("bid_project".equals(entryEntity)) {
                        bidOpen = BusinessDataServiceHelper.loadSingle((Object)curBidOpen.getLong("id"), (String)"bid_bidopen");
                        bid_bidDark = BusinessDataServiceHelper.loadSingle((String)"bid_biddark", (QFilter[])new QFilter[]{new QFilter("bidopen", "=", bidOpen.getPkValue())});
                    } else {
                        bidOpen = BusinessDataServiceHelper.loadSingle((Object)curBidOpen.getLong("id"), (String)"rebm_bidopen");
                        bid_bidDark = BusinessDataServiceHelper.loadSingle((String)"rebm_biddark", (QFilter[])new QFilter[]{new QFilter("bidopen", "=", bidOpen.getPkValue())});
                    }
                }
            }
        }
        if (bidOpen != null) {
            String scoremode = bidOpen.getString("scoremode");
            String scoretype = bidOpen.getString("scoretype");
            DynamicObjectCollection bidSectionColl = bidOpen.getDynamicObjectCollection("bidsection");
            DynamicObjectCollection proficientEntryColl = bidOpen.getDynamicObjectCollection("bidopen_proficient");
            DynamicObjectCollection evalItemEntryColl = bidOpen.getDynamicObjectCollection("entryentity");
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"bid_onlinebideval");
            EntityType sectionEntityType = (EntityType)mainEntityType.getAllEntities().get("bidsection");
            MainEntityType scoreDetailEntityType = EntityMetadataCache.getDataEntityType((String)"bid_onlinescoredetail");
            MainEntityType suppDetailEntityType = EntityMetadataCache.getDataEntityType((String)"bid_onlinesupplierdetail");
            boolean darkOnlineBidEval = false;
            boolean darkOpen = false;
            boolean darkNameFlag = false;
            String darkType = "";
            if (bid_bidDark != null) {
                darkOnlineBidEval = bid_bidDark.getBoolean("darkonlinebideval");
                darkOpen = bid_bidDark.getBoolean("darkopen");
                darkNameFlag = bid_bidDark.getBoolean("darknameflag");
                darkType = bid_bidDark.getString("darktype");
            }
            ArrayList<Long> proficientHasIds = new ArrayList<Long>();
            for (int i = 0; i < proficientEntryColl.size(); ++i) {
                DynamicObject section;
                DynamicObject onlineBidEvalT;
                int j;
                DynamicObject proficientEntry = (DynamicObject)proficientEntryColl.get(i);
                DynamicObject proficient = proficientEntry.getDynamicObject("proficient");
                long proficientLongId = proficient.getLong("id");
                if (proficientHasIds.contains(proficientLongId) || proficientCurrentId != 0L && proficientLongId != proficientCurrentId && "delete".equals(timing)) continue;
                proficientHasIds.add(proficientLongId);
                boolean technical = proficientEntry.getBoolean("proficient_technical");
                boolean commercial = proficientEntry.getBoolean("proficient_commercial");
                DynamicObject onlineBidEval = new DynamicObject((DynamicObjectType)mainEntityType);
                onlineBidEval.set("org", (Object)bidProject.getDynamicObject("org"));
                RequestContext requestContext = RequestContext.get();
                onlineBidEval.set("createtime", (Object)new Date());
                onlineBidEval.set("bidproject", (Object)bidOpen.getDynamicObject("bidproject"));
                onlineBidEval.set("bidprojectname", bidOpen.get("bidprojectname"));
                onlineBidEval.set("billno", (Object)(bidOpen.getDynamicObject("bidproject").getString("billno") + "_" + (i + 1)));
                onlineBidEval.set("bidevaluator", (Object)proficient);
                onlineBidEval.set("scoremode", (Object)scoremode);
                onlineBidEval.set("scoretype", (Object)scoretype);
                onlineBidEval.set("technical", (Object)technical);
                onlineBidEval.set("evaluatedmethod", bidOpen.get("evaluatedmethod"));
                onlineBidEval.set("commercial", (Object)commercial);
                onlineBidEval.set("billstatus", (Object)BillStatusEnum.DISBEGIN.getVal());
                onlineBidEval.set("currency", project.get("currency"));
                HashMap<String, DynamicObject> creatorMap = BidProjectChgCreatorUtils.getCreator(bidProject);
                DynamicObject creatorTec = creatorMap.get("13");
                DynamicObject creatorCom = creatorMap.get("14");
                DynamicObject creator = creatorMap.get("07");
                if (technical) {
                    onlineBidEval.set("creator", (Object)(creatorTec == null ? creator : creatorTec));
                } else if (commercial) {
                    onlineBidEval.set("creator", (Object)(creatorCom == null ? creator : creatorCom));
                } else {
                    onlineBidEval.set("creator", (Object)creator);
                }
                if (BidOpenTypeEnum.TECHNICAL.getValue().equals(bidOpen.getString("opentype")) || BidOpenTypeEnum.BUSSINESS.getValue().equals(bidOpen.getString("opentype"))) {
                    onlineBidEval.set("evaltype", (Object)bidOpen.getString("opentype"));
                    if (darkOnlineBidEval && (bidOpen.getString("opentype").equals(darkType) || BidOpenTypeEnum.MULTI.getValue().equals(darkType))) {
                        onlineBidEval.set("isdark", (Object)true);
                    }
                } else if (BidOpenTypeEnum.MULTI.getValue().equals(bidOpen.getString("opentype"))) {
                    if (technical && commercial) {
                        onlineBidEval.set("evaltype", (Object)bidOpen.getString("opentype"));
                    } else if (technical && !commercial) {
                        onlineBidEval.set("evaltype", (Object)BidOpenTypeEnum.TECHNICAL.getValue());
                    } else if (!technical && commercial) {
                        onlineBidEval.set("evaltype", (Object)BidOpenTypeEnum.BUSSINESS.getValue());
                    } else {
                        onlineBidEval.set("evaltype", (Object)bidOpen.getString("opentype"));
                    }
                    if (darkOnlineBidEval && BidOpenTypeEnum.MULTI.getValue().equals(darkType)) {
                        onlineBidEval.set("isdark", (Object)true);
                    }
                }
                if (onlineBidEval.getString("evaltype").equals(BidOpenTypeEnum.BUSSINESS.getValue())) {
                    onlineBidEval.set("creator", (Object)(creatorCom == null ? creator : creatorCom));
                }
                DynamicObjectCollection sectionColl = new DynamicObjectCollection();
                ArrayList<DynamicObject> suppDetailList = new ArrayList<DynamicObject>();
                ArrayList<DynamicObject> scoreDetailList = new ArrayList<DynamicObject>();
                String appId = BidUtils.getAppID(bidOpen.getString("entitytypeid"));
                ArrayList<Long> supplierFileIds = new ArrayList<Long>();
                for (j = 0; j < bidSectionColl.size(); ++j) {
                    DynamicObject bidSection = (DynamicObject)bidSectionColl.get(j);
                    DynamicObject section2 = new DynamicObject((DynamicObjectType)sectionEntityType);
                    Long sectionId = bidSection.getLong("id");
                    section2.set("seq", (Object)(j + 1));
                    section2.set("sectionname", bidSection.get("sectionname"));
                    section2.set("opensrcsectionid", (Object)sectionId);
                    sectionColl.add((Object)section2);
                    int index = 1;
                    DynamicObjectCollection supplierEntryColl = bidSection.getDynamicObjectCollection("supplierentry");
                    for (int k = 0; k < supplierEntryColl.size(); ++k) {
                        DynamicObject supplierComFile;
                        DynamicObject supplierEntry = (DynamicObject)supplierEntryColl.get(k);
                        if (supplierEntry.getBoolean("supplier_isinvalid") || !supplierEntry.getBoolean("supplier_istender")) continue;
                        DynamicObject supplier = supplierEntry.getDynamicObject("supplier");
                        Long supplierId = supplier.getLong("id");
                        DynamicObject supplierTechFile = this.supplierFileService.getOneFileRecordByIds(supplierId, sectionId, "techFile", "id");
                        if (supplierTechFile != null) {
                            supplierFileIds.add(supplierTechFile.getLong("id"));
                        }
                        if ((supplierComFile = this.supplierFileService.getOneFileRecordByIds(supplierId, sectionId, "comFile", "id")) != null) {
                            supplierFileIds.add(supplierComFile.getLong("id"));
                        }
                        DynamicObject suppDetail = new DynamicObject((DynamicObjectType)suppDetailEntityType);
                        suppDetail.set("entryseq", (Object)(k + 1));
                        suppDetail.set("onlinebideval", (Object)onlineBidEval);
                        suppDetail.set("section", (Object)section2);
                        suppDetail.set("supplier", (Object)supplier);
                        suppDetail.set("opensrcsectionid", bidSection.getPkValue());
                        suppDetailList.add(suppDetail);
                        for (int l = 0; l < evalItemEntryColl.size(); ++l) {
                            DynamicObject evalItemEntry = (DynamicObject)evalItemEntryColl.get(l);
                            String type1 = evalItemEntry.getString("type1");
                            DynamicObjectCollection evalItemDetailColl = evalItemEntry.getDynamicObjectCollection("bidopen_evalitementry");
                            for (int m = 0; m < evalItemDetailColl.size(); ++m) {
                                DynamicObject scoreDetail;
                                DynamicObject evalItemDetail = (DynamicObject)evalItemDetailColl.get(m);
                                String type = "";
                                type = EvalItemType.DEFAULT.getVal().equals(type1) ? evalItemDetail.getString("type") : type1;
                                if (BidOpenTypeEnum.MULTI.getValue().equals(bidOpen.getString("opentype"))) {
                                    if ((!EvalItemType.TECHNICAL.getVal().equals(type) || !technical) && (!EvalItemType.COMMERCIAL.getVal().equals(type) || !commercial)) continue;
                                    scoreDetail = new DynamicObject((DynamicObjectType)scoreDetailEntityType);
                                    scoreDetail.set("entryseq", (Object)index++);
                                    scoreDetail.set("onlinebideval", (Object)onlineBidEval);
                                    scoreDetail.set("section", (Object)section2);
                                    scoreDetail.set("supplier", (Object)supplier);
                                    scoreDetail.set("evalitem", (Object)evalItemDetail);
                                    scoreDetail.set("type", (Object)type);
                                    scoreDetail.set("opensrcsectionid", bidSection.getPkValue());
                                    scoreDetailList.add(scoreDetail);
                                    continue;
                                }
                                if ((!technical || !EvalItemType.TECHNICAL.getVal().equals(type) || !BidOpenTypeEnum.TECHNICAL.getValue().equals(bidOpen.getString("opentype"))) && (!commercial || !EvalItemType.COMMERCIAL.getVal().equals(type) || !BidOpenTypeEnum.BUSSINESS.getValue().equals(bidOpen.getString("opentype")))) continue;
                                scoreDetail = new DynamicObject((DynamicObjectType)scoreDetailEntityType);
                                scoreDetail.set("entryseq", (Object)index++);
                                scoreDetail.set("onlinebideval", (Object)onlineBidEval);
                                scoreDetail.set("section", (Object)section2);
                                scoreDetail.set("supplier", (Object)supplier);
                                scoreDetail.set("evalitem", (Object)evalItemDetail);
                                scoreDetail.set("type", (Object)type);
                                scoreDetail.set("opensrcsectionid", bidSection.getPkValue());
                                scoreDetailList.add(scoreDetail);
                            }
                        }
                    }
                }
                onlineBidEval.set("bidsection", (Object)sectionColl);
                if (!(BidOpenTypeEnum.TECHNICAL.getValue().equals(bidOpen.getString("opentype")) && technical || BidOpenTypeEnum.BUSSINESS.getValue().equals(bidOpen.getString("opentype")) && commercial) && !BidOpenTypeEnum.MULTI.getValue().equals(bidOpen.getString("opentype"))) continue;
                EntityTypeHelper.setEntityType(onlineBidEval, "bid_onlinebideval", "bidproject");
                this.setSourcebillID(onlineBidEval, entryEntity);
                this.saveOnlineBidEvaluation(onlineBidEval);
                this.saveSupplierFile(supplierFileIds, onlineBidEval.getLong("id"), appId);
                for (j = 0; j < suppDetailList.size(); ++j) {
                    DynamicObject suppDetail = (DynamicObject)suppDetailList.get(j);
                    onlineBidEvalT = (DynamicObject)suppDetail.get("onlinebideval");
                    suppDetail.set("onlinebideval", (Object)onlineBidEvalT);
                    section = (DynamicObject)suppDetail.get("section");
                    suppDetail.set("section", (Object)section);
                }
                this.saveOnlineSupplierDetail(suppDetailList);
                for (j = 0; j < scoreDetailList.size(); ++j) {
                    DynamicObject scoreDetail = (DynamicObject)scoreDetailList.get(j);
                    onlineBidEvalT = (DynamicObject)scoreDetail.get("onlinebideval");
                    scoreDetail.set("onlinebideval", (Object)onlineBidEvalT);
                    section = (DynamicObject)scoreDetail.get("section");
                    scoreDetail.set("section", (Object)section);
                }
                this.saveOnlineScoreDetail(scoreDetailList);
            }
            if (bid_bidDark != null) {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bid_bidDark});
            }
        }
    }

    @Override
    public void saveOnlineBidEvaluation(DynamicObject onlineBidEval) {
        if (onlineBidEval != null) {
            BusinessDataServiceHelper.save((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bid_onlinebideval"), (Object[])new DynamicObject[]{onlineBidEval});
        }
    }

    public void setSourcebillID(DynamicObject onlineBidEval, String entryEntity) {
        String docType;
        String evaltype = onlineBidEval.getString("evaltype");
        DynamicObject bidProject = onlineBidEval.getDynamicObject("bidproject");
        Object bidprojectId = bidProject.getPkValue();
        QFilter filter = new QFilter("bidproject", "=", bidprojectId);
        QFilter openFilter = new QFilter("billstatus", "!=", (Object)BillStatusEnum.INVALIDXX.getVal());
        QFilter onlinebidevalFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.INVALIDXX.getVal()).and("bidevaluator.id", "=", onlineBidEval.getDynamicObject("bidevaluator").getPkValue());
        String bidopenName = "bid_bidopen";
        String onlinebidevalsName = "bid_onlinebideval";
        if (!entryEntity.startsWith("bid")) {
            bidopenName = "rebm_bidopen";
            onlinebidevalsName = "rebm_onlinebideval";
        }
        String openType = "";
        if ("TECHNICAL".equals(evaltype)) {
            openType = "TECHNICAL";
        } else if ("BUSSINESS".equals(evaltype)) {
            openType = "BUSSINESS";
        } else if ("MULTI".equals(evaltype)) {
            openType = "MULTI";
        }
        String bidOpenType = bidProject.getString("bidopentype");
        if ("UNIONOPEN".equals(bidOpenType)) {
            openType = "MULTI";
        }
        if ("TECHNICAL".equals(docType = bidProject.getString("doctype"))) {
            openType = "TECHNICAL";
        } else if ("BUSSINESS".equals(docType)) {
            openType = "BUSSINESS";
        }
        QFilter openTypeQfilter = new QFilter("opentype", "=", (Object)openType);
        DynamicObject bidopen = BusinessDataServiceHelper.loadSingleFromCache((String)bidopenName, (String)"id,supplierinvitationid,bidpublishid", (QFilter[])new QFilter[]{filter, openFilter, openTypeQfilter});
        QFilter evalTypeQfilter = new QFilter("evaltype", "=", (Object)evaltype);
        DynamicObjectCollection onlinebidevals = QueryServiceHelper.query((String)onlinebidevalsName, (String)"id", (QFilter[])new QFilter[]{filter, evalTypeQfilter, onlinebidevalFilter}, (String)"rounds desc");
        if (bidopen != null) {
            onlineBidEval.set("supplierinvitationid", bidopen.get("supplierinvitationid"));
            onlineBidEval.set("bidpublishid", bidopen.get("bidpublishid"));
            onlineBidEval.set("bidopenid", bidopen.get("id"));
        }
        int rounds = onlinebidevals.size() + 1;
        onlineBidEval.set("listrounds", (Object)String.format(ResManager.loadKDString((String)"\u7b2c%s\u8f6e\u5728\u7ebf\u8bc4\u6807", (String)"OnlineBidEvalServiceImpl_15", (String)"scm-bid-business", (Object[])new Object[0]), this.toChinese(rounds + "")));
        if (onlinebidevals.size() != 0) {
            DynamicObject oldOnlineBidEval = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)onlinebidevals.get(0)).getLong("id"), (String)onlinebidevalsName);
            onlineBidEval.set("sourcebillid", oldOnlineBidEval.get("id"));
            SaveServiceHelper.update((DynamicObject)oldOnlineBidEval);
        }
    }

    public String toChinese(String str) {
        StringBuilder sb = new StringBuilder();
        int n = str.length();
        for (int i = 0; i < n; ++i) {
            int num = str.charAt(i) - 48;
            if (i != n - 1 && num != 0) {
                sb.append(this.getS1()[num]).append(this.getS2()[n - 2 - i]);
                continue;
            }
            sb.append(this.getS1()[num]);
        }
        return sb.toString();
    }

    @Override
    public void saveOnlineSupplierDetail(List<DynamicObject> suppDetailList) {
        if (suppDetailList != null && suppDetailList.size() > 0) {
            Object[] entryArr = new DynamicObject[suppDetailList.size()];
            suppDetailList.toArray(entryArr);
            BusinessDataServiceHelper.save((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bid_onlinesupplierdetail"), (Object[])entryArr);
        }
    }

    @Override
    public void saveOnlineScoreDetail(List<DynamicObject> scoreDetailList) {
        if (scoreDetailList != null && scoreDetailList.size() > 0) {
            Object[] scoreDetailArr = new DynamicObject[scoreDetailList.size()];
            scoreDetailList.toArray(scoreDetailArr);
            BusinessDataServiceHelper.save((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bid_onlinescoredetail"), (Object[])scoreDetailArr);
        }
    }

    public void saveSupplierFile(List<Long> fileIds, Long onLineid, String appId) {
        try (TXHandle h = TX.requiresNew();){
            String fileFormId = appId + "_supplier_file";
            String nowFormId = appId + "_onlinebideval";
            try {
                for (Long fileId : fileIds) {
                    BidFileHelper.copyFileFromAToB(fileFormId, fileId, "attachmentpanelap", nowFormId, onLineid, "attachmentpanelap");
                }
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
    }

    @Override
    public boolean deleteNextStepUnStarted(DynamicObject bidProject) {
        if (bidProject == null || bidProject.get("id") == null) {
            return false;
        }
        Object bidProjectPk = bidProject.getPkValue();
        QFilter qFilter = new QFilter("bidproject.id", "=", bidProjectPk);
        qFilter.and(new QFilter("billstatus", "!=", (Object)BillStatusEnum.INVALID.getVal()));
        QFilter[] qFilters = new QFilter[]{qFilter};
        Object[] onlineBidEvalColl = BusinessDataServiceHelper.load((String)"bid_onlinebideval", (String)"id,billstatus", (QFilter[])qFilters);
        HashSet<Long> onlineBidEvalIdSet = new HashSet<Long>(100);
        for (int i = 0; i < onlineBidEvalColl.length; ++i) {
            DynamicObject onlineBidEval = onlineBidEvalColl[i];
            String billStatus = onlineBidEval.getString("billstatus");
            if (!BillStatusEnum.DISBEGIN.getVal().equals(billStatus)) continue;
            onlineBidEvalIdSet.add(onlineBidEval.getLong("id"));
        }
        qFilter = new QFilter("onlinebideval.id", "in", onlineBidEvalIdSet);
        qFilters = new QFilter[]{qFilter};
        Object[] onlineScoreDetailColl = BusinessDataServiceHelper.load((String)"bid_onlinescoredetail", (String)"id", (QFilter[])qFilters);
        Object[] onlineSupplierDetailColl = BusinessDataServiceHelper.load((String)"bid_onlinesupplierdetail", (String)"id", (QFilter[])qFilters);
        if (onlineBidEvalColl.length > 0) {
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)"bid_onlinebideval");
            MainEntityType scoreType = EntityMetadataCache.getDataEntityType((String)"bid_onlinescoredetail");
            MainEntityType suppType = EntityMetadataCache.getDataEntityType((String)"bid_onlinesupplierdetail");
            BusinessDataServiceHelper.delete((IDataEntityType)type, (Object[])onlineBidEvalColl);
            BusinessDataServiceHelper.delete((IDataEntityType)scoreType, (Object[])onlineScoreDetailColl);
            BusinessDataServiceHelper.delete((IDataEntityType)suppType, (Object[])onlineSupplierDetailColl);
        }
        return true;
    }

    @Override
    public DynamicObject getOnlineBidEval(Long onlineBidEvalId) {
        return BusinessDataServiceHelper.loadSingle((Object)onlineBidEvalId, (String)"bid_onlinebideval");
    }

    @Override
    public DynamicObjectCollection listOnlineSupplierDetailBySections(Long sectionId, String selectFields, String entryEntity) {
        QFilter qFilter = new QFilter("section", "=", (Object)sectionId);
        DynamicObjectCollection onlineSupplierDetailColl = null;
        onlineSupplierDetailColl = entryEntity.startsWith("bid") ? QueryServiceHelper.query((String)"bid_onlinesupplierdetail", (String)selectFields, (QFilter[])new QFilter[]{qFilter}, (String)"entryseq") : QueryServiceHelper.query((String)"rebm_onlinesupplierdetail", (String)selectFields, (QFilter[])new QFilter[]{qFilter}, (String)"entryseq");
        return onlineSupplierDetailColl;
    }

    @Override
    public DynamicObjectCollection listOnlineScoreDetailBySections(Long sectionId, String selectFields, String appId) {
        QFilter qFilter = new QFilter("section", "=", (Object)sectionId);
        DynamicObjectCollection onlineScoreDetailColl = null;
        onlineScoreDetailColl = "bid".equals(appId) ? QueryServiceHelper.query((String)"bid_onlinescoredetail", (String)selectFields, (QFilter[])new QFilter[]{qFilter}, (String)"entryseq") : QueryServiceHelper.query((String)"rebm_onlinescoredetail", (String)selectFields, (QFilter[])new QFilter[]{qFilter}, (String)"entryseq");
        return onlineScoreDetailColl;
    }

    @Override
    public DynamicObjectCollection oneOnlineScoreDetailBySections(Long sectionId, String selectFields, String evalItem, String appId) {
        QFilter qFilter = new QFilter("section", "=", (Object)sectionId).and("evalItem.item", "=", (Object)evalItem);
        DynamicObjectCollection onlineScoreDetailColl = null;
        onlineScoreDetailColl = "bid".equals(appId) ? QueryServiceHelper.query((String)"bid_onlinescoredetail", (String)selectFields, (QFilter[])new QFilter[]{qFilter}, (String)"entryseq") : QueryServiceHelper.query((String)"rebm_onlinescoredetail", (String)selectFields, (QFilter[])new QFilter[]{qFilter}, (String)"entryseq");
        return onlineScoreDetailColl;
    }

    @Override
    public DynamicObjectCollection listOnlineScoreDetails(Long onlinebidevalId, String selectFields, String appId) {
        QFilter qFilter = new QFilter("onlinebideval", "=", (Object)onlinebidevalId);
        DynamicObjectCollection onlineScoreDetailColl = null;
        onlineScoreDetailColl = "bid".equals(appId) ? QueryServiceHelper.query((String)"bid_onlinescoredetail", (String)selectFields, (QFilter[])new QFilter[]{qFilter}, (String)"entryseq") : QueryServiceHelper.query((String)"rebm_onlinescoredetail", (String)selectFields, (QFilter[])new QFilter[]{qFilter}, (String)"entryseq");
        return onlineScoreDetailColl;
    }

    @Override
    public void saveSupplierScoreDetail(List<HashMap<String, Object>> onlineBidEvalScoreList, List<HashMap<String, Object>> entryDataList) {
        Long sectionId;
        HashMap<String, Object> dataMap;
        int i;
        ArrayList<DynamicObject> saveScoreDetailDataList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> saveEntryDataList = new ArrayList<DynamicObject>();
        for (i = 0; i < onlineBidEvalScoreList.size(); ++i) {
            dataMap = onlineBidEvalScoreList.get(i);
            sectionId = (Long)dataMap.get("section");
            Long evalItemId = (Long)dataMap.get("evalitemid");
            Long supplierId = Long.parseLong(dataMap.get("supplierid_").toString());
            Object suppScore = dataMap.get("suppscore_");
            String selectProperties = "id";
            QFilter[] filters = new QFilter[]{new QFilter("evalitem", "=", (Object)evalItemId), new QFilter("supplier", "=", (Object)supplierId), new QFilter("section", "=", (Object)sectionId)};
            DynamicObject onlineScoreDetail = QueryServiceHelper.queryOne((String)"bid_onlinescoredetail", (String)selectProperties, (QFilter[])filters);
            if (onlineScoreDetail == null) continue;
            DynamicObject data = BusinessDataServiceHelper.loadSingle((Object)onlineScoreDetail.getLong("id"), (String)"bid_onlinescoredetail");
            data.set("score", suppScore);
            saveScoreDetailDataList.add(data);
        }
        for (i = 0; i < entryDataList.size(); ++i) {
            dataMap = entryDataList.get(i);
            sectionId = (Long)dataMap.get("section");
            Long supplierId = Long.parseLong(dataMap.get("supplierid_").toString());
            Object technicalScore = dataMap.get("technicalscore");
            Object commercialScore = dataMap.get("commercialscore");
            Object totalScore = dataMap.get("totalscore");
            String selectProperties = "id";
            QFilter[] filters = new QFilter[]{new QFilter("supplier", "=", (Object)supplierId), new QFilter("section", "=", (Object)sectionId)};
            DynamicObject onlineSupplierDetail = QueryServiceHelper.queryOne((String)"bid_onlinesupplierdetail", (String)selectProperties, (QFilter[])filters);
            if (onlineSupplierDetail == null) continue;
            DynamicObject data = BusinessDataServiceHelper.loadSingle((Object)onlineSupplierDetail.getLong("id"), (String)"bid_onlinesupplierdetail");
            data.set("technicalscore", technicalScore);
            data.set("commercialscore", commercialScore);
            data.set("totalscore", totalScore);
            saveEntryDataList.add(data);
        }
        if (saveScoreDetailDataList.size() > 0) {
            BusinessDataServiceHelper.save((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bid_onlinescoredetail"), (Object[])saveScoreDetailDataList.toArray());
        }
        if (saveEntryDataList.size() > 0) {
            BusinessDataServiceHelper.save((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bid_onlinesupplierdetail"), (Object[])saveEntryDataList.toArray());
        }
    }

    @Override
    public int getTypeItemCount(Long sectionId, String type) {
        QFilter[] filters = new QFilter[]{new QFilter("section", "=", (Object)sectionId), new QFilter("type", "=", (Object)type)};
        HashSet<String> evalItemIdSet = new HashSet<String>(100);
        DynamicObjectCollection onlineScoreDetailColl = QueryServiceHelper.query((String)"bid_onlinescoredetail", (String)"id, evalitem.id", (QFilter[])filters);
        for (int i = 0; i < onlineScoreDetailColl.size(); ++i) {
            DynamicObject onlineScoreDetail = (DynamicObject)onlineScoreDetailColl.get(i);
            String evalItemId = onlineScoreDetail.getString("evalitem.id");
            evalItemIdSet.add(evalItemId);
        }
        return evalItemIdSet.size();
    }

    @Override
    public void updateBidEvaluationSupplierScore(DynamicObject bidProject, Long onlineBidEvalId, String evalType) {
        DynamicObject onlinebideval = BusinessDataServiceHelper.loadSingle((Object)onlineBidEvalId, (String)"bid_onlinebideval");
        if (onlinebideval != null) {
            Long proficientId = onlinebideval.getDynamicObject("bidevaluator").getLong("id");
            Long bidProjectId = bidProject.getLong("id");
            String entityType = bidProject.getString("entitytypeid");
            QFilter qFilter1 = new QFilter("bidproject.id", "=", (Object)bidProjectId);
            QFilter qFilter2 = new QFilter("evaltype", "=", (Object)evalType);
            DynamicObjectCollection bidEvaluationColl = QueryServiceHelper.query((String)"bid_bidevaluation", (String)"id", (QFilter[])new QFilter[]{qFilter1, qFilter2}, (String)"createtime desc");
            DynamicObject bidEvaluation = (DynamicObject)bidEvaluationColl.get(0);
            boolean isRebm = "rebm".equals(entityType.split("_")[0]);
            bidEvaluation = isRebm ? BusinessDataServiceHelper.loadSingle((Object)bidEvaluation.getLong("id"), (String)"rebm_bidevaluation") : BusinessDataServiceHelper.loadSingle((Object)bidEvaluation.getLong("id"), (String)"bid_bidevaluation");
            if (bidEvaluation != null) {
                DynamicObjectCollection bidEvalSectColl = bidEvaluation.getDynamicObjectCollection("bidsection");
                ArrayList<DynamicObject> saveScoreDetailDataList = new ArrayList<DynamicObject>();
                for (int i = 0; i < bidEvalSectColl.size(); ++i) {
                    DynamicObject bidEvalSect = (DynamicObject)bidEvalSectColl.get(i);
                    Long bidEvalSectId = bidEvalSect.getLong("id");
                    Long bidEvalSrcSectId = bidEvalSect.getLong("opensrcsectionid");
                    String selectFields = "id,entryseq,technicalscore,commercialscore,totalscore,supplier.id,supplier.number,supplier.name";
                    DynamicObjectCollection onlineSupplierDetailColl = this.listOnlineSupplierDetailBySrcSections(onlineBidEvalId, bidEvalSrcSectId, selectFields, isRebm);
                    for (int j = 0; j < onlineSupplierDetailColl.size(); ++j) {
                        DynamicObject onlineSupplierDetail = (DynamicObject)onlineSupplierDetailColl.get(j);
                        Long supplierId = onlineSupplierDetail.getLong("supplier.id");
                        BigDecimal technicalScore = onlineSupplierDetail.getBigDecimal("technicalscore");
                        BigDecimal commercialScore = onlineSupplierDetail.getBigDecimal("commercialscore");
                        String selectProperties = "id";
                        QFilter[] filters = new QFilter[]{new QFilter("proficient", "=", (Object)proficientId), new QFilter("supplier", "=", (Object)supplierId), new QFilter("section", "=", (Object)bidEvalSectId)};
                        DynamicObject bidEvalScoreDetail = QueryServiceHelper.queryOne((String)"bid_bidevalscoredetail", (String)selectProperties, (QFilter[])filters);
                        if (bidEvalScoreDetail == null) continue;
                        DynamicObject data = BusinessDataServiceHelper.loadSingle((Object)bidEvalScoreDetail.getLong("id"), (String)"bid_bidevalscoredetail");
                        data.set("technicalscore", (Object)technicalScore);
                        data.set("commercialscore", (Object)commercialScore);
                        saveScoreDetailDataList.add(data);
                    }
                }
                if (saveScoreDetailDataList.size() > 0) {
                    BusinessDataServiceHelper.save((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bid_bidevalscoredetail"), (Object[])saveScoreDetailDataList.toArray());
                }
            }
        }
    }

    @Override
    public void updateBidEvaluationSupplierScore(DynamicObject bidProject, List<Long> onlineBidEvalIdList, String evalType) {
        for (int i = 0; i < onlineBidEvalIdList.size(); ++i) {
            Long onlineBidEvalId = onlineBidEvalIdList.get(i);
            this.updateBidEvaluationSupplierScore(bidProject, onlineBidEvalId, evalType);
        }
    }

    @Override
    public void deleteBidEvaluationSupplierScore(DynamicObject bidProject, Long onlineBidEvalId, String evalType) {
        DynamicObject onlinebideval = BusinessDataServiceHelper.loadSingle((Object)onlineBidEvalId, (String)"bid_onlinebideval");
        if (onlinebideval != null) {
            Long proficientId = onlinebideval.getDynamicObject("bidevaluator").getLong("id");
            Long bidProjectId = bidProject.getLong("id");
            String entityType = bidProject.getString("entitytypeid");
            QFilter qFilter_openType = null;
            String bidOpenSelectType = bidProject.getString("bidopentype");
            String docType = bidProject.getString("doctype");
            qFilter_openType = BidOpenSelectTypeEnum.UNIONOPEN.getValue().equals(bidOpenSelectType) ? (BidOpenTypeEnum.BUSSINESS.getValue().equals(docType) ? new QFilter("evaltype", "=", (Object)BidOpenTypeEnum.BUSSINESS.getValue()) : new QFilter("evaltype", "=", (Object)BidOpenTypeEnum.MULTI.getValue())) : new QFilter("evaltype", "=", (Object)evalType);
            DynamicObject bidEvaluation = BusinessDataServiceHelper.loadSingle((String)"bid_bidevaluation", (String)"id", (QFilter[])new QFilter[]{new QFilter("bidproject.id", "=", (Object)bidProjectId), qFilter_openType});
            boolean isRebm = "rebm".equals(entityType.split("_")[0]);
            bidEvaluation = isRebm ? BusinessDataServiceHelper.loadSingle((Object)bidEvaluation.getLong("id"), (String)"rebm_bidevaluation") : BusinessDataServiceHelper.loadSingle((Object)bidEvaluation.getLong("id"), (String)"bid_bidevaluation");
            if (bidEvaluation != null) {
                DynamicObjectCollection bidEvalSectColl = bidEvaluation.getDynamicObjectCollection("bidsection");
                ArrayList<DynamicObject> saveScoreDetailDataList = new ArrayList<DynamicObject>();
                for (int i = 0; i < bidEvalSectColl.size(); ++i) {
                    DynamicObject bidEvalSect = (DynamicObject)bidEvalSectColl.get(i);
                    Long bidEvalSectId = bidEvalSect.getLong("id");
                    Long bidEvalSrcSectId = bidEvalSect.getLong("opensrcsectionid");
                    String selectFields = "id,entryseq,technicalscore,commercialscore,totalscore,supplier.id,supplier.number,supplier.name";
                    DynamicObjectCollection onlineSupplierDetailColl = this.listOnlineSupplierDetailBySrcSections(onlineBidEvalId, bidEvalSrcSectId, selectFields, isRebm);
                    for (int j = 0; j < onlineSupplierDetailColl.size(); ++j) {
                        String selectProperties = "id";
                        DynamicObject onlineSupplierDetail = (DynamicObject)onlineSupplierDetailColl.get(j);
                        Long supplierId = onlineSupplierDetail.getLong("supplier.id");
                        QFilter[] filters = new QFilter[]{new QFilter("proficient", "=", (Object)proficientId), new QFilter("supplier", "=", (Object)supplierId), new QFilter("section", "=", (Object)bidEvalSectId)};
                        DynamicObject bidEvalScoreDetail = QueryServiceHelper.queryOne((String)"bid_bidevalscoredetail", (String)selectProperties, (QFilter[])filters);
                        if (bidEvalScoreDetail == null) continue;
                        DynamicObject data = BusinessDataServiceHelper.loadSingle((Object)bidEvalScoreDetail.getLong("id"), (String)"bid_bidevalscoredetail");
                        data.set("technicalscore", (Object)BigDecimal.ZERO);
                        data.set("commercialscore", (Object)BigDecimal.ZERO);
                        saveScoreDetailDataList.add(data);
                    }
                }
                if (saveScoreDetailDataList.size() > 0) {
                    BusinessDataServiceHelper.save((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bid_bidevalscoredetail"), (Object[])saveScoreDetailDataList.toArray());
                }
            }
        }
    }

    public DynamicObjectCollection listOnlineSupplierDetailBySrcSections(Long onlineBidEvalId, Long srcSectId, String selectFields, boolean isRebm) {
        QFilter[] filters = new QFilter[]{new QFilter("onlinebideval.id", "=", (Object)onlineBidEvalId), new QFilter("opensrcsectionid", "=", (Object)srcSectId)};
        String entityName = "bid_onlinesupplierdetail";
        if (isRebm) {
            entityName = "rebm_onlinesupplierdetail";
        }
        DynamicObjectCollection onlineSupplierDetailColl = QueryServiceHelper.query((String)entityName, (String)selectFields, (QFilter[])filters, (String)"entryseq");
        return onlineSupplierDetailColl;
    }

    @Override
    public boolean checkBidEvaluationUnStarted(DynamicObject bidProject, String openType) {
        QFilter[] qFilters;
        DynamicObject object;
        if (bidProject == null || bidProject.get("id") == null) {
            return false;
        }
        Object bidProjectPk = bidProject.getPkValue();
        QFilter qFilter = new QFilter("bidproject.id", "=", bidProjectPk);
        qFilter.and(new QFilter("billstatus", "not in", (Object)new String[]{"X", "XX"}));
        if (openType != null) {
            qFilter.and(new QFilter("evaltype", "=", (Object)openType));
        }
        return (object = QueryServiceHelper.queryOne((String)"bid_bidevaluation", (String)"billstatus", (QFilter[])(qFilters = new QFilter[]{qFilter}))) == null || BillStatusEnum.DISBEGIN.getVal().equals(object.get("billstatus"));
    }

    @Override
    public DynamicObject[] listOnlineBidEvalByProjectId(Long projectId) {
        QFilter qFilter = new QFilter("bidproject", "=", (Object)projectId).and(new QFilter("billstatus", "!=", (Object)"XX"));
        DynamicObjectCollection onlineBidEvalColl = QueryServiceHelper.query((String)"bid_onlinebideval", (String)"id", (QFilter[])new QFilter[]{qFilter});
        ArrayList<Long> onlineBidEvalList = new ArrayList<Long>(20);
        for (int i = 0; i < onlineBidEvalColl.size(); ++i) {
            DynamicObject onlineBidEval = (DynamicObject)onlineBidEvalColl.get(i);
            onlineBidEvalList.add(onlineBidEval.getLong("id"));
        }
        Object[] pkArray = new Object[onlineBidEvalList.size()];
        onlineBidEvalList.toArray(pkArray);
        return BusinessDataServiceHelper.load((Object[])pkArray, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bid_onlinebideval"));
    }

    @Override
    public void saveOnlineBidEvalInvalidStatus(Long projectId) {
        Object[] onlineBidEvalArr = this.listOnlineBidEvalByProjectId(projectId);
        for (int i = 0; i < onlineBidEvalArr.length; ++i) {
            DynamicObject onlineBidEval = onlineBidEvalArr[i];
            onlineBidEval.set("billstatus", (Object)BillStatusEnum.INVALID.getVal());
        }
        BusinessDataServiceHelper.save((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bid_onlinebideval"), (Object[])onlineBidEvalArr);
    }

    @Override
    public boolean checkOnlineBidEvalUnStarted(DynamicObject bidProject) {
        if (bidProject == null || bidProject.get("id") == null) {
            return false;
        }
        Object bidProjectPk = bidProject.getPkValue();
        QFilter qFilter = new QFilter("bidproject.id", "=", bidProjectPk);
        qFilter.and(new QFilter("billstatus", "!=", (Object)BillStatusEnum.INVALID.getVal()));
        qFilter.and(new QFilter("billstatus", "!=", (Object)BillStatusEnum.DISBEGIN.getVal()));
        QFilter[] qFilters = new QFilter[]{qFilter};
        return QueryServiceHelper.exists((String)"bid_onlinebideval", (QFilter[])qFilters);
    }

    @Override
    public DynamicObject getEvalItemDetail(Long evalItemId) {
        return BusinessDataServiceHelper.loadSingle((Object)evalItemId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bidopenevalitementry_f7"));
    }

    @Override
    public boolean checkOnlineBidEvalHasUnStarted(DynamicObject bidProject) {
        if (bidProject == null || bidProject.get("id") == null) {
            return false;
        }
        Object bidProjectPk = bidProject.getPkValue();
        QFilter qFilter = new QFilter("bidproject.id", "=", bidProjectPk);
        qFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.DISBEGIN.getVal()));
        QFilter[] qFilters = new QFilter[]{qFilter};
        return QueryServiceHelper.exists((String)"bid_onlinebideval", (QFilter[])qFilters);
    }
}

