/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.business.bill.serviceImpl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.business.bill.IBidEvaluationService;
import kd.scm.bid.business.bill.IQuestionClarifyService;
import kd.scm.bid.business.bill.serviceImpl.BidEvaluationServiceImpl;
import kd.scm.bid.business.helper.BidFileHelper;
import kd.scm.bid.common.enums.BidOpenTypeEnum;
import kd.scm.bid.common.enums.BillStatusEnum;
import kd.scm.bid.common.enums.ClarifyStatusEnum;

public class QuestionClarifyServiceImpl
implements IQuestionClarifyService {
    static String TechFileType = "TECH";
    static String CommFileType = "COMM";
    IBidEvaluationService bidEvaluationService = new BidEvaluationServiceImpl();

    @Override
    public Boolean checkRepeatedClarifytheme(Object bidProjectId, String openType, String theme, Object BillPkId, String batchNo) {
        QFilter bidProjectFilter = new QFilter("bidproject.id", "=", bidProjectId);
        QFilter openTypeFilter = new QFilter("clarifytype", "=", (Object)openType);
        QFilter themeFilter = new QFilter("clarifytheme", "=", (Object)theme);
        QFilter idQFilter = new QFilter("id", "!=", BillPkId);
        QFilter[] qFilters = new QFilter[]{bidProjectFilter, openTypeFilter, themeFilter, idQFilter};
        DynamicObject[] qcs = BusinessDataServiceHelper.load((String)"bid_multiquestclarify", (String)"id", (QFilter[])qFilters);
        if (qcs.length > 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public List<QFilter> getCurrentQCListQFilterList(Object bidProjectId, String openType) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        QFilter bidProjectFilter = new QFilter("bidproject.id", "=", bidProjectId);
        qFilters.add(bidProjectFilter);
        QFilter openTypeFilter = new QFilter("openType", "=", (Object)openType);
        qFilters.add(openTypeFilter);
        return qFilters;
    }

    @Override
    public QFilter[] getCurrentQCListQFilters(Object bidProjectId, String openType) {
        QFilter bidProjectFilter = new QFilter("bidproject.id", "=", bidProjectId);
        QFilter openTypeFilter = new QFilter("openType", "=", (Object)openType);
        return new QFilter[]{bidProjectFilter, openTypeFilter};
    }

    @Override
    public void refreshCurrentQCListData(Object bidProjectId, String openType) {
        QFilter[] qFilters = this.getCurrentQCListQFilters(bidProjectId, openType);
        DynamicObject[] datas = BusinessDataServiceHelper.load((String)"bid_questionclarify", (String)"id,billstatus,clarifydeadline", (QFilter[])qFilters);
        if (datas.length > 0) {
            String billstatus = datas[0].getString("billstatus");
            if (ClarifyStatusEnum.INVALID.getValue().equals(billstatus)) {
                return;
            }
        } else {
            return;
        }
        ArrayList<DynamicObject> refreshdatas = new ArrayList<DynamicObject>();
        Date now = new Date();
        for (DynamicObject qc : datas) {
            int compareTo;
            Date clarifydeadline = qc.getDate("clarifydeadline");
            if (clarifydeadline == null || (compareTo = now.compareTo(clarifydeadline)) < 0) continue;
            String billstatus = qc.getString("billstatus");
            if (!ClarifyStatusEnum.UNCLARIFIED.getValue().equals(billstatus)) continue;
            qc.set("billstatus", (Object)ClarifyStatusEnum.NOCLARIFIED.getValue());
            refreshdatas.add(qc);
        }
        if (!refreshdatas.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])refreshdatas.toArray(new DynamicObject[refreshdatas.size()]));
        }
    }

    @Override
    public Boolean checkRepeatedSupplier(Object bidProjectId, String openType, Object supplierId) {
        QFilter bidProjectFilter = new QFilter("bidproject", "=", bidProjectId);
        QFilter supplierFilter = new QFilter("clarifysupplier", "like", (Object)(supplierId + "%"));
        QFilter clarifydeadlineFilter = new QFilter("clarifydeadline", ">", (Object)new Date());
        QFilter billstatusFilter = new QFilter("billstatus", "=", (Object)ClarifyStatusEnum.UNCLARIFIED.getValue());
        QFilter openTypeFilter = new QFilter("openType", "=", (Object)openType);
        DynamicObject clarifyQest = BusinessDataServiceHelper.loadSingle((String)"bid_questionclarify", (String)"id", (QFilter[])new QFilter[]{bidProjectFilter, supplierFilter, clarifydeadlineFilter, billstatusFilter, openTypeFilter});
        if (clarifyQest != null) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean checkRepeatedSupplierAndSection(Object multPk, String openType, Object supplierId, String bidName) {
        QFilter bidProjectFilter = new QFilter("bidproject", "=", multPk);
        QFilter supplierFilter = new QFilter("clarifysupplier", "like", (Object)(supplierId + "%"));
        QFilter clarifydeadlineFilter = new QFilter("clarifydeadline", ">", (Object)new Date());
        QFilter billstatusFilter = new QFilter("billstatus", "=", (Object)ClarifyStatusEnum.UNCLARIFIED.getValue());
        QFilter openTypeFilter = new QFilter("openType", "=", (Object)openType);
        QFilter qSection = new QFilter("bidsection.sectionname", "=", (Object)bidName);
        DynamicObject clarifyQest = BusinessDataServiceHelper.loadSingle((String)"bid_questionclarify", (String)"id", (QFilter[])new QFilter[]{bidProjectFilter, supplierFilter, clarifydeadlineFilter, billstatusFilter, openTypeFilter, qSection});
        if (clarifyQest != null) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public String getBidEvalutionStatus(Object bidProjectId, String openType) {
        QFilter bidProjectQF = new QFilter("bidproject", "=", bidProjectId);
        QFilter evaltypeQF = new QFilter("evaltype", "=", (Object)openType);
        DynamicObject[] bidEval = BusinessDataServiceHelper.load((String)"bid_bidevaluation", (String)"billstatus", (QFilter[])new QFilter[]{bidProjectQF, evaltypeQF}, (String)"createtime desc");
        if (bidEval.length > 0) {
            return bidEval[0].getString("billstatus");
        }
        return "";
    }

    @Override
    public Boolean judgeHaveUnClarifiedData(Object bidprojectId, String openType) {
        QFilter bidProjectFilter = new QFilter("bidproject", "=", bidprojectId);
        QFilter clarifydeadlineFilter = new QFilter("clarifydeadline", ">", (Object)new Date());
        QFilter billstatusFilter = new QFilter("billstatus", "=", (Object)ClarifyStatusEnum.UNCLARIFIED.getValue());
        QFilter openTypeFilter = new QFilter("openType", "=", (Object)openType);
        QFilter isAgainBiddingFilter = new QFilter("is_again_bidding", "!=", (Object)"1");
        DynamicObject clarifyQest = BusinessDataServiceHelper.loadSingle((String)"bid_questionclarify", (String)"id", (QFilter[])new QFilter[]{bidProjectFilter, openTypeFilter, clarifydeadlineFilter, billstatusFilter, isAgainBiddingFilter});
        if (clarifyQest != null) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public void setProjectClarifyDataInvalid(Object bidProjectId) {
        QFilter bidProjectFilter = new QFilter("bidproject", "=", bidProjectId);
        DynamicObject[] clarifyQests = BusinessDataServiceHelper.load((String)"bid_questionclarify", (String)"id,billstatus,supplierlookstatus", (QFilter[])new QFilter[]{bidProjectFilter});
        if (clarifyQests.length > 0) {
            for (DynamicObject clarifyQest : clarifyQests) {
                clarifyQest.set("supplierlookstatus", (Object)clarifyQest.getString("billstatus"));
                clarifyQest.set("billstatus", (Object)ClarifyStatusEnum.INVALID.getValue());
            }
            SaveServiceHelper.save((DynamicObject[])clarifyQests);
        }
    }

    @Override
    public void clarifyWriteBackBidDesicion(String AppId, DynamicObject bidProject) {
        String decisionFormType = "";
        DynamicObject bidProjectCheckType = BusinessDataServiceHelper.loadSingle((Object)bidProject.getPkValue(), (String)"bid_project", (String)"id,entitytypeid");
        decisionFormType = "rebm".equals(bidProjectCheckType.getString("entitytypeid").split("_")[0]) ? "rebm_decision" : "bid_decision";
        DynamicObject bidDecision = BusinessDataServiceHelper.loadSingle((String)decisionFormType, (String)"id,bidsection,bidsection.sectionname,supplierentry,supplierentry.supplier,supplierentry.finalprice,supplierentry.finaltaxrate,supplierentry.finalvat,supplierentry.finalexceptvat,supplierentry.finalrate,supplierentry.techfile_new,supplierentry.commfile_new,supfinaldetail,supfinaldetail.lpursupplier,supfinaldetail.lpurentrycontent,supfinaldetail.lpurentryproject,supfinaldetail.lresourceitem,supfinaldetail.lmaterialid,supfinaldetail.lmaterialdes,supfinaldetail.lqty,supfinaldetail.linclutaxprice,supfinaldetail.linclutaxamount,supfinaldetail.lbd_taxrate,supfinaldetail.ltaxrate,supfinaldetail.ltaxamount,supfinaldetail.lexcepttaxamount,supfinaldetail.lcostrate", (QFilter[])new QFilter[]{new QFilter("bidproject", "=", bidProject.getPkValue()), new QFilter("billstatus", "!=", (Object)BillStatusEnum.INVALIDXX.getVal())});
        if (bidDecision != null) {
            DynamicObjectCollection bidsectioncoll = bidDecision.getDynamicObjectCollection("bidsection");
            boolean enablemultisection = bidProject.getBoolean("enablemultisection");
            for (int i = 0; i < bidsectioncoll.size(); ++i) {
                DynamicObject bidDecisionSection = (DynamicObject)bidsectioncoll.get(i);
                String sectionName = bidDecisionSection.getString("sectionname");
                DynamicObjectCollection supplierentrys = bidDecisionSection.getDynamicObjectCollection("supplierentry");
                DynamicObjectCollection supfinaldetails = bidDecisionSection.getDynamicObjectCollection("supfinaldetail");
                for (int j = 0; j < supplierentrys.size(); ++j) {
                    DynamicObject supplierentry = (DynamicObject)supplierentrys.get(j);
                    DynamicObject supplier = supplierentry.getDynamicObject("supplier");
                    DynamicObject clarifyNewData = this.bidEvaluationService.getBusinessDataFromLatestData(bidProject.getPkValue(), supplier.getPkValue(), enablemultisection, sectionName);
                    this.synLatestSupplierAttFromQcToDidDecision(AppId, bidProject.getPkValue(), supplier.getPkValue(), supplierentry, enablemultisection, sectionName);
                    if (clarifyNewData == null) continue;
                    supplierentry.set("finalprice", clarifyNewData.get("tenderprice"));
                    supplierentry.set("finaltaxrate", clarifyNewData.get("pricevat"));
                    supplierentry.set("finalvat", clarifyNewData.get("tax"));
                    supplierentry.set("finalexceptvat", clarifyNewData.get("notaxtenderprice"));
                    supplierentry.set("finalrate", clarifyNewData.get("rate"));
                    for (int k = 0; k < supfinaldetails.size(); ++k) {
                        DynamicObject supfinaldetail = (DynamicObject)supfinaldetails.get(k);
                        DynamicObject lpursupplier = supfinaldetail.getDynamicObject("lpursupplier");
                        if (!StringUtils.equals((CharSequence)supplier.getPkValue().toString(), (CharSequence)lpursupplier.getPkValue().toString())) continue;
                        String ppurentrycontent = supfinaldetail.getString("lpurentrycontent") == null ? "" : supfinaldetail.getString("lpurentrycontent");
                        String ppurentryprojectid = supfinaldetail.getDynamicObject("lpurentryproject") == null ? "" : supfinaldetail.getDynamicObject("lpurentryproject").getString("id");
                        String pmaterialid = supfinaldetail.getDynamicObject("lmaterialid") == null ? "" : supfinaldetail.getDynamicObject("lmaterialid").getString("id");
                        String pmaterialdes = supfinaldetail.getString("lmaterialdes") == null ? "" : supfinaldetail.getString("lmaterialdes");
                        String presourceitem = "";
                        if ("rebm".equals(AppId)) {
                            presourceitem = supfinaldetail.getDynamicObject("lresourceitem") == null ? "" : supfinaldetail.getDynamicObject("lresourceitem").getString("id");
                        }
                        DynamicObjectCollection sectioncoll = clarifyNewData.getDynamicObjectCollection("bidsection");
                        DynamicObjectCollection supplierdetails = ((DynamicObject)sectioncoll.get(0)).getDynamicObjectCollection("supplierdetail");
                        for (int m = 0; m < supplierdetails.size(); ++m) {
                            DynamicObject supplierdetail = (DynamicObject)supplierdetails.get(m);
                            String purentrycontent = supplierdetail.getString("purentrycontent") == null ? "" : supplierdetail.getString("purentrycontent");
                            String purentryprojectid = supplierdetail.getDynamicObject("purentryproject") == null ? "" : supplierdetail.getDynamicObject("purentryproject").getString("id");
                            String materialid = supplierdetail.getDynamicObject("materialid") == null ? "" : supplierdetail.getDynamicObject("materialid").getString("id");
                            String lmaterialdes = supplierdetail.getString("materialdes") == null ? "" : supplierdetail.getString("materialdes");
                            String resourceitem = "";
                            if ("rebm".equals(AppId)) {
                                String string = resourceitem = supplierdetail.getDynamicObject("resourceitem") == null ? "" : supplierdetail.getDynamicObject("resourceitem").getString("id");
                            }
                            if (!StringUtils.equals((CharSequence)ppurentrycontent, (CharSequence)purentrycontent) || !StringUtils.equals((CharSequence)ppurentryprojectid, (CharSequence)purentryprojectid) || !StringUtils.equals((CharSequence)pmaterialid, (CharSequence)materialid) || !StringUtils.equals((CharSequence)pmaterialdes, (CharSequence)lmaterialdes) || !StringUtils.equals((CharSequence)presourceitem, (CharSequence)resourceitem)) continue;
                            supfinaldetail.set("linclutaxprice", supplierdetail.get("inclutaxprice"));
                            supfinaldetail.set("linclutaxamount", supplierdetail.get("inclutaxamount"));
                            supfinaldetail.set("ltaxrate", supplierdetail.get("taxrate"));
                            supfinaldetail.set("lbd_taxrate", supplierdetail.get("bd_taxrate"));
                            supfinaldetail.set("ltaxamount", supplierdetail.get("taxamount"));
                            supfinaldetail.set("lexcepttaxamount", supplierdetail.get("excepttaxamount"));
                            supfinaldetail.set("lcostrate", supplierdetail.get("costrate"));
                        }
                    }
                }
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bidDecision});
        }
    }

    @Override
    public void synLatestSupplierAttFromQcToDidDecision(String AppId, Object bidProjectId, Object supplierId, DynamicObject supplierentry, boolean enablemultisection, String sectionName) {
        Object commQcId;
        Object techQcId;
        String questionclarifyFormId = "bid_questionclarify";
        String decisionentryfileFormId = "bid_decisionentryfile";
        if ("rebm".equals(AppId)) {
            questionclarifyFormId = "rebm_questionclarify";
            decisionentryfileFormId = "rebm_decisionentryfile";
        }
        Object supDetailIdInDecision = supplierentry.getPkValue();
        DynamicObject DidDecisionAtt = BusinessDataServiceHelper.loadSingle((String)"bid_decisionentryfile", (String)"id", (QFilter[])new QFilter[]{new QFilter("detailid", "=", supDetailIdInDecision)});
        Object DidDecisionAttId = null;
        if (DidDecisionAtt != null) {
            DidDecisionAttId = DidDecisionAtt.getPkValue();
        }
        if ((techQcId = this.getLatestSupplierAttQcId(bidProjectId, supplierId, enablemultisection, sectionName, TechFileType)) != null) {
            List fileList = AttachmentServiceHelper.getAttachments((String)questionclarifyFormId, (Object)techQcId, (String)"techattachment");
            List<DynamicObject> attachments = BidFileHelper.copyToEntryAttachment(fileList);
            DynamicObjectCollection techfile_new = supplierentry.getDynamicObjectCollection("techfile_new");
            techfile_new.forEach(attachment -> attachment.set("fbasedataid", null));
            attachments.forEach(attachment -> techfile_new.addNew().set("fbasedataid", attachment));
        }
        if ((commQcId = this.getLatestSupplierAttQcId(bidProjectId, supplierId, enablemultisection, sectionName, CommFileType)) != null) {
            List fileList = AttachmentServiceHelper.getAttachments((String)questionclarifyFormId, (Object)commQcId, (String)"commercattachment");
            List<DynamicObject> attachments = BidFileHelper.copyToEntryAttachment(fileList);
            DynamicObjectCollection commfile_new = supplierentry.getDynamicObjectCollection("commfile_new");
            commfile_new.forEach(attachment -> attachment.set("fbasedataid", null));
            attachments.forEach(attachment -> commfile_new.addNew().set("fbasedataid", attachment));
        }
    }

    @Override
    public Object getLatestSupplierAttQcId(Object bidProjectId, Object supplierId, boolean enablemultisection, String sectionName, String fileType) {
        QFilter bidProjectFilter = new QFilter("bidproject", "=", bidProjectId);
        QFilter supplierFilter = new QFilter("clarifysupplier", "like", (Object)(supplierId + "%"));
        if (enablemultisection) {
            supplierFilter.and(new QFilter("clarifysupplier", "like", (Object)("%" + sectionName)));
        }
        QFilter billstatusFilter = new QFilter("billstatus", "=", (Object)ClarifyStatusEnum.CLARIFIED.getValue());
        QFilter clarifyTypeFilter = new QFilter("clarifytype", "=", (Object)BidOpenTypeEnum.MULTI.getValue());
        if (TechFileType.equals(fileType)) {
            clarifyTypeFilter.or(new QFilter("clarifytype", "=", (Object)BidOpenTypeEnum.TECHNICAL.getValue()));
        } else if (CommFileType.equals(fileType)) {
            clarifyTypeFilter.or(new QFilter("clarifytype", "=", (Object)BidOpenTypeEnum.BUSSINESS.getValue()));
        }
        QFilter resubmisstendersFilter = new QFilter("resubmisstenders", "=", (Object)Boolean.TRUE);
        String orderBys = "submitdate desc";
        int top = 1;
        DynamicObject[] latestFileDatas = BusinessDataServiceHelper.load((String)"bid_questionclarify", (String)"id", (QFilter[])new QFilter[]{bidProjectFilter, supplierFilter, clarifyTypeFilter, billstatusFilter, resubmisstendersFilter}, (String)orderBys, (int)top);
        if (latestFileDatas.length > 0) {
            return latestFileDatas[0].getPkValue();
        }
        return null;
    }

    @Override
    public boolean checkExistQuery(DynamicObject evation) {
        DynamicObject bidproject = evation.getDynamicObject("bidproject");
        String evaltype = evation.getString("evaltype");
        String entitytypeid = bidproject.getString("entitytypeid");
        String appId = entitytypeid.substring(0, entitytypeid.indexOf(95) + 1);
        StringBuilder buffer = new StringBuilder();
        String formId = buffer.append(appId).append("multiquestclarify").toString();
        QFilter bidProjectFilter = new QFilter("bidevaluationid", "=", evation.getPkValue());
        boolean exists = QueryServiceHelper.exists((String)formId, (QFilter[])new QFilter[]{bidProjectFilter});
        return exists;
    }

    @Override
    public String checkQueryIsProcess(DynamicObject evation) {
        DynamicObject bidproject = evation.getDynamicObject("bidproject");
        String evaltype = evation.getString("evaltype");
        String entitytypeid = bidproject.getString("entitytypeid");
        String appId = entitytypeid.substring(0, entitytypeid.indexOf(95) + 1);
        StringBuilder buffer = new StringBuilder();
        String formId = buffer.append(appId).append("multiquestclarify").toString();
        QFilter bidProjectFilter = new QFilter("bidproject.id", "=", bidproject.getPkValue());
        QFilter filterType = new QFilter("clarifytype", "=", (Object)evaltype);
        DynamicObject[] load = BusinessDataServiceHelper.load((String)formId, (String)"id,billstatus,publicstatis", (QFilter[])new QFilter[]{bidProjectFilter, bidProjectFilter, filterType});
        HashSet<Object> ids = new HashSet<Object>();
        if (load != null && load.length > 0) {
            for (DynamicObject dynamicObject : load) {
                String billstatus = dynamicObject.getString("billstatus");
                String publicstatis = dynamicObject.getString("publicstatis");
                ids.add(dynamicObject.getPkValue());
                if (billstatus.equals("UNCLARIFIED") || billstatus.equals("A") && publicstatis.equals("S") || billstatus.equals("INVALID") || billstatus.equals("INVALIDXX")) continue;
                return ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5904\u7406\u7684\u8d28\u7591/\u6f84\u6e05\u5355\u6216\u8d28\u7591\u51fd\uff0c\u8bf7\u5904\u7406\u5b8c\u6210\u540e\u518d\u8fdb\u884c\u63d0\u4ea4\u64cd\u4f5c\u3002", (String)"QuestionClarifyServiceImpl_0", (String)"scm-bid-business", (Object[])new Object[0]);
            }
        }
        bidProjectFilter = new QFilter("multiquestclarifyid", "in", ids);
        QFilter clarifydeadlineFilter = new QFilter("clarifydeadline", ">", (Object)new Date());
        QFilter billstatusFilter = new QFilter("billstatus", "=", (Object)ClarifyStatusEnum.UNCLARIFIED.getValue());
        buffer.setLength(0);
        formId = buffer.append(appId).append("questionclarify").toString();
        DynamicObject clarifyQest = BusinessDataServiceHelper.loadSingle((String)formId, (String)"id", (QFilter[])new QFilter[]{bidProjectFilter, clarifydeadlineFilter, billstatusFilter});
        if (clarifyQest != null) {
            return ResManager.loadKDString((String)"\u5b58\u5728\u5f85\u6f84\u6e05\u7684\u95ee\u9898\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"QuestionClarifyServiceImpl_1", (String)"scm-bid-business", (Object[])new Object[0]);
        }
        return "";
    }

    @Override
    public String checkQueryIsProcess(Long bidproject, String appId) {
        QFilter qFilter = new QFilter("bidproject", "=", (Object)bidproject);
        DynamicObject[] load = BusinessDataServiceHelper.load((String)(appId + "_multiquestclarify"), (String)"id,billstatus,publicstatis", (QFilter[])new QFilter[]{qFilter});
        if (load != null && load.length > 0) {
            for (int i = 0; i < load.length; ++i) {
                boolean b = this.checkMultiquestclarifyIsEnable(load[i]);
                if (!b) continue;
                return ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5b8c\u6210\u7684\u8d28\u7591\u6f84\u6e05\u8bb0\u5f55\uff0c\u4e0d\u80fd\u6267\u884c\u6b64\u6b21\u64cd\u4f5c\uff01", (String)"QuestionClarifyServiceImpl_2", (String)"scm-bid-business", (Object[])new Object[0]);
            }
        }
        QFilter statusQFilter = new QFilter("billstatus", "=", (Object)"UNCLARIFIED");
        QFilter clarifydeadlineFilter = new QFilter("clarifydeadline", ">", (Object)new Date());
        boolean exists = QueryServiceHelper.exists((String)(appId + "_questionclarify"), (QFilter[])new QFilter[]{qFilter, statusQFilter, clarifydeadlineFilter});
        if (exists) {
            return ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5b8c\u6210\u7684\u5f85\u6f84\u6e05\u95ee\u9898\uff0c\u4e0d\u80fd\u6267\u884c\u6b64\u6b21\u64cd\u4f5c\uff01", (String)"QuestionClarifyServiceImpl_3", (String)"scm-bid-business", (Object[])new Object[0]);
        }
        return "";
    }

    @Override
    public boolean checkMultiquestclarifyIsEnable(DynamicObject multiquestclarify) {
        String billstatus = multiquestclarify.getString("billstatus");
        if ("UNCLARIFIED".equals(billstatus)) {
            return false;
        }
        String publicstatis = multiquestclarify.getString("publicstatis");
        if ("A".equals(billstatus) && "S".equals(publicstatis)) {
            return false;
        }
        return !"INVALID".equals(billstatus) && !"INVALIDXX".equals(billstatus);
    }

    @Override
    public boolean checkQuestionclarifyIsEnable(DynamicObject questionclarify) {
        String billstatus = questionclarify.getString("billstatus");
        return "UNCLARIFIED".equals(billstatus);
    }

    @Override
    public void autiAndunAutiInvalidByProject(Long evaluation, String appId, boolean flag) {
        DynamicObject[] loads;
        QFilter qFilter = new QFilter("bidevaluationid", "=", (Object)evaluation);
        HashSet<Long> queryLetterIds = new HashSet<Long>();
        String multStatus = "INVALIDXX";
        String letterStatus = "XX";
        if (!flag) {
            multStatus = "A";
            letterStatus = "C";
        }
        for (DynamicObject load : loads = BusinessDataServiceHelper.load((String)(appId + "_multiquestclarify"), (String)"id,billstatus,isletter,publicstatis", (QFilter[])new QFilter[]{qFilter})) {
            load.set("billstatus", (Object)multStatus);
            boolean isletter = load.getBoolean("isletter");
            if (!isletter) continue;
            queryLetterIds.add(Long.parseLong(load.getPkValue().toString()));
        }
        SaveServiceHelper.save((DynamicObject[])loads);
        if (queryLetterIds.size() > 0) {
            DynamicObject[] letters;
            String formId = "bid_query_letters";
            if ("rebm".equals(appId)) {
                formId = "rebm_query_letters_inh";
            }
            for (DynamicObject letter : letters = BusinessDataServiceHelper.load((String)formId, (String)"id,status", (QFilter[])new QFilter[]{new QFilter("queryid", "in", queryLetterIds)})) {
                letter.set("status", (Object)letterStatus);
            }
            SaveServiceHelper.save((DynamicObject[])letters);
        }
    }
}

