/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.business.bill.serviceImpl;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.business.basedata.serviceImpl.BidServiceImpl;
import kd.scm.bid.business.basedata.serviceImpl.SupplierStatisticServiceImpl;
import kd.scm.bid.business.bill.ISupplierInvitationService;
import kd.scm.bid.business.bill.serviceImpl.BidProjectServiceImpl;
import kd.scm.bid.business.helper.BidStepInteractiveHelper;
import kd.scm.bid.business.helper.EntityTypeHelper;
import kd.scm.bid.business.util.BidProjectChgCreatorUtils;
import kd.scm.bid.common.constant.FormTypeConstants;
import kd.scm.bid.common.enums.BidStepEnum;
import kd.scm.bid.common.enums.BillStatusEnum;
import kd.scm.bid.common.enums.MyTenderStatus;
import kd.scm.bid.common.util.MessageCenterHelper;
import kd.scm.bid.common.util.MessageChannelUtil;

public class SupplierInvitationServiceImpl
extends BidServiceImpl
implements ISupplierInvitationService {
    public DynamicObjectType getEntryType(String entryName) {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)"bid_supplierinvitation");
        EntityType type = (EntityType)mainType.getAllEntities().get(entryName);
        return type;
    }

    @Override
    public void createByLastStep(DynamicObject bidProject, BidStepEnum lastStep) {
        if (bidProject == null || bidProject.get("id") == null) {
            return;
        }
        DynamicObject tempObj = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(bidProject.getPkValue().toString()), (String)"bid_project", (String)"id,entitytypeid");
        String entityTypePre = tempObj.getString("entitytypeid").split("_")[0];
        DynamicObject[] bidProjects = null;
        if ("bid".equals(entityTypePre)) {
            bidProjects = BusinessDataServiceHelper.load((Object[])new Object[]{bidProject.get("id")}, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bid_project"));
        } else if ("rebm".equals(entityTypePre)) {
            bidProjects = BusinessDataServiceHelper.load((Object[])new Object[]{bidProject.get("id")}, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"rebm_project"));
        }
        if (bidProjects == null) {
            return;
        }
        bidProject = bidProjects[0];
        MainEntityType dynObjT = EntityMetadataCache.getDataEntityType((String)"bid_supplierinvitation");
        DynamicObject supplierInvitation = new DynamicObject((DynamicObjectType)dynObjT);
        supplierInvitation.set("bidproject", bidProject.getPkValue());
        supplierInvitation.set("org", bidProject.get("org"));
        supplierInvitation.set("billno", bidProject.get("billno"));
        supplierInvitation.set("billstatus", (Object)BillStatusEnum.DISBEGIN.getVal());
        supplierInvitation.set("currency", bidProject.get("currency"));
        supplierInvitation.set("sortfield", (Object)(bidProject.getString("id") + new Date().getTime()));
        DynamicObjectType sectionEntryType = this.getEntryType("bidsection");
        DynamicObjectType supplierDetailType = this.getEntryType("supplierentry");
        DynamicObjectCollection bidProjSections = bidProject.getDynamicObjectCollection("bidsection");
        DynamicObjectCollection bidRollSections = bidProject.getDynamicObjectCollection("bidrollsection");
        DynamicObjectCollection suppInviSections = new DynamicObjectCollection(sectionEntryType, (Object)supplierInvitation);
        DynamicObjectType sectionEnrollEntryType = this.getEntryType("bidenrollsection");
        DynamicObjectType supplierEnrollDetailType = this.getEntryType("supplierenrollentry");
        DynamicObjectCollection sectionEnrollSections = new DynamicObjectCollection(sectionEnrollEntryType, (Object)supplierInvitation);
        supplierInvitation.set("bidsection", (Object)suppInviSections);
        supplierInvitation.set("bidenrollsection", (Object)sectionEnrollSections);
        HashSet<Object> supplierPks = new HashSet<Object>();
        for (DynamicObject section : bidRollSections) {
            DynamicObject supplierSection = new DynamicObject(sectionEntryType);
            suppInviSections.add((Object)supplierSection);
            supplierSection.set("seq", section.get("seq"));
            supplierSection.set("sectionname", section.get("rollsectionname"));
            DynamicObject supplierEnrollSection = new DynamicObject(sectionEnrollEntryType);
            sectionEnrollSections.add((Object)supplierEnrollSection);
            supplierEnrollSection.set("seq", section.get("seq"));
            supplierEnrollSection.set("entrysectionname", section.get("rollsectionname"));
            DynamicObjectCollection projSuppliers = section.getDynamicObjectCollection("supplierentry");
            DynamicObjectCollection suppInviSuppliers = new DynamicObjectCollection(supplierDetailType, (Object)supplierSection);
            supplierSection.set("supplierentry", (Object)suppInviSuppliers);
            DynamicObjectCollection supplierEnrollSuppliers = new DynamicObjectCollection(supplierEnrollDetailType, (Object)supplierEnrollSection);
            supplierEnrollSection.set("supplierenrollentry", (Object)supplierEnrollSuppliers);
            for (DynamicObject supplier : projSuppliers) {
                DynamicObject supplierEntry = new DynamicObject(supplierDetailType);
                suppInviSuppliers.add((Object)supplierEntry);
                DynamicObject bdSupplier = supplier.getDynamicObject("supplier");
                if (bdSupplier == null) continue;
                supplierPks.add(bdSupplier.getPkValue());
                supplierEntry.set("seq", supplier.get("seq"));
                supplierEntry.set("supplier", (Object)bdSupplier);
                supplierEntry.set("suppliercontact", supplier.get("suppliercontact"));
                supplierEntry.set("contactphone", supplier.get("contactphone"));
                supplierEntry.set("suppliercomment", supplier.get("suppliercomment"));
                supplierEntry.set("supplierstatistic", supplier.get("supplierstatistic"));
                supplierEntry.set("email", supplier.get("email"));
                supplierEntry.set("address", supplier.get("address"));
                supplierEntry.set("fax", supplier.get("fax"));
                supplierEntry.set("invitationstatus", (Object)"UNSEND");
                supplierEntry.set("isfromproject", (Object)"true");
                supplierEntry.set("projectpartner", supplier.get("projectpartner"));
                supplierEntry.set("suppliersecdeposit", supplier.get("suppliersecdeposit"));
            }
        }
        supplierInvitation.set("supplierqty", (Object)supplierPks.size());
        supplierInvitation.set("createtime", (Object)new Date());
        HashMap<String, DynamicObject> creatorMap = BidProjectChgCreatorUtils.getCreator(bidProject);
        DynamicObject creator = creatorMap.get("02");
        supplierInvitation.set("creator", (Object)creator);
        EntityTypeHelper.setEntityType(supplierInvitation, "bid_supplierinvitation", "bidproject");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{supplierInvitation});
    }

    @Override
    public void handleInvitedQty(Long[] objIds, boolean isAudit, String formId) {
        if (objIds == null) {
            return;
        }
        DynamicObject tempObj = BusinessDataServiceHelper.loadSingle((Object)objIds[0], (String)"bid_supplierinvitation", (String)"id,entitytypeid");
        String entityTypePre = "";
        if (tempObj != null) {
            entityTypePre = tempObj.getString("entitytypeid").split("_")[0];
        }
        DynamicObject[] datas = null;
        if ("bid".equals(entityTypePre)) {
            datas = BusinessDataServiceHelper.load((Object[])objIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bid_supplierinvitation"));
        } else if ("rebm".equals(entityTypePre)) {
            datas = BusinessDataServiceHelper.load((Object[])objIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"rebm_supplierinvitation"));
        }
        HashMap<Long, Integer> invitedQtyMap = new HashMap<Long, Integer>();
        DynamicObjectCollection bidSections = null;
        DynamicObjectCollection supplierEntrys = null;
        DynamicObject supplierName = null;
        if (datas != null) {
            HashSet<Long> bidProjectIDSet = new HashSet<Long>();
            for (DynamicObject supplierInvitationObj : datas) {
                bidProjectIDSet.add((Long)supplierInvitationObj.getDynamicObject("bidproject").getPkValue());
            }
            String selectFields = "bidproject,supplier,entry,entry.sectionname,entry.projectsection,entry.sectionstatus,ispublicbid,tenderstatus";
            DynamicObject[] myTenderArr = null;
            if ("bid".equals(entityTypePre)) {
                myTenderArr = BusinessDataServiceHelper.load((String)"ten_mytender", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("bidproject", "in", bidProjectIDSet)});
            } else if ("rebm".equals(entityTypePre)) {
                myTenderArr = BusinessDataServiceHelper.load((String)"resp_mytender", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("bidproject", "in", bidProjectIDSet)});
            }
            for (DynamicObject supplierInvitationObj : datas) {
                Long bidProjectID = (Long)supplierInvitationObj.getDynamicObject("bidproject").getPkValue();
                bidSections = supplierInvitationObj.getDynamicObjectCollection("bidsection");
                ArrayList<DynamicObject> targetMyTenderArr = new ArrayList<DynamicObject>(50);
                if (myTenderArr != null && myTenderArr.length > 0) {
                    for (DynamicObject aMyTender : myTenderArr) {
                        if (bidProjectID.compareTo((Long)aMyTender.getDynamicObject("bidproject").getPkValue()) != 0) continue;
                        targetMyTenderArr.add(aMyTender);
                    }
                }
                HashMap<String, DynamicObject> myTenderEntryMap = new HashMap<String, DynamicObject>(100);
                for (DynamicObject aMyTender : targetMyTenderArr) {
                    for (DynamicObject aMyTenderEntry : aMyTender.getDynamicObjectCollection("entry")) {
                        myTenderEntryMap.put(aMyTender.getDynamicObject("supplier").getPkValue() + aMyTenderEntry.getString("sectionname"), aMyTenderEntry);
                    }
                }
                for (DynamicObject bidSection : bidSections) {
                    supplierEntrys = bidSection.getDynamicObjectCollection("supplierentry");
                    for (DynamicObject supplierEntry : supplierEntrys) {
                        Integer n;
                        Integer n2;
                        supplierName = supplierEntry.getDynamicObject("supplier");
                        if (supplierName == null) continue;
                        Long bdSupplierID = (Long)supplierName.get("id");
                        DynamicObject myTenderEntry = (DynamicObject)myTenderEntryMap.get(bdSupplierID + bidSection.getString("sectionname"));
                        Integer invitedQty = (Integer)invitedQtyMap.get(bdSupplierID);
                        if (invitedQty == null) {
                            invitedQty = 0;
                        }
                        if (isAudit) {
                            n2 = invitedQty;
                            n = invitedQty = Integer.valueOf(invitedQty + 1);
                            if (myTenderEntry != null) {
                                myTenderEntry.set("sectionstatus", (Object)MyTenderStatus.INVITED);
                            }
                        } else {
                            n2 = invitedQty;
                            n = invitedQty = Integer.valueOf(invitedQty - 1);
                        }
                        invitedQtyMap.put(bdSupplierID, invitedQty);
                    }
                }
            }
            new SupplierStatisticServiceImpl().insertSupplierInvitedQty(invitedQtyMap, formId);
        }
    }

    @Override
    public DynamicObject getSupplierInvitationByProjectId(Long projectId, String selectedFields) {
        QFilter qFilter = new QFilter("bidproject.id", "=", (Object)projectId);
        QFilter qFilter1 = new QFilter("billstatus", "!=", (Object)"X");
        qFilter1.and("billstatus", "!=", (Object)"XX");
        if (StringUtils.isNotEmpty((CharSequence)selectedFields)) {
            return QueryServiceHelper.queryOne((String)"bid_supplierinvitation", (String)selectedFields, (QFilter[])new QFilter[]{qFilter, qFilter1});
        }
        return BusinessDataServiceHelper.loadSingle((String)"bid_supplierinvitation", (QFilter[])new QFilter[]{qFilter, qFilter1});
    }

    @Override
    public boolean deleteNextStepUnStarted(DynamicObject bidProject, BidStepEnum currentStep) {
        HashMap<String, String> stepMap = SupplierInvitationServiceImpl.queryStep(bidProject.getPkValue());
        boolean deleteSucess = ISupplierInvitationService.super.deleteNextStepUnStarted(bidProject, currentStep);
        if (deleteSucess && !BidStepInteractiveHelper.checkStepComplete((Long)bidProject.getPkValue(), BidStepEnum.BidDocument)) {
            BidProjectServiceImpl bidProService = new BidProjectServiceImpl();
            if (stepMap.get(BidStepEnum.Clarificaiton.name()) != null) {
                bidProService.saveCurrentBidStep(bidProject.getPkValue(), BidStepEnum.Clarificaiton, currentStep, BidStepEnum.BidDocument);
            } else {
                bidProService.saveCurrentBidStep(bidProject.getPkValue(), currentStep, BidStepEnum.BidDocument);
            }
        }
        return deleteSucess;
    }

    public static HashMap<String, String> queryStep(Object bidProjectId) {
        HashMap<String, String> result = new HashMap<String, String>();
        DynamicObject mainObj = BusinessDataServiceHelper.loadSingle((Object)bidProjectId, (String)"bid_project", (String)"id,currentstep");
        if (mainObj != null) {
            String[] stepArr;
            String stepStrs = mainObj.getString("currentstep");
            String[] stringArray = stepArr = stepStrs == null ? null : stepStrs.split(",");
            if (stepArr != null && stepArr.length > 0) {
                for (String step : stepArr) {
                    result.put(step, step);
                }
            }
        }
        return result;
    }

    @Override
    public String getFormId() {
        return "bid_supplierinvitation";
    }

    private MainEntityType getMainEntityType() {
        return EntityMetadataCache.getDataEntityType((String)this.getFormId());
    }

    @Override
    public DynamicObject getSupplierInvitationById(Long id) {
        DynamicObject tempObj = BusinessDataServiceHelper.loadSingle((Object)id, (String)"bid_supplierinvitation", (String)"id,entitytypeid");
        String prefix = tempObj.getString("entitytypeid").split("_")[0];
        if ("rebm".equals(prefix)) {
            return BusinessDataServiceHelper.loadSingle((Object)id, (String)"rebm_supplierinvitation");
        }
        return BusinessDataServiceHelper.loadSingle((Object)id, (DynamicObjectType)this.getMainEntityType());
    }

    @Override
    public void invalidInvitation(Long projectId, String formId) {
        DynamicObject obj = this.getSupplierInvitationByProjectId(projectId, "id,billstatus");
        if (obj == null) {
            return;
        }
        if (!StringUtils.equals((CharSequence)BillStatusEnum.AUDITED.getVal(), (CharSequence)obj.getString("billstatus"))) {
            return;
        }
        Long id = obj.getLong("id");
        if (id == null || id == 0L) {
            return;
        }
        DynamicObject now = this.getSupplierInvitationById(id);
        if (now == null) {
            return;
        }
        DynamicObject supplierName = null;
        DynamicObjectCollection sections = now.getDynamicObjectCollection("bidsection");
        HashMap<Long, Integer> invitedQtyMap = new HashMap<Long, Integer>();
        for (DynamicObject section : sections) {
            DynamicObjectCollection supplierEntrys = section.getDynamicObjectCollection("supplierentry");
            for (DynamicObject supplierEntry : supplierEntrys) {
                supplierName = supplierEntry.getDynamicObject("supplier");
                if (supplierName == null) continue;
                Long bdSupplierID = (Long)supplierName.get("id");
                Integer invitedQty = null;
                try {
                    invitedQty = (Integer)invitedQtyMap.get(bdSupplierID);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (invitedQty == null) {
                    invitedQty = 0;
                }
                Integer n = invitedQty;
                Integer n2 = invitedQty = Integer.valueOf(invitedQty - 1);
                invitedQtyMap.put(bdSupplierID, invitedQty);
            }
        }
        new SupplierStatisticServiceImpl().insertSupplierInvitedQty(invitedQtyMap, formId);
    }

    @Override
    public List<Map<String, Object>> listAttach(Object attachformid, Object pkValue, String key) {
        ArrayList<Map<String, Object>> attachs = new ArrayList<Map<String, Object>>();
        List attachments = AttachmentServiceHelper.getAttachments((String)String.valueOf(attachformid), (Object)pkValue, (String)key);
        if (attachments != null && attachments.size() != 0) {
            for (int i = 0; i < attachments.size(); ++i) {
                HashMap attach = new HashMap();
                Map map = (Map)attachments.get(i);
                attach.put("name", map.get("name"));
                attach.put("url", map.get("url"));
                attachs.add(attach);
            }
            return attachs;
        }
        return null;
    }

    @Override
    public DynamicObject getInvitationByProjectId(Long id) {
        QFilter qFilter = new QFilter("bidproject.id", "=", (Object)id);
        return QueryServiceHelper.queryOne((String)"bid_invitation", (String)"id,status", (QFilter[])new QFilter[]{qFilter});
    }

    @Override
    public void changeInvitationDeadLine(Object id, Date newDate) {
        QFilter filter = new QFilter("bidproject", "=", id);
        DynamicObject invitation = BusinessDataServiceHelper.loadSingle((String)"bid_invitation", (String)"supplierentry,supplierentry.content,bidproject.invitationdeadline", (QFilter[])new QFilter[]{filter});
        Date deadLineDate = (Date)invitation.get("bidproject.invitationdeadline");
        DynamicObjectCollection invitationEntryColl = invitation.getDynamicObjectCollection("supplierentry");
        for (int i = 0; i < invitationEntryColl.size(); ++i) {
            DynamicObject invitationEntryInfo = (DynamicObject)invitationEntryColl.get(i);
            String contentChange = "";
            contentChange = deadLineDate != null ? invitationEntryInfo.getString("content").replaceAll(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(deadLineDate), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(newDate)) : invitationEntryInfo.getString("content").replaceAll(ResManager.loadKDString((String)"\\{\u9080\u8bf7\u51fd.\u9080\u8bf7\u51fd\u786e\u8ba4\u622a\u6b62\u65f6\u95f4\\}", (String)"SupplierInvitationServiceImpl_0", (String)"scm-bid-business", (Object[])new Object[0]), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(newDate));
            invitationEntryInfo.set("content", (Object)contentChange);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{invitation});
    }

    public void sendMessage(DynamicObject bidProject) {
        this.sendInvitationMessage(bidProject, "createbidsupplierinvi", "bid_supplierinvitation", null, "save");
    }

    public void sendSignendTimeMessage(DynamicObject bidProject, Object pkId) {
        this.sendInvitationMessage(bidProject, "signendtime", "bid_announcement", pkId, "signendtime");
    }

    public void sendDeadlineDateMessage(DynamicObject bidProject, Object pkId) {
        this.sendInvitationMessage(bidProject, "deadlinedate", "bid_invitation", pkId, "deadlinedate");
    }

    protected void sendInvitationMessage(DynamicObject bidProject, String tplScene, String msgentity, Object pkId, String operation) {
        DynamicObject supplier = BusinessDataServiceHelper.loadSingle((String)FormTypeConstants.getFormConstant((String)"supplierinvitation", this.getClass()), (String)"id,entitytypeid", (QFilter[])new QFilter[]{new QFilter("bidproject.id", "=", bidProject.getPkValue()), new QFilter("billstatus", "not in", (Object)new String[]{"XX", "X"})});
        bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProject.getPkValue(), (String)FormTypeConstants.getFormConstant((String)"project", this.getClass()));
        if (supplier != null) {
            String appid = supplier.getString("entitytypeid").split("_")[0];
            HashMap<String, Object> msgParam = new HashMap<String, Object>();
            msgParam.put("tplScene", tplScene);
            if ("bid".equals(appid)) {
                msgParam.put("formId", "bid_supplierinvitation");
            } else {
                msgParam.put("formId", "rebm_supplierinvitation");
            }
            if (pkId != null) {
                msgParam.put("id", pkId);
            } else {
                msgParam.put("id", supplier.getPkValue());
            }
            msgParam.put("pkId", supplier.getPkValue());
            msgParam.put("appId", appid);
            msgParam.put("title", null);
            msgParam.put("operation", operation);
            msgParam.put("urlParams", Arrays.asList("formId", "pkId"));
            DynamicObjectCollection memberColl = bidProject.getDynamicObjectCollection("memberentity");
            HashSet<Long> receiveUserIds = new HashSet<Long>();
            for (DynamicObject member : memberColl) {
                String[] values;
                if (member.getString("respbusiness") == null || (values = member.getString("respbusiness").split(",")) == null || values.length <= 0) continue;
                for (int m = 0; m < values.length; ++m) {
                    if (!"02".equals(values[m])) continue;
                    receiveUserIds.add(member.getDynamicObject("user").getLong("id"));
                }
            }
            msgParam.put("msgentity", msgentity);
            msgParam.put("content", null);
            String notifyTypes = MessageChannelUtil.getNotifyType((String)tplScene, (String)msgentity);
            MessageCenterHelper.sendMessagesToOpetator(msgParam, (boolean)true, new ArrayList(receiveUserIds), (String)notifyTypes);
        }
    }
}

