/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.business.schedule;

import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.common.enums.BillStatusEnum;

public class BidAnswerQuestionStatusSchedule
extends AbstractTask {
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        try {
            long start = System.currentTimeMillis();
            BizLog.log((String)"start BidAnswerQuestionStatus Upgrade  ");
            QFilter billstatusFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.QUESTIONING.getVal());
            billstatusFilter.and(new QFilter("entitytypeid", "=", (Object)"bid_answerquestion"));
            Date now = new Date();
            DynamicObject[] answeringResultArr = BusinessDataServiceHelper.load((String)"bid_answerquestion", (String)"id,billstatus,answerquestiondeadline,bidproject,bidproject.bidopen", (QFilter[])new QFilter[]{billstatusFilter});
            HashSet<Long> hasOpenPorjectId = new HashSet<Long>(20);
            for (int i = 0; i < answeringResultArr.length; ++i) {
                if (answeringResultArr[i].getDate("answerquestiondeadline") == null || answeringResultArr[i].getDate("answerquestiondeadline").compareTo(now) > 0) continue;
                answeringResultArr[i].set("billstatus", (Object)BillStatusEnum.ENDED.getVal());
                DynamicObject project = answeringResultArr[i].getDynamicObject("bidproject");
                if (!project.getBoolean("bidopen")) continue;
                hasOpenPorjectId.add(project.getLong("id"));
            }
            SaveServiceHelper.save((DynamicObject[])answeringResultArr);
            if (!hasOpenPorjectId.isEmpty()) {
                QFilter idFilter = new QFilter("id", "in", hasOpenPorjectId);
                DynamicObject[] projectArr = BusinessDataServiceHelper.load((String)"bid_project", (String)"id,billstatus,currentstep,bidopen", (QFilter[])new QFilter[]{idFilter});
                for (int i = 0; i < projectArr.length; ++i) {
                    DynamicObject project = projectArr[i];
                    String currentStep = project.getString("currentstep");
                    if (!StringUtils.isNotEmpty((CharSequence)currentStep) || !",BidAnswerQuestion,".equals(currentStep)) continue;
                    project.set("currentstep", (Object)",BidOpen,");
                }
                SaveServiceHelper.update((DynamicObject[])projectArr);
            }
            long time = System.currentTimeMillis() - start;
            BizLog.log((String)("BidAnswerQuestionStatusSchedule_end hao shi ms: " + time));
            BizLog.log((String)"success\uff01");
        }
        catch (Exception e) {
            BizLog.log((String)("BidAnswerQuestionStatusSchedule_update paydata setupdate:" + e.getMessage()));
        }
    }
}

