/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.business.schedule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDException;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class BidDDWXMessageTask
extends AbstractTask {
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        String names = "";
        names = this.getAppID().equals("bid") ? "BidDDWXMessageTask" : "RebmDDWXMessageTask";
        try {
            BizLog.log((String)"\u521b\u5efa\u9489\u9489\u3001\u4f01\u4e1a\u5fae\u4fe1\u3001\u516c\u6709\u4e91\u4f01\u4e1a\u5fae\u4fe1\u7684\u4fe1\u606f\u6a21\u677f\u6570\u636e\u5347\u7ea7\u5f00\u59cb");
            QFilter qFilter = new QFilter("isexcutflag", "=", (Object)Boolean.TRUE);
            QFilter billNoQFilter = new QFilter("billno", "=", (Object)names);
            DynamicObject bidFileHistoryDataUp = BusinessDataServiceHelper.loadSingle((String)(this.getAppID() + "_scan_schedule"), (String)"id,billno,serviceclassname,mmethodname,excuterouds,executedate,appid", (QFilter[])new QFilter[]{qFilter, billNoQFilter});
            if (bidFileHistoryDataUp != null) {
                BizLog.log((String)"\u521b\u5efa\u9489\u9489\u3001\u4f01\u4e1a\u5fae\u4fe1\u3001\u516c\u6709\u4e91\u4f01\u4e1a\u5fae\u4fe1\u7684\u4fe1\u606f\u6a21\u677f\u6570\u636e\u5347\u7ea7\u5df2\u7ecf\u6210\u529f");
                return;
            }
            ArrayList<String> listApp = new ArrayList<String>(2);
            listApp.add(this.getAppID());
            listApp.add(this.getTenID());
            if (this.getAppID().equals("rebm")) {
                listApp.add("bid");
                listApp.add("ten");
            }
            DynamicObject[] bidAppDynamicObject = BusinessDataServiceHelper.load((String)"bos_devportal_bizapp", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "in", listApp)});
            ArrayList AppIDs = new ArrayList(2);
            Arrays.stream(bidAppDynamicObject).forEach(o -> AppIDs.add(o.getPkValue()));
            DynamicObject[] bidFormDynamicObjects = BusinessDataServiceHelper.load((String)"bos_entityobject", (String)"id", (QFilter[])new QFilter[]{new QFilter("bizappid", "in", AppIDs)});
            ArrayList<String> idFormList = new ArrayList<String>(bidFormDynamicObjects.length);
            for (int i = 0; i < bidFormDynamicObjects.length; ++i) {
                idFormList.add(bidFormDynamicObjects[i].getString("id"));
            }
            DynamicObject[] tplsceneDynamicObjects = BusinessDataServiceHelper.load((String)"msg_tplscene", (String)"id", (QFilter[])new QFilter[]{new QFilter("entitynumber", "in", idFormList)});
            ArrayList<Long> tplsceneIdList = new ArrayList<Long>(tplsceneDynamicObjects.length);
            for (int i = 0; i < tplsceneDynamicObjects.length; ++i) {
                tplsceneIdList.add(tplsceneDynamicObjects[i].getLong("id"));
            }
            ArrayList<String> msgchannelList = new ArrayList<String>();
            msgchannelList.add("dingding");
            msgchannelList.add("weixinqy");
            DeleteServiceHelper.delete((String)"msg_template", (QFilter[])new QFilter[]{new QFilter("msgscenevalue.fbasedataid.id", "in", tplsceneIdList), new QFilter("msgchannel", "in", msgchannelList)});
            DynamicObject[] templatesDynamicObjects = BusinessDataServiceHelper.load((String)"msg_template", (String)"number,name,msgentity,msgchannel,sv_msgtemplate,msgscene,msgscenename,msgtemplate,commonlang,msgscenevalue", (QFilter[])new QFilter[]{new QFilter("msgscenevalue.fbasedataid.id", "in", tplsceneIdList), new QFilter("msgchannel", "=", (Object)"mcenter")});
            ArrayList<DynamicObject> saveTemplateList = new ArrayList<DynamicObject>(templatesDynamicObjects.length * 2);
            for (int i = 0; i < templatesDynamicObjects.length; ++i) {
                this.addDingDingOrWenxinMessage("dingding", templatesDynamicObjects[i], saveTemplateList);
                this.addDingDingOrWenxinMessage("weixinqy", templatesDynamicObjects[i], saveTemplateList);
            }
            SaveServiceHelper.save((DynamicObject[])saveTemplateList.toArray(new DynamicObject[0]));
            BizLog.log((String)"\u521b\u5efa\u9489\u9489\u3001\u4f01\u4e1a\u5fae\u4fe1\u3001\u516c\u6709\u4e91\u4f01\u4e1a\u5fae\u4fe1\u7684\u4fe1\u606f\u6a21\u677f\u6570\u636e\u5347\u7ea7\u6210\u529f");
            this.updateScheduleState(names, true);
        }
        catch (Exception e) {
            BizLog.log((String)"\u521b\u5efa\u9489\u9489\u3001\u4f01\u4e1a\u5fae\u4fe1\u3001\u516c\u6709\u4e91\u4f01\u4e1a\u5fae\u4fe1\u7684\u4fe1\u606f\u6a21\u677f\u6570\u636e\u5347\u7ea7\u5f02\u5e38");
            this.updateScheduleState(names, false);
            throw e;
        }
    }

    public void addDingDingOrWenxinMessage(String msgchannel, DynamicObject template, List<DynamicObject> saveTemplateList) {
        String name = template.getString("name") + msgchannel;
        String number = template.getString("number") + msgchannel;
        DynamicObject msgentity = template.getDynamicObject("msgentity");
        ArrayList idList = new ArrayList();
        DynamicObjectCollection msgscenevalueCol = template.getDynamicObjectCollection("msgscenevalue");
        msgscenevalueCol.stream().forEach(o -> idList.add((DynamicObject)o.get("fbasedataid")));
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)"msg_template");
        DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)mainType);
        dynamicObject.set("number", (Object)number);
        dynamicObject.set("name", (Object)new LocaleString(name));
        dynamicObject.set("msgentity", (Object)msgentity);
        dynamicObject.set("msgchannel", (Object)msgchannel);
        dynamicObject.set("msgtype", (Object)"message");
        DynamicObjectCollection msgscenevalue = dynamicObject.getDynamicObjectCollection("msgscenevalue");
        DynamicObjectCollection fourBookColl = new DynamicObjectCollection();
        for (DynamicObject bookDyObj : idList) {
            DynamicObject tempDyObj = new DynamicObject(msgscenevalue.getDynamicObjectType());
            tempDyObj.set("fbasedataid", (Object)bookDyObj);
            fourBookColl.add((Object)tempDyObj);
        }
        dynamicObject.set("msgscenevalue", (Object)fourBookColl);
        dynamicObject.set("sv_msgtemplate", template.get("sv_msgtemplate"));
        dynamicObject.set("msgtemplate", template.get("msgtemplate"));
        dynamicObject.set("commonlang", template.get("commonlang"));
        if (msgscenevalueCol.size() <= 0) {
            return;
        }
        DynamicObject msg_tplscene = ((DynamicObject)msgscenevalueCol.get(0)).getDynamicObject("fbasedataid");
        dynamicObject.set("msgscene", msg_tplscene.get("number"));
        dynamicObject.set("msgscenename", msg_tplscene.get("name"));
        saveTemplateList.add(dynamicObject);
    }

    public String getAppID() {
        return "bid";
    }

    public String getTenID() {
        return "ten";
    }

    public void updateScheduleState(String billno, boolean isExcutFlag) {
        QFilter qFilter = new QFilter("billno", "=", (Object)billno);
        DynamicObject[] schedules = BusinessDataServiceHelper.load((String)(this.getAppID() + "_scan_schedule"), (String)"id", (QFilter[])new QFilter[]{qFilter});
        if (schedules == null || schedules.length == 0) {
            return;
        }
        DynamicObject loadSingle = BusinessDataServiceHelper.loadSingle((Object)schedules[0].getPkValue(), (String)(this.getAppID() + "_scan_schedule"));
        int excuteRouds = loadSingle.getInt("excuterouds") + 1;
        loadSingle.set("isexcutflag", (Object)isExcutFlag);
        loadSingle.set("executedate", (Object)new Date());
        loadSingle.set("excuterouds", (Object)excuteRouds);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{loadSingle});
    }
}

