/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.business.schedule;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class BidDecisionRoundsSchedule
extends AbstractTask {
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        String names = "";
        names = this.getAppId().equals("bid") ? "BidDecisionRoundsSchedule" : "DecisionRoundsTask";
        try {
            DynamicObject[] biddecisions;
            BizLog.log((String)"\u5b9a\u6807\u56de\u6807\u8f6e\u6b21\u5386\u53f2\u6570\u636e\u5347\u7ea7\u5f00\u59cb");
            QFilter qFilte = new QFilter("entitytypeid", "=", (Object)(this.getAppId() + "_decision"));
            QFilter qFilter = new QFilter("isexcutflag", "=", (Object)Boolean.TRUE);
            QFilter billNoQFilter = new QFilter("billno", "=", (Object)names);
            DynamicObject bidFileHistoryDataUp = BusinessDataServiceHelper.loadSingle((String)(this.getAppId() + "_scan_schedule"), (String)"id,billno,serviceclassname,mmethodname,excuterouds,executedate,appid", (QFilter[])new QFilter[]{qFilter, billNoQFilter});
            if (bidFileHistoryDataUp != null) {
                BizLog.log((String)"\u5b9a\u6807\u56de\u6807\u8f6e\u6b21\u5386\u53f2\u6570\u636e\u5347\u7ea7\u5df2\u7ecf\u6210\u529f");
                return;
            }
            for (DynamicObject biddecision : biddecisions = BusinessDataServiceHelper.load((String)(this.getAppId() + "_decision"), (String)"bidproject,bidsection,sectionname,supplierentry,supplier,techrounds,bussrounds", (QFilter[])new QFilter[]{qFilte})) {
                DynamicObject bidproject = biddecision.getDynamicObject("bidproject");
                if (bidproject == null) continue;
                DynamicObjectCollection bidsection = biddecision.getDynamicObjectCollection("bidsection");
                this.setRound(bidsection, bidproject);
            }
            SaveServiceHelper.save((DynamicObject[])biddecisions);
            BizLog.log((String)"\u5b9a\u6807\u56de\u6807\u8f6e\u6b21\u5386\u53f2\u6570\u636e\u5347\u7ea7\u7ed3\u675f");
            this.updateScheduleState(names, true);
        }
        catch (Exception e) {
            BizLog.log((String)("\u5b9a\u6807\u56de\u6807\u8f6e\u6b21\u5386\u53f2\u6570\u636e\u5347\u7ea7\u5f02\u5e38" + e.getMessage()));
            this.updateScheduleState(names, false);
            throw e;
        }
    }

    public void setRound(DynamicObjectCollection section4Decision, DynamicObject bidProject) {
        String bidappid = this.getAppId();
        String tenappid = bidappid.equals("bid") ? "ten" : "resp";
        QFilter bidqfilter = new QFilter("bidproject", "=", bidProject.getPkValue());
        QFilter secqfilter = new QFilter("tenderstatus", "=", (Object)"TENDERED");
        DynamicObject[] online_bids = BusinessDataServiceHelper.load((String)(tenappid + "_online_bid"), (String)"supplier,rounds,listrounds,sectionentry,sectionname,currentroundflag,fromrebackflag,backbidtype", (QFilter[])new QFilter[]{bidqfilter, secqfilter}, (String)"rounds asc");
        HashMap supRounds = new HashMap();
        for (DynamicObject online_bid : online_bids) {
            DynamicObjectCollection sectionentrys = online_bid.getDynamicObjectCollection("sectionentry");
            String backbidtype = online_bid.getString("backbidtype");
            for (DynamicObject sectionentry : sectionentrys) {
                boolean currentroundflag;
                String sectionname = sectionentry.getString("sectionname");
                if (sectionname == null || !(currentroundflag = sectionentry.getBoolean("currentroundflag"))) continue;
                String suppliersectionname = online_bid.getDynamicObject("supplier").getString("id") + sectionname;
                HashMap<String, String> roundsMap = (HashMap<String, String>)supRounds.get(suppliersectionname);
                if (roundsMap == null) {
                    roundsMap = new HashMap<String, String>();
                }
                if ("TECHNICAL".equals(backbidtype)) {
                    roundsMap.put("TECHNICAL", online_bid.getString("listrounds"));
                } else if ("BUSSINESS".equals(backbidtype)) {
                    roundsMap.put("BUSSINESS", online_bid.getString("listrounds"));
                } else if ("TECHANDBUSS".equals(backbidtype)) {
                    roundsMap.put("TECHNICAL", online_bid.getString("listrounds"));
                    roundsMap.put("BUSSINESS", online_bid.getString("listrounds"));
                }
                supRounds.put(suppliersectionname, roundsMap);
            }
        }
        for (DynamicObject section : section4Decision) {
            String sectionname = section.getString("sectionname");
            if (sectionname == null) continue;
            DynamicObjectCollection supplierentrys = section.getDynamicObjectCollection("supplierentry");
            for (DynamicObject supplierentry : supplierentrys) {
                String supplierid;
                String suppliersection;
                Map roundsmap;
                DynamicObject supp = supplierentry.getDynamicObject("supplier");
                if (supp == null || (roundsmap = (Map)supRounds.get(suppliersection = (supplierid = supp.getString("id")) + sectionname)) == null) continue;
                supplierentry.set("techrounds", roundsmap.get("TECHNICAL"));
                supplierentry.set("bussrounds", roundsmap.get("BUSSINESS"));
            }
        }
    }

    public String getAppId() {
        return "bid";
    }

    public void updateScheduleState(String billno, boolean isExcutFlag) {
        QFilter qFilter = new QFilter("billno", "=", (Object)billno);
        DynamicObject[] schedules = BusinessDataServiceHelper.load((String)"bid_scan_schedule", (String)"id", (QFilter[])new QFilter[]{qFilter});
        if (schedules == null || schedules.length == 0) {
            return;
        }
        DynamicObject loadSingle = BusinessDataServiceHelper.loadSingle((Object)schedules[0].getPkValue(), (String)(this.getAppId() + "_scan_schedule"));
        int excuteRouds = loadSingle.getInt("excuterouds") + 1;
        loadSingle.set("isexcutflag", (Object)isExcutFlag);
        loadSingle.set("executedate", (Object)new Date());
        loadSingle.set("excuterouds", (Object)excuteRouds);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{loadSingle});
    }
}

