/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.business.schedule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.bid.business.bill.serviceImpl.BidOpenServiceImpl;
import kd.scm.bid.business.bill.serviceImpl.SupplierInvitationServiceImpl;
import kd.scm.bid.business.helper.BidStepInteractiveHelper;
import kd.scm.bid.common.enums.BidOpenSelectTypeEnum;
import kd.scm.bid.common.enums.BidOpenTypeEnum;
import kd.scm.bid.common.enums.BidStepEnum;
import kd.scm.bid.common.util.MessageCenterHelper;
import kd.scm.bid.common.util.MessageChannelUtil;

public class BidPublishMessageTask
extends AbstractTask {
    private final SupplierInvitationServiceImpl invitationService = new SupplierInvitationServiceImpl();
    private final BidOpenServiceImpl bidOpenServiceImpl = new BidOpenServiceImpl();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        Class<BidPublishMessageTask> clazz = BidPublishMessageTask.class;
        synchronized (BidPublishMessageTask.class) {
            this.sendMessage();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public void sendMessage() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(11, 1);
        Date time = calendar.getTime();
        this.sendInvitationMessage(time);
        this.sendAnnouncementMessage(time);
        this.sendMultiQuestClarifyMessage(time);
    }

    protected void sendMultiQuestClarifyMessage(Date time) {
        DynamicObject[] multiQuestClarifys;
        for (DynamicObject multiQuestClarify : multiQuestClarifys = BusinessDataServiceHelper.load((String)"bid_multiquestclarify", (String)"id,bidproject,opentype,clarifydeadline,supplierinvitationid,creator", (QFilter[])new QFilter[]{new QFilter("clarifydeadline", ">=", (Object)new Date()), new QFilter("clarifydeadline", "<", (Object)time)})) {
            DynamicObject bidProject = multiQuestClarify.getDynamicObject("bidproject");
            if (null == bidProject) continue;
            HashMap<String, Object> msgParam = new HashMap<String, Object>();
            msgParam.put("formId", "bid_multiquestclarify");
            msgParam.put("id", multiQuestClarify.getPkValue());
            msgParam.put("pkId", multiQuestClarify.getPkValue());
            msgParam.put("appId", "bid");
            msgParam.put("bidproject", bidProject.getPkValue());
            msgParam.put("opentype", multiQuestClarify.getString("opentype"));
            msgParam.put("title", null);
            msgParam.put("operation", "sendpromeble");
            msgParam.put("urlParams", Arrays.asList("formId", "pkId", "bidproject", "opentype"));
            HashSet<Long> receiveUserIds = new HashSet<Long>();
            receiveUserIds.add((Long)multiQuestClarify.getDynamicObject("creator").getPkValue());
            msgParam.put("msgentity", "bid_multiquestclarify");
            msgParam.put("tplScene", "bidmultiquestclarify");
            msgParam.put("content", null);
            String notifyTypes = MessageChannelUtil.getNotifyType((String)"bidmultiquestclarify", (String)"bid_multiquestclarify");
            MessageCenterHelper.sendMessagesToOpetator(msgParam, (boolean)true, new ArrayList(receiveUserIds), (String)notifyTypes);
        }
    }

    protected void sendAnnouncementMessage(Date time) {
        DynamicObject[] announcements;
        for (DynamicObject announcement : announcements = BusinessDataServiceHelper.load((String)"bid_announcement", (String)"id,bidproject,signendtime", (QFilter[])new QFilter[]{new QFilter("signendtime", ">=", (Object)new Date()), new QFilter("signendtime", "<", (Object)time), new QFilter("entitytypeid", "=", (Object)"bid_announcement")})) {
            String bidProjectId = announcement.getString("bidproject");
            if (StringUtils.isEmpty((CharSequence)bidProjectId)) continue;
            DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(bidProjectId), (String)"bid_project");
            this.invitationService.sendSignendTimeMessage(bidProject, announcement.getPkValue());
        }
    }

    protected void sendInvitationMessage(Date time) {
        DynamicObject[] invitations;
        for (DynamicObject invitation : invitations = BusinessDataServiceHelper.load((String)"bid_invitation", (String)"id,bidproject,deadlinedate", (QFilter[])new QFilter[]{new QFilter("deadlinedate", ">=", (Object)new Date()), new QFilter("deadlinedate", "<", (Object)time), new QFilter("entitytypeid", "=", (Object)"bid_invitation")})) {
            DynamicObject bidProject = invitation.getDynamicObject("bidproject");
            if (null == bidProject) continue;
            this.invitationService.sendDeadlineDateMessage(bidProject, invitation.getPkValue());
        }
    }

    protected void sendBidOpenMessage(Date time) {
        DynamicObject[] bids;
        for (DynamicObject bid : bids = BusinessDataServiceHelper.load((String)"bid_bidpublish", (String)"id,bidproject,planbidopendeadline", (QFilter[])new QFilter[]{new QFilter("planbidopendeadline", ">=", (Object)new Date()), new QFilter("planbidopendeadline", "<", (Object)time), new QFilter("entitytypeid", "=", (Object)"bid_bidpublish")})) {
            DynamicObject bidOpen;
            BidStepEnum[] nextStep;
            DynamicObject bidProject = bid.getDynamicObject("bidproject");
            if (null == bidProject || (nextStep = BidStepInteractiveHelper.getNextStep(bidProject = BusinessDataServiceHelper.loadSingle((Object)bidProject.getPkValue(), (String)"bid_project"), BidStepEnum.BidPublish)) == null || !bidProject.getBoolean("bidopen") || (bidOpen = BusinessDataServiceHelper.loadSingle((String)"bid_bidopen", (String)"billstatus", (QFilter[])new QFilter[]{new QFilter("bidproject.id", "=", bidProject.getPkValue())})) == null || !bidProject.getBoolean("bidopen")) continue;
            String openType = bidProject.getString("bidopentype");
            String docType = bidProject.getString("doctype");
            String paraOpenType = null;
            if (StringUtils.equals((CharSequence)BidOpenSelectTypeEnum.UNIONOPEN.getValue(), (CharSequence)openType)) {
                if (BidOpenTypeEnum.BUSSINESS.getValue().equals(docType)) {
                    paraOpenType = BidOpenTypeEnum.BUSSINESS.getValue();
                } else if (BidOpenTypeEnum.MULTI.getValue().equals(docType)) {
                    paraOpenType = BidOpenTypeEnum.MULTI.getValue();
                }
            } else if (StringUtils.equals((CharSequence)BidOpenSelectTypeEnum.BUSSINESSTECH.getValue(), (CharSequence)openType)) {
                paraOpenType = BidOpenTypeEnum.BUSSINESS.getValue();
            } else if (StringUtils.equals((CharSequence)BidOpenSelectTypeEnum.TECHBUSINESS.getValue(), (CharSequence)openType)) {
                paraOpenType = BidOpenTypeEnum.TECHNICAL.getValue();
            }
            this.bidOpenServiceImpl.sendMessage(bidProject, paraOpenType);
        }
    }
}

