/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.business.schedule.file;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDException;
import kd.bos.id.ID;
import kd.bos.logging.BizLog;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.business.schedule.file.entity.BackSupplierEntry;
import kd.scm.bid.business.schedule.file.entity.BusTalkSupplierEntry;
import kd.scm.bid.business.schedule.file.entity.OnlineEvalSupplierEntry;
import kd.scm.bid.business.schedule.file.entity.OpenSectionSupplierEntry;
import kd.scm.bid.business.schedule.file.entity.SupInvitationBmSupplierEntry;
import kd.scm.bid.business.schedule.file.entity.SupInvitationRwSupplierEntry;
import kd.scm.bid.business.schedule.file.entity.SupplierinvalidEntry;
import kd.scm.bid.business.schedule.file.uitl.PageUtil;
import kd.scm.bid.common.util.BidDynamicObjectUtil;

public class BidFileHistoryDataUp
extends AbstractTask {
    Log log = LogFactory.getLog(BidFileHistoryDataUp.class);
    private static final String QUERY_SIRW_SUPPLIER_SQL = "select a.fbidprojectid, c.fsupplierid, c.fisregister, c.fannouncementid, c.finvitation, c.fdetailid from t_bid_supplierinvitation a  inner join t_bid_suppinvisectentry b on a.fid = b.fid  inner join t_bid_suppinvisuppdetail c on b.fentryid  = c.fentryid where finvitefile > 0";
    private static final String QUERY_SIBM_SUPPLIER_SQL = "select a.fbidprojectid, c.fsupplierid, c.fdetailid  from t_bid_supplierinvitation a inner join t_bid_suppenrollentry b on a.fid = b.fid  inner join t_bid_suppenrolldetail c on b.fentryid  = c.fentryid where fregisterfile > 0";
    private static final String QUERY_BMRW_SUPPLIER_SQL = "select fid,ftype,fbidprojectid,fsupplierid,fannouncementid,finvitationid from t_ten_registerinvite_file where ";
    private static final String INSERT_INVITE_ATTACH_SQL = "insert into t_bid_invite_attach(fpkid, fdetailid, fbasedataid) values (?,?,?)";
    private static final String INSERT_INVITE_REGAATTACH_SQL = "insert into t_bid_invite_regattach(fpkid, fdetailid, fbasedataid) values (?,?,?)";
    private static final String TEN_UNTENDER_SQL = "select fid, fbidprojectid, fsupplierid from t_ten_untender where ";
    private static final String BID_OPEN_SECTION_SUPPLIER_ENTRY_SQL = "select a.fid, a.fbidprojectid, b.fentryid, c.fdetailid, c.fsupplierid, c.funtenderfile from t_bid_bidopen a inner join t_bid_bidopen_bidsection b on a.fid = b.fid inner join t_bid_bidopen_supplier c on b.fentryid = c.fentryid";
    private static final String BID_OPEN_SUPPLIER_ENTRY_SQL = "select fid,ftype,fentryid,fsupplierid from t_bid_bidopen_file where ";
    private static final String BID_OPEN_INSERT_COMFILE_SQL = "insert into t_bid_open_comattach(fpkid, fdetailid, fbasedataid) values (?,?,?)";
    private static final String BID_OPEN_INSERT_TECHFILE_SQL = "insert into t_bid_open_techattach(fpkid, fdetailid, fbasedataid) values (?,?,?)";
    private static final String BID_OPEN_INSERT_TENFILE_SQL = "insert into t_bid_open_tenattach(fpkid, fdetailid, fbasedataid) values (?,?,?)";
    private static final String BID_OPEN_INSERT_OTHERFILE_SQL = "insert into t_bid_open_otherattach(fpkid, fdetailid, fbasedataid) values (?,?,?)";
    private static final String BID_OPEN_INSERT_UNTENDERFILE_SQL = "insert into t_bid_open_untenderattach(fpkid, fdetailid, fbasedataid) values (?,?,?)";
    private static final String REBCAK_SUPENTRY_QUERY_SQL = "select a.fsrcsectionid,b.fsupplierid,b.fdetailid from t_bid_backbidsction a left join t_bid_backbidsuppentry b on a.fentryid = b.fentryid";
    private static final String REBCAK_TECHFILE_INSERT_SQL = "insert into t_bid_back_techattach(fpkid, fdetailid, fbasedataid) values (?,?,?)";
    private static final String REBCAK_COMFILE_INSERT_SQL = "insert into t_bid_back_comattach(fpkid, fdetailid, fbasedataid) values (?,?,?)";
    private static final String REBCAK_TENFILE_INSERT_SQL = "insert into t_bid_back_tenattach(fpkid, fdetailid, fbasedataid) values (?,?,?)";
    private static final String REBCAK_OTHERFILE_INSERT_SQL = "insert into t_bid_back_otherattach(fpkid, fdetailid, fbasedataid) values (?,?,?)";
    private static final String BID_ONLIEEVAL_SECTION_SUPPLIER_ENTRY_SQL = "select a.fentryid, a.fopensectionid, b.fdetailid, b.fsupplierid from t_bid_onlinebideval_sec a left join t_bid_onlinebideval_sup b on a.fentryid = b.fentryid";
    private static final String BID_ONLINE_EVAL_TECHFILE_SQL = "insert into t_bid_onlineeval_techfile(fpkid, fdetailid, fbasedataid) values (?,?,?)";
    private static final String BID_ONLINE_EVAL_COMFILE_SQL = "insert into t_bid_onlineeval_comfile(fpkid, fdetailid, fbasedataid) values (?,?,?)";
    private static final String BUSTALK_FILE_SQL = "select fid, ftype, fentryid, fsupplierid from t_bid_bustalk_file where ";
    private static final String BUSTALK_SUPPLIER_FILE_SQL = "select fdetailid, fsupplierid from t_bid_bustalk_supplierent";
    private static final String BUSTALK_TECHFILE_INSERT_SQL = "insert into t_bid_bustalk_tech_attach(fpkid, fdetailid, fbasedataid) values (?,?,?)";
    private static final String BUSTALK_COMFILE_INSERT_SQL = "insert into t_bid_bustalk_bus_attach(fpkid, fdetailid, fbasedataid) values (?,?,?)";
    private static final String BUSTALK_OTHERFILE_INSERT_SQL = "insert into t_bid_bustalk_othe_attach(fpkid, fdetailid, fbasedataid) values (?,?,?)";
    private static final String DECISION_FILE_QUERY_SQL = "select fid, fdetailid from t_bid_decisionentryfile where ";
    private static final String DECISION_SUPPLIERENTRY_QUERY_SQL = "select fdetailid,fcommfile,ftechfile,fbidconfirmfile from t_bid_decisupplierdetail";
    private static final String DECISION_TECHFILE_INSERT_SQL = "insert into t_bid_desc_tech_attach(fpkid, fdetailid, fbasedataid) values (?,?,?)";
    private static final String DECISION_COMFILE_INSERT_SQL = "insert into t_bid_decs_comm_attach(fpkid, fdetailid, fbasedataid) values (?,?,?)";
    private static final String DECISION_COMFIRM_FILE_QUERY_SQL = "select fid, fbidprojectid, fsectionname, fsupplierid from t_ten_confirm_bid_file where fisconfirmbutton = '1' and fbidprojectid in(%s)";
    private static final String DECISION_CONFIRMFILE_INSERT_SQL = "insert into t_bidde_confirm_attach(fpkid, fdetailid, fbasedataid) values (?,?,?)";
    private static final String ANSWER_FILE_QUERY_SQL = "select fid, ftype, fanswerid from t_bid_answer_file where ";
    private static final String ANSWER_ENTRY_QUERY_SQL = "select fentryid from t_bid_answerquesrecoentry";
    private static final String ANSWER_FILE_INSERT_SQL = "insert into t_bid_answerfile_attach(fpkid, fentryid, fbasedataid) values (?,?,?)";
    private static final String ANSWER_QUESTION_INSERT_SQL = "insert into t_bid_questionfile_attach(fpkid, fentryid, fbasedataid) values (?,?,?)";
    private static final String SUPPLIERINVALID_SUPENTRY_QUERY_SQL = "select a.fbidopenid, c.fname, d.fsupplierid, d.fdetailid from t_bid_supplierinvalid a inner join t_bid_invalidsection b on a.fid = b.fid inner join t_bid_invalidsection_l c on c.fentryid = b.fentryid inner join t_bid_invalidsupplier d on d.fentryid = b.fentryid";
    private static final String BID_OPEN_FILE_SQL = "select a.fid, c.fname, d.fsupplierid, d.ftype, d.fid as fileid from t_bid_bidopen a inner join t_bid_bidopen_bidsection b on a.fid = b.fid inner join t_bid_bidopen_bidsection_l c on b.fentryid = c.fentryid inner join t_bid_bidopen_file d on d.fentryid = b.fentryid where ";
    private static final String SUPPLIERINVALID_TECHFILE_INSERT_SQL = "insert into t_bid_invalid_techattach(fpkid, fdetailid, fbasedataid) values (?,?,?)";
    private static final String SUPPLIERINVALID_COMFILE_INSERT_SQL = "insert into t_bid_invalid_comattach(fpkid, fdetailid, fbasedataid) values (?,?,?)";
    private static final String SUPPLIERINVALID_TENFILE_INSERT_SQL = "insert into t_bid_invalid_tenattach(fpkid, fdetailid, fbasedataid) values (?,?,?)";
    private static final String SUPPLIERINVALID_OTHERFILE_INSERT_SQL = "insert into t_bid_invalid_otherattach(fpkid, fdetailid, fbasedataid) values (?,?,?)";
    private static final String MULTIQUESTCLARIFY_SUPPENTRY_QUERY_SQL = "select fdetailid from t_query_supplierentry";
    private static final String MULTIQUESTCLARIFY_FILE_QUERY_SQL = "select fid, fmulticlarifyentryid from t_bid_multiclatifyfile where ";
    private static final String MULTIQUESTCLARIFY_INSERT_QUERY_SQL_1 = "insert into t_bid_multiclarify_attach(fpkid, fentryid, fbasedataid) values (?,?,?)";
    private static final String MULTIQUESTCLARIFY_INSERT_QUERY_SQL_2 = "insert into t_bid_supclarify_attach(fpkid, fdetailid, fbasedataid) values (?,?,?)";

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        String format = this.getCurrentDate();
        QFilter qFilter = new QFilter("isexcutflag", "=", (Object)Boolean.TRUE);
        QFilter billNoQFilter = new QFilter("billno", "=", (Object)"BidFileHistoryDataUp");
        DynamicObject bidFileHistoryDataUp = BusinessDataServiceHelper.loadSingle((String)"bid_scan_schedule", (String)"id,billno,serviceclassname,mmethodname,excuterouds,executedate,appid", (QFilter[])new QFilter[]{qFilter, billNoQFilter});
        if (bidFileHistoryDataUp != null) {
            BizLog.log((String)("BidFileHistoryDataUp Excute Date = " + format + ", has not data is excute!"));
            return;
        }
        try (TXHandle h = TX.requiresNew();){
            try {
                String bosAttachmentProperties = BidDynamicObjectUtil.getAllSelectProperties((String)"bos_attachment");
                BizLog.log((String)"\u9644\u4ef6\u5347\u7ea7\uff1a\u5904\u7406\u4f9b\u65b9\u5165\u56f4\u5386\u53f2\u5f00\u59cb");
                this.supplierInvitationData(bosAttachmentProperties, 500);
                BizLog.log((String)"\u9644\u4ef6\u5347\u7ea7\uff1a\u5904\u7406\u4f9b\u65b9\u5165\u56f4\u5386\u53f2\u7ed3\u675f");
                BizLog.log((String)"\u9644\u4ef6\u5347\u7ea7\uff1a\u5904\u7406\u5f00\u6807\u5386\u53f2\u5f00\u59cb");
                this.bidOpenData(bosAttachmentProperties, 500);
                BizLog.log((String)"\u9644\u4ef6\u5347\u7ea7\uff1a\u5904\u7406\u5f00\u6807\u5386\u53f2\u7ed3\u675f");
                BizLog.log((String)"\u9644\u4ef6\u5347\u7ea7\uff1a\u5904\u7406\u5728\u7ebf\u8bc4\u6807\u5f00\u59cb");
                this.onlineEval(bosAttachmentProperties, 500);
                BizLog.log((String)"\u9644\u4ef6\u5347\u7ea7\uff1a\u5904\u7406\u5728\u7ebf\u8bc4\u6807\u7ed3\u675f");
                BizLog.log((String)"\u9644\u4ef6\u5347\u7ea7\uff1a\u5904\u7406\u56de\u6807\u5f00\u59cb");
                this.backBid(bosAttachmentProperties, 500);
                BizLog.log((String)"\u9644\u4ef6\u5347\u7ea7\uff1a\u5904\u7406\u56de\u6807\u7ed3\u675f");
                BizLog.log((String)"\u9644\u4ef6\u5347\u7ea7\uff1a\u5904\u7406\u5546\u52a1\u8c08\u5224\u5f00\u59cb");
                this.busTak(bosAttachmentProperties, 500);
                BizLog.log((String)"\u9644\u4ef6\u5347\u7ea7\uff1a\u5904\u7406\u5546\u52a1\u8c08\u5224\u7ed3\u675f");
                BizLog.log((String)"\u9644\u4ef6\u5347\u7ea7\uff1a\u5904\u7406\u7b54\u7591\u5f00\u59cb");
                this.answer(bosAttachmentProperties, 500);
                BizLog.log((String)"\u9644\u4ef6\u5347\u7ea7\uff1a\u5904\u7406\u7b54\u7591\u7ed3\u675f");
                BizLog.log((String)"\u9644\u4ef6\u5347\u7ea7\uff1a\u5904\u7406\u5b9a\u6807\u5f00\u59cb");
                this.decision(bosAttachmentProperties, 500);
                this.decisionConfirmBidFile(bosAttachmentProperties, 500);
                BizLog.log((String)"\u9644\u4ef6\u5347\u7ea7\uff1a\u5904\u7406\u5b9a\u6807\u7ed3\u675f");
                BizLog.log((String)"\u9644\u4ef6\u5347\u7ea7\uff1a\u5904\u7406\u4f9b\u5e94\u5546\u6dd8\u6c70\u5386\u53f2\u5f00\u59cb");
                this.bidInvalidData(bosAttachmentProperties, 500);
                BizLog.log((String)"\u9644\u4ef6\u5347\u7ea7\uff1a\u5904\u7406\u4f9b\u5e94\u5546\u6dd8\u6c70\u5386\u53f2\u7ed3\u675f");
                BizLog.log((String)"\u9644\u4ef6\u5347\u7ea7\uff1a\u5904\u7406\u4f9b\u5e94\u5546\u8d28\u7591\u3001\u6f84\u6e05\u5386\u53f2\u5f00\u59cb");
                this.questionClarifyData(bosAttachmentProperties, 500);
                BizLog.log((String)"\u9644\u4ef6\u5347\u7ea7\uff1a\u5904\u7406\u4f9b\u5e94\u5546\u8d28\u7591\u3001\u6f84\u6e05\u5386\u53f2\u7ed3\u675f");
                this.updateScheduleState("BidFileHistoryDataUp", true);
            }
            catch (Throwable ex) {
                this.updateScheduleState("BidFileHistoryDataUp", false);
                h.markRollback();
                this.log.error(ex);
                throw ex;
            }
        }
    }

    public void bidInvalidData(String bosAttachmentProperties, int pageNum) {
        ArrayList supplierinvalidEntryList = new ArrayList();
        DB.query((DBRoute)DBRoute.of((String)"scm"), (String)SUPPLIERINVALID_SUPENTRY_QUERY_SQL, rs -> {
            while (rs.next()) {
                SupplierinvalidEntry supplierinvalidEntry = new SupplierinvalidEntry(rs.getLong(1), rs.getString(2), rs.getLong(3), rs.getLong(4));
                supplierinvalidEntryList.add(supplierinvalidEntry);
            }
            return null;
        });
        BizLog.log((String)("\u9644\u4ef6\u5347\u7ea7\uff1a\u5904\u7406\u6dd8\u6c70\u5355\u6570\u636esize\uff1a" + supplierinvalidEntryList.size()));
        Map<Integer, List<?>> listMap = PageUtil.listPage(supplierinvalidEntryList, pageNum);
        for (Map.Entry<Integer, List<?>> listData : listMap.entrySet()) {
            List<SupplierinvalidEntry> currentList = listData.getValue();
            if (currentList == null || currentList.size() <= 0) continue;
            List<Object> openIdList = currentList.stream().map(SupplierinvalidEntry::getFbidopenid).collect(Collectors.toList());
            this.dealBidInvalidFileData(bosAttachmentProperties, openIdList, currentList);
        }
    }

    public void dealBidInvalidFileData(String bosAttachmentProperties, List<Object> openIdList, List<SupplierinvalidEntry> currentList) {
        HashMap bidTenFileMap = new HashMap();
        SqlBuilder sb = new SqlBuilder();
        sb.append(BID_OPEN_FILE_SQL, new Object[0]);
        sb.appendIn("a.fid", openIdList);
        DB.query((DBRoute)DBRoute.of((String)"scm"), (SqlBuilder)sb, rs -> {
            while (rs.next()) {
                String key = String.format("%s_%s_%s_%s", rs.getString(1), rs.getString(2), rs.getString(3), rs.getString(4));
                bidTenFileMap.put(key, rs.getString(5));
            }
            return null;
        });
        BizLog.log((String)("\u9644\u4ef6\u5347\u7ea7\uff1a\u5904\u7406\u6dd8\u6c70\u5355\u6570\u636ebidTenFileMap\uff1a" + bidTenFileMap.size()));
        Map<Object, Object> tenAttachmentMap = new HashMap();
        if (bidTenFileMap != null && bidTenFileMap.size() > 0) {
            DynamicObject[] tenAttachmentArray = BusinessDataServiceHelper.load((String)"bos_attachment", (String)bosAttachmentProperties, (QFilter[])new QFilter[]{new QFilter("finterid", "in", bidTenFileMap.values())});
            tenAttachmentMap = Arrays.stream(tenAttachmentArray).collect(Collectors.groupingBy(t -> t.getString("finterid")));
        }
        BizLog.log((String)("\u9644\u4ef6\u5347\u7ea7\uff1a\u5904\u7406\u6dd8\u6c70\u5355\u6570\u636etenAttachmentMap\uff1a" + tenAttachmentMap.size()));
        ArrayList<Object[]> comFileParamList = new ArrayList<Object[]>();
        ArrayList<Object[]> techFileParamList = new ArrayList<Object[]>();
        ArrayList<Object[]> tenFileParamList = new ArrayList<Object[]>();
        ArrayList<Object[]> otherFileParamList = new ArrayList<Object[]>();
        ArrayList<DynamicObject> saveAttachmentList = new ArrayList<DynamicObject>();
        for (SupplierinvalidEntry supplierinvalidEntry : currentList) {
            String otherFileKey;
            String otherFileFid;
            String tenFileKey;
            String tenFileFid;
            String techFileKey;
            String techFileFid;
            String comFileKey = String.format("%s_%s_%s_%s", supplierinvalidEntry.getFbidopenid(), supplierinvalidEntry.getFname(), supplierinvalidEntry.getFsupplierid(), "comFile");
            String comFileFid = (String)bidTenFileMap.get(comFileKey);
            if (StringUtils.isNotBlank((CharSequence)comFileFid)) {
                List attachmentList = tenAttachmentMap.getOrDefault(comFileFid, new ArrayList());
                for (DynamicObject attachment : attachmentList) {
                    DynamicObject newAttachment = this.copyBdAttachment(attachment);
                    saveAttachmentList.add(newAttachment);
                    Object[] paramArr = new Object[]{ID.genLongId(), supplierinvalidEntry.getFdetailid(), newAttachment.getLong("id")};
                    comFileParamList.add(paramArr);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)(techFileFid = (String)bidTenFileMap.get(techFileKey = String.format("%s_%s_%s_%s", supplierinvalidEntry.getFbidopenid(), supplierinvalidEntry.getFname(), supplierinvalidEntry.getFsupplierid(), "techFile"))))) {
                List attachmentList = tenAttachmentMap.getOrDefault(techFileFid, new ArrayList());
                for (DynamicObject attachment : attachmentList) {
                    DynamicObject newAttachment = this.copyBdAttachment(attachment);
                    saveAttachmentList.add(newAttachment);
                    Object[] paramArr = new Object[]{ID.genLongId(), supplierinvalidEntry.getFdetailid(), newAttachment.getLong("id")};
                    techFileParamList.add(paramArr);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)(tenFileFid = (String)bidTenFileMap.get(tenFileKey = String.format("%s_%s_%s_%s", supplierinvalidEntry.getFbidopenid(), supplierinvalidEntry.getFname(), supplierinvalidEntry.getFsupplierid(), "tenFile"))))) {
                List attachmentList = tenAttachmentMap.getOrDefault(tenFileFid, new ArrayList());
                for (DynamicObject attachment : attachmentList) {
                    DynamicObject newAttachment = this.copyBdAttachment(attachment);
                    saveAttachmentList.add(newAttachment);
                    Object[] paramArr = new Object[]{ID.genLongId(), supplierinvalidEntry.getFdetailid(), newAttachment.getLong("id")};
                    tenFileParamList.add(paramArr);
                }
            }
            if (!StringUtils.isNotBlank((CharSequence)(otherFileFid = (String)bidTenFileMap.get(otherFileKey = String.format("%s_%s_%s_%s", supplierinvalidEntry.getFbidopenid(), supplierinvalidEntry.getFname(), supplierinvalidEntry.getFsupplierid(), "otherFile"))))) continue;
            List attachmentList = tenAttachmentMap.getOrDefault(otherFileFid, new ArrayList());
            for (DynamicObject attachment : attachmentList) {
                DynamicObject newAttachment = this.copyBdAttachment(attachment);
                saveAttachmentList.add(newAttachment);
                Object[] paramArr = new Object[]{ID.genLongId(), supplierinvalidEntry.getFdetailid(), newAttachment.getLong("id")};
                otherFileParamList.add(paramArr);
            }
        }
        BizLog.log((String)("\u9644\u4ef6\u5347\u7ea7\uff1a\u5904\u7406\u6dd8\u6c70\u5355\u3010DB\u3011\u4fdd\u5b58\u9644\u4ef6\u6570\u636esaveAttachmentList\uff1a" + saveAttachmentList.size()));
        if (comFileParamList != null && comFileParamList.size() > 0) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)SUPPLIERINVALID_COMFILE_INSERT_SQL, comFileParamList);
        }
        if (techFileParamList != null && techFileParamList.size() > 0) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)SUPPLIERINVALID_TECHFILE_INSERT_SQL, techFileParamList);
        }
        if (tenFileParamList != null && tenFileParamList.size() > 0) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)SUPPLIERINVALID_TENFILE_INSERT_SQL, tenFileParamList);
        }
        if (otherFileParamList != null && otherFileParamList.size() > 0) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)SUPPLIERINVALID_OTHERFILE_INSERT_SQL, otherFileParamList);
        }
        if (saveAttachmentList != null && saveAttachmentList.size() > 0) {
            try (TXHandle h = TX.requiresNew();){
                try {
                    SaveServiceHelper.save((DynamicObject[])saveAttachmentList.toArray(new DynamicObject[0]));
                }
                catch (Throwable ex) {
                    h.markRollback();
                    this.log.error(ex);
                    throw ex;
                }
            }
        }
        BizLog.log((String)"\u9644\u4ef6\u5347\u7ea7\uff1a\u5904\u7406\u6dd8\u6c70\u5355\u3010DB\u3011\u4fdd\u5b58\u6210\u529f");
    }

    public void supplierInvitationData(String bosAttachmentProperties, int pageNum) {
        ArrayList rwSupplierEntryList = new ArrayList();
        DB.query((DBRoute)DBRoute.of((String)"scm"), (String)QUERY_SIRW_SUPPLIER_SQL, rs -> {
            while (rs.next()) {
                SupInvitationRwSupplierEntry rwSupplierEntry = new SupInvitationRwSupplierEntry(rs.getLong(1), rs.getLong(2), rs.getBoolean(3), rs.getLong(4), rs.getLong(5), rs.getLong(6));
                rwSupplierEntryList.add(rwSupplierEntry);
            }
            return null;
        });
        BizLog.log((String)("\u9644\u4ef6\u5347\u7ea7\uff1a\u5904\u7406\u4f9b\u65b9\u5165\u56f4\u3010\u5165\u56f4\u3011\u6570\u636esize\uff1a" + rwSupplierEntryList.size()));
        Map<Integer, List<?>> listMap = PageUtil.listPage(rwSupplierEntryList, pageNum);
        for (Map.Entry<Integer, List<?>> listData : listMap.entrySet()) {
            List<SupInvitationRwSupplierEntry> currentList = listData.getValue();
            if (currentList == null || currentList.size() <= 0) continue;
            List<Object> bidProjectList = currentList.stream().map(SupInvitationRwSupplierEntry::getFbidprojectid).collect(Collectors.toList());
            this.dealRwSupplierInvitationFileData(bosAttachmentProperties, bidProjectList, currentList);
        }
        ArrayList bmSupplierEntryList = new ArrayList();
        DB.query((DBRoute)DBRoute.of((String)"scm"), (String)QUERY_SIBM_SUPPLIER_SQL, rs -> {
            while (rs.next()) {
                SupInvitationBmSupplierEntry rwSupplierEntry = new SupInvitationBmSupplierEntry(rs.getLong(1), rs.getLong(2), rs.getLong(3));
                bmSupplierEntryList.add(rwSupplierEntry);
            }
            return null;
        });
        BizLog.log((String)("\u9644\u4ef6\u5347\u7ea7\uff1a\u5904\u7406\u4f9b\u65b9\u5165\u56f4\u3010\u62a5\u540d\u3011\u6570\u636esize\uff1a" + rwSupplierEntryList.size()));
        Map<Integer, List<?>> bmListMap = PageUtil.listPage(bmSupplierEntryList, pageNum);
        for (Map.Entry<Integer, List<?>> listData : bmListMap.entrySet()) {
            List<SupInvitationBmSupplierEntry> currentList = listData.getValue();
            if (currentList == null || currentList.size() <= 0) continue;
            List<Object> bidProjectList = currentList.stream().map(SupInvitationBmSupplierEntry::getFbidprojectid).collect(Collectors.toList());
            this.dealBmSupplierInvitationFileData(bosAttachmentProperties, bidProjectList, currentList);
        }
    }

    public void dealRwSupplierInvitationFileData(String bosAttachmentProperties, List<Object> bidProjectList, List<SupInvitationRwSupplierEntry> currentList) {
        HashMap registerFileMap = new HashMap();
        SqlBuilder sb = new SqlBuilder();
        sb.append(QUERY_BMRW_SUPPLIER_SQL, new Object[0]);
        sb.appendIn("fbidprojectid", bidProjectList);
        DB.query((DBRoute)DBRoute.of((String)"scm"), (SqlBuilder)sb, rs -> {
            while (rs.next()) {
                String type = rs.getString(2);
                String key = null;
                if ("register".equals(type)) {
                    key = String.format("%s_%s_%s", rs.getLong(3), rs.getLong(4), rs.getLong(5));
                } else if ("invitation".equals(type)) {
                    key = String.format("%s_%s_%s", rs.getLong(3), rs.getLong(4), rs.getLong(6));
                }
                registerFileMap.put(key, rs.getString(1));
            }
            return null;
        });
        BizLog.log((String)("\u9644\u4ef6\u5347\u7ea7\uff1a\u5904\u7406\u4f9b\u65b9\u5165\u56f4\u3010\u5165\u56f4registerFileMap\u3011\u9644\u4ef6\u6570\u91cf\uff1a" + registerFileMap.size()));
        if (!registerFileMap.isEmpty()) {
            DynamicObject[] bosAttachmentArray = BusinessDataServiceHelper.load((String)"bos_attachment", (String)bosAttachmentProperties, (QFilter[])new QFilter[]{new QFilter("finterid", "in", registerFileMap.values())});
            Map<String, List<DynamicObject>> attachmentMap = Arrays.stream(bosAttachmentArray).collect(Collectors.groupingBy(t -> t.getString("finterid")));
            String key = null;
            ArrayList<DynamicObject> saveBdAttachmentList = new ArrayList<DynamicObject>();
            ArrayList<Object[]> supplierEntryParamList = new ArrayList<Object[]>(2000);
            for (SupInvitationRwSupplierEntry supplierEntry : currentList) {
                key = supplierEntry.getFisregister() != false ? String.format("%s_%s_%s", supplierEntry.getFbidprojectid(), supplierEntry.getFsupplierid(), supplierEntry.getFannouncementid()) : String.format("%s_%s_%s", supplierEntry.getFbidprojectid(), supplierEntry.getFsupplierid(), supplierEntry.getFinvitation());
                String fInterId = (String)registerFileMap.get(key);
                if (!StringUtils.isNotBlank((CharSequence)fInterId)) continue;
                List attachmentList = attachmentMap.getOrDefault(fInterId, new ArrayList());
                for (DynamicObject attachment : attachmentList) {
                    DynamicObject newAttachment = this.copyBdAttachment(attachment);
                    Object[] paramArr = new Object[]{ID.genLongId(), supplierEntry.getFdetailid(), newAttachment.getLong("id")};
                    supplierEntryParamList.add(paramArr);
                    saveBdAttachmentList.add(newAttachment);
                }
            }
            BizLog.log((String)("\u9644\u4ef6\u5347\u7ea7\uff1a\u5904\u7406\u4f9b\u65b9\u5165\u56f4\u3010\u5165\u56f4\u3011DB\u4fdd\u5b58\u6570\u636e\u5927\u5c0fsaveBdAttachmentList: " + saveBdAttachmentList.size()));
            if (supplierEntryParamList != null && supplierEntryParamList.size() > 0) {
                DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)INSERT_INVITE_ATTACH_SQL, supplierEntryParamList);
            }
            if (saveBdAttachmentList != null && saveBdAttachmentList.size() > 0) {
                try (TXHandle h = TX.requiresNew();){
                    try {
                        SaveServiceHelper.save((DynamicObject[])saveBdAttachmentList.toArray(new DynamicObject[0]));
                    }
                    catch (Throwable ex) {
                        h.markRollback();
                        this.log.error(ex);
                        throw ex;
                    }
                }
            }
            BizLog.log((String)"\u9644\u4ef6\u5347\u7ea7\uff1a\u5904\u7406\u4f9b\u65b9\u5165\u56f4\u3010\u5165\u56f4\u3011DB\u4fdd\u5b58\u6210\u529f");
        }
    }

    public void dealBmSupplierInvitationFileData(String bosAttachmentProperties, List<Object> bidProjectList, List<SupInvitationBmSupplierEntry> currentList) {
        HashMap registerFileMap = new HashMap();
        SqlBuilder sb = new SqlBuilder();
        sb.append(QUERY_BMRW_SUPPLIER_SQL, new Object[0]);
        sb.appendIn("fbidprojectid", bidProjectList);
        DB.query((DBRoute)DBRoute.of((String)"scm"), (SqlBuilder)sb, rs -> {
            while (rs.next()) {
                String type = rs.getString(2);
                String key = null;
                if ("register".equals(type)) {
                    key = String.format("%s_%s", rs.getLong(3), rs.getLong(4));
                }
                registerFileMap.put(key, rs.getString(1));
            }
            return null;
        });
        BizLog.log((String)("\u9644\u4ef6\u5347\u7ea7\uff1a\u5904\u7406\u4f9b\u65b9\u5165\u56f4\u3010\u62a5\u540dregisterFileMap\u3011\u9644\u4ef6\u6570\u91cf\uff1a" + registerFileMap.size()));
        if (!registerFileMap.isEmpty()) {
            DynamicObject[] bosAttachmentArray = BusinessDataServiceHelper.load((String)"bos_attachment", (String)bosAttachmentProperties, (QFilter[])new QFilter[]{new QFilter("finterid", "in", registerFileMap.values())});
            Map<String, List<DynamicObject>> attachmentMap = Arrays.stream(bosAttachmentArray).collect(Collectors.groupingBy(t -> t.getString("finterid")));
            String key = null;
            ArrayList<DynamicObject> saveBdAttachmentList = new ArrayList<DynamicObject>();
            ArrayList<Object[]> supplierEntryParamList = new ArrayList<Object[]>(2000);
            for (SupInvitationBmSupplierEntry supplierEntry : currentList) {
                key = String.format("%s_%s", supplierEntry.getFbidprojectid(), supplierEntry.getFsupplierid());
                String fInterId = (String)registerFileMap.get(key);
                if (!StringUtils.isNotBlank((CharSequence)fInterId)) continue;
                List attachmentList = attachmentMap.getOrDefault(fInterId, new ArrayList());
                for (DynamicObject attachment : attachmentList) {
                    DynamicObject newAttachment = this.copyBdAttachment(attachment);
                    Object[] paramArr = new Object[]{ID.genLongId(), supplierEntry.getFdetailid(), newAttachment.getLong("id")};
                    supplierEntryParamList.add(paramArr);
                    saveBdAttachmentList.add(newAttachment);
                }
            }
            BizLog.log((String)("\u9644\u4ef6\u5347\u7ea7\uff1a\u5904\u7406\u4f9b\u65b9\u5165\u56f4\u3010\u62a5\u540d\u3011\u4fdd\u5b58DB\u9644\u4ef6\u6570\u91cfsaveBdAttachmentList\uff1a" + saveBdAttachmentList.size()));
            if (supplierEntryParamList != null && supplierEntryParamList.size() > 0) {
                DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)INSERT_INVITE_REGAATTACH_SQL, supplierEntryParamList);
            }
            if (saveBdAttachmentList != null && saveBdAttachmentList.size() > 0) {
                try (TXHandle h = TX.requiresNew();){
                    try {
                        SaveServiceHelper.save((DynamicObject[])saveBdAttachmentList.toArray(new DynamicObject[0]));
                    }
                    catch (Throwable ex) {
                        h.markRollback();
                        this.log.error(ex);
                        throw ex;
                    }
                }
            }
            BizLog.log((String)"\u9644\u4ef6\u5347\u7ea7\uff1a\u5904\u7406\u4f9b\u65b9\u5165\u56f4\u3010\u62a5\u540d\u3011\u4fdd\u5b58DB\u6210\u529f");
        }
    }

    public void bidOpenData(String bosAttachmentProperties, int pageNum) {
        ArrayList bidOpenSupplierEntryList = new ArrayList();
        DB.query((DBRoute)DBRoute.of((String)"scm"), (String)BID_OPEN_SECTION_SUPPLIER_ENTRY_SQL, rs -> {
            while (rs.next()) {
                OpenSectionSupplierEntry openSupplierEntry = new OpenSectionSupplierEntry(rs.getLong(1), rs.getLong(2), rs.getLong(3), rs.getLong(4), rs.getLong(5));
                bidOpenSupplierEntryList.add(openSupplierEntry);
            }
            return null;
        });
        BizLog.log((String)("\u9644\u4ef6\u5347\u7ea7\uff1a\u5904\u7406\u5f00\u6807\u6570\u636esize\uff1a" + bidOpenSupplierEntryList.size()));
        Map<Integer, List<?>> listMap = PageUtil.listPage(bidOpenSupplierEntryList, pageNum);
        for (Map.Entry<Integer, List<?>> listData : listMap.entrySet()) {
            List<OpenSectionSupplierEntry> currentList = listData.getValue();
            if (currentList == null || currentList.size() <= 0) continue;
            List<Object> entryIdList = currentList.stream().map(OpenSectionSupplierEntry::getFentryid).collect(Collectors.toList());
            List<Object> bidProjectIdList = currentList.stream().map(OpenSectionSupplierEntry::getFbidprojectid).collect(Collectors.toList());
            this.dealBidOpenFile(bosAttachmentProperties, entryIdList, bidProjectIdList, currentList);
        }
    }

    public void dealBidOpenFile(String bosAttachmentProperties, List<Object> entryIdList, List<Object> bidProjectIdList, List<OpenSectionSupplierEntry> currentList) {
        HashMap bidTenFileMap = new HashMap();
        SqlBuilder tenSb = new SqlBuilder();
        tenSb.append(BID_OPEN_SUPPLIER_ENTRY_SQL, new Object[0]);
        tenSb.appendIn("fentryid", entryIdList);
        DB.query((DBRoute)DBRoute.of((String)"scm"), (SqlBuilder)tenSb, rs -> {
            while (rs.next()) {
                String key = String.format("%s_%s_%s", rs.getString(3), rs.getString(4), rs.getString(2));
                bidTenFileMap.put(key, rs.getString(1));
            }
            return null;
        });
        BizLog.log((String)("\u9644\u4ef6\u5347\u7ea7\uff1a\u5904\u7406\u5f00\u6807\u6570\u636e\u3010bidTenFileMap\u3011\uff1a" + bidTenFileMap.size()));
        HashMap tenUnTenderFileMap = new HashMap();
        SqlBuilder sb = new SqlBuilder();
        sb.append(TEN_UNTENDER_SQL, new Object[0]);
        sb.appendIn("fbidprojectid", bidProjectIdList);
        DB.query((DBRoute)DBRoute.of((String)"scm"), (SqlBuilder)sb, rs -> {
            while (rs.next()) {
                String key = String.format("%s_%s", rs.getString(2), rs.getString(3));
                tenUnTenderFileMap.put(key, rs.getString(1));
            }
            return null;
        });
        BizLog.log((String)("\u9644\u4ef6\u5347\u7ea7\uff1a\u5904\u7406\u5f00\u6807\u6570\u636e\u3010tenUnTenderFileMap\u3011\uff1a" + tenUnTenderFileMap.size()));
        Map<Object, Object> tenAttachmentMap = new HashMap();
        if (bidTenFileMap != null && bidTenFileMap.size() > 0) {
            DynamicObject[] tenAttachmentArray = BusinessDataServiceHelper.load((String)"bos_attachment", (String)bosAttachmentProperties, (QFilter[])new QFilter[]{new QFilter("finterid", "in", bidTenFileMap.values())});
            tenAttachmentMap = Arrays.stream(tenAttachmentArray).collect(Collectors.groupingBy(t -> t.getString("finterid")));
        }
        BizLog.log((String)("\u9644\u4ef6\u5347\u7ea7\uff1a\u5904\u7406\u5f00\u6807\u6570\u636e\u3010tenAttachmentMap\u3011\uff1a" + tenAttachmentMap.size()));
        Map<Object, Object> unTenderAttachmentMap = new HashMap();
        if (tenUnTenderFileMap != null && tenUnTenderFileMap.size() > 0) {
            DynamicObject[] unTenderAttachmentArray = BusinessDataServiceHelper.load((String)"bos_attachment", (String)bosAttachmentProperties, (QFilter[])new QFilter[]{new QFilter("finterid", "in", tenUnTenderFileMap.values())});
            unTenderAttachmentMap = Arrays.stream(unTenderAttachmentArray).collect(Collectors.groupingBy(t -> t.getString("finterid")));
        }
        BizLog.log((String)("\u9644\u4ef6\u5347\u7ea7\uff1a\u5904\u7406\u5f00\u6807\u6570\u636e\u3010unTenderAttachmentMap\u3011\uff1a" + unTenderAttachmentMap.size()));
        ArrayList<Object[]> comFileParamList = new ArrayList<Object[]>();
        ArrayList<Object[]> techFileParamList = new ArrayList<Object[]>();
        ArrayList<Object[]> tenFileParamList = new ArrayList<Object[]>();
        ArrayList<Object[]> otherFileParamList = new ArrayList<Object[]>();
        ArrayList<Object[]> unTenderFileParamList = new ArrayList<Object[]>();
        ArrayList<DynamicObject> saveAttachmentList = new ArrayList<DynamicObject>();
        for (OpenSectionSupplierEntry supplierEntry : currentList) {
            String unTenderFileKey;
            String unTenderFileFid;
            String otherFileKey;
            String otherFileFid;
            String tenFileKey;
            String tenFileFid;
            String techFileKey;
            String techFileFid;
            String comFileKey = String.format("%s_%s_%s", supplierEntry.getFentryid(), supplierEntry.getFsupplierid(), "comFile");
            String comFileFid = (String)bidTenFileMap.get(comFileKey);
            if (StringUtils.isNotBlank((CharSequence)comFileFid)) {
                List attachmentList = tenAttachmentMap.getOrDefault(comFileFid, new ArrayList());
                for (DynamicObject attachment : attachmentList) {
                    DynamicObject newAttachment = this.copyBdAttachment(attachment);
                    saveAttachmentList.add(newAttachment);
                    Object[] paramArr = new Object[]{ID.genLongId(), supplierEntry.getFdetailid(), newAttachment.getLong("id")};
                    comFileParamList.add(paramArr);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)(techFileFid = (String)bidTenFileMap.get(techFileKey = String.format("%s_%s_%s", supplierEntry.getFentryid(), supplierEntry.getFsupplierid(), "techFile"))))) {
                List attachmentList = tenAttachmentMap.getOrDefault(techFileFid, new ArrayList());
                for (DynamicObject attachment : attachmentList) {
                    DynamicObject newAttachment = this.copyBdAttachment(attachment);
                    saveAttachmentList.add(newAttachment);
                    Object[] paramArr = new Object[]{ID.genLongId(), supplierEntry.getFdetailid(), newAttachment.getLong("id")};
                    techFileParamList.add(paramArr);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)(tenFileFid = (String)bidTenFileMap.get(tenFileKey = String.format("%s_%s_%s", supplierEntry.getFentryid(), supplierEntry.getFsupplierid(), "tenFile"))))) {
                List attachmentList = tenAttachmentMap.getOrDefault(tenFileFid, new ArrayList());
                for (DynamicObject attachment : attachmentList) {
                    DynamicObject newAttachment = this.copyBdAttachment(attachment);
                    saveAttachmentList.add(newAttachment);
                    Object[] paramArr = new Object[]{ID.genLongId(), supplierEntry.getFdetailid(), newAttachment.getLong("id")};
                    tenFileParamList.add(paramArr);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)(otherFileFid = (String)bidTenFileMap.get(otherFileKey = String.format("%s_%s_%s", supplierEntry.getFentryid(), supplierEntry.getFsupplierid(), "otherFile"))))) {
                List attachmentList = tenAttachmentMap.getOrDefault(otherFileFid, new ArrayList());
                for (DynamicObject attachment : attachmentList) {
                    DynamicObject newAttachment = this.copyBdAttachment(attachment);
                    saveAttachmentList.add(newAttachment);
                    Object[] paramArr = new Object[]{ID.genLongId(), supplierEntry.getFdetailid(), newAttachment.getLong("id")};
                    otherFileParamList.add(paramArr);
                }
            }
            if (!StringUtils.isNotBlank((CharSequence)(unTenderFileFid = (String)tenUnTenderFileMap.get(unTenderFileKey = String.format("%s_%s", supplierEntry.getFbidprojectid(), supplierEntry.getFsupplierid()))))) continue;
            List attachmentList = unTenderAttachmentMap.getOrDefault(unTenderFileFid, new ArrayList());
            for (DynamicObject attachment : attachmentList) {
                DynamicObject newAttachment = this.copyBdAttachment(attachment);
                saveAttachmentList.add(newAttachment);
                Object[] paramArr = new Object[]{ID.genLongId(), supplierEntry.getFdetailid(), newAttachment.getLong("id")};
                unTenderFileParamList.add(paramArr);
            }
        }
        BizLog.log((String)("\u9644\u4ef6\u5347\u7ea7\uff1a\u5904\u7406\u5f00\u6807\u6570\u636e\u3010DB\u3011\u4fdd\u5b58\u9644\u4ef6\u6570\u91cfsaveAttachmentList\uff1a" + saveAttachmentList.size()));
        if (comFileParamList != null && comFileParamList.size() > 0) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)BID_OPEN_INSERT_COMFILE_SQL, comFileParamList);
        }
        if (techFileParamList != null && techFileParamList.size() > 0) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)BID_OPEN_INSERT_TECHFILE_SQL, techFileParamList);
        }
        if (tenFileParamList != null && tenFileParamList.size() > 0) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)BID_OPEN_INSERT_TENFILE_SQL, tenFileParamList);
        }
        if (otherFileParamList != null && otherFileParamList.size() > 0) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)BID_OPEN_INSERT_OTHERFILE_SQL, otherFileParamList);
        }
        if (unTenderFileParamList != null && unTenderFileParamList.size() > 0) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)BID_OPEN_INSERT_UNTENDERFILE_SQL, unTenderFileParamList);
        }
        if (saveAttachmentList != null && saveAttachmentList.size() > 0) {
            try (TXHandle h = TX.requiresNew();){
                try {
                    SaveServiceHelper.save((DynamicObject[])saveAttachmentList.toArray(new DynamicObject[0]));
                }
                catch (Throwable ex) {
                    h.markRollback();
                    this.log.error(ex);
                    throw ex;
                }
            }
        }
        BizLog.log((String)"\u9644\u4ef6\u5347\u7ea7\uff1a\u5904\u7406\u5f00\u6807\u6570\u636e\u3010DB\u4fdd\u5b58\u6210\u529f\u3011");
    }

    public void backBid(String bosAttachmentProperties, int pageNum) {
        ArrayList backSupplierEntryList = new ArrayList();
        DB.query((DBRoute)DBRoute.of((String)"scm"), (String)REBCAK_SUPENTRY_QUERY_SQL, rs -> {
            while (rs.next()) {
                BackSupplierEntry openSupplierEntry = new BackSupplierEntry(rs.getLong(1), rs.getLong(2), rs.getLong(3));
                backSupplierEntryList.add(openSupplierEntry);
            }
            return null;
        });
        BizLog.log((String)("\u9644\u4ef6\u5347\u7ea7\uff1a\u5904\u7406\u56de\u6807\u6570\u636e\u6570\u91cfbackSupplierEntryList\uff1a" + backSupplierEntryList.size()));
        Map<Integer, List<?>> listMap = PageUtil.listPage(backSupplierEntryList, pageNum);
        for (Map.Entry<Integer, List<?>> listData : listMap.entrySet()) {
            List<BackSupplierEntry> currentList = listData.getValue();
            if (currentList == null || currentList.size() <= 0) continue;
            List<Object> entryIdList = currentList.stream().map(BackSupplierEntry::getFsrcsectionid).collect(Collectors.toList());
            this.dealBackBidFile(bosAttachmentProperties, entryIdList, currentList);
        }
    }

    public void dealBackBidFile(String bosAttachmentProperties, List<Object> entryIdList, List<BackSupplierEntry> currentList) {
        HashMap bidTenFileMap = new HashMap();
        SqlBuilder tenSb = new SqlBuilder();
        tenSb.append(BID_OPEN_SUPPLIER_ENTRY_SQL, new Object[0]);
        tenSb.appendIn("fentryid", entryIdList);
        DB.query((DBRoute)DBRoute.of((String)"scm"), (SqlBuilder)tenSb, rs -> {
            while (rs.next()) {
                String key = String.format("%s_%s_%s", rs.getString(3), rs.getString(4), rs.getString(2));
                bidTenFileMap.put(key, rs.getString(1));
            }
            return null;
        });
        BizLog.log((String)("\u9644\u4ef6\u5347\u7ea7\uff1a\u5904\u7406\u56de\u6807\u5916\u7f51\u6295\u6807\u6570\u636ebidTenFileMap\uff1a" + bidTenFileMap.size()));
        Map<Object, Object> tenAttachmentMap = new HashMap();
        if (bidTenFileMap != null && bidTenFileMap.size() > 0) {
            DynamicObject[] tenAttachmentArray = BusinessDataServiceHelper.load((String)"bos_attachment", (String)bosAttachmentProperties, (QFilter[])new QFilter[]{new QFilter("finterid", "in", bidTenFileMap.values())});
            tenAttachmentMap = Arrays.stream(tenAttachmentArray).collect(Collectors.groupingBy(t -> t.getString("finterid")));
        }
        BizLog.log((String)("\u9644\u4ef6\u5347\u7ea7\uff1a\u5904\u7406\u56de\u6807\u5916\u7f51\u6295\u6807\u6570\u636etenAttachmentMap\uff1a" + tenAttachmentMap.size()));
        ArrayList<Object[]> comFileParamList = new ArrayList<Object[]>();
        ArrayList<Object[]> techFileParamList = new ArrayList<Object[]>();
        ArrayList<Object[]> tenFileParamList = new ArrayList<Object[]>();
        ArrayList<Object[]> otherFileParamList = new ArrayList<Object[]>();
        ArrayList<DynamicObject> saveAttachmentList = new ArrayList<DynamicObject>();
        for (BackSupplierEntry supplierEntry : currentList) {
            String otherFileKey;
            String otherFileFid;
            String tenFileKey;
            String tenFileFid;
            String techFileKey;
            String techFileFid;
            String comFileKey = String.format("%s_%s_%s", supplierEntry.getFsrcsectionid(), supplierEntry.getFsupplierid(), "comFile");
            String comFileFid = (String)bidTenFileMap.get(comFileKey);
            if (StringUtils.isNotBlank((CharSequence)comFileFid)) {
                List attachmentList = tenAttachmentMap.getOrDefault(comFileFid, new ArrayList());
                for (DynamicObject attachment : attachmentList) {
                    DynamicObject newAttachment = this.copyBdAttachment(attachment);
                    saveAttachmentList.add(newAttachment);
                    Object[] paramArr = new Object[]{ID.genLongId(), supplierEntry.getFdetailid(), newAttachment.getLong("id")};
                    comFileParamList.add(paramArr);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)(techFileFid = (String)bidTenFileMap.get(techFileKey = String.format("%s_%s_%s", supplierEntry.getFsrcsectionid(), supplierEntry.getFsupplierid(), "techFile"))))) {
                List attachmentList = tenAttachmentMap.getOrDefault(techFileFid, new ArrayList());
                for (DynamicObject attachment : attachmentList) {
                    DynamicObject newAttachment = this.copyBdAttachment(attachment);
                    saveAttachmentList.add(newAttachment);
                    Object[] paramArr = new Object[]{ID.genLongId(), supplierEntry.getFdetailid(), newAttachment.getLong("id")};
                    techFileParamList.add(paramArr);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)(tenFileFid = (String)bidTenFileMap.get(tenFileKey = String.format("%s_%s_%s", supplierEntry.getFsrcsectionid(), supplierEntry.getFsupplierid(), "tenFile"))))) {
                List attachmentList = tenAttachmentMap.getOrDefault(tenFileFid, new ArrayList());
                for (DynamicObject attachment : attachmentList) {
                    DynamicObject newAttachment = this.copyBdAttachment(attachment);
                    saveAttachmentList.add(newAttachment);
                    Object[] paramArr = new Object[]{ID.genLongId(), supplierEntry.getFdetailid(), newAttachment.getLong("id")};
                    tenFileParamList.add(paramArr);
                }
            }
            if (!StringUtils.isNotBlank((CharSequence)(otherFileFid = (String)bidTenFileMap.get(otherFileKey = String.format("%s_%s_%s", supplierEntry.getFsrcsectionid(), supplierEntry.getFsupplierid(), "otherFile"))))) continue;
            List attachmentList = tenAttachmentMap.getOrDefault(otherFileFid, new ArrayList());
            for (DynamicObject attachment : attachmentList) {
                DynamicObject newAttachment = this.copyBdAttachment(attachment);
                saveAttachmentList.add(newAttachment);
                Object[] paramArr = new Object[]{ID.genLongId(), supplierEntry.getFdetailid(), newAttachment.getLong("id")};
                otherFileParamList.add(paramArr);
            }
        }
        BizLog.log((String)("\u9644\u4ef6\u5347\u7ea7\uff1a\u5904\u7406\u56de\u6807\u3010DB\u3011\u4fdd\u5b58\u9644\u4ef6\u6570\u636esaveAttachmentList\uff1a" + saveAttachmentList.size()));
        if (comFileParamList != null && comFileParamList.size() > 0) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)REBCAK_COMFILE_INSERT_SQL, comFileParamList);
        }
        if (techFileParamList != null && techFileParamList.size() > 0) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)REBCAK_TECHFILE_INSERT_SQL, techFileParamList);
        }
        if (tenFileParamList != null && tenFileParamList.size() > 0) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)REBCAK_TENFILE_INSERT_SQL, tenFileParamList);
        }
        if (otherFileParamList != null && otherFileParamList.size() > 0) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)REBCAK_OTHERFILE_INSERT_SQL, otherFileParamList);
        }
        if (saveAttachmentList != null && saveAttachmentList.size() > 0) {
            try (TXHandle h = TX.requiresNew();){
                try {
                    SaveServiceHelper.save((DynamicObject[])saveAttachmentList.toArray(new DynamicObject[0]));
                }
                catch (Throwable ex) {
                    h.markRollback();
                    this.log.error(ex);
                    throw ex;
                }
            }
        }
        BizLog.log((String)"\u9644\u4ef6\u5347\u7ea7\uff1a\u5904\u7406\u56de\u6807\u3010DB\u3011\u4fdd\u5b58\u6210\u529f");
    }

    public void onlineEval(String bosAttachmentProperties, int pageNum) {
        ArrayList onlineEvalSupplierEntryList = new ArrayList();
        DB.query((DBRoute)DBRoute.of((String)"scm"), (String)BID_ONLIEEVAL_SECTION_SUPPLIER_ENTRY_SQL, rs -> {
            while (rs.next()) {
                OnlineEvalSupplierEntry onlineEvalSupplierEntry = new OnlineEvalSupplierEntry(rs.getLong(2), rs.getLong(3), rs.getLong(4));
                onlineEvalSupplierEntryList.add(onlineEvalSupplierEntry);
            }
            return null;
        });
        BizLog.log((String)("\u9644\u4ef6\u5347\u7ea7\uff1a\u5904\u7406\u5728\u7ebf\u8bc4\u6807\u6570\u636e\u6570\u91cfonlineEvalSupplierEntryList\uff1a" + onlineEvalSupplierEntryList.size()));
        Map<Integer, List<?>> listMap = PageUtil.listPage(onlineEvalSupplierEntryList, pageNum);
        for (Map.Entry<Integer, List<?>> listData : listMap.entrySet()) {
            List<OnlineEvalSupplierEntry> currentList = listData.getValue();
            if (currentList == null || currentList.size() <= 0) continue;
            List<Object> entryIdList = currentList.stream().map(OnlineEvalSupplierEntry::getFopensectionid).collect(Collectors.toList());
            this.dealOnlineEvalFile(bosAttachmentProperties, entryIdList, currentList);
        }
    }

    public void dealOnlineEvalFile(String bosAttachmentProperties, List<Object> entryIdList, List<OnlineEvalSupplierEntry> currentList) {
        HashMap bidTenFileMap = new HashMap();
        SqlBuilder tenSb = new SqlBuilder();
        tenSb.append(BID_OPEN_SUPPLIER_ENTRY_SQL, new Object[0]);
        tenSb.appendIn("fentryid", entryIdList);
        DB.query((DBRoute)DBRoute.of((String)"scm"), (SqlBuilder)tenSb, rs -> {
            while (rs.next()) {
                String key = String.format("%s_%s_%s", rs.getString(3), rs.getString(4), rs.getString(2));
                bidTenFileMap.put(key, rs.getString(1));
            }
            return null;
        });
        BizLog.log((String)("\u9644\u4ef6\u5347\u7ea7\uff1a\u5904\u7406\u5728\u7ebf\u8bc4\u6807\u9644\u4ef6\u6570\u636ebidTenFileMap\uff1a" + bidTenFileMap.size()));
        Map<Object, Object> tenAttachmentMap = new HashMap();
        if (bidTenFileMap != null && bidTenFileMap.size() > 0) {
            DynamicObject[] tenAttachmentArray = BusinessDataServiceHelper.load((String)"bos_attachment", (String)bosAttachmentProperties, (QFilter[])new QFilter[]{new QFilter("finterid", "in", bidTenFileMap.values())});
            tenAttachmentMap = Arrays.stream(tenAttachmentArray).collect(Collectors.groupingBy(t -> t.getString("finterid")));
        }
        BizLog.log((String)("\u9644\u4ef6\u5347\u7ea7\uff1a\u5904\u7406\u5728\u7ebf\u8bc4\u6807\u9644\u4ef6\u6570\u636etenAttachmentMap\uff1a" + tenAttachmentMap.size()));
        ArrayList<Object[]> comFileParamList = new ArrayList<Object[]>();
        ArrayList<Object[]> techFileParamList = new ArrayList<Object[]>();
        ArrayList<DynamicObject> saveAttachmentList = new ArrayList<DynamicObject>();
        for (OnlineEvalSupplierEntry supplierEntry : currentList) {
            String techFileKey;
            String techFileFid;
            String comFileKey = String.format("%s_%s_%s", supplierEntry.getFopensectionid(), supplierEntry.getFsupplierid(), "comFile");
            String comFileFid = (String)bidTenFileMap.get(comFileKey);
            if (StringUtils.isNotBlank((CharSequence)comFileFid)) {
                List attachmentList = tenAttachmentMap.getOrDefault(comFileFid, new ArrayList());
                for (DynamicObject attachment : attachmentList) {
                    DynamicObject newAttachment = this.copyBdAttachment(attachment);
                    saveAttachmentList.add(newAttachment);
                    Object[] paramArr = new Object[]{ID.genLongId(), supplierEntry.getFdetailid(), newAttachment.getLong("id")};
                    comFileParamList.add(paramArr);
                }
            }
            if (!StringUtils.isNotBlank((CharSequence)(techFileFid = (String)bidTenFileMap.get(techFileKey = String.format("%s_%s_%s", supplierEntry.getFopensectionid(), supplierEntry.getFsupplierid(), "techFile"))))) continue;
            List attachmentList = tenAttachmentMap.getOrDefault(techFileFid, new ArrayList());
            for (DynamicObject attachment : attachmentList) {
                DynamicObject newAttachment = this.copyBdAttachment(attachment);
                saveAttachmentList.add(newAttachment);
                Object[] paramArr = new Object[]{ID.genLongId(), supplierEntry.getFdetailid(), newAttachment.getLong("id")};
                techFileParamList.add(paramArr);
            }
        }
        BizLog.log((String)("\u9644\u4ef6\u5347\u7ea7\uff1a\u5904\u7406\u5728\u7ebf\u8bc4\u6807\u9644\u4ef6\u6570\u636esaveAttachmentList\uff1a" + saveAttachmentList.size()));
        if (comFileParamList != null && comFileParamList.size() > 0) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)BID_ONLINE_EVAL_COMFILE_SQL, comFileParamList);
        }
        if (techFileParamList != null && techFileParamList.size() > 0) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)BID_ONLINE_EVAL_TECHFILE_SQL, techFileParamList);
        }
        if (saveAttachmentList != null && saveAttachmentList.size() > 0) {
            try (TXHandle h = TX.requiresNew();){
                try {
                    SaveServiceHelper.save((DynamicObject[])saveAttachmentList.toArray(new DynamicObject[0]));
                }
                catch (Throwable ex) {
                    h.markRollback();
                    this.log.error(ex);
                    throw ex;
                }
            }
        }
        BizLog.log((String)"\u9644\u4ef6\u5347\u7ea7\uff1a\u5904\u7406\u5728\u7ebf\u8bc4\u6807\u9644\u4ef6\u6570\u636e\u3010DB\u3011\u4fdd\u5b58\u6210\u529f");
    }

    public void busTak(String bosAttachmentProperties, int pageNum) {
        ArrayList supplierEntryList = new ArrayList();
        DB.query((DBRoute)DBRoute.of((String)"scm"), (String)BUSTALK_SUPPLIER_FILE_SQL, rs -> {
            while (rs.next()) {
                BusTalkSupplierEntry supplierEntry = new BusTalkSupplierEntry(rs.getLong(1), rs.getLong(2));
                supplierEntryList.add(supplierEntry);
            }
            return null;
        });
        BizLog.log((String)("\u9644\u4ef6\u5347\u7ea7\uff1a\u5904\u7406\u5546\u52a1\u8c08\u5224\u6570\u636e\u6570\u91cfsupplierEntryList\uff1a" + supplierEntryList.size()));
        Map<Integer, List<?>> listMap = PageUtil.listPage(supplierEntryList, pageNum);
        for (Map.Entry<Integer, List<?>> listData : listMap.entrySet()) {
            List<BusTalkSupplierEntry> currentList = listData.getValue();
            if (currentList == null || currentList.size() <= 0) continue;
            List<Object> entryIdList = currentList.stream().map(BusTalkSupplierEntry::getFdetailid).collect(Collectors.toList());
            this.dealBusTakFile(bosAttachmentProperties, entryIdList, currentList);
        }
    }

    public void dealBusTakFile(String bosAttachmentProperties, List<Object> entryIdList, List<BusTalkSupplierEntry> currentList) {
        HashMap bidBusTalkFileMap = new HashMap();
        SqlBuilder tenSb = new SqlBuilder();
        tenSb.append(BUSTALK_FILE_SQL, new Object[0]);
        tenSb.appendIn("fentryid", entryIdList);
        DB.query((DBRoute)DBRoute.of((String)"scm"), (SqlBuilder)tenSb, rs -> {
            while (rs.next()) {
                String key = String.format("%s_%s_%s", rs.getString(3), rs.getString(4), rs.getString(2));
                bidBusTalkFileMap.put(key, rs.getString(1));
            }
            return null;
        });
        BizLog.log((String)("\u9644\u4ef6\u5347\u7ea7\uff1a\u5904\u7406\u5546\u52a1\u8c08\u5224\u6570\u636e\u6570\u91cfbidBusTalkFileMap\uff1a" + bidBusTalkFileMap.size()));
        Map<Object, Object> attachmentMap = new HashMap();
        if (bidBusTalkFileMap != null && bidBusTalkFileMap.size() > 0) {
            DynamicObject[] tenAttachmentArray = BusinessDataServiceHelper.load((String)"bos_attachment", (String)bosAttachmentProperties, (QFilter[])new QFilter[]{new QFilter("finterid", "in", bidBusTalkFileMap.values())});
            attachmentMap = Arrays.stream(tenAttachmentArray).collect(Collectors.groupingBy(t -> t.getString("finterid")));
        }
        ArrayList<Object[]> comFileParamList = new ArrayList<Object[]>();
        ArrayList<Object[]> techFileParamList = new ArrayList<Object[]>();
        ArrayList<Object[]> otherFileParamList = new ArrayList<Object[]>();
        ArrayList<DynamicObject> saveAttachmentList = new ArrayList<DynamicObject>();
        for (BusTalkSupplierEntry supplierEntry : currentList) {
            String otherFileKey;
            String otherFileFid;
            String techFileKey;
            String techFileFid;
            String comFileKey = String.format("%s_%s_%s", supplierEntry.getFdetailid(), supplierEntry.getFsupplierid(), "comFile");
            String comFileFid = (String)bidBusTalkFileMap.get(comFileKey);
            if (StringUtils.isNotBlank((CharSequence)comFileFid)) {
                List attachmentList = attachmentMap.getOrDefault(comFileFid, new ArrayList());
                for (DynamicObject attachment : attachmentList) {
                    DynamicObject newAttachment = this.copyBdAttachment(attachment);
                    saveAttachmentList.add(newAttachment);
                    Object[] paramArr = new Object[]{ID.genLongId(), supplierEntry.getFdetailid(), newAttachment.getLong("id")};
                    comFileParamList.add(paramArr);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)(techFileFid = (String)bidBusTalkFileMap.get(techFileKey = String.format("%s_%s_%s", supplierEntry.getFdetailid(), supplierEntry.getFsupplierid(), "techFile"))))) {
                List attachmentList = attachmentMap.getOrDefault(techFileFid, new ArrayList());
                for (DynamicObject attachment : attachmentList) {
                    DynamicObject newAttachment = this.copyBdAttachment(attachment);
                    saveAttachmentList.add(newAttachment);
                    Object[] paramArr = new Object[]{ID.genLongId(), supplierEntry.getFdetailid(), newAttachment.getLong("id")};
                    techFileParamList.add(paramArr);
                }
            }
            if (!StringUtils.isNotBlank((CharSequence)(otherFileFid = (String)bidBusTalkFileMap.get(otherFileKey = String.format("%s_%s_%s", supplierEntry.getFdetailid(), supplierEntry.getFsupplierid(), "otherFile"))))) continue;
            List attachmentList = attachmentMap.getOrDefault(otherFileFid, new ArrayList());
            for (DynamicObject attachment : attachmentList) {
                DynamicObject newAttachment = this.copyBdAttachment(attachment);
                saveAttachmentList.add(newAttachment);
                Object[] paramArr = new Object[]{ID.genLongId(), supplierEntry.getFdetailid(), newAttachment.getLong("id")};
                otherFileParamList.add(paramArr);
            }
        }
        BizLog.log((String)("\u9644\u4ef6\u5347\u7ea7\uff1a\u5904\u7406\u5546\u52a1\u8c08\u5224\u6570\u636e\u6570\u91cfsaveAttachmentList\uff1a" + saveAttachmentList.size()));
        if (comFileParamList != null && comFileParamList.size() > 0) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)BUSTALK_COMFILE_INSERT_SQL, comFileParamList);
        }
        if (techFileParamList != null && techFileParamList.size() > 0) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)BUSTALK_TECHFILE_INSERT_SQL, techFileParamList);
        }
        if (otherFileParamList != null && otherFileParamList.size() > 0) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)BUSTALK_OTHERFILE_INSERT_SQL, otherFileParamList);
        }
        if (saveAttachmentList != null && saveAttachmentList.size() > 0 && saveAttachmentList != null && saveAttachmentList.size() > 0) {
            try (TXHandle h = TX.requiresNew();){
                try {
                    SaveServiceHelper.save((DynamicObject[])saveAttachmentList.toArray(new DynamicObject[0]));
                }
                catch (Throwable ex) {
                    h.markRollback();
                    this.log.error(ex);
                    throw ex;
                }
            }
        }
        BizLog.log((String)("\u9644\u4ef6\u5347\u7ea7\uff1a\u5904\u7406\u5546\u52a1\u8c08\u5224\u6570\u636e\u3010DB\u3011\u4fdd\u5b58\u6210\u529f\uff1a" + saveAttachmentList.size()));
    }

    public void decision(String bosAttachmentProperties, int pageNum) {
        ArrayList decisionSupplierEntryList = new ArrayList();
        DB.query((DBRoute)DBRoute.of((String)"scm"), (String)DECISION_SUPPLIERENTRY_QUERY_SQL, rs -> {
            while (rs.next()) {
                decisionSupplierEntryList.add(rs.getLong(1));
            }
            return null;
        });
        BizLog.log((String)("\u9644\u4ef6\u5347\u7ea7\uff1a\u5904\u7406\u5b9a\u6807\u6570\u636edecisionSupplierEntryList\uff1a" + decisionSupplierEntryList.size()));
        Map<Integer, List<?>> listMap = PageUtil.listPage(decisionSupplierEntryList, pageNum);
        for (Map.Entry<Integer, List<?>> listData : listMap.entrySet()) {
            List<Object> currentList = listData.getValue();
            this.dealDecisionFile(bosAttachmentProperties, currentList);
        }
    }

    public void dealDecisionFile(String bosAttachmentProperties, List<Object> currentList) {
        if (currentList != null && currentList.size() > 0) {
            HashMap bidDecisionFileMap = new HashMap();
            SqlBuilder sb = new SqlBuilder();
            sb.append(DECISION_FILE_QUERY_SQL, new Object[0]);
            sb.appendIn("fdetailid", currentList);
            DB.query((DBRoute)DBRoute.of((String)"scm"), (SqlBuilder)sb, rs -> {
                while (rs.next()) {
                    bidDecisionFileMap.put(rs.getLong(2), rs.getString(1));
                }
                return null;
            });
            BizLog.log((String)("\u9644\u4ef6\u5347\u7ea7\uff1a\u5904\u7406\u5b9a\u6807\u6570\u636ebidDecisionFileMap\uff1a" + bidDecisionFileMap.size()));
            ArrayList<DynamicObject> saveAttachmentList = new ArrayList<DynamicObject>();
            ArrayList<Object[]> techParamList = new ArrayList<Object[]>();
            ArrayList<Object[]> comParamList = new ArrayList<Object[]>();
            if (!bidDecisionFileMap.isEmpty()) {
                DynamicObject[] tenAttachmentArray = BusinessDataServiceHelper.load((String)"bos_attachment", (String)bosAttachmentProperties, (QFilter[])new QFilter[]{new QFilter("finterid", "in", bidDecisionFileMap.values())});
                Map<String, List<DynamicObject>> attachmentMap = Arrays.stream(tenAttachmentArray).collect(Collectors.groupingBy(t -> t.getString("finterid")));
                for (Object decisionEntry : currentList) {
                    String fileFid = bidDecisionFileMap.getOrDefault(decisionEntry, null);
                    if (!StringUtils.isNotBlank((CharSequence)fileFid)) continue;
                    List attachmentList = attachmentMap.getOrDefault(fileFid, new ArrayList());
                    for (DynamicObject bosAttachment : attachmentList) {
                        String attachmentPanelKey = bosAttachment.getString("fattachmentpanel");
                        DynamicObject newAttachment = this.copyBdAttachment(bosAttachment);
                        Object[] paramArr = new Object[]{ID.genLongId(), decisionEntry, newAttachment.getLong("id")};
                        if ("techfilepanel".equals(attachmentPanelKey)) {
                            techParamList.add(paramArr);
                        } else if ("commfilepanel".equals(attachmentPanelKey)) {
                            comParamList.add(paramArr);
                        }
                        saveAttachmentList.add(newAttachment);
                    }
                }
                BizLog.log((String)("\u9644\u4ef6\u5347\u7ea7\uff1a\u5904\u7406\u5b9a\u6807\u6570\u636esaveAttachmentList\uff1a" + saveAttachmentList.size()));
                if (techParamList != null && techParamList.size() > 0) {
                    DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)DECISION_TECHFILE_INSERT_SQL, techParamList);
                }
                if (comParamList != null && comParamList.size() > 0) {
                    DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)DECISION_COMFILE_INSERT_SQL, comParamList);
                }
                if (saveAttachmentList != null && saveAttachmentList.size() > 0) {
                    try (TXHandle h = TX.requiresNew();){
                        try {
                            SaveServiceHelper.save((DynamicObject[])saveAttachmentList.toArray(new DynamicObject[0]));
                        }
                        catch (Throwable ex) {
                            h.markRollback();
                            this.log.error(ex);
                            throw ex;
                        }
                    }
                }
                BizLog.log((String)("\u9644\u4ef6\u5347\u7ea7\uff1a\u5904\u7406\u5b9a\u6807\u6570\u636e\u3010DB\u3011\u4fdd\u5b58\u6210\u529f\uff1a" + saveAttachmentList.size()));
            }
        }
    }

    public void decisionConfirmBidFile(String bosAttachmentProperties, int pageNum) {
        DynamicObject[] bidIdArray = BusinessDataServiceHelper.load((String)"bid_decision", (String)"id", (QFilter[])new QFilter[]{new QFilter("entitytypeid", "=", (Object)"bid_decision")});
        BizLog.log((String)("\u9644\u4ef6\u5347\u7ea7\uff1a\u5904\u7406\u5b9a\u6807\u786e\u8ba4\u4e2d\u6807\u9644\u4ef6\u6570\u636ebidIdArray\uff1a" + bidIdArray.length));
        Map<Integer, List<?>> bidIdListMap = PageUtil.listPageByDynamicObject(bidIdArray, pageNum);
        for (Map.Entry<Integer, List<?>> listData : bidIdListMap.entrySet()) {
            List<?> currentList = listData.getValue();
            if (currentList == null || currentList.size() <= 0) continue;
            ArrayList idList = new ArrayList();
            currentList.forEach(item -> idList.add(item.getPkValue()));
            DynamicObject[] bidDecisonArray = BusinessDataServiceHelper.load((String)"bid_decision", (String)"bidproject,bidsection,sectionname,supplierentry,supplier", (QFilter[])new QFilter[]{new QFilter("entitytypeid", "=", (Object)"bid_decision"), new QFilter("id", "in", idList)});
            ArrayList<Object> bidProjectIdList = new ArrayList<Object>();
            for (DynamicObject bidDecison : bidDecisonArray) {
                DynamicObject bidProject = bidDecison.getDynamicObject("bidproject");
                if (bidProject == null) continue;
                bidProjectIdList.add(bidProject.getPkValue());
            }
            HashMap<String, String> decisionSupplierFileMap = new HashMap<String, String>();
            String bidProjectIdStr = bidProjectIdList.stream().map(item -> "'" + item.toString() + "'").collect(Collectors.joining(","));
            DB.query((DBRoute)DBRoute.of((String)"scm"), (String)String.format(DECISION_COMFIRM_FILE_QUERY_SQL, bidProjectIdStr), rs -> {
                while (rs.next()) {
                    String key = String.format("%s_%s_%s", rs.getString(2), rs.getString(3), rs.getString(4));
                    decisionSupplierFileMap.put(key, rs.getString(1));
                }
                return null;
            });
            this.dealDecisionConfirmBidFile(bosAttachmentProperties, bidDecisonArray, decisionSupplierFileMap);
        }
        try {
            DynamicObject[] rebmIdArray = BusinessDataServiceHelper.load((String)"rebm_decision", (String)"id", (QFilter[])new QFilter[]{new QFilter("entitytypeid", "=", (Object)"rebm_decision")});
            BizLog.log((String)("\u9644\u4ef6\u5347\u7ea7\uff1a\u5904\u7406\u5b9a\u6807\u786e\u8ba4\u4e2d\u6807\u9644\u4ef6\u6570\u636ebidIdArray\uff1a" + bidIdArray.length));
            Map<Integer, List<?>> rebmIdListMap = PageUtil.listPageByDynamicObject(rebmIdArray, pageNum);
            for (Map.Entry<Integer, List<?>> listData : rebmIdListMap.entrySet()) {
                List<?> currentList = listData.getValue();
                if (currentList == null || currentList.size() <= 0) continue;
                ArrayList idList = new ArrayList();
                currentList.forEach(item -> idList.add(item.getPkValue()));
                DynamicObject[] rebmDecisonArray = BusinessDataServiceHelper.load((String)"rebm_decision", (String)"bidproject,bidsection,sectionname,supplierentry,supplier", (QFilter[])new QFilter[]{new QFilter("entitytypeid", "=", (Object)"rebm_decision"), new QFilter("id", "in", idList)});
                ArrayList<Object> rebmBidProjectIdList = new ArrayList<Object>();
                for (DynamicObject bidDecison : rebmDecisonArray) {
                    DynamicObject bidProject = bidDecison.getDynamicObject("bidproject");
                    if (bidProject == null) continue;
                    rebmBidProjectIdList.add(bidProject.getPkValue());
                }
                HashMap<String, String> rebmDecisionSupplierFileMap = new HashMap<String, String>();
                String rebmBidProjectIdStr = rebmBidProjectIdList.stream().map(item -> "'" + item.toString() + "'").collect(Collectors.joining(","));
                DB.query((DBRoute)DBRoute.of((String)"scm"), (String)String.format(DECISION_COMFIRM_FILE_QUERY_SQL, rebmBidProjectIdStr), rs -> {
                    while (rs.next()) {
                        String key = String.format("%s_%s_%s", rs.getString(2), rs.getString(3), rs.getString(4));
                        rebmDecisionSupplierFileMap.put(key, rs.getString(1));
                    }
                    return null;
                });
                this.dealDecisionConfirmBidFile(bosAttachmentProperties, rebmDecisonArray, rebmDecisionSupplierFileMap);
            }
        }
        catch (Exception e) {
            BizLog.log((String)("\u5904\u7406\u5b9a\u6807\u786e\u8ba4\u4e2d\u6807\u9644\u4ef6rebm_decision\uff1a" + e.getMessage()));
        }
    }

    public void dealDecisionConfirmBidFile(String bosAttachmentProperties, DynamicObject[] currentArray, HashMap<String, String> decisionSupplierFileMap) {
        DynamicObject[] bosAttachmentArray;
        if (!decisionSupplierFileMap.isEmpty() && (bosAttachmentArray = BusinessDataServiceHelper.load((String)"bos_attachment", (String)bosAttachmentProperties, (QFilter[])new QFilter[]{new QFilter("finterid", "in", decisionSupplierFileMap.values())})) != null && bosAttachmentArray.length > 0) {
            ArrayList<Object[]> paramList = new ArrayList<Object[]>();
            ArrayList<DynamicObject> saveAttachmentList = new ArrayList<DynamicObject>();
            Map<String, List<DynamicObject>> attachmentMap = Arrays.stream(bosAttachmentArray).collect(Collectors.groupingBy(t -> t.getString("finterid")));
            for (DynamicObject current : currentArray) {
                DynamicObject bidProject = current.getDynamicObject("bidproject");
                DynamicObjectCollection bidSectionCol = current.getDynamicObjectCollection("bidsection");
                for (DynamicObject bidSection : bidSectionCol) {
                    DynamicObjectCollection supplierEntryCol = bidSection.getDynamicObjectCollection("supplierentry");
                    for (DynamicObject supplierEntry : supplierEntryCol) {
                        String key;
                        String fileFid;
                        DynamicObject supplier = supplierEntry.getDynamicObject("supplier");
                        if (supplier == null || !StringUtils.isNotBlank((CharSequence)(fileFid = (String)decisionSupplierFileMap.getOrDefault(key = String.format("%s_%s_%s", bidProject.getString("billno"), bidSection.getString("sectionname"), supplier.getPkValue()), null)))) continue;
                        List attachmentList = attachmentMap.getOrDefault(fileFid, new ArrayList());
                        for (DynamicObject bosAttachment : attachmentList) {
                            DynamicObject newAttachment = this.copyBdAttachment(bosAttachment);
                            Object[] paramArr = new Object[]{ID.genLongId(), supplierEntry.getPkValue(), newAttachment.getLong("id")};
                            paramList.add(paramArr);
                            saveAttachmentList.add(newAttachment);
                        }
                    }
                }
            }
            if (paramList != null && paramList.size() > 0) {
                DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)DECISION_CONFIRMFILE_INSERT_SQL, paramList);
            }
            if (saveAttachmentList != null && saveAttachmentList.size() > 0) {
                try (TXHandle h = TX.requiresNew();){
                    try {
                        SaveServiceHelper.save((DynamicObject[])saveAttachmentList.toArray(new DynamicObject[0]));
                    }
                    catch (Throwable ex) {
                        h.markRollback();
                        this.log.error(ex);
                        throw ex;
                    }
                }
            }
        }
    }

    public void answer(String bosAttachmentProperties, int pageNum) {
        ArrayList answerEntryList = new ArrayList();
        DB.query((DBRoute)DBRoute.of((String)"scm"), (String)ANSWER_ENTRY_QUERY_SQL, rs -> {
            while (rs.next()) {
                answerEntryList.add(rs.getLong(1));
            }
            return null;
        });
        Map<Integer, List<?>> listMap = PageUtil.listPage(answerEntryList, pageNum);
        for (Map.Entry<Integer, List<?>> listData : listMap.entrySet()) {
            List<Object> currentList = listData.getValue();
            this.dealAnswerFile(bosAttachmentProperties, currentList);
        }
    }

    public void dealAnswerFile(String bosAttachmentProperties, List<Object> currentList) {
        if (currentList != null && currentList.size() > 0) {
            HashMap answerFileMap = new HashMap();
            SqlBuilder sb = new SqlBuilder();
            sb.append(ANSWER_FILE_QUERY_SQL, new Object[0]);
            sb.appendIn("fanswerid", currentList);
            DB.query((DBRoute)DBRoute.of((String)"scm"), (SqlBuilder)sb, rs -> {
                while (rs.next()) {
                    String key = String.format("%s_%s", rs.getString(3), rs.getString(2));
                    answerFileMap.put(key, rs.getString(1));
                }
                return null;
            });
            ArrayList<DynamicObject> saveAttachmentList = new ArrayList<DynamicObject>();
            ArrayList<Object[]> questionParamList = new ArrayList<Object[]>();
            ArrayList<Object[]> answerParamList = new ArrayList<Object[]>();
            HashMap<String, String> fileTypeMap = new HashMap<String, String>();
            for (Object answerEntry : currentList) {
                DynamicObject[] bosAttachmentArray;
                String answerFileKey;
                String answerFileFid;
                String questionFileKey = answerEntry + "_questionfile";
                String questionFileFid = (String)answerFileMap.get(questionFileKey);
                ArrayList<String> fInterIdList = new ArrayList<String>();
                if (StringUtils.isNotBlank((CharSequence)questionFileFid)) {
                    fInterIdList.add(questionFileFid);
                    fileTypeMap.put(questionFileFid, "questionfile");
                }
                if (StringUtils.isNotBlank((CharSequence)(answerFileFid = (String)answerFileMap.get(answerFileKey = answerEntry + "_answerfile")))) {
                    fInterIdList.add(answerFileFid);
                    fileTypeMap.put(answerFileFid, "answerfile");
                }
                if (fInterIdList == null || fInterIdList.size() <= 0 || (bosAttachmentArray = BusinessDataServiceHelper.load((String)"bos_attachment", (String)bosAttachmentProperties, (QFilter[])new QFilter[]{new QFilter("finterid", "in", fInterIdList)})) == null || bosAttachmentArray.length <= 0) continue;
                for (DynamicObject bosAttachment : bosAttachmentArray) {
                    String fInterid = bosAttachment.getString("finterid");
                    String fileType = fileTypeMap.getOrDefault(fInterid, null);
                    if (!StringUtils.isNotBlank((CharSequence)fileType)) continue;
                    DynamicObject newAttachment = this.copyBdAttachment(bosAttachment);
                    Object[] paramArr = new Object[]{ID.genLongId(), answerEntry, newAttachment.getLong("id")};
                    if ("questionfile".equals(fileType)) {
                        questionParamList.add(paramArr);
                    } else if ("answerfile".equals(fileType)) {
                        answerParamList.add(paramArr);
                    }
                    saveAttachmentList.add(newAttachment);
                }
            }
            if (questionParamList != null && questionParamList.size() > 0) {
                DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)ANSWER_QUESTION_INSERT_SQL, questionParamList);
            }
            if (answerParamList != null && answerParamList.size() > 0) {
                DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)ANSWER_FILE_INSERT_SQL, answerParamList);
            }
            if (saveAttachmentList != null && saveAttachmentList.size() > 0) {
                try (TXHandle h = TX.requiresNew();){
                    try {
                        SaveServiceHelper.save((DynamicObject[])saveAttachmentList.toArray(new DynamicObject[0]));
                    }
                    catch (Throwable ex) {
                        h.markRollback();
                        this.log.error(ex);
                        throw ex;
                    }
                }
            }
        }
    }

    public void questionClarifyData(String bosAttachmentProperties, int pageNum) {
        ArrayList detailIdList = new ArrayList();
        DB.query((DBRoute)DBRoute.of((String)"scm"), (String)MULTIQUESTCLARIFY_SUPPENTRY_QUERY_SQL, rs -> {
            while (rs.next()) {
                detailIdList.add(rs.getLong(1));
            }
            return null;
        });
        BizLog.log((String)("\u9644\u4ef6\u5347\u7ea7\uff1a\u8d28\u7591\u6f84\u6e05size\uff1a" + detailIdList.size()));
        Map<Integer, List<?>> listMap = PageUtil.listPage(detailIdList, pageNum);
        for (Map.Entry<Integer, List<?>> listData : listMap.entrySet()) {
            List<Object> currentList = listData.getValue();
            if (currentList == null || currentList.size() <= 0) continue;
            this.dealQuestionClarifyFile(bosAttachmentProperties, currentList);
        }
    }

    public void dealQuestionClarifyFile(String bosAttachmentProperties, List<Object> currentList) {
        if (currentList != null && currentList.size() > 0) {
            HashMap questionClarifyFileMap = new HashMap();
            SqlBuilder sb = new SqlBuilder();
            sb.append(MULTIQUESTCLARIFY_FILE_QUERY_SQL, new Object[0]);
            sb.appendIn("fmulticlarifyentryid", currentList);
            DB.query((DBRoute)DBRoute.of((String)"scm"), (SqlBuilder)sb, rs -> {
                while (rs.next()) {
                    questionClarifyFileMap.put(rs.getString(2), rs.getString(1));
                }
                return null;
            });
            ArrayList<Object[]> questionParamList = new ArrayList<Object[]>();
            ArrayList<DynamicObject> saveAttachmentList = new ArrayList<DynamicObject>();
            if (!questionClarifyFileMap.isEmpty()) {
                DynamicObject[] bosAttachmentArray = BusinessDataServiceHelper.load((String)"bos_attachment", (String)bosAttachmentProperties, (QFilter[])new QFilter[]{new QFilter("finterid", "in", questionClarifyFileMap.values())});
                Map<String, List<DynamicObject>> attachmentMap = Arrays.stream(bosAttachmentArray).collect(Collectors.groupingBy(t -> t.getString("finterid")));
                for (Object detailId : currentList) {
                    String fileFid = questionClarifyFileMap.getOrDefault(String.valueOf(detailId), null);
                    if (!StringUtils.isNotBlank((CharSequence)fileFid)) continue;
                    List attachmentList = attachmentMap.getOrDefault(fileFid, new ArrayList());
                    for (DynamicObject attachment : attachmentList) {
                        DynamicObject newAttachment = this.copyBdAttachment(attachment);
                        Object[] paramArr = new Object[]{ID.genLongId(), detailId, newAttachment.getLong("id")};
                        questionParamList.add(paramArr);
                        saveAttachmentList.add(newAttachment);
                    }
                }
            }
            if (questionParamList != null && questionParamList.size() > 0) {
                DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)MULTIQUESTCLARIFY_INSERT_QUERY_SQL_1, questionParamList);
                DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)MULTIQUESTCLARIFY_INSERT_QUERY_SQL_2, questionParamList);
            }
            if (saveAttachmentList != null && saveAttachmentList.size() > 0) {
                try (TXHandle h = TX.requiresNew();){
                    try {
                        SaveServiceHelper.save((DynamicObject[])saveAttachmentList.toArray(new DynamicObject[0]));
                    }
                    catch (Throwable ex) {
                        h.markRollback();
                        this.log.error(ex);
                        throw ex;
                    }
                }
            }
        }
    }

    public DynamicObject copyBdAttachment(DynamicObject attachment) {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)"bd_attachment");
        String fileName = attachment.getString("fattachmentname");
        String type = fileName != null ? fileName.substring(fileName.lastIndexOf(46) + 1) : "";
        Long id = ID.genLongId();
        DynamicObject newAttachment = new DynamicObject((DynamicObjectType)mainType);
        newAttachment.set("name", (Object)fileName);
        newAttachment.set("size", attachment.get("fattachmentsize"));
        newAttachment.set("url", (Object)attachment.getString("FFileId"));
        newAttachment.set("type", (Object)type);
        newAttachment.set("description", (Object)"");
        newAttachment.set("tempfile", (Object)"1");
        newAttachment.set("pageid", (Object)"");
        newAttachment.set("number", (Object)id.toString());
        newAttachment.set("status", (Object)"B");
        newAttachment.set("createtime", (Object)attachment.getDate("fcreatetime"));
        newAttachment.set("modifytime", (Object)attachment.getDate("fmodifytime"));
        newAttachment.set("creator", attachment.get("fcreatemen"));
        newAttachment.set("uid", (Object)id.toString());
        newAttachment.set("id", (Object)id);
        return newAttachment;
    }

    public String getTenAppId(String appId) {
        if ("bid".equals(appId)) {
            return "ten";
        }
        return "resp";
    }

    public void updateScheduleState(String billno, boolean isExcutFlag) {
        QFilter qFilter = new QFilter("billno", "=", (Object)billno);
        DynamicObject[] schedules = BusinessDataServiceHelper.load((String)"bid_scan_schedule", (String)"id", (QFilter[])new QFilter[]{qFilter});
        String format = this.getCurrentDate();
        if (schedules == null || schedules.length == 0) {
            BizLog.log((String)("BidFileHistoryDataUp has null billno = " + billno + ", Date = " + format));
            return;
        }
        DynamicObject loadSingle = BusinessDataServiceHelper.loadSingle((Object)schedules[0].getPkValue(), (String)"bid_scan_schedule");
        int excuteRouds = loadSingle.getInt("excuterouds") + 1;
        loadSingle.set("isexcutflag", (Object)isExcutFlag);
        loadSingle.set("executedate", (Object)new Date());
        loadSingle.set("excuterouds", (Object)excuteRouds);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{loadSingle});
    }

    public String getCurrentDate() {
        Date date = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String format = dateFormat.format(date);
        return format;
    }
}

