/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.business.schedule.untender;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.bid.common.enums.BidBackTypeEnum;
import kd.scm.bid.common.enums.MyTenderStatus;

public class BidUnTenderTask
extends AbstractTask {
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        try {
            BizLog.log((String)"\u5f03\u6807\u72b6\u6001\u66f4\u65b0\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb\u6267\u884c");
            this.dealData("rebm");
            this.dealData("bid");
            BizLog.log((String)"\u5f03\u6807\u72b6\u6001\u66f4\u65b0\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u7ed3\u675f");
        }
        catch (Exception e) {
            BizLog.log((String)("\u5f03\u6807\u72b6\u6001\u66f4\u65b0\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    public void dealData(String appId) {
        DynamicObject[] toUnTenderArr = this.getToUnTenderData(appId);
        HashSet<String> unTenderProjectSupplierSectionSet = new HashSet<String>();
        HashSet<Object> unTenderBidProjectIdList = new HashSet<Object>();
        if (toUnTenderArr != null && toUnTenderArr.length > 0) {
            for (DynamicObject myTender : toUnTenderArr) {
                DynamicObject supplier = myTender.getDynamicObject("supplier");
                DynamicObject bidProject = myTender.getDynamicObject("bidproject");
                if (supplier != null && bidProject != null) {
                    Object bidProjectId = bidProject.getPkValue();
                    Object supplierId = supplier.getPkValue();
                    for (DynamicObject myTenderEntry : myTender.getDynamicObjectCollection("entry")) {
                        if (myTenderEntry.getString("sectionstatus").equals(MyTenderStatus.UNINVITED.getValue())) continue;
                        myTenderEntry.set("sectionstatus", (Object)MyTenderStatus.UNTENDERED);
                        String sectionName = myTenderEntry.getString("sectionname");
                        String key = bidProjectId + "_" + sectionName + "_" + supplierId;
                        unTenderProjectSupplierSectionSet.add(key);
                        unTenderBidProjectIdList.add(bidProjectId);
                    }
                    continue;
                }
                BizLog.log((String)("\u903e\u671f\u672a\u6295\u6807\uff0c\u4f9b\u5e94\u5546\u4e3a\u7a7a\u6216\u8005\u7acb\u9879\u4e3a\u7a7a\uff1a" + myTender.getPkValue()));
            }
        }
        this.updateMyTenderStatus(toUnTenderArr);
        this.updateBidOpenUnTenderStatus(appId, unTenderProjectSupplierSectionSet, unTenderBidProjectIdList, true);
        DynamicObject[] toPreTenderArr = this.getToPreTenderData(appId);
        HashSet<String> preTenderProjectSupplierSectionSet = new HashSet<String>();
        HashSet<Object> preTenderBidProjectSet = new HashSet<Object>();
        if (toPreTenderArr != null && toPreTenderArr.length > 0) {
            for (DynamicObject myTender : toPreTenderArr) {
                DynamicObject supplier = myTender.getDynamicObject("supplier");
                if (supplier == null) continue;
                Object supplierId = supplier.getPkValue();
                for (DynamicObject myTenderEntry : myTender.getDynamicObjectCollection("entry")) {
                    if (!myTenderEntry.getString("sectionstatus").equals(MyTenderStatus.UNTENDERED.getValue()) || myTenderEntry.getBoolean("untenderflag")) continue;
                    myTenderEntry.set("sectionstatus", (Object)MyTenderStatus.PRETENDERED);
                    Object bidProjectId = myTender.getDynamicObject("bidproject").getPkValue();
                    String sectionName = myTenderEntry.getString("sectionname");
                    String key = bidProjectId + "_" + sectionName + "_" + supplierId;
                    preTenderProjectSupplierSectionSet.add(key);
                    preTenderBidProjectSet.add(bidProjectId);
                }
            }
        }
        this.updateMyTenderStatus(toPreTenderArr);
        this.updateBidOpenUnTenderStatus(appId, preTenderProjectSupplierSectionSet, preTenderBidProjectSet, false);
    }

    public DynamicObject[] getToUnTenderData(String appId) {
        String formId = "ten_mytender";
        if ("rebm".equals(appId)) {
            formId = "resp_mytender";
        }
        ArrayList<DynamicObject> resultList = new ArrayList<DynamicObject>();
        ArrayList<QFilter> toUnTenderQFilterList = new ArrayList<QFilter>();
        toUnTenderQFilterList.add(new QFilter("tenderstatus", "=", (Object)MyTenderStatus.PRETENDERED));
        toUnTenderQFilterList.add(new QFilter("entitytypeid", "=", (Object)formId));
        DynamicObject[] toUnTenderArr = BusinessDataServiceHelper.load((String)formId, (String)"id,supplier,backbidtype,bidproject,tenderstatus,entry.id,entry.sectionstatus,entry.sectionname", (QFilter[])toUnTenderQFilterList.toArray(new QFilter[0]));
        if (toUnTenderArr.length > 0) {
            Date date = new Date();
            for (DynamicObject myTender : toUnTenderArr) {
                String backBidType = myTender.getString("backbidtype");
                DynamicObject bidProject = myTender.getDynamicObject("bidproject");
                if (BidUnTenderTask.bidOpenFlag(bidProject)) continue;
                for (DynamicObject myTenderEntry : myTender.getDynamicObjectCollection("entry")) {
                    int compareTo;
                    Date backDeadLineDate = BidUnTenderTask.getBackDeadLineDate(backBidType, bidProject.getPkValue());
                    if (backDeadLineDate == null || (compareTo = date.compareTo(backDeadLineDate)) <= 0 || myTenderEntry.getString("sectionstatus").equals(MyTenderStatus.UNINVITED.getValue())) continue;
                    resultList.add(myTender);
                }
            }
        }
        if (!CollectionUtils.isEmpty(resultList)) {
            DynamicObject[] resultArray = new DynamicObject[resultList.size()];
            resultList.toArray(resultArray);
            return resultArray;
        }
        return null;
    }

    public static boolean bidOpenFlag(DynamicObject bidProject) {
        QFilter qFilter = new QFilter("bidproject", "=", bidProject.getPkValue());
        qFilter.and(new QFilter("billstatus", "=", (Object)"O"));
        return QueryServiceHelper.exists((String)"bid_bidopen", (QFilter[])qFilter.toArray());
    }

    public void updateBidOpenUnTenderStatus(String appId, Set<String> projectSupplierSectionSet, Set<Object> bidProjectIdList, boolean flag) {
        String selectBidOpenProperties = "id,billstatus,bidproject,bidsection,bidsection.sectionname,supplierentry,supplierentry.supplier, supplierentry.supplier_isinvalid,supplierentry.untenderflag,supplierentry.untendertype,supplierentry.untenderreason, supplierentry.untenderfile";
        DynamicObject[] bidOpenArray = BusinessDataServiceHelper.load((String)(appId + "_bidopen"), (String)selectBidOpenProperties, (QFilter[])new QFilter[]{new QFilter("bidproject", "in", bidProjectIdList), new QFilter("billstatus", "not in", (Object)new String[]{"X", "XX"})});
        if (bidOpenArray != null && bidOpenArray.length > 0) {
            BizLog.log((String)"\u903e\u671f\u672a\u6295\u6807\uff0c\u5f00\u59cb\u66f4\u65b0\u5f00\u6807\u8868\u5355\u4e0a\u7684\u5f03\u6807\u72b6\u6001");
            for (DynamicObject bidOpen : bidOpenArray) {
                Object bidProjectId = bidOpen.getDynamicObject("bidproject").getPkValue();
                String billStatus = bidOpen.getString("billstatus");
                DynamicObjectCollection bidSectionColl = bidOpen.getDynamicObjectCollection("bidsection");
                for (DynamicObject bidSection : bidSectionColl) {
                    String sectionName = bidSection.getString("sectionname");
                    DynamicObjectCollection supplierEntryCollection = bidSection.getDynamicObjectCollection("supplierentry");
                    for (DynamicObject supplierEntry : supplierEntryCollection) {
                        Object supplierId = supplierEntry.getDynamicObject("supplier").getPkValue();
                        Boolean supplierInvalidFlag = supplierEntry.getBoolean("supplier_isinvalid");
                        String unTenderType = supplierEntry.getString("untendertype");
                        String key = bidProjectId + "_" + sectionName + "_" + supplierId;
                        if (!projectSupplierSectionSet.contains(key) || supplierInvalidFlag.booleanValue()) continue;
                        if (flag) {
                            BizLog.log((String)("\u903e\u671f\u672a\u6295\u6807\uff0c\u66f4\u65b0\u5f00\u6807\u8868\u5355id\uff1a" + bidOpen.getPkValue() + " \u6807\u6bb5\u540d\u79f0\uff1a" + sectionName + " \u4f9b\u5e94\u5546id\uff1a" + supplierId));
                            supplierEntry.set("untendertype", (Object)"1");
                            supplierEntry.set("untenderflag", (Object)Boolean.TRUE);
                            supplierEntry.getDynamicObjectCollection("supplier_techattach").clear();
                            supplierEntry.getDynamicObjectCollection("supplier_comattach").clear();
                            supplierEntry.getDynamicObjectCollection("supplier_tenattach").clear();
                            supplierEntry.getDynamicObjectCollection("supplier_otherattach").clear();
                            supplierEntry.set("untenderreason", (Object)ResManager.loadKDString((String)"\u903e\u671f\u672a\u6295\u6807", (String)"BidUnTenderTask_0", (String)"scm-bid-business", (Object[])new Object[0]));
                            continue;
                        }
                        if (!"1".equals(unTenderType)) continue;
                        BizLog.log((String)("\u66f4\u65b0\u5f03\u6807\u4fe1\u606f\uff0c\u66f4\u65b0\u5f00\u6807\u8868\u5355id\uff1a" + bidOpen.getPkValue() + " \u6807\u6bb5\u540d\u79f0\uff1a" + sectionName + " \u4f9b\u5e94\u5546id\uff1a" + supplierId));
                        supplierEntry.set("untendertype", null);
                        supplierEntry.set("untenderflag", (Object)Boolean.FALSE);
                        supplierEntry.set("untenderreason", null);
                    }
                }
            }
            SaveServiceHelper.save((DynamicObject[])bidOpenArray);
        }
    }

    public DynamicObject[] getToPreTenderData(String appId) {
        String formId = "ten_mytender";
        if ("rebm".equals(appId)) {
            formId = "resp_mytender";
        }
        ArrayList<DynamicObject> resultList = new ArrayList<DynamicObject>();
        ArrayList<QFilter> toPreTenderQFilterList = new ArrayList<QFilter>();
        toPreTenderQFilterList.add(new QFilter("tenderstatus", "=", (Object)MyTenderStatus.UNTENDERED));
        DynamicObject[] toUnTenderArr = BusinessDataServiceHelper.load((String)formId, (String)"id,supplier,backbidtype,bidproject,tenderstatus,entry.id,entry.sectionstatus,entry.sectionname,entry.untenderflag", (QFilter[])toPreTenderQFilterList.toArray(new QFilter[0]));
        if (toUnTenderArr.length > 0) {
            Date date = new Date();
            for (DynamicObject myTender : toUnTenderArr) {
                String backBidType = myTender.getString("backbidtype");
                DynamicObject bidProject = myTender.getDynamicObject("bidproject");
                if (BidUnTenderTask.bidOpenFlag(bidProject) || bidProject == null) continue;
                Date backDeadLineDate = BidUnTenderTask.getBackDeadLineDate(backBidType, bidProject.getPkValue());
                if (backDeadLineDate != null) {
                    int compareTo = date.compareTo(backDeadLineDate);
                    if (compareTo >= 0) continue;
                    resultList.add(myTender);
                    continue;
                }
                QFilter qFilter = new QFilter("bidproject", "=", bidProject.getPkValue());
                qFilter.and(new QFilter("billstatus", "=", (Object)"O"));
                boolean isHasOpen = QueryServiceHelper.exists((String)"bid_bidopen", (QFilter[])qFilter.toArray());
                if (isHasOpen) continue;
                resultList.add(myTender);
            }
        }
        if (!CollectionUtils.isEmpty(resultList)) {
            DynamicObject[] resultArray = new DynamicObject[resultList.size()];
            resultList.toArray(resultArray);
            return resultArray;
        }
        return null;
    }

    public static Date getBackDeadLineDate(String backBidType, Object projectId) {
        DynamicObject bidProject = BusinessDataServiceHelper.loadSingle((Object)projectId, (String)"bid_project", (String)"bidopendeadline,techbackbidtime,busbackbidtime");
        if (BidBackTypeEnum.TECHANDBUSS.getValue().equals(backBidType)) {
            return bidProject.getDate("bidopendeadline");
        }
        if (BidBackTypeEnum.TECHNICAL.getValue().equals(backBidType)) {
            return bidProject.getDate("techbackbidtime");
        }
        return BidBackTypeEnum.BUSSINESS.getValue().equals(backBidType) ? bidProject.getDate("busbackbidtime") : null;
    }

    public void updateMyTenderStatus(DynamicObject[] toUpdateMyTenderArray) {
        if (toUpdateMyTenderArray != null && toUpdateMyTenderArray.length > 0) {
            ArrayList<String> sectionStatusList = new ArrayList<String>(20);
            for (DynamicObject myTender : toUpdateMyTenderArray) {
                DynamicObjectCollection myTenderSectionEntryCol = myTender.getDynamicObjectCollection("entry");
                sectionStatusList.clear();
                for (DynamicObject myTenderSectionEntry : myTenderSectionEntryCol) {
                    String sectionStatus = myTenderSectionEntry.getString("sectionstatus");
                    sectionStatusList.add(sectionStatus);
                }
                if (sectionStatusList.contains(MyTenderStatus.PRETENDERED.getValue())) {
                    myTender.set("tenderstatus", (Object)MyTenderStatus.PRETENDERED);
                    continue;
                }
                if (!sectionStatusList.contains(MyTenderStatus.PRETENDERED.getValue()) && sectionStatusList.contains(MyTenderStatus.TENDERED.getValue())) {
                    myTender.set("tenderstatus", (Object)MyTenderStatus.TENDERED);
                    continue;
                }
                myTender.set("tenderstatus", (Object)MyTenderStatus.UNTENDERED);
            }
            SaveServiceHelper.save((DynamicObject[])toUpdateMyTenderArray);
        }
    }
}

