/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.bid.business.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeView;
import kd.bos.list.ITreeListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.bid.business.util.BidUtils;
import kd.scm.bid.business.util.OrgViewUtils;

public class OrgTreeUtils {
    public static final String CACHE_KEY_LONGNUMBER = "_longNumberCacheKey";
    public static final String CACHE_KEY_SEARCH_NODES = "_searchNodes";
    public static final String CACHE_KEY_OLD_SEARCH_TEXT = "_oldSearchText";
    public static final String CACHE_KEY_PARENTID = "_parentIdCacheKey";

    public static String getOrgNameByNodeId(long nodeId) {
        String selectFields = "id,name";
        QFilter idFilter = new QFilter("id", "=", (Object)nodeId);
        QFilter[] filters = new QFilter[]{idFilter};
        DynamicObjectCollection orgCol = QueryServiceHelper.query((String)"bos_org", (String)selectFields, (QFilter[])filters);
        if (BidUtils.isListEmpty((List)orgCol)) {
            return ResManager.loadKDString((String)"\u5168\u90e8", (String)"OrgTreeUtils_0", (String)"scm-bid-business", (Object[])new Object[0]);
        }
        return ((DynamicObject)orgCol.get(0)).getString("name");
    }

    public static TreeNode genRootNodeByNodeId(String nodeId, String orgViewType) {
        String selectFields = "id,org.name name,longnumber";
        QFilter idFilter = new QFilter("org", "=", (Object)Long.parseLong(nodeId));
        QFilter viewFilter = OrgViewUtils.getOrgViewFilter(orgViewType);
        QFilter[] filters = new QFilter[]{idFilter, viewFilter};
        DynamicObjectCollection orgCol = QueryServiceHelper.query((String)"bos_org_structure", (String)selectFields, (QFilter[])filters);
        if (BidUtils.isListEmpty((List)orgCol)) {
            LocaleString text = new LocaleString(ResManager.loadKDString((String)"\u5168\u90e8", (String)"OrgTreeUtils_0", (String)"scm-bid-business", (Object[])new Object[0]));
            return new TreeNode("", nodeId, text.getLocaleValue());
        }
        DynamicObject org = (DynamicObject)orgCol.get(0);
        TreeNode root = new TreeNode("", nodeId, org.getString("name"));
        root.setLongNumber(org.getString("longnumber"));
        root.setIsOpened(true);
        return root;
    }

    public static TreeNode queryRootNode(String parentId, String orgViewType) {
        TreeNode root = null;
        List<TreeNode> rootNodeList = OrgTreeUtils.queryChildNodes(parentId, orgViewType, null, "level");
        if (BidUtils.isListNotEmpty(rootNodeList)) {
            root = rootNodeList.get(0);
            root.setParentid("");
            root.setIsOpened(true);
        } else {
            LocaleString text = new LocaleString(ResManager.loadKDString((String)"\u5168\u90e8", (String)"OrgTreeUtils_0", (String)"scm-bid-business", (Object[])new Object[0]));
            root = new TreeNode("", "-1", text.getLocaleValue());
        }
        return root;
    }

    public static List<TreeNode> queryChildNodes(String parentId, String orgViewType, QFilter otherFilter, String orderBy) {
        ArrayList<TreeNode> childNodes = new ArrayList<TreeNode>();
        DynamicObjectCollection subOrgCol = OrgTreeUtils.getSubOrgByParentId(parentId, orgViewType, otherFilter, orderBy, false);
        if (BidUtils.isListEmpty((List)subOrgCol)) {
            return childNodes;
        }
        for (DynamicObject orgObj : subOrgCol) {
            childNodes.add(OrgTreeUtils.genTreeNode(orgObj));
        }
        return childNodes;
    }

    public static List<TreeNode> queryChildNodes(String parentId, String orgViewType, QFilter otherFilter, String orderBy, TreeNode parentNode) {
        ArrayList<TreeNode> childNodes = new ArrayList<TreeNode>();
        DynamicObjectCollection subOrgCol = OrgTreeUtils.getSubOrgByParentId(parentId, orgViewType, otherFilter, orderBy, true);
        if (BidUtils.isListEmpty((List)subOrgCol)) {
            return childNodes;
        }
        for (DynamicObject orgObj : subOrgCol) {
            if (parentNode != null && parentId.equals(orgObj.getString("org"))) {
                OrgTreeUtils.genTreeNode(orgObj, parentNode);
                continue;
            }
            childNodes.add(OrgTreeUtils.genTreeNode(orgObj));
        }
        return childNodes;
    }

    public static DynamicObjectCollection getSubOrgByParentId(String parentId, String orgViewType, QFilter otherFilter, String orderBy, boolean isIncludeCur) {
        long parentOrgId = 0L;
        if (StringUtils.isNotBlank((CharSequence)parentId)) {
            parentOrgId = Long.parseLong(parentId);
        }
        String selectFields = "id,org.id org,org.name name,parent.id parent,longNumber,isleaf,isfreeze";
        QFilter parentFilter = new QFilter("parent", "=", (Object)parentOrgId);
        if (isIncludeCur) {
            QFilter orgFilter = new QFilter("org", "=", (Object)parentOrgId);
            parentFilter = parentFilter.or(orgFilter);
        }
        QFilter viewFilter = OrgViewUtils.getOrgViewFilter(orgViewType);
        QFilter[] filters = new QFilter[]{parentFilter, viewFilter, otherFilter};
        if (StringUtils.isBlank((CharSequence)orderBy)) {
            orderBy = "level,longNumber";
        }
        DynamicObjectCollection subOrgCol = QueryServiceHelper.query((String)"bos_org_structure", (String)selectFields, (QFilter[])filters, (String)orderBy);
        return subOrgCol;
    }

    private static TreeNode genTreeNode(DynamicObject orgObj) {
        TreeNode node = new TreeNode();
        OrgTreeUtils.genTreeNode(orgObj, node);
        return node;
    }

    private static void genTreeNode(DynamicObject orgObj, TreeNode node) {
        node.setId(orgObj.getString("org"));
        String name = orgObj.getString("name");
        if (orgObj.getBoolean("isfreeze")) {
            name = String.format(ResManager.loadKDString((String)"%s(\u5c01\u5b58)", (String)"OrgTreeUtils_1", (String)"scm-bid-business", (Object[])new Object[0]), name);
        }
        node.setText(name);
        String parentId = orgObj.getString("parent");
        if ("0".equals(parentId)) {
            parentId = "";
        }
        node.setParentid(parentId);
        node.setLongNumber(orgObj.getString("longnumber"));
        if (!orgObj.getBoolean("isleaf")) {
            node.setChildren(new ArrayList());
        }
    }

    public static void searchTreeNode(String searchText, IFormView formView, ITreeListView treeListView, String orgViewType, boolean isOrgId) {
        if (StringUtils.isBlank((CharSequence)searchText) || formView == null || treeListView == null) {
            return;
        }
        OrgTreeUtils.searchTreeNode(searchText, formView, treeListView.getTreeView(), treeListView.getTreeModel(), orgViewType, isOrgId);
    }

    public static void searchTreeNode(String searchText, IFormView formView, TreeView treeView, ITreeModel treeModel, String orgViewType, boolean isOrgId) {
        if (StringUtils.isBlank((CharSequence)searchText) || formView == null || treeView == null) {
            return;
        }
        Map<String, String> longNumMap = new HashMap<String, String>();
        List<Object> treeNodes = new ArrayList<TreeNode>();
        IPageCache pageCache = (IPageCache)formView.getService(IPageCache.class);
        String longNumberCacheKey = formView.getPageId() + CACHE_KEY_LONGNUMBER;
        String searchNodesCacheKey = formView.getPageId() + CACHE_KEY_SEARCH_NODES;
        String oldSearchTextCacheKey = formView.getPageId() + CACHE_KEY_OLD_SEARCH_TEXT;
        String parentIdCacheKey = formView.getPageId() + CACHE_KEY_PARENTID;
        String oldSearchText = pageCache.get(oldSearchTextCacheKey);
        pageCache.put(oldSearchTextCacheKey, searchText);
        if (searchText.equals(oldSearchText)) {
            String searchNodesCache = pageCache.get(searchNodesCacheKey);
            if (StringUtils.isNotBlank((CharSequence)searchNodesCache)) {
                treeNodes = SerializationUtils.fromJsonStringToList((String)searchNodesCache, TreeNode.class);
                String longNumCache = pageCache.get(longNumberCacheKey);
                longNumMap = StringUtils.isBlank((CharSequence)longNumCache) ? new HashMap() : (Map)SerializationUtils.fromJsonString((String)longNumCache, Map.class);
            }
            if (BidUtils.isListEmpty(treeNodes)) {
                pageCache.put(searchNodesCacheKey, "");
                if (!isOrgId) {
                    formView.showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u641c\u7d22\u3002", (String)"OrgTreeUtils_3", (String)"scm-bid-business", (Object[])new Object[0]));
                    return;
                }
            }
        } else {
            OrgTreeUtils.searchTreeNode(searchText, treeNodes, orgViewType, isOrgId, longNumMap);
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString(treeNodes));
            pageCache.put(longNumberCacheKey, SerializationUtils.toJsonString(longNumMap));
        }
        if (BidUtils.isListNotEmpty(treeNodes)) {
            TreeNode node;
            String parentIdCache = pageCache.get(parentIdCacheKey);
            ArrayList<String> parentIds = null;
            if (StringUtils.isNotBlank((CharSequence)parentIdCache)) {
                parentIds = (ArrayList<String>)SerializationUtils.fromJsonString((String)parentIdCache, List.class);
            }
            if (parentIds == null) {
                parentIds = new ArrayList<String>();
            }
            if (parentIds.contains((node = (TreeNode)treeNodes.get(0)).getParentid())) {
                treeView.focusNode(node);
            } else {
                OrgTreeUtils.queryTreeNodeWithParent(formView, treeView, treeModel, longNumMap, node, parentIds);
                pageCache.put(parentIdCacheKey, SerializationUtils.toJsonString(parentIds));
            }
            if (!isOrgId) {
                treeNodes.remove(0);
                pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString(treeNodes));
            }
        }
    }

    private static void searchTreeNode(String searchText, List<TreeNode> treeNodes, String orgViewType, boolean isOrgId, Map<String, String> longNumMap) {
        String selectFields = "id,org,org.name name,parent,longnumber";
        QFilter viewFilter = OrgViewUtils.getOrgViewFilter(orgViewType);
        if (isOrgId) {
            QFilter idFilter = new QFilter("org", "=", (Object)searchText);
            viewFilter = viewFilter.and(idFilter);
        } else {
            QFilter nameFilter = new QFilter("org.name", "like", (Object)("%" + searchText + "%"));
            QFilter enableFilter = new QFilter("org.enable", "=", (Object)Boolean.TRUE);
            QFilter freezeFilter = new QFilter("isfreeze", "=", (Object)Boolean.FALSE);
            viewFilter = viewFilter.and(nameFilter).and(enableFilter).and(freezeFilter);
        }
        QFilter[] filters = new QFilter[]{viewFilter};
        DynamicObjectCollection orgCol = QueryServiceHelper.query((String)"bos_org_structure", (String)selectFields, (QFilter[])filters, (String)"longnumber");
        if (BidUtils.isListEmpty((List)orgCol)) {
            return;
        }
        for (DynamicObject org : orgCol) {
            String orgId = org.getString("org");
            TreeNode treeNode = new TreeNode(org.getString("parent"), orgId, org.getString("name"));
            treeNode.setExpend(true);
            treeNodes.add(treeNode);
            longNumMap.put(orgId, org.getString("longnumber"));
        }
    }

    private static void queryTreeNodeWithParent(IFormView formView, TreeView treeView, ITreeModel treeModel, Map<String, String> longNumMap, TreeNode node, List<String> parentIds) {
        String nodeId = node.getId();
        String longNumber = longNumMap.get(nodeId);
        ArrayList<String> longNumList = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)longNumber)) {
            longNumList.add(longNumber);
        }
        OrgTreeUtils.getParentLongNumber(longNumber, longNumList);
        String selectFields = "id,org,org.name name,parent,longnumber";
        QFilter longNumberFilter = new QFilter("longnumber", "in", longNumList);
        QFilter enableFilter = new QFilter("org.enable", "=", (Object)Boolean.TRUE);
        QFilter freezeFilter = new QFilter("isfreeze", "=", (Object)Boolean.FALSE);
        QFilter viewFilter = OrgViewUtils.getOrgViewFilter("15");
        QFilter[] filters = new QFilter[]{longNumberFilter, enableFilter, freezeFilter, viewFilter};
        DynamicObjectCollection orgCol = QueryServiceHelper.query((String)"bos_org_structure", (String)selectFields, (QFilter[])filters, (String)"longnumber");
        if (BidUtils.isListEmpty((List)orgCol)) {
            return;
        }
        for (DynamicObject org : orgCol) {
            String parentId = org.getString("parent");
            String orgId = org.getString("org");
            if (parentIds.contains(orgId)) continue;
            parentIds.add(parentId);
            if (treeModel == null) {
                treeView.treeNodeClick(parentId, orgId);
                continue;
            }
            if (OrgTreeUtils.getNode(orgId, treeModel) == null) continue;
            treeView.queryTreeNodeChildren(parentId, orgId);
        }
        treeView.focusNode(node);
    }

    public static TreeNode getNode(Object nodeId, ITreeModel treeModel) {
        if (treeModel == null) {
            return null;
        }
        TreeNode rootNode = treeModel.getRoot();
        if (rootNode == null || nodeId == null) {
            return null;
        }
        return rootNode.getTreeNode(nodeId.toString(), 20);
    }

    private static void getParentLongNumber(String longNumber, List<String> longNumList) {
        if (StringUtils.isBlank((CharSequence)longNumber) || longNumber.indexOf(33) == -1) {
            return;
        }
        String parentLongNumber = StringUtils.substringBeforeLast((String)longNumber, (String)"!");
        longNumList.add(parentLongNumber);
        OrgTreeUtils.getParentLongNumber(parentLongNumber, longNumList);
    }
}

